import{s as mt,a as pt,n as Mt,o as ct}from"../chunks/scheduler.35aab934.js";import{S as yt,i as ut,e as i,s as a,c as m,h as dt,a as o,d as s,b as l,f as ot,g as p,j as r,k as K,l as Ut,m as n,n as M,t as c,o as y,p as u}from"../chunks/index.de17b971.js";import{C as ht}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as rt}from"../chunks/CodeBlock.c1f62de5.js";import{H as d,E as wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function ft(Ee){let U,te,D,se,w,ne,f,ae,h,Fe,le,J,ie,g,Ne="OneFormer is a groundbreaking approach to image segmentation, a computer vision task that involves dividing an image into meaningful segments. Traditional methods used separate models and architectures for different segmentation tasks, like identifying objects (instance segmentation) or labeling regions (semantic segmentation). More recent attempts aimed to unify these tasks using shared architectures but still required separate training for each task.",oe,T,Qe="Enter OneFormer, a universal image segmentation framework designed to overcome these challenges. It introduces a unique multi-task approach, allowing a single model to handle semantic, instance, and panoptic segmentation tasks without the need for separate training on each. The key innovation lies in a task-conditioned joint training strategy, where the model is guided by a task input, making it dynamic and adaptive to different tasks during both training and inference.",re,j,Xe="This breakthrough not only simplifies the training process but also outperforms existing models across various datasets. OneFormer achieves this by using panoptic annotations, unifying the ground truth information needed for all tasks. Additionally, the framework introduces query-text contrastive learning to better distinguish between tasks and improve overall performance.",me,C,pe,I,ze='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer.svg" alt="Oneformer Method"/> <em>Image taken from OneFormer paper</em>',Me,b,He="To understand OneFormer’s significance, let’s look into the background of image segmentation. In image processing, segmentation involves dividing an image into different parts, which is crucial for tasks like recognizing objects and understanding the content of a scene. Traditionally, two main types of segmentation tasks were semantic segmentation, where pixels are labeled with categories like “road” or “sky,” and instance segmentation, which identifies objects with well-defined boundaries.",ce,k,Ve="Over time, researchers proposed panoptic segmentation as a way to unify semantic and instance segmentation tasks. However, even with these advancements, there were challenges. Existing models designed for panoptic segmentation still required separate training for each task, making them semi-universal at best.",ye,v,qe="This is where OneFormer comes in as a game-changer. It introduces a novel approach – a multi-task universal architecture. The idea is to train this framework only once, using a single universal architecture, a lone model, and just one dataset. The magic happens as OneFormer outperforms specialized frameworks across semantic, instance, and panoptic segmentation tasks. This breakthrough is not just about improving accuracy; it’s about making image segmentation more universal and efficient. With OneFormer, the need for extensive resources and separate training for different tasks becomes a thing of the past.",ue,B,de,Z,Ye='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/text_gen.svg" alt="Task Conditioned Joint Training"/>',Ue,W,Oe="Now, let’s break down the key features of OneFormer that make it stand out:",he,A,we,x,Le="OneFormer uses a clever trick called “Task-Dynamic Mask” to better understand and tackle different types of image segmentation tasks. So, when the model encounters an image, it uses this “Task-Dynamic Mask” to decide whether to pay attention to the overall scene, identify specific objects with clear boundaries, or do a combination of both.",fe,$,Je,R,Pe="One of the groundbreaking features of OneFormer is its task-conditioned joint training strategy. Instead of training separately for semantic, instance, and panoptic segmentation, OneFormer uniformly samples the task during training. This strategy enables the model to learn and generalize across different segmentation tasks simultaneously. By conditioning the architecture on the specific task through the task token, OneFormer unifies the training process, reducing the need for task-specific architectures, models, and datasets. This innovative approach significantly streamlines the training pipeline and resource requirements.",ge,_,Te,G,Ke="Lastly, let’s talk about “Query-Text Contrastive Loss.” Think of it as a way for OneFormer to teach itself about the differences between tasks and classes. In the training process, the model compares the features it extracts from the image (queries) with the corresponding text descriptions (like “a photo with a car”). This helps the model understand the unique characteristics of each task and reduces confusion between different classes. OneFormer’s “Task-Dynamic Mask” allows it to be versatile like a multitasking assistant, and the “Query-Text Contrastive Loss” helps it learn the specifics of each task by comparing visual features with textual descriptions.",je,S,De="By combining these core concepts, OneFormer becomes a smart and efficient tool for image segmentation, making the process more universal and accessible.",Ce,E,Ie,F,et='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/plots.svg" alt="result comperison"/> <em>Image taken from OneFormer paper</em>',be,N,tt="In conclusion, the OneFormer framework represents a groundbreaking approach in the field of image segmentation, aiming to simplify and unify the task across various domains. Unlike traditional methods that rely on specialized architectures for each segmentation task, OneFormer introduces a novel multi-task universal architecture that requires only a single model, trained once on a universal dataset, to outperform existing frameworks. Additionally, the incorporation of query-text contrastive loss during training enhances the model’s ability to learn inter-task and inter-class differences. OneFormer utilizes transformer-based architectures, inspired by recent successes in computer vision, and introduces task-guided queries to improve task sensitivity. The results are impressive, as OneFormer surpasses state-of-the-art models across semantic, instance, and panoptic segmentation tasks on benchmark datasets like ADE20k, Cityscapes, and COCO. The framework’s performance is further enhanced with new ConvNeXt and DiNAT backbones.",ke,Q,st="In summary, OneFormer represents a significant step towards universal and accessible image segmentation. By introducing a single model capable of handling diverse segmentation tasks, the framework streamlines the segmentation process and reduces resource requirements.",ve,X,Be,z,nt="Let’s see an example use of the model. Dinat backbone requires Natten library, which may take a while to install.",Ze,H,We,V,at="We can see an inference code below depending on different segmentation types.",Ae,q,xe,Y,lt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/oneformer_semantic.png" alt="semantic segmentation"/>',$e,O,Re,L,it='<li><a href="https://arxiv.org/pdf/2211.06220.pdf" rel="nofollow">OneFormer Paper</a></li> <li><a href="https://huggingface.co/shi-labs/oneformer_ade20k_dinat_large" rel="nofollow">HuggingFace OneFormer model</a></li>',_e,P,Ge,ee,Se;return w=new ht({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new d({props:{title:"OneFormer: One Transformer to Rule Universal Image Segmentation",local:"oneformer-one-transformer-to-rule-universal-image-segmentation",headingTag:"h1"}}),J=new d({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),C=new d({props:{title:"Background of OneFormer",local:"background-of-oneformer",headingTag:"h2"}}),B=new d({props:{title:"Core Concepts of OneFormer",local:"core-concepts-of-oneformer",headingTag:"h2"}}),A=new d({props:{title:"Task-Dynamic Mask",local:"task-dynamic-mask",headingTag:"h3"}}),$=new d({props:{title:"Task-Conditioned Joint Training",local:"task-conditioned-joint-training",headingTag:"h3"}}),_=new d({props:{title:"Query-Text Contrastive Loss",local:"query-text-contrastive-loss",headingTag:"h3"}}),E=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),X=new d({props:{title:"Example use of model",local:"example-use-of-model",headingTag:"h2"}}),H=new rt({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMG5hdHRlbiUyMA==",highlighted:"!pip install -q natten ",wrap:!1}}),q=new rt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_segmentation</span>(<span class="hljs-params">image, task_type</span>):
    <span class="hljs-string">&quot;&quot;&quot;Performs image segmentation based on the given task type.

    Args:
        image (PIL.Image): The input image.
        task_type (str): The type of segmentation to perform (&#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;).

    Returns:
        PIL.Image: The segmented image.

    Raises:
        ValueError: If the task type is invalid.
    &quot;&quot;&quot;</span>

    processor = OneFormerProcessor.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )  <span class="hljs-comment"># Load once here</span>
    model = OneFormerForUniversalSegmentation.from_pretrained(
        <span class="hljs-string">&quot;shi-labs/oneformer_ade20k_dinat_large&quot;</span>
    )

    <span class="hljs-keyword">if</span> task_type == <span class="hljs-string">&quot;semantic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_semantic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;instance&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_instance_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">elif</span> task_type == <span class="hljs-string">&quot;panoptic&quot;</span>:
        inputs = processor(images=image, task_inputs=[<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model(**inputs)
        predicted_map = processor.post_process_panoptic_segmentation(
            outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
        )[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]

    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">raise</span> ValueError(
            <span class="hljs-string">&quot;Invalid task type. Choose from &#x27;semantic&#x27;, &#x27;instance&#x27;, or &#x27;panoptic&#x27;&quot;</span>
        )

    <span class="hljs-keyword">return</span> predicted_map


<span class="hljs-keyword">def</span> <span class="hljs-title function_">show_image_comparison</span>(<span class="hljs-params">image, predicted_map, segmentation_title</span>):
    <span class="hljs-string">&quot;&quot;&quot;Displays the original image and the segmented image side-by-side.

    Args:
        image (PIL.Image): The original image.
        predicted_map (PIL.Image): The segmented image.
        segmentation_title (str): The title for the segmented image.
    &quot;&quot;&quot;</span>

    plt.figure(figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">6</span>))
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">1</span>)
    plt.imshow(image)
    plt.title(<span class="hljs-string">&quot;Original Image&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)
    plt.imshow(predicted_map)
    plt.title(segmentation_title + <span class="hljs-string">&quot; Segmentation&quot;</span>)
    plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
    plt.show()


url = <span class="hljs-string">&quot;https://huggingface.co/datasets/shi-labs/oneformer_demo/resolve/main/ade20k.jpeg&quot;</span>
response = requests.get(url, stream=<span class="hljs-literal">True</span>)
response.raise_for_status()  <span class="hljs-comment"># Check for HTTP errors</span>
image = Image.<span class="hljs-built_in">open</span>(response.raw)

task_to_run = <span class="hljs-string">&quot;semantic&quot;</span>
predicted_map = run_segmentation(image, task_to_run)
show_image_comparison(image, predicted_map, task_to_run)`,wrap:!1}}),O=new d({props:{title:"References",local:"references",headingTag:"h2"}}),P=new wt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/oneformer.mdx"}}),{c(){U=i("meta"),te=a(),D=i("p"),se=a(),m(w.$$.fragment),ne=a(),m(f.$$.fragment),ae=a(),h=i("img"),le=a(),m(J.$$.fragment),ie=a(),g=i("p"),g.textContent=Ne,oe=a(),T=i("p"),T.textContent=Qe,re=a(),j=i("p"),j.textContent=Xe,me=a(),m(C.$$.fragment),pe=a(),I=i("p"),I.innerHTML=ze,Me=a(),b=i("p"),b.textContent=He,ce=a(),k=i("p"),k.textContent=Ve,ye=a(),v=i("p"),v.textContent=qe,ue=a(),m(B.$$.fragment),de=a(),Z=i("p"),Z.innerHTML=Ye,Ue=a(),W=i("p"),W.textContent=Oe,he=a(),m(A.$$.fragment),we=a(),x=i("p"),x.textContent=Le,fe=a(),m($.$$.fragment),Je=a(),R=i("p"),R.textContent=Pe,ge=a(),m(_.$$.fragment),Te=a(),G=i("p"),G.textContent=Ke,je=a(),S=i("p"),S.textContent=De,Ce=a(),m(E.$$.fragment),Ie=a(),F=i("p"),F.innerHTML=et,be=a(),N=i("p"),N.textContent=tt,ke=a(),Q=i("p"),Q.textContent=st,ve=a(),m(X.$$.fragment),Be=a(),z=i("p"),z.textContent=nt,Ze=a(),m(H.$$.fragment),We=a(),V=i("p"),V.textContent=at,Ae=a(),m(q.$$.fragment),xe=a(),Y=i("p"),Y.innerHTML=lt,$e=a(),m(O.$$.fragment),Re=a(),L=i("ul"),L.innerHTML=it,_e=a(),m(P.$$.fragment),Ge=a(),ee=i("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);U=o(t,"META",{name:!0,content:!0}),t.forEach(s),te=l(e),D=o(e,"P",{}),ot(D).forEach(s),se=l(e),p(w.$$.fragment,e),ne=l(e),p(f.$$.fragment,e),ae=l(e),h=o(e,"IMG",{align:!0,width:!0,height:!0,src:!0}),le=l(e),p(J.$$.fragment,e),ie=l(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1hf6o1y"&&(g.textContent=Ne),oe=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ty30hf"&&(T.textContent=Qe),re=l(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1lma2v6"&&(j.textContent=Xe),me=l(e),p(C.$$.fragment,e),pe=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-10j1l9u"&&(I.innerHTML=ze),Me=l(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ucc15p"&&(b.textContent=He),ce=l(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-n6259b"&&(k.textContent=Ve),ye=l(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ujmywj"&&(v.textContent=qe),ue=l(e),p(B.$$.fragment,e),de=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-m45fcy"&&(Z.innerHTML=Ye),Ue=l(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-rk7g5b"&&(W.textContent=Oe),he=l(e),p(A.$$.fragment,e),we=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-iru73r"&&(x.textContent=Le),fe=l(e),p($.$$.fragment,e),Je=l(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-fq7603"&&(R.textContent=Pe),ge=l(e),p(_.$$.fragment,e),Te=l(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1iagkck"&&(G.textContent=Ke),je=l(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-xjljcp"&&(S.textContent=De),Ce=l(e),p(E.$$.fragment,e),Ie=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-s6hco9"&&(F.innerHTML=et),be=l(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-glyvcc"&&(N.textContent=tt),ke=l(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1fzjv2z"&&(Q.textContent=st),ve=l(e),p(X.$$.fragment,e),Be=l(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3lq6h2"&&(z.textContent=nt),Ze=l(e),p(H.$$.fragment,e),We=l(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14sbb7i"&&(V.textContent=at),Ae=l(e),p(q.$$.fragment,e),xe=l(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ihn2fs"&&(Y.innerHTML=lt),$e=l(e),p(O.$$.fragment,e),Re=l(e),L=o(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-gdx474"&&(L.innerHTML=it),_e=l(e),p(P.$$.fragment,e),Ge=l(e),ee=o(e,"P",{}),ot(ee).forEach(s),this.h()},h(){K(U,"name","hf:doc:metadata"),K(U,"content",Jt),K(h,"align","center"),K(h,"width","1050"),K(h,"height","303"),pt(h.src,Fe="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/oneformer/teaser.svg")||K(h,"src",Fe)},m(e,t){Ut(document.head,U),n(e,te,t),n(e,D,t),n(e,se,t),M(w,e,t),n(e,ne,t),M(f,e,t),n(e,ae,t),n(e,h,t),n(e,le,t),M(J,e,t),n(e,ie,t),n(e,g,t),n(e,oe,t),n(e,T,t),n(e,re,t),n(e,j,t),n(e,me,t),M(C,e,t),n(e,pe,t),n(e,I,t),n(e,Me,t),n(e,b,t),n(e,ce,t),n(e,k,t),n(e,ye,t),n(e,v,t),n(e,ue,t),M(B,e,t),n(e,de,t),n(e,Z,t),n(e,Ue,t),n(e,W,t),n(e,he,t),M(A,e,t),n(e,we,t),n(e,x,t),n(e,fe,t),M($,e,t),n(e,Je,t),n(e,R,t),n(e,ge,t),M(_,e,t),n(e,Te,t),n(e,G,t),n(e,je,t),n(e,S,t),n(e,Ce,t),M(E,e,t),n(e,Ie,t),n(e,F,t),n(e,be,t),n(e,N,t),n(e,ke,t),n(e,Q,t),n(e,ve,t),M(X,e,t),n(e,Be,t),n(e,z,t),n(e,Ze,t),M(H,e,t),n(e,We,t),n(e,V,t),n(e,Ae,t),M(q,e,t),n(e,xe,t),n(e,Y,t),n(e,$e,t),M(O,e,t),n(e,Re,t),n(e,L,t),n(e,_e,t),M(P,e,t),n(e,Ge,t),n(e,ee,t),Se=!0},p:Mt,i(e){Se||(c(w.$$.fragment,e),c(f.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(B.$$.fragment,e),c(A.$$.fragment,e),c($.$$.fragment,e),c(_.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(q.$$.fragment,e),c(O.$$.fragment,e),c(P.$$.fragment,e),Se=!0)},o(e){y(w.$$.fragment,e),y(f.$$.fragment,e),y(J.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(A.$$.fragment,e),y($.$$.fragment,e),y(_.$$.fragment,e),y(E.$$.fragment,e),y(X.$$.fragment,e),y(H.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(P.$$.fragment,e),Se=!1},d(e){e&&(s(te),s(D),s(se),s(ne),s(ae),s(h),s(le),s(ie),s(g),s(oe),s(T),s(re),s(j),s(me),s(pe),s(I),s(Me),s(b),s(ce),s(k),s(ye),s(v),s(ue),s(de),s(Z),s(Ue),s(W),s(he),s(we),s(x),s(fe),s(Je),s(R),s(ge),s(Te),s(G),s(je),s(S),s(Ce),s(Ie),s(F),s(be),s(N),s(ke),s(Q),s(ve),s(Be),s(z),s(Ze),s(We),s(V),s(Ae),s(xe),s(Y),s($e),s(Re),s(L),s(_e),s(Ge),s(ee)),s(U),u(w,e),u(f,e),u(J,e),u(C,e),u(B,e),u(A,e),u($,e),u(_,e),u(E,e),u(X,e),u(H,e),u(q,e),u(O,e),u(P,e)}}}const Jt='{"title":"OneFormer: One Transformer to Rule Universal Image Segmentation","local":"oneformer-one-transformer-to-rule-universal-image-segmentation","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Background of OneFormer","local":"background-of-oneformer","sections":[],"depth":2},{"title":"Core Concepts of OneFormer","local":"core-concepts-of-oneformer","sections":[{"title":"Task-Dynamic Mask","local":"task-dynamic-mask","sections":[],"depth":3},{"title":"Task-Conditioned Joint Training","local":"task-conditioned-joint-training","sections":[],"depth":3},{"title":"Query-Text Contrastive Loss","local":"query-text-contrastive-loss","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2},{"title":"Example use of model","local":"example-use-of-model","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function gt(Ee){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends yt{constructor(U){super(),ut(this,U,gt,ft,mt,{})}}export{kt as component};
