import{s as gM,o as QM,n as RM}from"../chunks/scheduler.35aab934.js";import{S as VM,i as vM,e as U,s as e,c as w,h as YM,a as i,d as s,b as n,f as SM,g as J,j as p,k as pM,l as HM,m as a,n as y,t as j,o as T,p as t}from"../chunks/index.de17b971.js";import{T as xM}from"../chunks/Tip.514d77c4.js";import{C as FM}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as Il}from"../chunks/CodeBlock.c1f62de5.js";import{H as I,E as $M}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function DM(Cl){let o,c='A backbone, in terms of deep learning, is a part of a neural network that does feature extraction. Additional layers can be added to the backbone to do a variety of vision tasks. Hierarchical backbones have tiered structures, sometimes with varying resolutions. This is in contrast to the non-hierarchical <strong>plain backbone</strong> in <a href="https://arxiv.org/abs/2203.16527" rel="nofollow">VitDet</a> model.';return{c(){o=U("p"),o.innerHTML=c},l(C){o=i(C,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kukwkj"&&(o.innerHTML=c)},m(C,pl){a(C,o,pl)},p:RM,d(C){C&&s(o)}}}function LM(Cl){let o,c,C,pl,m,Al,d,rl,h,IM='Introduced in the 2021 paper, <a href="https://arxiv.org/pdf/2103.14030.pdf" rel="nofollow">Swin Transformer: Hierarchical Vision Transformer using Shifted Windows</a>, the Swin Transformer architecture optimizes for latency and performance using a shifted window (as opposed to sliding window) approach which reduces the number of operations required. Swin is considered a <strong>hierarchical backbone</strong> for computer vision. Swin can be used for tasks like image classification.',cl,A,ml,b,dl,u,hl,f,oM="In the original ViT, attention is done between each patch and all other patches, which gets computationally intensive. Swin optimizes this process by reducing the normally quadratic complexity ViT into linear complexity (with respect to image size). Swin achieves this using a technique similar to CNN, where patches only attend to other patches in the same window, as opposed to all other patches, and then are gradually merged with neighboring patches. This is what makes Swin a hierarchical model.",bl,B,CM='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/swin_transformer_architecture.png" alt="Architecture Diagram of Swin vs Vit, taken from Swin transformer paper"/> <em>Image taken from Swin Transformer paper</em>',ul,Z,fl,G,Bl,E,AM="Swin is more performant than completely patch-based approaches like ViT.",Zl,W,Gl,_,rM="SwinV2 is one of the first 3B parameter models. As training size goes up, Swin outperforms CNN. The large number of parameters enables increased capacity for learning and more complex representations.",El,k,Wl,z,cM='Swin Transformer V2 is a large vision model that can support up to 3B parameters and capable of training with high resolution images. It improves upon the original Swin Transformer by stabilizing training, transfer models pre-trained with low-resolution images to high-resolution tasks, and using <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>, a self-supervised training approach that reduces the number of labeled images required for training.',_l,N,kl,X,zl,S,mM="SwinIR is a model for turning low resolution images into high resolution images based on Swin Transformer.",Nl,g,Xl,Q,dM="Swin2SR is another image restoration model. It is an improvement on SwinIR by incorporating Swin Transformer V2, applying the benefits of Swin V2 like training stability and higher image resolution capacity.",Sl,R,gl,V,hM='Key parts of the <a href="https://github.com/microsoft/Swin-Transformer/blob/main/models/swin_transformer.py" rel="nofollow">implementation of Swin from the original paper</a> is outlined below:',Ql,v,Rl,Y,bM="<li><p><strong>Initialize Parameters</strong>. Among various other dropout and normalization parameters, these parameters include:</p> <ul><li><code>window_size</code>: Size of the windows for local self-attention.</li> <li><code>ape (bool)</code>: If True, add absolute position embedding to the patch embedding.</li> <li><code>fused_window_process</code>: Optional hardware optimization.</li></ul></li> <li><p><strong>Apply Patch Embedding</strong>: Similar to ViT, Images are split into non-overlapping patches and linearly embedded using <code>Conv2D</code>.</p></li> <li><p><strong>Apply Positional Embeddings</strong>: <code>SwinTransformer</code> optionally uses absolute position embeddings (<code>ape</code>), added to the patch embeddings. Absolute positional embeddings often help the model learn to use positional information about each patch to make more informed predictions.</p></li> <li><p><strong>Apply Depth Decay</strong>: Depth decay helps with regularization and preventing overfitting. Depth decay usually done by skipping layers during training. In this Swin implementation, <strong>stochastic</strong> depth decay is used, which means the deeper the layer, the higher the chance it might be skipped.</p></li> <li><p><strong>Layer Construction</strong>:</p> <ul><li>The model is composed of multiple layers (<code>BasicLayer</code>) of <code>SwinTransformerBlock</code>s, each downsampling the feature map for hierarchical processing using <code>PatchMerging</code>.</li> <li>The dimensionality of features and resolution of feature maps change across layers.</li></ul></li> <li><p><strong>Classification Head</strong>: Similar to ViT, it uses an Multi-Layer Perceptron (MLP) head for classification tasks, as defined in <code>self.head</code>, as the last step.</p></li>",Vl,H,vl,x,Yl,F,uM="The <code>SwinTransformerBlock</code> encapsulates the core operations of the Swin Transformer: local windowed attention and subsequent MLP processing. It plays a key role in enabling the Swin Transformer to efficiently handle large images by focusing on local patches while maintaining the ability to learn global representations.",Hl,$,fM="<strong>Layer Components</strong>:",xl,D,BM="<li><strong>Normalization Layer 1 (<code>self.norm1</code>)</strong>: Applied before the attention mechanism.</li> <li><strong>Window Attention (<code>self.attn</code>)</strong>: Computes self-attention within local windows.</li> <li><strong>Drop Path (<code>self.drop_path</code>)</strong>: Implements stochastic depth for regularization.</li> <li><strong>Normalization Layer 2 (<code>self.norm2</code>)</strong>: Applied before the MLP layer.</li> <li><strong>MLP (<code>mlp</code>)</strong>: A multi-layer perceptron for processing features post-attention.</li> <li><strong>Attention Mask (<code>self.register_buffer</code>)</strong>: The attention mask is used during the self-attention computation to control which elements in the windowed input are allowed to interact (i.e., attend to each other). The shifted window approach helps the model to capture broader contextual information by allowing some cross-window interaction.</li>",Fl,L,$l,K,Dl,q,Ll,P,ZM="There are 4 key steps:",Kl,O,GM=`<li><strong>Cyclic shift</strong>:
The feature map is partitioned into windows via <code>window_partition</code>. A <strong>cyclic shift</strong> is then applied to the partitions. Cyclic shift is done by moving elements (in this case, partitions) in a sequence to the left or right, and wrapping around the elements that go off one end back to the other end. This process changes the positions of the elements relative to each other but keeps the sequence otherwise intact. For example, if you cyclically shift the sequence <code>A, B, C, D</code> to the right by one position, it becomes <code>D, A, B, C</code>.</li>`,ql,ll,EM="Cyclic shift allows the model to capture relationships between adjacent windows, enhancing its ability to learn spatial contexts beyond the local scope of individual windows.",Pl,r,WM="<li><p><strong>Windowed attention</strong>: Perform attention using window-based multi-head self attention (W-MSA) module.</p></li> <li><p><strong>Merge Patches</strong>: Patches are merged via <code>PatchMerging</code>.</p></li> <li><p><strong>Reverse cyclic shift</strong>: After attention is done, the window partitioning is undone via <code>reverse_window</code>, and the cyclic shift operation is reversed, so that the feature map retains its original form.</p></li>",Ol,Ml,lM,sl,MM,al,_M="<code>WindowAttention</code> is a window-based multi-head self attention (W-MSA) module with relative position bias. This can be used for both shifted and non-shifted windows.",sM,el,aM,nl,eM,wl,kM="Patch merging method is used for downsampling. It is used to reduce the spatial dimensions of the feature map, similar to pooling in traditional convolutional neural networks (CNNs). It helps in building hierarchical feature representations by progressively increasing the receptive field and reducing the spatial resolution.",nM,Jl,wM,yl,JM,jl,zM='You can find the 🤗 documentation for Swin <a href="https://huggingface.co/docs/transformers/model_doc/swin" rel="nofollow">here</a>.',yM,Tl,jM,tl,NM="Here is how to use Swin model to classify a cat image into one of the 1,000 ImageNet classes:",TM,Ul,tM,il,UM,ol,iM;return m=new FM({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new I({props:{title:"Swin Transformer",local:"swin-transformer",headingTag:"h1"}}),A=new xM({props:{$$slots:{default:[DM]},$$scope:{ctx:Cl}}}),b=new I({props:{title:"Main Highlights",local:"main-highlights",headingTag:"h2"}}),u=new I({props:{title:"Shifted windows",local:"shifted-windows",headingTag:"h3"}}),Z=new I({props:{title:"Advantages",local:"advantages",headingTag:"h2"}}),G=new I({props:{title:"Computational efficiency",local:"computational-efficiency",headingTag:"h3"}}),W=new I({props:{title:"Large datasets",local:"large-datasets",headingTag:"h3"}}),k=new I({props:{title:"Swin Transformer V2 (paper)",local:"swin-transformer-v2-paper",headingTag:"h2"}}),N=new I({props:{title:"Applications in Image Restoration",local:"applications-in-image-restoration",headingTag:"h2"}}),X=new I({props:{title:"SwinIR (paper)",local:"swinir-paper",headingTag:"h3"}}),g=new I({props:{title:"Swin2SR (paper)",local:"swin2sr-paper",headingTag:"h3"}}),R=new I({props:{title:"Overview of PyTorch Implementation of Swin",local:"overview-of-pytorch-implementation-of-swin",headingTag:"h2"}}),v=new I({props:{title:"Swin Transformer class",local:"swin-transformer-class",headingTag:"h3"}}),H=new Il({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SwinTransformer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        img_size=<span class="hljs-number">224</span>,
        patch_size=<span class="hljs-number">4</span>,
        in_chans=<span class="hljs-number">3</span>,
        num_classes=<span class="hljs-number">1000</span>,
        embed_dim=<span class="hljs-number">96</span>,
        depths=[<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">6</span>, <span class="hljs-number">2</span>],
        num_heads=[<span class="hljs-number">3</span>, <span class="hljs-number">6</span>, <span class="hljs-number">12</span>, <span class="hljs-number">24</span>],
        window_size=<span class="hljs-number">7</span>,
        mlp_ratio=<span class="hljs-number">4.0</span>,
        qkv_bias=<span class="hljs-literal">True</span>,
        qk_scale=<span class="hljs-literal">None</span>,
        drop_rate=<span class="hljs-number">0.0</span>,
        attn_drop_rate=<span class="hljs-number">0.0</span>,
        drop_path_rate=<span class="hljs-number">0.1</span>,
        norm_layer=nn.LayerNorm,
        ape=<span class="hljs-literal">False</span>,
        patch_norm=<span class="hljs-literal">True</span>,
        use_checkpoint=<span class="hljs-literal">False</span>,
        fused_window_process=<span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()

        self.num_classes = num_classes
        self.num_layers = <span class="hljs-built_in">len</span>(depths)
        self.embed_dim = embed_dim
        self.ape = ape
        self.patch_norm = patch_norm
        self.num_features = <span class="hljs-built_in">int</span>(embed_dim * <span class="hljs-number">2</span> ** (self.num_layers - <span class="hljs-number">1</span>))
        self.mlp_ratio = mlp_ratio

        <span class="hljs-comment"># split image into non-overlapping patches</span>
        self.patch_embed = PatchEmbed(
            img_size=img_size,
            patch_size=patch_size,
            in_chans=in_chans,
            embed_dim=embed_dim,
            norm_layer=norm_layer <span class="hljs-keyword">if</span> self.patch_norm <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
        )
        num_patches = self.patch_embed.num_patches
        patches_resolution = self.patch_embed.patches_resolution
        self.patches_resolution = patches_resolution

        <span class="hljs-comment"># absolute position embedding</span>
        <span class="hljs-keyword">if</span> self.ape:
            self.absolute_pos_embed = nn.Parameter(torch.zeros(<span class="hljs-number">1</span>, num_patches, embed_dim))
            trunc_normal_(self.absolute_pos_embed, std=<span class="hljs-number">0.02</span>)

        self.pos_drop = nn.Dropout(p=drop_rate)

        <span class="hljs-comment"># stochastic depth</span>
        dpr = [
            x.item() <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> torch.linspace(<span class="hljs-number">0</span>, drop_path_rate, <span class="hljs-built_in">sum</span>(depths))
        ]  <span class="hljs-comment"># stochastic depth decay rule</span>

        <span class="hljs-comment"># build layers</span>
        self.layers = nn.ModuleList()
        <span class="hljs-keyword">for</span> i_layer <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(self.num_layers):
            layer = BasicLayer(
                dim=<span class="hljs-built_in">int</span>(embed_dim * <span class="hljs-number">2</span>**i_layer),
                input_resolution=(
                    patches_resolution[<span class="hljs-number">0</span>] // (<span class="hljs-number">2</span>**i_layer),
                    patches_resolution[<span class="hljs-number">1</span>] // (<span class="hljs-number">2</span>**i_layer),
                ),
                depth=depths[i_layer],
                num_heads=num_heads[i_layer],
                window_size=window_size,
                mlp_ratio=self.mlp_ratio,
                qkv_bias=qkv_bias,
                qk_scale=qk_scale,
                drop=drop_rate,
                attn_drop=attn_drop_rate,
                drop_path=dpr[<span class="hljs-built_in">sum</span>(depths[:i_layer]) : <span class="hljs-built_in">sum</span>(depths[: i_layer + <span class="hljs-number">1</span>])],
                norm_layer=norm_layer,
                downsample=PatchMerging <span class="hljs-keyword">if</span> (i_layer &lt; self.num_layers - <span class="hljs-number">1</span>) <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
                use_checkpoint=use_checkpoint,
                fused_window_process=fused_window_process,
            )
            self.layers.append(layer)

        self.norm = norm_layer(self.num_features)
        self.avgpool = nn.AdaptiveAvgPool1d(<span class="hljs-number">1</span>)
        self.head = (
            nn.Linear(self.num_features, num_classes)
            <span class="hljs-keyword">if</span> num_classes &gt; <span class="hljs-number">0</span>
            <span class="hljs-keyword">else</span> nn.Identity()
        )

        self.apply(self._init_weights)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_init_weights</span>(<span class="hljs-params">self, m</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(m, nn.Linear):
            trunc_normal_(m.weight, std=<span class="hljs-number">0.02</span>)
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(m, nn.Linear) <span class="hljs-keyword">and</span> m.bias <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                nn.init.constant_(m.bias, <span class="hljs-number">0</span>)
        <span class="hljs-keyword">elif</span> <span class="hljs-built_in">isinstance</span>(m, nn.LayerNorm):
            nn.init.constant_(m.bias, <span class="hljs-number">0</span>)
            nn.init.constant_(m.weight, <span class="hljs-number">1.0</span>)

<span class="hljs-meta">    @torch.jit.ignore</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">no_weight_decay</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;absolute_pos_embed&quot;</span>}

<span class="hljs-meta">    @torch.jit.ignore</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">no_weight_decay_keywords</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;relative_position_bias_table&quot;</span>}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward_features</span>(<span class="hljs-params">self, x</span>):
        x = self.patch_embed(x)
        <span class="hljs-keyword">if</span> self.ape:
            x = x + self.absolute_pos_embed
        x = self.pos_drop(x)

        <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> self.layers:
            x = layer(x)

        x = self.norm(x)  <span class="hljs-comment"># B L C</span>
        x = self.avgpool(x.transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>))  <span class="hljs-comment"># B C 1</span>
        x = torch.flatten(x, <span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> x

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        x = self.forward_features(x)
        x = self.head(x)
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),x=new I({props:{title:"Swin Transformer Block",local:"swin-transformer-block",headingTag:"h3"}}),L=new I({props:{title:"Swin Transformer Block’s Initialization",local:"swin-transformer-blocks-initialization",headingTag:"h4"}}),K=new Il({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SwinTransformerBlock</span>(nn.Module):
    <span class="hljs-string">r&quot;&quot;&quot;Swin Transformer Block.

    Args:
        dim (int): Number of input channels.
        input_resolution (tuple[int]): Input resulotion.
        num_heads (int): Number of attention heads.
        window_size (int): Window size.
        shift_size (int): Shift size for SW-MSA.
        mlp_ratio (float): Ratio of mlp hidden dim to embedding dim.
        qkv_bias (bool, optional): If True, add a learnable bias to query, key, value. Default: True
        qk_scale (float | None, optional): Override default qk scale of head_dim ** -0.5 if set.
        drop (float, optional): Dropout rate. Default: 0.0
        attn_drop (float, optional): Attention dropout rate. Default: 0.0
        drop_path (float, optional): Stochastic depth rate. Default: 0.0
        act_layer (nn.Module, optional): Activation layer. Default: nn.GELU
        norm_layer (nn.Module, optional): Normalization layer.  Default: nn.LayerNorm
        fused_window_process (bool, optional): If True, use one kernel to fused window shift &amp; window partition for acceleration, similar for the reversed part. Default: False
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        dim,
        input_resolution,
        num_heads,
        window_size=<span class="hljs-number">7</span>,
        shift_size=<span class="hljs-number">0</span>,
        mlp_ratio=<span class="hljs-number">4.0</span>,
        qkv_bias=<span class="hljs-literal">True</span>,
        qk_scale=<span class="hljs-literal">None</span>,
        drop=<span class="hljs-number">0.0</span>,
        attn_drop=<span class="hljs-number">0.0</span>,
        drop_path=<span class="hljs-number">0.0</span>,
        act_layer=nn.GELU,
        norm_layer=nn.LayerNorm,
        fused_window_process=<span class="hljs-literal">False</span>,
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dim = dim
        self.input_resolution = input_resolution
        self.num_heads = num_heads
        self.window_size = window_size
        self.shift_size = shift_size
        self.mlp_ratio = mlp_ratio
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">min</span>(self.input_resolution) &lt;= self.window_size:
            <span class="hljs-comment"># if window size is larger than input resolution, we don&#x27;t partition windows</span>
            self.shift_size = <span class="hljs-number">0</span>
            self.window_size = <span class="hljs-built_in">min</span>(self.input_resolution)
        <span class="hljs-keyword">assert</span> <span class="hljs-number">0</span> &lt;= self.shift_size &lt; self.window_size, <span class="hljs-string">&quot;shift_size must in 0-window_size&quot;</span>

        self.norm1 = norm_layer(dim)
        self.attn = WindowAttention(
            dim,
            window_size=to_2tuple(self.window_size),
            num_heads=num_heads,
            qkv_bias=qkv_bias,
            qk_scale=qk_scale,
            attn_drop=attn_drop,
            proj_drop=drop,
        )

        self.drop_path = DropPath(drop_path) <span class="hljs-keyword">if</span> drop_path &gt; <span class="hljs-number">0.0</span> <span class="hljs-keyword">else</span> nn.Identity()
        self.norm2 = norm_layer(dim)
        mlp_hidden_dim = <span class="hljs-built_in">int</span>(dim * mlp_ratio)
        self.mlp = Mlp(
            in_features=dim,
            hidden_features=mlp_hidden_dim,
            act_layer=act_layer,
            drop=drop,
        )

        <span class="hljs-keyword">if</span> self.shift_size &gt; <span class="hljs-number">0</span>:
            <span class="hljs-comment"># calculate attention mask for SW-MSA</span>
            H, W = self.input_resolution
            img_mask = torch.zeros((<span class="hljs-number">1</span>, H, W, <span class="hljs-number">1</span>))  <span class="hljs-comment"># 1 H W 1</span>
            h_slices = (
                <span class="hljs-built_in">slice</span>(<span class="hljs-number">0</span>, -self.window_size),
                <span class="hljs-built_in">slice</span>(-self.window_size, -self.shift_size),
                <span class="hljs-built_in">slice</span>(-self.shift_size, <span class="hljs-literal">None</span>),
            )
            w_slices = (
                <span class="hljs-built_in">slice</span>(<span class="hljs-number">0</span>, -self.window_size),
                <span class="hljs-built_in">slice</span>(-self.window_size, -self.shift_size),
                <span class="hljs-built_in">slice</span>(-self.shift_size, <span class="hljs-literal">None</span>),
            )
            cnt = <span class="hljs-number">0</span>
            <span class="hljs-keyword">for</span> h <span class="hljs-keyword">in</span> h_slices:
                <span class="hljs-keyword">for</span> w <span class="hljs-keyword">in</span> w_slices:
                    img_mask[:, h, w, :] = cnt
                    cnt += <span class="hljs-number">1</span>

            mask_windows = window_partition(
                img_mask, self.window_size
            )  <span class="hljs-comment"># nW, window_size, window_size, 1</span>
            mask_windows = mask_windows.view(-<span class="hljs-number">1</span>, self.window_size * self.window_size)
            attn_mask = mask_windows.unsqueeze(<span class="hljs-number">1</span>) - mask_windows.unsqueeze(<span class="hljs-number">2</span>)
            attn_mask = attn_mask.masked_fill(attn_mask != <span class="hljs-number">0</span>, <span class="hljs-built_in">float</span>(-<span class="hljs-number">100.0</span>)).masked_fill(
                attn_mask == <span class="hljs-number">0</span>, <span class="hljs-built_in">float</span>(<span class="hljs-number">0.0</span>)
            )
        <span class="hljs-keyword">else</span>:
            attn_mask = <span class="hljs-literal">None</span>

        self.register_buffer(<span class="hljs-string">&quot;attn_mask&quot;</span>, attn_mask)
        self.fused_window_process = fused_window_process

    <span class="hljs-comment">### New cell ###</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        H, W = self.input_resolution
        B, L, C = x.shape
        <span class="hljs-keyword">assert</span> L == H * W, <span class="hljs-string">&quot;input feature has wrong size&quot;</span>

        shortcut = x
        x = self.norm1(x)
        x = x.view(B, H, W, C)

        <span class="hljs-comment"># cyclic shift</span>
        <span class="hljs-keyword">if</span> self.shift_size &gt; <span class="hljs-number">0</span>:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.fused_window_process:
                shifted_x = torch.roll(
                    x, shifts=(-self.shift_size, -self.shift_size), dims=(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
                )
                <span class="hljs-comment"># partition windows</span>
                x_windows = window_partition(
                    shifted_x, self.window_size
                )  <span class="hljs-comment"># nW*B, window_size, window_size, C</span>
            <span class="hljs-keyword">else</span>:
                x_windows = WindowProcess.apply(
                    x, B, H, W, C, -self.shift_size, self.window_size
                )
        <span class="hljs-keyword">else</span>:
            shifted_x = x
            <span class="hljs-comment"># partition windows</span>
            x_windows = window_partition(
                shifted_x, self.window_size
            )  <span class="hljs-comment"># nW*B, window_size, window_size, C</span>

        x_windows = x_windows.view(
            -<span class="hljs-number">1</span>, self.window_size * self.window_size, C
        )  <span class="hljs-comment"># nW*B, window_size*window_size, C</span>

        <span class="hljs-comment"># W-MSA/SW-MSA</span>
        attn_windows = self.attn(
            x_windows, mask=self.attn_mask
        )  <span class="hljs-comment"># nW*B, window_size*window_size, C</span>

        <span class="hljs-comment"># merge windows</span>
        attn_windows = attn_windows.view(-<span class="hljs-number">1</span>, self.window_size, self.window_size, C)

        <span class="hljs-comment"># reverse cyclic shift</span>
        <span class="hljs-keyword">if</span> self.shift_size &gt; <span class="hljs-number">0</span>:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.fused_window_process:
                shifted_x = window_reverse(
                    attn_windows, self.window_size, H, W
                )  <span class="hljs-comment"># B H&#x27; W&#x27; C</span>
                x = torch.roll(
                    shifted_x, shifts=(self.shift_size, self.shift_size), dims=(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
                )
            <span class="hljs-keyword">else</span>:
                x = WindowProcessReverse.apply(
                    attn_windows, B, H, W, C, self.shift_size, self.window_size
                )
        <span class="hljs-keyword">else</span>:
            shifted_x = window_reverse(attn_windows, self.window_size, H, W)  <span class="hljs-comment"># B H&#x27; W&#x27; C</span>
            x = shifted_x
        x = x.view(B, H * W, C)
        x = shortcut + self.drop_path(x)

        <span class="hljs-comment"># Feed-forward network (FFN)</span>
        x = x + self.drop_path(self.mlp(self.norm2(x)))

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),q=new I({props:{title:"Swin Transformer Block’s Forward Pass",local:"swin-transformer-blocks-forward-pass",headingTag:"h4"}}),Ml=new Il({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">WindowAttention</span>(nn.Module):
    <span class="hljs-string">&quot;&quot;&quot;
    Args:
        dim (int): Number of input channels.
        window_size (tuple[int]): The height and width of the window.
        num_heads (int): Number of attention heads.
        qkv_bias (bool, optional):  If True, add a learnable bias to query, key, value. Default: True
        qk_scale (float | None, optional): Override default qk scale of head_dim ** -0.5 if set
        attn_drop (float, optional): Dropout ratio of attention weight. Default: 0.0
        proj_drop (float, optional): Dropout ratio of output. Default: 0.0
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        dim,
        window_size,
        num_heads,
        qkv_bias=<span class="hljs-literal">True</span>,
        qk_scale=<span class="hljs-literal">None</span>,
        attn_drop=<span class="hljs-number">0.0</span>,
        proj_drop=<span class="hljs-number">0.0</span>,
    </span>):

        <span class="hljs-built_in">super</span>().__init__()
        self.dim = dim
        self.window_size = window_size  <span class="hljs-comment"># Wh, Ww</span>
        self.num_heads = num_heads
        head_dim = dim // num_heads
        self.scale = qk_scale <span class="hljs-keyword">or</span> head_dim**-<span class="hljs-number">0.5</span>

        <span class="hljs-comment"># define a parameter table of relative position bias</span>
        self.relative_position_bias_table = nn.Parameter(
            torch.zeros((<span class="hljs-number">2</span> * window_size[<span class="hljs-number">0</span>] - <span class="hljs-number">1</span>) * (<span class="hljs-number">2</span> * window_size[<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>), num_heads)
        )  <span class="hljs-comment"># 2*Wh-1 * 2*Ww-1, nH</span>

        <span class="hljs-comment"># get pair-wise relative position index for each token inside the window</span>
        coords_h = torch.arange(self.window_size[<span class="hljs-number">0</span>])
        coords_w = torch.arange(self.window_size[<span class="hljs-number">1</span>])
        coords = torch.stack(torch.meshgrid([coords_h, coords_w]))  <span class="hljs-comment"># 2, Wh, Ww</span>
        coords_flatten = torch.flatten(coords, <span class="hljs-number">1</span>)  <span class="hljs-comment"># 2, Wh*Ww</span>
        relative_coords = (
            coords_flatten[:, :, <span class="hljs-literal">None</span>] - coords_flatten[:, <span class="hljs-literal">None</span>, :]
        )  <span class="hljs-comment"># 2, Wh*Ww, Wh*Ww</span>
        relative_coords = relative_coords.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).contiguous()  <span class="hljs-comment"># Wh*Ww, Wh*Ww, 2</span>
        relative_coords[:, :, <span class="hljs-number">0</span>] += self.window_size[<span class="hljs-number">0</span>] - <span class="hljs-number">1</span>  <span class="hljs-comment"># shift to start from 0</span>
        relative_coords[:, :, <span class="hljs-number">1</span>] += self.window_size[<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>
        relative_coords[:, :, <span class="hljs-number">0</span>] *= <span class="hljs-number">2</span> * self.window_size[<span class="hljs-number">1</span>] - <span class="hljs-number">1</span>
        relative_position_index = relative_coords.<span class="hljs-built_in">sum</span>(-<span class="hljs-number">1</span>)  <span class="hljs-comment"># Wh*Ww, Wh*Ww</span>
        self.register_buffer(<span class="hljs-string">&quot;relative_position_index&quot;</span>, relative_position_index)

        self.qkv = nn.Linear(dim, dim * <span class="hljs-number">3</span>, bias=qkv_bias)
        self.attn_drop = nn.Dropout(attn_drop)
        self.proj = nn.Linear(dim, dim)
        self.proj_drop = nn.Dropout(proj_drop)

        trunc_normal_(self.relative_position_bias_table, std=<span class="hljs-number">0.02</span>)
        self.softmax = nn.Softmax(dim=-<span class="hljs-number">1</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x, mask=<span class="hljs-literal">None</span></span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Args:
            x: input features with shape of (num_windows*B, N, C)
            mask: (0/-inf) mask with shape of (num_windows, Wh*Ww, Wh*Ww) or None
        &quot;&quot;&quot;</span>
        B_, N, C = x.shape
        qkv = (
            self.qkv(x)
            .reshape(B_, N, <span class="hljs-number">3</span>, self.num_heads, C // self.num_heads)
            .permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>)
        )
        q, k, v = (
            qkv[<span class="hljs-number">0</span>],
            qkv[<span class="hljs-number">1</span>],
            qkv[<span class="hljs-number">2</span>],
        )  <span class="hljs-comment"># make torchscript happy (cannot use tensor as tuple)</span>

        q = q * self.scale
        attn = q @ k.transpose(-<span class="hljs-number">2</span>, -<span class="hljs-number">1</span>)

        relative_position_bias = self.relative_position_bias_table[
            self.relative_position_index.view(-<span class="hljs-number">1</span>)
        ].view(
            self.window_size[<span class="hljs-number">0</span>] * self.window_size[<span class="hljs-number">1</span>],
            self.window_size[<span class="hljs-number">0</span>] * self.window_size[<span class="hljs-number">1</span>],
            -<span class="hljs-number">1</span>,
        )  <span class="hljs-comment"># Wh*Ww,Wh*Ww,nH</span>
        relative_position_bias = relative_position_bias.permute(
            <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>
        ).contiguous()  <span class="hljs-comment"># nH, Wh*Ww, Wh*Ww</span>
        attn = attn + relative_position_bias.unsqueeze(<span class="hljs-number">0</span>)

        <span class="hljs-keyword">if</span> mask <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            nW = mask.shape[<span class="hljs-number">0</span>]
            attn = attn.view(B_ // nW, nW, self.num_heads, N, N) + mask.unsqueeze(
                <span class="hljs-number">1</span>
            ).unsqueeze(<span class="hljs-number">0</span>)
            attn = attn.view(-<span class="hljs-number">1</span>, self.num_heads, N, N)
            attn = self.softmax(attn)
        <span class="hljs-keyword">else</span>:
            attn = self.softmax(attn)

        attn = self.attn_drop(attn)

        x = (attn @ v).transpose(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>).reshape(B_, N, C)
        x = self.proj(x)
        x = self.proj_drop(x)
        <span class="hljs-keyword">return</span> x`,wrap:!1}}),sl=new I({props:{title:"Window Attention",local:"window-attention",headingTag:"h3"}}),el=new Il({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PatchMerging</span>(nn.Module):
    <span class="hljs-string">r&quot;&quot;&quot;Patch Merging Layer.

    Args:
        input_resolution (tuple[int]): Resolution of input feature.
        dim (int): Number of input channels.
        norm_layer (nn.Module, optional): Normalization layer.  Default: nn.LayerNorm
    &quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, input_resolution, dim, norm_layer=nn.LayerNorm</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.input_resolution = input_resolution
        self.dim = dim
        self.reduction = nn.Linear(<span class="hljs-number">4</span> * dim, <span class="hljs-number">2</span> * dim, bias=<span class="hljs-literal">False</span>)
        self.norm = norm_layer(<span class="hljs-number">4</span> * dim)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        x: B, H*W, C
        &quot;&quot;&quot;</span>
        H, W = self.input_resolution
        B, L, C = x.shape
        <span class="hljs-keyword">assert</span> L == H * W, <span class="hljs-string">&quot;input feature has wrong size&quot;</span>
        <span class="hljs-keyword">assert</span> H % <span class="hljs-number">2</span> == <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> W % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, <span class="hljs-string">f&quot;x size (<span class="hljs-subst">{H}</span>*<span class="hljs-subst">{W}</span>) are not even.&quot;</span>

        x = x.view(B, H, W, C)

        x0 = x[:, <span class="hljs-number">0</span>::<span class="hljs-number">2</span>, <span class="hljs-number">0</span>::<span class="hljs-number">2</span>, :]  <span class="hljs-comment"># B H/2 W/2 C</span>
        x1 = x[:, <span class="hljs-number">1</span>::<span class="hljs-number">2</span>, <span class="hljs-number">0</span>::<span class="hljs-number">2</span>, :]  <span class="hljs-comment"># B H/2 W/2 C</span>
        x2 = x[:, <span class="hljs-number">0</span>::<span class="hljs-number">2</span>, <span class="hljs-number">1</span>::<span class="hljs-number">2</span>, :]  <span class="hljs-comment"># B H/2 W/2 C</span>
        x3 = x[:, <span class="hljs-number">1</span>::<span class="hljs-number">2</span>, <span class="hljs-number">1</span>::<span class="hljs-number">2</span>, :]  <span class="hljs-comment"># B H/2 W/2 C</span>
        x = torch.cat([x0, x1, x2, x3], -<span class="hljs-number">1</span>)  <span class="hljs-comment"># B H/2 W/2 4*C</span>
        x = x.view(B, -<span class="hljs-number">1</span>, <span class="hljs-number">4</span> * C)  <span class="hljs-comment"># B H/2*W/2 4*C</span>

        x = self.norm(x)
        x = self.reduction(x)

        <span class="hljs-keyword">return</span> x`,wrap:!1}}),nl=new I({props:{title:"Patch Merging Layer",local:"patch-merging-layer",headingTag:"h3"}}),Jl=new Il({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyJTBBKSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiUwQSklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9sYWJlbF9pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByZWRpY3RlZF9sYWJlbF90ZXh0JTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsX2lkJTVEJTBBJTBBcHJpbnQocHJlZGljdGVkX2xhYmVsX3RleHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForImageClassification
<span class="hljs-keyword">import</span> torch

model = SwinForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>
)
image_processor = AutoImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>
)

dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    logits = model(**inputs).logits

predicted_label_id = logits.argmax(-<span class="hljs-number">1</span>).item()
predicted_label_text = model.config.id2label[predicted_label_id]

<span class="hljs-built_in">print</span>(predicted_label_text)`,wrap:!1}}),yl=new I({props:{title:"Try it out",local:"try-it-out",headingTag:"h2"}}),Tl=new I({props:{title:"Usage of pretrained Swin model for classification",local:"usage-of-pretrained-swin-model-for-classification",headingTag:"h3"}}),Ul=new Il({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyJTBBKSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiUwQSklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9sYWJlbF9pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByZWRpY3RlZF9sYWJlbF90ZXh0JTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsX2lkJTVEJTBBJTBBcHJpbnQocHJlZGljdGVkX2xhYmVsX3RleHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForImageClassification
<span class="hljs-keyword">import</span> torch

model = SwinForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>
)
image_processor = AutoImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>
)

dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    logits = model(**inputs).logits

predicted_label_id = logits.argmax(-<span class="hljs-number">1</span>).item()
predicted_label_text = model.config.id2label[predicted_label_id]

<span class="hljs-built_in">print</span>(predicted_label_text)`,wrap:!1}}),il=new $M({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/swin-transformer.mdx"}}),{c(){o=U("meta"),c=e(),C=U("p"),pl=e(),w(m.$$.fragment),Al=e(),w(d.$$.fragment),rl=e(),h=U("p"),h.innerHTML=IM,cl=e(),w(A.$$.fragment),ml=e(),w(b.$$.fragment),dl=e(),w(u.$$.fragment),hl=e(),f=U("p"),f.textContent=oM,bl=e(),B=U("p"),B.innerHTML=CM,ul=e(),w(Z.$$.fragment),fl=e(),w(G.$$.fragment),Bl=e(),E=U("p"),E.textContent=AM,Zl=e(),w(W.$$.fragment),Gl=e(),_=U("p"),_.textContent=rM,El=e(),w(k.$$.fragment),Wl=e(),z=U("p"),z.innerHTML=cM,_l=e(),w(N.$$.fragment),kl=e(),w(X.$$.fragment),zl=e(),S=U("p"),S.textContent=mM,Nl=e(),w(g.$$.fragment),Xl=e(),Q=U("p"),Q.textContent=dM,Sl=e(),w(R.$$.fragment),gl=e(),V=U("p"),V.innerHTML=hM,Ql=e(),w(v.$$.fragment),Rl=e(),Y=U("ol"),Y.innerHTML=bM,Vl=e(),w(H.$$.fragment),vl=e(),w(x.$$.fragment),Yl=e(),F=U("p"),F.innerHTML=uM,Hl=e(),$=U("p"),$.innerHTML=fM,xl=e(),D=U("ul"),D.innerHTML=BM,Fl=e(),w(L.$$.fragment),$l=e(),w(K.$$.fragment),Dl=e(),w(q.$$.fragment),Ll=e(),P=U("p"),P.textContent=ZM,Kl=e(),O=U("ol"),O.innerHTML=GM,ql=e(),ll=U("p"),ll.textContent=EM,Pl=e(),r=U("ol"),r.innerHTML=WM,Ol=e(),w(Ml.$$.fragment),lM=e(),w(sl.$$.fragment),MM=e(),al=U("p"),al.innerHTML=_M,sM=e(),w(el.$$.fragment),aM=e(),w(nl.$$.fragment),eM=e(),wl=U("p"),wl.textContent=kM,nM=e(),w(Jl.$$.fragment),wM=e(),w(yl.$$.fragment),JM=e(),jl=U("p"),jl.innerHTML=zM,yM=e(),w(Tl.$$.fragment),jM=e(),tl=U("p"),tl.textContent=NM,TM=e(),w(Ul.$$.fragment),tM=e(),w(il.$$.fragment),UM=e(),ol=U("p"),this.h()},l(l){const M=YM("svelte-u9bgzb",document.head);o=i(M,"META",{name:!0,content:!0}),M.forEach(s),c=n(l),C=i(l,"P",{}),SM(C).forEach(s),pl=n(l),J(m.$$.fragment,l),Al=n(l),J(d.$$.fragment,l),rl=n(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1liaej5"&&(h.innerHTML=IM),cl=n(l),J(A.$$.fragment,l),ml=n(l),J(b.$$.fragment,l),dl=n(l),J(u.$$.fragment,l),hl=n(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-v6mufn"&&(f.textContent=oM),bl=n(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1sivzp7"&&(B.innerHTML=CM),ul=n(l),J(Z.$$.fragment,l),fl=n(l),J(G.$$.fragment,l),Bl=n(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1scimix"&&(E.textContent=AM),Zl=n(l),J(W.$$.fragment,l),Gl=n(l),_=i(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1ar7si0"&&(_.textContent=rM),El=n(l),J(k.$$.fragment,l),Wl=n(l),z=i(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-gte5nr"&&(z.innerHTML=cM),_l=n(l),J(N.$$.fragment,l),kl=n(l),J(X.$$.fragment,l),zl=n(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ovyyzy"&&(S.textContent=mM),Nl=n(l),J(g.$$.fragment,l),Xl=n(l),Q=i(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-17s6cnu"&&(Q.textContent=dM),Sl=n(l),J(R.$$.fragment,l),gl=n(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1mhwcrz"&&(V.innerHTML=hM),Ql=n(l),J(v.$$.fragment,l),Rl=n(l),Y=i(l,"OL",{"data-svelte-h":!0}),p(Y)!=="svelte-yzpp2u"&&(Y.innerHTML=bM),Vl=n(l),J(H.$$.fragment,l),vl=n(l),J(x.$$.fragment,l),Yl=n(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1xtzqrj"&&(F.innerHTML=uM),Hl=n(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-2vg4uy"&&($.innerHTML=fM),xl=n(l),D=i(l,"UL",{"data-svelte-h":!0}),p(D)!=="svelte-1q7zr4v"&&(D.innerHTML=BM),Fl=n(l),J(L.$$.fragment,l),$l=n(l),J(K.$$.fragment,l),Dl=n(l),J(q.$$.fragment,l),Ll=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-pxflyy"&&(P.textContent=ZM),Kl=n(l),O=i(l,"OL",{"data-svelte-h":!0}),p(O)!=="svelte-1hw5ztp"&&(O.innerHTML=GM),ql=n(l),ll=i(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1we3lpu"&&(ll.textContent=EM),Pl=n(l),r=i(l,"OL",{start:!0,"data-svelte-h":!0}),p(r)!=="svelte-eauj2a"&&(r.innerHTML=WM),Ol=n(l),J(Ml.$$.fragment,l),lM=n(l),J(sl.$$.fragment,l),MM=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-p86ede"&&(al.innerHTML=_M),sM=n(l),J(el.$$.fragment,l),aM=n(l),J(nl.$$.fragment,l),eM=n(l),wl=i(l,"P",{"data-svelte-h":!0}),p(wl)!=="svelte-13lo25y"&&(wl.textContent=kM),nM=n(l),J(Jl.$$.fragment,l),wM=n(l),J(yl.$$.fragment,l),JM=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-uwdp26"&&(jl.innerHTML=zM),yM=n(l),J(Tl.$$.fragment,l),jM=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-jk9xtw"&&(tl.textContent=NM),TM=n(l),J(Ul.$$.fragment,l),tM=n(l),J(il.$$.fragment,l),UM=n(l),ol=i(l,"P",{}),SM(ol).forEach(s),this.h()},h(){pM(o,"name","hf:doc:metadata"),pM(o,"content",KM),pM(r,"start","2")},m(l,M){HM(document.head,o),a(l,c,M),a(l,C,M),a(l,pl,M),y(m,l,M),a(l,Al,M),y(d,l,M),a(l,rl,M),a(l,h,M),a(l,cl,M),y(A,l,M),a(l,ml,M),y(b,l,M),a(l,dl,M),y(u,l,M),a(l,hl,M),a(l,f,M),a(l,bl,M),a(l,B,M),a(l,ul,M),y(Z,l,M),a(l,fl,M),y(G,l,M),a(l,Bl,M),a(l,E,M),a(l,Zl,M),y(W,l,M),a(l,Gl,M),a(l,_,M),a(l,El,M),y(k,l,M),a(l,Wl,M),a(l,z,M),a(l,_l,M),y(N,l,M),a(l,kl,M),y(X,l,M),a(l,zl,M),a(l,S,M),a(l,Nl,M),y(g,l,M),a(l,Xl,M),a(l,Q,M),a(l,Sl,M),y(R,l,M),a(l,gl,M),a(l,V,M),a(l,Ql,M),y(v,l,M),a(l,Rl,M),a(l,Y,M),a(l,Vl,M),y(H,l,M),a(l,vl,M),y(x,l,M),a(l,Yl,M),a(l,F,M),a(l,Hl,M),a(l,$,M),a(l,xl,M),a(l,D,M),a(l,Fl,M),y(L,l,M),a(l,$l,M),y(K,l,M),a(l,Dl,M),y(q,l,M),a(l,Ll,M),a(l,P,M),a(l,Kl,M),a(l,O,M),a(l,ql,M),a(l,ll,M),a(l,Pl,M),a(l,r,M),a(l,Ol,M),y(Ml,l,M),a(l,lM,M),y(sl,l,M),a(l,MM,M),a(l,al,M),a(l,sM,M),y(el,l,M),a(l,aM,M),y(nl,l,M),a(l,eM,M),a(l,wl,M),a(l,nM,M),y(Jl,l,M),a(l,wM,M),y(yl,l,M),a(l,JM,M),a(l,jl,M),a(l,yM,M),y(Tl,l,M),a(l,jM,M),a(l,tl,M),a(l,TM,M),y(Ul,l,M),a(l,tM,M),y(il,l,M),a(l,UM,M),a(l,ol,M),iM=!0},p(l,[M]){const XM={};M&2&&(XM.$$scope={dirty:M,ctx:l}),A.$set(XM)},i(l){iM||(j(m.$$.fragment,l),j(d.$$.fragment,l),j(A.$$.fragment,l),j(b.$$.fragment,l),j(u.$$.fragment,l),j(Z.$$.fragment,l),j(G.$$.fragment,l),j(W.$$.fragment,l),j(k.$$.fragment,l),j(N.$$.fragment,l),j(X.$$.fragment,l),j(g.$$.fragment,l),j(R.$$.fragment,l),j(v.$$.fragment,l),j(H.$$.fragment,l),j(x.$$.fragment,l),j(L.$$.fragment,l),j(K.$$.fragment,l),j(q.$$.fragment,l),j(Ml.$$.fragment,l),j(sl.$$.fragment,l),j(el.$$.fragment,l),j(nl.$$.fragment,l),j(Jl.$$.fragment,l),j(yl.$$.fragment,l),j(Tl.$$.fragment,l),j(Ul.$$.fragment,l),j(il.$$.fragment,l),iM=!0)},o(l){T(m.$$.fragment,l),T(d.$$.fragment,l),T(A.$$.fragment,l),T(b.$$.fragment,l),T(u.$$.fragment,l),T(Z.$$.fragment,l),T(G.$$.fragment,l),T(W.$$.fragment,l),T(k.$$.fragment,l),T(N.$$.fragment,l),T(X.$$.fragment,l),T(g.$$.fragment,l),T(R.$$.fragment,l),T(v.$$.fragment,l),T(H.$$.fragment,l),T(x.$$.fragment,l),T(L.$$.fragment,l),T(K.$$.fragment,l),T(q.$$.fragment,l),T(Ml.$$.fragment,l),T(sl.$$.fragment,l),T(el.$$.fragment,l),T(nl.$$.fragment,l),T(Jl.$$.fragment,l),T(yl.$$.fragment,l),T(Tl.$$.fragment,l),T(Ul.$$.fragment,l),T(il.$$.fragment,l),iM=!1},d(l){l&&(s(c),s(C),s(pl),s(Al),s(rl),s(h),s(cl),s(ml),s(dl),s(hl),s(f),s(bl),s(B),s(ul),s(fl),s(Bl),s(E),s(Zl),s(Gl),s(_),s(El),s(Wl),s(z),s(_l),s(kl),s(zl),s(S),s(Nl),s(Xl),s(Q),s(Sl),s(gl),s(V),s(Ql),s(Rl),s(Y),s(Vl),s(vl),s(Yl),s(F),s(Hl),s($),s(xl),s(D),s(Fl),s($l),s(Dl),s(Ll),s(P),s(Kl),s(O),s(ql),s(ll),s(Pl),s(r),s(Ol),s(lM),s(MM),s(al),s(sM),s(aM),s(eM),s(wl),s(nM),s(wM),s(JM),s(jl),s(yM),s(jM),s(tl),s(TM),s(tM),s(UM),s(ol)),s(o),t(m,l),t(d,l),t(A,l),t(b,l),t(u,l),t(Z,l),t(G,l),t(W,l),t(k,l),t(N,l),t(X,l),t(g,l),t(R,l),t(v,l),t(H,l),t(x,l),t(L,l),t(K,l),t(q,l),t(Ml,l),t(sl,l),t(el,l),t(nl,l),t(Jl,l),t(yl,l),t(Tl,l),t(Ul,l),t(il,l)}}}const KM='{"title":"Swin Transformer","local":"swin-transformer","sections":[{"title":"Main Highlights","local":"main-highlights","sections":[{"title":"Shifted windows","local":"shifted-windows","sections":[],"depth":3}],"depth":2},{"title":"Advantages","local":"advantages","sections":[{"title":"Computational efficiency","local":"computational-efficiency","sections":[],"depth":3},{"title":"Large datasets","local":"large-datasets","sections":[],"depth":3}],"depth":2},{"title":"Swin Transformer V2 (paper)","local":"swin-transformer-v2-paper","sections":[],"depth":2},{"title":"Applications in Image Restoration","local":"applications-in-image-restoration","sections":[{"title":"SwinIR (paper)","local":"swinir-paper","sections":[],"depth":3},{"title":"Swin2SR (paper)","local":"swin2sr-paper","sections":[],"depth":3}],"depth":2},{"title":"Overview of PyTorch Implementation of Swin","local":"overview-of-pytorch-implementation-of-swin","sections":[{"title":"Swin Transformer class","local":"swin-transformer-class","sections":[],"depth":3},{"title":"Swin Transformer Block","local":"swin-transformer-block","sections":[{"title":"Swin Transformer Block’s Initialization","local":"swin-transformer-blocks-initialization","sections":[],"depth":4},{"title":"Swin Transformer Block’s Forward Pass","local":"swin-transformer-blocks-forward-pass","sections":[],"depth":4}],"depth":3},{"title":"Window Attention","local":"window-attention","sections":[],"depth":3},{"title":"Patch Merging Layer","local":"patch-merging-layer","sections":[],"depth":3}],"depth":2},{"title":"Try it out","local":"try-it-out","sections":[{"title":"Usage of pretrained Swin model for classification","local":"usage-of-pretrained-swin-model-for-classification","sections":[],"depth":3}],"depth":2}],"depth":1}';function qM(Cl){return QM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends VM{constructor(o){super(),vM(this,o,qM,LM,gM,{})}}export{es as component};
