import{s as pa,n as ca,o as ua}from"../chunks/scheduler.35aab934.js";import{S as ma,i as da,e as i,s as n,c as p,h as ga,a as o,d as s,b as l,f as oa,g as c,j as r,k as ra,l as ya,m as a,n as u,t as m,o as d,p as g}from"../chunks/index.de17b971.js";import{C as ha}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as y}from"../chunks/CodeBlock.c1f62de5.js";import{H as h,E as Ma}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function wa(us){let M,Ye,Ne,ze,w,qe,J,Fe,T,ms="In this section, we will briefly look at the different multimodal tasks involving Image and Text modalities and their corresponding models. Before diving in, let’s have a small recap on what is meant by “multimodal” which was covered in previous sections. The human world is a symphony of diverse sensory inputs. We perceive and understand through sight, sound, touch, and more. This multimodality is what separates our rich understanding from the limitations of traditional, unimodal AI models. Drawing inspiration from human cognition, multimodal models aim to bridge this gap by integrating information from multiple sources, like text, images, audio, and even sensor data. This fusion of modalities leads to a more comprehensive and nuanced understanding of the world, unlocking a vast range of tasks and applications.",Le,b,_e,f,ds="Before looking into specific models, it’s crucial to understand the diverse range of tasks involving image and text. These tasks include but are not limited to:",$e,U,gs="<li><p><strong>Visual Question Answering (VQA) and Visual Reasoning:</strong> Imagine a machine that looks at a picture and understands your questions about it. Visual Question Answering (VQA) is just that! It trains computers to extract meaning from images and answer questions like “Who’s driving the car?” while Visual Reasoning is the secret sauce, enabling the machine to go beyond simple recognition and infer relationships, compare objects, and understand scene context to give accurate answers. It’s like asking a detective to read the clues in a picture, only much faster and better!</p></li> <li><p><strong>Document Visual Question Answering (DocVQA):</strong> Imagine a computer understanding both the text and layout of a document, like a map or contract, and then answering questions about it directly from the image. That’s Document Visual Question Answering (DocVQA) in a nutshell. It combines computer vision for processing image elements and natural language processing to interpret text, allowing machines to “read” and answer questions about documents just like humans do. Think of it as supercharging document search with AI to unlock all the information trapped within those images.</p></li> <li><p><strong>Image captioning:</strong> Image captioning bridges the gap between vision and language. It analyzes an image like a detective, extracting details, understanding the scene, and then crafting a sentence or two that tells the story – a sunset over a calm sea, a child laughing on a swing, or even a bustling city street. It’s a fascinating blend of computer vision and language, letting computers describe the world around them, one picture at a time.</p></li> <li><p><strong>Image-Text Retrieval:</strong> Image-text retrieval is like a matchmaker for images and their descriptions. Think of it like searching for a specific book in a library, but instead of browsing titles, you can use either the picture on the cover or a brief summary to find it. It’s like a super-powered search engine that understands both pictures and words, opening doors for exciting applications like image search, automatic captioning, and even helping visually impaired people “see” through text descriptions.</p></li> <li><p><strong>Visual grounding:</strong> Visual grounding is like connecting the dots between what we see and say. It’s about understanding how language references specific parts of an image, allowing AI models to pinpoint objects or regions based on natural language descriptions. Imagine asking “Where’s the red apple in the fruit bowl?” and the AI instantly highlights it in the picture - that’s visual grounding at work!</p></li> <li><p><strong>Text-to-Image generation:</strong> Imagine a magical paintbrush that interprets your words and brings them to life! Text-to-image generation is like that; it transforms your written descriptions into unique images. It’s a blend of language understanding and image creation, where your text unlocks a visual world from photorealistic landscapes to dreamlike abstractions, all born from the power of your words.</p></li>",Se,v,Ae,j,ys='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/vqa_visual_reasoning.png" alt="VQA"/> <em>Example of Input (Image + Text) and Output (Text) for the VQA and Visual Reasoning Models <a href="#pretraining-paper">[1]</a></em>',Pe,I,hs="<strong>Visual Question Answering (VQA)</strong>",De,Z,Ms=`<li><strong>Input:</strong> An image-question pair (image and a question about it).</li> <li><strong>Output:</strong> In multiple-choice setting: A label corresponding to the correct answer among pre-defined choices.
In open-ended setting: A free-form natural language answer based on the image and question.</li> <li><strong>Task:</strong> Answer questions about images. (Most VQA models treat as a classification problem with pre-defined answers). See the above example for the reference.</li>`,Ke,B,ws="<strong>Visual Reasoning</strong>",Oe,W,Js=`<li><strong>Input:</strong> Varies depending on the specific visual reasoning task:
<ul><li>VQA-style tasks: Image-question pairs.</li> <li>Matching tasks: Images and text statements.</li> <li>Entailment tasks: Image and text pair (potentially with multiple statements).</li> <li>Sub-question tasks: Image and a primary question with additional perception-related sub-questions.</li></ul></li> <li><strong>Output:</strong> Varies depending on the task:
<ul><li>VQA: Answers to questions about the image.</li> <li>Matching: True/False for whether the text is true about the image(s).</li> <li>Entailment: Prediction of whether the image semantically entails the text.</li> <li>Sub-question: Answers to the sub-questions related to perception.</li></ul></li> <li><strong>Task:</strong> Performs various reasoning tasks on images. See the above example for the reference.</li>`,et,x,Ts="In general, both VQA and Visual Reasoning are treated as <em>Visual Question Answering (VQA)</em> task. Some of the popular models for VQA tasks are:",tt,k,bs="<li><strong>BLIP-VQA</strong>: It is a large pre-trained model for visual question answering (VQA) tasks developed by Salesforce AI. It uses a “Bootstrapping Language-Image Pre-training” (BLIP) approach, which leverages both noisy web data and caption generation to achieve state-of-the-art performance on various vision-language tasks. You can use the BLIP in huggingface as follows:</li>",st,V,at,C,fs="<li><strong>Deplot</strong>: It is a one-shot visual language reasoning model trained on translating plots and charts to text summaries. This enables its integration with LLMs for answering complex questions about the data, even with novel human-written queries. DePlot achieves this by standardizing the plot-to-table translation task and leveraging Pix2Struct architecture, surpassing previous SOTA on chart QA with just a single example and LLM prompting. You can use the Deplot in huggingface as follows:</li>",nt,G,lt,R,Us="<li><strong>VLIT</strong>: It is a Vision-and-Language Transformer (ViLT) model, utilizing a transformer architecture without convolutions or region supervision, fine-tuned on the VQAv2 dataset for answering natural language questions about images. The base ViLT model boasts a large architecture (B32 size) and leverages joint image and text training, making it effective for various vision-language tasks, particularly VQA, achieving competitive performance. You can use VLIT in HuggingFace as follows:</li>",it,H,ot,X,vs='Learn more about how to train and use VQA models in HuggingFace <code>transformers</code> library <a href="https://huggingface.co/docs/transformers/v4.36.1/tasks/visual_question_answering" rel="nofollow">here</a>.',rt,Q,pt,N,js='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/doc_vqa.jpg" alt="DocVQA"/> <em>Example of Input (Image + Text) and Output (Text) for the Doc VQA Model. <a href="#doc-vqa-paper">[2]</a></em>',ct,E,Is="<li><p><strong>Input:</strong></p> <ul><li>Document image: A scanned or digital image of a document, containing text, layout, and visual elements.</li> <li>Question about the document: A natural language question posed in text format.</li></ul></li> <li><p><strong>Task:</strong></p> <ul><li>Analyze and understand: The DocVQA model must process both the visual and textual information within the document to fully comprehend its content.</li> <li>Reason and infer: The model needs to establish relationships between visual elements, text, and the question to draw relevant conclusions.</li> <li>Generate a natural language answer: The model must produce a clear, concise, and accurate answer to the question in natural language text format. See the above example for the reference.</li></ul></li> <li><p><strong>Output:</strong> Answer to the question: A text response that directly addresses the query and accurately reflects the information found in the document.</p></li>",ut,Y,Zs="Now, let’s look at the some of the popular DocVQA models in the HuggingFace:",mt,z,Bs="<li><strong>LayoutLM:</strong> It is a pre-trained neural network that understands document images by jointly analyzing both the text and its layout. Unlike traditional NLP models, it considers factors like font size, position, and proximity to learn relationships between words and their meaning in the context of the document. This allows it to excel at tasks like form understanding, receipt analysis, and document classification, making it a powerful tool for extracting information from scanned documents. You can use LayoutLM in HuggingFace as follows:</li>",dt,q,gt,F,Ws="<li><strong>Donut:</strong> Also known as OCR-free Document Understanding Transformer, is a state-of-the-art image processing model that bypasses traditional optical character recognition (OCR) and directly analyzes document images to understand their content. It combines a vision encoder (Swin Transformer) with a text decoder (BART) to extract information and generate textual descriptions, excelling in tasks like document classification, form understanding, and visual question answering. Its unique strength lies in its “end-to-end” nature, avoiding potential errors introduced by separate OCR steps and achieving impressive accuracy with efficient processing. You can use Donut model in HuggingFace as follows:</li>",yt,L,ht,_,xs="<li><strong>Nougat:</strong> It is a visual transformer model, trained on millions of academic papers, that can directly “read” scanned PDFs and output their content in a structured markup language, even understanding complex elements like math equations and tables. It bypasses traditional Optical Character Recognition, achieving high accuracy while preserving semantics, making scientific knowledge stored in PDFs more accessible and usable. Nougat uses the same architecture as Donut, meaning an image Transformer encoder and an autoregressive text Transformer decoder to translate scientific PDFs to markdown, enabling easier access to them. You can use Nougat model in HuggingFace as follows:</li>",Mt,$,wt,S,ks='Learn more about how to train and use DocVQA models in HuggingFace <code>transformers</code> library <a href="https://huggingface.co/docs/transformers/tasks/document_question_answering" rel="nofollow">here</a>.',Jt,A,Tt,P,Vs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/image_captioning.png" alt="Image Captioning"/> <em>Example of Input (Image) and Output (Text) for the Image Captioning Model. <a href="#pretraining-paper">[1]</a></em>',bt,D,Cs="<li><strong>Inputs:</strong> <ul><li>Image: Image in various formats (e.g., JPEG, PNG).</li> <li>Pre-trained image feature extractor (optional): A pre-trained neural network that can extract meaningful features from images, such as a convolutional neural network (CNN).</li></ul></li> <li><strong>Outputs:</strong> Textual captions: Single Sentence or Paragraph that accurately describe the content of the input images, capturing objects, actions, relationships, and overall context. See the above example for the reference.</li> <li><strong>Task:</strong> To automatically generate natural language descriptions of images. This involves: (1) Understanding the visual content of the image (objects, actions, relationships). (2) Encoding this information into a meaningful representation. (3) Decoding this representation into a coherent, grammatically correct, and informative sentence or phrase.</li>",ft,K,Gs="Now, let’s look at some of the popular Image Captioning models in HuggingFace:",Ut,O,Rs="<li><strong>ViT-GPT2:</strong> It is a PyTorch model for generating image captions, built by combining Vision Transformer (ViT) for visual feature extraction and GPT-2 for text generation. Trained on the COCO dataset, it leverages ViT’s ability to encode rich image details and GPT-2’s fluency in language production to create accurate and descriptive captions. This open-source model offers an effective solution for image understanding and captioning tasks. You can use <strong>ViT-GPT2</strong> in HuggingFace as follows:</li>",vt,ee,jt,te,Hs="<li><strong>BLIP-Image-Captioning:</strong> It is a state-of-the-art image captioning model based on BLIP, a framework pre-trained on both clean and noisy web data for unified vision-language understanding and generation. It utilizes a bootstrapping process to filter out noisy captions, achieving improved performance on tasks like image captioning, image-text retrieval, and VQA. This large version, built with a ViT-L backbone, excels in generating accurate and detailed captions from images. You can use the BLIP Image Captioning model in HuggingFace as follows:</li>",It,se,Zt,ae,Xs="<li><strong>git-base:</strong> <code>microsoft/git-base</code> is a base-sized version of the GIT (GenerativeImage2Text) model, a Transformer decoder trained to generate text descriptions of images. It takes both image tokens and text tokens as input, predicting the next text token based on both the image and previous text. This makes it suitable for tasks like image and video captioning. Fine-tuned versions like <code>microsoft/git-base-coco</code> and <code>microsoft/git-base-textcaps</code> exist for specific datasets, while the base model offers a starting point for further customization. You can use git-base model in HuggingFace as follows:</li>",Bt,ne,Wt,le,Qs='Learn more about how to train and use Image Captioning models in HuggingFace <code>transformers</code> libraries <a href="https://huggingface.co/docs/transformers/v4.36.1/en/tasks/image_captioning" rel="nofollow">here.</a>',xt,ie,kt,oe,Ns='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/image_text_retrieval.png" alt="Image-Text Retrieval"/> <em>Example of Input (Text Query) and Output (Image) for the Text-to-Image Retrieval. <a href="#pretraining-paper">[1]</a></em>',Vt,re,Es="<li><strong>Inputs:</strong> <ul><li>Images: Image in various formats (e.g., JPEG, PNG).</li> <li>Text: Natural language text, usually in the form of captions, descriptions, or keywords associated with images.</li></ul></li> <li><strong>Outputs:</strong> <ul><li>Relevant images: When a text query is given, the system returns a ranked list of images most relevant to the text.</li> <li>Relevant text: When an image query is given, the system returns a ranked list of text descriptions or captions that best describe the image.</li></ul></li> <li><strong>Tasks:</strong> <ul><li>Image-to-text retrieval: Given an image as input, retrieve text descriptions or captions that accurately describe its content.</li> <li>Text-to-image retrieval: Given a text query, retrieve images that visually match the concepts and entities mentioned in the text.</li></ul></li>",Ct,pe,Ys="One of most popular model for the Image-Text Retrieval is CLIP.",Gt,ce,zs="<li><strong>CLIP (Contrastive Language-Image Pretraining):</strong> It excels in image-text retrieval by leveraging a shared embedding space. Through contrastive learning, it pretrains on large-scale image and text datasets, enabling the model to map diverse concepts into a common space. CLIP leverages a contrastive learning approach during pretraining, where it learns to map images and text into a shared embedding space. This shared space enables direct comparison between the two modalities, allowing for efficient and accurate retrieval tasks. In image-text retrieval, CLIP can be applied by encoding images and text into the shared embedding space, and the similarity between an image and a textual query is measured by the proximity of their respective embeddings.  The model’s versatility arises from its ability to grasp semantic relationships without task-specific fine-tuning, making it efficient for applications ranging from content-based image retrieval to interpreting natural language queries for images. You can use CLIP in HuggingFace for Image-Text retrieval as follows:</li>",Rt,ue,Ht,me,qs='Learn more about how to use CLIP for Image-Text retrieval in HuggingFace <a href="https://huggingface.co/docs/transformers/model_doc/clip#resources" rel="nofollow">here</a>.',Xt,de,Qt,ge,Fs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/visual_grounding.jpg" alt="Visual Grounding"/> <em>Example of Input (Image + Text) and Output (Bounding Boxes).(a) Phrase Grounding (b) Expression Comprehension. <a href="#pretraining-paper">[1]</a></em>',Nt,ye,Ls="<li><p><strong>Inputs:</strong></p> <ul><li>Image: A visual representation of a scene or object.</li> <li>Natural language query: A text description or question that refers to a specific part of the image.</li></ul></li> <li><p><strong>Output:</strong> Bounding box or segmentation mask: A spatial region within the image that corresponds to the object or area described in the query. This is typically represented as coordinates or a highlighted region.</p></li> <li><p><strong>Task:</strong> Locating the relevant object or region: The model must correctly identify the part of the image that matches the query. This involves understanding both the visual content of the image and the linguistic meaning of the query.</p></li>",Et,he,_s="Now, see some of the popular Visual Grounding (Object Detection) models in HuggingFace.",Yt,Me,$s="<li><strong>OWL-ViT:</strong> OWL-ViT (Vision Transformer for Open-World Localization) is a powerful object detection model built on a standard Vision Transformer architecture and trained on large-scale image-text pairs. It excels at “open-vocabulary” detection, meaning it can identify objects not present in its training data based on textual descriptions. By leveraging contrastive pre-training and fine-tuning, OWL-ViT achieves impressive performance in both zero-shot (text-guided) and one-shot (image-guided) detection tasks, making it a versatile tool for flexible search and identification in images. You can use OWL-ViT in HuggingFace as follows:</li>",zt,we,qt,Je,Ss=`<li><strong>Grounding DINO<a href="#grounding-dino">[3]</a>:</strong> It combines the Transformer-based object detector (DINO) with “grounded pre-training” to create a state-of-the-art, zero-shot object detection model. This means it can identify objects even if they weren’t in its training data, thanks to its ability to understand both images and human language inputs (like category names or descriptions). Its architecture combines text and image backbones, a feature enhancer, language-guided query selection, and a cross-modality decoder, achieving impressive results on benchmarks like COCO and LVIS. Essentially, Grounding DINO takes visual information, links it to textual descriptions, and then uses that understanding to pinpoint objects even within completely new categories.
You can try out the Grounding DINO model in the Google Colab <a href="https://colab.research.google.com/github/roboflow-ai/notebooks/blob/main/notebooks/zero-shot-object-detection-with-grounding-dino.ipynb" rel="nofollow">here</a>.</li>`,Ft,Te,Lt,be,As='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/text_image_generation.png" alt="Text-Image Generation"/> <em>Illustration of Auto-regressive and Diffusion Models for Text-Image Generation.<a href="#pretraining-paper">[1]</a></em>',_t,fe,Ps="<li><p><strong>Auto-regressive Models:</strong> These models treat the task like translating text descriptions into sequences of image tokens, similar to language models generating sentences. Like puzzle pieces, these tokens, created by image tokenizers like VQ-VAE, represent basic image features. The model uses an encoder-decoder architecture: the encoder extracts information from the text prompt, and the decoder, guided by this information, predicts one image token at a time, gradually building the final image pixel by pixel. This approach allows for high control and detail, but faces challenges in handling long, complex prompts and can be slower than alternative methods like diffusion models. The generation process is shown in the above figure (a).</p></li> <li><p><strong>Stable Diffusion Models:</strong> Stable Diffusion Models uses “Latent Diffusion” technique, where it builds images from noise by progressively denoising it, guided by a text prompt and a frozen CLIP text encoder. Its light architecture with a UNet backbone and CLIP encoder allows for GPU-powered image generation, while its latent focus reduces memory consumption. This unique setup empowers diverse artistic expression, translating textual inputs into photorealistic and imaginative visuals. The generation process is shown in the above figure (b).</p></li>",$t,Ue,Ds="Now, let’s how can we use text-image generation models in HuggingFace.",St,ve,Ks="Install <code>diffusers</code> library:",At,je,Pt,Ie,Os="In addition make sure to install transformers, safetensors, accelerate as well as the invisible watermark:",Dt,Ze,Kt,Be,ea="To just use the base model, you can run:",Ot,We,es,xe,ta='To learn more about text-image generation models, you can refer to the HuggingFace <a href="https://huggingface.co/docs/diffusers/training/overview" rel="nofollow">Diffusers Course</a>.',ts,ke,sa="Now you know what some of the popular tasks and models involving Image and Text modalities. But you might be wondering on how to train or fine-tune for the above mentioned tasks. So, let’s have a glimpse on training the Vision-Language models.",ss,Ve,as,Ce,aa='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/multimodal_fusion_text_vision/vlp_framework.png" alt="VLP Framework"/> <em>General framework for Transformer based vision-language models. <a href="#pretraining-paper">[1]</a></em>',ns,Ge,na="Given an image-text pair, a VL model first extracts text features via a text encoder and a vision encoder, respectively. The text and visual features are then fed into a multimodal fusion module to produce cross-modal representations, which are then optionally fed into a decoder before generating the final outputs. An illustration of this general framework is shown in the above figure. In many cases, there are no clear boundaries among image/text backbones, multimodal fusion module, and the decoder.",ls,Re,la="Congratulations! you made it till the end. Now on to the next section for more on Vision-Language Pretrained Models.",is,He,os,Xe,ia='<li><a href="https://arxiv.org/abs/2210.09263" rel="nofollow">Vision-Language Pre-training: Basics, Recent Advances, and Future Trends</a><a id="pretraining-paper"></a></li> <li><a href="https://arxiv.org/abs/2104.14336" rel="nofollow">Document Collection Visual Question Answering</a><a id="doc-vqa-paper"></a></li> <li><a href="https://arxiv.org/abs/2303.05499" rel="nofollow">Grounding DINO: Marrying DINO with Grounded Pre-Training for Open-Set Object Detection</a><a id="grounding-dino"></a></li>',rs,Qe,ps,Ee,cs;return w=new ha({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new h({props:{title:"Multimodal Tasks and Models",local:"multimodal-tasks-and-models",headingTag:"h1"}}),b=new h({props:{title:"Examples of Tasks",local:"examples-of-tasks",headingTag:"h2"}}),v=new h({props:{title:"Visual Question Anwering (VQA) and Visual Reasoning",local:"visual-question-anwering-vqa-and-visual-reasoning",headingTag:"h2"}}),V=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhX3BpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIydmlzdWFsLXF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEJTIyU2FsZXNmb3JjZSUyRmJsaXAtdnFhLWNhcGZpbHQtbGFyZ2UlMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKCUyMmVsZXBoYW50LmpwZWclMjIpJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJJcyUyMHRoZXJlJTIwYW4lMjBlbGVwaGFudCUzRiUyMiUwQSUwQXZxYV9waXBlbGluZShpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwdG9wX2slM0QxKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

vqa_pipeline = pipeline(
    <span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;Salesforce/blip-vqa-capfilt-large&quot;</span>
)

image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;elephant.jpeg&quot;</span>)
question = <span class="hljs-string">&quot;Is there an elephant?&quot;</span>

vqa_pipeline(image, question, top_k=<span class="hljs-number">1</span>)`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpeDJTdHJ1Y3RQcm9jZXNzb3IlMkMlMjBQaXgyU3RydWN0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBQaXgyU3RydWN0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZXBsb3QlMjIpJTBBbW9kZWwlMjAlM0QlMjBQaXgyU3RydWN0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZXBsb3QlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGdmlzLW5scCUyRkNoYXJ0UUElMkZtYWluJTJGQ2hhcnRRQSUyNTIwRGF0YXNldCUyRnZhbCUyRnBuZyUyRjUwOTAucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkdlbmVyYXRlJTIwdW5kZXJseWluZyUyMGRhdGElMjB0YWJsZSUyMG9mJTIwdGhlJTIwZmlndXJlJTIwYmVsb3clM0ElMjIlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQXByZWRpY3Rpb25zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiklMEFwcmludChwcm9jZXNzb3IuZGVjb2RlKHByZWRpY3Rpb25zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pix2StructProcessor, Pix2StructForConditionalGeneration
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

processor = Pix2StructProcessor.from_pretrained(<span class="hljs-string">&quot;google/deplot&quot;</span>)
model = Pix2StructForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/deplot&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/vis-nlp/ChartQA/main/ChartQA%20Dataset/val/png/5090.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

inputs = processor(
    images=image,
    text=<span class="hljs-string">&quot;Generate underlying data table of the figure below:&quot;</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
)
predictions = model.generate(**inputs, max_new_tokens=<span class="hljs-number">512</span>)
<span class="hljs-built_in">print</span>(processor.decode(predictions[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMkMlMjBWaWx0Rm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQSUyMyUyMHByZXBhcmUlMjBpbWFnZSUyMCUyQiUyMHF1ZXN0aW9uJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXRleHQlMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwY2F0cyUyMGFyZSUyMHRoZXJlJTNGJTIyJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyKSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWElMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKiplbmNvZGluZyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor, ViltForQuestionAnswering
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-comment"># prepare image + question</span>
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
text = <span class="hljs-string">&quot;How many cats are there?&quot;</span>

processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)

<span class="hljs-comment"># prepare inputs</span>
encoding = processor(image, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># forward pass</span>
outputs = model(**encoding)
logits = outputs.logits
idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])`,wrap:!1}}),Q=new h({props:{title:"Document Visual Question Answering (DocVQA)",local:"document-visual-question-answering-docvqa",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmRvY3VtZW50LXF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEJTIyaW1waXJhJTJGbGF5b3V0bG0tZG9jdW1lbnQtcWElMjIpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBwdXJjaGFzZSUyMGFtb3VudCUzRiUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbiglMjJ5b3VyLWRvY3VtZW50LnBuZyUyMiklMEElMEFwaXBlKGltYWdlJTNEaW1hZ2UlMkMlMjBxdWVzdGlvbiUzRHF1ZXN0aW9uKSUwQSUwQSUyMyUyMyUyMCU1QiU3QidhbnN3ZXInJTNBJTIwJzIwJTJDMDAwJTI0JyU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)

question = <span class="hljs-string">&quot;What is the purchase amount?&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;your-document.png&quot;</span>)

pipe(image=image, question=question)

<span class="hljs-comment">## [{&#x27;answer&#x27;: &#x27;20,000$&#x27;}]</span>`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmRvY3VtZW50LXF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEJTIybmF2ZXItY2xvdmEtaXglMkZkb251dC1iYXNlLWZpbmV0dW5lZC1kb2N2cWElMjIlMEEpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBwdXJjaGFzZSUyMGFtb3VudCUzRiUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbiglMjJ5b3VyLWRvY3VtZW50LnBuZyUyMiklMEElMEFwaXBlKGltYWdlJTNEaW1hZ2UlMkMlMjBxdWVzdGlvbiUzRHF1ZXN0aW9uKSUwQSUwQSUyMyUyMyUyMCU1QiU3QidhbnN3ZXInJTNBJTIwJzIwJTJDMDAwJTI0JyU3RCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

pipe = pipeline(
    <span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;naver-clova-ix/donut-base-finetuned-docvqa&quot;</span>
)

question = <span class="hljs-string">&quot;What is the purchase amount?&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;your-document.png&quot;</span>)

pipe(image=image, question=question)

<span class="hljs-comment">## [{&#x27;answer&#x27;: &#x27;20,000$&#x27;}]</span>`,wrap:!1}}),$=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NougatProcessor, VisionEncoderDecoderModel
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> torch

processor = NougatProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/nougat-base&quot;</span>)
model = VisionEncoderDecoderModel.from_pretrained(<span class="hljs-string">&quot;facebook/nougat-base&quot;</span>)

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
model.to(device)
<span class="hljs-comment"># prepare PDF image for the model</span>
filepath = hf_hub_download(
    repo_id=<span class="hljs-string">&quot;hf-internal-testing/fixtures_docvqa&quot;</span>,
    filename=<span class="hljs-string">&quot;nougat_paper.png&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)
image = Image.<span class="hljs-built_in">open</span>(filepath)
pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-comment"># generate transcription (here we only generate 30 tokens)</span>
outputs = model.generate(
    pixel_values.to(device),
    min_length=<span class="hljs-number">1</span>,
    max_new_tokens=<span class="hljs-number">30</span>,
    bad_words_ids=[[processor.tokenizer.unk_token_id]],
)

sequence = processor.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
sequence = processor.post_process_generation(sequence, fix_markdown=<span class="hljs-literal">False</span>)
<span class="hljs-comment"># note: we&#x27;re using repr here such for the sake of printing the \\n characters, feel free to just print the sequence</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">repr</span>(sequence))`,wrap:!1}}),A=new h({props:{title:"Image Captioning",local:"image-captioning",headingTag:"h2"}}),ee=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBaW1hZ2VfdG9fdGV4dCUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLXRvLXRleHQlMjIlMkMlMjBtb2RlbCUzRCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQSUwQWltYWdlX3RvX3RleHQoJTIyaHR0cHMlM0ElMkYlMkZhbmt1cjMxMDcuZ2l0aHViLmlvJTJGYXNzZXRzJTJGaW1hZ2VzJTJGaW1hZ2UtY2FwdGlvbmluZy1leGFtcGxlLnBuZyUyMiklMEElMEElMjMlMjAlNUIlN0InZ2VuZXJhdGVkX3RleHQnJTNBJTIwJ2ElMjBzb2NjZXIlMjBnYW1lJTIwd2l0aCUyMGElMjBwbGF5ZXIlMjBqdW1waW5nJTIwdG8lMjBjYXRjaCUyMHRoZSUyMGJhbGwlMjAnJTdEJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)

image_to_text(<span class="hljs-string">&quot;https://ankur3107.github.io/assets/images/image-captioning-example.png&quot;</span>)

<span class="hljs-comment"># [{&#x27;generated_text&#x27;: &#x27;a soccer game with a player jumping to catch the ball &#x27;}]</span>`,wrap:!1}}),se=new y({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcFByb2Nlc3NvciUyQyUyMEJsaXBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJTYWxlc2ZvcmNlJTJGYmxpcC1pbWFnZS1jYXB0aW9uaW5nLWxhcmdlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyU2FsZXNmb3JjZSUyRmJsaXAtaW1hZ2UtY2FwdGlvbmluZy1sYXJnZSUyMiUwQSklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZzdG9yYWdlLmdvb2dsZWFwaXMuY29tJTJGc2ZyLXZpc2lvbi1sYW5ndWFnZS1yZXNlYXJjaCUyRkJMSVAlMkZkZW1vLmpwZyUyMiUwQXJhd19pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUyMyUyMGNvbmRpdGlvbmFsJTIwaW1hZ2UlMjBjYXB0aW9uaW5nJTBBdGV4dCUyMCUzRCUyMCUyMmElMjBwaG90b2dyYXBoeSUyMG9mJTIyJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHJhd19pbWFnZSUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHByb2Nlc3Nvci5kZWNvZGUob3V0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjB1bmNvbmRpdGlvbmFsJTIwaW1hZ2UlMjBjYXB0aW9uaW5nJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHJhd19pbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQocHJvY2Vzc29yLmRlY29kZShvdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BlipProcessor, BlipForConditionalGeneration

processor = BlipProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip-image-captioning-large&quot;</span>)
model = BlipForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;Salesforce/blip-image-captioning-large&quot;</span>
)

img_url = <span class="hljs-string">&quot;https://storage.googleapis.com/sfr-vision-language-research/BLIP/demo.jpg&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(img_url, stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

<span class="hljs-comment"># conditional image captioning</span>
text = <span class="hljs-string">&quot;a photography of&quot;</span>
inputs = processor(raw_image, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs)
<span class="hljs-built_in">print</span>(processor.decode(out[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))

<span class="hljs-comment"># unconditional image captioning</span>
inputs = processor(raw_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs)
<span class="hljs-built_in">print</span>(processor.decode(out[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),ne=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGZ2l0LWJhc2UtY29jbyUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZnaXQtYmFzZS1jb2NvJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUocGl4ZWxfdmFsdWVzJTNEcGl4ZWxfdmFsdWVzJTJDJTIwbWF4X2xlbmd0aCUzRDUwKSUwQWdlbmVyYXRlZF9jYXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KGdlbmVyYXRlZF9jYXB0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/git-base-coco&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/git-base-coco&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

pixel_values = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

generated_ids = model.generate(pixel_values=pixel_values, max_length=<span class="hljs-number">50</span>)
generated_caption = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(generated_caption)`,wrap:!1}}),ie=new h({props:{title:"Image-Text Retrieval",local:"image-text-retrieval",headingTag:"h2"}}),ue=new y({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMzIlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ0xJUFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGY2xpcC12aXQtYmFzZS1wYXRjaDMyJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGRvZyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlcyUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTIwJTIwJTIzJTIwdGhpcyUyMGlzJTIwdGhlJTIwaW1hZ2UtdGV4dCUyMHNpbWlsYXJpdHklMjBzY29yZSUwQXByb2JzJTIwJTNEJTIwbG9naXRzX3Blcl9pbWFnZS5zb2Z0bWF4KCUwQSUyMCUyMCUyMCUyMGRpbSUzRDElMEEpJTIwJTIwJTIzJTIwd2UlMjBjYW4lMjB0YWtlJTIwdGhlJTIwc29mdG1heCUyMHRvJTIwZ2V0JTIwdGhlJTIwbGFiZWwlMjBwcm9iYWJpbGl0aWVz",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPProcessor, CLIPModel

model = CLIPModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)
processor = CLIPProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch32&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

inputs = processor(
    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>],
    images=image,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

outputs = model(**inputs)
logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
probs = logits_per_image.softmax(
    dim=<span class="hljs-number">1</span>
)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),de=new h({props:{title:"Visual Grounding",local:"visual-grounding",headingTag:"h2"}}),we=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OwlViTProcessor, OwlViTForObjectDetection

processor = OwlViTProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>)
model = OwlViTForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlvit-base-patch32&quot;</span>)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to COCO API</span>
results = processor.post_process_object_detection(
    outputs=outputs, threshold=<span class="hljs-number">0.1</span>, target_sizes=target_sizes
)

i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
text = texts[i]
boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]

<span class="hljs-comment"># Print detected objects and rescaled box coordinates</span>
<span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )`,wrap:!1}}),Te=new h({props:{title:"Text-to-Image Generation",local:"text-to-image-generation",headingTag:"h2"}}),je=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUyMC0tdXBncmFkZQ==",highlighted:"pip install diffusers --upgrade",wrap:!1}}),Ze=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGludmlzaWJsZV93YXRlcm1hcmslMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwc2FmZXRlbnNvcnM=",highlighted:"pip install invisible_watermark transformers accelerate safetensors",wrap:!1}}),We=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwdW5pY29ybiUyMiUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;An astronaut riding a unicorn&quot;</span>

images = pipe(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ve=new h({props:{title:"Glimpse of Vision-Language Pretrained Models",local:"glimpse-of-vision-language-pretrained-models",headingTag:"h2"}}),He=new h({props:{title:"References",local:"references",headingTag:"h2"}}),Qe=new Ma({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit4/multimodal-models/tasks-models-part1.mdx"}}),{c(){M=i("meta"),Ye=n(),Ne=i("p"),ze=n(),p(w.$$.fragment),qe=n(),p(J.$$.fragment),Fe=n(),T=i("p"),T.textContent=ms,Le=n(),p(b.$$.fragment),_e=n(),f=i("p"),f.textContent=ds,$e=n(),U=i("ul"),U.innerHTML=gs,Se=n(),p(v.$$.fragment),Ae=n(),j=i("p"),j.innerHTML=ys,Pe=n(),I=i("p"),I.innerHTML=hs,De=n(),Z=i("ul"),Z.innerHTML=Ms,Ke=n(),B=i("p"),B.innerHTML=ws,Oe=n(),W=i("ul"),W.innerHTML=Js,et=n(),x=i("p"),x.innerHTML=Ts,tt=n(),k=i("ul"),k.innerHTML=bs,st=n(),p(V.$$.fragment),at=n(),C=i("ul"),C.innerHTML=fs,nt=n(),p(G.$$.fragment),lt=n(),R=i("ul"),R.innerHTML=Us,it=n(),p(H.$$.fragment),ot=n(),X=i("p"),X.innerHTML=vs,rt=n(),p(Q.$$.fragment),pt=n(),N=i("p"),N.innerHTML=js,ct=n(),E=i("ul"),E.innerHTML=Is,ut=n(),Y=i("p"),Y.textContent=Zs,mt=n(),z=i("ul"),z.innerHTML=Bs,dt=n(),p(q.$$.fragment),gt=n(),F=i("ul"),F.innerHTML=Ws,yt=n(),p(L.$$.fragment),ht=n(),_=i("ul"),_.innerHTML=xs,Mt=n(),p($.$$.fragment),wt=n(),S=i("p"),S.innerHTML=ks,Jt=n(),p(A.$$.fragment),Tt=n(),P=i("p"),P.innerHTML=Vs,bt=n(),D=i("ul"),D.innerHTML=Cs,ft=n(),K=i("p"),K.textContent=Gs,Ut=n(),O=i("ul"),O.innerHTML=Rs,vt=n(),p(ee.$$.fragment),jt=n(),te=i("ul"),te.innerHTML=Hs,It=n(),p(se.$$.fragment),Zt=n(),ae=i("ul"),ae.innerHTML=Xs,Bt=n(),p(ne.$$.fragment),Wt=n(),le=i("p"),le.innerHTML=Qs,xt=n(),p(ie.$$.fragment),kt=n(),oe=i("p"),oe.innerHTML=Ns,Vt=n(),re=i("ul"),re.innerHTML=Es,Ct=n(),pe=i("p"),pe.textContent=Ys,Gt=n(),ce=i("ul"),ce.innerHTML=zs,Rt=n(),p(ue.$$.fragment),Ht=n(),me=i("p"),me.innerHTML=qs,Xt=n(),p(de.$$.fragment),Qt=n(),ge=i("p"),ge.innerHTML=Fs,Nt=n(),ye=i("ul"),ye.innerHTML=Ls,Et=n(),he=i("p"),he.textContent=_s,Yt=n(),Me=i("ul"),Me.innerHTML=$s,zt=n(),p(we.$$.fragment),qt=n(),Je=i("ul"),Je.innerHTML=Ss,Ft=n(),p(Te.$$.fragment),Lt=n(),be=i("p"),be.innerHTML=As,_t=n(),fe=i("ul"),fe.innerHTML=Ps,$t=n(),Ue=i("p"),Ue.textContent=Ds,St=n(),ve=i("p"),ve.innerHTML=Ks,At=n(),p(je.$$.fragment),Pt=n(),Ie=i("p"),Ie.textContent=Os,Dt=n(),p(Ze.$$.fragment),Kt=n(),Be=i("p"),Be.textContent=ea,Ot=n(),p(We.$$.fragment),es=n(),xe=i("p"),xe.innerHTML=ta,ts=n(),ke=i("p"),ke.textContent=sa,ss=n(),p(Ve.$$.fragment),as=n(),Ce=i("p"),Ce.innerHTML=aa,ns=n(),Ge=i("p"),Ge.textContent=na,ls=n(),Re=i("p"),Re.textContent=la,is=n(),p(He.$$.fragment),os=n(),Xe=i("ol"),Xe.innerHTML=ia,rs=n(),p(Qe.$$.fragment),ps=n(),Ee=i("p"),this.h()},l(e){const t=ga("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(s),Ye=l(e),Ne=o(e,"P",{}),oa(Ne).forEach(s),ze=l(e),c(w.$$.fragment,e),qe=l(e),c(J.$$.fragment,e),Fe=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1ubnshu"&&(T.textContent=ms),Le=l(e),c(b.$$.fragment,e),_e=l(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-ca9fx5"&&(f.textContent=ds),$e=l(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-xpykii"&&(U.innerHTML=gs),Se=l(e),c(v.$$.fragment,e),Ae=l(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1hh9njd"&&(j.innerHTML=ys),Pe=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-s9d6kc"&&(I.innerHTML=hs),De=l(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-x0cvpr"&&(Z.innerHTML=Ms),Ke=l(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-axri6l"&&(B.innerHTML=ws),Oe=l(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-n5vei9"&&(W.innerHTML=Js),et=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-b6374n"&&(x.innerHTML=Ts),tt=l(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-q9j6qy"&&(k.innerHTML=bs),st=l(e),c(V.$$.fragment,e),at=l(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-53weux"&&(C.innerHTML=fs),nt=l(e),c(G.$$.fragment,e),lt=l(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-ariid3"&&(R.innerHTML=Us),it=l(e),c(H.$$.fragment,e),ot=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-4880ds"&&(X.innerHTML=vs),rt=l(e),c(Q.$$.fragment,e),pt=l(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1n6nwx7"&&(N.innerHTML=js),ct=l(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-jreek6"&&(E.innerHTML=Is),ut=l(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-16mo7jb"&&(Y.textContent=Zs),mt=l(e),z=o(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-m7p4l8"&&(z.innerHTML=Bs),dt=l(e),c(q.$$.fragment,e),gt=l(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1h7k3zc"&&(F.innerHTML=Ws),yt=l(e),c(L.$$.fragment,e),ht=l(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-2zd0tc"&&(_.innerHTML=xs),Mt=l(e),c($.$$.fragment,e),wt=l(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-q3xdd0"&&(S.innerHTML=ks),Jt=l(e),c(A.$$.fragment,e),Tt=l(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-fvz37d"&&(P.innerHTML=Vs),bt=l(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-3smdc5"&&(D.innerHTML=Cs),ft=l(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1xajvou"&&(K.textContent=Gs),Ut=l(e),O=o(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-ocenfr"&&(O.innerHTML=Rs),vt=l(e),c(ee.$$.fragment,e),jt=l(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-mw0315"&&(te.innerHTML=Hs),It=l(e),c(se.$$.fragment,e),Zt=l(e),ae=o(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1iycfbd"&&(ae.innerHTML=Xs),Bt=l(e),c(ne.$$.fragment,e),Wt=l(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-zf82nr"&&(le.innerHTML=Qs),xt=l(e),c(ie.$$.fragment,e),kt=l(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1xil0oc"&&(oe.innerHTML=Ns),Vt=l(e),re=o(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-1pw6yhm"&&(re.innerHTML=Es),Ct=l(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-15dnx35"&&(pe.textContent=Ys),Gt=l(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-1awdq9i"&&(ce.innerHTML=zs),Rt=l(e),c(ue.$$.fragment,e),Ht=l(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-ixlk6u"&&(me.innerHTML=qs),Xt=l(e),c(de.$$.fragment,e),Qt=l(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1gfkkle"&&(ge.innerHTML=Fs),Nt=l(e),ye=o(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-feoxpq"&&(ye.innerHTML=Ls),Et=l(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1ywnzfn"&&(he.textContent=_s),Yt=l(e),Me=o(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-u6xetj"&&(Me.innerHTML=$s),zt=l(e),c(we.$$.fragment,e),qt=l(e),Je=o(e,"UL",{"data-svelte-h":!0}),r(Je)!=="svelte-1b7au05"&&(Je.innerHTML=Ss),Ft=l(e),c(Te.$$.fragment,e),Lt=l(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-xmg3gw"&&(be.innerHTML=As),_t=l(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-i5b273"&&(fe.innerHTML=Ps),$t=l(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-2w3lea"&&(Ue.textContent=Ds),St=l(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1s815ag"&&(ve.innerHTML=Ks),At=l(e),c(je.$$.fragment,e),Pt=l(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1d6rj20"&&(Ie.textContent=Os),Dt=l(e),c(Ze.$$.fragment,e),Kt=l(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1j6dsnv"&&(Be.textContent=ea),Ot=l(e),c(We.$$.fragment,e),es=l(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-4oqr2m"&&(xe.innerHTML=ta),ts=l(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-u5oywj"&&(ke.textContent=sa),ss=l(e),c(Ve.$$.fragment,e),as=l(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-16ymetk"&&(Ce.innerHTML=aa),ns=l(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-10v06df"&&(Ge.textContent=na),ls=l(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-139als7"&&(Re.textContent=la),is=l(e),c(He.$$.fragment,e),os=l(e),Xe=o(e,"OL",{"data-svelte-h":!0}),r(Xe)!=="svelte-zioxvd"&&(Xe.innerHTML=ia),rs=l(e),c(Qe.$$.fragment,e),ps=l(e),Ee=o(e,"P",{}),oa(Ee).forEach(s),this.h()},h(){ra(M,"name","hf:doc:metadata"),ra(M,"content",Ja)},m(e,t){ya(document.head,M),a(e,Ye,t),a(e,Ne,t),a(e,ze,t),u(w,e,t),a(e,qe,t),u(J,e,t),a(e,Fe,t),a(e,T,t),a(e,Le,t),u(b,e,t),a(e,_e,t),a(e,f,t),a(e,$e,t),a(e,U,t),a(e,Se,t),u(v,e,t),a(e,Ae,t),a(e,j,t),a(e,Pe,t),a(e,I,t),a(e,De,t),a(e,Z,t),a(e,Ke,t),a(e,B,t),a(e,Oe,t),a(e,W,t),a(e,et,t),a(e,x,t),a(e,tt,t),a(e,k,t),a(e,st,t),u(V,e,t),a(e,at,t),a(e,C,t),a(e,nt,t),u(G,e,t),a(e,lt,t),a(e,R,t),a(e,it,t),u(H,e,t),a(e,ot,t),a(e,X,t),a(e,rt,t),u(Q,e,t),a(e,pt,t),a(e,N,t),a(e,ct,t),a(e,E,t),a(e,ut,t),a(e,Y,t),a(e,mt,t),a(e,z,t),a(e,dt,t),u(q,e,t),a(e,gt,t),a(e,F,t),a(e,yt,t),u(L,e,t),a(e,ht,t),a(e,_,t),a(e,Mt,t),u($,e,t),a(e,wt,t),a(e,S,t),a(e,Jt,t),u(A,e,t),a(e,Tt,t),a(e,P,t),a(e,bt,t),a(e,D,t),a(e,ft,t),a(e,K,t),a(e,Ut,t),a(e,O,t),a(e,vt,t),u(ee,e,t),a(e,jt,t),a(e,te,t),a(e,It,t),u(se,e,t),a(e,Zt,t),a(e,ae,t),a(e,Bt,t),u(ne,e,t),a(e,Wt,t),a(e,le,t),a(e,xt,t),u(ie,e,t),a(e,kt,t),a(e,oe,t),a(e,Vt,t),a(e,re,t),a(e,Ct,t),a(e,pe,t),a(e,Gt,t),a(e,ce,t),a(e,Rt,t),u(ue,e,t),a(e,Ht,t),a(e,me,t),a(e,Xt,t),u(de,e,t),a(e,Qt,t),a(e,ge,t),a(e,Nt,t),a(e,ye,t),a(e,Et,t),a(e,he,t),a(e,Yt,t),a(e,Me,t),a(e,zt,t),u(we,e,t),a(e,qt,t),a(e,Je,t),a(e,Ft,t),u(Te,e,t),a(e,Lt,t),a(e,be,t),a(e,_t,t),a(e,fe,t),a(e,$t,t),a(e,Ue,t),a(e,St,t),a(e,ve,t),a(e,At,t),u(je,e,t),a(e,Pt,t),a(e,Ie,t),a(e,Dt,t),u(Ze,e,t),a(e,Kt,t),a(e,Be,t),a(e,Ot,t),u(We,e,t),a(e,es,t),a(e,xe,t),a(e,ts,t),a(e,ke,t),a(e,ss,t),u(Ve,e,t),a(e,as,t),a(e,Ce,t),a(e,ns,t),a(e,Ge,t),a(e,ls,t),a(e,Re,t),a(e,is,t),u(He,e,t),a(e,os,t),a(e,Xe,t),a(e,rs,t),u(Qe,e,t),a(e,ps,t),a(e,Ee,t),cs=!0},p:ca,i(e){cs||(m(w.$$.fragment,e),m(J.$$.fragment,e),m(b.$$.fragment,e),m(v.$$.fragment,e),m(V.$$.fragment,e),m(G.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(L.$$.fragment,e),m($.$$.fragment,e),m(A.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(Ze.$$.fragment,e),m(We.$$.fragment,e),m(Ve.$$.fragment,e),m(He.$$.fragment,e),m(Qe.$$.fragment,e),cs=!0)},o(e){d(w.$$.fragment,e),d(J.$$.fragment,e),d(b.$$.fragment,e),d(v.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d($.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(we.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(Ze.$$.fragment,e),d(We.$$.fragment,e),d(Ve.$$.fragment,e),d(He.$$.fragment,e),d(Qe.$$.fragment,e),cs=!1},d(e){e&&(s(Ye),s(Ne),s(ze),s(qe),s(Fe),s(T),s(Le),s(_e),s(f),s($e),s(U),s(Se),s(Ae),s(j),s(Pe),s(I),s(De),s(Z),s(Ke),s(B),s(Oe),s(W),s(et),s(x),s(tt),s(k),s(st),s(at),s(C),s(nt),s(lt),s(R),s(it),s(ot),s(X),s(rt),s(pt),s(N),s(ct),s(E),s(ut),s(Y),s(mt),s(z),s(dt),s(gt),s(F),s(yt),s(ht),s(_),s(Mt),s(wt),s(S),s(Jt),s(Tt),s(P),s(bt),s(D),s(ft),s(K),s(Ut),s(O),s(vt),s(jt),s(te),s(It),s(Zt),s(ae),s(Bt),s(Wt),s(le),s(xt),s(kt),s(oe),s(Vt),s(re),s(Ct),s(pe),s(Gt),s(ce),s(Rt),s(Ht),s(me),s(Xt),s(Qt),s(ge),s(Nt),s(ye),s(Et),s(he),s(Yt),s(Me),s(zt),s(qt),s(Je),s(Ft),s(Lt),s(be),s(_t),s(fe),s($t),s(Ue),s(St),s(ve),s(At),s(Pt),s(Ie),s(Dt),s(Kt),s(Be),s(Ot),s(es),s(xe),s(ts),s(ke),s(ss),s(as),s(Ce),s(ns),s(Ge),s(ls),s(Re),s(is),s(os),s(Xe),s(rs),s(ps),s(Ee)),s(M),g(w,e),g(J,e),g(b,e),g(v,e),g(V,e),g(G,e),g(H,e),g(Q,e),g(q,e),g(L,e),g($,e),g(A,e),g(ee,e),g(se,e),g(ne,e),g(ie,e),g(ue,e),g(de,e),g(we,e),g(Te,e),g(je,e),g(Ze,e),g(We,e),g(Ve,e),g(He,e),g(Qe,e)}}}const Ja='{"title":"Multimodal Tasks and Models","local":"multimodal-tasks-and-models","sections":[{"title":"Examples of Tasks","local":"examples-of-tasks","sections":[],"depth":2},{"title":"Visual Question Anwering (VQA) and Visual Reasoning","local":"visual-question-anwering-vqa-and-visual-reasoning","sections":[],"depth":2},{"title":"Document Visual Question Answering (DocVQA)","local":"document-visual-question-answering-docvqa","sections":[],"depth":2},{"title":"Image Captioning","local":"image-captioning","sections":[],"depth":2},{"title":"Image-Text Retrieval","local":"image-text-retrieval","sections":[],"depth":2},{"title":"Visual Grounding","local":"visual-grounding","sections":[],"depth":2},{"title":"Text-to-Image Generation","local":"text-to-image-generation","sections":[],"depth":2},{"title":"Glimpse of Vision-Language Pretrained Models","local":"glimpse-of-vision-language-pretrained-models","sections":[],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Ta(us){return ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends ma{constructor(M){super(),da(this,M,Ta,wa,pa,{})}}export{Ia as component};
