import{s as ft,a as Mt,n as gt,o as wt}from"../chunks/scheduler.35aab934.js";import{S as yt,i as Jt,e as n,s as i,c as d,q as Ve,H as bt,h as Tt,a as o,d as a,b as l,f as Re,g as u,j as r,r as Ce,u as Zt,k as J,l as q,m as s,n as c,t as h,o as f,p as M}from"../chunks/index.de17b971.js";import{C as Ut}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as Xe}from"../chunks/CodeBlock.c1f62de5.js";import{H as Se,E as Wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function jt(Le){let g,ee,K,te,b,ae,T,se,Z,Qe=`This chapter introduces the building blocks of Stable Diffusion which is a generative artificial intelligence (generative AI) model that produces unique photorealistic images from text and image prompts. It originally launched in 2022 and was made possible thanks to a collaboration with
<a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://runwayml.com/" rel="nofollow">RunwayML</a> and CompVis Group at LMU Munich following the <a href="https://arxiv.org/pdf/2112.10752.pdf" rel="nofollow">paper</a>.`,ie,U,ze="What will you learn from this chapter?",le,W,Ne="<li>Fundamental components of Stable Diffusion</li> <li>How to use <code>text-to-image</code>, <code>image2image</code>, inpainting pipelines</li>",ne,j,oe,v,Ae=`To make this section interesting we will try to answer some questions to understand the basic components of the Stable Diffusion process.
We will briefly discuss each component as they are already covered in our Diffusers course. Also, you can visit our previous section, which talks about GANS and Diffusion models in details.`,re,k,De=`<li>What strategies does Stable Diffusion employ to learn new information?
<ul><li>It uses forward and reverse processes of diffusion models. In the forward process, we add Gaussian noise to an image until all that remains is the random noise. Usually we cannot identify the final noisy version of the image.</li> <li>In the reserve process, we have a learned neural network trained to gradually denoise an image starting from pure noise, until you end up with an actual image.</li></ul></li>`,me,m,$e,P,qe="T",Ye,pe,ht='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>t</mi><mn>0</mn></msub></mrow><annotation encoding="application/x-tex">t_0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7651em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">t</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',de,w,Pe="Hugging Face Blog",Ee,ue,I,Ke="<li>Since our images can be huge how can we compress it?</li>",ce,B,Oe=`When you have large images, they require more computing power to process. This becomes very noticeable in a specific operation known as self-attention. The bigger the image, the more calculations are needed, and these calculations increase very quickly (in a way mathematicians call “quadratically”) with the size of the image.
For example, if you have an image that’s 128 pixels wide and tall, it has four times more pixels than an image that’s only 64 pixels wide and tall. Because of how self-attention works, dealing with this larger image doesn’t just need four times more memory and computing power, it actually needs sixteen times more (since 4 times 4 equals 16). This makes it challenging to work with very high-resolution images, as they require a lot of resources to process.
Latent diffusion models address the high computational demands of processing large images by using a Variational Auto-Encoder (VAE) to shrink the images into a more manageable size. The idea is that many images have repetitive or unnecessary information. A VAE, after being trained on a lot of data, can compress an image into a much smaller, condensed form. This smaller version still retains the essential features of the original image.`,he,G,et="<li>How are we fusing texts with images since we are using prompts?</li>",fe,x,tt=`We know that during inference time, we can feed in the description of an image we’d like to see and some pure noise as a starting point, and the model does its best to ‘denoise’ the random input into something that matches the caption.
SD leverages a pre-trained transformer model based on something called <a href="https://huggingface.co/learn/computer-vision-course/unit4/multimodal-models/clip-and-relatives/clip" rel="nofollow">CLIP</a>. CLIP’s text encoder was designed to process image captions into a form that could be used to compare images and text, so it is well suited to the task of creating useful representations from image descriptions. An input prompt is first tokenized (based on a large vocabulary where each word or sub-word is assigned a specific token) and then fed through the CLIP text encoder, producing a 768-dimensional (in the case of SD 1.X) or 1024-dimensional (SD 2.X) vector for each token. To keep things consistent prompts are always padded/truncated to be 77 tokens long, and so the final representation which we use as conditioning is a tensor of shape 77x1024 per prompt.`,Me,_,at="<li>How can we add-in good inductive biases?</li>",ge,F,st=`Since, we are trying to generate something new(e.g., a realistic Pokemon), we need a way to go beyond the images we have seen before(e.g., an anime Pokemon). That’s where U-Net and self-attention come into the picture. Given a noisy version of an image, the model is tasked with predicting the denoised version based on additional clues such as a text description of the image. Ok, how do we actually feed this conditioning information into the U-Net for it to use as it makes predictions? The answer is something called cross-attention. Scattered throughout the U-Net are cross-attention layers.
Each spatial location in the U-Net can ‘attend’ to different tokens in the text conditioning, bringing in relevant information from the prompt.`,we,H,ye,V,it='This section introduces helpful usecases and how we can perform these tasks using the <a href="https://github.com/huggingface/diffusers" rel="nofollow">Diffusers</a> library.',Je,C,lt=`<li>Steps for <code>text-to-image</code> inference
The idea is to pass in the text prompt, which is converted to the output image.</li>`,be,p,nt="",ot,Te,X,rt="Using the <code>diffusers</code> library you can get <code>text-to-image</code> working in 2 steps.",Ze,S,mt="Let’s install the <code>diffusers</code> library first.",Ue,$,We,Y,pt="We will now initialize the pipeline and pass our prompt inside and infer.",je,E,ve,R,dt=`<li>Steps for image-to-image inference
In similar fashion, we can initialize the pipeline, but pass an image and a text prompt instead.</li>`,ke,L,Ie,Q,ut=`<li>Steps for Inpainting
For inpainting pipeline, we need to pass an image, a text prompt, and a mask based on an object in that image, which indicates what to inpaint in the image.
In this example we also pass a negative prompt to further influence the inference on what we want to avoid.</li>`,Be,z,Ge,N,xe,A,ct='<li><a href="https://huggingface.co/docs/diffusers/using-diffusers/pipeline_overview" rel="nofollow">Diffusers documentation</a></li> <li><a href="https://huggingface.co/docs/diffusers/installation" rel="nofollow">Diffusers installation</a></li>',_e,D,Fe,O,He;return b=new Ut({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new Se({props:{title:"Introduction to Stable Diffusion",local:"introduction-to-stable-diffusion",headingTag:"h1"}}),j=new Se({props:{title:"What Do We Need for Stable Diffusion to Work?",local:"what-do-we-need-for-stable-diffusion-to-work",headingTag:"h2"}}),H=new Se({props:{title:"How to use text-to-image , image-to-image , Inpainting Models in Diffusers",local:"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers",headingTag:"h2"}}),$=new Xe({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),E=new Xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMzEpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">31</span>)
image = pipeline(
    <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new Xe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTIzJTIwcmVtb3ZlJTIwZm9sbG93aW5nJTIwbGluZSUyMGlmJTIweEZvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZCUyMG9yJTIweW91JTIwaGF2ZSUyMFB5VG9yY2glMjAyLjAlMjBvciUyMGhpZ2hlciUyMGluc3RhbGxlZCUwQXBpcGVsaW5lLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBJTIzJTIwTG9hZCUyMGFuJTIwaW1hZ2UlMjB0byUyMHBhc3MlMjB0byUyMHRoZSUyMHBpcGVsaW5lJTNBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY2F0LnBuZyUyMiUwQSklMEElMEElMjMlMjBQYXNzJTIwYSUyMHByb21wdCUyMGFuZCUyMGltYWdlJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMHRvJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTNBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY2F0JTIwd2l6YXJkJTJDJTIwZ2FuZGFsZiUyQyUyMGxvcmQlMjBvZiUyMHRoZSUyMHJpbmdzJTJDJTIwZGV0YWlsZWQlMkMlMjBmYW50YXN5JTJDJTIwY3V0ZSUyQyUyMGFkb3JhYmxlJTJDJTIwUGl4YXIlMkMlMjBEaXNuZXklMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1QmluaXRfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load an image to pass to the pipeline:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>
)

<span class="hljs-comment"># Pass a prompt and image to the pipeline to generate an image:</span>
prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>
image = pipeline(prompt, image=init_image).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),z=new Xe({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the pipeline</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipeline = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipeline.enable_model_cpu_offload()
<span class="hljs-comment"># remove following line if xFormers is not installed or you have PyTorch 2.0 or higher installed</span>
pipeline.enable_xformers_memory_efficient_attention()

<span class="hljs-comment"># Load the base and mask images:</span>
init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>
)
mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>
)

<span class="hljs-comment"># Create a prompt to inpaint the image with and pass it to the pipeline with the base and mask images:</span>
prompt = (
    <span class="hljs-string">&quot;a black cat with glowing eyes, cute, adorable, disney, pixar, highly detailed, 8k&quot;</span>
)
negative_prompt = <span class="hljs-string">&quot;bad anatomy, deformed, ugly, disfigured&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=init_image,
    mask_image=mask_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`,wrap:!1}}),N=new Se({props:{title:"Further Reading",local:"further-reading",headingTag:"h3"}}),D=new Wt({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit5/generative-models/diffusion-models/stable-diffusion.mdx"}}),{c(){g=n("meta"),ee=i(),K=n("p"),te=i(),d(b.$$.fragment),ae=i(),d(T.$$.fragment),se=i(),Z=n("p"),Z.innerHTML=Qe,ie=i(),U=n("p"),U.textContent=ze,le=i(),W=n("ul"),W.innerHTML=Ne,ne=i(),d(j.$$.fragment),oe=i(),v=n("p"),v.textContent=Ae,re=i(),k=n("ul"),k.innerHTML=De,me=i(),m=n("p"),$e=Ve("Both of these processes happens for a finite number of steps "),P=n("code"),P.textContent=qe,Ye=Ve("(as per DDPM paper T=1000). You begin the process at time"),pe=new bt(!1),de=Ve(" by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),w=n("a"),w.textContent=Pe,Ee=Ve(" on Diffusion Models."),ue=i(),I=n("ul"),I.innerHTML=Ke,ce=i(),B=n("p"),B.textContent=Oe,he=i(),G=n("ul"),G.innerHTML=et,fe=i(),x=n("p"),x.innerHTML=tt,Me=i(),_=n("ul"),_.innerHTML=at,ge=i(),F=n("p"),F.textContent=st,we=i(),d(H.$$.fragment),ye=i(),V=n("p"),V.innerHTML=it,Je=i(),C=n("ul"),C.innerHTML=lt,be=i(),p=n("iframe"),p.innerHTML=nt,Te=i(),X=n("p"),X.innerHTML=rt,Ze=i(),S=n("p"),S.innerHTML=mt,Ue=i(),d($.$$.fragment),We=i(),Y=n("p"),Y.textContent=pt,je=i(),d(E.$$.fragment),ve=i(),R=n("ul"),R.innerHTML=dt,ke=i(),d(L.$$.fragment),Ie=i(),Q=n("ul"),Q.innerHTML=ut,Be=i(),d(z.$$.fragment),Ge=i(),d(N.$$.fragment),xe=i(),A=n("ul"),A.innerHTML=ct,_e=i(),d(D.$$.fragment),Fe=i(),O=n("p"),this.h()},l(e){const t=Tt("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(a),ee=l(e),K=o(e,"P",{}),Re(K).forEach(a),te=l(e),u(b.$$.fragment,e),ae=l(e),u(T.$$.fragment,e),se=l(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-z66int"&&(Z.innerHTML=Qe),ie=l(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1sm6n8h"&&(U.textContent=ze),le=l(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-15b6ktr"&&(W.innerHTML=Ne),ne=l(e),u(j.$$.fragment,e),oe=l(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-15v5s0q"&&(v.textContent=Ae),re=l(e),k=o(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-i7hn3j"&&(k.innerHTML=De),me=l(e),m=o(e,"P",{});var y=Re(m);$e=Ce(y,"Both of these processes happens for a finite number of steps "),P=o(y,"CODE",{"data-svelte-h":!0}),r(P)!=="svelte-18tc35m"&&(P.textContent=qe),Ye=Ce(y,"(as per DDPM paper T=1000). You begin the process at time"),pe=Zt(y,!1),de=Ce(y," by sampling a real image from your data distribution, and the forward process samples some noise from a Gaussian distribution at each time step t, which is added to the image of the previous time step. To get more mathematical intuition, please read "),w=o(y,"A",{href:!0,rel:!0,"data-svelte-h":!0}),r(w)!=="svelte-1h13rvl"&&(w.textContent=Pe),Ee=Ce(y," on Diffusion Models."),y.forEach(a),ue=l(e),I=o(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-nhvgmx"&&(I.innerHTML=Ke),ce=l(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ghqky8"&&(B.textContent=Oe),he=l(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-wgoof5"&&(G.innerHTML=et),fe=l(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1xqaret"&&(x.innerHTML=tt),Me=l(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1gci2og"&&(_.innerHTML=at),ge=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ceb1g8"&&(F.textContent=st),we=l(e),u(H.$$.fragment,e),ye=l(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1tbjqci"&&(V.innerHTML=it),Je=l(e),C=o(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-4vkcyc"&&(C.innerHTML=lt),be=l(e),p=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),r(p)!=="svelte-1du1c08"&&(p.innerHTML=nt),Te=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1xlt128"&&(X.innerHTML=rt),Ze=l(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-3yyytc"&&(S.innerHTML=mt),Ue=l(e),u($.$$.fragment,e),We=l(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-18bx7u2"&&(Y.textContent=pt),je=l(e),u(E.$$.fragment,e),ve=l(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-k07d6l"&&(R.innerHTML=dt),ke=l(e),u(L.$$.fragment,e),Ie=l(e),Q=o(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-3vw8pj"&&(Q.innerHTML=ut),Be=l(e),u(z.$$.fragment,e),Ge=l(e),u(N.$$.fragment,e),xe=l(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-cvv663"&&(A.innerHTML=ct),_e=l(e),u(D.$$.fragment,e),Fe=l(e),O=o(e,"P",{}),Re(O).forEach(a),this.h()},h(){J(g,"name","hf:doc:metadata"),J(g,"content",vt),pe.a=de,J(w,"href","https://huggingface.co/blog/annotated-diffusion"),J(w,"rel","nofollow"),Mt(p.src,ot="https://hysts-controlnet-v1-1.hf.space/")||J(p,"src",ot),J(p,"frameborder","0"),J(p,"width","850"),J(p,"height","450")},m(e,t){q(document.head,g),s(e,ee,t),s(e,K,t),s(e,te,t),c(b,e,t),s(e,ae,t),c(T,e,t),s(e,se,t),s(e,Z,t),s(e,ie,t),s(e,U,t),s(e,le,t),s(e,W,t),s(e,ne,t),c(j,e,t),s(e,oe,t),s(e,v,t),s(e,re,t),s(e,k,t),s(e,me,t),s(e,m,t),q(m,$e),q(m,P),q(m,Ye),pe.m(ht,m),q(m,de),q(m,w),q(m,Ee),s(e,ue,t),s(e,I,t),s(e,ce,t),s(e,B,t),s(e,he,t),s(e,G,t),s(e,fe,t),s(e,x,t),s(e,Me,t),s(e,_,t),s(e,ge,t),s(e,F,t),s(e,we,t),c(H,e,t),s(e,ye,t),s(e,V,t),s(e,Je,t),s(e,C,t),s(e,be,t),s(e,p,t),s(e,Te,t),s(e,X,t),s(e,Ze,t),s(e,S,t),s(e,Ue,t),c($,e,t),s(e,We,t),s(e,Y,t),s(e,je,t),c(E,e,t),s(e,ve,t),s(e,R,t),s(e,ke,t),c(L,e,t),s(e,Ie,t),s(e,Q,t),s(e,Be,t),c(z,e,t),s(e,Ge,t),c(N,e,t),s(e,xe,t),s(e,A,t),s(e,_e,t),c(D,e,t),s(e,Fe,t),s(e,O,t),He=!0},p:gt,i(e){He||(h(b.$$.fragment,e),h(T.$$.fragment,e),h(j.$$.fragment,e),h(H.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(L.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(D.$$.fragment,e),He=!0)},o(e){f(b.$$.fragment,e),f(T.$$.fragment,e),f(j.$$.fragment,e),f(H.$$.fragment,e),f($.$$.fragment,e),f(E.$$.fragment,e),f(L.$$.fragment,e),f(z.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),He=!1},d(e){e&&(a(ee),a(K),a(te),a(ae),a(se),a(Z),a(ie),a(U),a(le),a(W),a(ne),a(oe),a(v),a(re),a(k),a(me),a(m),a(ue),a(I),a(ce),a(B),a(he),a(G),a(fe),a(x),a(Me),a(_),a(ge),a(F),a(we),a(ye),a(V),a(Je),a(C),a(be),a(p),a(Te),a(X),a(Ze),a(S),a(Ue),a(We),a(Y),a(je),a(ve),a(R),a(ke),a(Ie),a(Q),a(Be),a(Ge),a(xe),a(A),a(_e),a(Fe),a(O)),a(g),M(b,e),M(T,e),M(j,e),M(H,e),M($,e),M(E,e),M(L,e),M(z,e),M(N,e),M(D,e)}}}const vt='{"title":"Introduction to Stable Diffusion","local":"introduction-to-stable-diffusion","sections":[{"title":"What Do We Need for Stable Diffusion to Work?","local":"what-do-we-need-for-stable-diffusion-to-work","sections":[],"depth":2},{"title":"How to use text-to-image , image-to-image , Inpainting Models in Diffusers","local":"how-to-use-text-to-image--image-to-image--inpainting-models-in-diffusers","sections":[{"title":"Further Reading","local":"further-reading","sections":[],"depth":3}],"depth":2}],"depth":1}';function kt(Le){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ft extends yt{constructor(g){super(),Jt(this,g,kt,jt,ft,{})}}export{Ft as component};
