import{s as Ml,n as hl,o as cl}from"../chunks/scheduler.35aab934.js";import{S as yl,i as ul,e as i,s as a,c as m,h as fl,a as p,d as s,b as n,f as ol,g as o,j as r,k as Us,l as wl,m as l,n as M,t as h,o as c,p as y}from"../chunks/index.de17b971.js";import{C as Tl}from"../chunks/CopyLLMTxtMenu.48bc5cc2.js";import{C as u}from"../chunks/CodeBlock.c1f62de5.js";import{H as Ts,E as Ul}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8fdece89.js";function Jl(Js){let f,Ee,Le,Ye,T,Ve,U,Xe,J,ds="How can we match detected features from one image to another? Feature matching involves comparing key attributes in different images to find similarities. Feature matching is useful in many computer vision applications, including scene understanding, image stitching, object tracking, and pattern recognition.",De,d,He,b,bs="Imagine you have a giant box of puzzle pieces, and you’re trying to find a specific piece that fits into your puzzle. This is similar to searching for matching features in images. Instead of having any special strategy, you decide to check every piece, one by one until you find the right one. This straightforward method is a brute-force search. The advantage of brute force is its simplicity. You don’t need any special tricks – just patience. However, it can be time-consuming, especially if there are a lot of pieces to check. In the context of feature matching, this brute force approach is akin to comparing every pixel in one image to every pixel in another to see if they match. It’s exhaustive and it might take a lot of time, especially for large images.",Ke,g,gs="Now that we have an intuitive idea of how brute-force matches are found, let’s dive into the algorithms. We are going to use the descriptors that we learned about in the previous chapter to find the matching features in two images.",Pe,C,Cs="First install and load libraries.",qe,j,Oe,$,et,k,js="<strong>Brute Force with SIFT</strong>",tt,I,$s="Let’s start by initializing SIFT detector.",st,v,lt,x,ks="Find the keypoints and descriptors with SIFT.",at,R,nt,N,Is="Find matches using k nearest neighbors.",it,B,pt,F,vs="Apply ratio test to threshold the best matches.",rt,G,mt,S,xs="Draw the matches.",ot,_,Mt,w,Rs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/SIFT.png" alt="SIFT"/>',ht,z,Ns="<strong>Brute Force with ORB (binary) descriptors</strong>",ct,Z,Bs="Initialize the ORB descriptor.",yt,Q,ut,W,Fs="Find keypoints and descriptors.",ft,L,wt,A,Gs=`Because ORB is a binary descriptor, we find matches using <a href="https://www.geeksforgeeks.org/hamming-distance-two-strings/" rel="nofollow">Hamming Distance</a>,
which is a measure of the difference between two strings of equal length.`,Tt,E,Ut,Y,Ss="We will now find the matches.",Jt,V,dt,X,_s="We can sort them in the order of their distance like the following.",bt,D,gt,H,zs="Draw first n matches.",Ct,K,jt,P,Zs="<strong>Fast Library for Approximate Nearest Neighbors (FLANN)</strong>",$t,q,Qs=`FLANN was proposed in <a href="https://www.cs.ubc.ca/research/flann/uploads/FLANN/flann_visapp09.pdf" rel="nofollow">Fast Approximate Nearest Neighbors With Automatic Algorithm Configuration</a> by Muja and Lowe. To explain FLANN, we will continue with our puzzle solving example. Visualize a giant puzzle with hundreds of pieces scattered around. Your goal is to organize these pieces based on how well they fit together. Instead of randomly trying to match pieces,
FLANN uses some clever tricks to quickly figure out which pieces are most likely to go together. Instead of trying every piece against every other piece, FLANN streamlines the process by finding pieces that are approximately similar. This means it can make educated guesses about which pieces might fit well together, even if they’re not an exact match. Under the hood, FLANN is uses something called k-D trees. Think of it as organizing the puzzle pieces in a special way. Instead of checking every piece against every other piece, FLANN arranges them in a tree-like structure that makes finding matches faster. In each node of the k-D tree, FLANN puts pieces with similar features together. It’s like sorting puzzle pieces with similar shapes or colors into piles. This way, when you’re looking for a match, you can quickly check the pile that’s most likely to have similar pieces. Let’s say you’re looking for a “sky” piece. Instead of searching through all the pieces, FLANN guides you to the right spot in the k-D tree where the sky-colored pieces are sorted. FLANN also adjusts its strategy based on the features of the puzzle pieces. If you have a puzzle with lots of colors, it will focus on color features. Alternately, if it’s a puzzle with intricate shapes, it pays attention to those shapes. By balancing speed and accuracy when finding matching features, FLANN substantially improves query time.`,kt,O,Ws="First, we create a dictionary to specify the algorithm we will use, for SIFT or SURF it looks like the following.",It,ee,vt,te,Ls="For ORB, will use the parameters from the paper.",xt,se,Rt,le,As="We also create a dictionary to specify the maximum leafs to visit as follows.",Nt,ae,Bt,ne,Es="Initiate SIFT detector.",Ft,ie,Gt,pe,Ys="Find the keypoints and descriptors with SIFT.",St,re,_t,me,Vs="We will now define the FLANN parameters. Here, trees is the number of bins you want.",zt,oe,Zt,Me,Xs="We will only draw good matches, so create a mask.",Qt,he,Wt,ce,Ds="We can perform a ratio test to determine good matches.",Lt,ye,At,ue,Hs="Now let’s visualize the matches.",Et,fe,Yt,we,Ks='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/FLANN.png" alt="FLANN"/>',Vt,Te,Xt,Ue,Ps=`LoFTR was proposed in <a href="https://arxiv.org/pdf/2104.00680.pdf" rel="nofollow">LoFTR: Detector-Free Local Feature Matching with Transformers</a> by Sun, et. al.
Instead of using feature detectors, LoFTR uses a learning-based approach to feature matching.`,Dt,Je,qs=`Let’s keep it simple and use our puzzle example once again. Instead of simply comparing images pixel by pixel, LoFTR looks for specific key points, or features, in each image. It’s like identifying the corners and edges of each puzzle piece. And just as someone really good a putting together a puzzle might focus on distinctive marks, LoFTR identifies these unique points in one image. These could be key landmarks or structures that stand out. As we have already learned, it is important that the matching algorithm handles changes in rotation or scale. If a feature is turned or resized, LoFTR would still recognize it. It’s like solving puzzles where pieces may be flipped or adjusted. As LoFTR matches features, it assigns a similarity score to indicate how well the features align. Higher scores mean better matches. It’s like giving a grade to how well one puzzle piece fits with another.
LoFTR is also invariant to certain transformations, meaning it can handle variations in lighting, angle, or perspective. This is crucial when dealing with images that might be photographed under different conditions. LoFTR’s ability to robustly match features makes it valuable for tasks like image stitching, where you combine multiple images seamlessly by identifying and connecting common features.`,Ht,de,Os='We can use <a href="https://github.com/kornia/kornia" rel="nofollow">Kornia</a> to find matching features in two images using LoFTR.',Kt,be,Pt,ge,el="Import the necessary libraries.",qt,Ce,Ot,je,tl="Load and resize the images.",es,$e,ts,ke,sl="Indicate whether the image is an “indoor” or “outdoor” image.",ss,Ie,ls,ve,ll="LoFTR only works on grayscale images, so convert to images to grayscale.",as,xe,ns,Re,al="Let’s perform the inference.",is,Ne,ps,Be,nl='Clean up the correspondences using Random Sample Consensus (<a href="https://en.wikipedia.org/wiki/Random_sample_consensus" rel="nofollow">RANSAC</a>). This helps to deal with noise or outliers in the data.',rs,Fe,ms,Ge,il="Finally, we can visualize the matches.",os,Se,Ms,_e,pl="The best matches are visualized in green, while less certain matches are in blue.",hs,ze,rl='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/LoFTR.png" alt="LoFTR"/>',cs,Ze,ys,Qe,ml='<li><a href="https://github.com/flann-lib/flann" rel="nofollow">FLANN Github</a></li> <li><a href="https://arxiv.org/pdf/1710.02726.pdf" rel="nofollow">Image Matching Using SIFT, SURF, BRIEF and ORB: Performance Comparison for Distorted Images</a></li> <li><a href="https://docs.opencv.org/4.x/d1/d89/tutorial_py_orb.html" rel="nofollow">ORB (Oriented FAST and Rotated BRIEF) tutorial</a></li> <li><a href="https://kornia.github.io/tutorials/nbs/image_matching.html" rel="nofollow">Kornia tutorial on Image Matching</a></li> <li><a href="https://github.com/zju3dv/LoFTR" rel="nofollow">LoFTR Github</a></li> <li><a href="https://github.com/opencv/opencv-python" rel="nofollow">OpenCV Github</a></li> <li><a href="https://docs.opencv.org/4.x/dc/dc3/tutorial_py_matcher.html" rel="nofollow">OpenCV Feature Matching Tutorial</a></li> <li><a href="https://arxiv.org/abs/2204.08870" rel="nofollow">OpenGlue: Open Source Graph Neural Net Based Pipeline for Image Matching</a></li>',us,We,fs,Ae,ws;return T=new Tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new Ts({props:{title:"Feature Matching",local:"feature-matching",headingTag:"h1"}}),d=new Ts({props:{title:"Brute-Force Search",local:"brute-force-search",headingTag:"h2"}}),j=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcGVuY3YtcHl0aG9u",highlighted:"!pip install opencv-python",wrap:!1}}),$=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5w",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np`,wrap:!1}}),v=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2Mi5TSUZUX2NyZWF0ZSgp",highlighted:"sift = cv2.SIFT_create()",wrap:!1}}),R=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),B=new u({props:{code:"YmYlMjAlM0QlMjBjdjIuQkZNYXRjaGVyKCklMEFtYXRjaGVzJTIwJTNEJTIwYmYua25uTWF0Y2goZGVzMSUyQyUyMGRlczIlMkMlMjBrJTNEMik=",highlighted:`bf = cv2.BFMatcher()
matches = bf.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),G=new u({props:{code:"Z29vZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG0lMkMlMjBuJTIwaW4lMjBtYXRjaGVzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBtLmRpc3RhbmNlJTIwJTNDJTIwMC43NSUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ29vZC5hcHBlbmQoJTVCbSU1RCk=",highlighted:`good = []
<span class="hljs-keyword">for</span> m, n <span class="hljs-keyword">in</span> matches:
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.75</span> * n.distance:
        good.append([m])`,wrap:!1}}),_=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2Mi5kcmF3TWF0Y2hlc0tubiglMEElMjAlMjAlMjAlMjBpbWcxJTJDJTIwa3AxJTJDJTIwaW1nMiUyQyUyMGtwMiUyQyUyMGdvb2QlMkMlMjBOb25lJTJDJTIwZmxhZ3MlM0RjdjIuRHJhd01hdGNoZXNGbGFnc19OT1RfRFJBV19TSU5HTEVfUE9JTlRTJTBBKQ==",highlighted:`img3 = cv2.drawMatchesKnn(
    img1, kp1, img2, kp2, good, <span class="hljs-literal">None</span>, flags=cv2.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS
)`,wrap:!1}}),Q=new u({props:{code:"b3JiJTIwJTNEJTIwY3YyLk9SQl9jcmVhdGUoKQ==",highlighted:"orb = cv2.ORB_create()",wrap:!1}}),L=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMG9yYi5kZXRlY3RBbmRDb21wdXRlKGltZzElMkMlMjBOb25lKSUwQWtwMiUyQyUyMGRlczIlMjAlM0QlMjBvcmIuZGV0ZWN0QW5kQ29tcHV0ZShpbWcyJTJDJTIwTm9uZSk=",highlighted:`kp1, des1 = orb.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = orb.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),E=new u({props:{code:"YmYlMjAlM0QlMjBjdjIuQkZNYXRjaGVyKGN2Mi5OT1JNX0hBTU1JTkclMkMlMjBjcm9zc0NoZWNrJTNEVHJ1ZSk=",highlighted:'bf = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=<span class="hljs-literal">True</span>)',wrap:!1}}),V=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMGJmLm1hdGNoKGRlczElMkMlMjBkZXMyKQ==",highlighted:'matches = bf.<span class="hljs-keyword">match</span>(des1, des2)',wrap:!1}}),D=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMHNvcnRlZChtYXRjaGVzJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHguZGlzdGFuY2Up",highlighted:'matches = <span class="hljs-built_in">sorted</span>(matches, key=<span class="hljs-keyword">lambda</span> x: x.distance)',wrap:!1}}),K=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2Mi5kcmF3TWF0Y2hlcyglMEElMjAlMjAlMjAlMjBpbWcxJTJDJTBBJTIwJTIwJTIwJTIwa3AxJTJDJTBBJTIwJTIwJTIwJTIwaW1nMiUyQyUwQSUyMCUyMCUyMCUyMGtwMiUyQyUwQSUyMCUyMCUyMCUyMG1hdGNoZXMlNUIlM0FuJTVEJTJDJTBBJTIwJTIwJTIwJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMGZsYWdzJTNEY3YyLkRyYXdNYXRjaGVzRmxhZ3NfTk9UX0RSQVdfU0lOR0xFX1BPSU5UUyUyQyUwQSk=",highlighted:`img3 = cv2.drawMatches(
    img1,
    kp1,
    img2,
    kp2,
    matches[:n],
    <span class="hljs-literal">None</span>,
    flags=cv2.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS,
)`,wrap:!1}}),ee=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KQ==",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)`,wrap:!1}}),se=new u({props:{code:"RkxBTk5fSU5ERVhfTFNIJTIwJTNEJTIwNiUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoJTBBJTIwJTIwJTIwJTIwYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfTFNIJTJDJTIwdGFibGVfbnVtYmVyJTNEMTIlMkMlMjBrZXlfc2l6ZSUzRDIwJTJDJTIwbXVsdGlfcHJvYmVfbGV2ZWwlM0QyJTBBKQ==",highlighted:`FLANN_INDEX_LSH = <span class="hljs-number">6</span>
index_params = <span class="hljs-built_in">dict</span>(
    algorithm=FLANN_INDEX_LSH, table_number=<span class="hljs-number">12</span>, key_size=<span class="hljs-number">20</span>, multi_probe_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),ae=new u({props:{code:"c2VhcmNoX3BhcmFtcyUyMCUzRCUyMGRpY3QoY2hlY2tzJTNENTAp",highlighted:'search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)',wrap:!1}}),ie=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2Mi5TSUZUX2NyZWF0ZSgp",highlighted:"sift = cv2.SIFT_create()",wrap:!1}}),re=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),oe=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KSUwQXNlYXJjaF9wYXJhbXMlMjAlM0QlMjBkaWN0KGNoZWNrcyUzRDUwKSUwQWZsYW5uJTIwJTNEJTIwY3YyLkZsYW5uQmFzZWRNYXRjaGVyKGluZGV4X3BhcmFtcyUyQyUyMHNlYXJjaF9wYXJhbXMpJTBBJTBBbWF0Y2hlcyUyMCUzRCUyMGZsYW5uLmtubk1hdGNoKGRlczElMkMlMjBkZXMyJTJDJTIwayUzRDIp",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)
search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)
flann = cv2.FlannBasedMatcher(index_params, search_params)

matches = flann.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),he=new u({props:{code:"bWF0Y2hlc01hc2slMjAlM0QlMjAlNUIlNUIwJTJDJTIwMCU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihtYXRjaGVzKSklNUQ=",highlighted:'matchesMask = [[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(matches))]',wrap:!1}}),ye=new u({props:{code:"Zm9yJTIwaSUyQyUyMChtJTJDJTIwbiklMjBpbiUyMGVudW1lcmF0ZShtYXRjaGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbS5kaXN0YW5jZSUyMCUzQyUyMDAuNyUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF0Y2hlc01hc2slNUJpJTVEJTIwJTNEJTIwJTVCMSUyQyUyMDAlNUQ=",highlighted:`<span class="hljs-keyword">for</span> i, (m, n) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(matches):
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.7</span> * n.distance:
        matchesMask[i] = [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),fe=new u({props:{code:"ZHJhd19wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMG1hdGNoQ29sb3IlM0QoMCUyQyUyMDI1NSUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwc2luZ2xlUG9pbnRDb2xvciUzRCgyNTUlMkMlMjAwJTJDJTIwMCklMkMlMEElMjAlMjAlMjAlMjBtYXRjaGVzTWFzayUzRG1hdGNoZXNNYXNrJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0RjdjIuRHJhd01hdGNoZXNGbGFnc19ERUZBVUxUJTJDJTBBKSUwQSUwQWltZzMlMjAlM0QlMjBjdjIuZHJhd01hdGNoZXNLbm4oaW1nMSUyQyUyMGtwMSUyQyUyMGltZzIlMkMlMjBrcDIlMkMlMjBtYXRjaGVzJTJDJTIwTm9uZSUyQyUyMCoqZHJhd19wYXJhbXMp",highlighted:`draw_params = <span class="hljs-built_in">dict</span>(
    matchColor=(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>),
    singlePointColor=(<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    matchesMask=matchesMask,
    flags=cv2.DrawMatchesFlags_DEFAULT,
)

img3 = cv2.drawMatchesKnn(img1, kp1, img2, kp2, matches, <span class="hljs-literal">None</span>, **draw_params)`,wrap:!1}}),Te=new Ts({props:{title:"Local Feature Matching with Transformers (LoFTR)",local:"local-feature-matching-with-transformers-loftr",headingTag:"h2"}}),be=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBrb3JuaWElMjAlMjBrb3JuaWEtcnMlMjAlMjBrb3JuaWFfbW9vbnMlMjBvcGVuY3YtcHl0aG9uJTIwLS11cGdyYWRl",highlighted:"!pip install kornia  kornia-rs  kornia_moons opencv-python --upgrade",wrap:!1}}),Ce=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwa29ybmlhJTIwYXMlMjBLJTBBaW1wb3J0JTIwa29ybmlhLmZlYXR1cmUlMjBhcyUyMEtGJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGtvcm5pYV9tb29ucy52aXolMjBpbXBvcnQlMjBkcmF3X0xBRl9tYXRjaGVz",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> kornia <span class="hljs-keyword">as</span> K
<span class="hljs-keyword">import</span> kornia.feature <span class="hljs-keyword">as</span> KF
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> kornia_moons.viz <span class="hljs-keyword">import</span> draw_LAF_matches`,wrap:!1}}),$e=new u({props:{code:"ZnJvbSUyMGtvcm5pYS5mZWF0dXJlJTIwaW1wb3J0JTIwTG9GVFIlMEElMEFpbWcxJTIwJTNEJTIwSy5pby5sb2FkX2ltYWdlKGltYWdlMS5qcGclMkMlMjBLLmlvLkltYWdlTG9hZFR5cGUuUkdCMzIpJTVCTm9uZSUyQyUyMC4uLiU1RCUwQWltZzIlMjAlM0QlMjBLLmlvLmxvYWRfaW1hZ2UoaW1hZ2UyLmpwZyUyQyUyMEsuaW8uSW1hZ2VMb2FkVHlwZS5SR0IzMiklNUJOb25lJTJDJTIwLi4uJTVEJTBBJTBBaW1nMSUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzElMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUpJTBBaW1nMiUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzIlMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> kornia.feature <span class="hljs-keyword">import</span> LoFTR

img1 = K.io.load_image(image1.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]
img2 = K.io.load_image(image2.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]

img1 = K.geometry.resize(img1, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)
img2 = K.geometry.resize(img2, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ie=new u({props:{code:"bWF0Y2hlciUyMCUzRCUyMExvRlRSKHByZXRyYWluZWQlM0QlMjJvdXRkb29yJTIyKQ==",highlighted:'matcher = LoFTR(pretrained=<span class="hljs-string">&quot;outdoor&quot;</span>)',wrap:!1}}),xe=new u({props:{code:"aW5wdXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMCUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMSUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcyKSUyQyUwQSU3RA==",highlighted:`input_dict = {
    <span class="hljs-string">&quot;image0&quot;</span>: K.color.rgb_to_grayscale(img1),
    <span class="hljs-string">&quot;image1&quot;</span>: K.color.rgb_to_grayscale(img2),
}`,wrap:!1}}),Ne=new u({props:{code:"d2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBjb3JyZXNwb25kZW5jZXMlMjAlM0QlMjBtYXRjaGVyKGlucHV0X2RpY3Qp",highlighted:`<span class="hljs-keyword">with</span> torch.inference_mode():
    correspondences = matcher(input_dict)`,wrap:!1}}),Fe=new u({props:{code:"bWtwdHMwJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMCUyMiU1RC5jcHUoKS5udW1weSgpJTBBbWtwdHMxJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMSUyMiU1RC5jcHUoKS5udW1weSgpJTBBRm0lMkMlMjBpbmxpZXJzJTIwJTNEJTIwY3YyLmZpbmRGdW5kYW1lbnRhbE1hdChta3B0czAlMkMlMjBta3B0czElMkMlMjBjdjIuVVNBQ19NQUdTQUMlMkMlMjAwLjUlMkMlMjAwLjk5OSUyQyUyMDEwMDAwMCklMEFpbmxpZXJzJTIwJTNEJTIwaW5saWVycyUyMCUzRSUyMDA=",highlighted:`mkpts0 = correspondences[<span class="hljs-string">&quot;keypoints0&quot;</span>].cpu().numpy()
mkpts1 = correspondences[<span class="hljs-string">&quot;keypoints1&quot;</span>].cpu().numpy()
Fm, inliers = cv2.findFundamentalMat(mkpts0, mkpts1, cv2.USAC_MAGSAC, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.999</span>, <span class="hljs-number">100000</span>)
inliers = inliers &gt; <span class="hljs-number">0</span>`,wrap:!1}}),Se=new u({props:{code:"ZHJhd19MQUZfbWF0Y2hlcyglMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMwKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czAuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMxKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czEuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMxLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB0b3JjaC5hcmFuZ2UobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygtMSUyQyUyMDEpLnJlcGVhdCgxJTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjBLLnRlbnNvcl90b19pbWFnZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMEsudGVuc29yX3RvX2ltYWdlKGltZzIpJTJDJTBBJTIwJTIwJTIwJTIwaW5saWVycyUyQyUwQSUyMCUyMCUyMCUyMGRyYXdfZGljdCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlubGllcl9jb2xvciUyMiUzQSUyMCgwLjElMkMlMjAxJTJDJTIwMC4xJTJDJTIwMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbnRhdGl2ZV9jb2xvciUyMiUzQSUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlX2NvbG9yJTIyJTNBJTIwKDAuMiUyQyUyMDAuMiUyQyUyMDElMkMlMjAwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmVydGljYWwlMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`draw_LAF_matches(
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts0).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts1).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    torch.arange(mkpts0.shape[<span class="hljs-number">0</span>]).view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
    K.tensor_to_image(img1),
    K.tensor_to_image(img2),
    inliers,
    draw_dict={
        <span class="hljs-string">&quot;inlier_color&quot;</span>: (<span class="hljs-number">0.1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;tentative_color&quot;</span>: <span class="hljs-literal">None</span>,
        <span class="hljs-string">&quot;feature_color&quot;</span>: (<span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;vertical&quot;</span>: <span class="hljs-literal">False</span>,
    },
)`,wrap:!1}}),Ze=new Ts({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),We=new Ul({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit1/feature-extraction/feature-matching.mdx"}}),{c(){f=i("meta"),Ee=a(),Le=i("p"),Ye=a(),m(T.$$.fragment),Ve=a(),m(U.$$.fragment),Xe=a(),J=i("p"),J.textContent=ds,De=a(),m(d.$$.fragment),He=a(),b=i("p"),b.textContent=bs,Ke=a(),g=i("p"),g.textContent=gs,Pe=a(),C=i("p"),C.textContent=Cs,qe=a(),m(j.$$.fragment),Oe=a(),m($.$$.fragment),et=a(),k=i("p"),k.innerHTML=js,tt=a(),I=i("p"),I.textContent=$s,st=a(),m(v.$$.fragment),lt=a(),x=i("p"),x.textContent=ks,at=a(),m(R.$$.fragment),nt=a(),N=i("p"),N.textContent=Is,it=a(),m(B.$$.fragment),pt=a(),F=i("p"),F.textContent=vs,rt=a(),m(G.$$.fragment),mt=a(),S=i("p"),S.textContent=xs,ot=a(),m(_.$$.fragment),Mt=a(),w=i("div"),w.innerHTML=Rs,ht=a(),z=i("p"),z.innerHTML=Ns,ct=a(),Z=i("p"),Z.textContent=Bs,yt=a(),m(Q.$$.fragment),ut=a(),W=i("p"),W.textContent=Fs,ft=a(),m(L.$$.fragment),wt=a(),A=i("p"),A.innerHTML=Gs,Tt=a(),m(E.$$.fragment),Ut=a(),Y=i("p"),Y.textContent=Ss,Jt=a(),m(V.$$.fragment),dt=a(),X=i("p"),X.textContent=_s,bt=a(),m(D.$$.fragment),gt=a(),H=i("p"),H.textContent=zs,Ct=a(),m(K.$$.fragment),jt=a(),P=i("p"),P.innerHTML=Zs,$t=a(),q=i("p"),q.innerHTML=Qs,kt=a(),O=i("p"),O.textContent=Ws,It=a(),m(ee.$$.fragment),vt=a(),te=i("p"),te.textContent=Ls,xt=a(),m(se.$$.fragment),Rt=a(),le=i("p"),le.textContent=As,Nt=a(),m(ae.$$.fragment),Bt=a(),ne=i("p"),ne.textContent=Es,Ft=a(),m(ie.$$.fragment),Gt=a(),pe=i("p"),pe.textContent=Ys,St=a(),m(re.$$.fragment),_t=a(),me=i("p"),me.textContent=Vs,zt=a(),m(oe.$$.fragment),Zt=a(),Me=i("p"),Me.textContent=Xs,Qt=a(),m(he.$$.fragment),Wt=a(),ce=i("p"),ce.textContent=Ds,Lt=a(),m(ye.$$.fragment),At=a(),ue=i("p"),ue.textContent=Hs,Et=a(),m(fe.$$.fragment),Yt=a(),we=i("p"),we.innerHTML=Ks,Vt=a(),m(Te.$$.fragment),Xt=a(),Ue=i("p"),Ue.innerHTML=Ps,Dt=a(),Je=i("p"),Je.textContent=qs,Ht=a(),de=i("p"),de.innerHTML=Os,Kt=a(),m(be.$$.fragment),Pt=a(),ge=i("p"),ge.textContent=el,qt=a(),m(Ce.$$.fragment),Ot=a(),je=i("p"),je.textContent=tl,es=a(),m($e.$$.fragment),ts=a(),ke=i("p"),ke.textContent=sl,ss=a(),m(Ie.$$.fragment),ls=a(),ve=i("p"),ve.textContent=ll,as=a(),m(xe.$$.fragment),ns=a(),Re=i("p"),Re.textContent=al,is=a(),m(Ne.$$.fragment),ps=a(),Be=i("p"),Be.innerHTML=nl,rs=a(),m(Fe.$$.fragment),ms=a(),Ge=i("p"),Ge.textContent=il,os=a(),m(Se.$$.fragment),Ms=a(),_e=i("p"),_e.textContent=pl,hs=a(),ze=i("p"),ze.innerHTML=rl,cs=a(),m(Ze.$$.fragment),ys=a(),Qe=i("ul"),Qe.innerHTML=ml,us=a(),m(We.$$.fragment),fs=a(),Ae=i("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(s),Ee=n(e),Le=p(e,"P",{}),ol(Le).forEach(s),Ye=n(e),o(T.$$.fragment,e),Ve=n(e),o(U.$$.fragment,e),Xe=n(e),J=p(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-15xns04"&&(J.textContent=ds),De=n(e),o(d.$$.fragment,e),He=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-on1oww"&&(b.textContent=bs),Ke=n(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-18ol5uq"&&(g.textContent=gs),Pe=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-j7e5uv"&&(C.textContent=Cs),qe=n(e),o(j.$$.fragment,e),Oe=n(e),o($.$$.fragment,e),et=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-9u0yio"&&(k.innerHTML=js),tt=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-w6x33t"&&(I.textContent=$s),st=n(e),o(v.$$.fragment,e),lt=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1rqvoxt"&&(x.textContent=ks),at=n(e),o(R.$$.fragment,e),nt=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s4nnss"&&(N.textContent=Is),it=n(e),o(B.$$.fragment,e),pt=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-11pmghx"&&(F.textContent=vs),rt=n(e),o(G.$$.fragment,e),mt=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1dxu9r2"&&(S.textContent=xs),ot=n(e),o(_.$$.fragment,e),Mt=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-65csdm"&&(w.innerHTML=Rs),ht=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ugbzmf"&&(z.innerHTML=Ns),ct=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-118nbqb"&&(Z.textContent=Bs),yt=n(e),o(Q.$$.fragment,e),ut=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1db2byq"&&(W.textContent=Fs),ft=n(e),o(L.$$.fragment,e),wt=n(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-16ya51f"&&(A.innerHTML=Gs),Tt=n(e),o(E.$$.fragment,e),Ut=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1qu6t9d"&&(Y.textContent=Ss),Jt=n(e),o(V.$$.fragment,e),dt=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16suw0v"&&(X.textContent=_s),bt=n(e),o(D.$$.fragment,e),gt=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1uxd7nf"&&(H.textContent=zs),Ct=n(e),o(K.$$.fragment,e),jt=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1br77qa"&&(P.innerHTML=Zs),$t=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1bts3l5"&&(q.innerHTML=Qs),kt=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-12c8hlw"&&(O.textContent=Ws),It=n(e),o(ee.$$.fragment,e),vt=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-xztual"&&(te.textContent=Ls),xt=n(e),o(se.$$.fragment,e),Rt=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-aqv1ru"&&(le.textContent=As),Nt=n(e),o(ae.$$.fragment,e),Bt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1uz9tsf"&&(ne.textContent=Es),Ft=n(e),o(ie.$$.fragment,e),Gt=n(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1rqvoxt"&&(pe.textContent=Ys),St=n(e),o(re.$$.fragment,e),_t=n(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1owh1z6"&&(me.textContent=Vs),zt=n(e),o(oe.$$.fragment,e),Zt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-fflevz"&&(Me.textContent=Xs),Qt=n(e),o(he.$$.fragment,e),Wt=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-wxpfev"&&(ce.textContent=Ds),Lt=n(e),o(ye.$$.fragment,e),At=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1v2s6y7"&&(ue.textContent=Hs),Et=n(e),o(fe.$$.fragment,e),Yt=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1wrykwq"&&(we.innerHTML=Ks),Vt=n(e),o(Te.$$.fragment,e),Xt=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-lacwgz"&&(Ue.innerHTML=Ps),Dt=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-9siw9c"&&(Je.textContent=qs),Ht=n(e),de=p(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1e39a5t"&&(de.innerHTML=Os),Kt=n(e),o(be.$$.fragment,e),Pt=n(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-srwjmc"&&(ge.textContent=el),qt=n(e),o(Ce.$$.fragment,e),Ot=n(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-5yf40"&&(je.textContent=tl),es=n(e),o($e.$$.fragment,e),ts=n(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-h1pkxc"&&(ke.textContent=sl),ss=n(e),o(Ie.$$.fragment,e),ls=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-mpwa7r"&&(ve.textContent=ll),as=n(e),o(xe.$$.fragment,e),ns=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1d3obuy"&&(Re.textContent=al),is=n(e),o(Ne.$$.fragment,e),ps=n(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1pdz4rs"&&(Be.innerHTML=nl),rs=n(e),o(Fe.$$.fragment,e),ms=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1h7emw7"&&(Ge.textContent=il),os=n(e),o(Se.$$.fragment,e),Ms=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-19n2hbq"&&(_e.textContent=pl),hs=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1p8df1m"&&(ze.innerHTML=rl),cs=n(e),o(Ze.$$.fragment,e),ys=n(e),Qe=p(e,"UL",{"data-svelte-h":!0}),r(Qe)!=="svelte-5o0z5y"&&(Qe.innerHTML=ml),us=n(e),o(We.$$.fragment,e),fs=n(e),Ae=p(e,"P",{}),ol(Ae).forEach(s),this.h()},h(){Us(f,"name","hf:doc:metadata"),Us(f,"content",dl),Us(w,"class","flex justify-center")},m(e,t){wl(document.head,f),l(e,Ee,t),l(e,Le,t),l(e,Ye,t),M(T,e,t),l(e,Ve,t),M(U,e,t),l(e,Xe,t),l(e,J,t),l(e,De,t),M(d,e,t),l(e,He,t),l(e,b,t),l(e,Ke,t),l(e,g,t),l(e,Pe,t),l(e,C,t),l(e,qe,t),M(j,e,t),l(e,Oe,t),M($,e,t),l(e,et,t),l(e,k,t),l(e,tt,t),l(e,I,t),l(e,st,t),M(v,e,t),l(e,lt,t),l(e,x,t),l(e,at,t),M(R,e,t),l(e,nt,t),l(e,N,t),l(e,it,t),M(B,e,t),l(e,pt,t),l(e,F,t),l(e,rt,t),M(G,e,t),l(e,mt,t),l(e,S,t),l(e,ot,t),M(_,e,t),l(e,Mt,t),l(e,w,t),l(e,ht,t),l(e,z,t),l(e,ct,t),l(e,Z,t),l(e,yt,t),M(Q,e,t),l(e,ut,t),l(e,W,t),l(e,ft,t),M(L,e,t),l(e,wt,t),l(e,A,t),l(e,Tt,t),M(E,e,t),l(e,Ut,t),l(e,Y,t),l(e,Jt,t),M(V,e,t),l(e,dt,t),l(e,X,t),l(e,bt,t),M(D,e,t),l(e,gt,t),l(e,H,t),l(e,Ct,t),M(K,e,t),l(e,jt,t),l(e,P,t),l(e,$t,t),l(e,q,t),l(e,kt,t),l(e,O,t),l(e,It,t),M(ee,e,t),l(e,vt,t),l(e,te,t),l(e,xt,t),M(se,e,t),l(e,Rt,t),l(e,le,t),l(e,Nt,t),M(ae,e,t),l(e,Bt,t),l(e,ne,t),l(e,Ft,t),M(ie,e,t),l(e,Gt,t),l(e,pe,t),l(e,St,t),M(re,e,t),l(e,_t,t),l(e,me,t),l(e,zt,t),M(oe,e,t),l(e,Zt,t),l(e,Me,t),l(e,Qt,t),M(he,e,t),l(e,Wt,t),l(e,ce,t),l(e,Lt,t),M(ye,e,t),l(e,At,t),l(e,ue,t),l(e,Et,t),M(fe,e,t),l(e,Yt,t),l(e,we,t),l(e,Vt,t),M(Te,e,t),l(e,Xt,t),l(e,Ue,t),l(e,Dt,t),l(e,Je,t),l(e,Ht,t),l(e,de,t),l(e,Kt,t),M(be,e,t),l(e,Pt,t),l(e,ge,t),l(e,qt,t),M(Ce,e,t),l(e,Ot,t),l(e,je,t),l(e,es,t),M($e,e,t),l(e,ts,t),l(e,ke,t),l(e,ss,t),M(Ie,e,t),l(e,ls,t),l(e,ve,t),l(e,as,t),M(xe,e,t),l(e,ns,t),l(e,Re,t),l(e,is,t),M(Ne,e,t),l(e,ps,t),l(e,Be,t),l(e,rs,t),M(Fe,e,t),l(e,ms,t),l(e,Ge,t),l(e,os,t),M(Se,e,t),l(e,Ms,t),l(e,_e,t),l(e,hs,t),l(e,ze,t),l(e,cs,t),M(Ze,e,t),l(e,ys,t),l(e,Qe,t),l(e,us,t),M(We,e,t),l(e,fs,t),l(e,Ae,t),ws=!0},p:hl,i(e){ws||(h(T.$$.fragment,e),h(U.$$.fragment,e),h(d.$$.fragment,e),h(j.$$.fragment,e),h($.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(oe.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(fe.$$.fragment,e),h(Te.$$.fragment,e),h(be.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(xe.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),ws=!0)},o(e){c(T.$$.fragment,e),c(U.$$.fragment,e),c(d.$$.fragment,e),c(j.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c(B.$$.fragment,e),c(G.$$.fragment,e),c(_.$$.fragment,e),c(Q.$$.fragment,e),c(L.$$.fragment,e),c(E.$$.fragment,e),c(V.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(he.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(Te.$$.fragment,e),c(be.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(Ie.$$.fragment,e),c(xe.$$.fragment,e),c(Ne.$$.fragment,e),c(Fe.$$.fragment,e),c(Se.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),ws=!1},d(e){e&&(s(Ee),s(Le),s(Ye),s(Ve),s(Xe),s(J),s(De),s(He),s(b),s(Ke),s(g),s(Pe),s(C),s(qe),s(Oe),s(et),s(k),s(tt),s(I),s(st),s(lt),s(x),s(at),s(nt),s(N),s(it),s(pt),s(F),s(rt),s(mt),s(S),s(ot),s(Mt),s(w),s(ht),s(z),s(ct),s(Z),s(yt),s(ut),s(W),s(ft),s(wt),s(A),s(Tt),s(Ut),s(Y),s(Jt),s(dt),s(X),s(bt),s(gt),s(H),s(Ct),s(jt),s(P),s($t),s(q),s(kt),s(O),s(It),s(vt),s(te),s(xt),s(Rt),s(le),s(Nt),s(Bt),s(ne),s(Ft),s(Gt),s(pe),s(St),s(_t),s(me),s(zt),s(Zt),s(Me),s(Qt),s(Wt),s(ce),s(Lt),s(At),s(ue),s(Et),s(Yt),s(we),s(Vt),s(Xt),s(Ue),s(Dt),s(Je),s(Ht),s(de),s(Kt),s(Pt),s(ge),s(qt),s(Ot),s(je),s(es),s(ts),s(ke),s(ss),s(ls),s(ve),s(as),s(ns),s(Re),s(is),s(ps),s(Be),s(rs),s(ms),s(Ge),s(os),s(Ms),s(_e),s(hs),s(ze),s(cs),s(ys),s(Qe),s(us),s(fs),s(Ae)),s(f),y(T,e),y(U,e),y(d,e),y(j,e),y($,e),y(v,e),y(R,e),y(B,e),y(G,e),y(_,e),y(Q,e),y(L,e),y(E,e),y(V,e),y(D,e),y(K,e),y(ee,e),y(se,e),y(ae,e),y(ie,e),y(re,e),y(oe,e),y(he,e),y(ye,e),y(fe,e),y(Te,e),y(be,e),y(Ce,e),y($e,e),y(Ie,e),y(xe,e),y(Ne,e),y(Fe,e),y(Se,e),y(Ze,e),y(We,e)}}}const dl='{"title":"Feature Matching","local":"feature-matching","sections":[{"title":"Brute-Force Search","local":"brute-force-search","sections":[],"depth":2},{"title":"Local Feature Matching with Transformers (LoFTR)","local":"local-feature-matching-with-transformers-loftr","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function bl(Js){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends yl{constructor(f){super(),ul(this,f,bl,Jl,Ml,{})}}export{Il as component};
