# Table of Contents for Notebooks

Here you can find a list of notebooks that contain accompanying and hands-on material to the chapters you find in this course.
Feel free to browse them at your own speed and interest.

| Chapter Title                                           | Notebooks                                                                                                                                                                                                                             | Colabs                                                                                                                                                                                                                                                           |
| ------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Unit 0 - Welcome                                        | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 1 - Fundamentals                                   | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 2 - Convolutional Neural Networks                  | [Transfer Learning with VGG19](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%202%20-%20Convolutional%20Neural%20Networks/transfer_learning_vgg19.ipynb)                                                    | [Transfer Learning with VGG](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%202%20-%20Convolutional%20Neural%20Networks/transfer_learning_vgg19.ipynb)                                                      |
|                                                         | [Using ResNet with timm](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%202%20-%20Convolutional%20Neural%20Networks/timm_Resnet.ipynb)                                                                      | [timm_Resnet](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%202%20-%20Convolutional%20Neural%20Networks/timm_Resnet.ipynb)                                                                                 |
| Unit 3 - Vision Transformers                            | [Detection Transformer (DETR)](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/DETR.ipynb)                                                                                   | [Detection Transformer (DETR)](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/DETR.ipynb)                                                                                   |
|                                                         | [Fine-tuning Vision Transformers for Object Detection](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/Fine-tuning%20Vision%20Transformers%20for%20Object%20detection.ipynb) | [Fine-tuning Vision Transformers for Object Detection](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/Fine-tuning%20Vision%20Transformers%20for%20Object%20detection.ipynb) |
|                                                         | [Knowledge Distillation](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/KnowledgeDistillation.ipynb)                                                                        | [Knowledge Distillation](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/KnowledgeDistillation.ipynb)                                                                        |
|                                                         | [LoRA Fine-tuning for Image Classification](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/LoRA-Image-Classification.ipynb)                                                 | [LoRA Fine-tuning for Image Classification](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/LoRA-Image-Classification.ipynb)                                                 |
|                                                         | [Fine-tuning for Multilabel Image Classification](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/fine-tuning-multilabel-image-classification.ipynb)                         | [Fine-tuning for Multilabel Image Classification](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/fine-tuning-multilabel-image-classification.ipynb)                         |
|                                                         | [Transfer Learning for Image Classification](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/transfer-learning-image-classification.ipynb)                                   | [Transfer Learning for Image Classification](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/transfer-learning-image-classification.ipynb)                                   |
|                                                         | [Transfer Learning for Image Segmentation](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/transfer-learning-segmentation.ipynb)                                             | [Transfer Learning for Image Segmentation](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/transfer-learning-segmentation.ipynb)                                             |
|                                                         | [Swin Transformer](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/Swin.ipynb)                                                                                               | [Swin Transformer](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%203%20-%20Vision%20Transformers/Swin.ipynb)                                                                                               |
| Unit 4 - Multimodal Models                              | [Clip Crop](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/ClipCrop.ipynb)                                                                                                    | [Clip Crop](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/ClipCrop.ipynb)                                                                                                    |
|                                                         | [Fine-tuning CLIP](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/Clip_finetune.ipynb)                                                                                        | [Fine-tuning CLIP](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/Clip_finetune.ipynb)                                                                                        |
|                                                         | [Clustering with CLIP](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Clustering%20with%20CLIP.ipynb)                                                  | [Clustering with CLIP](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Clustering%20with%20CLIP.ipynb)                                                  |
|                                                         | [Image Classification with CLIP](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image%20classification%20with%20CLIP.ipynb)                            | [Image Classification with CLIP](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image%20classification%20with%20CLIP.ipynb)                            |
|                                                         | [Image Retrieval with Prompts](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image_retrieval_with_prompts.ipynb)                                      | [Image Retrieval with Prompts](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image_retrieval_with_prompts.ipynb)                                      |
|                                                         | [Image Similarity](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image_similarity.ipynb)                                                              | [Image Similarity](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%204%20-%20Multimodal%20Models/CLIP%20and%20relatives/Image_similarity.ipynb)                                                              |
| Unit 5 - Generative Models                              | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 6 - Basic CV Tasks                                 | [Fine-tune SAM on Custom Dataset]()                             | [Fine-tune SAM on Custom Dataset]()                             |
| Unit 7 - Video and Video Processing                     | [Fine-tune ViViT for Video Classification](https://github.com/DiwakarBasnet/computer-vision-course/blob/unit-7_Video_and_VideoProcessing/notebooks/Unit%207%20-%20Video%20and%20Video%20Processing/Vivit_Fine_tuned_Video_Classification.ipynb)                                                                                                                                                                                                                           | [Fine-tune ViViT for Video Classification](https://github.com/DiwakarBasnet/computervisioncourse/blob/unit7_Video_and_VideoProcessing/notebooks/Unit%207%20%20Video%20and%20Video%20Processing/Vivit_Fine_tuned_Video_Classification.ipynb)                                                                                                                                                                                                                                                         |
| Unit 8 - 3D Vision, Scene Rendering, and Reconstruction | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 9 - Model Optimization                             | [Edge TPU](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/edge_tpu.ipynb)                                                                                                    | [Edge TPU](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/edge_tpu.ipynb)                                                                                                    |
|                                                         | [ONNX](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/onnx.ipynb)                                                                                                            | [ONNX](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/onnx.ipynb)                                                                                                            |
|                                                         | [OpenVINO](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/openvino.ipynb)                                                                                                    | [OpenVINO](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/openvino.ipynb)                                                                                                    |
|                                                         | [Optimum](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/optimum.ipynb)                                                                                                      | [Optimum](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/optimum.ipynb)                                                                                                      |
|                                                         | [TensorRT](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/tensorrt.ipynb)                                                                                                    | [TensorRT](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/tensorrt.ipynb)                                                                                                    |
|                                                         | [TMO](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/tmo.ipynb)                                                                                                              | [TMO](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/tmo.ipynb)                                                                                                              |
|                                                         | [Torch](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/torch.ipynb)                                                                                                          | [Torch](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%209%20-%20Model%20Optimization/torch.ipynb)                                                                                                          |
| Unit 10 - Synthetic Data Creation                       | [Dataset Labeling with OWLv2](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/OWLV2_labeled_image_dataset_with_annotations.ipynb)                                     | [Dataset Labeling with OWLv2](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/OWLV2_labeled_image_dataset_with_annotations.ipynb)                                     |
|                                                         | [Generating Synthetic Lung Images](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/Synthetic_lung_images_hf_course.ipynb)                                             | [Generating Synthetic Lung Images](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/Synthetic_lung_images_hf_course.ipynb)                                             |
|                                                         | [BlenderProc Examples](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/blenderproc_examples.ipynb)                                                                    | [BlenderProc Examples](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/blenderproc_examples.ipynb)                                                                    |
|                                                         | [Image Labeling with BLIP-2](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/image_labeling_BLIP_2.ipynb)                                                             | [Image Labeling with BLIP-2](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/image_labeling_BLIP_2.ipynb)                                                             |
|                                                         | [Synthetic Data Creation with SDXL Turbo](https://github.com/huggingface/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/synthetic_data_creation_sdxl_turbo.ipynb)                                   | [Synthetic Data Creation with SDXL Turbo](https://colab.research.google.com/github/fariddinar/computer-vision-course/blob/main/notebooks/Unit%2010%20-%20Synthetic%20Data%20Creation/synthetic_data_creation_sdxl_turbo.ipynb)                                   |
| Unit 11 - Zero Shot Computer Vision                     | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 12 - Ethics and Biases                             | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |
| Unit 13 - Outlook                                       | No Notebook                                                                                                                                                                                                                           | No Colab                                                                                                                                                                                                                                                         |

