# Hugging Face's efforts: Ethics and Society 🤗🌎

We hope you liked exploring the unit on ethics and bias in computer vision. As we conclude this unit, let us take a look into the efforts by Hugging Face to improve ethics in society. This chapter will encourage you to explore the world of ethics and bias in AI in general, which is constantly evolving. Hugging Face's core mission is to *democratize good machine learning*. So what is Good ML? There are some principles for Good ML. 

## Democratizing Good ML 🤗

**1. Collaboration:** Providing tools for easier collaboration with the open-source community. Some examples of these tools are: 
    a. [*Model Cards*](https://huggingface.co/docs/hub/model-cards) are files that accompany the models and provide information about the model, its intended uses and potential limitations (including ethical considerations), training parameters and experimental information, datasets used for training and evaluation results. This ensures that the models uploaded to the hub are transparent and open to the community.
    b. [*Evaluation*](https://huggingface.co/blog/eval-on-the-hub) lets users to evaluate any model on any dataset that is openly available on the Hub without writing a single line of code. , 
    c. [*Community discussion*](https://huggingface.co/blog/community-update) is important, whether you upload a model, dataset or a space or you just want to know more about them from the authors. Everyone can give feedback, flag a given Space, and improve or contribute directly to the repository via PRs. 
    d. [*Discord*](https://discord.com/invite/JfAtkvEtRb) group for the 🤗 community, where a wide range of channels discuss about different domains like reinforcement-learning, NLP, game development, audio, computer vision and so on. 
**2. Transparency:** Being transparent about the intent, sources of data, model training and performance. Efforts in this direction include: 
    a. [*Ethical charter for multimodal project*](https://huggingface.co/blog/ethical-charter-multimodal) discusses the values of the multimodal learning group at 🤗. This is a project-specific charter.
    b. [*Work on AI policy @* 🤗](https://huggingface.co/blog/us-national-ai-research-resource) mentions the response of Hugging Face on U.S. National AI Research Resource Interim Report.
**3. Responsibility:** Assessing the impacts of ML models and tools, and making them more auditable and understandable even for people with less expertise on ML. Some efforts in this directions are: 
    a. [🤗 *for Education Project*](https://huggingface.co/blog/education) aims at educating people from all backgrounds, beginners and instructors. Various experts and team members organize meetups, conferences and workshops.  
    b. [*Data Measurement Tool*](https://huggingface.co/spaces/huggingface/data-measurements-tool) is an interactive interface and open-source library that lets dataset creators and users automatically calculate metrics that are meaningful and useful for responsible data development. 

## Categories of Hugging Face Spaces 

As we move forward, let us now take a look into how spaces are categorized by Hugging Face. Hugging Face categorizes the spaces in 6 high levels based on the ethical aspects in Machine Learning. Hugging Face Spaces are categorized as:

### ✍️ Rigorous

Rigorous projects pay special attention to examining failure cases, protecting privacy through security measures, and ensuring that potential users (technical and non-technical) are informed of the project's limitations. Some examples:
- Projects built with models that are well-documented with Model Cards.
- Tools that provide transparency into how a model was trained and how it behaves.
- Evaluations against cutting-edge benchmarks, with results reported against disaggregated sets.
- Demonstrations of models failing across gender, skin type, ethnicity, age or other attributes.
- Techniques for mitigating issues like over-fitting and training data memorization.
- Techniques for detoxifying language models.

An example space is the [**Diffusion Bias Explorer**](https://huggingface.co/spaces/society-ethics/DiffusionBiasExplorer) which lets the users compare three text-to-image models SD 1.4, SD 2.0 and Dall-E 2 for different prompts and how they represent different professions and adjectives. 

### 🤝 Consentful

Consentful technology supports the self-determination of people who use and are affected by these technologies. Some examples:
- Demonstrating a commitment to acquiring data from willing, informed, and appropriately compensated sources.
- Designing systems that respect end-user autonomy, e.g. with privacy-preserving techniques.
- Avoiding extractive, chauvinist, "dark", and otherwise "unethical" patterns of engagement.

Some example spaces for this category are: 
1. [**Does CLIP Know My Face:**](https://huggingface.co/spaces/AIML-TUDA/does-clip-know-my-face) this space lets you choose a model, enter your name and upload some pictures. Depending on this information, the model tries to predict your name from the images, if it predicts name correctly for multiple images there are high chances that you were part of the training data.
2. [**Photoguard:**](https://huggingface.co/spaces/RamAnanth1/photoguard) this space demonstrates an approach to safeguarding images against manipulation by ML-powered photo-editing models such as SD, through immunization of images.

### 👁️‍🗨️ Socially Conscious 

Socially Conscious work shows us how machine learning can support efforts toward a stronger society. Some examples:
- Using machine learning as part of an effort to tackle climate change.
- Building tools to assist with medical research and practice.
- Models for text-to-speech, image captioning, and other tasks aimed at increasing accessibility.
- Creating systems for the digital humanities, such as for Indigenous language revitalization.

Some example spaces:
1. [**Socratic Models Image Captioning**](https://huggingface.co/spaces/Geonmo/socratic-models-image-captioning-with-BLOOM)
2. [**Comparing Image Captioning Models**](https://huggingface.co/spaces/nielsr/comparing-captioning-models)

### 🌎 Sustainable

This is work that highlights and explores techniques for making machine learning ecologically sustainable. Some examples:
- Tracking emissions from training and running inferences on large language models.
- Quantization and distillation methods to reduce carbon footprints without sacrificing model quality.

1. [**EfficientFormer**](https://huggingface.co/spaces/adirik/efficientformer)
2. [**EfficientNetV2 Deepfakes Video Detector**](https://huggingface.co/spaces/Ron0420/EfficientNetV2_Deepfakes_Video_Detector)

### 🧑‍🤝‍🧑 Inclusive

These are projects which broaden the scope of who builds and benefits in the machine learning world. Some examples:
- Curating diverse datasets that increase the representation of underserved groups.
- Training language models on languages that aren't yet available on the Hugging Face Hub.
- Creating no-code and low-code frameworks that allow non-technical folk to engage with AI.

An example space is [**Promptist Demo**](https://huggingface.co/spaces/microsoft/Promptist).

### 🤔 Inquisitive

Some projects take a radical new approach to concepts which may have become commonplace. These projects, often rooted in critical theory, shine a light on inequities and power structures which challenge the community to rethink its relationship to technology. Some examples:
- Reframing AI and machine learning from Indigenous perspectives.
- Highlighting LGBTQIA2S+ marginalization in AI.
- Critiquing the harms perpetuated by AI systems.
- Discussing the role of "openness" in AI research.

An example space is [**PAIR: Datasets Have Worldviews**](https://huggingface.co/spaces/merve/dataset-worldviews).

Finally, if you would like to explore more about Hugging Face's efforts, do check out the [**Society and Ethics**](https://huggingface.co/society-ethics) organzation on Hugging Face. Also check out the dedicated channel on [**#ethics-and-society**](https://discord.gg/hugging-face-879548962464493619).

