# CLIP and Relatives

So far we have learned about the fundamentals of multimodality with a special spotlight of Vision Language Models. This chapters provide a short overview of CLIP and similar models, highlighting their unique features and applicability to various machine learning tasks.
It sets the stage for a high-level exploration of key multimodal models that have emerged before and after CLIP, showcasing their significant contributions to the advancement of multimodal AI.

## Pre-CLIP

In this part, we explore the innovative attempts in multimodal AI before CLIP.
The focus is on influential papers that used deep learning to make significant strides in the field:

1. **"Multimodal Deep Learning" by Ngiam et al. (2011):** This paper demonstrated the use of deep learning for multimodal inputs, emphasizing the potential of neural networks in integrating different data types. It laid the groundwork for future innovations in multimodal AI.

   - [Multimodal Deep Learning](https://people.csail.mit.edu/khosla/papers/icml2011_ngiam.pdf)

2. **"Deep Visual-Semantic Alignments for Generating Image Descriptions" by Karpathy and Fei-Fei (2015):** This study presented a method for aligning textual data with specific image regions, enhancing the interpretability of multimodal systems and advancing the understanding of complex visual-textual relationships.

   - [Deep Visual-Semantic Alignments for Generating Image Descriptions](https://cs.stanford.edu/people/karpathy/cvpr2015.pdf)

3. **"Show and Tell: A Neural Image Caption Generator" by Vinyals et al. (2015):** This paper marked a significant step in practical multimodal AI by showing how CNNs and RNNs could be combined to transform visual information into descriptive language.
   - [Show and Tell: A Neural Image Caption Generator](https://arxiv.org/abs/1411.4555)

## Post-CLIP

The emergence of CLIP brought new dimensions to multimodal models, as illustrated by the following developments:

1. **CLIP:** OpenAI's CLIP was a game-changer, learning from a vast array of internet text-image pairs and enabling zero-shot learning, contrasting with earlier models.

   - [CLIP](https://openai.com/blog/clip/)

2. **GroupViT:** Innovating in segmentation and semantic understanding, GroupViT combined these aspects with language, showing advanced integration of language and vision.

   - [GroupViT](https://arxiv.org/abs/2202.11094)

3. **BLIP:** BLIP introduced bidirectional learning between vision and language, pushing the boundaries for generating text from visual inputs.

   - [BLIP](https://arxiv.org/abs/2201.12086)

4. **OWL-VIT:** Focusing on object-centric representations, OWL-VIT advanced the understanding of objects within images in context with text.
   - [OWL-VIT](https://arxiv.org/abs/2205.06230)

## Conclusion

Hopefully, this section has provided a concise overview of pivotal works in multimodal AI before and after CLIP.
These developments highlight the evolving methods of processing multimodal data and their implications for AI applications.

The upcoming sections will delve into the "Losses" aspect, focusing on various loss functions and self-supervised learning crucial for training multimodal models.
The "Models" section will provide a deeper understanding of CLIP and its variants, exploring their designs and functionalities.
Finally, the "Practical Notebooks" section will offer hands-on experience, addressing challenges like data bias and applying these models in tasks such as image search engines and visual question answering systems.
These sections aim to deepen your knowledge and practical skills in the multifaceted world of multimodal AI.

