# Privacy, Bias and Societal Concerns

The widespread adoption of AI-powered image editing tools raises significant concerns regarding privacy, bias, and potential societal ramifications. These tools, capable of manipulating both 2D and 3D images with remarkable realism, introduce ethical dilemmas and require careful consideration.

What you will learn from this chapter:

- Impact of such AI images/videos on society
- Current approaches to tackle the issues
- Future scope

## Impact on Society

The ability to effortlessly edit and alter images has the potential to:

- **Undermine trust in media:** Deepfakes, convincingly manipulated videos, can spread misinformation and erode public trust in news and online content.
- **Harass and defame individuals:** Malicious actors can use AI tools to create fake images for harassment, defamation, and other harmful purposes.
- **Create unrealistic beauty standards:** AI tools can be used to edit images to conform to unrealistic beauty standards, negatively impacting self-esteem and body image.

## Current approaches

Several approaches are currently being employed to address these concerns:

- **Transparency and labeling:** Platforms and developers are encouraged to be transparent about the use of AI-edited images and implement labeling systems to differentiate real and manipulated content.
- **Fact-checking and verification:** Media outlets and tech companies are investing in fact-checking and verification tools to help combat the spread of misinformation and disinformation.
- **Legal frameworks:** Governments are considering legislative measures to regulate the use of AI-edited images and hold individuals accountable for their misuse.

## Future scope

The future of AI-edited images will likely involve:

- **Advanced detection and mitigation techniques:** Researchers will ideally develop more advanced techniques for detecting and mitigating the harms associated with AI-edited images. But is like a cat-and-mouse game where one group develops sophisticated realistic images generation algorithms, whereas another group develops methods to identify them.
- **Public awareness and education:** Public awareness campaigns and educational initiatives will be crucial in promoting responsible use of AI-edited images and combating the spread of misinformation.
- **Protecting rights of image artist:** Companies like OpenAI, Google, StabiltyAI that trains large text-to-image models are facing slew of lawsuits because of scraping works of artists from internet without crediting them in anyway. Techniques like image poisoning is an emerging research problem where an artists' image is added with human-eye-invisible noise-like pixel changes before uploading on internet. This potentially corrupts the training data and hence model's image generation capability if scraped directly. You can read about this more from - [here](https://www.technologyreview.com/2023/10/23/1082189/data-poisoning-artists-fight-generative-ai/), and [here](https://arxiv.org/abs/2310.13828).

This is a rapidly evolving field, and it is crucial to stay informed about the latest developments.

## Conclusion

This section concludes our unit on Generative Vision Models, where you have learned about Generative Adversarial Networks, Variational Auto Encoders and Diffusion Models.
You saw how they can be implemented and used, and in this chapter, you also learned about the important topic of ethics and biases concerning these models.

With the end of this unit, you have also finished the most fundamental part of this course, which includes _Fundamentals_, _Convolutional Neural Networks_, _Vision Transformers_ and _Generative Models_.
In the next chapters we will dive deeper into specialized fields like _Video and Video Processing_, _3D Vision, Scene Rendering and Reconstruction_ and _Model Optimization_.
But first, we will have a look at basic Computer Vision tasks - what they are used for, what defines them and how they are evaluated.

