import{s as Ds,f as El,o as Ps,n as Al}from"../chunks/scheduler.9039eef2.js";import{S as Ks,i as Os,g as i,s as n,r as o,A as en,h as p,f as l,c as a,j as As,u,x as m,k as w,y as tn,a as s,v as r,d as c,t as M,w as d}from"../chunks/index.cdcc3d35.js";import{T as ql}from"../chunks/Tip.6f74db41.js";import{C as b}from"../chunks/CodeBlock.e3ac94d9.js";import{H as h}from"../chunks/Heading.96ce3702.js";function ln(I){let f,T="To apply optimized compute of Unet’s attention score, please configure your environment variable with <code>export NEURON_FUSE_SOFTMAX=1</code>.",y,g,j='Besides, don’t hesitate to tweak the compilation configuration to find the best tradeoff between performance v.s accuracy in your use case. By default, we suggest casting FP32 matrix multiplication operations to BF16 which offers good performance with moderate sacrifice of the accuracy. Check out the guide from <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/appnotes/neuronx-cc/neuronx-cc-training-mixed-precision.html#neuronx-cc-training-mixed-precision" rel="nofollow">AWS Neuron documentation</a> to better understand the options for your compilation.';return{c(){f=i("p"),f.innerHTML=T,y=n(),g=i("p"),g.innerHTML=j},l(J){f=p(J,"P",{"data-svelte-h":!0}),m(f)!=="svelte-6bhicj"&&(f.innerHTML=T),y=a(J),g=p(J,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1dh7n4s"&&(g.innerHTML=j)},m(J,U){s(J,f,U),s(J,y,U),s(J,g,U)},p:Al,d(J){J&&(l(f),l(y),l(g))}}}function sn(I){let f,T="To avoid Neuron device out of memory, it’s suggested to finish all base inference and release the device memory before running the refiner.";return{c(){f=i("p"),f.textContent=T},l(y){f=p(y,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1323ut2"&&(f.textContent=T)},m(y,g){s(y,f,g)},p:Al,d(y){y&&l(f)}}}function nn(I){let f,T="Inf2 instances contain one or more Neuron devices, and each Neuron device includes 2 NeuronCore-v2. By default, we load the whole pipeline of LCM to both Neuron cores. It means that when the batch size is divisible by 2, you can fully leverage the compute power of both cores.";return{c(){f=i("p"),f.textContent=T},l(y){f=p(y,"P",{"data-svelte-h":!0}),m(f)!=="svelte-3zwean"&&(f.textContent=T)},m(y,g){s(y,f,g)},p:Al,d(y){y&&l(f)}}}function an(I){let f,T,y,g,j,J,U,ot,_,Dl="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",ut,V,Pl='To get started, make sure you have <a href="../installation">configured your inf2 / trn1 instance</a>, and installed optimum:',rt,$,ct,v,Mt,N,Kl="To deploy models, you will need to compile them to TorchScript optimized for AWS Neuron. In the case of Stable Diffusion, there are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",dt,x,Ol="<li>Text encoder</li> <li>U-Net</li> <li>VAE encoder</li> <li>VAE decoder</li>",ft,R,es="You can either compile and export a Stable Diffusion Checkpoint via CLI or <code>NeuronStableDiffusionPipeline</code> class.",yt,k,ts="<strong><em>Export via CLI</em></strong>",ht,S,ls="Here is an example of exporting stable diffusion components with <code>Optimum</code> CLI:",bt,Y,gt,Q,ss="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",Jt,L,ns="<strong><em>Export via Python API</em></strong>",wt,F,as="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionPipeline</code>:",Tt,X,Ut,H,jt,z,Zt,E,is="<code>NeuronStableDiffusionPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",Wt,q,ps="With pre-compiled Stable Diffusion models, now generate an image with a prompt on Neuron:",Gt,A,It,Z,ms,Xt,D,Ct,P,os="With the <code>NeuronStableDiffusionImg2ImgPipeline</code> class, you can generate a new image conditioned on a text prompt and an initial image.",Bt,K,_t,O,us='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/03-sd-img2img-init.png" alt="landscape photo" width="256" height="256"/></td> <td align="center"><strong><em>ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. warm colors, 8K</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/04-sd-img2img.png" alt="drawing" width="250"/></td> <td align="right"></td></tr></tbody>',Vt,ee,$t,te,rs="With the <code>NeuronStableDiffusionInpaintPipeline</code> class, you can edit specific parts of an image by providing a mask and a text prompt.",vt,le,Nt,se,cs='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>Face of a yellow cat, high resolution, sitting on a park bench</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/05-sd-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',xt,ne,Rt,ae,Ms="Stable Diffusion XL (SDXL) is a latent diffusion model for text-to-image. Compared to the previous versions of Stable Diffusion models, it improves the quality of generated images with a times larger UNet.",kt,ie,St,pe,ds="To deploy SDXL models, we will also start by compiling the models. We support the export of following components in the pipeline to boost the speed:",Yt,me,fs="<li>Text encoder</li> <li>Second text encoder</li> <li>U-Net (a three times larger UNet than the one in Stable Diffusion pipeline)</li> <li>VAE encoder</li> <li>VAE decoder</li>",Qt,oe,ys="<strong><em>Export via CLI</em></strong>",Lt,ue,hs="Here is an example of exporting SDXL components with <code>Optimum</code> CLI:",Ft,re,Ht,ce,bs="We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with Optimum CLI on a CPU-only instance (needs ~92 GB memory), and then run the pre-compiled models on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.",zt,Me,gs="<strong><em>Export via Python API</em></strong>",Et,de,Js="Here is an example of exporting stable diffusion components with <code>NeuronStableDiffusionXLPipeline</code>:",qt,fe,At,ye,Dt,he,ws="With pre-compiled SDXL models, now generate an image with a text prompt on Neuron:",Pt,be,Kt,W,Ts,Ot,ge,el,Je,Us="With <code>NeuronStableDiffusionXLImg2ImgPipeline</code>, you can pass an initial image, and a text prompt to condition generated images:",tl,we,ll,Te,js='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>prompt</code></th> <th align="center">output</th> <th align="right"></th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png" alt="castle photo" width="256" height="256"/></td> <td align="center"><strong><em>a dog running, lake, moat</em></strong></td> <td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/06-sdxl-img2img.png" alt="castle with dog" width="250"/></td> <td align="right"></td></tr></tbody>',sl,Ue,nl,je,Zs="With <code>NeuronStableDiffusionXLInpaintPipeline</code>, pass the original image and a mask of what you want to replace in the original image. Then replace the masked area with content described in a prompt.",al,Ze,il,We,Ws='<thead><tr><th align="center"><code>image</code></th> <th align="center"><code>mask_image</code></th> <th align="center"><code>prompt</code></th> <th align="right">output</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png" alt="drawing" width="250"/></td> <td align="center"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png" alt="drawing" width="250"/></td> <td align="center"><strong><em>A deep sea diver floating</em></strong></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/07-sdxl-inpaint.png" alt="drawing" width="250"/></td></tr></tbody>',pl,Ge,ml,Ie,Gs='SDXL includes a <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">refiner model</a> to denoise low-noise stage images generated from the base model. There are two ways to use the refiner:',ol,Xe,Is="<li>use the base and refiner model together to produce a refined image.</li> <li>use the base model to produce an image, and subsequently use the refiner model to add more details to the image.</li>",ul,Ce,rl,Be,cl,G,Xs,Ml,_e,dl,Ve,fl,$e,Cs='<thead><tr><th align="center"><code>Base Image</code></th> <th align="right">Refined Image</th></tr></thead> <tbody><tr><td align="center"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/09-sdxl-base-full.png" alt="drawing" width="250"/></td> <td align="right"><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/010-sdxl-refiner-detailed.png" alt="drawing" width="250"/></td></tr></tbody>',yl,C,hl,ve,bl,Ne,Bs='Latent Consistency Models (LCMs) were proposed in <a href="https://huggingface.co/papers/2310.04378" rel="nofollow">Latent Consistency Models: Synthesizing High-Resolution Images with Few-Step Inference by Simian Luo, Yiqin Tan, Longbo Huang, Jian Li, and Hang Zhao</a>. LCMs enable inference with fewer steps on any pre-trained LDMs, including Stable Diffusion and SDXL.',gl,xe,_s="In <code>optimum-neuron</code>, you can:",Jl,Re,Vs="<li>Use the class <code>NeuronLatentConsistencyModelPipeline</code> to compile and run inference of LCMs distilled from Stable Diffusion (SD) models.</li> <li>And continue to use the class <code>NeuronStableDiffusionXLPipeline</code> for LCMs distilled from SDXL models.</li>",wl,ke,$s='Here are examples to compile the LCMs of Stable Diffusion ( <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> ) and Stable Diffusion XL( <a href="https://huggingface.co/latent-consistency/lcm-sdxl" rel="nofollow">latent-consistency/lcm-sdxl</a> ), and then run inference on AWS Inferentia 2 :',Tl,Se,Ul,Ye,vs="<strong><em>LCM of Stable Diffusion</em></strong>",jl,Qe,Zl,Le,Ns="<strong><em>LCM of Stable Diffusion XL</em></strong>",Wl,Fe,Gl,He,Il,ze,xs="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Xl,Ee,Rs="<strong><em>LCM of Stable Diffusion</em></strong>",Cl,qe,Bl,Ae,ks="<strong><em>LCM of Stable Diffusion XL</em></strong>",_l,De,Vl,Pe,$l,Ke,Ss='SDXL Turbo is an adversarial time-distilled Stable Diffusion XL (SDXL) model capable of running inference in as little as 1 step (<a href="https://huggingface.co/docs/diffusers/using-diffusers/sdxl_turbo" rel="nofollow">check <code>🤗diffusers</code> for more details</a>).',vl,Oe,Ys="In <code>optimum-neuron</code>, you can:",Nl,et,Qs="<li>Use the class <code>NeuronStableDiffusionXLPipeline</code> to compile and run inference.</li>",xl,tt,Ls='Here we will compile the <a href="https://huggingface.co/stabilityai/sdxl-turbo" rel="nofollow"><code>stabilityai/sdxl-turbo</code></a> model with Optimum CLI.',Rl,lt,kl,st,Sl,nt,Yl,at,Fs="Now we can generate images from text prompts on Inf2 using the pre-compiled model:",Ql,it,Ll,B,Fl,pt,Hs='Are there any other stable diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',Hl,mt,zl;return j=new h({props:{title:"Generate images with Stable Diffusion models on AWS Inferentia",local:"generate-images-with-stable-diffusion-models-on-aws-inferentia",headingTag:"h1"}}),U=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),$=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMm9wdGltdW0lNUJuZXVyb254JTJDJTIwZGlmZnVzZXJzJTVEJTIy",highlighted:'pip install <span class="hljs-string">&quot;optimum[neuronx, diffusers]&quot;</span>',wrap:!1}}),v=new h({props:{title:"Compile Stable Diffusion",local:"compile-stable-diffusion",headingTag:"h3"}}),Y=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMS1iYXNlJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbiUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDUxMiUyMCU2MCUyMyUyMGhlaWdodCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0td2lkdGglMjA1MTIlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDUxMiUyQyUyMDc2OCU2MCUyMCU1QyUwQSUyMCUyMC0tbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwNCUyMCU2MCUyMyUyMG51bWJlciUyMG9mJTIwaW1hZ2VzJTIwdG8lMjBnZW5lcmF0ZSUyMHBlciUyMHByb21wdCUyQyUyMGRlZmF1bHRzJTIwdG8lMjAxJTYwJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3QlMjBtYXRtdWwlMjAlNjAlMjMlMjBjYXN0JTIwb25seSUyMG1hdHJpeCUyMG11bHRpcGxpY2F0aW9uJTIwb3BlcmF0aW9ucyU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwJTYwJTIzJTIwY2FzdCUyMG9wZXJhdGlvbnMlMjBmcm9tJTIwRlAzMiUyMHRvJTIwQkYxNiU2MCUyMCU1QyUwQSUyMCUyMHNkX25ldXJvbiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-2-1-base \\\n  --task stable-diffusion \\\n  --batch_size 1 \\\n  --height 512 `<span class="hljs-comment"># height in pixels of generated image, eg. 512, 768` \\</span>\n  --width 512 `<span class="hljs-comment"># width in pixels of generated image, eg. 512, 768` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron/',wrap:!1}}),X=new ql({props:{$$slots:{default:[ln]},$$scope:{ctx:I}}}),H=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKSUwQSUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIyc2RfbmV1cm9uJTJGJTIyJTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBc3RhYmxlX2RpZmZ1c2lvbi5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1uZXVyb24tcmVwbyUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),z=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),A=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbiUyRiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBaW1hZ2UlMjAlM0QlMjBzdGFibGVfZGlmZnVzaW9uKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion = NeuronStableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),D=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),K=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBJTIzJTIwY29tcGlsZSUyMCUyNiUyMHNhdmUlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm5pdHJvc29ja2UlMkZHaGlibGktRGlmZnVzaW9uJTIyJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiU3RCUwQXBpcGVsaW5lJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmlucHV0X3NoYXBlcyklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyc2RfaW1nMmltZyUyRiUyMiklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQSUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyZ2hpYmxpJTIwc3R5bGUlMkMlMjBhJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyMHdpdGglMjBzbm93Y2FwcGVkJTIwbW91bnRhaW5zJTJDJTIwdHJlZXMlMkMlMjBsYWtlJTIwd2l0aCUyMGRldGFpbGVkJTIwcmVmbGVjdGlvbi4lMjBzdW5saWdodCUyMGFuZCUyMGNsb3VkJTIwaW4lMjB0aGUlMjBza3klMkMlMjB3YXJtJTIwY29sb3JzJTJDJTIwOEslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionImg2ImgPipeline

<span class="hljs-comment"># compile &amp; save</span>
model_id = <span class="hljs-string">&quot;nitrosocke/Ghibli-Diffusion&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_img2img/&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;ghibli style, a fantasy landscape with snowcapped mountains, trees, lake with detailed reflection. sunlight and cloud in the sky, warm colors, 8K&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),ee=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),le=new b({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24taW5wYWludGluZyUyMiUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwNTEyJTJDJTIwJTIyd2lkdGglMjIlM0ElMjA1MTIlN0QlMEFwaXBlbGluZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlJTJDJTIwKippbnB1dF9zaGFwZXMpJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnNkX2lucGFpbnQlMkYlMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1by5wbmclMjIlMEFtYXNrX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvX21hc2sucG5nJTIyJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKGltZ191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UobWFza191cmwpLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyY2F0X29uX2JlbmNoLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>}
pipeline = NeuronStableDiffusionInpaintPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **input_shapes)
pipeline.save_pretrained(<span class="hljs-string">&quot;sd_inpaint/&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat_on_bench.png&quot;</span>)`,wrap:!1}}),ne=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ie=new h({props:{title:"Compile Stable Diffusion XL",local:"compile-stable-diffusion-xl",headingTag:"h3"}}),re=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIwJTVDJTBBJTIwJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMCU1QyUwQSUyMCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAtLWhlaWdodCUyMDEwMjQlMjAlNjAlMjMlMjBoZWlnaHQlMjBpbiUyMHBpeGVscyUyMG9mJTIwZ2VuZXJhdGVkJTIwaW1hZ2UlMkMlMjBlZy4lMjA3NjglMkMlMjAxMDI0JTYwJTIwJTVDJTBBJTIwJTIwLS13aWR0aCUyMDEwMjQlMjAlNjAlMjMlMjB3aWR0aCUyMGluJTIwcGl4ZWxzJTIwb2YlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyQyUyMGVnLiUyMDc2OCUyQyUyMDEwMjQlNjAlMjAlNUMlMEElMjAlMjAtLW51bV9pbWFnZXNfcGVyX3Byb21wdCUyMDQlMjAlNjAlMjMlMjBudW1iZXIlMjBvZiUyMGltYWdlcyUyMHRvJTIwZ2VuZXJhdGUlMjBwZXIlMjBwcm9tcHQlMkMlMjBkZWZhdWx0cyUyMHRvJTIwMSU2MCUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTYwJTIzJTIwY2FzdCUyMG9ubHklMjBtYXRyaXglMjBtdWx0aXBsaWNhdGlvbiUyMG9wZXJhdGlvbnMlNjAlMjAlNUMlMEElMjAlMjAtLWF1dG9fY2FzdF90eXBlJTIwYmYxNiUyMCU2MCUyMyUyMGNhc3QlMjBvcGVyYXRpb25zJTIwZnJvbSUyMEZQMzIlMjB0byUyMEJGMTYlNjAlMjAlNUMlMEElMjAlMjBzZF9uZXVyb25feGwlMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/stable-diffusion-xl-base-1.0 \\\n  --task stable-diffusion-xl \\\n  --batch_size 1 \\\n  --height 1024 `<span class="hljs-comment"># height in pixels of generated image, eg. 768, 1024` \\</span>\n  --width 1024 `<span class="hljs-comment"># width in pixels of generated image, eg. 768, 1024` \\</span>\n  --num_images_per_prompt 4 `<span class="hljs-comment"># number of images to generate per prompt, defaults to 1` \\</span>\n  --auto_cast matmul `<span class="hljs-comment"># cast only matrix multiplication operations` \\</span>\n  --auto_cast_type bf16 `<span class="hljs-comment"># cast operations from FP32 to BF16` \\</span>\n  sd_neuron_xl/',wrap:!1}}),fe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMmF1dG9fY2FzdCUyMiUzQSUyMCUyMm1hdG11bCUyMiUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJTIyYmYxNiUyMiU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCU3RCUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX25ldXJvbl94bCUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb25feGwuc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQXN0YWJsZV9kaWZmdXNpb25feGwucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIybXktbmV1cm9uLXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally or upload to the HuggingFace Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl.push_to_hub(
<span class="hljs-meta">... </span>    save_directory, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ye=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),be=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXN0YWJsZV9kaWZmdXNpb25feGwlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWltYWdlJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl94bChwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>stable_diffusion_xl = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = stable_diffusion_xl(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ge=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),we=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjBydW5uaW5nJTJDJTIwbGFrZSUyQyUyMG1vYXQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZvcHRpbXVtJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmludGVsJTJGb3BlbnZpbm8lMkZzZF94bCUyRmNhc3RsZV9mcmllZHJpY2gucG5nJTIyJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFwaXBlJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bCUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

prompt = <span class="hljs-string">&quot;a dog running, lake, moat&quot;</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
init_image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

pipe = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ue=new h({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),Ze=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbnBhaW50UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZzZHhsLXRleHQyaW1nLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnNkeGwtaW5wYWludC1tYXNrLnBuZyUyMiUwQSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWdfdXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShtYXNrX3VybCkuY29udmVydCglMjJSR0IlMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGRlZXAlMjBzZWElMjBkaXZlciUyMGZsb2F0aW5nJTIyJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW5wYWludFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjg1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMi41KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLInpaintPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-text2img.png&quot;</span>
mask_url = (
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl-inpaint-mask.png&quot;</span>
)

init_image = load_image(img_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
mask_image = load_image(mask_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;A deep sea diver floating&quot;</span>

pipe = NeuronStableDiffusionXLInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = pipe(prompt=prompt, image=init_image, mask_image=mask_image, strength=<span class="hljs-number">0.85</span>, guidance_scale=<span class="hljs-number">12.5</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ge=new h({props:{title:"Refine Image Quality",local:"refine-image-quality",headingTag:"h3"}}),Ce=new h({props:{title:"Base + refiner model",local:"base--refiner-model",headingTag:"h4"}}),Be=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXNfcGVyX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMGRlbm9pc2luZ19lbmQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWRlbCUyMGJhc2UlMjAlMjAlMjMlMjBUbyUyMGF2b2lkJTIwbmV1cm9uJTIwZGV2aWNlJTIwT09NJTBBJTBBcmVmaW5lciUyMCUzRCUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGxfcmVmaW5lciUyRiUyMiklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTIwJTNEJTIwcmVmaW5lciglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAlMkMlMEElMjAlMjAlMjAlMjBkZW5vaXNpbmdfc3RhcnQlM0QwLjglMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(
    prompt=prompt,
    num_images_per_prompt=num_images_per_prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_end=<span class="hljs-number">0.8</span>,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = image = refiner(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">40</span>,
    denoising_start=<span class="hljs-number">0.8</span>,
    image=image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_e=new h({props:{title:"Base to refiner model",local:"base-to-refiner-model",headingTag:"h4"}}),Ve=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUyQyUyME5ldXJvblN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMG1hamVzdGljJTIwbGlvbiUyMGp1bXBpbmclMjBmcm9tJTIwYSUyMGJpZyUyMHN0b25lJTIwYXQlMjBuaWdodCUyMiUwQWJhc2UlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZF9uZXVyb25feGwlMkYlMjIpJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBZGVsJTIwYmFzZSUyMCUyMCUyMyUyMFRvJTIwYXZvaWQlMjBuZXVyb24lMjBkZXZpY2UlMjBPT00lMEElMEFyZWZpbmVyJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnNkX25ldXJvbl94bF9yZWZpbmVyJTJGJTIyKSUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline, NeuronStableDiffusionXLImg2ImgPipeline

prompt = <span class="hljs-string">&quot;A majestic lion jumping from a big stone at night&quot;</span>
base = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl/&quot;</span>)
image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-keyword">del</span> base  <span class="hljs-comment"># To avoid neuron device OOM</span>

refiner = NeuronStableDiffusionXLImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;sd_neuron_xl_refiner/&quot;</span>)
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),C=new ql({props:{$$slots:{default:[sn]},$$scope:{ctx:I}}}),ve=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),Se=new h({props:{title:"Compile LCM",local:"compile-lcm",headingTag:"h3"}}),Qe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMEFudW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAlM0QlMjAxJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA3NjglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDc2OCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZF9uZXVyb24lMkYlMjIlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSklMEElMEElMjMlMjBQdXNoJTIwdG8lMjBodWIlMEFzdGFibGVfZGlmZnVzaW9uLnB1c2hfdG9faHViKHNhdmVfZGlyZWN0b3J5JTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMkppbmd5YSUyRkxDTV9EcmVhbXNoYXBlcl92N19uZXVyb254JTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">768</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronLatentConsistencyModelPipeline.from_pretrained(
    model_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sd_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),Fe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTBBdW5ldF9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1zZHhsJTIyJTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMSUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyaGVpZ2h0JTIyJTNBJTIwMTAyNCUyQyUyMCUyMndpZHRoJTIyJTNBJTIwMTAyNCUyQyUyMCUyMm51bV9pbWFnZXNfcGVyX3Byb21wdCUyMiUzQSUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCU3RCUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJtYXRtdWwlMjIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCUyMmJmMTYlMjIlN0QlMEElMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjB1bmV0X2lkJTNEdW5ldF9pZCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUwQSklMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMmxjbV9zZHhsX25ldXJvbiUyRiUyMiUwQXN0YWJsZV9kaWZmdXNpb24uc2F2ZV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5KSUwQSUwQSUyMyUyMFB1c2glMjB0byUyMGh1YiUwQXN0YWJsZV9kaWZmdXNpb24ucHVzaF90b19odWIoc2F2ZV9kaXJlY3RvcnklMkMlMjByZXBvc2l0b3J5X2lkJTNEJTIySmluZ3lhJTJGbGNtLXNkeGwtbmV1cm9ueCUyMiUyQyUyMHVzZV9hdXRoX3Rva2VuJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
unet_id = <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>
num_images_per_prompt = <span class="hljs-number">1</span>
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">1024</span>, <span class="hljs-string">&quot;num_images_per_prompt&quot;</span>: num_images_per_prompt}
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;matmul&quot;</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>}

stable_diffusion = NeuronStableDiffusionXLPipeline.from_pretrained(
    model_id, unet_id=unet_id, export=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes
)
save_directory = <span class="hljs-string">&quot;lcm_sdxl_neuron/&quot;</span>
stable_diffusion.save_pretrained(save_directory)

<span class="hljs-comment"># Push to hub</span>
stable_diffusion.push_to_hub(save_directory, repository_id=<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)`,wrap:!1}}),He=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),qe=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTGF0ZW50Q29uc2lzdGVuY3lNb2RlbFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyME5ldXJvbkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGTENNX0RyZWFtc2hhcGVyX3Y3X25ldXJvbnglMjIpJTBBcHJvbXB0cyUyMCUzRCUyMCU1QiUyMlNlbGYtcG9ydHJhaXQlMjBvaWwlMjBwYWludGluZyUyQyUyMGElMjBiZWF1dGlmdWwlMjBjeWJvcmclMjB3aXRoJTIwZ29sZGVuJTIwaGFpciUyQyUyMDhrJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronLatentConsistencyModelPipeline

pipe = NeuronLatentConsistencyModelPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/LCM_Dreamshaper_v7_neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),De=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZsY20tc2R4bC1uZXVyb254JTIyKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJhJTIwY2xvc2UtdXAlMjBwaWN0dXJlJTIwb2YlMjBhbiUyMG9sZCUyMG1hbiUyMHN0YW5kaW5nJTIwaW4lMjB0aGUlMjByYWluJTIyJTVEJTIwKiUyMDIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdHMlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/lcm-sdxl-neuronx&quot;</span>)
prompts = [<span class="hljs-string">&quot;a close-up picture of an old man standing in the rain&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompts, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),Pe=new h({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h2"}}),lt=new h({props:{title:"Compile SDXL Turbo",local:"compile-sdxl-turbo",headingTag:"h3"}}),st=new b({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIwLS10YXNrJTIwc3RhYmxlLWRpZmZ1c2lvbi14bCUyMC0tYmF0Y2hfc2l6ZSUyMDElMjAtLWhlaWdodCUyMDUxMiUyMC0td2lkdGglMjA1MTIlMjAtLWF1dG9fY2FzdCUyMG1hdG11bCUyMC0tYXV0b19jYXN0X3R5cGUlMjBiZjE2JTIwc2R4bF90dXJib19uZXVyb24lMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model stabilityai/sdxl-turbo --task stable-diffusion-xl --batch_size 1 --height 512 --width 512 --auto_cast matmul --auto_cast_type bf16 sdxl_turbo_neuron/',wrap:!1}}),nt=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),it=new b({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBOZXVyb25TdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzZHhsX3R1cmJvX25ldXJvbiUyRiUyMiUyQyUyMGRhdGFfcGFyYWxsZWxfbW9kZSUzRCUyMmFsbCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlNUIlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiU1RCUyMColMjAyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronStableDiffusionXLPipeline

pipe = NeuronStableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;sdxl_turbo_neuron/&quot;</span>, data_parallel_mode=<span class="hljs-string">&quot;all&quot;</span>)
prompt = [<span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>] * <span class="hljs-number">2</span>

images = pipe(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images`,wrap:!1}}),B=new ql({props:{$$slots:{default:[nn]},$$scope:{ctx:I}}}),{c(){f=i("meta"),T=n(),y=i("p"),g=n(),o(j.$$.fragment),J=n(),o(U.$$.fragment),ot=n(),_=i("p"),_.innerHTML=Dl,ut=n(),V=i("p"),V.innerHTML=Pl,rt=n(),o($.$$.fragment),ct=n(),o(v.$$.fragment),Mt=n(),N=i("p"),N.innerHTML=Kl,dt=n(),x=i("ul"),x.innerHTML=Ol,ft=n(),R=i("p"),R.innerHTML=es,yt=n(),k=i("p"),k.innerHTML=ts,ht=n(),S=i("p"),S.innerHTML=ls,bt=n(),o(Y.$$.fragment),gt=n(),Q=i("p"),Q.innerHTML=ss,Jt=n(),L=i("p"),L.innerHTML=ns,wt=n(),F=i("p"),F.innerHTML=as,Tt=n(),o(X.$$.fragment),Ut=n(),o(H.$$.fragment),jt=n(),o(z.$$.fragment),Zt=n(),E=i("p"),E.innerHTML=is,Wt=n(),q=i("p"),q.textContent=ps,Gt=n(),o(A.$$.fragment),It=n(),Z=i("img"),Xt=n(),o(D.$$.fragment),Ct=n(),P=i("p"),P.innerHTML=os,Bt=n(),o(K.$$.fragment),_t=n(),O=i("table"),O.innerHTML=us,Vt=n(),o(ee.$$.fragment),$t=n(),te=i("p"),te.innerHTML=rs,vt=n(),o(le.$$.fragment),Nt=n(),se=i("table"),se.innerHTML=cs,xt=n(),o(ne.$$.fragment),Rt=n(),ae=i("p"),ae.textContent=Ms,kt=n(),o(ie.$$.fragment),St=n(),pe=i("p"),pe.textContent=ds,Yt=n(),me=i("ul"),me.innerHTML=fs,Qt=n(),oe=i("p"),oe.innerHTML=ys,Lt=n(),ue=i("p"),ue.innerHTML=hs,Ft=n(),o(re.$$.fragment),Ht=n(),ce=i("p"),ce.innerHTML=bs,zt=n(),Me=i("p"),Me.innerHTML=gs,Et=n(),de=i("p"),de.innerHTML=Js,qt=n(),o(fe.$$.fragment),At=n(),o(ye.$$.fragment),Dt=n(),he=i("p"),he.textContent=ws,Pt=n(),o(be.$$.fragment),Kt=n(),W=i("img"),Ot=n(),o(ge.$$.fragment),el=n(),Je=i("p"),Je.innerHTML=Us,tl=n(),o(we.$$.fragment),ll=n(),Te=i("table"),Te.innerHTML=js,sl=n(),o(Ue.$$.fragment),nl=n(),je=i("p"),je.innerHTML=Zs,al=n(),o(Ze.$$.fragment),il=n(),We=i("table"),We.innerHTML=Ws,pl=n(),o(Ge.$$.fragment),ml=n(),Ie=i("p"),Ie.innerHTML=Gs,ol=n(),Xe=i("ol"),Xe.innerHTML=Is,ul=n(),o(Ce.$$.fragment),rl=n(),o(Be.$$.fragment),cl=n(),G=i("img"),Ml=n(),o(_e.$$.fragment),dl=n(),o(Ve.$$.fragment),fl=n(),$e=i("table"),$e.innerHTML=Cs,yl=n(),o(C.$$.fragment),hl=n(),o(ve.$$.fragment),bl=n(),Ne=i("p"),Ne.innerHTML=Bs,gl=n(),xe=i("p"),xe.innerHTML=_s,Jl=n(),Re=i("ul"),Re.innerHTML=Vs,wl=n(),ke=i("p"),ke.innerHTML=$s,Tl=n(),o(Se.$$.fragment),Ul=n(),Ye=i("p"),Ye.innerHTML=vs,jl=n(),o(Qe.$$.fragment),Zl=n(),Le=i("p"),Le.innerHTML=Ns,Wl=n(),o(Fe.$$.fragment),Gl=n(),o(He.$$.fragment),Il=n(),ze=i("p"),ze.textContent=xs,Xl=n(),Ee=i("p"),Ee.innerHTML=Rs,Cl=n(),o(qe.$$.fragment),Bl=n(),Ae=i("p"),Ae.innerHTML=ks,_l=n(),o(De.$$.fragment),Vl=n(),o(Pe.$$.fragment),$l=n(),Ke=i("p"),Ke.innerHTML=Ss,vl=n(),Oe=i("p"),Oe.innerHTML=Ys,Nl=n(),et=i("ul"),et.innerHTML=Qs,xl=n(),tt=i("p"),tt.innerHTML=Ls,Rl=n(),o(lt.$$.fragment),kl=n(),o(st.$$.fragment),Sl=n(),o(nt.$$.fragment),Yl=n(),at=i("p"),at.textContent=Fs,Ql=n(),o(it.$$.fragment),Ll=n(),o(B.$$.fragment),Fl=n(),pt=i("p"),pt.innerHTML=Hs,Hl=n(),mt=i("p"),this.h()},l(e){const t=en("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),T=a(e),y=p(e,"P",{}),As(y).forEach(l),g=a(e),u(j.$$.fragment,e),J=a(e),u(U.$$.fragment,e),ot=a(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1g87d8z"&&(_.innerHTML=Dl),ut=a(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1u4t7n7"&&(V.innerHTML=Pl),rt=a(e),u($.$$.fragment,e),ct=a(e),u(v.$$.fragment,e),Mt=a(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-3qllio"&&(N.innerHTML=Kl),dt=a(e),x=p(e,"UL",{"data-svelte-h":!0}),m(x)!=="svelte-1c1t3y0"&&(x.innerHTML=Ol),ft=a(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-15y00oa"&&(R.innerHTML=es),yt=a(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1a2m8iq"&&(k.innerHTML=ts),ht=a(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-ktaj8q"&&(S.innerHTML=ls),bt=a(e),u(Y.$$.fragment,e),gt=a(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-jz092x"&&(Q.innerHTML=ss),Jt=a(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-kxhd34"&&(L.innerHTML=ns),wt=a(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1bahy14"&&(F.innerHTML=as),Tt=a(e),u(X.$$.fragment,e),Ut=a(e),u(H.$$.fragment,e),jt=a(e),u(z.$$.fragment,e),Zt=a(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1r61oa5"&&(E.innerHTML=is),Wt=a(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1q8fgqb"&&(q.textContent=ps),Gt=a(e),u(A.$$.fragment,e),It=a(e),Z=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Xt=a(e),u(D.$$.fragment,e),Ct=a(e),P=p(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-kqnotf"&&(P.innerHTML=os),Bt=a(e),u(K.$$.fragment,e),_t=a(e),O=p(e,"TABLE",{"data-svelte-h":!0}),m(O)!=="svelte-i6e2ex"&&(O.innerHTML=us),Vt=a(e),u(ee.$$.fragment,e),$t=a(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-vhijyl"&&(te.innerHTML=rs),vt=a(e),u(le.$$.fragment,e),Nt=a(e),se=p(e,"TABLE",{"data-svelte-h":!0}),m(se)!=="svelte-v8z5s8"&&(se.innerHTML=cs),xt=a(e),u(ne.$$.fragment,e),Rt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-7xctqf"&&(ae.textContent=Ms),kt=a(e),u(ie.$$.fragment,e),St=a(e),pe=p(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-u4wwem"&&(pe.textContent=ds),Yt=a(e),me=p(e,"UL",{"data-svelte-h":!0}),m(me)!=="svelte-17e9k9s"&&(me.innerHTML=fs),Qt=a(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-1a2m8iq"&&(oe.innerHTML=ys),Lt=a(e),ue=p(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-9niqj3"&&(ue.innerHTML=hs),Ft=a(e),u(re.$$.fragment,e),Ht=a(e),ce=p(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-eias7g"&&(ce.innerHTML=bs),zt=a(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-kxhd34"&&(Me.innerHTML=gs),Et=a(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-17tzr0c"&&(de.innerHTML=Js),qt=a(e),u(fe.$$.fragment,e),At=a(e),u(ye.$$.fragment,e),Dt=a(e),he=p(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-8q3qyn"&&(he.textContent=ws),Pt=a(e),u(be.$$.fragment,e),Kt=a(e),W=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ot=a(e),u(ge.$$.fragment,e),el=a(e),Je=p(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-luub4o"&&(Je.innerHTML=Us),tl=a(e),u(we.$$.fragment,e),ll=a(e),Te=p(e,"TABLE",{"data-svelte-h":!0}),m(Te)!=="svelte-1s0d0pv"&&(Te.innerHTML=js),sl=a(e),u(Ue.$$.fragment,e),nl=a(e),je=p(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-11fbw00"&&(je.innerHTML=Zs),al=a(e),u(Ze.$$.fragment,e),il=a(e),We=p(e,"TABLE",{"data-svelte-h":!0}),m(We)!=="svelte-18741xe"&&(We.innerHTML=Ws),pl=a(e),u(Ge.$$.fragment,e),ml=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-1usq821"&&(Ie.innerHTML=Gs),ol=a(e),Xe=p(e,"OL",{"data-svelte-h":!0}),m(Xe)!=="svelte-6p4eqi"&&(Xe.innerHTML=Is),ul=a(e),u(Ce.$$.fragment,e),rl=a(e),u(Be.$$.fragment,e),cl=a(e),G=p(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),Ml=a(e),u(_e.$$.fragment,e),dl=a(e),u(Ve.$$.fragment,e),fl=a(e),$e=p(e,"TABLE",{"data-svelte-h":!0}),m($e)!=="svelte-1s7g03c"&&($e.innerHTML=Cs),yl=a(e),u(C.$$.fragment,e),hl=a(e),u(ve.$$.fragment,e),bl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1ud6a8q"&&(Ne.innerHTML=Bs),gl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-1ayizu6"&&(xe.innerHTML=_s),Jl=a(e),Re=p(e,"UL",{"data-svelte-h":!0}),m(Re)!=="svelte-r4tdj0"&&(Re.innerHTML=Vs),wl=a(e),ke=p(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-c4lhmw"&&(ke.innerHTML=$s),Tl=a(e),u(Se.$$.fragment,e),Ul=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1s0vvjb"&&(Ye.innerHTML=vs),jl=a(e),u(Qe.$$.fragment,e),Zl=a(e),Le=p(e,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-51zp7x"&&(Le.innerHTML=Ns),Wl=a(e),u(Fe.$$.fragment,e),Gl=a(e),u(He.$$.fragment,e),Il=a(e),ze=p(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1ebkvay"&&(ze.textContent=xs),Xl=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-1s0vvjb"&&(Ee.innerHTML=Rs),Cl=a(e),u(qe.$$.fragment,e),Bl=a(e),Ae=p(e,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-51zp7x"&&(Ae.innerHTML=ks),_l=a(e),u(De.$$.fragment,e),Vl=a(e),u(Pe.$$.fragment,e),$l=a(e),Ke=p(e,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-10h80ju"&&(Ke.innerHTML=Ss),vl=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-1ayizu6"&&(Oe.innerHTML=Ys),Nl=a(e),et=p(e,"UL",{"data-svelte-h":!0}),m(et)!=="svelte-t7g18i"&&(et.innerHTML=Qs),xl=a(e),tt=p(e,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-ohwj0a"&&(tt.innerHTML=Ls),Rl=a(e),u(lt.$$.fragment,e),kl=a(e),u(st.$$.fragment,e),Sl=a(e),u(nt.$$.fragment,e),Yl=a(e),at=p(e,"P",{"data-svelte-h":!0}),m(at)!=="svelte-1ebkvay"&&(at.textContent=Fs),Ql=a(e),u(it.$$.fragment,e),Ll=a(e),u(B.$$.fragment,e),Fl=a(e),pt=p(e,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-xbi604"&&(pt.innerHTML=Hs),Hl=a(e),mt=p(e,"P",{}),As(mt).forEach(l),this.h()},h(){w(f,"name","hf:doc:metadata"),w(f,"content",pn),El(Z.src,ms="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/01-sd-image.png")||w(Z,"src",ms),w(Z,"width","256"),w(Z,"height","256"),w(Z,"alt","stable diffusion generated image"),El(W.src,Ts="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/models/02-sdxl-image.jpeg")||w(W,"src",Ts),w(W,"width","256"),w(W,"height","256"),w(W,"alt","sdxl generated image"),El(G.src,Xs="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/neuron/models/08-sdxl-base-refine.png")||w(G,"src",Xs),w(G,"width","256"),w(G,"height","256"),w(G,"alt","sdxl base + refiner")},m(e,t){tn(document.head,f),s(e,T,t),s(e,y,t),s(e,g,t),r(j,e,t),s(e,J,t),r(U,e,t),s(e,ot,t),s(e,_,t),s(e,ut,t),s(e,V,t),s(e,rt,t),r($,e,t),s(e,ct,t),r(v,e,t),s(e,Mt,t),s(e,N,t),s(e,dt,t),s(e,x,t),s(e,ft,t),s(e,R,t),s(e,yt,t),s(e,k,t),s(e,ht,t),s(e,S,t),s(e,bt,t),r(Y,e,t),s(e,gt,t),s(e,Q,t),s(e,Jt,t),s(e,L,t),s(e,wt,t),s(e,F,t),s(e,Tt,t),r(X,e,t),s(e,Ut,t),r(H,e,t),s(e,jt,t),r(z,e,t),s(e,Zt,t),s(e,E,t),s(e,Wt,t),s(e,q,t),s(e,Gt,t),r(A,e,t),s(e,It,t),s(e,Z,t),s(e,Xt,t),r(D,e,t),s(e,Ct,t),s(e,P,t),s(e,Bt,t),r(K,e,t),s(e,_t,t),s(e,O,t),s(e,Vt,t),r(ee,e,t),s(e,$t,t),s(e,te,t),s(e,vt,t),r(le,e,t),s(e,Nt,t),s(e,se,t),s(e,xt,t),r(ne,e,t),s(e,Rt,t),s(e,ae,t),s(e,kt,t),r(ie,e,t),s(e,St,t),s(e,pe,t),s(e,Yt,t),s(e,me,t),s(e,Qt,t),s(e,oe,t),s(e,Lt,t),s(e,ue,t),s(e,Ft,t),r(re,e,t),s(e,Ht,t),s(e,ce,t),s(e,zt,t),s(e,Me,t),s(e,Et,t),s(e,de,t),s(e,qt,t),r(fe,e,t),s(e,At,t),r(ye,e,t),s(e,Dt,t),s(e,he,t),s(e,Pt,t),r(be,e,t),s(e,Kt,t),s(e,W,t),s(e,Ot,t),r(ge,e,t),s(e,el,t),s(e,Je,t),s(e,tl,t),r(we,e,t),s(e,ll,t),s(e,Te,t),s(e,sl,t),r(Ue,e,t),s(e,nl,t),s(e,je,t),s(e,al,t),r(Ze,e,t),s(e,il,t),s(e,We,t),s(e,pl,t),r(Ge,e,t),s(e,ml,t),s(e,Ie,t),s(e,ol,t),s(e,Xe,t),s(e,ul,t),r(Ce,e,t),s(e,rl,t),r(Be,e,t),s(e,cl,t),s(e,G,t),s(e,Ml,t),r(_e,e,t),s(e,dl,t),r(Ve,e,t),s(e,fl,t),s(e,$e,t),s(e,yl,t),r(C,e,t),s(e,hl,t),r(ve,e,t),s(e,bl,t),s(e,Ne,t),s(e,gl,t),s(e,xe,t),s(e,Jl,t),s(e,Re,t),s(e,wl,t),s(e,ke,t),s(e,Tl,t),r(Se,e,t),s(e,Ul,t),s(e,Ye,t),s(e,jl,t),r(Qe,e,t),s(e,Zl,t),s(e,Le,t),s(e,Wl,t),r(Fe,e,t),s(e,Gl,t),r(He,e,t),s(e,Il,t),s(e,ze,t),s(e,Xl,t),s(e,Ee,t),s(e,Cl,t),r(qe,e,t),s(e,Bl,t),s(e,Ae,t),s(e,_l,t),r(De,e,t),s(e,Vl,t),r(Pe,e,t),s(e,$l,t),s(e,Ke,t),s(e,vl,t),s(e,Oe,t),s(e,Nl,t),s(e,et,t),s(e,xl,t),s(e,tt,t),s(e,Rl,t),r(lt,e,t),s(e,kl,t),r(st,e,t),s(e,Sl,t),r(nt,e,t),s(e,Yl,t),s(e,at,t),s(e,Ql,t),r(it,e,t),s(e,Ll,t),r(B,e,t),s(e,Fl,t),s(e,pt,t),s(e,Hl,t),s(e,mt,t),zl=!0},p(e,[t]){const zs={};t&2&&(zs.$$scope={dirty:t,ctx:e}),X.$set(zs);const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),C.$set(Es);const qs={};t&2&&(qs.$$scope={dirty:t,ctx:e}),B.$set(qs)},i(e){zl||(c(j.$$.fragment,e),c(U.$$.fragment,e),c($.$$.fragment,e),c(v.$$.fragment,e),c(Y.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(z.$$.fragment,e),c(A.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(fe.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(Ze.$$.fragment,e),c(Ge.$$.fragment,e),c(Ce.$$.fragment,e),c(Be.$$.fragment,e),c(_e.$$.fragment,e),c(Ve.$$.fragment,e),c(C.$$.fragment,e),c(ve.$$.fragment,e),c(Se.$$.fragment,e),c(Qe.$$.fragment,e),c(Fe.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),c(De.$$.fragment,e),c(Pe.$$.fragment,e),c(lt.$$.fragment,e),c(st.$$.fragment,e),c(nt.$$.fragment,e),c(it.$$.fragment,e),c(B.$$.fragment,e),zl=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M($.$$.fragment,e),M(v.$$.fragment,e),M(Y.$$.fragment,e),M(X.$$.fragment,e),M(H.$$.fragment,e),M(z.$$.fragment,e),M(A.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(fe.$$.fragment,e),M(ye.$$.fragment,e),M(be.$$.fragment,e),M(ge.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(Ze.$$.fragment,e),M(Ge.$$.fragment,e),M(Ce.$$.fragment,e),M(Be.$$.fragment,e),M(_e.$$.fragment,e),M(Ve.$$.fragment,e),M(C.$$.fragment,e),M(ve.$$.fragment,e),M(Se.$$.fragment,e),M(Qe.$$.fragment,e),M(Fe.$$.fragment,e),M(He.$$.fragment,e),M(qe.$$.fragment,e),M(De.$$.fragment,e),M(Pe.$$.fragment,e),M(lt.$$.fragment,e),M(st.$$.fragment,e),M(nt.$$.fragment,e),M(it.$$.fragment,e),M(B.$$.fragment,e),zl=!1},d(e){e&&(l(T),l(y),l(g),l(J),l(ot),l(_),l(ut),l(V),l(rt),l(ct),l(Mt),l(N),l(dt),l(x),l(ft),l(R),l(yt),l(k),l(ht),l(S),l(bt),l(gt),l(Q),l(Jt),l(L),l(wt),l(F),l(Tt),l(Ut),l(jt),l(Zt),l(E),l(Wt),l(q),l(Gt),l(It),l(Z),l(Xt),l(Ct),l(P),l(Bt),l(_t),l(O),l(Vt),l($t),l(te),l(vt),l(Nt),l(se),l(xt),l(Rt),l(ae),l(kt),l(St),l(pe),l(Yt),l(me),l(Qt),l(oe),l(Lt),l(ue),l(Ft),l(Ht),l(ce),l(zt),l(Me),l(Et),l(de),l(qt),l(At),l(Dt),l(he),l(Pt),l(Kt),l(W),l(Ot),l(el),l(Je),l(tl),l(ll),l(Te),l(sl),l(nl),l(je),l(al),l(il),l(We),l(pl),l(ml),l(Ie),l(ol),l(Xe),l(ul),l(rl),l(cl),l(G),l(Ml),l(dl),l(fl),l($e),l(yl),l(hl),l(bl),l(Ne),l(gl),l(xe),l(Jl),l(Re),l(wl),l(ke),l(Tl),l(Ul),l(Ye),l(jl),l(Zl),l(Le),l(Wl),l(Gl),l(Il),l(ze),l(Xl),l(Ee),l(Cl),l(Bl),l(Ae),l(_l),l(Vl),l($l),l(Ke),l(vl),l(Oe),l(Nl),l(et),l(xl),l(tt),l(Rl),l(kl),l(Sl),l(Yl),l(at),l(Ql),l(Ll),l(Fl),l(pt),l(Hl),l(mt)),l(f),d(j,e),d(U,e),d($,e),d(v,e),d(Y,e),d(X,e),d(H,e),d(z,e),d(A,e),d(D,e),d(K,e),d(ee,e),d(le,e),d(ne,e),d(ie,e),d(re,e),d(fe,e),d(ye,e),d(be,e),d(ge,e),d(we,e),d(Ue,e),d(Ze,e),d(Ge,e),d(Ce,e),d(Be,e),d(_e,e),d(Ve,e),d(C,e),d(ve,e),d(Se,e),d(Qe,e),d(Fe,e),d(He,e),d(qe,e),d(De,e),d(Pe,e),d(lt,e),d(st,e),d(nt,e),d(it,e),d(B,e)}}}const pn='{"title":"Generate images with Stable Diffusion models on AWS Inferentia","local":"generate-images-with-stable-diffusion-models-on-aws-inferentia","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Compile Stable Diffusion","local":"compile-stable-diffusion","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Compile Stable Diffusion XL","local":"compile-stable-diffusion-xl","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3},{"title":"Refine Image Quality","local":"refine-image-quality","sections":[{"title":"Base + refiner model","local":"base--refiner-model","sections":[],"depth":4},{"title":"Base to refiner model","local":"base-to-refiner-model","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Compile LCM","local":"compile-lcm","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Compile SDXL Turbo","local":"compile-sdxl-turbo","sections":[],"depth":3},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function mn(I){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dn extends Ks{constructor(f){super(),Os(this,f,mn,an,Ds,{})}}export{dn as component};
