import{s as Za,o as Ia,n as z}from"../chunks/scheduler.9bc65507.js";import{S as qa,i as Ba,g as a,s as i,u as _,A as Na,h as r,f as s,c as l,j as w,v as M,y as h,k as u,o as n,a as m,w as b,d as y,t as T,x as v}from"../chunks/index.78c82d43.js";import{T as Ct}from"../chunks/Tip.87d55b76.js";import{D as I}from"../chunks/Docstring.f3d04bd2.js";import{C as ce}from"../chunks/CodeBlock.48618ec2.js";import{I as K}from"../chunks/IconCopyLink.bedaa44d.js";import{E as de}from"../chunks/ExampleCodeBlock.872b014d.js";function Ga(C){let o,f="Examples:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1lZ2FDb25maWclMkMlMjBNZWdhTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTWVnYSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTWVnYUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNZWdhTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MegaConfig, MegaModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mega configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MegaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-kvfsh7"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function La(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Xa(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBNZWdhTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaModel.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Ra(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Ea(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhRm9yQ2F1c2FsTE0lMkMlMjBBdXRvQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtbmF5bG9yJTJGbWVnYS1iYXNlLXdpa2l0ZXh0JTIyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBY29uZmlnLmlzX2RlY29kZXIlMjAlM0QlMjBUcnVlJTBBY29uZmlnLmJpZGlyZWN0aW9uYWwlMjAlM0QlMjBGYWxzZSUwQW1vZGVsJTIwJTNEJTIwTWVnYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtbmF5bG9yJTJGbWVnYS1iYXNlLXdpa2l0ZXh0JTIyJTJDJTIwY29uZmlnJTNEY29uZmlnJTJDJTIwaWdub3JlX21pc21hdGNoZWRfc2l6ZXMlM0RUcnVlJTBBKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBcHJlZGljdGlvbl9sb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForCausalLM, AutoConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.is_decoder = <span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config.bidirectional = <span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>, config=config, ignore_mismatched_sizes=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_logits = outputs.logits`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Va(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Aa(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBNZWdhRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTNDbWFzayUzRS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwcmV0cmlldmUlMjBpbmRleCUyMG9mJTIwJTNDbWFzayUzRSUwQW1hc2tfdG9rZW5faW5kZXglMjAlM0QlMjAoaW5wdXRzLmlucHV0X2lkcyUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKSU1QjAlNUQubm9uemVybyhhc190dXBsZSUzRFRydWUpJTVCMCU1RCUwQSUwQXByZWRpY3RlZF90b2tlbl9pZCUyMCUzRCUyMGxvZ2l0cyU1QjAlMkMlMjBtYXNrX3Rva2VuX2luZGV4JTVELmFyZ21heChheGlzJTNELTEpJTBBdG9rZW5pemVyLmRlY29kZShwcmVkaWN0ZWRfdG9rZW5faWQpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjMlMjBtYXNrJTIwbGFiZWxzJTIwb2YlMjBub24tJTNDbWFzayUzRSUyMHRva2VucyUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLndoZXJlKGlucHV0cy5pbnB1dF9pZHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUyQyUyMGxhYmVscyUyQyUyMC0xMDApJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQXJvdW5kKG91dHB1dHMubG9zcy5pdGVtKCklMkMlMjAyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForMaskedLM.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is &lt;mask&gt;.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve index of &lt;mask&gt;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token_index = (inputs.input_ids == tokenizer.mask_token_id)[<span class="hljs-number">0</span>].nonzero(as_tuple=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_id = logits[<span class="hljs-number">0</span>, mask_token_index].argmax(axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(predicted_token_id)
<span class="hljs-string">&#x27; Paris&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask labels of non-&lt;mask&gt; tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.where(inputs.input_ids == tokenizer.mask_token_id, labels, -<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(outputs.loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">0.1</span>`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Ha(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Sa(C){let o,f="Example of single-label classification:",d,p,g;return p=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1lZ2FGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW5heWxvciUyRm1lZ2EtYmFzZS13aWtpdGV4dCUyMiklMEFtb2RlbCUyMCUzRCUyME1lZ2FGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtbmF5bG9yJTJGbWVnYS1iYXNlLXdpa2l0ZXh0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNZWdhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybW5heWxvciUyRm1lZ2EtYmFzZS13aWtpdGV4dCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-ykxpe4"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Qa(C){let o,f="Example of multi-label classification:",d,p,g;return p=new ce({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME1lZ2FGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW5heWxvciUyRm1lZ2EtYmFzZS13aWtpdGV4dCUyMiklMEFtb2RlbCUyMCUzRCUyME1lZ2FGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtbmF5bG9yJTJGbWVnYS1iYXNlLXdpa2l0ZXh0JTIyJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyYW5nZSgwJTJDJTIwbG9naXRzLnNoYXBlJTVCLTElNUQpJTVCdG9yY2guc2lnbW9pZChsb2dpdHMpLnNxdWVlemUoZGltJTNEMCklMjAlM0UlMjAwLjUlNUQlMEElMEElMjMlMjBUbyUyMHRyYWluJTIwYSUyMG1vZGVsJTIwb24lMjAlNjBudW1fbGFiZWxzJTYwJTIwY2xhc3NlcyUyQyUyMHlvdSUyMGNhbiUyMHBhc3MlMjAlNjBudW1fbGFiZWxzJTNEbnVtX2xhYmVscyU2MCUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCguLi4pJTYwJTBBbnVtX2xhYmVscyUyMCUzRCUyMGxlbihtb2RlbC5jb25maWcuaWQybGFiZWwpJTBBbW9kZWwlMjAlM0QlMjBNZWdhRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybW5heWxvciUyRm1lZ2EtYmFzZS13aWtpdGV4dCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-1l8e32d"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Ya(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Pa(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhRm9yTXVsdGlwbGVDaG9pY2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBNZWdhRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySW4lMjBJdGFseSUyQyUyMHBpenphJTIwc2VydmVkJTIwaW4lMjBmb3JtYWwlMjBzZXR0aW5ncyUyQyUyMHN1Y2glMjBhcyUyMGF0JTIwYSUyMHJlc3RhdXJhbnQlMkMlMjBpcyUyMHByZXNlbnRlZCUyMHVuc2xpY2VkLiUyMiUwQWNob2ljZTAlMjAlM0QlMjAlMjJJdCUyMGlzJTIwZWF0ZW4lMjB3aXRoJTIwYSUyMGZvcmslMjBhbmQlMjBhJTIwa25pZmUuJTIyJTBBY2hvaWNlMSUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdoaWxlJTIwaGVsZCUyMGluJTIwdGhlJTIwaGFuZC4lMjIlMEFsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoMCkudW5zcXVlZXplKDApJTIwJTIwJTIzJTIwY2hvaWNlMCUyMGlzJTIwY29ycmVjdCUyMChhY2NvcmRpbmclMjB0byUyMFdpa2lwZWRpYSUyMCUzQikpJTJDJTIwYmF0Y2glMjBzaXplJTIwMSUwQSUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCUyQyUyMHByb21wdCU1RCUyQyUyMCU1QmNob2ljZTAlMkMlMjBjaG9pY2UxJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKiU3QmslM0ElMjB2LnVuc3F1ZWV6ZSgwKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBlbmNvZGluZy5pdGVtcygpJTdEJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUyMCUyMCUyMyUyMGJhdGNoJTIwc2l6ZSUyMGlzJTIwMSUwQSUwQSUyMyUyMHRoZSUyMGxpbmVhciUyMGNsYXNzaWZpZXIlMjBzdGlsbCUyMG5lZWRzJTIwdG8lMjBiZSUyMHRyYWluZWQlMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Oa(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function Da(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybW5heWxvciUyRm1lZ2EtYmFzZS13aWtpdGV4dCUyMiklMEFtb2RlbCUyMCUzRCUyME1lZ2FGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtbmF5bG9yJTJGbWVnYS1iYXNlLXdpa2l0ZXh0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZSUyMGlzJTIwYSUyMGNvbXBhbnklMjBiYXNlZCUyMGluJTIwUGFyaXMlMjBhbmQlMjBOZXclMjBZb3JrJTIyJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpJTBBJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB0b2tlbnMlMjBhcmUlMjBjbGFzc2lmaWVkJTIwcmF0aGVyJTIwdGhlbiUyMGlucHV0JTIwd29yZHMlMjB3aGljaCUyMG1lYW5zJTIwdGhhdCUwQSUyMyUyMHRoZXJlJTIwbWlnaHQlMjBiZSUyMG1vcmUlMjBwcmVkaWN0ZWQlMjB0b2tlbiUyMGNsYXNzZXMlMjB0aGFuJTIwd29yZHMuJTBBJTIzJTIwTXVsdGlwbGUlMjB0b2tlbiUyMGNsYXNzZXMlMjBtaWdodCUyMGFjY291bnQlMjBmb3IlMjB0aGUlMjBzYW1lJTIwd29yZCUwQXByZWRpY3RlZF90b2tlbnNfY2xhc3NlcyUyMCUzRCUyMCU1Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnQuaXRlbSgpJTVEJTIwZm9yJTIwdCUyMGluJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyU1QjAlNUQlNUQlMEElMEFsYWJlbHMlMjAlM0QlMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForTokenClassification.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function Ka(C){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){m(d,o,p)},p:z,d(d){d&&s(o)}}}function er(C){let o,f="Example:",d,p,g;return p=new ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNZWdhRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBbW9kZWwlMjAlM0QlMjBNZWdhRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm1uYXlsb3IlMkZtZWdhLWJhc2Utd2lraXRleHQlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWFuc3dlcl9zdGFydF9pbmRleCUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzLmFyZ21heCgpJTBBYW5zd2VyX2VuZF9pbmRleCUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cy5hcmdtYXgoKSUwQSUwQXByZWRpY3RfYW5zd2VyX3Rva2VucyUyMCUzRCUyMGlucHV0cy5pbnB1dF9pZHMlNUIwJTJDJTIwYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNBJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElNUQlMEElMEElMjMlMjB0YXJnZXQlMjBpcyUyMCUyMm5pY2UlMjBwdXBwZXQlMjIlMEF0YXJnZXRfc3RhcnRfaW5kZXglMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMTQlNUQpJTBBdGFyZ2V0X2VuZF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNSU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBzdGFydF9wb3NpdGlvbnMlM0R0YXJnZXRfc3RhcnRfaW5kZXglMkMlMjBlbmRfcG9zaXRpb25zJTNEdGFyZ2V0X2VuZF9pbmRleCklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MegaForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MegaForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;mnaylor/mega-base-wikitext&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`}}),{c(){o=a("p"),o.textContent=f,d=i(),_(p.$$.fragment)},l(t){o=r(t,"P",{"data-svelte-h":!0}),h(o)!=="svelte-11lpom8"&&(o.textContent=f),d=l(t),M(p.$$.fragment,t)},m(t,k){m(t,o,k),m(t,d,k),b(p,t,k),g=!0},p:z,i(t){g||(y(p.$$.fragment,t),g=!0)},o(t){T(p.$$.fragment,t),g=!1},d(t){t&&(s(o),s(d)),v(p,t)}}}function tr(C){let o,f,d,p,g,t,k,Xe,hn,jt,Cs="MEGA",Zo,ee,pe,fo,Re,un,$t,js="Overview",Io,Ee,$s=`The MEGA model was proposed in <a href="https://arxiv.org/abs/2209.10655" rel="nofollow">Mega: Moving Average Equipped Gated Attention</a> by Xuezhe Ma, Chunting Zhou, Xiang Kong, Junxian He, Liangke Gui, Graham Neubig, Jonathan May, and Luke Zettlemoyer.
MEGA proposes a new approach to self-attention with each encoder layer having a multi-headed exponential moving average in addition to a single head of standard dot-product attention, giving the attention mechanism
stronger positional biases. This allows MEGA to perform competitively to Transformers on standard benchmarks including LRA
while also having significantly fewer parameters. MEGA’s compute efficiency allows it to scale to very long sequences, making it an
attractive option for long-document NLP tasks.`,qo,Ve,zs="The abstract from the paper is the following:",Bo,Ae,xs="<em>The design choices in the Transformer attention mechanism, including weak inductive bias and quadratic computational complexity, have limited its application for modeling long sequences. In this paper, we introduce Mega, a simple, theoretically grounded, single-head gated attention mechanism equipped with (exponential) moving average to incorporate inductive bias of position-aware local dependencies into the position-agnostic attention mechanism. We further propose a variant of Mega that offers linear time and space complexity yet yields only minimal quality loss, by efficiently splitting the whole sequence into multiple chunks with fixed length. Extensive experiments on a wide range of sequence modeling benchmarks, including the Long Range Arena, neural machine translation, auto-regressive language modeling, and image and speech classification, show that Mega achieves significant improvements over other sequence models, including variants of Transformers and recent state space models.</em>",No,He,Js="Tips:",Go,Se,Fs="<li>MEGA can perform quite well with relatively few parameters. See Appendix D in the MEGA paper for examples of architectural specs which perform well in various settings. If using MEGA as a decoder, be sure to set <code>bidirectional=False</code> to avoid errors with default bidirectional.</li> <li>Mega-chunk is a variant of mega that reduces time and spaces complexity from quadratic to linear. Utilize chunking with MegaConfig.use_chunking and control chunk size with MegaConfig.chunk_size</li>",Lo,Qe,Us=`This model was contributed by <a href="https://huggingface.co/mnaylor" rel="nofollow">mnaylor</a>.
The original code can be found <a href="https://github.com/facebookresearch/mega" rel="nofollow">here</a>.`,Xo,Ye,Ws="Implementation Notes:",Ro,Pe,Zs="<li>The original implementation of MEGA had an inconsistent expectation of attention masks for padding and causal self-attention between the softmax attention and Laplace/squared ReLU method. This implementation addresses that inconsistency.</li> <li>The original implementation did not include token type embeddings; this implementation adds support for these, with the option controlled by MegaConfig.add_token_type_embeddings</li>",Eo,te,me,_o,Oe,gn,zt,Is="MegaConfig",Vo,B,De,fn,xt,qs=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaModel">MegaModel</a>. It is used to instantiate a Mega
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Mega
<a href="https://huggingface.co/mnaylor/mega-base-wikitext" rel="nofollow">mnaylor/mega-base-wikitext</a> architecture.`,_n,Jt,Bs=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mn,he,Ao,oe,ue,Mo,Ke,bn,Ft,Ns="MegaModel",Ho,j,et,yn,Ut,Gs="The bare MEGA Model transformer outputting raw hidden-states without any specific head on top.",Tn,Wt,Ls=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vn,Zt,Xs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wn,It,Rs=`The model can behave as an encoder (with only self-attention) as well as a decoder, in which case a layer of
cross-attention is added after self-attention, following the architecture described in <em>Mega: Moving Average
Equipped Gated Attention</em>_ by Xuezhe Ma, Chunting Zhou, Xiang Kong, Junxian He, Liangke Gui, Graham Neubig,
Jonathan May, and Luke Zettlemoyer`,kn,qt,Es=`To behave as a decoder the model needs to be initialized with the <code>is_decoder</code> argument of the configuration set to
<code>True</code> and <code>bidirectional</code> set to <code>False</code>. To be used in a Seq2Seq model, the model needs to initialized with both
<code>is_decoder=True</code> and <code>bidirectional=False</code> argument as well as <code>add_cross_attention</code> set to <code>True</code>; an
<code>encoder_hidden_states</code> is then expected as an input to the forward pass.`,Cn,Bt,Vs='.. _<em>Mega: Moving Average Equipped Gated Attention</em>: <a href="https://arxiv.org/abs/2209.10655" rel="nofollow">https://arxiv.org/abs/2209.10655</a>',jn,N,tt,$n,Nt,As='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaModel">MegaModel</a> forward method, overrides the <code>__call__</code> special method.',zn,ge,xn,fe,So,ne,_e,bo,ot,Jn,Gt,Hs="MegaForCausalLM",Qo,x,nt,Fn,Lt,Ss="MEGA Model with a <code>language modeling</code> head on top for CLM fine-tuning.",Un,Xt,Qs=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wn,Rt,Ys=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Zn,G,st,In,Et,Ps='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForCausalLM">MegaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',qn,Me,Bn,be,Yo,se,ye,yo,at,Nn,Vt,Os="MegaForMaskedLM",Po,J,rt,Gn,At,Ds="MEGA Model with a <code>language modeling</code> head on top.",Ln,Ht,Ks=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xn,St,ea=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rn,L,it,En,Qt,ta='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForMaskedLM">MegaForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Vn,Te,An,ve,Oo,ae,we,To,lt,Hn,Yt,oa="MegaForSequenceClassification",Do,F,dt,Sn,Pt,na=`MEGA Model transformer with a sequence classification/regression head on top (a linear layer on top of the pooled
output) e.g. for GLUE tasks.`,Qn,Ot,sa=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Yn,Dt,aa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Pn,q,ct,On,Kt,ra='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForSequenceClassification">MegaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Dn,ke,Kn,Ce,es,je,Ko,re,$e,vo,pt,ts,eo,ia="MegaForMultipleChoice",en,U,mt,os,to,la=`MEGA Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,ns,oo,da=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ss,no,ca=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,as,X,ht,rs,so,pa='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForMultipleChoice">MegaForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',is,ze,ls,xe,tn,ie,Je,wo,ut,ds,ao,ma="MegaForTokenClassification",on,W,gt,cs,ro,ha=`MEGA Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,ps,io,ua=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ms,lo,ga=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,hs,R,ft,us,co,fa='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForTokenClassification">MegaForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',gs,Fe,fs,Ue,nn,le,We,ko,_t,_s,po,_a="MegaForQuestionAnswering",sn,Z,Mt,Ms,mo,Ma=`MEGA Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,bs,ho,ba=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ys,uo,ya=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ts,E,bt,vs,go,Ta='The <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaForQuestionAnswering">MegaForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',ws,Ze,ks,Ie,an,Co,rn;return Xe=new K({}),Re=new K({}),Oe=new K({}),De=new I({props:{name:"class transformers.MegaConfig",anchor:"transformers.MegaConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 128"},{name:"num_hidden_layers",val:" = 4"},{name:"intermediate_size",val:" = 256"},{name:"ema_projection_size",val:" = 16"},{name:"bidirectional",val:" = True"},{name:"shared_representation_size",val:" = 64"},{name:"use_chunking",val:" = False"},{name:"chunk_size",val:" = -1"},{name:"truncation",val:" = None"},{name:"normalize_before_mega",val:" = True"},{name:"normalization_type",val:" = 'scalenorm'"},{name:"norm_affine",val:" = True"},{name:"activation",val:" = 'silu'"},{name:"attention_activation",val:" = 'softmax'"},{name:"dropout_prob",val:" = 0.1"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"use_feature_dropout",val:" = False"},{name:"use_normalized_ffn",val:" = True"},{name:"nffn_hidden_size",val:" = 256"},{name:"normalize_before_ffn",val:" = True"},{name:"nffn_activation_dropout_prob",val:" = 0.1"},{name:"max_positions",val:" = 2048"},{name:"add_token_type_embeddings",val:" = False"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"ema_delta_alpha_range",val:" = 0.2"},{name:"ema_beta_range",val:" = 0.02"},{name:"ema_gamma_omega_range",val:" = 1.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"relative_positional_bias",val:" = 'rotary'"},{name:"classifier_dropout",val:" = None"},{name:"use_cache",val:" = True"},{name:"add_lm_hidden_dense_layer",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MegaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Mega model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaModel">MegaModel</a>.`,name:"vocab_size"},{anchor:"transformers.MegaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MegaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of hidden layers in the Mega encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MegaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the hidden size (self-attention value projection) within the Mega encoder`,name:"intermediate_size"},{anchor:"transformers.MegaConfig.ema_projection_size",description:`<strong>ema_projection_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Dimensionality of the MegaMultiDimensionDampedEma`,name:"ema_projection_size"},{anchor:"transformers.MegaConfig.bidirectional",description:`<strong>bidirectional</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the MegaMultiDimensionDampedEma used in Mega&#x2019;s self-attention should work bidirectionally (<code>True</code>)
or unidirectionally (<code>False</code>). Bidirectional EMA is incompatible with causal decoding, so this should be
False if you intend to use the model as a decoder.`,name:"bidirectional"},{anchor:"transformers.MegaConfig.shared_representation_size",description:`<strong>shared_representation_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality of the linear projection for shared representation of self-attention queries and keys`,name:"shared_representation_size"},{anchor:"transformers.MegaConfig.use_chunking",description:`<strong>use_chunking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to chunk inputs for linear self-attention complexity (described as Mega-chunk in the paper)`,name:"use_chunking"},{anchor:"transformers.MegaConfig.chunk_size",description:`<strong>chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
If <code>use_chunking</code> is set to <code>True</code>, determines the size of the chunks to apply to the input sequence. If
chunking is used, input sequences must be padded to a multiple of <code>chunk_size</code>`,name:"chunk_size"},{anchor:"transformers.MegaConfig.truncation",description:`<strong>truncation</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If specified, the sequence length for which to truncate MegaMultiDimensionDampedEma`,name:"truncation"},{anchor:"transformers.MegaConfig.normalize_before_mega",description:`<strong>normalize_before_mega</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize before (<code>True</code>) or after (<code>False</code>) passing through Mega encoder blocks`,name:"normalize_before_mega"},{anchor:"transformers.MegaConfig.normalization_type",description:`<strong>normalization_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;scalenorm&quot;</code>) &#x2014;
Type of normalization to use in Mega encoder blocks. Choose one of <code>&quot;scalenorm&quot;</code>, <code>&quot;layernorm&quot;</code>,
<code>&quot;rmsnorm&quot;</code>, <code>&quot;batchnorm&quot;</code>, or <code>&quot;syncbatchnorm&quot;</code> (GPU required for syncbatchnorm)`,name:"normalization_type"},{anchor:"transformers.MegaConfig.norm_affine",description:`<strong>norm_affine</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If <code>True</code>, applies a parameterized affine transformation to inputs during normalization`,name:"norm_affine"},{anchor:"transformers.MegaConfig.activation",description:`<strong>activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
Activation function to apply within Mega encoder blocks. Choose one of <code>&quot;silu&quot;</code>, <code>&quot;relu&quot;</code>, <code>&quot;linear&quot;</code>,
<code>&quot;gelu&quot;</code>, or <code>&quot;gelu_accurate&quot;</code>`,name:"activation"},{anchor:"transformers.MegaConfig.attention_activation",description:`<strong>attention_activation</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;softmax&quot;</code>) &#x2014;
Activation function to apply for single-headed self-attention (a la Transformer). Choose one of
<code>&quot;softmax&quot;</code>, <code>&quot;laplace&quot;</code>, or <code>&quot;relu2&quot;</code>`,name:"attention_activation"},{anchor:"transformers.MegaConfig.dropout_prob",description:`<strong>dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for EMA self-attention`,name:"dropout_prob"},{anchor:"transformers.MegaConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.MegaConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.MegaConfig.use_feature_dropout",description:`<strong>use_feature_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use feature-based (<code>True</code>) or standard dropout (<code>False</code>)`,name:"use_feature_dropout"},{anchor:"transformers.MegaConfig.use_normalized_ffn",description:`<strong>use_normalized_ffn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the normalized feed-forward sub-layer in Mega blocks (<code>True</code>) or pass Mega encoder output
as-is (<code>False</code>)`,name:"use_normalized_ffn"},{anchor:"transformers.MegaConfig.nffn_hidden_size",description:`<strong>nffn_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
If using the normalized feed-forward network (NFFN) layer within Mega (<code>use_normalized_ffn = True</code>), this
is the hidden size of the NFFN`,name:"nffn_hidden_size"},{anchor:"transformers.MegaConfig.normalize_before_ffn",description:`<strong>normalize_before_ffn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize before (<code>True</code>) or after (<code>False</code>) the feed-forward portion of NFFN`,name:"normalize_before_ffn"},{anchor:"transformers.MegaConfig.nffn_activation_dropout_prob",description:`<strong>nffn_activation_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the NFFN component.`,name:"nffn_activation_dropout_prob"},{anchor:"transformers.MegaConfig.max_positions",description:`<strong>max_positions</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length to use for positional representations. For <code>&quot;simple&quot;</code> relative positional bias,
this is a hard limit on input length; <code>&quot;rotary&quot;</code> relative positional bias will extrapolate to longer
sequences`,name:"max_positions"},{anchor:"transformers.MegaConfig.add_token_type_embeddings",description:`<strong>add_token_type_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to account for token types in embeddings. Left as optional to maintain compatibility with original
implementation while adding support for token types.`,name:"add_token_type_embeddings"},{anchor:"transformers.MegaConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaModel">MegaModel</a>. Only used if
<code>add_token_type_embeddings = True</code>`,name:"type_vocab_size"},{anchor:"transformers.MegaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MegaConfig.ema_delta_alpha_range",description:`<strong>ema_delta_alpha_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.2) &#x2014;
The standard deviation for initializing the delta (damping factor) and alpha (decay factor) parameters in
MegaMultiDimensionDampedEma.`,name:"ema_delta_alpha_range"},{anchor:"transformers.MegaConfig.ema_beta_range",description:`<strong>ema_beta_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation for initializing the beta parameter (expansion matrix) in
MegaMultiDimensionDampedEma.`,name:"ema_beta_range"},{anchor:"transformers.MegaConfig.ema_gamma_omega_range",description:`<strong>ema_gamma_omega_range</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The standard deviation for initializing the gamma (projection matrix) and omega (residual weight)
parameters in MultiDimensionEMA.`,name:"ema_gamma_omega_range"},{anchor:"transformers.MegaConfig.relative_positional_bias",description:`<strong>relative_positional_bias</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;rotary&quot;</code>) &#x2014;
Type of relative positional encoding. Choose one of <code>&quot;rotary&quot;</code> or <code>&quot;simple&quot;</code>. If <code>&quot;simple&quot;</code> is selected,
<code>max_positions</code> is used as a limit on input size, while <code>&quot;rotary&quot;</code> extrapolates beyond <code>max_positions</code>.`,name:"relative_positional_bias"},{anchor:"transformers.MegaConfig.is_decoder",description:`<strong>is_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model is used as a decoder or not. If <code>False</code>, the model is used as an encoder.`,name:"is_decoder"},{anchor:"transformers.MegaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.MegaConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"},{anchor:"transformers.MegaConfig.add_lm_hidden_dense_layer",description:`<strong>add_lm_hidden_dense_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to include a hidden layer for projection between encoder outputs and LM heads (<code>True</code>) or pass
hidden states directly to LM head (<code>False</code>). Remains optional for compatibility with original
implementation`,name:"add_lm_hidden_dense_layer"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/configuration_mega.py#L31"}}),he=new de({props:{anchor:"transformers.MegaConfig.example",$$slots:{default:[Ga]},$$scope:{ctx:C}}}),Ke=new K({}),et=new I({props:{name:"class transformers.MegaModel",anchor:"transformers.MegaModel",parameters:[{name:"config",val:": MegaConfig"},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.MegaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1451"}}),tt=new I({props:{name:"forward",anchor:"transformers.MegaModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MegaModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.MegaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MegaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1486",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Ct({props:{$$slots:{default:[La]},$$scope:{ctx:C}}}),fe=new de({props:{anchor:"transformers.MegaModel.forward.example",$$slots:{default:[Xa]},$$scope:{ctx:C}}}),ot=new K({}),nt=new I({props:{name:"class transformers.MegaForCausalLM",anchor:"transformers.MegaForCausalLM",parameters:[{name:"config",val:": MegaConfig"}],parametersDescription:[{anchor:"transformers.MegaForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1648"}}),st=new I({props:{name:"forward",anchor:"transformers.MegaForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Tuple[typing.Tuple[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForCausalLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MegaForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.MegaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the left-to-right language modeling loss (next word prediction). Indices should be in
<code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are
ignored (masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MegaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MegaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1677",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new Ct({props:{$$slots:{default:[Ra]},$$scope:{ctx:C}}}),be=new de({props:{anchor:"transformers.MegaForCausalLM.forward.example",$$slots:{default:[Ea]},$$scope:{ctx:C}}}),at=new K({}),rt=new I({props:{name:"class transformers.MegaForMaskedLM",anchor:"transformers.MegaForMaskedLM",parameters:[{name:"config",val:": MegaConfig"}],parametersDescription:[{anchor:"transformers.MegaForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1807"}}),it=new I({props:{name:"forward",anchor:"transformers.MegaForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForMaskedLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MegaForMaskedLM.forward.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, any]</code>, optional, defaults to <em>{}</em>) &#x2014;
Used to hide legacy arguments that have been deprecated.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1838",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new Ct({props:{$$slots:{default:[Va]},$$scope:{ctx:C}}}),ve=new de({props:{anchor:"transformers.MegaForMaskedLM.forward.example",$$slots:{default:[Aa]},$$scope:{ctx:C}}}),lt=new K({}),dt=new I({props:{name:"class transformers.MegaForSequenceClassification",anchor:"transformers.MegaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MegaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1911"}}),ct=new I({props:{name:"forward",anchor:"transformers.MegaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L1923",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ke=new Ct({props:{$$slots:{default:[Ha]},$$scope:{ctx:C}}}),Ce=new de({props:{anchor:"transformers.MegaForSequenceClassification.forward.example",$$slots:{default:[Sa]},$$scope:{ctx:C}}}),je=new de({props:{anchor:"transformers.MegaForSequenceClassification.forward.example-2",$$slots:{default:[Qa]},$$scope:{ctx:C}}}),pt=new K({}),mt=new I({props:{name:"class transformers.MegaForMultipleChoice",anchor:"transformers.MegaForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MegaForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2002"}}),ht=new I({props:{name:"forward",anchor:"transformers.MegaForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2013",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ze=new Ct({props:{$$slots:{default:[Ya]},$$scope:{ctx:C}}}),xe=new de({props:{anchor:"transformers.MegaForMultipleChoice.forward.example",$$slots:{default:[Pa]},$$scope:{ctx:C}}}),ut=new K({}),gt=new I({props:{name:"class transformers.MegaForTokenClassification",anchor:"transformers.MegaForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MegaForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2087"}}),ft=new I({props:{name:"forward",anchor:"transformers.MegaForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2102",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Fe=new Ct({props:{$$slots:{default:[Oa]},$$scope:{ctx:C}}}),Ue=new de({props:{anchor:"transformers.MegaForTokenClassification.forward.example",$$slots:{default:[Da]},$$scope:{ctx:C}}}),_t=new K({}),Mt=new I({props:{name:"class transformers.MegaForQuestionAnswering",anchor:"transformers.MegaForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MegaForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig">MegaConfig</a>) &#x2014; Model configuration class with all the parameters of the
model. Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2187"}}),bt=new I({props:{name:"forward",anchor:"transformers.MegaForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MegaForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MegaForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MegaForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0,1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.
This parameter can only be used when the model is initialized with <code>add_token_type_embeddings</code> parameter
set to <code>True</code>. All the value in this tensor should be always &lt; config.type_vocab_size.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.MegaForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MegaForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MegaForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MegaForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MegaForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MegaForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mega/modeling_mega.py#L2198",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mega#transformers.MegaConfig"
>MegaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ze=new Ct({props:{$$slots:{default:[Ka]},$$scope:{ctx:C}}}),Ie=new de({props:{anchor:"transformers.MegaForQuestionAnswering.forward.example",$$slots:{default:[er]},$$scope:{ctx:C}}}),{c(){o=a("meta"),f=i(),d=a("p"),p=i(),g=a("h1"),t=a("a"),k=a("span"),_(Xe.$$.fragment),hn=i(),jt=a("span"),jt.textContent=Cs,Zo=i(),ee=a("h2"),pe=a("a"),fo=a("span"),_(Re.$$.fragment),un=i(),$t=a("span"),$t.textContent=js,Io=i(),Ee=a("p"),Ee.innerHTML=$s,qo=i(),Ve=a("p"),Ve.textContent=zs,Bo=i(),Ae=a("p"),Ae.innerHTML=xs,No=i(),He=a("p"),He.textContent=Js,Go=i(),Se=a("ul"),Se.innerHTML=Fs,Lo=i(),Qe=a("p"),Qe.innerHTML=Us,Xo=i(),Ye=a("p"),Ye.textContent=Ws,Ro=i(),Pe=a("ul"),Pe.innerHTML=Zs,Eo=i(),te=a("h2"),me=a("a"),_o=a("span"),_(Oe.$$.fragment),gn=i(),zt=a("span"),zt.textContent=Is,Vo=i(),B=a("div"),_(De.$$.fragment),fn=i(),xt=a("p"),xt.innerHTML=qs,_n=i(),Jt=a("p"),Jt.innerHTML=Bs,Mn=i(),_(he.$$.fragment),Ao=i(),oe=a("h2"),ue=a("a"),Mo=a("span"),_(Ke.$$.fragment),bn=i(),Ft=a("span"),Ft.textContent=Ns,Ho=i(),j=a("div"),_(et.$$.fragment),yn=i(),Ut=a("p"),Ut.textContent=Gs,Tn=i(),Wt=a("p"),Wt.innerHTML=Ls,vn=i(),Zt=a("p"),Zt.innerHTML=Xs,wn=i(),It=a("p"),It.innerHTML=Rs,kn=i(),qt=a("p"),qt.innerHTML=Es,Cn=i(),Bt=a("p"),Bt.innerHTML=Vs,jn=i(),N=a("div"),_(tt.$$.fragment),$n=i(),Nt=a("p"),Nt.innerHTML=As,zn=i(),_(ge.$$.fragment),xn=i(),_(fe.$$.fragment),So=i(),ne=a("h2"),_e=a("a"),bo=a("span"),_(ot.$$.fragment),Jn=i(),Gt=a("span"),Gt.textContent=Hs,Qo=i(),x=a("div"),_(nt.$$.fragment),Fn=i(),Lt=a("p"),Lt.innerHTML=Ss,Un=i(),Xt=a("p"),Xt.innerHTML=Qs,Wn=i(),Rt=a("p"),Rt.innerHTML=Ys,Zn=i(),G=a("div"),_(st.$$.fragment),In=i(),Et=a("p"),Et.innerHTML=Ps,qn=i(),_(Me.$$.fragment),Bn=i(),_(be.$$.fragment),Yo=i(),se=a("h2"),ye=a("a"),yo=a("span"),_(at.$$.fragment),Nn=i(),Vt=a("span"),Vt.textContent=Os,Po=i(),J=a("div"),_(rt.$$.fragment),Gn=i(),At=a("p"),At.innerHTML=Ds,Ln=i(),Ht=a("p"),Ht.innerHTML=Ks,Xn=i(),St=a("p"),St.innerHTML=ea,Rn=i(),L=a("div"),_(it.$$.fragment),En=i(),Qt=a("p"),Qt.innerHTML=ta,Vn=i(),_(Te.$$.fragment),An=i(),_(ve.$$.fragment),Oo=i(),ae=a("h2"),we=a("a"),To=a("span"),_(lt.$$.fragment),Hn=i(),Yt=a("span"),Yt.textContent=oa,Do=i(),F=a("div"),_(dt.$$.fragment),Sn=i(),Pt=a("p"),Pt.textContent=na,Qn=i(),Ot=a("p"),Ot.innerHTML=sa,Yn=i(),Dt=a("p"),Dt.innerHTML=aa,Pn=i(),q=a("div"),_(ct.$$.fragment),On=i(),Kt=a("p"),Kt.innerHTML=ra,Dn=i(),_(ke.$$.fragment),Kn=i(),_(Ce.$$.fragment),es=i(),_(je.$$.fragment),Ko=i(),re=a("h2"),$e=a("a"),vo=a("span"),_(pt.$$.fragment),ts=i(),eo=a("span"),eo.textContent=ia,en=i(),U=a("div"),_(mt.$$.fragment),os=i(),to=a("p"),to.textContent=la,ns=i(),oo=a("p"),oo.innerHTML=da,ss=i(),no=a("p"),no.innerHTML=ca,as=i(),X=a("div"),_(ht.$$.fragment),rs=i(),so=a("p"),so.innerHTML=pa,is=i(),_(ze.$$.fragment),ls=i(),_(xe.$$.fragment),tn=i(),ie=a("h2"),Je=a("a"),wo=a("span"),_(ut.$$.fragment),ds=i(),ao=a("span"),ao.textContent=ma,on=i(),W=a("div"),_(gt.$$.fragment),cs=i(),ro=a("p"),ro.textContent=ha,ps=i(),io=a("p"),io.innerHTML=ua,ms=i(),lo=a("p"),lo.innerHTML=ga,hs=i(),R=a("div"),_(ft.$$.fragment),us=i(),co=a("p"),co.innerHTML=fa,gs=i(),_(Fe.$$.fragment),fs=i(),_(Ue.$$.fragment),nn=i(),le=a("h2"),We=a("a"),ko=a("span"),_(_t.$$.fragment),_s=i(),po=a("span"),po.textContent=_a,sn=i(),Z=a("div"),_(Mt.$$.fragment),Ms=i(),mo=a("p"),mo.innerHTML=Ma,bs=i(),ho=a("p"),ho.innerHTML=ba,ys=i(),uo=a("p"),uo.innerHTML=ya,Ts=i(),E=a("div"),_(bt.$$.fragment),vs=i(),go=a("p"),go.innerHTML=Ta,ws=i(),_(Ze.$$.fragment),ks=i(),_(Ie.$$.fragment),an=i(),Co=a("p"),this.h()},l(e){const c=Na("svelte-1phssyn",document.head);o=r(c,"META",{name:!0,content:!0}),c.forEach(s),f=l(e),d=r(e,"P",{}),w(d).forEach(s),p=l(e),g=r(e,"H1",{class:!0});var yt=w(g);t=r(yt,"A",{id:!0,class:!0,href:!0});var jo=w(t);k=r(jo,"SPAN",{});var $o=w(k);M(Xe.$$.fragment,$o),$o.forEach(s),jo.forEach(s),hn=l(yt),jt=r(yt,"SPAN",{"data-svelte-h":!0}),h(jt)!=="svelte-112oytn"&&(jt.textContent=Cs),yt.forEach(s),Zo=l(e),ee=r(e,"H2",{class:!0});var Tt=w(ee);pe=r(Tt,"A",{id:!0,class:!0,href:!0});var zo=w(pe);fo=r(zo,"SPAN",{});var xo=w(fo);M(Re.$$.fragment,xo),xo.forEach(s),zo.forEach(s),un=l(Tt),$t=r(Tt,"SPAN",{"data-svelte-h":!0}),h($t)!=="svelte-1jsw1pg"&&($t.textContent=js),Tt.forEach(s),Io=l(e),Ee=r(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-y21kap"&&(Ee.innerHTML=$s),qo=l(e),Ve=r(e,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-vfdo9a"&&(Ve.textContent=zs),Bo=l(e),Ae=r(e,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-usb8p6"&&(Ae.innerHTML=xs),No=l(e),He=r(e,"P",{"data-svelte-h":!0}),h(He)!=="svelte-axv494"&&(He.textContent=Js),Go=l(e),Se=r(e,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-18672am"&&(Se.innerHTML=Fs),Lo=l(e),Qe=r(e,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-hu61i0"&&(Qe.innerHTML=Us),Xo=l(e),Ye=r(e,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-1opxynz"&&(Ye.textContent=Ws),Ro=l(e),Pe=r(e,"UL",{"data-svelte-h":!0}),h(Pe)!=="svelte-12nl4xf"&&(Pe.innerHTML=Zs),Eo=l(e),te=r(e,"H2",{class:!0});var vt=w(te);me=r(vt,"A",{id:!0,class:!0,href:!0});var Jo=w(me);_o=r(Jo,"SPAN",{});var Fo=w(_o);M(Oe.$$.fragment,Fo),Fo.forEach(s),Jo.forEach(s),gn=l(vt),zt=r(vt,"SPAN",{"data-svelte-h":!0}),h(zt)!=="svelte-csvur9"&&(zt.textContent=Is),vt.forEach(s),Vo=l(e),B=r(e,"DIV",{class:!0});var V=w(B);M(De.$$.fragment,V),fn=l(V),xt=r(V,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-1aeag9f"&&(xt.innerHTML=qs),_n=l(V),Jt=r(V,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-cfh5wl"&&(Jt.innerHTML=Bs),Mn=l(V),M(he.$$.fragment,V),V.forEach(s),Ao=l(e),oe=r(e,"H2",{class:!0});var wt=w(oe);ue=r(wt,"A",{id:!0,class:!0,href:!0});var Uo=w(ue);Mo=r(Uo,"SPAN",{});var Wo=w(Mo);M(Ke.$$.fragment,Wo),Wo.forEach(s),Uo.forEach(s),bn=l(wt),Ft=r(wt,"SPAN",{"data-svelte-h":!0}),h(Ft)!=="svelte-6j5mjs"&&(Ft.textContent=Ns),wt.forEach(s),Ho=l(e),j=r(e,"DIV",{class:!0});var $=w(j);M(et.$$.fragment,$),yn=l($),Ut=r($,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-wsjevx"&&(Ut.textContent=Gs),Tn=l($),Wt=r($,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-ev63c"&&(Wt.innerHTML=Ls),vn=l($),Zt=r($,"P",{"data-svelte-h":!0}),h(Zt)!=="svelte-hswkmf"&&(Zt.innerHTML=Xs),wn=l($),It=r($,"P",{"data-svelte-h":!0}),h(It)!=="svelte-1jfjp18"&&(It.innerHTML=Rs),kn=l($),qt=r($,"P",{"data-svelte-h":!0}),h(qt)!=="svelte-1u2qb33"&&(qt.innerHTML=Es),Cn=l($),Bt=r($,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-ge0ssm"&&(Bt.innerHTML=Vs),jn=l($),N=r($,"DIV",{class:!0});var A=w(N);M(tt.$$.fragment,A),$n=l(A),Nt=r(A,"P",{"data-svelte-h":!0}),h(Nt)!=="svelte-nqfmjz"&&(Nt.innerHTML=As),zn=l(A),M(ge.$$.fragment,A),xn=l(A),M(fe.$$.fragment,A),A.forEach(s),$.forEach(s),So=l(e),ne=r(e,"H2",{class:!0});var kt=w(ne);_e=r(kt,"A",{id:!0,class:!0,href:!0});var va=w(_e);bo=r(va,"SPAN",{});var wa=w(bo);M(ot.$$.fragment,wa),wa.forEach(s),va.forEach(s),Jn=l(kt),Gt=r(kt,"SPAN",{"data-svelte-h":!0}),h(Gt)!=="svelte-1xljv5k"&&(Gt.textContent=Hs),kt.forEach(s),Qo=l(e),x=r(e,"DIV",{class:!0});var H=w(x);M(nt.$$.fragment,H),Fn=l(H),Lt=r(H,"P",{"data-svelte-h":!0}),h(Lt)!=="svelte-pogedt"&&(Lt.innerHTML=Ss),Un=l(H),Xt=r(H,"P",{"data-svelte-h":!0}),h(Xt)!=="svelte-ev63c"&&(Xt.innerHTML=Qs),Wn=l(H),Rt=r(H,"P",{"data-svelte-h":!0}),h(Rt)!=="svelte-hswkmf"&&(Rt.innerHTML=Ys),Zn=l(H),G=r(H,"DIV",{class:!0});var qe=w(G);M(st.$$.fragment,qe),In=l(qe),Et=r(qe,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-1pk19a3"&&(Et.innerHTML=Ps),qn=l(qe),M(Me.$$.fragment,qe),Bn=l(qe),M(be.$$.fragment,qe),qe.forEach(s),H.forEach(s),Yo=l(e),se=r(e,"H2",{class:!0});var ln=w(se);ye=r(ln,"A",{id:!0,class:!0,href:!0});var ka=w(ye);yo=r(ka,"SPAN",{});var Ca=w(yo);M(at.$$.fragment,Ca),Ca.forEach(s),ka.forEach(s),Nn=l(ln),Vt=r(ln,"SPAN",{"data-svelte-h":!0}),h(Vt)!=="svelte-q2e1mo"&&(Vt.textContent=Os),ln.forEach(s),Po=l(e),J=r(e,"DIV",{class:!0});var S=w(J);M(rt.$$.fragment,S),Gn=l(S),At=r(S,"P",{"data-svelte-h":!0}),h(At)!=="svelte-vwo04g"&&(At.innerHTML=Ds),Ln=l(S),Ht=r(S,"P",{"data-svelte-h":!0}),h(Ht)!=="svelte-ev63c"&&(Ht.innerHTML=Ks),Xn=l(S),St=r(S,"P",{"data-svelte-h":!0}),h(St)!=="svelte-hswkmf"&&(St.innerHTML=ea),Rn=l(S),L=r(S,"DIV",{class:!0});var Be=w(L);M(it.$$.fragment,Be),En=l(Be),Qt=r(Be,"P",{"data-svelte-h":!0}),h(Qt)!=="svelte-b1mb83"&&(Qt.innerHTML=ta),Vn=l(Be),M(Te.$$.fragment,Be),An=l(Be),M(ve.$$.fragment,Be),Be.forEach(s),S.forEach(s),Oo=l(e),ae=r(e,"H2",{class:!0});var dn=w(ae);we=r(dn,"A",{id:!0,class:!0,href:!0});var ja=w(we);To=r(ja,"SPAN",{});var $a=w(To);M(lt.$$.fragment,$a),$a.forEach(s),ja.forEach(s),Hn=l(dn),Yt=r(dn,"SPAN",{"data-svelte-h":!0}),h(Yt)!=="svelte-1l5qjgj"&&(Yt.textContent=oa),dn.forEach(s),Do=l(e),F=r(e,"DIV",{class:!0});var Q=w(F);M(dt.$$.fragment,Q),Sn=l(Q),Pt=r(Q,"P",{"data-svelte-h":!0}),h(Pt)!=="svelte-12iqzjk"&&(Pt.textContent=na),Qn=l(Q),Ot=r(Q,"P",{"data-svelte-h":!0}),h(Ot)!=="svelte-ev63c"&&(Ot.innerHTML=sa),Yn=l(Q),Dt=r(Q,"P",{"data-svelte-h":!0}),h(Dt)!=="svelte-hswkmf"&&(Dt.innerHTML=aa),Pn=l(Q),q=r(Q,"DIV",{class:!0});var Y=w(q);M(ct.$$.fragment,Y),On=l(Y),Kt=r(Y,"P",{"data-svelte-h":!0}),h(Kt)!=="svelte-1goj76z"&&(Kt.innerHTML=ra),Dn=l(Y),M(ke.$$.fragment,Y),Kn=l(Y),M(Ce.$$.fragment,Y),es=l(Y),M(je.$$.fragment,Y),Y.forEach(s),Q.forEach(s),Ko=l(e),re=r(e,"H2",{class:!0});var cn=w(re);$e=r(cn,"A",{id:!0,class:!0,href:!0});var za=w($e);vo=r(za,"SPAN",{});var xa=w(vo);M(pt.$$.fragment,xa),xa.forEach(s),za.forEach(s),ts=l(cn),eo=r(cn,"SPAN",{"data-svelte-h":!0}),h(eo)!=="svelte-c9ldjd"&&(eo.textContent=ia),cn.forEach(s),en=l(e),U=r(e,"DIV",{class:!0});var P=w(U);M(mt.$$.fragment,P),os=l(P),to=r(P,"P",{"data-svelte-h":!0}),h(to)!=="svelte-370gjw"&&(to.textContent=la),ns=l(P),oo=r(P,"P",{"data-svelte-h":!0}),h(oo)!=="svelte-ev63c"&&(oo.innerHTML=da),ss=l(P),no=r(P,"P",{"data-svelte-h":!0}),h(no)!=="svelte-hswkmf"&&(no.innerHTML=ca),as=l(P),X=r(P,"DIV",{class:!0});var Ne=w(X);M(ht.$$.fragment,Ne),rs=l(Ne),so=r(Ne,"P",{"data-svelte-h":!0}),h(so)!=="svelte-g6bv4b"&&(so.innerHTML=pa),is=l(Ne),M(ze.$$.fragment,Ne),ls=l(Ne),M(xe.$$.fragment,Ne),Ne.forEach(s),P.forEach(s),tn=l(e),ie=r(e,"H2",{class:!0});var pn=w(ie);Je=r(pn,"A",{id:!0,class:!0,href:!0});var Ja=w(Je);wo=r(Ja,"SPAN",{});var Fa=w(wo);M(ut.$$.fragment,Fa),Fa.forEach(s),Ja.forEach(s),ds=l(pn),ao=r(pn,"SPAN",{"data-svelte-h":!0}),h(ao)!=="svelte-1fsr1ar"&&(ao.textContent=ma),pn.forEach(s),on=l(e),W=r(e,"DIV",{class:!0});var O=w(W);M(gt.$$.fragment,O),cs=l(O),ro=r(O,"P",{"data-svelte-h":!0}),h(ro)!=="svelte-1bzmarr"&&(ro.textContent=ha),ps=l(O),io=r(O,"P",{"data-svelte-h":!0}),h(io)!=="svelte-ev63c"&&(io.innerHTML=ua),ms=l(O),lo=r(O,"P",{"data-svelte-h":!0}),h(lo)!=="svelte-hswkmf"&&(lo.innerHTML=ga),hs=l(O),R=r(O,"DIV",{class:!0});var Ge=w(R);M(ft.$$.fragment,Ge),us=l(Ge),co=r(Ge,"P",{"data-svelte-h":!0}),h(co)!=="svelte-f3d21j"&&(co.innerHTML=fa),gs=l(Ge),M(Fe.$$.fragment,Ge),fs=l(Ge),M(Ue.$$.fragment,Ge),Ge.forEach(s),O.forEach(s),nn=l(e),le=r(e,"H2",{class:!0});var mn=w(le);We=r(mn,"A",{id:!0,class:!0,href:!0});var Ua=w(We);ko=r(Ua,"SPAN",{});var Wa=w(ko);M(_t.$$.fragment,Wa),Wa.forEach(s),Ua.forEach(s),_s=l(mn),po=r(mn,"SPAN",{"data-svelte-h":!0}),h(po)!=="svelte-rbf3te"&&(po.textContent=_a),mn.forEach(s),sn=l(e),Z=r(e,"DIV",{class:!0});var D=w(Z);M(Mt.$$.fragment,D),Ms=l(D),mo=r(D,"P",{"data-svelte-h":!0}),h(mo)!=="svelte-8yqw99"&&(mo.innerHTML=Ma),bs=l(D),ho=r(D,"P",{"data-svelte-h":!0}),h(ho)!=="svelte-ev63c"&&(ho.innerHTML=ba),ys=l(D),uo=r(D,"P",{"data-svelte-h":!0}),h(uo)!=="svelte-hswkmf"&&(uo.innerHTML=ya),Ts=l(D),E=r(D,"DIV",{class:!0});var Le=w(E);M(bt.$$.fragment,Le),vs=l(Le),go=r(Le,"P",{"data-svelte-h":!0}),h(go)!=="svelte-1q7vkk5"&&(go.innerHTML=Ta),ws=l(Le),M(Ze.$$.fragment,Le),ks=l(Le),M(Ie.$$.fragment,Le),Le.forEach(s),D.forEach(s),an=l(e),Co=r(e,"P",{}),w(Co).forEach(s),this.h()},h(){u(o,"name","hf:doc:metadata"),u(o,"content",JSON.stringify(or)),u(t,"id","mega"),u(t,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(t,"href","#mega"),u(g,"class","relative group"),u(pe,"id","overview"),u(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(pe,"href","#overview"),u(ee,"class","relative group"),u(me,"id","transformers.MegaConfig"),u(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(me,"href","#transformers.MegaConfig"),u(te,"class","relative group"),u(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ue,"id","transformers.MegaModel"),u(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ue,"href","#transformers.MegaModel"),u(oe,"class","relative group"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(_e,"id","transformers.MegaForCausalLM"),u(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(_e,"href","#transformers.MegaForCausalLM"),u(ne,"class","relative group"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ye,"id","transformers.MegaForMaskedLM"),u(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ye,"href","#transformers.MegaForMaskedLM"),u(se,"class","relative group"),u(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(we,"id","transformers.MegaForSequenceClassification"),u(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(we,"href","#transformers.MegaForSequenceClassification"),u(ae,"class","relative group"),u(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($e,"id","transformers.MegaForMultipleChoice"),u($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u($e,"href","#transformers.MegaForMultipleChoice"),u(re,"class","relative group"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Je,"id","transformers.MegaForTokenClassification"),u(Je,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Je,"href","#transformers.MegaForTokenClassification"),u(ie,"class","relative group"),u(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(We,"id","transformers.MegaForQuestionAnswering"),u(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(We,"href","#transformers.MegaForQuestionAnswering"),u(le,"class","relative group"),u(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,o),m(e,f,c),m(e,d,c),m(e,p,c),m(e,g,c),n(g,t),n(t,k),b(Xe,k,null),n(g,hn),n(g,jt),m(e,Zo,c),m(e,ee,c),n(ee,pe),n(pe,fo),b(Re,fo,null),n(ee,un),n(ee,$t),m(e,Io,c),m(e,Ee,c),m(e,qo,c),m(e,Ve,c),m(e,Bo,c),m(e,Ae,c),m(e,No,c),m(e,He,c),m(e,Go,c),m(e,Se,c),m(e,Lo,c),m(e,Qe,c),m(e,Xo,c),m(e,Ye,c),m(e,Ro,c),m(e,Pe,c),m(e,Eo,c),m(e,te,c),n(te,me),n(me,_o),b(Oe,_o,null),n(te,gn),n(te,zt),m(e,Vo,c),m(e,B,c),b(De,B,null),n(B,fn),n(B,xt),n(B,_n),n(B,Jt),n(B,Mn),b(he,B,null),m(e,Ao,c),m(e,oe,c),n(oe,ue),n(ue,Mo),b(Ke,Mo,null),n(oe,bn),n(oe,Ft),m(e,Ho,c),m(e,j,c),b(et,j,null),n(j,yn),n(j,Ut),n(j,Tn),n(j,Wt),n(j,vn),n(j,Zt),n(j,wn),n(j,It),n(j,kn),n(j,qt),n(j,Cn),n(j,Bt),n(j,jn),n(j,N),b(tt,N,null),n(N,$n),n(N,Nt),n(N,zn),b(ge,N,null),n(N,xn),b(fe,N,null),m(e,So,c),m(e,ne,c),n(ne,_e),n(_e,bo),b(ot,bo,null),n(ne,Jn),n(ne,Gt),m(e,Qo,c),m(e,x,c),b(nt,x,null),n(x,Fn),n(x,Lt),n(x,Un),n(x,Xt),n(x,Wn),n(x,Rt),n(x,Zn),n(x,G),b(st,G,null),n(G,In),n(G,Et),n(G,qn),b(Me,G,null),n(G,Bn),b(be,G,null),m(e,Yo,c),m(e,se,c),n(se,ye),n(ye,yo),b(at,yo,null),n(se,Nn),n(se,Vt),m(e,Po,c),m(e,J,c),b(rt,J,null),n(J,Gn),n(J,At),n(J,Ln),n(J,Ht),n(J,Xn),n(J,St),n(J,Rn),n(J,L),b(it,L,null),n(L,En),n(L,Qt),n(L,Vn),b(Te,L,null),n(L,An),b(ve,L,null),m(e,Oo,c),m(e,ae,c),n(ae,we),n(we,To),b(lt,To,null),n(ae,Hn),n(ae,Yt),m(e,Do,c),m(e,F,c),b(dt,F,null),n(F,Sn),n(F,Pt),n(F,Qn),n(F,Ot),n(F,Yn),n(F,Dt),n(F,Pn),n(F,q),b(ct,q,null),n(q,On),n(q,Kt),n(q,Dn),b(ke,q,null),n(q,Kn),b(Ce,q,null),n(q,es),b(je,q,null),m(e,Ko,c),m(e,re,c),n(re,$e),n($e,vo),b(pt,vo,null),n(re,ts),n(re,eo),m(e,en,c),m(e,U,c),b(mt,U,null),n(U,os),n(U,to),n(U,ns),n(U,oo),n(U,ss),n(U,no),n(U,as),n(U,X),b(ht,X,null),n(X,rs),n(X,so),n(X,is),b(ze,X,null),n(X,ls),b(xe,X,null),m(e,tn,c),m(e,ie,c),n(ie,Je),n(Je,wo),b(ut,wo,null),n(ie,ds),n(ie,ao),m(e,on,c),m(e,W,c),b(gt,W,null),n(W,cs),n(W,ro),n(W,ps),n(W,io),n(W,ms),n(W,lo),n(W,hs),n(W,R),b(ft,R,null),n(R,us),n(R,co),n(R,gs),b(Fe,R,null),n(R,fs),b(Ue,R,null),m(e,nn,c),m(e,le,c),n(le,We),n(We,ko),b(_t,ko,null),n(le,_s),n(le,po),m(e,sn,c),m(e,Z,c),b(Mt,Z,null),n(Z,Ms),n(Z,mo),n(Z,bs),n(Z,ho),n(Z,ys),n(Z,uo),n(Z,Ts),n(Z,E),b(bt,E,null),n(E,vs),n(E,go),n(E,ws),b(Ze,E,null),n(E,ks),b(Ie,E,null),m(e,an,c),m(e,Co,c),rn=!0},p(e,[c]){const yt={};c&2&&(yt.$$scope={dirty:c,ctx:e}),he.$set(yt);const jo={};c&2&&(jo.$$scope={dirty:c,ctx:e}),ge.$set(jo);const $o={};c&2&&($o.$$scope={dirty:c,ctx:e}),fe.$set($o);const Tt={};c&2&&(Tt.$$scope={dirty:c,ctx:e}),Me.$set(Tt);const zo={};c&2&&(zo.$$scope={dirty:c,ctx:e}),be.$set(zo);const xo={};c&2&&(xo.$$scope={dirty:c,ctx:e}),Te.$set(xo);const vt={};c&2&&(vt.$$scope={dirty:c,ctx:e}),ve.$set(vt);const Jo={};c&2&&(Jo.$$scope={dirty:c,ctx:e}),ke.$set(Jo);const Fo={};c&2&&(Fo.$$scope={dirty:c,ctx:e}),Ce.$set(Fo);const V={};c&2&&(V.$$scope={dirty:c,ctx:e}),je.$set(V);const wt={};c&2&&(wt.$$scope={dirty:c,ctx:e}),ze.$set(wt);const Uo={};c&2&&(Uo.$$scope={dirty:c,ctx:e}),xe.$set(Uo);const Wo={};c&2&&(Wo.$$scope={dirty:c,ctx:e}),Fe.$set(Wo);const $={};c&2&&($.$$scope={dirty:c,ctx:e}),Ue.$set($);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),Ze.$set(A);const kt={};c&2&&(kt.$$scope={dirty:c,ctx:e}),Ie.$set(kt)},i(e){rn||(y(Xe.$$.fragment,e),y(Re.$$.fragment,e),y(Oe.$$.fragment,e),y(De.$$.fragment,e),y(he.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(ge.$$.fragment,e),y(fe.$$.fragment,e),y(ot.$$.fragment,e),y(nt.$$.fragment,e),y(st.$$.fragment,e),y(Me.$$.fragment,e),y(be.$$.fragment,e),y(at.$$.fragment,e),y(rt.$$.fragment,e),y(it.$$.fragment,e),y(Te.$$.fragment,e),y(ve.$$.fragment,e),y(lt.$$.fragment,e),y(dt.$$.fragment,e),y(ct.$$.fragment,e),y(ke.$$.fragment,e),y(Ce.$$.fragment,e),y(je.$$.fragment,e),y(pt.$$.fragment,e),y(mt.$$.fragment,e),y(ht.$$.fragment,e),y(ze.$$.fragment,e),y(xe.$$.fragment,e),y(ut.$$.fragment,e),y(gt.$$.fragment,e),y(ft.$$.fragment,e),y(Fe.$$.fragment,e),y(Ue.$$.fragment,e),y(_t.$$.fragment,e),y(Mt.$$.fragment,e),y(bt.$$.fragment,e),y(Ze.$$.fragment,e),y(Ie.$$.fragment,e),rn=!0)},o(e){T(Xe.$$.fragment,e),T(Re.$$.fragment,e),T(Oe.$$.fragment,e),T(De.$$.fragment,e),T(he.$$.fragment,e),T(Ke.$$.fragment,e),T(et.$$.fragment,e),T(tt.$$.fragment,e),T(ge.$$.fragment,e),T(fe.$$.fragment,e),T(ot.$$.fragment,e),T(nt.$$.fragment,e),T(st.$$.fragment,e),T(Me.$$.fragment,e),T(be.$$.fragment,e),T(at.$$.fragment,e),T(rt.$$.fragment,e),T(it.$$.fragment,e),T(Te.$$.fragment,e),T(ve.$$.fragment,e),T(lt.$$.fragment,e),T(dt.$$.fragment,e),T(ct.$$.fragment,e),T(ke.$$.fragment,e),T(Ce.$$.fragment,e),T(je.$$.fragment,e),T(pt.$$.fragment,e),T(mt.$$.fragment,e),T(ht.$$.fragment,e),T(ze.$$.fragment,e),T(xe.$$.fragment,e),T(ut.$$.fragment,e),T(gt.$$.fragment,e),T(ft.$$.fragment,e),T(Fe.$$.fragment,e),T(Ue.$$.fragment,e),T(_t.$$.fragment,e),T(Mt.$$.fragment,e),T(bt.$$.fragment,e),T(Ze.$$.fragment,e),T(Ie.$$.fragment,e),rn=!1},d(e){e&&(s(f),s(d),s(p),s(g),s(Zo),s(ee),s(Io),s(Ee),s(qo),s(Ve),s(Bo),s(Ae),s(No),s(He),s(Go),s(Se),s(Lo),s(Qe),s(Xo),s(Ye),s(Ro),s(Pe),s(Eo),s(te),s(Vo),s(B),s(Ao),s(oe),s(Ho),s(j),s(So),s(ne),s(Qo),s(x),s(Yo),s(se),s(Po),s(J),s(Oo),s(ae),s(Do),s(F),s(Ko),s(re),s(en),s(U),s(tn),s(ie),s(on),s(W),s(nn),s(le),s(sn),s(Z),s(an),s(Co)),s(o),v(Xe),v(Re),v(Oe),v(De),v(he),v(Ke),v(et),v(tt),v(ge),v(fe),v(ot),v(nt),v(st),v(Me),v(be),v(at),v(rt),v(it),v(Te),v(ve),v(lt),v(dt),v(ct),v(ke),v(Ce),v(je),v(pt),v(mt),v(ht),v(ze),v(xe),v(ut),v(gt),v(ft),v(Fe),v(Ue),v(_t),v(Mt),v(bt),v(Ze),v(Ie)}}}const or={local:"mega",sections:[{local:"overview",title:"Overview"},{local:"transformers.MegaConfig",title:"MegaConfig"},{local:"transformers.MegaModel",title:"MegaModel"},{local:"transformers.MegaForCausalLM",title:"MegaForCausalLM"},{local:"transformers.MegaForMaskedLM",title:"MegaForMaskedLM"},{local:"transformers.MegaForSequenceClassification",title:"MegaForSequenceClassification"},{local:"transformers.MegaForMultipleChoice",title:"MegaForMultipleChoice"},{local:"transformers.MegaForTokenClassification",title:"MegaForTokenClassification"},{local:"transformers.MegaForQuestionAnswering",title:"MegaForQuestionAnswering"}],title:"MEGA"};function nr(C){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pr extends qa{constructor(o){super(),Ba(this,o,nr,tr,Za,{})}}export{pr as component};
