import{s as b2,o as w2,n as $2}from"../chunks/scheduler.9bc65507.js";import{S as q2,i as O2,g as n,s as r,u as p,A as S2,h as s,f as t,c as d,j as l,v as h,y as c,k as a,o,a as u,w as f,d as m,t as g,x as _}from"../chunks/index.78c82d43.js";import{T as C2}from"../chunks/Tip.87d55b76.js";import{D as v}from"../chunks/Docstring.f3d04bd2.js";import{C as y2}from"../chunks/CodeBlock.48618ec2.js";import{I as T}from"../chunks/IconCopyLink.bedaa44d.js";function F2(vl){let x,_n=`You can’t unpack a <code>ModelOutput</code> directly. Use the <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput.to_tuple">to_tuple()</a> method to convert it to a tuple
before.`;return{c(){x=n("p"),x.innerHTML=_n},l(b){x=s(b,"P",{"data-svelte-h":!0}),c(x)!=="svelte-11ykpvn"&&(x.innerHTML=_n)},m(b,lr){u(b,x,lr)},p:$2,d(b){b&&t(x)}}}function M2(vl){let x,_n,b,lr,B,Ht,du,vn,fm,cr,pv="Model outputs",Tl,Tn,hv=`All models have outputs that are instances of subclasses of <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. Those are
data structures containing all the information returned by the model, but that can also be used as tuples or
dictionaries.`,xl,xn,fv="Let’s see how this looks in an example:",yl,yn,bl,bn,mv=`The <code>outputs</code> object is a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput">SequenceClassifierOutput</a>, as we can see in the
documentation of that class below, it means it has an optional <code>loss</code>, a <code>logits</code>, an optional <code>hidden_states</code> and
an optional <code>attentions</code> attribute. Here we have the <code>loss</code> since we passed along <code>labels</code>, but we don’t have
<code>hidden_states</code> and <code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or
<code>output_attentions=True</code>.`,wl,wn,gv=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>outputs.loss</code> is the loss computed by the model, and <code>outputs.attentions</code> is
<code>None</code>.`,$l,$n,_v=`When considering our <code>outputs</code> object as tuple, it only considers the attributes that don’t have <code>None</code> values.
Here for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,ql,qn,Ol,On,vv="will return the tuple <code>(outputs.loss, outputs.logits)</code> for instance.",Sl,Sn,Tv=`When considering our <code>outputs</code> object as dictionary, it only considers the attributes that don’t have <code>None</code>
values. Here for instance, it has two keys that are <code>loss</code> and <code>logits</code>.`,Cl,Cn,xv=`We document here the generic model outputs that are used by more than one model type. Specific output types are
documented on their corresponding model page.`,Fl,j,Dt,iu,Fn,mm,pr,yv="ModelOutput",Ml,y,Mn,gm,hr,bv=`Base class for all model outputs as dataclass. Has a <code>__getitem__</code> that allows indexing by integer or slice (like a
tuple) or strings (like a dictionary) that will ignore the <code>None</code> attributes. Otherwise behaves like a regular
python dictionary.`,_m,Vt,vm,It,An,Tm,fr,wv="Convert self to a tuple containing all the attributes/keys that are not <code>None</code>.",Al,W,Qt,uu,kn,xm,mr,$v="BaseModelOutput",kl,H,Nn,ym,gr,qv="Base class for model’s outputs, with potential hidden states and attentions.",Nl,D,Rt,lu,zn,bm,_r,Ov="BaseModelOutputWithPooling",zl,V,Pn,wm,vr,Sv="Base class for model’s outputs that also contains a pooling of the last hidden states.",Pl,I,Ut,cu,Ln,$m,Tr,Cv="BaseModelOutputWithCrossAttentions",Ll,Q,En,qm,xr,Fv="Base class for model’s outputs, with potential hidden states and attentions.",El,R,Xt,pu,Bn,Om,yr,Mv="BaseModelOutputWithPoolingAndCrossAttentions",Bl,U,jn,Sm,br,Av="Base class for model’s outputs that also contains a pooling of the last hidden states.",jl,X,Jt,hu,Wn,Cm,wr,kv="BaseModelOutputWithPast",Wl,J,Hn,Fm,$r,Nv="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Hl,Z,Zt,fu,Dn,Mm,qr,zv="BaseModelOutputWithPastAndCrossAttentions",Dl,G,Vn,Am,Or,Pv="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Vl,Y,Gt,mu,In,km,Sr,Lv="Seq2SeqModelOutput",Il,K,Qn,Nm,Cr,Ev=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,Ql,ee,Yt,gu,Rn,zm,Fr,Bv="CausalLMOutput",Rl,te,Un,Pm,Mr,jv="Base class for causal language model (or autoregressive) outputs.",Ul,oe,Kt,_u,Xn,Lm,Ar,Wv="CausalLMOutputWithCrossAttentions",Xl,ne,Jn,Em,kr,Hv="Base class for causal language model (or autoregressive) outputs.",Jl,se,eo,vu,Zn,Bm,Nr,Dv="CausalLMOutputWithPast",Zl,ae,Gn,jm,zr,Vv="Base class for causal language model (or autoregressive) outputs.",Gl,re,to,Tu,Yn,Wm,Pr,Iv="MaskedLMOutput",Yl,de,Kn,Hm,Lr,Qv="Base class for masked language models outputs.",Kl,ie,oo,xu,es,Dm,Er,Rv="Seq2SeqLMOutput",ec,ue,ts,Vm,Br,Uv="Base class for sequence-to-sequence language models outputs.",tc,le,no,yu,os,Im,jr,Xv="NextSentencePredictorOutput",oc,ce,ns,Qm,Wr,Jv="Base class for outputs of models predicting if two sentences are consecutive or not.",nc,pe,so,bu,ss,Rm,Hr,Zv="SequenceClassifierOutput",sc,he,as,Um,Dr,Gv="Base class for outputs of sentence classification models.",ac,fe,ao,wu,rs,Xm,Vr,Yv="Seq2SeqSequenceClassifierOutput",rc,me,ds,Jm,Ir,Kv="Base class for outputs of sequence-to-sequence sentence classification models.",dc,ge,ro,$u,is,Zm,Qr,eT="MultipleChoiceModelOutput",ic,_e,us,Gm,Rr,tT="Base class for outputs of multiple choice models.",uc,ve,io,qu,ls,Ym,Ur,oT="TokenClassifierOutput",lc,Te,cs,Km,Xr,nT="Base class for outputs of token classification models.",cc,xe,uo,Ou,ps,eg,Jr,sT="QuestionAnsweringModelOutput",pc,ye,hs,tg,Zr,aT="Base class for outputs of question answering models.",hc,be,lo,Su,fs,og,Gr,rT="Seq2SeqQuestionAnsweringModelOutput",fc,we,ms,ng,Yr,dT="Base class for outputs of sequence-to-sequence question answering models.",mc,$e,co,Cu,gs,sg,Kr,iT="Seq2SeqSpectrogramOutput",gc,qe,_s,ag,ed,uT="Base class for sequence-to-sequence spectrogram outputs.",_c,Oe,po,Fu,vs,rg,td,lT="SemanticSegmenterOutput",vc,Se,Ts,dg,od,cT="Base class for outputs of semantic segmentation models.",Tc,Ce,ho,Mu,xs,ig,nd,pT="ImageClassifierOutput",xc,Fe,ys,ug,sd,hT="Base class for outputs of image classification models.",yc,Me,fo,Au,bs,lg,ad,fT="ImageClassifierOutputWithNoAttention",bc,Ae,ws,cg,rd,mT="Base class for outputs of image classification models.",wc,ke,mo,ku,$s,pg,dd,gT="DepthEstimatorOutput",$c,Ne,qs,hg,id,_T="Base class for outputs of depth estimation models.",qc,ze,go,Nu,Os,fg,ud,vT="Wav2Vec2BaseModelOutput",Oc,Pe,Ss,mg,ld,TT="Base class for models that have been trained with the Wav2Vec2 loss objective.",Sc,Le,_o,zu,Cs,gg,cd,xT="XVectorOutput",Cc,Ee,Fs,_g,pd,yT='Output type of <a href="/docs/transformers/v4.33.3/en/model_doc/wav2vec2#transformers.Wav2Vec2ForXVector">Wav2Vec2ForXVector</a>.',Fc,Be,vo,Pu,Ms,vg,hd,bT="Seq2SeqTSModelOutput",Mc,je,As,Tg,fd,wT=`Base class for time series model’s encoder outputs that also contains pre-computed hidden states that can speed up
sequential decoding.`,Ac,We,To,Lu,ks,xg,md,$T="Seq2SeqTSPredictionOutput",kc,He,Ns,yg,gd,qT=`Base class for time series model’s decoder outputs that also contain the loss as well as the parameters of the
chosen distribution.`,Nc,De,xo,Eu,zs,bg,_d,OT="SampleTSPredictionOutput",zc,Ve,Ps,wg,vd,ST=`Base class for time series model’s predictions outputs that contains the sampled values from the chosen
distribution.`,Pc,Ie,yo,Bu,Ls,$g,Td,CT="TFBaseModelOutput",Lc,Qe,Es,qg,xd,FT="Base class for model’s outputs, with potential hidden states and attentions.",Ec,Re,bo,ju,Bs,Og,yd,MT="TFBaseModelOutputWithPooling",Bc,Ue,js,Sg,bd,AT="Base class for model’s outputs that also contains a pooling of the last hidden states.",jc,Xe,wo,Wu,Ws,Cg,wd,kT="TFBaseModelOutputWithPoolingAndCrossAttentions",Wc,Je,Hs,Fg,$d,NT="Base class for model’s outputs that also contains a pooling of the last hidden states.",Hc,Ze,$o,Hu,Ds,Mg,qd,zT="TFBaseModelOutputWithPast",Dc,Ge,Vs,Ag,Od,PT="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Vc,Ye,qo,Du,Is,kg,Sd,LT="TFBaseModelOutputWithPastAndCrossAttentions",Ic,Ke,Qs,Ng,Cd,ET="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",Qc,et,Oo,Vu,Rs,zg,Fd,BT="TFSeq2SeqModelOutput",Rc,tt,Us,Pg,Md,jT=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,Uc,ot,So,Iu,Xs,Lg,Ad,WT="TFCausalLMOutput",Xc,nt,Js,Eg,kd,HT="Base class for causal language model (or autoregressive) outputs.",Jc,st,Co,Qu,Zs,Bg,Nd,DT="TFCausalLMOutputWithCrossAttentions",Zc,at,Gs,jg,zd,VT="Base class for causal language model (or autoregressive) outputs.",Gc,rt,Fo,Ru,Ys,Wg,Pd,IT="TFCausalLMOutputWithPast",Yc,dt,Ks,Hg,Ld,QT="Base class for causal language model (or autoregressive) outputs.",Kc,it,Mo,Uu,ea,Dg,Ed,RT="TFMaskedLMOutput",ep,ut,ta,Vg,Bd,UT="Base class for masked language models outputs.",tp,lt,Ao,Xu,oa,Ig,jd,XT="TFSeq2SeqLMOutput",op,ct,na,Qg,Wd,JT="Base class for sequence-to-sequence language models outputs.",np,pt,ko,Ju,sa,Rg,Hd,ZT="TFNextSentencePredictorOutput",sp,ht,aa,Ug,Dd,GT="Base class for outputs of models predicting if two sentences are consecutive or not.",ap,ft,No,Zu,ra,Xg,Vd,YT="TFSequenceClassifierOutput",rp,mt,da,Jg,Id,KT="Base class for outputs of sentence classification models.",dp,gt,zo,Gu,ia,Zg,Qd,ex="TFSeq2SeqSequenceClassifierOutput",ip,_t,ua,Gg,Rd,tx="Base class for outputs of sequence-to-sequence sentence classification models.",up,vt,Po,Yu,la,Yg,Ud,ox="TFMultipleChoiceModelOutput",lp,Tt,ca,Kg,Xd,nx="Base class for outputs of multiple choice models.",cp,xt,Lo,Ku,pa,e_,Jd,sx="TFTokenClassifierOutput",pp,yt,ha,t_,Zd,ax="Base class for outputs of token classification models.",hp,bt,Eo,el,fa,o_,Gd,rx="TFQuestionAnsweringModelOutput",fp,wt,ma,n_,Yd,dx="Base class for outputs of question answering models.",mp,$t,Bo,tl,ga,s_,Kd,ix="TFSeq2SeqQuestionAnsweringModelOutput",gp,qt,_a,a_,ei,ux="Base class for outputs of sequence-to-sequence question answering models.",_p,Ot,jo,ol,va,r_,ti,lx="FlaxBaseModelOutput",vp,w,Ta,d_,oi,cx="Base class for model’s outputs, with potential hidden states and attentions.",i_,Wo,xa,u_,ni,px="“Returns a new object replacing the specified fields with new values.",Tp,St,Ho,nl,ya,l_,si,hx="FlaxBaseModelOutputWithPast",xp,$,ba,c_,ai,fx="Base class for model’s outputs, with potential hidden states and attentions.",p_,Do,wa,h_,ri,mx="“Returns a new object replacing the specified fields with new values.",yp,Ct,Vo,sl,$a,f_,di,gx="FlaxBaseModelOutputWithPooling",bp,q,qa,m_,ii,_x="Base class for model’s outputs that also contains a pooling of the last hidden states.",g_,Io,Oa,__,ui,vx="“Returns a new object replacing the specified fields with new values.",wp,Ft,Qo,al,Sa,v_,li,Tx="FlaxBaseModelOutputWithPastAndCrossAttentions",$p,O,Ca,T_,ci,xx="Base class for model’s outputs that may also contain a past key/values (to speed up sequential decoding).",x_,Ro,Fa,y_,pi,yx="“Returns a new object replacing the specified fields with new values.",qp,Mt,Uo,rl,Ma,b_,hi,bx="FlaxSeq2SeqModelOutput",Op,S,Aa,w_,fi,wx=`Base class for model encoder’s outputs that also contains : pre-computed hidden states that can speed up sequential
decoding.`,$_,Xo,ka,q_,mi,$x="“Returns a new object replacing the specified fields with new values.",Sp,At,Jo,dl,Na,O_,gi,qx="FlaxCausalLMOutputWithCrossAttentions",Cp,C,za,S_,_i,Ox="Base class for causal language model (or autoregressive) outputs.",C_,Zo,Pa,F_,vi,Sx="“Returns a new object replacing the specified fields with new values.",Fp,kt,Go,il,La,M_,Ti,Cx="FlaxMaskedLMOutput",Mp,F,Ea,A_,xi,Fx="Base class for masked language models outputs.",k_,Yo,Ba,N_,yi,Mx="“Returns a new object replacing the specified fields with new values.",Ap,Nt,Ko,ul,ja,z_,bi,Ax="FlaxSeq2SeqLMOutput",kp,M,Wa,P_,wi,kx="Base class for sequence-to-sequence language models outputs.",L_,en,Ha,E_,$i,Nx="“Returns a new object replacing the specified fields with new values.",Np,zt,tn,ll,Da,B_,qi,zx="FlaxNextSentencePredictorOutput",zp,A,Va,j_,Oi,Px="Base class for outputs of models predicting if two sentences are consecutive or not.",W_,on,Ia,H_,Si,Lx="“Returns a new object replacing the specified fields with new values.",Pp,Pt,nn,cl,Qa,D_,Ci,Ex="FlaxSequenceClassifierOutput",Lp,k,Ra,V_,Fi,Bx="Base class for outputs of sentence classification models.",I_,sn,Ua,Q_,Mi,jx="“Returns a new object replacing the specified fields with new values.",Ep,Lt,an,pl,Xa,R_,Ai,Wx="FlaxSeq2SeqSequenceClassifierOutput",Bp,N,Ja,U_,ki,Hx="Base class for outputs of sequence-to-sequence sentence classification models.",X_,rn,Za,J_,Ni,Dx="“Returns a new object replacing the specified fields with new values.",jp,Et,dn,hl,Ga,Z_,zi,Vx="FlaxMultipleChoiceModelOutput",Wp,z,Ya,G_,Pi,Ix="Base class for outputs of multiple choice models.",Y_,un,Ka,K_,Li,Qx="“Returns a new object replacing the specified fields with new values.",Hp,Bt,ln,fl,er,ev,Ei,Rx="FlaxTokenClassifierOutput",Dp,P,tr,tv,Bi,Ux="Base class for outputs of token classification models.",ov,cn,or,nv,ji,Xx="“Returns a new object replacing the specified fields with new values.",Vp,jt,pn,ml,nr,sv,Wi,Jx="FlaxQuestionAnsweringModelOutput",Ip,L,sr,av,Hi,Zx="Base class for outputs of question answering models.",rv,hn,ar,dv,Di,Gx="“Returns a new object replacing the specified fields with new values.",Qp,Wt,fn,gl,rr,iv,Vi,Yx="FlaxSeq2SeqQuestionAnsweringModelOutput",Rp,E,dr,uv,Ii,Kx="Base class for outputs of sequence-to-sequence question answering models.",lv,mn,ir,cv,Qi,ey="“Returns a new object replacing the specified fields with new values.",Up,_l,Xp;return vn=new T({}),yn=new y2({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQmVydFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer, BertForSequenceClassification
<span class="hljs-keyword">import</span> torch

tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
model = BertForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
labels = torch.tensor([<span class="hljs-number">1</span>]).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># Batch size 1</span>
outputs = model(**inputs, labels=labels)`}}),qn=new y2({props:{code:"b3V0cHV0cyU1QiUzQTIlNUQ=",highlighted:'outputs[:<span class="hljs-number">2</span>]'}}),Fn=new T({}),Mn=new v({props:{name:"class transformers.utils.ModelOutput",anchor:"transformers.utils.ModelOutput",parameters:"",source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/utils/generic.py#L288"}}),Vt=new C2({props:{warning:!0,$$slots:{default:[F2]},$$scope:{ctx:vl}}}),An=new v({props:{name:"to_tuple",anchor:"transformers.utils.ModelOutput.to_tuple",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/utils/generic.py#L400"}}),kn=new T({}),Nn=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutput",anchor:"transformers.modeling_outputs.BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L25"}}),zn=new T({}),Pn=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPooling",anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L70"}}),Ln=new T({}),En=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L163"}}),Bn=new T({}),jn=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"pooler_output",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L196"}}),Wn=new T({}),Hn=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPast",anchor:"transformers.modeling_outputs.BaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L124"}}),Dn=new T({}),Vn=new v({props:{name:"class transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L245"}}),In=new T({}),Qn=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L425"}}),Rn=new T({}),Un=new v({props:{name:"class transformers.modeling_outputs.CausalLMOutput",anchor:"transformers.modeling_outputs.CausalLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L558"}}),Xn=new T({}),Jn=new v({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L623"}}),Zn=new T({}),Gn=new v({props:{name:"class transformers.modeling_outputs.CausalLMOutputWithPast",anchor:"transformers.modeling_outputs.CausalLMOutputWithPast",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.CausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L587"}}),Yn=new T({}),Kn=new v({props:{name:"class transformers.modeling_outputs.MaskedLMOutput",anchor:"transformers.modeling_outputs.MaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L703"}}),es=new T({}),ts=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqLMOutput",anchor:"transformers.modeling_outputs.Seq2SeqLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L732"}}),os=new T({}),ns=new v({props:{name:"class transformers.modeling_outputs.NextSentencePredictorOutput",anchor:"transformers.modeling_outputs.NextSentencePredictorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sequence prediction (classification) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.NextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L867"}}),ss=new T({}),as=new v({props:{name:"class transformers.modeling_outputs.SequenceClassifierOutput",anchor:"transformers.modeling_outputs.SequenceClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L897"}}),rs=new T({}),ds=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L926"}}),is=new T({}),us=new v({props:{name:"class transformers.modeling_outputs.MultipleChoiceModelOutput",anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.MultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L986"}}),ls=new T({}),cs=new v({props:{name:"class transformers.modeling_outputs.TokenClassifierOutput",anchor:"transformers.modeling_outputs.TokenClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.TokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.TokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1017"}}),ps=new T({}),hs=new v({props:{name:"class transformers.modeling_outputs.QuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.QuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1046"}}),fs=new T({}),ms=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_logits",val:": FloatTensor = None"},{name:"end_logits",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1078"}}),gs=new T({}),_s=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqSpectrogramOutput",anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"spectrogram",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Spectrogram generation loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.spectrogram",description:`<strong>spectrogram</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, num_bins)</code>) &#x2014;
The predicted spectrogram.`,name:"spectrogram"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1411"}}),vs=new T({}),Ts=new v({props:{name:"class transformers.modeling_outputs.SemanticSegmenterOutput",anchor:"transformers.modeling_outputs.SemanticSegmenterOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) &#x2014;
Classification scores for each pixel.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>

					</div>`,name:"logits"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.SemanticSegmenterOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1141"}}),xs=new T({}),ys=new v({props:{name:"class transformers.modeling_outputs.ImageClassifierOutput",anchor:"transformers.modeling_outputs.ImageClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.ImageClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1179"}}),bs=new T({}),ws=new v({props:{name:"class transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also
called feature maps) of the model at the output of each stage.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1207"}}),$s=new T({}),qs=new v({props:{name:"class transformers.modeling_outputs.DepthEstimatorOutput",anchor:"transformers.modeling_outputs.DepthEstimatorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"predicted_depth",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.predicted_depth",description:`<strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) &#x2014;
Predicted depth for each pixel.`,name:"predicted_depth"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.DepthEstimatorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1228"}}),Os=new T({}),Ss=new v({props:{name:"class transformers.modeling_outputs.Wav2Vec2BaseModelOutput",anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"extract_features",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.extract_features",description:`<strong>extract_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, conv_dim[-1])</code>) &#x2014;
Sequence of extracted feature vectors of the last convolutional layer of the model.`,name:"extract_features"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1286"}}),Cs=new T({}),Fs=new v({props:{name:"class transformers.modeling_outputs.XVectorOutput",anchor:"transformers.modeling_outputs.XVectorOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"embeddings",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.XVectorOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.XVectorOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Classification hidden states before AMSoftmax.`,name:"logits"},{anchor:"transformers.modeling_outputs.XVectorOutput.embeddings",description:`<strong>embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.xvector_output_dim)</code>) &#x2014;
Utterance embeddings used for vector similarity-based retrieval.`,name:"embeddings"},{anchor:"transformers.modeling_outputs.XVectorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_outputs.XVectorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1315"}}),Ms=new T({}),As=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqTSModelOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput",parameters:[{name:"last_hidden_state",val:": FloatTensor = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"loc",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"static_features",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSModelOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1471"}}),ks=new T({}),Ns=new v({props:{name:"class transformers.modeling_outputs.Seq2SeqTSPredictionOutput",anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"params",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"loc",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scale",val:": typing.Optional[torch.FloatTensor] = None"},{name:"static_features",val:": typing.Optional[torch.FloatTensor] = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when a <code>future_values</code> is provided) &#x2014;
Distributional loss.`,name:"loss"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.params",description:`<strong>params</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, num_params)</code>) &#x2014;
Parameters of the chosen distribution.`,name:"params"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.loc",description:`<strong>loc</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Shift values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to shift back to the original magnitude.`,name:"loc"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.scale",description:`<strong>scale</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size,)</code> or <code>(batch_size, input_size)</code>, <em>optional</em>) &#x2014;
Scaling values of each time series&#x2019; context window which is used to give the model inputs of the same
magnitude and then used to rescale back to the original magnitude.`,name:"scale"},{anchor:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput.static_features",description:`<strong>static_features</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, feature size)</code>, <em>optional</em>) &#x2014;
Static features of each time series&#x2019; in a batch which are copied to the covariates at inference time.`,name:"static_features"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1543"}}),zs=new T({}),Ps=new v({props:{name:"class transformers.modeling_outputs.SampleTSPredictionOutput",anchor:"transformers.modeling_outputs.SampleTSPredictionOutput",parameters:[{name:"sequences",val:": FloatTensor = None"}],parametersDescription:[{anchor:"transformers.modeling_outputs.SampleTSPredictionOutput.sequences",description:`<strong>sequences</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_samples, prediction_length)</code> or <code>(batch_size, num_samples, prediction_length, input_size)</code>) &#x2014;
Sampled values from the chosen distribution.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_outputs.py#L1615"}}),Ls=new T({}),Es=new v({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutput",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L27"}}),Bs=new T({}),js=new v({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L72"}}),Ws=new T({}),Hs=new v({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"pooler_output",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.pooler_output",description:`<strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you&#x2019;re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.`,name:"pooler_output"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L128"}}),Ds=new T({}),Vs=new v({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L176"}}),Is=new T({}),Qs=new v({props:{name:"class transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L245"}}),Rs=new T({}),Us=new v({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L288"}}),Xs=new T({}),Js=new v({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutput",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L348"}}),Zs=new T({}),Gs=new v({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L413"}}),Ys=new T({}),Ks=new v({props:{name:"class transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss (for next-token prediction).`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L377"}}),ea=new T({}),ta=new v({props:{name:"class transformers.modeling_tf_outputs.TFMaskedLMOutput",anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L456"}}),oa=new T({}),na=new v({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) &#x2014;
Language modeling loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L485"}}),sa=new T({}),aa=new v({props:{name:"class transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>next_sentence_label</code> is provided) &#x2014;
Next sentence prediction loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L544"}}),ra=new T({}),da=new v({props:{name:"class transformers.modeling_tf_outputs.TFSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L574"}}),ia=new T({}),ua=new v({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"cross_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>`,name:"cross_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L603"}}),la=new T({}),ca=new v({props:{name:"class transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <em>(batch_size, )</em>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L754"}}),pa=new T({}),ha=new v({props:{name:"class transformers.modeling_tf_outputs.TFTokenClassifierOutput",anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of unmasked labels, returned when <code>labels</code> is provided)  &#x2014;
Classification loss.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L785"}}),fa=new T({}),ma=new v({props:{name:"class transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, )</code>, <em>optional</em>, returned when <code>start_positions</code> and <code>end_positions</code> are provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L814"}}),ga=new T({}),_a=new v({props:{name:"class transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"loss",val:": tf.Tensor | None = None"},{name:"start_logits",val:": tf.Tensor = None"},{name:"end_logits",val:": tf.Tensor = None"},{name:"past_key_values",val:": List[tf.Tensor] | None = None"},{name:"decoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"decoder_attentions",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_last_hidden_state",val:": tf.Tensor | None = None"},{name:"encoder_hidden_states",val:": Tuple[tf.Tensor] | None = None"},{name:"encoder_attentions",val:": Tuple[tf.Tensor] | None = None"}],parametersDescription:[{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.loss",description:`<strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.`,name:"loss"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) of the decoder that can be
used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_tf_outputs.py#L846"}}),va=new T({}),Ta=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L23"}}),xa=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),ya=new T({}),ba=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Union[typing.Dict[str, jax.Array], NoneType] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.past_key_values",description:`<strong>past_key_values</strong> (<code>Dict[str, jnp.ndarray]</code>) &#x2014;
Dictionary of pre-computed hidden-states (key and values in the attention blocks) that can be used for fast
auto-regressive decoding. Pre-computed key and value hidden-states are of shape <em>[batch_size, max_length]</em>.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L107"}}),wa=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),$a=new T({}),qa=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"pooler_output",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.`,name:"pooler_output"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L137"}}),Oa=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Sa=new T({}),Ca=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L217"}}),Fa=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Ma=new T({}),Aa=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",parameters:[{name:"last_hidden_state",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.`,name:"last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L263"}}),ka=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Na=new T({}),za=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key, value
states of the self-attention and the cross-attention layers if model is used in encoder-decoder setting.
Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L324"}}),Pa=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),La=new T({}),Ea=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxMaskedLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L365"}}),Ba=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),ja=new T({}),Wa=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L394"}}),Ha=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Da=new T({}),Va=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, 2)</code>) &#x2014;
Prediction scores of the next sequence prediction (classification) head (scores of True/False continuation
before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L451"}}),Ia=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Qa=new T({}),Ra=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L478"}}),Ua=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Xa=new T({}),Ja=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L504"}}),Za=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),Ga=new T({}),Ya=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, num_choices)</code>) &#x2014;
<em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L561"}}),Ka=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),er=new T({}),tr=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",parameters:[{name:"logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.logits",description:`<strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) &#x2014;
Classification scores (before SoftMax).`,name:"logits"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L589"}}),or=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),nr=new T({}),sr=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L615"}}),ar=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),rr=new T({}),dr=new v({props:{name:"class transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",parameters:[{name:"start_logits",val:": Array = None"},{name:"end_logits",val:": Array = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[jax.Array]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.start_logits",description:`<strong>start_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-start scores (before SoftMax).`,name:"start_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.end_logits",description:`<strong>end_logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Span-end scores (before SoftMax).`,name:"end_logits"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(jnp.ndarray))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(jnp.ndarray)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.`,name:"past_key_values"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.`,name:"decoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"decoder_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.`,name:"cross_attentions"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder of the model.`,name:"encoder_last_hidden_state"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.`,name:"encoder_hidden_states"},{anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"encoder_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/modeling_flax_outputs.py#L644"}}),ir=new v({props:{name:"replace",anchor:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/flax/struct.py#L111"}}),{c(){x=n("meta"),_n=r(),b=n("p"),lr=r(),B=n("h1"),Ht=n("a"),du=n("span"),p(vn.$$.fragment),fm=r(),cr=n("span"),cr.textContent=pv,Tl=r(),Tn=n("p"),Tn.innerHTML=hv,xl=r(),xn=n("p"),xn.textContent=fv,yl=r(),p(yn.$$.fragment),bl=r(),bn=n("p"),bn.innerHTML=mv,wl=r(),wn=n("p"),wn.innerHTML=gv,$l=r(),$n=n("p"),$n.innerHTML=_v,ql=r(),p(qn.$$.fragment),Ol=r(),On=n("p"),On.innerHTML=vv,Sl=r(),Sn=n("p"),Sn.innerHTML=Tv,Cl=r(),Cn=n("p"),Cn.textContent=xv,Fl=r(),j=n("h2"),Dt=n("a"),iu=n("span"),p(Fn.$$.fragment),mm=r(),pr=n("span"),pr.textContent=yv,Ml=r(),y=n("div"),p(Mn.$$.fragment),gm=r(),hr=n("p"),hr.innerHTML=bv,_m=r(),p(Vt.$$.fragment),vm=r(),It=n("div"),p(An.$$.fragment),Tm=r(),fr=n("p"),fr.innerHTML=wv,Al=r(),W=n("h2"),Qt=n("a"),uu=n("span"),p(kn.$$.fragment),xm=r(),mr=n("span"),mr.textContent=$v,kl=r(),H=n("div"),p(Nn.$$.fragment),ym=r(),gr=n("p"),gr.textContent=qv,Nl=r(),D=n("h2"),Rt=n("a"),lu=n("span"),p(zn.$$.fragment),bm=r(),_r=n("span"),_r.textContent=Ov,zl=r(),V=n("div"),p(Pn.$$.fragment),wm=r(),vr=n("p"),vr.textContent=Sv,Pl=r(),I=n("h2"),Ut=n("a"),cu=n("span"),p(Ln.$$.fragment),$m=r(),Tr=n("span"),Tr.textContent=Cv,Ll=r(),Q=n("div"),p(En.$$.fragment),qm=r(),xr=n("p"),xr.textContent=Fv,El=r(),R=n("h2"),Xt=n("a"),pu=n("span"),p(Bn.$$.fragment),Om=r(),yr=n("span"),yr.textContent=Mv,Bl=r(),U=n("div"),p(jn.$$.fragment),Sm=r(),br=n("p"),br.textContent=Av,jl=r(),X=n("h2"),Jt=n("a"),hu=n("span"),p(Wn.$$.fragment),Cm=r(),wr=n("span"),wr.textContent=kv,Wl=r(),J=n("div"),p(Hn.$$.fragment),Fm=r(),$r=n("p"),$r.textContent=Nv,Hl=r(),Z=n("h2"),Zt=n("a"),fu=n("span"),p(Dn.$$.fragment),Mm=r(),qr=n("span"),qr.textContent=zv,Dl=r(),G=n("div"),p(Vn.$$.fragment),Am=r(),Or=n("p"),Or.textContent=Pv,Vl=r(),Y=n("h2"),Gt=n("a"),mu=n("span"),p(In.$$.fragment),km=r(),Sr=n("span"),Sr.textContent=Lv,Il=r(),K=n("div"),p(Qn.$$.fragment),Nm=r(),Cr=n("p"),Cr.textContent=Ev,Ql=r(),ee=n("h2"),Yt=n("a"),gu=n("span"),p(Rn.$$.fragment),zm=r(),Fr=n("span"),Fr.textContent=Bv,Rl=r(),te=n("div"),p(Un.$$.fragment),Pm=r(),Mr=n("p"),Mr.textContent=jv,Ul=r(),oe=n("h2"),Kt=n("a"),_u=n("span"),p(Xn.$$.fragment),Lm=r(),Ar=n("span"),Ar.textContent=Wv,Xl=r(),ne=n("div"),p(Jn.$$.fragment),Em=r(),kr=n("p"),kr.textContent=Hv,Jl=r(),se=n("h2"),eo=n("a"),vu=n("span"),p(Zn.$$.fragment),Bm=r(),Nr=n("span"),Nr.textContent=Dv,Zl=r(),ae=n("div"),p(Gn.$$.fragment),jm=r(),zr=n("p"),zr.textContent=Vv,Gl=r(),re=n("h2"),to=n("a"),Tu=n("span"),p(Yn.$$.fragment),Wm=r(),Pr=n("span"),Pr.textContent=Iv,Yl=r(),de=n("div"),p(Kn.$$.fragment),Hm=r(),Lr=n("p"),Lr.textContent=Qv,Kl=r(),ie=n("h2"),oo=n("a"),xu=n("span"),p(es.$$.fragment),Dm=r(),Er=n("span"),Er.textContent=Rv,ec=r(),ue=n("div"),p(ts.$$.fragment),Vm=r(),Br=n("p"),Br.textContent=Uv,tc=r(),le=n("h2"),no=n("a"),yu=n("span"),p(os.$$.fragment),Im=r(),jr=n("span"),jr.textContent=Xv,oc=r(),ce=n("div"),p(ns.$$.fragment),Qm=r(),Wr=n("p"),Wr.textContent=Jv,nc=r(),pe=n("h2"),so=n("a"),bu=n("span"),p(ss.$$.fragment),Rm=r(),Hr=n("span"),Hr.textContent=Zv,sc=r(),he=n("div"),p(as.$$.fragment),Um=r(),Dr=n("p"),Dr.textContent=Gv,ac=r(),fe=n("h2"),ao=n("a"),wu=n("span"),p(rs.$$.fragment),Xm=r(),Vr=n("span"),Vr.textContent=Yv,rc=r(),me=n("div"),p(ds.$$.fragment),Jm=r(),Ir=n("p"),Ir.textContent=Kv,dc=r(),ge=n("h2"),ro=n("a"),$u=n("span"),p(is.$$.fragment),Zm=r(),Qr=n("span"),Qr.textContent=eT,ic=r(),_e=n("div"),p(us.$$.fragment),Gm=r(),Rr=n("p"),Rr.textContent=tT,uc=r(),ve=n("h2"),io=n("a"),qu=n("span"),p(ls.$$.fragment),Ym=r(),Ur=n("span"),Ur.textContent=oT,lc=r(),Te=n("div"),p(cs.$$.fragment),Km=r(),Xr=n("p"),Xr.textContent=nT,cc=r(),xe=n("h2"),uo=n("a"),Ou=n("span"),p(ps.$$.fragment),eg=r(),Jr=n("span"),Jr.textContent=sT,pc=r(),ye=n("div"),p(hs.$$.fragment),tg=r(),Zr=n("p"),Zr.textContent=aT,hc=r(),be=n("h2"),lo=n("a"),Su=n("span"),p(fs.$$.fragment),og=r(),Gr=n("span"),Gr.textContent=rT,fc=r(),we=n("div"),p(ms.$$.fragment),ng=r(),Yr=n("p"),Yr.textContent=dT,mc=r(),$e=n("h2"),co=n("a"),Cu=n("span"),p(gs.$$.fragment),sg=r(),Kr=n("span"),Kr.textContent=iT,gc=r(),qe=n("div"),p(_s.$$.fragment),ag=r(),ed=n("p"),ed.textContent=uT,_c=r(),Oe=n("h2"),po=n("a"),Fu=n("span"),p(vs.$$.fragment),rg=r(),td=n("span"),td.textContent=lT,vc=r(),Se=n("div"),p(Ts.$$.fragment),dg=r(),od=n("p"),od.textContent=cT,Tc=r(),Ce=n("h2"),ho=n("a"),Mu=n("span"),p(xs.$$.fragment),ig=r(),nd=n("span"),nd.textContent=pT,xc=r(),Fe=n("div"),p(ys.$$.fragment),ug=r(),sd=n("p"),sd.textContent=hT,yc=r(),Me=n("h2"),fo=n("a"),Au=n("span"),p(bs.$$.fragment),lg=r(),ad=n("span"),ad.textContent=fT,bc=r(),Ae=n("div"),p(ws.$$.fragment),cg=r(),rd=n("p"),rd.textContent=mT,wc=r(),ke=n("h2"),mo=n("a"),ku=n("span"),p($s.$$.fragment),pg=r(),dd=n("span"),dd.textContent=gT,$c=r(),Ne=n("div"),p(qs.$$.fragment),hg=r(),id=n("p"),id.textContent=_T,qc=r(),ze=n("h2"),go=n("a"),Nu=n("span"),p(Os.$$.fragment),fg=r(),ud=n("span"),ud.textContent=vT,Oc=r(),Pe=n("div"),p(Ss.$$.fragment),mg=r(),ld=n("p"),ld.textContent=TT,Sc=r(),Le=n("h2"),_o=n("a"),zu=n("span"),p(Cs.$$.fragment),gg=r(),cd=n("span"),cd.textContent=xT,Cc=r(),Ee=n("div"),p(Fs.$$.fragment),_g=r(),pd=n("p"),pd.innerHTML=yT,Fc=r(),Be=n("h2"),vo=n("a"),Pu=n("span"),p(Ms.$$.fragment),vg=r(),hd=n("span"),hd.textContent=bT,Mc=r(),je=n("div"),p(As.$$.fragment),Tg=r(),fd=n("p"),fd.textContent=wT,Ac=r(),We=n("h2"),To=n("a"),Lu=n("span"),p(ks.$$.fragment),xg=r(),md=n("span"),md.textContent=$T,kc=r(),He=n("div"),p(Ns.$$.fragment),yg=r(),gd=n("p"),gd.textContent=qT,Nc=r(),De=n("h2"),xo=n("a"),Eu=n("span"),p(zs.$$.fragment),bg=r(),_d=n("span"),_d.textContent=OT,zc=r(),Ve=n("div"),p(Ps.$$.fragment),wg=r(),vd=n("p"),vd.textContent=ST,Pc=r(),Ie=n("h2"),yo=n("a"),Bu=n("span"),p(Ls.$$.fragment),$g=r(),Td=n("span"),Td.textContent=CT,Lc=r(),Qe=n("div"),p(Es.$$.fragment),qg=r(),xd=n("p"),xd.textContent=FT,Ec=r(),Re=n("h2"),bo=n("a"),ju=n("span"),p(Bs.$$.fragment),Og=r(),yd=n("span"),yd.textContent=MT,Bc=r(),Ue=n("div"),p(js.$$.fragment),Sg=r(),bd=n("p"),bd.textContent=AT,jc=r(),Xe=n("h2"),wo=n("a"),Wu=n("span"),p(Ws.$$.fragment),Cg=r(),wd=n("span"),wd.textContent=kT,Wc=r(),Je=n("div"),p(Hs.$$.fragment),Fg=r(),$d=n("p"),$d.textContent=NT,Hc=r(),Ze=n("h2"),$o=n("a"),Hu=n("span"),p(Ds.$$.fragment),Mg=r(),qd=n("span"),qd.textContent=zT,Dc=r(),Ge=n("div"),p(Vs.$$.fragment),Ag=r(),Od=n("p"),Od.textContent=PT,Vc=r(),Ye=n("h2"),qo=n("a"),Du=n("span"),p(Is.$$.fragment),kg=r(),Sd=n("span"),Sd.textContent=LT,Ic=r(),Ke=n("div"),p(Qs.$$.fragment),Ng=r(),Cd=n("p"),Cd.textContent=ET,Qc=r(),et=n("h2"),Oo=n("a"),Vu=n("span"),p(Rs.$$.fragment),zg=r(),Fd=n("span"),Fd.textContent=BT,Rc=r(),tt=n("div"),p(Us.$$.fragment),Pg=r(),Md=n("p"),Md.textContent=jT,Uc=r(),ot=n("h2"),So=n("a"),Iu=n("span"),p(Xs.$$.fragment),Lg=r(),Ad=n("span"),Ad.textContent=WT,Xc=r(),nt=n("div"),p(Js.$$.fragment),Eg=r(),kd=n("p"),kd.textContent=HT,Jc=r(),st=n("h2"),Co=n("a"),Qu=n("span"),p(Zs.$$.fragment),Bg=r(),Nd=n("span"),Nd.textContent=DT,Zc=r(),at=n("div"),p(Gs.$$.fragment),jg=r(),zd=n("p"),zd.textContent=VT,Gc=r(),rt=n("h2"),Fo=n("a"),Ru=n("span"),p(Ys.$$.fragment),Wg=r(),Pd=n("span"),Pd.textContent=IT,Yc=r(),dt=n("div"),p(Ks.$$.fragment),Hg=r(),Ld=n("p"),Ld.textContent=QT,Kc=r(),it=n("h2"),Mo=n("a"),Uu=n("span"),p(ea.$$.fragment),Dg=r(),Ed=n("span"),Ed.textContent=RT,ep=r(),ut=n("div"),p(ta.$$.fragment),Vg=r(),Bd=n("p"),Bd.textContent=UT,tp=r(),lt=n("h2"),Ao=n("a"),Xu=n("span"),p(oa.$$.fragment),Ig=r(),jd=n("span"),jd.textContent=XT,op=r(),ct=n("div"),p(na.$$.fragment),Qg=r(),Wd=n("p"),Wd.textContent=JT,np=r(),pt=n("h2"),ko=n("a"),Ju=n("span"),p(sa.$$.fragment),Rg=r(),Hd=n("span"),Hd.textContent=ZT,sp=r(),ht=n("div"),p(aa.$$.fragment),Ug=r(),Dd=n("p"),Dd.textContent=GT,ap=r(),ft=n("h2"),No=n("a"),Zu=n("span"),p(ra.$$.fragment),Xg=r(),Vd=n("span"),Vd.textContent=YT,rp=r(),mt=n("div"),p(da.$$.fragment),Jg=r(),Id=n("p"),Id.textContent=KT,dp=r(),gt=n("h2"),zo=n("a"),Gu=n("span"),p(ia.$$.fragment),Zg=r(),Qd=n("span"),Qd.textContent=ex,ip=r(),_t=n("div"),p(ua.$$.fragment),Gg=r(),Rd=n("p"),Rd.textContent=tx,up=r(),vt=n("h2"),Po=n("a"),Yu=n("span"),p(la.$$.fragment),Yg=r(),Ud=n("span"),Ud.textContent=ox,lp=r(),Tt=n("div"),p(ca.$$.fragment),Kg=r(),Xd=n("p"),Xd.textContent=nx,cp=r(),xt=n("h2"),Lo=n("a"),Ku=n("span"),p(pa.$$.fragment),e_=r(),Jd=n("span"),Jd.textContent=sx,pp=r(),yt=n("div"),p(ha.$$.fragment),t_=r(),Zd=n("p"),Zd.textContent=ax,hp=r(),bt=n("h2"),Eo=n("a"),el=n("span"),p(fa.$$.fragment),o_=r(),Gd=n("span"),Gd.textContent=rx,fp=r(),wt=n("div"),p(ma.$$.fragment),n_=r(),Yd=n("p"),Yd.textContent=dx,mp=r(),$t=n("h2"),Bo=n("a"),tl=n("span"),p(ga.$$.fragment),s_=r(),Kd=n("span"),Kd.textContent=ix,gp=r(),qt=n("div"),p(_a.$$.fragment),a_=r(),ei=n("p"),ei.textContent=ux,_p=r(),Ot=n("h2"),jo=n("a"),ol=n("span"),p(va.$$.fragment),r_=r(),ti=n("span"),ti.textContent=lx,vp=r(),w=n("div"),p(Ta.$$.fragment),d_=r(),oi=n("p"),oi.textContent=cx,i_=r(),Wo=n("div"),p(xa.$$.fragment),u_=r(),ni=n("p"),ni.textContent=px,Tp=r(),St=n("h2"),Ho=n("a"),nl=n("span"),p(ya.$$.fragment),l_=r(),si=n("span"),si.textContent=hx,xp=r(),$=n("div"),p(ba.$$.fragment),c_=r(),ai=n("p"),ai.textContent=fx,p_=r(),Do=n("div"),p(wa.$$.fragment),h_=r(),ri=n("p"),ri.textContent=mx,yp=r(),Ct=n("h2"),Vo=n("a"),sl=n("span"),p($a.$$.fragment),f_=r(),di=n("span"),di.textContent=gx,bp=r(),q=n("div"),p(qa.$$.fragment),m_=r(),ii=n("p"),ii.textContent=_x,g_=r(),Io=n("div"),p(Oa.$$.fragment),__=r(),ui=n("p"),ui.textContent=vx,wp=r(),Ft=n("h2"),Qo=n("a"),al=n("span"),p(Sa.$$.fragment),v_=r(),li=n("span"),li.textContent=Tx,$p=r(),O=n("div"),p(Ca.$$.fragment),T_=r(),ci=n("p"),ci.textContent=xx,x_=r(),Ro=n("div"),p(Fa.$$.fragment),y_=r(),pi=n("p"),pi.textContent=yx,qp=r(),Mt=n("h2"),Uo=n("a"),rl=n("span"),p(Ma.$$.fragment),b_=r(),hi=n("span"),hi.textContent=bx,Op=r(),S=n("div"),p(Aa.$$.fragment),w_=r(),fi=n("p"),fi.textContent=wx,$_=r(),Xo=n("div"),p(ka.$$.fragment),q_=r(),mi=n("p"),mi.textContent=$x,Sp=r(),At=n("h2"),Jo=n("a"),dl=n("span"),p(Na.$$.fragment),O_=r(),gi=n("span"),gi.textContent=qx,Cp=r(),C=n("div"),p(za.$$.fragment),S_=r(),_i=n("p"),_i.textContent=Ox,C_=r(),Zo=n("div"),p(Pa.$$.fragment),F_=r(),vi=n("p"),vi.textContent=Sx,Fp=r(),kt=n("h2"),Go=n("a"),il=n("span"),p(La.$$.fragment),M_=r(),Ti=n("span"),Ti.textContent=Cx,Mp=r(),F=n("div"),p(Ea.$$.fragment),A_=r(),xi=n("p"),xi.textContent=Fx,k_=r(),Yo=n("div"),p(Ba.$$.fragment),N_=r(),yi=n("p"),yi.textContent=Mx,Ap=r(),Nt=n("h2"),Ko=n("a"),ul=n("span"),p(ja.$$.fragment),z_=r(),bi=n("span"),bi.textContent=Ax,kp=r(),M=n("div"),p(Wa.$$.fragment),P_=r(),wi=n("p"),wi.textContent=kx,L_=r(),en=n("div"),p(Ha.$$.fragment),E_=r(),$i=n("p"),$i.textContent=Nx,Np=r(),zt=n("h2"),tn=n("a"),ll=n("span"),p(Da.$$.fragment),B_=r(),qi=n("span"),qi.textContent=zx,zp=r(),A=n("div"),p(Va.$$.fragment),j_=r(),Oi=n("p"),Oi.textContent=Px,W_=r(),on=n("div"),p(Ia.$$.fragment),H_=r(),Si=n("p"),Si.textContent=Lx,Pp=r(),Pt=n("h2"),nn=n("a"),cl=n("span"),p(Qa.$$.fragment),D_=r(),Ci=n("span"),Ci.textContent=Ex,Lp=r(),k=n("div"),p(Ra.$$.fragment),V_=r(),Fi=n("p"),Fi.textContent=Bx,I_=r(),sn=n("div"),p(Ua.$$.fragment),Q_=r(),Mi=n("p"),Mi.textContent=jx,Ep=r(),Lt=n("h2"),an=n("a"),pl=n("span"),p(Xa.$$.fragment),R_=r(),Ai=n("span"),Ai.textContent=Wx,Bp=r(),N=n("div"),p(Ja.$$.fragment),U_=r(),ki=n("p"),ki.textContent=Hx,X_=r(),rn=n("div"),p(Za.$$.fragment),J_=r(),Ni=n("p"),Ni.textContent=Dx,jp=r(),Et=n("h2"),dn=n("a"),hl=n("span"),p(Ga.$$.fragment),Z_=r(),zi=n("span"),zi.textContent=Vx,Wp=r(),z=n("div"),p(Ya.$$.fragment),G_=r(),Pi=n("p"),Pi.textContent=Ix,Y_=r(),un=n("div"),p(Ka.$$.fragment),K_=r(),Li=n("p"),Li.textContent=Qx,Hp=r(),Bt=n("h2"),ln=n("a"),fl=n("span"),p(er.$$.fragment),ev=r(),Ei=n("span"),Ei.textContent=Rx,Dp=r(),P=n("div"),p(tr.$$.fragment),tv=r(),Bi=n("p"),Bi.textContent=Ux,ov=r(),cn=n("div"),p(or.$$.fragment),nv=r(),ji=n("p"),ji.textContent=Xx,Vp=r(),jt=n("h2"),pn=n("a"),ml=n("span"),p(nr.$$.fragment),sv=r(),Wi=n("span"),Wi.textContent=Jx,Ip=r(),L=n("div"),p(sr.$$.fragment),av=r(),Hi=n("p"),Hi.textContent=Zx,rv=r(),hn=n("div"),p(ar.$$.fragment),dv=r(),Di=n("p"),Di.textContent=Gx,Qp=r(),Wt=n("h2"),fn=n("a"),gl=n("span"),p(rr.$$.fragment),iv=r(),Vi=n("span"),Vi.textContent=Yx,Rp=r(),E=n("div"),p(dr.$$.fragment),uv=r(),Ii=n("p"),Ii.textContent=Kx,lv=r(),mn=n("div"),p(ir.$$.fragment),cv=r(),Qi=n("p"),Qi.textContent=ey,Up=r(),_l=n("p"),this.h()},l(e){const i=S2("svelte-1phssyn",document.head);x=s(i,"META",{name:!0,content:!0}),i.forEach(t),_n=d(e),b=s(e,"P",{}),l(b).forEach(t),lr=d(e),B=s(e,"H1",{class:!0});var ur=l(B);Ht=s(ur,"A",{id:!0,class:!0,href:!0});var ty=l(Ht);du=s(ty,"SPAN",{});var oy=l(du);h(vn.$$.fragment,oy),oy.forEach(t),ty.forEach(t),fm=d(ur),cr=s(ur,"SPAN",{"data-svelte-h":!0}),c(cr)!=="svelte-pdeyrs"&&(cr.textContent=pv),ur.forEach(t),Tl=d(e),Tn=s(e,"P",{"data-svelte-h":!0}),c(Tn)!=="svelte-7hcrmh"&&(Tn.innerHTML=hv),xl=d(e),xn=s(e,"P",{"data-svelte-h":!0}),c(xn)!=="svelte-zk7t5e"&&(xn.textContent=fv),yl=d(e),h(yn.$$.fragment,e),bl=d(e),bn=s(e,"P",{"data-svelte-h":!0}),c(bn)!=="svelte-1tuh5ek"&&(bn.innerHTML=mv),wl=d(e),wn=s(e,"P",{"data-svelte-h":!0}),c(wn)!=="svelte-ww282k"&&(wn.innerHTML=gv),$l=d(e),$n=s(e,"P",{"data-svelte-h":!0}),c($n)!=="svelte-qrkykg"&&($n.innerHTML=_v),ql=d(e),h(qn.$$.fragment,e),Ol=d(e),On=s(e,"P",{"data-svelte-h":!0}),c(On)!=="svelte-sv5ldg"&&(On.innerHTML=vv),Sl=d(e),Sn=s(e,"P",{"data-svelte-h":!0}),c(Sn)!=="svelte-1tp97x6"&&(Sn.innerHTML=Tv),Cl=d(e),Cn=s(e,"P",{"data-svelte-h":!0}),c(Cn)!=="svelte-1b6en9a"&&(Cn.textContent=xv),Fl=d(e),j=s(e,"H2",{class:!0});var Jp=l(j);Dt=s(Jp,"A",{id:!0,class:!0,href:!0});var ny=l(Dt);iu=s(ny,"SPAN",{});var sy=l(iu);h(Fn.$$.fragment,sy),sy.forEach(t),ny.forEach(t),mm=d(Jp),pr=s(Jp,"SPAN",{"data-svelte-h":!0}),c(pr)!=="svelte-1ef4han"&&(pr.textContent=yv),Jp.forEach(t),Ml=d(e),y=s(e,"DIV",{class:!0});var gn=l(y);h(Mn.$$.fragment,gn),gm=d(gn),hr=s(gn,"P",{"data-svelte-h":!0}),c(hr)!=="svelte-1q6gwat"&&(hr.innerHTML=bv),_m=d(gn),h(Vt.$$.fragment,gn),vm=d(gn),It=s(gn,"DIV",{class:!0});var Zp=l(It);h(An.$$.fragment,Zp),Tm=d(Zp),fr=s(Zp,"P",{"data-svelte-h":!0}),c(fr)!=="svelte-1gdpts"&&(fr.innerHTML=wv),Zp.forEach(t),gn.forEach(t),Al=d(e),W=s(e,"H2",{class:!0});var Gp=l(W);Qt=s(Gp,"A",{id:!0,class:!0,href:!0});var ay=l(Qt);uu=s(ay,"SPAN",{});var ry=l(uu);h(kn.$$.fragment,ry),ry.forEach(t),ay.forEach(t),xm=d(Gp),mr=s(Gp,"SPAN",{"data-svelte-h":!0}),c(mr)!=="svelte-1a2thsg"&&(mr.textContent=$v),Gp.forEach(t),kl=d(e),H=s(e,"DIV",{class:!0});var Yp=l(H);h(Nn.$$.fragment,Yp),ym=d(Yp),gr=s(Yp,"P",{"data-svelte-h":!0}),c(gr)!=="svelte-19jpj19"&&(gr.textContent=qv),Yp.forEach(t),Nl=d(e),D=s(e,"H2",{class:!0});var Kp=l(D);Rt=s(Kp,"A",{id:!0,class:!0,href:!0});var dy=l(Rt);lu=s(dy,"SPAN",{});var iy=l(lu);h(zn.$$.fragment,iy),iy.forEach(t),dy.forEach(t),bm=d(Kp),_r=s(Kp,"SPAN",{"data-svelte-h":!0}),c(_r)!=="svelte-12bjow0"&&(_r.textContent=Ov),Kp.forEach(t),zl=d(e),V=s(e,"DIV",{class:!0});var eh=l(V);h(Pn.$$.fragment,eh),wm=d(eh),vr=s(eh,"P",{"data-svelte-h":!0}),c(vr)!=="svelte-rzpgnp"&&(vr.textContent=Sv),eh.forEach(t),Pl=d(e),I=s(e,"H2",{class:!0});var th=l(I);Ut=s(th,"A",{id:!0,class:!0,href:!0});var uy=l(Ut);cu=s(uy,"SPAN",{});var ly=l(cu);h(Ln.$$.fragment,ly),ly.forEach(t),uy.forEach(t),$m=d(th),Tr=s(th,"SPAN",{"data-svelte-h":!0}),c(Tr)!=="svelte-qpjwor"&&(Tr.textContent=Cv),th.forEach(t),Ll=d(e),Q=s(e,"DIV",{class:!0});var oh=l(Q);h(En.$$.fragment,oh),qm=d(oh),xr=s(oh,"P",{"data-svelte-h":!0}),c(xr)!=="svelte-19jpj19"&&(xr.textContent=Fv),oh.forEach(t),El=d(e),R=s(e,"H2",{class:!0});var nh=l(R);Xt=s(nh,"A",{id:!0,class:!0,href:!0});var cy=l(Xt);pu=s(cy,"SPAN",{});var py=l(pu);h(Bn.$$.fragment,py),py.forEach(t),cy.forEach(t),Om=d(nh),yr=s(nh,"SPAN",{"data-svelte-h":!0}),c(yr)!=="svelte-13467fc"&&(yr.textContent=Mv),nh.forEach(t),Bl=d(e),U=s(e,"DIV",{class:!0});var sh=l(U);h(jn.$$.fragment,sh),Sm=d(sh),br=s(sh,"P",{"data-svelte-h":!0}),c(br)!=="svelte-rzpgnp"&&(br.textContent=Av),sh.forEach(t),jl=d(e),X=s(e,"H2",{class:!0});var ah=l(X);Jt=s(ah,"A",{id:!0,class:!0,href:!0});var hy=l(Jt);hu=s(hy,"SPAN",{});var fy=l(hu);h(Wn.$$.fragment,fy),fy.forEach(t),hy.forEach(t),Cm=d(ah),wr=s(ah,"SPAN",{"data-svelte-h":!0}),c(wr)!=="svelte-1p9g8sk"&&(wr.textContent=kv),ah.forEach(t),Wl=d(e),J=s(e,"DIV",{class:!0});var rh=l(J);h(Hn.$$.fragment,rh),Fm=d(rh),$r=s(rh,"P",{"data-svelte-h":!0}),c($r)!=="svelte-1kt4x95"&&($r.textContent=Nv),rh.forEach(t),Hl=d(e),Z=s(e,"H2",{class:!0});var dh=l(Z);Zt=s(dh,"A",{id:!0,class:!0,href:!0});var my=l(Zt);fu=s(my,"SPAN",{});var gy=l(fu);h(Dn.$$.fragment,gy),gy.forEach(t),my.forEach(t),Mm=d(dh),qr=s(dh,"SPAN",{"data-svelte-h":!0}),c(qr)!=="svelte-1aypz0"&&(qr.textContent=zv),dh.forEach(t),Dl=d(e),G=s(e,"DIV",{class:!0});var ih=l(G);h(Vn.$$.fragment,ih),Am=d(ih),Or=s(ih,"P",{"data-svelte-h":!0}),c(Or)!=="svelte-1kt4x95"&&(Or.textContent=Pv),ih.forEach(t),Vl=d(e),Y=s(e,"H2",{class:!0});var uh=l(Y);Gt=s(uh,"A",{id:!0,class:!0,href:!0});var _y=l(Gt);mu=s(_y,"SPAN",{});var vy=l(mu);h(In.$$.fragment,vy),vy.forEach(t),_y.forEach(t),km=d(uh),Sr=s(uh,"SPAN",{"data-svelte-h":!0}),c(Sr)!=="svelte-fgkzpb"&&(Sr.textContent=Lv),uh.forEach(t),Il=d(e),K=s(e,"DIV",{class:!0});var lh=l(K);h(Qn.$$.fragment,lh),Nm=d(lh),Cr=s(lh,"P",{"data-svelte-h":!0}),c(Cr)!=="svelte-k12cko"&&(Cr.textContent=Ev),lh.forEach(t),Ql=d(e),ee=s(e,"H2",{class:!0});var ch=l(ee);Yt=s(ch,"A",{id:!0,class:!0,href:!0});var Ty=l(Yt);gu=s(Ty,"SPAN",{});var xy=l(gu);h(Rn.$$.fragment,xy),xy.forEach(t),Ty.forEach(t),zm=d(ch),Fr=s(ch,"SPAN",{"data-svelte-h":!0}),c(Fr)!=="svelte-1gagv9s"&&(Fr.textContent=Bv),ch.forEach(t),Rl=d(e),te=s(e,"DIV",{class:!0});var ph=l(te);h(Un.$$.fragment,ph),Pm=d(ph),Mr=s(ph,"P",{"data-svelte-h":!0}),c(Mr)!=="svelte-3npkmq"&&(Mr.textContent=jv),ph.forEach(t),Ul=d(e),oe=s(e,"H2",{class:!0});var hh=l(oe);Kt=s(hh,"A",{id:!0,class:!0,href:!0});var yy=l(Kt);_u=s(yy,"SPAN",{});var by=l(_u);h(Xn.$$.fragment,by),by.forEach(t),yy.forEach(t),Lm=d(hh),Ar=s(hh,"SPAN",{"data-svelte-h":!0}),c(Ar)!=="svelte-16uyeo9"&&(Ar.textContent=Wv),hh.forEach(t),Xl=d(e),ne=s(e,"DIV",{class:!0});var fh=l(ne);h(Jn.$$.fragment,fh),Em=d(fh),kr=s(fh,"P",{"data-svelte-h":!0}),c(kr)!=="svelte-3npkmq"&&(kr.textContent=Hv),fh.forEach(t),Jl=d(e),se=s(e,"H2",{class:!0});var mh=l(se);eo=s(mh,"A",{id:!0,class:!0,href:!0});var wy=l(eo);vu=s(wy,"SPAN",{});var $y=l(vu);h(Zn.$$.fragment,$y),$y.forEach(t),wy.forEach(t),Bm=d(mh),Nr=s(mh,"SPAN",{"data-svelte-h":!0}),c(Nr)!=="svelte-jpn7uk"&&(Nr.textContent=Dv),mh.forEach(t),Zl=d(e),ae=s(e,"DIV",{class:!0});var gh=l(ae);h(Gn.$$.fragment,gh),jm=d(gh),zr=s(gh,"P",{"data-svelte-h":!0}),c(zr)!=="svelte-3npkmq"&&(zr.textContent=Vv),gh.forEach(t),Gl=d(e),re=s(e,"H2",{class:!0});var _h=l(re);to=s(_h,"A",{id:!0,class:!0,href:!0});var qy=l(to);Tu=s(qy,"SPAN",{});var Oy=l(Tu);h(Yn.$$.fragment,Oy),Oy.forEach(t),qy.forEach(t),Wm=d(_h),Pr=s(_h,"SPAN",{"data-svelte-h":!0}),c(Pr)!=="svelte-19iaqfc"&&(Pr.textContent=Iv),_h.forEach(t),Yl=d(e),de=s(e,"DIV",{class:!0});var vh=l(de);h(Kn.$$.fragment,vh),Hm=d(vh),Lr=s(vh,"P",{"data-svelte-h":!0}),c(Lr)!=="svelte-1xezu93"&&(Lr.textContent=Qv),vh.forEach(t),Kl=d(e),ie=s(e,"H2",{class:!0});var Th=l(ie);oo=s(Th,"A",{id:!0,class:!0,href:!0});var Sy=l(oo);xu=s(Sy,"SPAN",{});var Cy=l(xu);h(es.$$.fragment,Cy),Cy.forEach(t),Sy.forEach(t),Dm=d(Th),Er=s(Th,"SPAN",{"data-svelte-h":!0}),c(Er)!=="svelte-adyvor"&&(Er.textContent=Rv),Th.forEach(t),ec=d(e),ue=s(e,"DIV",{class:!0});var xh=l(ue);h(ts.$$.fragment,xh),Vm=d(xh),Br=s(xh,"P",{"data-svelte-h":!0}),c(Br)!=="svelte-1dobm33"&&(Br.textContent=Uv),xh.forEach(t),tc=d(e),le=s(e,"H2",{class:!0});var yh=l(le);no=s(yh,"A",{id:!0,class:!0,href:!0});var Fy=l(no);yu=s(Fy,"SPAN",{});var My=l(yu);h(os.$$.fragment,My),My.forEach(t),Fy.forEach(t),Im=d(yh),jr=s(yh,"SPAN",{"data-svelte-h":!0}),c(jr)!=="svelte-48jzli"&&(jr.textContent=Xv),yh.forEach(t),oc=d(e),ce=s(e,"DIV",{class:!0});var bh=l(ce);h(ns.$$.fragment,bh),Qm=d(bh),Wr=s(bh,"P",{"data-svelte-h":!0}),c(Wr)!=="svelte-1bm2i0r"&&(Wr.textContent=Jv),bh.forEach(t),nc=d(e),pe=s(e,"H2",{class:!0});var wh=l(pe);so=s(wh,"A",{id:!0,class:!0,href:!0});var Ay=l(so);bu=s(Ay,"SPAN",{});var ky=l(bu);h(ss.$$.fragment,ky),ky.forEach(t),Ay.forEach(t),Rm=d(wh),Hr=s(wh,"SPAN",{"data-svelte-h":!0}),c(Hr)!=="svelte-wttvdu"&&(Hr.textContent=Zv),wh.forEach(t),sc=d(e),he=s(e,"DIV",{class:!0});var $h=l(he);h(as.$$.fragment,$h),Um=d($h),Dr=s($h,"P",{"data-svelte-h":!0}),c(Dr)!=="svelte-o4u80u"&&(Dr.textContent=Gv),$h.forEach(t),ac=d(e),fe=s(e,"H2",{class:!0});var qh=l(fe);ao=s(qh,"A",{id:!0,class:!0,href:!0});var Ny=l(ao);wu=s(Ny,"SPAN",{});var zy=l(wu);h(rs.$$.fragment,zy),zy.forEach(t),Ny.forEach(t),Xm=d(qh),Vr=s(qh,"SPAN",{"data-svelte-h":!0}),c(Vr)!=="svelte-1rc0d00"&&(Vr.textContent=Yv),qh.forEach(t),rc=d(e),me=s(e,"DIV",{class:!0});var Oh=l(me);h(ds.$$.fragment,Oh),Jm=d(Oh),Ir=s(Oh,"P",{"data-svelte-h":!0}),c(Ir)!=="svelte-1kfw2sn"&&(Ir.textContent=Kv),Oh.forEach(t),dc=d(e),ge=s(e,"H2",{class:!0});var Sh=l(ge);ro=s(Sh,"A",{id:!0,class:!0,href:!0});var Py=l(ro);$u=s(Py,"SPAN",{});var Ly=l($u);h(is.$$.fragment,Ly),Ly.forEach(t),Py.forEach(t),Zm=d(Sh),Qr=s(Sh,"SPAN",{"data-svelte-h":!0}),c(Qr)!=="svelte-10ckve"&&(Qr.textContent=eT),Sh.forEach(t),ic=d(e),_e=s(e,"DIV",{class:!0});var Ch=l(_e);h(us.$$.fragment,Ch),Gm=d(Ch),Rr=s(Ch,"P",{"data-svelte-h":!0}),c(Rr)!=="svelte-yql1ve"&&(Rr.textContent=tT),Ch.forEach(t),uc=d(e),ve=s(e,"H2",{class:!0});var Fh=l(ve);io=s(Fh,"A",{id:!0,class:!0,href:!0});var Ey=l(io);qu=s(Ey,"SPAN",{});var By=l(qu);h(ls.$$.fragment,By),By.forEach(t),Ey.forEach(t),Ym=d(Fh),Ur=s(Fh,"SPAN",{"data-svelte-h":!0}),c(Ur)!=="svelte-s33aw2"&&(Ur.textContent=oT),Fh.forEach(t),lc=d(e),Te=s(e,"DIV",{class:!0});var Mh=l(Te);h(cs.$$.fragment,Mh),Km=d(Mh),Xr=s(Mh,"P",{"data-svelte-h":!0}),c(Xr)!=="svelte-1iv9pso"&&(Xr.textContent=nT),Mh.forEach(t),cc=d(e),xe=s(e,"H2",{class:!0});var Ah=l(xe);uo=s(Ah,"A",{id:!0,class:!0,href:!0});var jy=l(uo);Ou=s(jy,"SPAN",{});var Wy=l(Ou);h(ps.$$.fragment,Wy),Wy.forEach(t),jy.forEach(t),eg=d(Ah),Jr=s(Ah,"SPAN",{"data-svelte-h":!0}),c(Jr)!=="svelte-gbrupb"&&(Jr.textContent=sT),Ah.forEach(t),pc=d(e),ye=s(e,"DIV",{class:!0});var kh=l(ye);h(hs.$$.fragment,kh),tg=d(kh),Zr=s(kh,"P",{"data-svelte-h":!0}),c(Zr)!=="svelte-w7415f"&&(Zr.textContent=aT),kh.forEach(t),hc=d(e),be=s(e,"H2",{class:!0});var Nh=l(be);lo=s(Nh,"A",{id:!0,class:!0,href:!0});var Hy=l(lo);Su=s(Hy,"SPAN",{});var Dy=l(Su);h(fs.$$.fragment,Dy),Dy.forEach(t),Hy.forEach(t),og=d(Nh),Gr=s(Nh,"SPAN",{"data-svelte-h":!0}),c(Gr)!=="svelte-tdd3hb"&&(Gr.textContent=rT),Nh.forEach(t),fc=d(e),we=s(e,"DIV",{class:!0});var zh=l(we);h(ms.$$.fragment,zh),ng=d(zh),Yr=s(zh,"P",{"data-svelte-h":!0}),c(Yr)!=="svelte-dhzux4"&&(Yr.textContent=dT),zh.forEach(t),mc=d(e),$e=s(e,"H2",{class:!0});var Ph=l($e);co=s(Ph,"A",{id:!0,class:!0,href:!0});var Vy=l(co);Cu=s(Vy,"SPAN",{});var Iy=l(Cu);h(gs.$$.fragment,Iy),Iy.forEach(t),Vy.forEach(t),sg=d(Ph),Kr=s(Ph,"SPAN",{"data-svelte-h":!0}),c(Kr)!=="svelte-10xg2fj"&&(Kr.textContent=iT),Ph.forEach(t),gc=d(e),qe=s(e,"DIV",{class:!0});var Lh=l(qe);h(_s.$$.fragment,Lh),ag=d(Lh),ed=s(Lh,"P",{"data-svelte-h":!0}),c(ed)!=="svelte-8u8l5m"&&(ed.textContent=uT),Lh.forEach(t),_c=d(e),Oe=s(e,"H2",{class:!0});var Eh=l(Oe);po=s(Eh,"A",{id:!0,class:!0,href:!0});var Qy=l(po);Fu=s(Qy,"SPAN",{});var Ry=l(Fu);h(vs.$$.fragment,Ry),Ry.forEach(t),Qy.forEach(t),rg=d(Eh),td=s(Eh,"SPAN",{"data-svelte-h":!0}),c(td)!=="svelte-1rlqqjo"&&(td.textContent=lT),Eh.forEach(t),vc=d(e),Se=s(e,"DIV",{class:!0});var Bh=l(Se);h(Ts.$$.fragment,Bh),dg=d(Bh),od=s(Bh,"P",{"data-svelte-h":!0}),c(od)!=="svelte-kob7ff"&&(od.textContent=cT),Bh.forEach(t),Tc=d(e),Ce=s(e,"H2",{class:!0});var jh=l(Ce);ho=s(jh,"A",{id:!0,class:!0,href:!0});var Uy=l(ho);Mu=s(Uy,"SPAN",{});var Xy=l(Mu);h(xs.$$.fragment,Xy),Xy.forEach(t),Uy.forEach(t),ig=d(jh),nd=s(jh,"SPAN",{"data-svelte-h":!0}),c(nd)!=="svelte-lzhsv6"&&(nd.textContent=pT),jh.forEach(t),xc=d(e),Fe=s(e,"DIV",{class:!0});var Wh=l(Fe);h(ys.$$.fragment,Wh),ug=d(Wh),sd=s(Wh,"P",{"data-svelte-h":!0}),c(sd)!=="svelte-sv2ymo"&&(sd.textContent=hT),Wh.forEach(t),yc=d(e),Me=s(e,"H2",{class:!0});var Hh=l(Me);fo=s(Hh,"A",{id:!0,class:!0,href:!0});var Jy=l(fo);Au=s(Jy,"SPAN",{});var Zy=l(Au);h(bs.$$.fragment,Zy),Zy.forEach(t),Jy.forEach(t),lg=d(Hh),ad=s(Hh,"SPAN",{"data-svelte-h":!0}),c(ad)!=="svelte-1ljovlp"&&(ad.textContent=fT),Hh.forEach(t),bc=d(e),Ae=s(e,"DIV",{class:!0});var Dh=l(Ae);h(ws.$$.fragment,Dh),cg=d(Dh),rd=s(Dh,"P",{"data-svelte-h":!0}),c(rd)!=="svelte-sv2ymo"&&(rd.textContent=mT),Dh.forEach(t),wc=d(e),ke=s(e,"H2",{class:!0});var Vh=l(ke);mo=s(Vh,"A",{id:!0,class:!0,href:!0});var Gy=l(mo);ku=s(Gy,"SPAN",{});var Yy=l(ku);h($s.$$.fragment,Yy),Yy.forEach(t),Gy.forEach(t),pg=d(Vh),dd=s(Vh,"SPAN",{"data-svelte-h":!0}),c(dd)!=="svelte-18g0iqh"&&(dd.textContent=gT),Vh.forEach(t),$c=d(e),Ne=s(e,"DIV",{class:!0});var Ih=l(Ne);h(qs.$$.fragment,Ih),hg=d(Ih),id=s(Ih,"P",{"data-svelte-h":!0}),c(id)!=="svelte-1rjgll"&&(id.textContent=_T),Ih.forEach(t),qc=d(e),ze=s(e,"H2",{class:!0});var Qh=l(ze);go=s(Qh,"A",{id:!0,class:!0,href:!0});var Ky=l(go);Nu=s(Ky,"SPAN",{});var eb=l(Nu);h(Os.$$.fragment,eb),eb.forEach(t),Ky.forEach(t),fg=d(Qh),ud=s(Qh,"SPAN",{"data-svelte-h":!0}),c(ud)!=="svelte-1id1sfo"&&(ud.textContent=vT),Qh.forEach(t),Oc=d(e),Pe=s(e,"DIV",{class:!0});var Rh=l(Pe);h(Ss.$$.fragment,Rh),mg=d(Rh),ld=s(Rh,"P",{"data-svelte-h":!0}),c(ld)!=="svelte-1tmia4b"&&(ld.textContent=TT),Rh.forEach(t),Sc=d(e),Le=s(e,"H2",{class:!0});var Uh=l(Le);_o=s(Uh,"A",{id:!0,class:!0,href:!0});var tb=l(_o);zu=s(tb,"SPAN",{});var ob=l(zu);h(Cs.$$.fragment,ob),ob.forEach(t),tb.forEach(t),gg=d(Uh),cd=s(Uh,"SPAN",{"data-svelte-h":!0}),c(cd)!=="svelte-17e2f41"&&(cd.textContent=xT),Uh.forEach(t),Cc=d(e),Ee=s(e,"DIV",{class:!0});var Xh=l(Ee);h(Fs.$$.fragment,Xh),_g=d(Xh),pd=s(Xh,"P",{"data-svelte-h":!0}),c(pd)!=="svelte-wpmgc7"&&(pd.innerHTML=yT),Xh.forEach(t),Fc=d(e),Be=s(e,"H2",{class:!0});var Jh=l(Be);vo=s(Jh,"A",{id:!0,class:!0,href:!0});var nb=l(vo);Pu=s(nb,"SPAN",{});var sb=l(Pu);h(Ms.$$.fragment,sb),sb.forEach(t),nb.forEach(t),vg=d(Jh),hd=s(Jh,"SPAN",{"data-svelte-h":!0}),c(hd)!=="svelte-a1dfx2"&&(hd.textContent=bT),Jh.forEach(t),Mc=d(e),je=s(e,"DIV",{class:!0});var Zh=l(je);h(As.$$.fragment,Zh),Tg=d(Zh),fd=s(Zh,"P",{"data-svelte-h":!0}),c(fd)!=="svelte-dz9ong"&&(fd.textContent=wT),Zh.forEach(t),Ac=d(e),We=s(e,"H2",{class:!0});var Gh=l(We);To=s(Gh,"A",{id:!0,class:!0,href:!0});var ab=l(To);Lu=s(ab,"SPAN",{});var rb=l(Lu);h(ks.$$.fragment,rb),rb.forEach(t),ab.forEach(t),xg=d(Gh),md=s(Gh,"SPAN",{"data-svelte-h":!0}),c(md)!=="svelte-10gavac"&&(md.textContent=$T),Gh.forEach(t),kc=d(e),He=s(e,"DIV",{class:!0});var Yh=l(He);h(Ns.$$.fragment,Yh),yg=d(Yh),gd=s(Yh,"P",{"data-svelte-h":!0}),c(gd)!=="svelte-os2t7w"&&(gd.textContent=qT),Yh.forEach(t),Nc=d(e),De=s(e,"H2",{class:!0});var Kh=l(De);xo=s(Kh,"A",{id:!0,class:!0,href:!0});var db=l(xo);Eu=s(db,"SPAN",{});var ib=l(Eu);h(zs.$$.fragment,ib),ib.forEach(t),db.forEach(t),bg=d(Kh),_d=s(Kh,"SPAN",{"data-svelte-h":!0}),c(_d)!=="svelte-11v9g64"&&(_d.textContent=OT),Kh.forEach(t),zc=d(e),Ve=s(e,"DIV",{class:!0});var ef=l(Ve);h(Ps.$$.fragment,ef),wg=d(ef),vd=s(ef,"P",{"data-svelte-h":!0}),c(vd)!=="svelte-1iolpnx"&&(vd.textContent=ST),ef.forEach(t),Pc=d(e),Ie=s(e,"H2",{class:!0});var tf=l(Ie);yo=s(tf,"A",{id:!0,class:!0,href:!0});var ub=l(yo);Bu=s(ub,"SPAN",{});var lb=l(Bu);h(Ls.$$.fragment,lb),lb.forEach(t),ub.forEach(t),$g=d(tf),Td=s(tf,"SPAN",{"data-svelte-h":!0}),c(Td)!=="svelte-x6bhrq"&&(Td.textContent=CT),tf.forEach(t),Lc=d(e),Qe=s(e,"DIV",{class:!0});var of=l(Qe);h(Es.$$.fragment,of),qg=d(of),xd=s(of,"P",{"data-svelte-h":!0}),c(xd)!=="svelte-19jpj19"&&(xd.textContent=FT),of.forEach(t),Ec=d(e),Re=s(e,"H2",{class:!0});var nf=l(Re);bo=s(nf,"A",{id:!0,class:!0,href:!0});var cb=l(bo);ju=s(cb,"SPAN",{});var pb=l(ju);h(Bs.$$.fragment,pb),pb.forEach(t),cb.forEach(t),Og=d(nf),yd=s(nf,"SPAN",{"data-svelte-h":!0}),c(yd)!=="svelte-od18p2"&&(yd.textContent=MT),nf.forEach(t),Bc=d(e),Ue=s(e,"DIV",{class:!0});var sf=l(Ue);h(js.$$.fragment,sf),Sg=d(sf),bd=s(sf,"P",{"data-svelte-h":!0}),c(bd)!=="svelte-rzpgnp"&&(bd.textContent=AT),sf.forEach(t),jc=d(e),Xe=s(e,"H2",{class:!0});var af=l(Xe);wo=s(af,"A",{id:!0,class:!0,href:!0});var hb=l(wo);Wu=s(hb,"SPAN",{});var fb=l(Wu);h(Ws.$$.fragment,fb),fb.forEach(t),hb.forEach(t),Cg=d(af),wd=s(af,"SPAN",{"data-svelte-h":!0}),c(wd)!=="svelte-sjs78e"&&(wd.textContent=kT),af.forEach(t),Wc=d(e),Je=s(e,"DIV",{class:!0});var rf=l(Je);h(Hs.$$.fragment,rf),Fg=d(rf),$d=s(rf,"P",{"data-svelte-h":!0}),c($d)!=="svelte-rzpgnp"&&($d.textContent=NT),rf.forEach(t),Hc=d(e),Ze=s(e,"H2",{class:!0});var df=l(Ze);$o=s(df,"A",{id:!0,class:!0,href:!0});var mb=l($o);Hu=s(mb,"SPAN",{});var gb=l(Hu);h(Ds.$$.fragment,gb),gb.forEach(t),mb.forEach(t),Mg=d(df),qd=s(df,"SPAN",{"data-svelte-h":!0}),c(qd)!=="svelte-akpc6i"&&(qd.textContent=zT),df.forEach(t),Dc=d(e),Ge=s(e,"DIV",{class:!0});var uf=l(Ge);h(Vs.$$.fragment,uf),Ag=d(uf),Od=s(uf,"P",{"data-svelte-h":!0}),c(Od)!=="svelte-1kt4x95"&&(Od.textContent=PT),uf.forEach(t),Vc=d(e),Ye=s(e,"H2",{class:!0});var lf=l(Ye);qo=s(lf,"A",{id:!0,class:!0,href:!0});var _b=l(qo);Du=s(_b,"SPAN",{});var vb=l(Du);h(Is.$$.fragment,vb),vb.forEach(t),_b.forEach(t),kg=d(lf),Sd=s(lf,"SPAN",{"data-svelte-h":!0}),c(Sd)!=="svelte-1qz2b1e"&&(Sd.textContent=LT),lf.forEach(t),Ic=d(e),Ke=s(e,"DIV",{class:!0});var cf=l(Ke);h(Qs.$$.fragment,cf),Ng=d(cf),Cd=s(cf,"P",{"data-svelte-h":!0}),c(Cd)!=="svelte-1kt4x95"&&(Cd.textContent=ET),cf.forEach(t),Qc=d(e),et=s(e,"H2",{class:!0});var pf=l(et);Oo=s(pf,"A",{id:!0,class:!0,href:!0});var Tb=l(Oo);Vu=s(Tb,"SPAN",{});var xb=l(Vu);h(Rs.$$.fragment,xb),xb.forEach(t),Tb.forEach(t),zg=d(pf),Fd=s(pf,"SPAN",{"data-svelte-h":!0}),c(Fd)!=="svelte-c1w9k9"&&(Fd.textContent=BT),pf.forEach(t),Rc=d(e),tt=s(e,"DIV",{class:!0});var hf=l(tt);h(Us.$$.fragment,hf),Pg=d(hf),Md=s(hf,"P",{"data-svelte-h":!0}),c(Md)!=="svelte-k12cko"&&(Md.textContent=jT),hf.forEach(t),Uc=d(e),ot=s(e,"H2",{class:!0});var ff=l(ot);So=s(ff,"A",{id:!0,class:!0,href:!0});var yb=l(So);Iu=s(yb,"SPAN",{});var bb=l(Iu);h(Xs.$$.fragment,bb),bb.forEach(t),yb.forEach(t),Lg=d(ff),Ad=s(ff,"SPAN",{"data-svelte-h":!0}),c(Ad)!=="svelte-10rtrjq"&&(Ad.textContent=WT),ff.forEach(t),Xc=d(e),nt=s(e,"DIV",{class:!0});var mf=l(nt);h(Js.$$.fragment,mf),Eg=d(mf),kd=s(mf,"P",{"data-svelte-h":!0}),c(kd)!=="svelte-3npkmq"&&(kd.textContent=HT),mf.forEach(t),Jc=d(e),st=s(e,"H2",{class:!0});var gf=l(st);Co=s(gf,"A",{id:!0,class:!0,href:!0});var wb=l(Co);Qu=s(wb,"SPAN",{});var $b=l(Qu);h(Zs.$$.fragment,$b),$b.forEach(t),wb.forEach(t),Bg=d(gf),Nd=s(gf,"SPAN",{"data-svelte-h":!0}),c(Nd)!=="svelte-11ictgf"&&(Nd.textContent=DT),gf.forEach(t),Zc=d(e),at=s(e,"DIV",{class:!0});var _f=l(at);h(Gs.$$.fragment,_f),jg=d(_f),zd=s(_f,"P",{"data-svelte-h":!0}),c(zd)!=="svelte-3npkmq"&&(zd.textContent=VT),_f.forEach(t),Gc=d(e),rt=s(e,"H2",{class:!0});var vf=l(rt);Fo=s(vf,"A",{id:!0,class:!0,href:!0});var qb=l(Fo);Ru=s(qb,"SPAN",{});var Ob=l(Ru);h(Ys.$$.fragment,Ob),Ob.forEach(t),qb.forEach(t),Wg=d(vf),Pd=s(vf,"SPAN",{"data-svelte-h":!0}),c(Pd)!=="svelte-1u5xujm"&&(Pd.textContent=IT),vf.forEach(t),Yc=d(e),dt=s(e,"DIV",{class:!0});var Tf=l(dt);h(Ks.$$.fragment,Tf),Hg=d(Tf),Ld=s(Tf,"P",{"data-svelte-h":!0}),c(Ld)!=="svelte-3npkmq"&&(Ld.textContent=QT),Tf.forEach(t),Kc=d(e),it=s(e,"H2",{class:!0});var xf=l(it);Mo=s(xf,"A",{id:!0,class:!0,href:!0});var Sb=l(Mo);Uu=s(Sb,"SPAN",{});var Cb=l(Uu);h(ea.$$.fragment,Cb),Cb.forEach(t),Sb.forEach(t),Dg=d(xf),Ed=s(xf,"SPAN",{"data-svelte-h":!0}),c(Ed)!=="svelte-1837iem"&&(Ed.textContent=RT),xf.forEach(t),ep=d(e),ut=s(e,"DIV",{class:!0});var yf=l(ut);h(ta.$$.fragment,yf),Vg=d(yf),Bd=s(yf,"P",{"data-svelte-h":!0}),c(Bd)!=="svelte-1xezu93"&&(Bd.textContent=UT),yf.forEach(t),tp=d(e),lt=s(e,"H2",{class:!0});var bf=l(lt);Ao=s(bf,"A",{id:!0,class:!0,href:!0});var Fb=l(Ao);Xu=s(Fb,"SPAN",{});var Mb=l(Xu);h(oa.$$.fragment,Mb),Mb.forEach(t),Fb.forEach(t),Ig=d(bf),jd=s(bf,"SPAN",{"data-svelte-h":!0}),c(jd)!=="svelte-10vwa0l"&&(jd.textContent=XT),bf.forEach(t),op=d(e),ct=s(e,"DIV",{class:!0});var wf=l(ct);h(na.$$.fragment,wf),Qg=d(wf),Wd=s(wf,"P",{"data-svelte-h":!0}),c(Wd)!=="svelte-1dobm33"&&(Wd.textContent=JT),wf.forEach(t),np=d(e),pt=s(e,"H2",{class:!0});var $f=l(pt);ko=s($f,"A",{id:!0,class:!0,href:!0});var Ab=l(ko);Ju=s(Ab,"SPAN",{});var kb=l(Ju);h(sa.$$.fragment,kb),kb.forEach(t),Ab.forEach(t),Rg=d($f),Hd=s($f,"SPAN",{"data-svelte-h":!0}),c(Hd)!=="svelte-1ndjqfs"&&(Hd.textContent=ZT),$f.forEach(t),sp=d(e),ht=s(e,"DIV",{class:!0});var qf=l(ht);h(aa.$$.fragment,qf),Ug=d(qf),Dd=s(qf,"P",{"data-svelte-h":!0}),c(Dd)!=="svelte-1bm2i0r"&&(Dd.textContent=GT),qf.forEach(t),ap=d(e),ft=s(e,"H2",{class:!0});var Of=l(ft);No=s(Of,"A",{id:!0,class:!0,href:!0});var Nb=l(No);Zu=s(Nb,"SPAN",{});var zb=l(Zu);h(ra.$$.fragment,zb),zb.forEach(t),Nb.forEach(t),Xg=d(Of),Vd=s(Of,"SPAN",{"data-svelte-h":!0}),c(Vd)!=="svelte-qjstw4"&&(Vd.textContent=YT),Of.forEach(t),rp=d(e),mt=s(e,"DIV",{class:!0});var Sf=l(mt);h(da.$$.fragment,Sf),Jg=d(Sf),Id=s(Sf,"P",{"data-svelte-h":!0}),c(Id)!=="svelte-o4u80u"&&(Id.textContent=KT),Sf.forEach(t),dp=d(e),gt=s(e,"H2",{class:!0});var Cf=l(gt);zo=s(Cf,"A",{id:!0,class:!0,href:!0});var Pb=l(zo);Gu=s(Pb,"SPAN",{});var Lb=l(Gu);h(ia.$$.fragment,Lb),Lb.forEach(t),Pb.forEach(t),Zg=d(Cf),Qd=s(Cf,"SPAN",{"data-svelte-h":!0}),c(Qd)!=="svelte-1tbdu7q"&&(Qd.textContent=ex),Cf.forEach(t),ip=d(e),_t=s(e,"DIV",{class:!0});var Ff=l(_t);h(ua.$$.fragment,Ff),Gg=d(Ff),Rd=s(Ff,"P",{"data-svelte-h":!0}),c(Rd)!=="svelte-1kfw2sn"&&(Rd.textContent=tx),Ff.forEach(t),up=d(e),vt=s(e,"H2",{class:!0});var Mf=l(vt);Po=s(Mf,"A",{id:!0,class:!0,href:!0});var Eb=l(Po);Yu=s(Eb,"SPAN",{});var Bb=l(Yu);h(la.$$.fragment,Bb),Bb.forEach(t),Eb.forEach(t),Yg=d(Mf),Ud=s(Mf,"SPAN",{"data-svelte-h":!0}),c(Ud)!=="svelte-1eqxli4"&&(Ud.textContent=ox),Mf.forEach(t),lp=d(e),Tt=s(e,"DIV",{class:!0});var Af=l(Tt);h(ca.$$.fragment,Af),Kg=d(Af),Xd=s(Af,"P",{"data-svelte-h":!0}),c(Xd)!=="svelte-yql1ve"&&(Xd.textContent=nx),Af.forEach(t),cp=d(e),xt=s(e,"H2",{class:!0});var kf=l(xt);Lo=s(kf,"A",{id:!0,class:!0,href:!0});var jb=l(Lo);Ku=s(jb,"SPAN",{});var Wb=l(Ku);h(pa.$$.fragment,Wb),Wb.forEach(t),jb.forEach(t),e_=d(kf),Jd=s(kf,"SPAN",{"data-svelte-h":!0}),c(Jd)!=="svelte-vovdw4"&&(Jd.textContent=sx),kf.forEach(t),pp=d(e),yt=s(e,"DIV",{class:!0});var Nf=l(yt);h(ha.$$.fragment,Nf),t_=d(Nf),Zd=s(Nf,"P",{"data-svelte-h":!0}),c(Zd)!=="svelte-1iv9pso"&&(Zd.textContent=ax),Nf.forEach(t),hp=d(e),bt=s(e,"H2",{class:!0});var zf=l(bt);Eo=s(zf,"A",{id:!0,class:!0,href:!0});var Hb=l(Eo);el=s(Hb,"SPAN",{});var Db=l(el);h(fa.$$.fragment,Db),Db.forEach(t),Hb.forEach(t),o_=d(zf),Gd=s(zf,"SPAN",{"data-svelte-h":!0}),c(Gd)!=="svelte-13upjw9"&&(Gd.textContent=rx),zf.forEach(t),fp=d(e),wt=s(e,"DIV",{class:!0});var Pf=l(wt);h(ma.$$.fragment,Pf),n_=d(Pf),Yd=s(Pf,"P",{"data-svelte-h":!0}),c(Yd)!=="svelte-w7415f"&&(Yd.textContent=dx),Pf.forEach(t),mp=d(e),$t=s(e,"H2",{class:!0});var Lf=l($t);Bo=s(Lf,"A",{id:!0,class:!0,href:!0});var Vb=l(Bo);tl=s(Vb,"SPAN",{});var Ib=l(tl);h(ga.$$.fragment,Ib),Ib.forEach(t),Vb.forEach(t),s_=d(Lf),Kd=s(Lf,"SPAN",{"data-svelte-h":!0}),c(Kd)!=="svelte-1xen7d5"&&(Kd.textContent=ix),Lf.forEach(t),gp=d(e),qt=s(e,"DIV",{class:!0});var Ef=l(qt);h(_a.$$.fragment,Ef),a_=d(Ef),ei=s(Ef,"P",{"data-svelte-h":!0}),c(ei)!=="svelte-dhzux4"&&(ei.textContent=ux),Ef.forEach(t),_p=d(e),Ot=s(e,"H2",{class:!0});var Bf=l(Ot);jo=s(Bf,"A",{id:!0,class:!0,href:!0});var Qb=l(jo);ol=s(Qb,"SPAN",{});var Rb=l(ol);h(va.$$.fragment,Rb),Rb.forEach(t),Qb.forEach(t),r_=d(Bf),ti=s(Bf,"SPAN",{"data-svelte-h":!0}),c(ti)!=="svelte-usew05"&&(ti.textContent=lx),Bf.forEach(t),vp=d(e),w=s(e,"DIV",{class:!0});var Ri=l(w);h(Ta.$$.fragment,Ri),d_=d(Ri),oi=s(Ri,"P",{"data-svelte-h":!0}),c(oi)!=="svelte-19jpj19"&&(oi.textContent=cx),i_=d(Ri),Wo=s(Ri,"DIV",{class:!0});var jf=l(Wo);h(xa.$$.fragment,jf),u_=d(jf),ni=s(jf,"P",{"data-svelte-h":!0}),c(ni)!=="svelte-5ihtpa"&&(ni.textContent=px),jf.forEach(t),Ri.forEach(t),Tp=d(e),St=s(e,"H2",{class:!0});var Wf=l(St);Ho=s(Wf,"A",{id:!0,class:!0,href:!0});var Ub=l(Ho);nl=s(Ub,"SPAN",{});var Xb=l(nl);h(ya.$$.fragment,Xb),Xb.forEach(t),Ub.forEach(t),l_=d(Wf),si=s(Wf,"SPAN",{"data-svelte-h":!0}),c(si)!=="svelte-q7ayqx"&&(si.textContent=hx),Wf.forEach(t),xp=d(e),$=s(e,"DIV",{class:!0});var Ui=l($);h(ba.$$.fragment,Ui),c_=d(Ui),ai=s(Ui,"P",{"data-svelte-h":!0}),c(ai)!=="svelte-19jpj19"&&(ai.textContent=fx),p_=d(Ui),Do=s(Ui,"DIV",{class:!0});var Hf=l(Do);h(wa.$$.fragment,Hf),h_=d(Hf),ri=s(Hf,"P",{"data-svelte-h":!0}),c(ri)!=="svelte-5ihtpa"&&(ri.textContent=mx),Hf.forEach(t),Ui.forEach(t),yp=d(e),Ct=s(e,"H2",{class:!0});var Df=l(Ct);Vo=s(Df,"A",{id:!0,class:!0,href:!0});var Jb=l(Vo);sl=s(Jb,"SPAN",{});var Zb=l(sl);h($a.$$.fragment,Zb),Zb.forEach(t),Jb.forEach(t),f_=d(Df),di=s(Df,"SPAN",{"data-svelte-h":!0}),c(di)!=="svelte-xztkid"&&(di.textContent=gx),Df.forEach(t),bp=d(e),q=s(e,"DIV",{class:!0});var Xi=l(q);h(qa.$$.fragment,Xi),m_=d(Xi),ii=s(Xi,"P",{"data-svelte-h":!0}),c(ii)!=="svelte-rzpgnp"&&(ii.textContent=_x),g_=d(Xi),Io=s(Xi,"DIV",{class:!0});var Vf=l(Io);h(Oa.$$.fragment,Vf),__=d(Vf),ui=s(Vf,"P",{"data-svelte-h":!0}),c(ui)!=="svelte-5ihtpa"&&(ui.textContent=vx),Vf.forEach(t),Xi.forEach(t),wp=d(e),Ft=s(e,"H2",{class:!0});var If=l(Ft);Qo=s(If,"A",{id:!0,class:!0,href:!0});var Gb=l(Qo);al=s(Gb,"SPAN",{});var Yb=l(al);h(Sa.$$.fragment,Yb),Yb.forEach(t),Gb.forEach(t),v_=d(If),li=s(If,"SPAN",{"data-svelte-h":!0}),c(li)!=="svelte-1p3mom9"&&(li.textContent=Tx),If.forEach(t),$p=d(e),O=s(e,"DIV",{class:!0});var Ji=l(O);h(Ca.$$.fragment,Ji),T_=d(Ji),ci=s(Ji,"P",{"data-svelte-h":!0}),c(ci)!=="svelte-1kt4x95"&&(ci.textContent=xx),x_=d(Ji),Ro=s(Ji,"DIV",{class:!0});var Qf=l(Ro);h(Fa.$$.fragment,Qf),y_=d(Qf),pi=s(Qf,"P",{"data-svelte-h":!0}),c(pi)!=="svelte-5ihtpa"&&(pi.textContent=yx),Qf.forEach(t),Ji.forEach(t),qp=d(e),Mt=s(e,"H2",{class:!0});var Rf=l(Mt);Uo=s(Rf,"A",{id:!0,class:!0,href:!0});var Kb=l(Uo);rl=s(Kb,"SPAN",{});var e2=l(rl);h(Ma.$$.fragment,e2),e2.forEach(t),Kb.forEach(t),b_=d(Rf),hi=s(Rf,"SPAN",{"data-svelte-h":!0}),c(hi)!=="svelte-r88kse"&&(hi.textContent=bx),Rf.forEach(t),Op=d(e),S=s(e,"DIV",{class:!0});var Zi=l(S);h(Aa.$$.fragment,Zi),w_=d(Zi),fi=s(Zi,"P",{"data-svelte-h":!0}),c(fi)!=="svelte-k12cko"&&(fi.textContent=wx),$_=d(Zi),Xo=s(Zi,"DIV",{class:!0});var Uf=l(Xo);h(ka.$$.fragment,Uf),q_=d(Uf),mi=s(Uf,"P",{"data-svelte-h":!0}),c(mi)!=="svelte-5ihtpa"&&(mi.textContent=$x),Uf.forEach(t),Zi.forEach(t),Sp=d(e),At=s(e,"H2",{class:!0});var Xf=l(At);Jo=s(Xf,"A",{id:!0,class:!0,href:!0});var t2=l(Jo);dl=s(t2,"SPAN",{});var o2=l(dl);h(Na.$$.fragment,o2),o2.forEach(t),t2.forEach(t),O_=d(Xf),gi=s(Xf,"SPAN",{"data-svelte-h":!0}),c(gi)!=="svelte-113vny4"&&(gi.textContent=qx),Xf.forEach(t),Cp=d(e),C=s(e,"DIV",{class:!0});var Gi=l(C);h(za.$$.fragment,Gi),S_=d(Gi),_i=s(Gi,"P",{"data-svelte-h":!0}),c(_i)!=="svelte-3npkmq"&&(_i.textContent=Ox),C_=d(Gi),Zo=s(Gi,"DIV",{class:!0});var Jf=l(Zo);h(Pa.$$.fragment,Jf),F_=d(Jf),vi=s(Jf,"P",{"data-svelte-h":!0}),c(vi)!=="svelte-5ihtpa"&&(vi.textContent=Sx),Jf.forEach(t),Gi.forEach(t),Fp=d(e),kt=s(e,"H2",{class:!0});var Zf=l(kt);Go=s(Zf,"A",{id:!0,class:!0,href:!0});var n2=l(Go);il=s(n2,"SPAN",{});var s2=l(il);h(La.$$.fragment,s2),s2.forEach(t),n2.forEach(t),M_=d(Zf),Ti=s(Zf,"SPAN",{"data-svelte-h":!0}),c(Ti)!=="svelte-1t8bna5"&&(Ti.textContent=Cx),Zf.forEach(t),Mp=d(e),F=s(e,"DIV",{class:!0});var Yi=l(F);h(Ea.$$.fragment,Yi),A_=d(Yi),xi=s(Yi,"P",{"data-svelte-h":!0}),c(xi)!=="svelte-1xezu93"&&(xi.textContent=Fx),k_=d(Yi),Yo=s(Yi,"DIV",{class:!0});var Gf=l(Yo);h(Ba.$$.fragment,Gf),N_=d(Gf),yi=s(Gf,"P",{"data-svelte-h":!0}),c(yi)!=="svelte-5ihtpa"&&(yi.textContent=Mx),Gf.forEach(t),Yi.forEach(t),Ap=d(e),Nt=s(e,"H2",{class:!0});var Yf=l(Nt);Ko=s(Yf,"A",{id:!0,class:!0,href:!0});var a2=l(Ko);ul=s(a2,"SPAN",{});var r2=l(ul);h(ja.$$.fragment,r2),r2.forEach(t),a2.forEach(t),z_=d(Yf),bi=s(Yf,"SPAN",{"data-svelte-h":!0}),c(bi)!=="svelte-13djdyy"&&(bi.textContent=Ax),Yf.forEach(t),kp=d(e),M=s(e,"DIV",{class:!0});var Ki=l(M);h(Wa.$$.fragment,Ki),P_=d(Ki),wi=s(Ki,"P",{"data-svelte-h":!0}),c(wi)!=="svelte-1dobm33"&&(wi.textContent=kx),L_=d(Ki),en=s(Ki,"DIV",{class:!0});var Kf=l(en);h(Ha.$$.fragment,Kf),E_=d(Kf),$i=s(Kf,"P",{"data-svelte-h":!0}),c($i)!=="svelte-5ihtpa"&&($i.textContent=Nx),Kf.forEach(t),Ki.forEach(t),Np=d(e),zt=s(e,"H2",{class:!0});var em=l(zt);tn=s(em,"A",{id:!0,class:!0,href:!0});var d2=l(tn);ll=s(d2,"SPAN",{});var i2=l(ll);h(Da.$$.fragment,i2),i2.forEach(t),d2.forEach(t),B_=d(em),qi=s(em,"SPAN",{"data-svelte-h":!0}),c(qi)!=="svelte-187qrbb"&&(qi.textContent=zx),em.forEach(t),zp=d(e),A=s(e,"DIV",{class:!0});var eu=l(A);h(Va.$$.fragment,eu),j_=d(eu),Oi=s(eu,"P",{"data-svelte-h":!0}),c(Oi)!=="svelte-1bm2i0r"&&(Oi.textContent=Px),W_=d(eu),on=s(eu,"DIV",{class:!0});var tm=l(on);h(Ia.$$.fragment,tm),H_=d(tm),Si=s(tm,"P",{"data-svelte-h":!0}),c(Si)!=="svelte-5ihtpa"&&(Si.textContent=Lx),tm.forEach(t),eu.forEach(t),Pp=d(e),Pt=s(e,"H2",{class:!0});var om=l(Pt);nn=s(om,"A",{id:!0,class:!0,href:!0});var u2=l(nn);cl=s(u2,"SPAN",{});var l2=l(cl);h(Qa.$$.fragment,l2),l2.forEach(t),u2.forEach(t),D_=d(om),Ci=s(om,"SPAN",{"data-svelte-h":!0}),c(Ci)!=="svelte-ikidir"&&(Ci.textContent=Ex),om.forEach(t),Lp=d(e),k=s(e,"DIV",{class:!0});var tu=l(k);h(Ra.$$.fragment,tu),V_=d(tu),Fi=s(tu,"P",{"data-svelte-h":!0}),c(Fi)!=="svelte-o4u80u"&&(Fi.textContent=Bx),I_=d(tu),sn=s(tu,"DIV",{class:!0});var nm=l(sn);h(Ua.$$.fragment,nm),Q_=d(nm),Mi=s(nm,"P",{"data-svelte-h":!0}),c(Mi)!=="svelte-5ihtpa"&&(Mi.textContent=jx),nm.forEach(t),tu.forEach(t),Ep=d(e),Lt=s(e,"H2",{class:!0});var sm=l(Lt);an=s(sm,"A",{id:!0,class:!0,href:!0});var c2=l(an);pl=s(c2,"SPAN",{});var p2=l(pl);h(Xa.$$.fragment,p2),p2.forEach(t),c2.forEach(t),R_=d(sm),Ai=s(sm,"SPAN",{"data-svelte-h":!0}),c(Ai)!=="svelte-jk17ut"&&(Ai.textContent=Wx),sm.forEach(t),Bp=d(e),N=s(e,"DIV",{class:!0});var ou=l(N);h(Ja.$$.fragment,ou),U_=d(ou),ki=s(ou,"P",{"data-svelte-h":!0}),c(ki)!=="svelte-1kfw2sn"&&(ki.textContent=Hx),X_=d(ou),rn=s(ou,"DIV",{class:!0});var am=l(rn);h(Za.$$.fragment,am),J_=d(am),Ni=s(am,"P",{"data-svelte-h":!0}),c(Ni)!=="svelte-5ihtpa"&&(Ni.textContent=Dx),am.forEach(t),ou.forEach(t),jp=d(e),Et=s(e,"H2",{class:!0});var rm=l(Et);dn=s(rm,"A",{id:!0,class:!0,href:!0});var h2=l(dn);hl=s(h2,"SPAN",{});var f2=l(hl);h(Ga.$$.fragment,f2),f2.forEach(t),h2.forEach(t),Z_=d(rm),zi=s(rm,"SPAN",{"data-svelte-h":!0}),c(zi)!=="svelte-1psmz"&&(zi.textContent=Vx),rm.forEach(t),Wp=d(e),z=s(e,"DIV",{class:!0});var nu=l(z);h(Ya.$$.fragment,nu),G_=d(nu),Pi=s(nu,"P",{"data-svelte-h":!0}),c(Pi)!=="svelte-yql1ve"&&(Pi.textContent=Ix),Y_=d(nu),un=s(nu,"DIV",{class:!0});var dm=l(un);h(Ka.$$.fragment,dm),K_=d(dm),Li=s(dm,"P",{"data-svelte-h":!0}),c(Li)!=="svelte-5ihtpa"&&(Li.textContent=Qx),dm.forEach(t),nu.forEach(t),Hp=d(e),Bt=s(e,"H2",{class:!0});var im=l(Bt);ln=s(im,"A",{id:!0,class:!0,href:!0});var m2=l(ln);fl=s(m2,"SPAN",{});var g2=l(fl);h(er.$$.fragment,g2),g2.forEach(t),m2.forEach(t),ev=d(im),Ei=s(im,"SPAN",{"data-svelte-h":!0}),c(Ei)!=="svelte-1wdvsmr"&&(Ei.textContent=Rx),im.forEach(t),Dp=d(e),P=s(e,"DIV",{class:!0});var su=l(P);h(tr.$$.fragment,su),tv=d(su),Bi=s(su,"P",{"data-svelte-h":!0}),c(Bi)!=="svelte-1iv9pso"&&(Bi.textContent=Ux),ov=d(su),cn=s(su,"DIV",{class:!0});var um=l(cn);h(or.$$.fragment,um),nv=d(um),ji=s(um,"P",{"data-svelte-h":!0}),c(ji)!=="svelte-5ihtpa"&&(ji.textContent=Xx),um.forEach(t),su.forEach(t),Vp=d(e),jt=s(e,"H2",{class:!0});var lm=l(jt);pn=s(lm,"A",{id:!0,class:!0,href:!0});var _2=l(pn);ml=s(_2,"SPAN",{});var v2=l(ml);h(nr.$$.fragment,v2),v2.forEach(t),_2.forEach(t),sv=d(lm),Wi=s(lm,"SPAN",{"data-svelte-h":!0}),c(Wi)!=="svelte-1azm2fi"&&(Wi.textContent=Jx),lm.forEach(t),Ip=d(e),L=s(e,"DIV",{class:!0});var au=l(L);h(sr.$$.fragment,au),av=d(au),Hi=s(au,"P",{"data-svelte-h":!0}),c(Hi)!=="svelte-w7415f"&&(Hi.textContent=Zx),rv=d(au),hn=s(au,"DIV",{class:!0});var cm=l(hn);h(ar.$$.fragment,cm),dv=d(cm),Di=s(cm,"P",{"data-svelte-h":!0}),c(Di)!=="svelte-5ihtpa"&&(Di.textContent=Gx),cm.forEach(t),au.forEach(t),Qp=d(e),Wt=s(e,"H2",{class:!0});var pm=l(Wt);fn=s(pm,"A",{id:!0,class:!0,href:!0});var T2=l(fn);gl=s(T2,"SPAN",{});var x2=l(gl);h(rr.$$.fragment,x2),x2.forEach(t),T2.forEach(t),iv=d(pm),Vi=s(pm,"SPAN",{"data-svelte-h":!0}),c(Vi)!=="svelte-1ydnevy"&&(Vi.textContent=Yx),pm.forEach(t),Rp=d(e),E=s(e,"DIV",{class:!0});var ru=l(E);h(dr.$$.fragment,ru),uv=d(ru),Ii=s(ru,"P",{"data-svelte-h":!0}),c(Ii)!=="svelte-dhzux4"&&(Ii.textContent=Kx),lv=d(ru),mn=s(ru,"DIV",{class:!0});var hm=l(mn);h(ir.$$.fragment,hm),cv=d(hm),Qi=s(hm,"P",{"data-svelte-h":!0}),c(Qi)!=="svelte-5ihtpa"&&(Qi.textContent=ey),hm.forEach(t),ru.forEach(t),Up=d(e),_l=s(e,"P",{}),l(_l).forEach(t),this.h()},h(){a(x,"name","hf:doc:metadata"),a(x,"content",JSON.stringify(A2)),a(Ht,"id","model-outputs"),a(Ht,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Ht,"href","#model-outputs"),a(B,"class","relative group"),a(Dt,"id","transformers.utils.ModelOutput"),a(Dt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Dt,"href","#transformers.utils.ModelOutput"),a(j,"class","relative group"),a(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Qt,"id","transformers.modeling_outputs.BaseModelOutput"),a(Qt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Qt,"href","#transformers.modeling_outputs.BaseModelOutput"),a(W,"class","relative group"),a(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Rt,"id","transformers.modeling_outputs.BaseModelOutputWithPooling"),a(Rt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Rt,"href","#transformers.modeling_outputs.BaseModelOutputWithPooling"),a(D,"class","relative group"),a(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Ut,"id","transformers.modeling_outputs.BaseModelOutputWithCrossAttentions"),a(Ut,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Ut,"href","#transformers.modeling_outputs.BaseModelOutputWithCrossAttentions"),a(I,"class","relative group"),a(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Xt,"id","transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"),a(Xt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Xt,"href","#transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions"),a(R,"class","relative group"),a(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Jt,"id","transformers.modeling_outputs.BaseModelOutputWithPast"),a(Jt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Jt,"href","#transformers.modeling_outputs.BaseModelOutputWithPast"),a(X,"class","relative group"),a(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Zt,"id","transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"),a(Zt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Zt,"href","#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"),a(Z,"class","relative group"),a(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Gt,"id","transformers.modeling_outputs.Seq2SeqModelOutput"),a(Gt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Gt,"href","#transformers.modeling_outputs.Seq2SeqModelOutput"),a(Y,"class","relative group"),a(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Yt,"id","transformers.modeling_outputs.CausalLMOutput"),a(Yt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Yt,"href","#transformers.modeling_outputs.CausalLMOutput"),a(ee,"class","relative group"),a(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Kt,"id","transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"),a(Kt,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Kt,"href","#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"),a(oe,"class","relative group"),a(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(eo,"id","transformers.modeling_outputs.CausalLMOutputWithPast"),a(eo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(eo,"href","#transformers.modeling_outputs.CausalLMOutputWithPast"),a(se,"class","relative group"),a(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(to,"id","transformers.modeling_outputs.MaskedLMOutput"),a(to,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(to,"href","#transformers.modeling_outputs.MaskedLMOutput"),a(re,"class","relative group"),a(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(oo,"id","transformers.modeling_outputs.Seq2SeqLMOutput"),a(oo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(oo,"href","#transformers.modeling_outputs.Seq2SeqLMOutput"),a(ie,"class","relative group"),a(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(no,"id","transformers.modeling_outputs.NextSentencePredictorOutput"),a(no,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(no,"href","#transformers.modeling_outputs.NextSentencePredictorOutput"),a(le,"class","relative group"),a(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(so,"id","transformers.modeling_outputs.SequenceClassifierOutput"),a(so,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(so,"href","#transformers.modeling_outputs.SequenceClassifierOutput"),a(pe,"class","relative group"),a(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(ao,"id","transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"),a(ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(ao,"href","#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"),a(fe,"class","relative group"),a(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(ro,"id","transformers.modeling_outputs.MultipleChoiceModelOutput"),a(ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(ro,"href","#transformers.modeling_outputs.MultipleChoiceModelOutput"),a(ge,"class","relative group"),a(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(io,"id","transformers.modeling_outputs.TokenClassifierOutput"),a(io,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(io,"href","#transformers.modeling_outputs.TokenClassifierOutput"),a(ve,"class","relative group"),a(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(uo,"id","transformers.modeling_outputs.QuestionAnsweringModelOutput"),a(uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(uo,"href","#transformers.modeling_outputs.QuestionAnsweringModelOutput"),a(xe,"class","relative group"),a(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(lo,"id","transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"),a(lo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(lo,"href","#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"),a(be,"class","relative group"),a(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(co,"id","transformers.modeling_outputs.Seq2SeqSpectrogramOutput"),a(co,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(co,"href","#transformers.modeling_outputs.Seq2SeqSpectrogramOutput"),a($e,"class","relative group"),a(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(po,"id","transformers.modeling_outputs.SemanticSegmenterOutput"),a(po,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(po,"href","#transformers.modeling_outputs.SemanticSegmenterOutput"),a(Oe,"class","relative group"),a(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(ho,"id","transformers.modeling_outputs.ImageClassifierOutput"),a(ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(ho,"href","#transformers.modeling_outputs.ImageClassifierOutput"),a(Ce,"class","relative group"),a(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(fo,"id","transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"),a(fo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(fo,"href","#transformers.modeling_outputs.ImageClassifierOutputWithNoAttention"),a(Me,"class","relative group"),a(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(mo,"id","transformers.modeling_outputs.DepthEstimatorOutput"),a(mo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(mo,"href","#transformers.modeling_outputs.DepthEstimatorOutput"),a(ke,"class","relative group"),a(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(go,"id","transformers.modeling_outputs.Wav2Vec2BaseModelOutput"),a(go,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(go,"href","#transformers.modeling_outputs.Wav2Vec2BaseModelOutput"),a(ze,"class","relative group"),a(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(_o,"id","transformers.modeling_outputs.XVectorOutput"),a(_o,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(_o,"href","#transformers.modeling_outputs.XVectorOutput"),a(Le,"class","relative group"),a(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(vo,"id","transformers.modeling_outputs.Seq2SeqTSModelOutput"),a(vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(vo,"href","#transformers.modeling_outputs.Seq2SeqTSModelOutput"),a(Be,"class","relative group"),a(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(To,"id","transformers.modeling_outputs.Seq2SeqTSPredictionOutput"),a(To,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(To,"href","#transformers.modeling_outputs.Seq2SeqTSPredictionOutput"),a(We,"class","relative group"),a(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(xo,"id","transformers.modeling_outputs.SampleTSPredictionOutput"),a(xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(xo,"href","#transformers.modeling_outputs.SampleTSPredictionOutput"),a(De,"class","relative group"),a(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(yo,"id","transformers.modeling_tf_outputs.TFBaseModelOutput"),a(yo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(yo,"href","#transformers.modeling_tf_outputs.TFBaseModelOutput"),a(Ie,"class","relative group"),a(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(bo,"id","transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"),a(bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(bo,"href","#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"),a(Re,"class","relative group"),a(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(wo,"id","transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions"),a(wo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(wo,"href","#transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions"),a(Xe,"class","relative group"),a(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a($o,"id","transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"),a($o,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a($o,"href","#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"),a(Ze,"class","relative group"),a(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(qo,"id","transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions"),a(qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(qo,"href","#transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions"),a(Ye,"class","relative group"),a(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Oo,"id","transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"),a(Oo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Oo,"href","#transformers.modeling_tf_outputs.TFSeq2SeqModelOutput"),a(et,"class","relative group"),a(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(So,"id","transformers.modeling_tf_outputs.TFCausalLMOutput"),a(So,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(So,"href","#transformers.modeling_tf_outputs.TFCausalLMOutput"),a(ot,"class","relative group"),a(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Co,"id","transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions"),a(Co,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Co,"href","#transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions"),a(st,"class","relative group"),a(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Fo,"id","transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"),a(Fo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Fo,"href","#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"),a(rt,"class","relative group"),a(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Mo,"id","transformers.modeling_tf_outputs.TFMaskedLMOutput"),a(Mo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Mo,"href","#transformers.modeling_tf_outputs.TFMaskedLMOutput"),a(it,"class","relative group"),a(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Ao,"id","transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"),a(Ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Ao,"href","#transformers.modeling_tf_outputs.TFSeq2SeqLMOutput"),a(lt,"class","relative group"),a(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(ko,"id","transformers.modeling_tf_outputs.TFNextSentencePredictorOutput"),a(ko,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(ko,"href","#transformers.modeling_tf_outputs.TFNextSentencePredictorOutput"),a(pt,"class","relative group"),a(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(No,"id","transformers.modeling_tf_outputs.TFSequenceClassifierOutput"),a(No,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(No,"href","#transformers.modeling_tf_outputs.TFSequenceClassifierOutput"),a(ft,"class","relative group"),a(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(zo,"id","transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput"),a(zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(zo,"href","#transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput"),a(gt,"class","relative group"),a(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Po,"id","transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput"),a(Po,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Po,"href","#transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput"),a(vt,"class","relative group"),a(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Lo,"id","transformers.modeling_tf_outputs.TFTokenClassifierOutput"),a(Lo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Lo,"href","#transformers.modeling_tf_outputs.TFTokenClassifierOutput"),a(xt,"class","relative group"),a(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Eo,"id","transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput"),a(Eo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Eo,"href","#transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput"),a(bt,"class","relative group"),a(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Bo,"id","transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput"),a(Bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Bo,"href","#transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput"),a($t,"class","relative group"),a(qt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(jo,"id","transformers.modeling_flax_outputs.FlaxBaseModelOutput"),a(jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(jo,"href","#transformers.modeling_flax_outputs.FlaxBaseModelOutput"),a(Ot,"class","relative group"),a(Wo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Ho,"id","transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast"),a(Ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Ho,"href","#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast"),a(St,"class","relative group"),a(Do,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Vo,"id","transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"),a(Vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Vo,"href","#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling"),a(Ct,"class","relative group"),a(Io,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Qo,"id","transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions"),a(Qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Qo,"href","#transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions"),a(Ft,"class","relative group"),a(Ro,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Uo,"id","transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput"),a(Uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Uo,"href","#transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput"),a(Mt,"class","relative group"),a(Xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Jo,"id","transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions"),a(Jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Jo,"href","#transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions"),a(At,"class","relative group"),a(Zo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Go,"id","transformers.modeling_flax_outputs.FlaxMaskedLMOutput"),a(Go,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Go,"href","#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"),a(kt,"class","relative group"),a(Yo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(Ko,"id","transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"),a(Ko,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(Ko,"href","#transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput"),a(Nt,"class","relative group"),a(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(tn,"id","transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput"),a(tn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(tn,"href","#transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput"),a(zt,"class","relative group"),a(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(nn,"id","transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"),a(nn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(nn,"href","#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"),a(Pt,"class","relative group"),a(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(an,"id","transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput"),a(an,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(an,"href","#transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput"),a(Lt,"class","relative group"),a(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(dn,"id","transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput"),a(dn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(dn,"href","#transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput"),a(Et,"class","relative group"),a(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(ln,"id","transformers.modeling_flax_outputs.FlaxTokenClassifierOutput"),a(ln,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(ln,"href","#transformers.modeling_flax_outputs.FlaxTokenClassifierOutput"),a(Bt,"class","relative group"),a(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(pn,"id","transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput"),a(pn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(pn,"href","#transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput"),a(jt,"class","relative group"),a(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(fn,"id","transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput"),a(fn,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),a(fn,"href","#transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput"),a(Wt,"class","relative group"),a(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),a(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,x),u(e,_n,i),u(e,b,i),u(e,lr,i),u(e,B,i),o(B,Ht),o(Ht,du),f(vn,du,null),o(B,fm),o(B,cr),u(e,Tl,i),u(e,Tn,i),u(e,xl,i),u(e,xn,i),u(e,yl,i),f(yn,e,i),u(e,bl,i),u(e,bn,i),u(e,wl,i),u(e,wn,i),u(e,$l,i),u(e,$n,i),u(e,ql,i),f(qn,e,i),u(e,Ol,i),u(e,On,i),u(e,Sl,i),u(e,Sn,i),u(e,Cl,i),u(e,Cn,i),u(e,Fl,i),u(e,j,i),o(j,Dt),o(Dt,iu),f(Fn,iu,null),o(j,mm),o(j,pr),u(e,Ml,i),u(e,y,i),f(Mn,y,null),o(y,gm),o(y,hr),o(y,_m),f(Vt,y,null),o(y,vm),o(y,It),f(An,It,null),o(It,Tm),o(It,fr),u(e,Al,i),u(e,W,i),o(W,Qt),o(Qt,uu),f(kn,uu,null),o(W,xm),o(W,mr),u(e,kl,i),u(e,H,i),f(Nn,H,null),o(H,ym),o(H,gr),u(e,Nl,i),u(e,D,i),o(D,Rt),o(Rt,lu),f(zn,lu,null),o(D,bm),o(D,_r),u(e,zl,i),u(e,V,i),f(Pn,V,null),o(V,wm),o(V,vr),u(e,Pl,i),u(e,I,i),o(I,Ut),o(Ut,cu),f(Ln,cu,null),o(I,$m),o(I,Tr),u(e,Ll,i),u(e,Q,i),f(En,Q,null),o(Q,qm),o(Q,xr),u(e,El,i),u(e,R,i),o(R,Xt),o(Xt,pu),f(Bn,pu,null),o(R,Om),o(R,yr),u(e,Bl,i),u(e,U,i),f(jn,U,null),o(U,Sm),o(U,br),u(e,jl,i),u(e,X,i),o(X,Jt),o(Jt,hu),f(Wn,hu,null),o(X,Cm),o(X,wr),u(e,Wl,i),u(e,J,i),f(Hn,J,null),o(J,Fm),o(J,$r),u(e,Hl,i),u(e,Z,i),o(Z,Zt),o(Zt,fu),f(Dn,fu,null),o(Z,Mm),o(Z,qr),u(e,Dl,i),u(e,G,i),f(Vn,G,null),o(G,Am),o(G,Or),u(e,Vl,i),u(e,Y,i),o(Y,Gt),o(Gt,mu),f(In,mu,null),o(Y,km),o(Y,Sr),u(e,Il,i),u(e,K,i),f(Qn,K,null),o(K,Nm),o(K,Cr),u(e,Ql,i),u(e,ee,i),o(ee,Yt),o(Yt,gu),f(Rn,gu,null),o(ee,zm),o(ee,Fr),u(e,Rl,i),u(e,te,i),f(Un,te,null),o(te,Pm),o(te,Mr),u(e,Ul,i),u(e,oe,i),o(oe,Kt),o(Kt,_u),f(Xn,_u,null),o(oe,Lm),o(oe,Ar),u(e,Xl,i),u(e,ne,i),f(Jn,ne,null),o(ne,Em),o(ne,kr),u(e,Jl,i),u(e,se,i),o(se,eo),o(eo,vu),f(Zn,vu,null),o(se,Bm),o(se,Nr),u(e,Zl,i),u(e,ae,i),f(Gn,ae,null),o(ae,jm),o(ae,zr),u(e,Gl,i),u(e,re,i),o(re,to),o(to,Tu),f(Yn,Tu,null),o(re,Wm),o(re,Pr),u(e,Yl,i),u(e,de,i),f(Kn,de,null),o(de,Hm),o(de,Lr),u(e,Kl,i),u(e,ie,i),o(ie,oo),o(oo,xu),f(es,xu,null),o(ie,Dm),o(ie,Er),u(e,ec,i),u(e,ue,i),f(ts,ue,null),o(ue,Vm),o(ue,Br),u(e,tc,i),u(e,le,i),o(le,no),o(no,yu),f(os,yu,null),o(le,Im),o(le,jr),u(e,oc,i),u(e,ce,i),f(ns,ce,null),o(ce,Qm),o(ce,Wr),u(e,nc,i),u(e,pe,i),o(pe,so),o(so,bu),f(ss,bu,null),o(pe,Rm),o(pe,Hr),u(e,sc,i),u(e,he,i),f(as,he,null),o(he,Um),o(he,Dr),u(e,ac,i),u(e,fe,i),o(fe,ao),o(ao,wu),f(rs,wu,null),o(fe,Xm),o(fe,Vr),u(e,rc,i),u(e,me,i),f(ds,me,null),o(me,Jm),o(me,Ir),u(e,dc,i),u(e,ge,i),o(ge,ro),o(ro,$u),f(is,$u,null),o(ge,Zm),o(ge,Qr),u(e,ic,i),u(e,_e,i),f(us,_e,null),o(_e,Gm),o(_e,Rr),u(e,uc,i),u(e,ve,i),o(ve,io),o(io,qu),f(ls,qu,null),o(ve,Ym),o(ve,Ur),u(e,lc,i),u(e,Te,i),f(cs,Te,null),o(Te,Km),o(Te,Xr),u(e,cc,i),u(e,xe,i),o(xe,uo),o(uo,Ou),f(ps,Ou,null),o(xe,eg),o(xe,Jr),u(e,pc,i),u(e,ye,i),f(hs,ye,null),o(ye,tg),o(ye,Zr),u(e,hc,i),u(e,be,i),o(be,lo),o(lo,Su),f(fs,Su,null),o(be,og),o(be,Gr),u(e,fc,i),u(e,we,i),f(ms,we,null),o(we,ng),o(we,Yr),u(e,mc,i),u(e,$e,i),o($e,co),o(co,Cu),f(gs,Cu,null),o($e,sg),o($e,Kr),u(e,gc,i),u(e,qe,i),f(_s,qe,null),o(qe,ag),o(qe,ed),u(e,_c,i),u(e,Oe,i),o(Oe,po),o(po,Fu),f(vs,Fu,null),o(Oe,rg),o(Oe,td),u(e,vc,i),u(e,Se,i),f(Ts,Se,null),o(Se,dg),o(Se,od),u(e,Tc,i),u(e,Ce,i),o(Ce,ho),o(ho,Mu),f(xs,Mu,null),o(Ce,ig),o(Ce,nd),u(e,xc,i),u(e,Fe,i),f(ys,Fe,null),o(Fe,ug),o(Fe,sd),u(e,yc,i),u(e,Me,i),o(Me,fo),o(fo,Au),f(bs,Au,null),o(Me,lg),o(Me,ad),u(e,bc,i),u(e,Ae,i),f(ws,Ae,null),o(Ae,cg),o(Ae,rd),u(e,wc,i),u(e,ke,i),o(ke,mo),o(mo,ku),f($s,ku,null),o(ke,pg),o(ke,dd),u(e,$c,i),u(e,Ne,i),f(qs,Ne,null),o(Ne,hg),o(Ne,id),u(e,qc,i),u(e,ze,i),o(ze,go),o(go,Nu),f(Os,Nu,null),o(ze,fg),o(ze,ud),u(e,Oc,i),u(e,Pe,i),f(Ss,Pe,null),o(Pe,mg),o(Pe,ld),u(e,Sc,i),u(e,Le,i),o(Le,_o),o(_o,zu),f(Cs,zu,null),o(Le,gg),o(Le,cd),u(e,Cc,i),u(e,Ee,i),f(Fs,Ee,null),o(Ee,_g),o(Ee,pd),u(e,Fc,i),u(e,Be,i),o(Be,vo),o(vo,Pu),f(Ms,Pu,null),o(Be,vg),o(Be,hd),u(e,Mc,i),u(e,je,i),f(As,je,null),o(je,Tg),o(je,fd),u(e,Ac,i),u(e,We,i),o(We,To),o(To,Lu),f(ks,Lu,null),o(We,xg),o(We,md),u(e,kc,i),u(e,He,i),f(Ns,He,null),o(He,yg),o(He,gd),u(e,Nc,i),u(e,De,i),o(De,xo),o(xo,Eu),f(zs,Eu,null),o(De,bg),o(De,_d),u(e,zc,i),u(e,Ve,i),f(Ps,Ve,null),o(Ve,wg),o(Ve,vd),u(e,Pc,i),u(e,Ie,i),o(Ie,yo),o(yo,Bu),f(Ls,Bu,null),o(Ie,$g),o(Ie,Td),u(e,Lc,i),u(e,Qe,i),f(Es,Qe,null),o(Qe,qg),o(Qe,xd),u(e,Ec,i),u(e,Re,i),o(Re,bo),o(bo,ju),f(Bs,ju,null),o(Re,Og),o(Re,yd),u(e,Bc,i),u(e,Ue,i),f(js,Ue,null),o(Ue,Sg),o(Ue,bd),u(e,jc,i),u(e,Xe,i),o(Xe,wo),o(wo,Wu),f(Ws,Wu,null),o(Xe,Cg),o(Xe,wd),u(e,Wc,i),u(e,Je,i),f(Hs,Je,null),o(Je,Fg),o(Je,$d),u(e,Hc,i),u(e,Ze,i),o(Ze,$o),o($o,Hu),f(Ds,Hu,null),o(Ze,Mg),o(Ze,qd),u(e,Dc,i),u(e,Ge,i),f(Vs,Ge,null),o(Ge,Ag),o(Ge,Od),u(e,Vc,i),u(e,Ye,i),o(Ye,qo),o(qo,Du),f(Is,Du,null),o(Ye,kg),o(Ye,Sd),u(e,Ic,i),u(e,Ke,i),f(Qs,Ke,null),o(Ke,Ng),o(Ke,Cd),u(e,Qc,i),u(e,et,i),o(et,Oo),o(Oo,Vu),f(Rs,Vu,null),o(et,zg),o(et,Fd),u(e,Rc,i),u(e,tt,i),f(Us,tt,null),o(tt,Pg),o(tt,Md),u(e,Uc,i),u(e,ot,i),o(ot,So),o(So,Iu),f(Xs,Iu,null),o(ot,Lg),o(ot,Ad),u(e,Xc,i),u(e,nt,i),f(Js,nt,null),o(nt,Eg),o(nt,kd),u(e,Jc,i),u(e,st,i),o(st,Co),o(Co,Qu),f(Zs,Qu,null),o(st,Bg),o(st,Nd),u(e,Zc,i),u(e,at,i),f(Gs,at,null),o(at,jg),o(at,zd),u(e,Gc,i),u(e,rt,i),o(rt,Fo),o(Fo,Ru),f(Ys,Ru,null),o(rt,Wg),o(rt,Pd),u(e,Yc,i),u(e,dt,i),f(Ks,dt,null),o(dt,Hg),o(dt,Ld),u(e,Kc,i),u(e,it,i),o(it,Mo),o(Mo,Uu),f(ea,Uu,null),o(it,Dg),o(it,Ed),u(e,ep,i),u(e,ut,i),f(ta,ut,null),o(ut,Vg),o(ut,Bd),u(e,tp,i),u(e,lt,i),o(lt,Ao),o(Ao,Xu),f(oa,Xu,null),o(lt,Ig),o(lt,jd),u(e,op,i),u(e,ct,i),f(na,ct,null),o(ct,Qg),o(ct,Wd),u(e,np,i),u(e,pt,i),o(pt,ko),o(ko,Ju),f(sa,Ju,null),o(pt,Rg),o(pt,Hd),u(e,sp,i),u(e,ht,i),f(aa,ht,null),o(ht,Ug),o(ht,Dd),u(e,ap,i),u(e,ft,i),o(ft,No),o(No,Zu),f(ra,Zu,null),o(ft,Xg),o(ft,Vd),u(e,rp,i),u(e,mt,i),f(da,mt,null),o(mt,Jg),o(mt,Id),u(e,dp,i),u(e,gt,i),o(gt,zo),o(zo,Gu),f(ia,Gu,null),o(gt,Zg),o(gt,Qd),u(e,ip,i),u(e,_t,i),f(ua,_t,null),o(_t,Gg),o(_t,Rd),u(e,up,i),u(e,vt,i),o(vt,Po),o(Po,Yu),f(la,Yu,null),o(vt,Yg),o(vt,Ud),u(e,lp,i),u(e,Tt,i),f(ca,Tt,null),o(Tt,Kg),o(Tt,Xd),u(e,cp,i),u(e,xt,i),o(xt,Lo),o(Lo,Ku),f(pa,Ku,null),o(xt,e_),o(xt,Jd),u(e,pp,i),u(e,yt,i),f(ha,yt,null),o(yt,t_),o(yt,Zd),u(e,hp,i),u(e,bt,i),o(bt,Eo),o(Eo,el),f(fa,el,null),o(bt,o_),o(bt,Gd),u(e,fp,i),u(e,wt,i),f(ma,wt,null),o(wt,n_),o(wt,Yd),u(e,mp,i),u(e,$t,i),o($t,Bo),o(Bo,tl),f(ga,tl,null),o($t,s_),o($t,Kd),u(e,gp,i),u(e,qt,i),f(_a,qt,null),o(qt,a_),o(qt,ei),u(e,_p,i),u(e,Ot,i),o(Ot,jo),o(jo,ol),f(va,ol,null),o(Ot,r_),o(Ot,ti),u(e,vp,i),u(e,w,i),f(Ta,w,null),o(w,d_),o(w,oi),o(w,i_),o(w,Wo),f(xa,Wo,null),o(Wo,u_),o(Wo,ni),u(e,Tp,i),u(e,St,i),o(St,Ho),o(Ho,nl),f(ya,nl,null),o(St,l_),o(St,si),u(e,xp,i),u(e,$,i),f(ba,$,null),o($,c_),o($,ai),o($,p_),o($,Do),f(wa,Do,null),o(Do,h_),o(Do,ri),u(e,yp,i),u(e,Ct,i),o(Ct,Vo),o(Vo,sl),f($a,sl,null),o(Ct,f_),o(Ct,di),u(e,bp,i),u(e,q,i),f(qa,q,null),o(q,m_),o(q,ii),o(q,g_),o(q,Io),f(Oa,Io,null),o(Io,__),o(Io,ui),u(e,wp,i),u(e,Ft,i),o(Ft,Qo),o(Qo,al),f(Sa,al,null),o(Ft,v_),o(Ft,li),u(e,$p,i),u(e,O,i),f(Ca,O,null),o(O,T_),o(O,ci),o(O,x_),o(O,Ro),f(Fa,Ro,null),o(Ro,y_),o(Ro,pi),u(e,qp,i),u(e,Mt,i),o(Mt,Uo),o(Uo,rl),f(Ma,rl,null),o(Mt,b_),o(Mt,hi),u(e,Op,i),u(e,S,i),f(Aa,S,null),o(S,w_),o(S,fi),o(S,$_),o(S,Xo),f(ka,Xo,null),o(Xo,q_),o(Xo,mi),u(e,Sp,i),u(e,At,i),o(At,Jo),o(Jo,dl),f(Na,dl,null),o(At,O_),o(At,gi),u(e,Cp,i),u(e,C,i),f(za,C,null),o(C,S_),o(C,_i),o(C,C_),o(C,Zo),f(Pa,Zo,null),o(Zo,F_),o(Zo,vi),u(e,Fp,i),u(e,kt,i),o(kt,Go),o(Go,il),f(La,il,null),o(kt,M_),o(kt,Ti),u(e,Mp,i),u(e,F,i),f(Ea,F,null),o(F,A_),o(F,xi),o(F,k_),o(F,Yo),f(Ba,Yo,null),o(Yo,N_),o(Yo,yi),u(e,Ap,i),u(e,Nt,i),o(Nt,Ko),o(Ko,ul),f(ja,ul,null),o(Nt,z_),o(Nt,bi),u(e,kp,i),u(e,M,i),f(Wa,M,null),o(M,P_),o(M,wi),o(M,L_),o(M,en),f(Ha,en,null),o(en,E_),o(en,$i),u(e,Np,i),u(e,zt,i),o(zt,tn),o(tn,ll),f(Da,ll,null),o(zt,B_),o(zt,qi),u(e,zp,i),u(e,A,i),f(Va,A,null),o(A,j_),o(A,Oi),o(A,W_),o(A,on),f(Ia,on,null),o(on,H_),o(on,Si),u(e,Pp,i),u(e,Pt,i),o(Pt,nn),o(nn,cl),f(Qa,cl,null),o(Pt,D_),o(Pt,Ci),u(e,Lp,i),u(e,k,i),f(Ra,k,null),o(k,V_),o(k,Fi),o(k,I_),o(k,sn),f(Ua,sn,null),o(sn,Q_),o(sn,Mi),u(e,Ep,i),u(e,Lt,i),o(Lt,an),o(an,pl),f(Xa,pl,null),o(Lt,R_),o(Lt,Ai),u(e,Bp,i),u(e,N,i),f(Ja,N,null),o(N,U_),o(N,ki),o(N,X_),o(N,rn),f(Za,rn,null),o(rn,J_),o(rn,Ni),u(e,jp,i),u(e,Et,i),o(Et,dn),o(dn,hl),f(Ga,hl,null),o(Et,Z_),o(Et,zi),u(e,Wp,i),u(e,z,i),f(Ya,z,null),o(z,G_),o(z,Pi),o(z,Y_),o(z,un),f(Ka,un,null),o(un,K_),o(un,Li),u(e,Hp,i),u(e,Bt,i),o(Bt,ln),o(ln,fl),f(er,fl,null),o(Bt,ev),o(Bt,Ei),u(e,Dp,i),u(e,P,i),f(tr,P,null),o(P,tv),o(P,Bi),o(P,ov),o(P,cn),f(or,cn,null),o(cn,nv),o(cn,ji),u(e,Vp,i),u(e,jt,i),o(jt,pn),o(pn,ml),f(nr,ml,null),o(jt,sv),o(jt,Wi),u(e,Ip,i),u(e,L,i),f(sr,L,null),o(L,av),o(L,Hi),o(L,rv),o(L,hn),f(ar,hn,null),o(hn,dv),o(hn,Di),u(e,Qp,i),u(e,Wt,i),o(Wt,fn),o(fn,gl),f(rr,gl,null),o(Wt,iv),o(Wt,Vi),u(e,Rp,i),u(e,E,i),f(dr,E,null),o(E,uv),o(E,Ii),o(E,lv),o(E,mn),f(ir,mn,null),o(mn,cv),o(mn,Qi),u(e,Up,i),u(e,_l,i),Xp=!0},p(e,[i]){const ur={};i&2&&(ur.$$scope={dirty:i,ctx:e}),Vt.$set(ur)},i(e){Xp||(m(vn.$$.fragment,e),m(yn.$$.fragment,e),m(qn.$$.fragment,e),m(Fn.$$.fragment,e),m(Mn.$$.fragment,e),m(Vt.$$.fragment,e),m(An.$$.fragment,e),m(kn.$$.fragment,e),m(Nn.$$.fragment,e),m(zn.$$.fragment,e),m(Pn.$$.fragment,e),m(Ln.$$.fragment,e),m(En.$$.fragment,e),m(Bn.$$.fragment,e),m(jn.$$.fragment,e),m(Wn.$$.fragment,e),m(Hn.$$.fragment,e),m(Dn.$$.fragment,e),m(Vn.$$.fragment,e),m(In.$$.fragment,e),m(Qn.$$.fragment,e),m(Rn.$$.fragment,e),m(Un.$$.fragment,e),m(Xn.$$.fragment,e),m(Jn.$$.fragment,e),m(Zn.$$.fragment,e),m(Gn.$$.fragment,e),m(Yn.$$.fragment,e),m(Kn.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(os.$$.fragment,e),m(ns.$$.fragment,e),m(ss.$$.fragment,e),m(as.$$.fragment,e),m(rs.$$.fragment,e),m(ds.$$.fragment,e),m(is.$$.fragment,e),m(us.$$.fragment,e),m(ls.$$.fragment,e),m(cs.$$.fragment,e),m(ps.$$.fragment,e),m(hs.$$.fragment,e),m(fs.$$.fragment,e),m(ms.$$.fragment,e),m(gs.$$.fragment,e),m(_s.$$.fragment,e),m(vs.$$.fragment,e),m(Ts.$$.fragment,e),m(xs.$$.fragment,e),m(ys.$$.fragment,e),m(bs.$$.fragment,e),m(ws.$$.fragment,e),m($s.$$.fragment,e),m(qs.$$.fragment,e),m(Os.$$.fragment,e),m(Ss.$$.fragment,e),m(Cs.$$.fragment,e),m(Fs.$$.fragment,e),m(Ms.$$.fragment,e),m(As.$$.fragment,e),m(ks.$$.fragment,e),m(Ns.$$.fragment,e),m(zs.$$.fragment,e),m(Ps.$$.fragment,e),m(Ls.$$.fragment,e),m(Es.$$.fragment,e),m(Bs.$$.fragment,e),m(js.$$.fragment,e),m(Ws.$$.fragment,e),m(Hs.$$.fragment,e),m(Ds.$$.fragment,e),m(Vs.$$.fragment,e),m(Is.$$.fragment,e),m(Qs.$$.fragment,e),m(Rs.$$.fragment,e),m(Us.$$.fragment,e),m(Xs.$$.fragment,e),m(Js.$$.fragment,e),m(Zs.$$.fragment,e),m(Gs.$$.fragment,e),m(Ys.$$.fragment,e),m(Ks.$$.fragment,e),m(ea.$$.fragment,e),m(ta.$$.fragment,e),m(oa.$$.fragment,e),m(na.$$.fragment,e),m(sa.$$.fragment,e),m(aa.$$.fragment,e),m(ra.$$.fragment,e),m(da.$$.fragment,e),m(ia.$$.fragment,e),m(ua.$$.fragment,e),m(la.$$.fragment,e),m(ca.$$.fragment,e),m(pa.$$.fragment,e),m(ha.$$.fragment,e),m(fa.$$.fragment,e),m(ma.$$.fragment,e),m(ga.$$.fragment,e),m(_a.$$.fragment,e),m(va.$$.fragment,e),m(Ta.$$.fragment,e),m(xa.$$.fragment,e),m(ya.$$.fragment,e),m(ba.$$.fragment,e),m(wa.$$.fragment,e),m($a.$$.fragment,e),m(qa.$$.fragment,e),m(Oa.$$.fragment,e),m(Sa.$$.fragment,e),m(Ca.$$.fragment,e),m(Fa.$$.fragment,e),m(Ma.$$.fragment,e),m(Aa.$$.fragment,e),m(ka.$$.fragment,e),m(Na.$$.fragment,e),m(za.$$.fragment,e),m(Pa.$$.fragment,e),m(La.$$.fragment,e),m(Ea.$$.fragment,e),m(Ba.$$.fragment,e),m(ja.$$.fragment,e),m(Wa.$$.fragment,e),m(Ha.$$.fragment,e),m(Da.$$.fragment,e),m(Va.$$.fragment,e),m(Ia.$$.fragment,e),m(Qa.$$.fragment,e),m(Ra.$$.fragment,e),m(Ua.$$.fragment,e),m(Xa.$$.fragment,e),m(Ja.$$.fragment,e),m(Za.$$.fragment,e),m(Ga.$$.fragment,e),m(Ya.$$.fragment,e),m(Ka.$$.fragment,e),m(er.$$.fragment,e),m(tr.$$.fragment,e),m(or.$$.fragment,e),m(nr.$$.fragment,e),m(sr.$$.fragment,e),m(ar.$$.fragment,e),m(rr.$$.fragment,e),m(dr.$$.fragment,e),m(ir.$$.fragment,e),Xp=!0)},o(e){g(vn.$$.fragment,e),g(yn.$$.fragment,e),g(qn.$$.fragment,e),g(Fn.$$.fragment,e),g(Mn.$$.fragment,e),g(Vt.$$.fragment,e),g(An.$$.fragment,e),g(kn.$$.fragment,e),g(Nn.$$.fragment,e),g(zn.$$.fragment,e),g(Pn.$$.fragment,e),g(Ln.$$.fragment,e),g(En.$$.fragment,e),g(Bn.$$.fragment,e),g(jn.$$.fragment,e),g(Wn.$$.fragment,e),g(Hn.$$.fragment,e),g(Dn.$$.fragment,e),g(Vn.$$.fragment,e),g(In.$$.fragment,e),g(Qn.$$.fragment,e),g(Rn.$$.fragment,e),g(Un.$$.fragment,e),g(Xn.$$.fragment,e),g(Jn.$$.fragment,e),g(Zn.$$.fragment,e),g(Gn.$$.fragment,e),g(Yn.$$.fragment,e),g(Kn.$$.fragment,e),g(es.$$.fragment,e),g(ts.$$.fragment,e),g(os.$$.fragment,e),g(ns.$$.fragment,e),g(ss.$$.fragment,e),g(as.$$.fragment,e),g(rs.$$.fragment,e),g(ds.$$.fragment,e),g(is.$$.fragment,e),g(us.$$.fragment,e),g(ls.$$.fragment,e),g(cs.$$.fragment,e),g(ps.$$.fragment,e),g(hs.$$.fragment,e),g(fs.$$.fragment,e),g(ms.$$.fragment,e),g(gs.$$.fragment,e),g(_s.$$.fragment,e),g(vs.$$.fragment,e),g(Ts.$$.fragment,e),g(xs.$$.fragment,e),g(ys.$$.fragment,e),g(bs.$$.fragment,e),g(ws.$$.fragment,e),g($s.$$.fragment,e),g(qs.$$.fragment,e),g(Os.$$.fragment,e),g(Ss.$$.fragment,e),g(Cs.$$.fragment,e),g(Fs.$$.fragment,e),g(Ms.$$.fragment,e),g(As.$$.fragment,e),g(ks.$$.fragment,e),g(Ns.$$.fragment,e),g(zs.$$.fragment,e),g(Ps.$$.fragment,e),g(Ls.$$.fragment,e),g(Es.$$.fragment,e),g(Bs.$$.fragment,e),g(js.$$.fragment,e),g(Ws.$$.fragment,e),g(Hs.$$.fragment,e),g(Ds.$$.fragment,e),g(Vs.$$.fragment,e),g(Is.$$.fragment,e),g(Qs.$$.fragment,e),g(Rs.$$.fragment,e),g(Us.$$.fragment,e),g(Xs.$$.fragment,e),g(Js.$$.fragment,e),g(Zs.$$.fragment,e),g(Gs.$$.fragment,e),g(Ys.$$.fragment,e),g(Ks.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(oa.$$.fragment,e),g(na.$$.fragment,e),g(sa.$$.fragment,e),g(aa.$$.fragment,e),g(ra.$$.fragment,e),g(da.$$.fragment,e),g(ia.$$.fragment,e),g(ua.$$.fragment,e),g(la.$$.fragment,e),g(ca.$$.fragment,e),g(pa.$$.fragment,e),g(ha.$$.fragment,e),g(fa.$$.fragment,e),g(ma.$$.fragment,e),g(ga.$$.fragment,e),g(_a.$$.fragment,e),g(va.$$.fragment,e),g(Ta.$$.fragment,e),g(xa.$$.fragment,e),g(ya.$$.fragment,e),g(ba.$$.fragment,e),g(wa.$$.fragment,e),g($a.$$.fragment,e),g(qa.$$.fragment,e),g(Oa.$$.fragment,e),g(Sa.$$.fragment,e),g(Ca.$$.fragment,e),g(Fa.$$.fragment,e),g(Ma.$$.fragment,e),g(Aa.$$.fragment,e),g(ka.$$.fragment,e),g(Na.$$.fragment,e),g(za.$$.fragment,e),g(Pa.$$.fragment,e),g(La.$$.fragment,e),g(Ea.$$.fragment,e),g(Ba.$$.fragment,e),g(ja.$$.fragment,e),g(Wa.$$.fragment,e),g(Ha.$$.fragment,e),g(Da.$$.fragment,e),g(Va.$$.fragment,e),g(Ia.$$.fragment,e),g(Qa.$$.fragment,e),g(Ra.$$.fragment,e),g(Ua.$$.fragment,e),g(Xa.$$.fragment,e),g(Ja.$$.fragment,e),g(Za.$$.fragment,e),g(Ga.$$.fragment,e),g(Ya.$$.fragment,e),g(Ka.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(or.$$.fragment,e),g(nr.$$.fragment,e),g(sr.$$.fragment,e),g(ar.$$.fragment,e),g(rr.$$.fragment,e),g(dr.$$.fragment,e),g(ir.$$.fragment,e),Xp=!1},d(e){e&&(t(_n),t(b),t(lr),t(B),t(Tl),t(Tn),t(xl),t(xn),t(yl),t(bl),t(bn),t(wl),t(wn),t($l),t($n),t(ql),t(Ol),t(On),t(Sl),t(Sn),t(Cl),t(Cn),t(Fl),t(j),t(Ml),t(y),t(Al),t(W),t(kl),t(H),t(Nl),t(D),t(zl),t(V),t(Pl),t(I),t(Ll),t(Q),t(El),t(R),t(Bl),t(U),t(jl),t(X),t(Wl),t(J),t(Hl),t(Z),t(Dl),t(G),t(Vl),t(Y),t(Il),t(K),t(Ql),t(ee),t(Rl),t(te),t(Ul),t(oe),t(Xl),t(ne),t(Jl),t(se),t(Zl),t(ae),t(Gl),t(re),t(Yl),t(de),t(Kl),t(ie),t(ec),t(ue),t(tc),t(le),t(oc),t(ce),t(nc),t(pe),t(sc),t(he),t(ac),t(fe),t(rc),t(me),t(dc),t(ge),t(ic),t(_e),t(uc),t(ve),t(lc),t(Te),t(cc),t(xe),t(pc),t(ye),t(hc),t(be),t(fc),t(we),t(mc),t($e),t(gc),t(qe),t(_c),t(Oe),t(vc),t(Se),t(Tc),t(Ce),t(xc),t(Fe),t(yc),t(Me),t(bc),t(Ae),t(wc),t(ke),t($c),t(Ne),t(qc),t(ze),t(Oc),t(Pe),t(Sc),t(Le),t(Cc),t(Ee),t(Fc),t(Be),t(Mc),t(je),t(Ac),t(We),t(kc),t(He),t(Nc),t(De),t(zc),t(Ve),t(Pc),t(Ie),t(Lc),t(Qe),t(Ec),t(Re),t(Bc),t(Ue),t(jc),t(Xe),t(Wc),t(Je),t(Hc),t(Ze),t(Dc),t(Ge),t(Vc),t(Ye),t(Ic),t(Ke),t(Qc),t(et),t(Rc),t(tt),t(Uc),t(ot),t(Xc),t(nt),t(Jc),t(st),t(Zc),t(at),t(Gc),t(rt),t(Yc),t(dt),t(Kc),t(it),t(ep),t(ut),t(tp),t(lt),t(op),t(ct),t(np),t(pt),t(sp),t(ht),t(ap),t(ft),t(rp),t(mt),t(dp),t(gt),t(ip),t(_t),t(up),t(vt),t(lp),t(Tt),t(cp),t(xt),t(pp),t(yt),t(hp),t(bt),t(fp),t(wt),t(mp),t($t),t(gp),t(qt),t(_p),t(Ot),t(vp),t(w),t(Tp),t(St),t(xp),t($),t(yp),t(Ct),t(bp),t(q),t(wp),t(Ft),t($p),t(O),t(qp),t(Mt),t(Op),t(S),t(Sp),t(At),t(Cp),t(C),t(Fp),t(kt),t(Mp),t(F),t(Ap),t(Nt),t(kp),t(M),t(Np),t(zt),t(zp),t(A),t(Pp),t(Pt),t(Lp),t(k),t(Ep),t(Lt),t(Bp),t(N),t(jp),t(Et),t(Wp),t(z),t(Hp),t(Bt),t(Dp),t(P),t(Vp),t(jt),t(Ip),t(L),t(Qp),t(Wt),t(Rp),t(E),t(Up),t(_l)),t(x),_(vn),_(yn,e),_(qn,e),_(Fn),_(Mn),_(Vt),_(An),_(kn),_(Nn),_(zn),_(Pn),_(Ln),_(En),_(Bn),_(jn),_(Wn),_(Hn),_(Dn),_(Vn),_(In),_(Qn),_(Rn),_(Un),_(Xn),_(Jn),_(Zn),_(Gn),_(Yn),_(Kn),_(es),_(ts),_(os),_(ns),_(ss),_(as),_(rs),_(ds),_(is),_(us),_(ls),_(cs),_(ps),_(hs),_(fs),_(ms),_(gs),_(_s),_(vs),_(Ts),_(xs),_(ys),_(bs),_(ws),_($s),_(qs),_(Os),_(Ss),_(Cs),_(Fs),_(Ms),_(As),_(ks),_(Ns),_(zs),_(Ps),_(Ls),_(Es),_(Bs),_(js),_(Ws),_(Hs),_(Ds),_(Vs),_(Is),_(Qs),_(Rs),_(Us),_(Xs),_(Js),_(Zs),_(Gs),_(Ys),_(Ks),_(ea),_(ta),_(oa),_(na),_(sa),_(aa),_(ra),_(da),_(ia),_(ua),_(la),_(ca),_(pa),_(ha),_(fa),_(ma),_(ga),_(_a),_(va),_(Ta),_(xa),_(ya),_(ba),_(wa),_($a),_(qa),_(Oa),_(Sa),_(Ca),_(Fa),_(Ma),_(Aa),_(ka),_(Na),_(za),_(Pa),_(La),_(Ea),_(Ba),_(ja),_(Wa),_(Ha),_(Da),_(Va),_(Ia),_(Qa),_(Ra),_(Ua),_(Xa),_(Ja),_(Za),_(Ga),_(Ya),_(Ka),_(er),_(tr),_(or),_(nr),_(sr),_(ar),_(rr),_(dr),_(ir)}}}const A2={local:"model-outputs",sections:[{local:"transformers.utils.ModelOutput",title:"ModelOutput"},{local:"transformers.modeling_outputs.BaseModelOutput",title:"BaseModelOutput"},{local:"transformers.modeling_outputs.BaseModelOutputWithPooling",title:"BaseModelOutputWithPooling"},{local:"transformers.modeling_outputs.BaseModelOutputWithCrossAttentions",title:"BaseModelOutputWithCrossAttentions"},{local:"transformers.modeling_outputs.BaseModelOutputWithPoolingAndCrossAttentions",title:"BaseModelOutputWithPoolingAndCrossAttentions"},{local:"transformers.modeling_outputs.BaseModelOutputWithPast",title:"BaseModelOutputWithPast"},{local:"transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions",title:"BaseModelOutputWithPastAndCrossAttentions"},{local:"transformers.modeling_outputs.Seq2SeqModelOutput",title:"Seq2SeqModelOutput"},{local:"transformers.modeling_outputs.CausalLMOutput",title:"CausalLMOutput"},{local:"transformers.modeling_outputs.CausalLMOutputWithCrossAttentions",title:"CausalLMOutputWithCrossAttentions"},{local:"transformers.modeling_outputs.CausalLMOutputWithPast",title:"CausalLMOutputWithPast"},{local:"transformers.modeling_outputs.MaskedLMOutput",title:"MaskedLMOutput"},{local:"transformers.modeling_outputs.Seq2SeqLMOutput",title:"Seq2SeqLMOutput"},{local:"transformers.modeling_outputs.NextSentencePredictorOutput",title:"NextSentencePredictorOutput"},{local:"transformers.modeling_outputs.SequenceClassifierOutput",title:"SequenceClassifierOutput"},{local:"transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput",title:"Seq2SeqSequenceClassifierOutput"},{local:"transformers.modeling_outputs.MultipleChoiceModelOutput",title:"MultipleChoiceModelOutput"},{local:"transformers.modeling_outputs.TokenClassifierOutput",title:"TokenClassifierOutput"},{local:"transformers.modeling_outputs.QuestionAnsweringModelOutput",title:"QuestionAnsweringModelOutput"},{local:"transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput",title:"Seq2SeqQuestionAnsweringModelOutput"},{local:"transformers.modeling_outputs.Seq2SeqSpectrogramOutput",title:"Seq2SeqSpectrogramOutput"},{local:"transformers.modeling_outputs.SemanticSegmenterOutput",title:"SemanticSegmenterOutput"},{local:"transformers.modeling_outputs.ImageClassifierOutput",title:"ImageClassifierOutput"},{local:"transformers.modeling_outputs.ImageClassifierOutputWithNoAttention",title:"ImageClassifierOutputWithNoAttention"},{local:"transformers.modeling_outputs.DepthEstimatorOutput",title:"DepthEstimatorOutput"},{local:"transformers.modeling_outputs.Wav2Vec2BaseModelOutput",title:"Wav2Vec2BaseModelOutput"},{local:"transformers.modeling_outputs.XVectorOutput",title:"XVectorOutput"},{local:"transformers.modeling_outputs.Seq2SeqTSModelOutput",title:"Seq2SeqTSModelOutput"},{local:"transformers.modeling_outputs.Seq2SeqTSPredictionOutput",title:"Seq2SeqTSPredictionOutput"},{local:"transformers.modeling_outputs.SampleTSPredictionOutput",title:"SampleTSPredictionOutput"},{local:"transformers.modeling_tf_outputs.TFBaseModelOutput",title:"TFBaseModelOutput"},{local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling",title:"TFBaseModelOutputWithPooling"},{local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPoolingAndCrossAttentions",title:"TFBaseModelOutputWithPoolingAndCrossAttentions"},{local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPast",title:"TFBaseModelOutputWithPast"},{local:"transformers.modeling_tf_outputs.TFBaseModelOutputWithPastAndCrossAttentions",title:"TFBaseModelOutputWithPastAndCrossAttentions"},{local:"transformers.modeling_tf_outputs.TFSeq2SeqModelOutput",title:"TFSeq2SeqModelOutput"},{local:"transformers.modeling_tf_outputs.TFCausalLMOutput",title:"TFCausalLMOutput"},{local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithCrossAttentions",title:"TFCausalLMOutputWithCrossAttentions"},{local:"transformers.modeling_tf_outputs.TFCausalLMOutputWithPast",title:"TFCausalLMOutputWithPast"},{local:"transformers.modeling_tf_outputs.TFMaskedLMOutput",title:"TFMaskedLMOutput"},{local:"transformers.modeling_tf_outputs.TFSeq2SeqLMOutput",title:"TFSeq2SeqLMOutput"},{local:"transformers.modeling_tf_outputs.TFNextSentencePredictorOutput",title:"TFNextSentencePredictorOutput"},{local:"transformers.modeling_tf_outputs.TFSequenceClassifierOutput",title:"TFSequenceClassifierOutput"},{local:"transformers.modeling_tf_outputs.TFSeq2SeqSequenceClassifierOutput",title:"TFSeq2SeqSequenceClassifierOutput"},{local:"transformers.modeling_tf_outputs.TFMultipleChoiceModelOutput",title:"TFMultipleChoiceModelOutput"},{local:"transformers.modeling_tf_outputs.TFTokenClassifierOutput",title:"TFTokenClassifierOutput"},{local:"transformers.modeling_tf_outputs.TFQuestionAnsweringModelOutput",title:"TFQuestionAnsweringModelOutput"},{local:"transformers.modeling_tf_outputs.TFSeq2SeqQuestionAnsweringModelOutput",title:"TFSeq2SeqQuestionAnsweringModelOutput"},{local:"transformers.modeling_flax_outputs.FlaxBaseModelOutput",title:"FlaxBaseModelOutput"},{local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPast",title:"FlaxBaseModelOutputWithPast"},{local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPooling",title:"FlaxBaseModelOutputWithPooling"},{local:"transformers.modeling_flax_outputs.FlaxBaseModelOutputWithPastAndCrossAttentions",title:"FlaxBaseModelOutputWithPastAndCrossAttentions"},{local:"transformers.modeling_flax_outputs.FlaxSeq2SeqModelOutput",title:"FlaxSeq2SeqModelOutput"},{local:"transformers.modeling_flax_outputs.FlaxCausalLMOutputWithCrossAttentions",title:"FlaxCausalLMOutputWithCrossAttentions"},{local:"transformers.modeling_flax_outputs.FlaxMaskedLMOutput",title:"FlaxMaskedLMOutput"},{local:"transformers.modeling_flax_outputs.FlaxSeq2SeqLMOutput",title:"FlaxSeq2SeqLMOutput"},{local:"transformers.modeling_flax_outputs.FlaxNextSentencePredictorOutput",title:"FlaxNextSentencePredictorOutput"},{local:"transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput",title:"FlaxSequenceClassifierOutput"},{local:"transformers.modeling_flax_outputs.FlaxSeq2SeqSequenceClassifierOutput",title:"FlaxSeq2SeqSequenceClassifierOutput"},{local:"transformers.modeling_flax_outputs.FlaxMultipleChoiceModelOutput",title:"FlaxMultipleChoiceModelOutput"},{local:"transformers.modeling_flax_outputs.FlaxTokenClassifierOutput",title:"FlaxTokenClassifierOutput"},{local:"transformers.modeling_flax_outputs.FlaxQuestionAnsweringModelOutput",title:"FlaxQuestionAnsweringModelOutput"},{local:"transformers.modeling_flax_outputs.FlaxSeq2SeqQuestionAnsweringModelOutput",title:"FlaxSeq2SeqQuestionAnsweringModelOutput"}],title:"Model outputs"};function k2(vl){return w2(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class j2 extends q2{constructor(x){super(),O2(this,x,k2,M2,b2,{})}}export{j2 as component};
