import{s as Me,n as ie,o as oe}from"../chunks/scheduler.889ebb13.js";import{S as ce,i as re,g as p,s as a,u as r,A as ye,h as M,f as l,c as n,j as y,v as d,y as i,k as o,o as c,a as t,w as j,d as J,t as w,x as u}from"../chunks/index.8980e686.js";import{I as ul}from"../chunks/IconCopyLink.357761cd.js";import{C as T}from"../chunks/CodeBlock.25fc3430.js";function de(fl){let m,bs,Ts,Cs,h,b,ms,k,Tl,js,Il="어떻게 사용자 정의 파이프라인을 생성하나요?",Bs,Z,bl='이 가이드에서는 사용자 정의 파이프라인을 어떻게 생성하고 <a href="hf.co/models">허브</a>에 공유하거나 🤗 Transformers 라이브러리에 추가하는 방법을 살펴보겠습니다.',_s,A,Cl=`먼저 파이프라인이 수용할 수 있는 원시 입력을 결정해야 합니다.
문자열, 원시 바이트, 딕셔너리 또는 가장 원하는 입력일 가능성이 높은 것이면 무엇이든 가능합니다.
이 입력을 가능한 한 순수한 Python 형식으로 유지해야 (JSON을 통해 다른 언어와도) 호환성이 좋아집니다.
이것이 전처리(<code>preprocess</code>) 파이프라인의 입력(<code>inputs</code>)이 될 것입니다.`,ks,v,Bl=`그런 다음 <code>outputs</code>를 정의하세요.
<code>inputs</code>와 같은 정책을 따르고, 간단할수록 좋습니다.
이것이 후처리(<code>postprocess</code>) 메소드의 출력이 될 것입니다.`,Zs,V,_l="먼저 4개의 메소드(<code>preprocess</code>, <code>_forward</code>, <code>postprocess</code> 및 <code>_sanitize_parameters</code>)를 구현하기 위해 기본 클래스 <code>Pipeline</code>을 상속하여 시작합니다.",As,g,vs,N,kl="이 분할 구조는 CPU/GPU에 대한 비교적 원활한 지원을 제공하는 동시에, 다른 스레드에서 CPU에 대한 사전/사후 처리를 수행할 수 있게 지원하는 것입니다.",Vs,R,Zl=`<code>preprocess</code>는 원래 정의된 입력을 가져와 모델에 공급할 수 있는 형식으로 변환합니다.
더 많은 정보를 포함할 수 있으며 일반적으로 <code>Dict</code> 형태입니다.`,gs,E,Al=`<code>_forward</code>는 구현 세부 사항이며 직접 호출할 수 없습니다.
<code>forward</code>는 예상 장치에서 모든 것이 작동하는지 확인하기 위한 안전장치가 포함되어 있어 선호되는 호출 메소드입니다.
실제 모델과 관련된 것은 <code>_forward</code> 메소드에 속하며, 나머지는 전처리/후처리 과정에 있습니다.`,Ns,G,vl="<code>postprocess</code> 메소드는 <code>_forward</code>의 출력을 가져와 이전에 결정한 최종 출력 형식으로 변환합니다.",Rs,W,Vl="<code>_sanitize_parameters</code>는 초기화 시간에 <code>pipeline(...., maybe_arg=4)</code>이나 호출 시간에 <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>과 같이, 사용자가 원하는 경우 언제든지 매개변수를 전달할 수 있도록 허용합니다.",Es,H,gl=`<code>_sanitize_parameters</code>의 반환 값은 <code>preprocess</code>, <code>_forward</code>, <code>postprocess</code>에 직접 전달되는 3개의 kwargs 딕셔너리입니다.
호출자가 추가 매개변수로 호출하지 않았다면 아무것도 채우지 마십시오.
이렇게 하면 항상 더 “자연스러운” 함수 정의의 기본 인수를 유지할 수 있습니다.`,Gs,X,Nl="분류 작업에서 <code>top_k</code> 매개변수가 대표적인 예입니다.",Ws,q,Hs,x,Rl="이를 달성하기 위해 우리는 <code>postprocess</code> 메소드를 기본 매개변수인 <code>5</code>로 업데이트하고 <code>_sanitize_parameters</code>를 수정하여 이 새 매개변수를 허용합니다.",Xs,$,qs,z,El=`입/출력을 가능한 한 간단하고 완전히 JSON 직렬화 가능한 형식으로 유지하려고 노력하십시오.
이렇게 하면 사용자가 새로운 종류의 개체를 이해하지 않고도 파이프라인을 쉽게 사용할 수 있습니다.
또한 사용 용이성을 위해 여러 가지 유형의 인수(오디오 파일은 파일 이름, URL 또는 순수한 바이트일 수 있음)를 지원하는 것이 비교적 일반적입니다.`,xs,U,C,hs,Q,ml,Js,Gl="지원되는 작업 목록에 추가하기",$s,F,Wl="<code>new-task</code>를 지원되는 작업 목록에 등록하려면 <code>PIPELINE_REGISTRY</code>에 추가해야 합니다:",zs,Y,Qs,S,Hl="원하는 경우 기본 모델을 지정할 수 있으며, 이 경우 특정 개정(분기 이름 또는 커밋 해시일 수 있음, 여기서는 “abcdef”)과 타입을 함께 가져와야 합니다:",Fs,P,Ys,f,B,Us,L,hl,ws,Xl="Hub에 파이프라인 공유하기",Ss,K,ql=`Hub에 사용자 정의 파이프라인을 공유하려면 <code>Pipeline</code> 하위 클래스의 사용자 정의 코드를 Python 파일에 저장하기만 하면 됩니다.
예를 들어, 다음과 같이 문장 쌍 분류를 위한 사용자 정의 파이프라인을 사용한다고 가정해 보겠습니다:`,Ps,D,Ls,O,xl=`구현은 프레임워크에 구애받지 않으며, PyTorch와 TensorFlow 모델에 대해 작동합니다.
이를 <code>pair_classification.py</code>라는 파일에 저장한 경우, 다음과 같이 가져오고 등록할 수 있습니다:`,Ks,ss,Ds,ls,$l=`이 작업이 완료되면 사전훈련된 모델과 함께 사용할 수 있습니다.
예를 들어, <code>sgugger/finetuned-bert-mrpc</code>은 MRPC 데이터 세트에서 미세 조정되어 문장 쌍을 패러프레이즈인지 아닌지를 분류합니다.`,Os,es,sl,ts,zl="그런 다음 <code>Repository</code>의 <code>save_pretrained</code> 메소드를 사용하여 허브에 공유할 수 있습니다:",ll,as,el,ns,Ql=`이렇게 하면 “test-dynamic-pipeline” 폴더 내에 <code>PairClassificationPipeline</code>을 정의한 파일이 복사되며, 파이프라인의 모델과 토크나이저도 저장한 후, <code>{your_username}/test-dynamic-pipeline</code> 저장소에 있는 모든 것을 푸시합니다.
이후에는 <code>trust_remote_code=True</code> 옵션만 제공하면 누구나 사용할 수 있습니다.`,tl,ps,al,I,_,fs,Ms,Ul,us,Fl="🤗 Transformers에 파이프라인 추가하기",nl,is,Yl="🤗 Transformers에 사용자 정의 파이프라인을 기여하려면, <code>pipelines</code> 하위 모듈에 사용자 정의 파이프라인 코드와 함께 새 모듈을 추가한 다음, <code>pipelines/__init__.py</code>에서 정의된 작업 목록에 추가해야 합니다.",pl,os,Sl=`그런 다음 테스트를 추가해야 합니다.
<code>tests/test_pipelines_MY_PIPELINE.py</code>라는 새 파일을 만들고 다른 테스트와 예제를 함께 작성합니다.`,Ml,cs,Pl="<code>run_pipeline_test</code> 함수는 매우 일반적이며, <code>model_mapping</code> 및 <code>tf_model_mapping</code>에서 정의된 가능한 모든 아키텍처의 작은 무작위 모델에서 실행됩니다.",il,rs,Ll=`이는 향후 호환성을 테스트하는 데 매우 중요하며, 누군가 <code>XXXForQuestionAnswering</code>을 위한 새 모델을 추가하면 파이프라인 테스트가 해당 모델에서 실행을 시도한다는 의미입니다.
모델이 무작위이기 때문에 실제 값을 확인하는 것은 불가능하므로, 단순히 파이프라인 출력 <code>TYPE</code>과 일치시키기 위한 도우미 <code>ANY</code>가 있습니다.`,ol,ys,Kl="또한 2개(이상적으로는 4개)의 테스트를 구현해야 합니다.",cl,ds,Dl=`<li><code>test_small_model_pt</code>: 이 파이프라인에 대한 작은 모델 1개를 정의(결과가 의미 없어도 상관없음)하고 파이프라인 출력을 테스트합니다.
결과는 <code>test_small_model_tf</code>와 동일해야 합니다.</li> <li><code>test_small_model_tf</code>: 이 파이프라인에 대한 작은 모델 1개를 정의(결과가 의미 없어도 상관없음)하고 파이프라인 출력을 테스트합니다.
결과는 <code>test_small_model_pt</code>와 동일해야 합니다.</li> <li><code>test_large_model_pt</code>(<code>선택사항</code>): 결과가 의미 있을 것으로 예상되는 실제 파이프라인에서 파이프라인을 테스트합니다.
이러한 테스트는 속도가 느리므로 이를 표시해야 합니다.
여기서의 목표는 파이프라인을 보여주고 향후 릴리즈에서의 변화가 없는지 확인하는 것입니다.</li> <li><code>test_large_model_tf</code>(<code>선택사항</code>): 결과가 의미 있을 것으로 예상되는 실제 파이프라인에서 파이프라인을 테스트합니다.
이러한 테스트는 속도가 느리므로 이를 표시해야 합니다.
여기서의 목표는 파이프라인을 보여주고 향후 릴리즈에서의 변화가 없는지 확인하는 것입니다.</li>`,rl,Is,yl;return k=new ul({}),g=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`}}),q=new T({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`}}),$=new T({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjB0b3BfayVFQiVBNSVCQyUyMCVFQyVCMiU5OCVFQiVBNiVBQyVFRCU5NSU5OCVFQiU4QSU5NCUyMCVFQiVBMSU5QyVFQyVBNyU4MSUyMCVFQyVCNiU5NCVFQSVCMCU4MCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJlc3RfY2xhc3MlMEElMEElMEFkZWYlMjBfc2FuaXRpemVfcGFyYW1ldGVycyhzZWxmJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMm1heWJlX2FyZyUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19rd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJtYXliZV9hcmclMjIlNUQlMEElMEElMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBpZiUyMCUyMnRvcF9rJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb3N0cHJvY2Vzc19rd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMnRvcF9rJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcHJlcHJvY2Vzc19rd2FyZ3MlMkMlMjAlN0IlN0QlMkMlMjBwb3N0cHJvY2Vzc19rd2FyZ3M=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># top_k를 처리하는 로직 추가</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`}}),Q=new ul({}),Y=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`}}),P=new T({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjAlRUQlOTglODQlRUMlOUUlQUMlMjAlRUMlQTclODAlRUMlOUIlOTAlMjAlRUMlOUMlQTAlRUQlOTglOTUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># 현재 지원 유형: text, audio, image, multimodal</span>
)`}}),L=new ul({}),D=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`}}),ss=new T({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`}}),es=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`}}),as=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEElMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeSglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiklMEFjbGFzc2lmaWVyLnNhdmVfcHJldHJhaW5lZCglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIpJTBBcmVwby5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository

repo = Repository(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>, clone_from=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>)
classifier.save_pretrained(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)
repo.push_to_hub()`}}),ps=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`}}),Ms=new ul({}),{c(){m=p("meta"),bs=a(),Ts=p("p"),Cs=a(),h=p("h1"),b=p("a"),ms=p("span"),r(k.$$.fragment),Tl=a(),js=p("span"),js.textContent=Il,Bs=a(),Z=p("p"),Z.innerHTML=bl,_s=a(),A=p("p"),A.innerHTML=Cl,ks=a(),v=p("p"),v.innerHTML=Bl,Zs=a(),V=p("p"),V.innerHTML=_l,As=a(),r(g.$$.fragment),vs=a(),N=p("p"),N.textContent=kl,Vs=a(),R=p("p"),R.innerHTML=Zl,gs=a(),E=p("p"),E.innerHTML=Al,Ns=a(),G=p("p"),G.innerHTML=vl,Rs=a(),W=p("p"),W.innerHTML=Vl,Es=a(),H=p("p"),H.innerHTML=gl,Gs=a(),X=p("p"),X.innerHTML=Nl,Ws=a(),r(q.$$.fragment),Hs=a(),x=p("p"),x.innerHTML=Rl,Xs=a(),r($.$$.fragment),qs=a(),z=p("p"),z.textContent=El,xs=a(),U=p("h2"),C=p("a"),hs=p("span"),r(Q.$$.fragment),ml=a(),Js=p("span"),Js.textContent=Gl,$s=a(),F=p("p"),F.innerHTML=Wl,zs=a(),r(Y.$$.fragment),Qs=a(),S=p("p"),S.textContent=Hl,Fs=a(),r(P.$$.fragment),Ys=a(),f=p("h2"),B=p("a"),Us=p("span"),r(L.$$.fragment),hl=a(),ws=p("span"),ws.textContent=Xl,Ss=a(),K=p("p"),K.innerHTML=ql,Ps=a(),r(D.$$.fragment),Ls=a(),O=p("p"),O.innerHTML=xl,Ks=a(),r(ss.$$.fragment),Ds=a(),ls=p("p"),ls.innerHTML=$l,Os=a(),r(es.$$.fragment),sl=a(),ts=p("p"),ts.innerHTML=zl,ll=a(),r(as.$$.fragment),el=a(),ns=p("p"),ns.innerHTML=Ql,tl=a(),r(ps.$$.fragment),al=a(),I=p("h2"),_=p("a"),fs=p("span"),r(Ms.$$.fragment),Ul=a(),us=p("span"),us.textContent=Fl,nl=a(),is=p("p"),is.innerHTML=Yl,pl=a(),os=p("p"),os.innerHTML=Sl,Ml=a(),cs=p("p"),cs.innerHTML=Pl,il=a(),rs=p("p"),rs.innerHTML=Ll,ol=a(),ys=p("p"),ys.textContent=Kl,cl=a(),ds=p("ul"),ds.innerHTML=Dl,rl=a(),Is=p("p"),this.h()},l(s){const e=ye("svelte-1phssyn",document.head);m=M(e,"META",{name:!0,content:!0}),e.forEach(l),bs=n(s),Ts=M(s,"P",{}),y(Ts).forEach(l),Cs=n(s),h=M(s,"H1",{class:!0});var dl=y(h);b=M(dl,"A",{id:!0,class:!0,href:!0});var Ol=y(b);ms=M(Ol,"SPAN",{});var se=y(ms);d(k.$$.fragment,se),se.forEach(l),Ol.forEach(l),Tl=n(dl),js=M(dl,"SPAN",{"data-svelte-h":!0}),i(js)!=="svelte-1wnrbij"&&(js.textContent=Il),dl.forEach(l),Bs=n(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-19at4ba"&&(Z.innerHTML=bl),_s=n(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-6ogr6z"&&(A.innerHTML=Cl),ks=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1r1v4v7"&&(v.innerHTML=Bl),Zs=n(s),V=M(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1u9gwbf"&&(V.innerHTML=_l),As=n(s),d(g.$$.fragment,s),vs=n(s),N=M(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-rv0lg4"&&(N.textContent=kl),Vs=n(s),R=M(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-fwn4og"&&(R.innerHTML=Zl),gs=n(s),E=M(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-tcs7ux"&&(E.innerHTML=Al),Ns=n(s),G=M(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1a54d54"&&(G.innerHTML=vl),Rs=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-ufagsr"&&(W.innerHTML=Vl),Es=n(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-j02rys"&&(H.innerHTML=gl),Gs=n(s),X=M(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1n2acw"&&(X.innerHTML=Nl),Ws=n(s),d(q.$$.fragment,s),Hs=n(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1d0sxb1"&&(x.innerHTML=Rl),Xs=n(s),d($.$$.fragment,s),qs=n(s),z=M(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1k45o3o"&&(z.textContent=El),xs=n(s),U=M(s,"H2",{class:!0});var jl=y(U);C=M(jl,"A",{id:!0,class:!0,href:!0});var le=y(C);hs=M(le,"SPAN",{});var ee=y(hs);d(Q.$$.fragment,ee),ee.forEach(l),le.forEach(l),ml=n(jl),Js=M(jl,"SPAN",{"data-svelte-h":!0}),i(Js)!=="svelte-kcv7fn"&&(Js.textContent=Gl),jl.forEach(l),$s=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1ty0isp"&&(F.innerHTML=Wl),zs=n(s),d(Y.$$.fragment,s),Qs=n(s),S=M(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-ct19sw"&&(S.textContent=Hl),Fs=n(s),d(P.$$.fragment,s),Ys=n(s),f=M(s,"H2",{class:!0});var Jl=y(f);B=M(Jl,"A",{id:!0,class:!0,href:!0});var te=y(B);Us=M(te,"SPAN",{});var ae=y(Us);d(L.$$.fragment,ae),ae.forEach(l),te.forEach(l),hl=n(Jl),ws=M(Jl,"SPAN",{"data-svelte-h":!0}),i(ws)!=="svelte-1q8mmaz"&&(ws.textContent=Xl),Jl.forEach(l),Ss=n(s),K=M(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-56khl3"&&(K.innerHTML=ql),Ps=n(s),d(D.$$.fragment,s),Ls=n(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1d1jvf5"&&(O.innerHTML=xl),Ks=n(s),d(ss.$$.fragment,s),Ds=n(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1vdr0z9"&&(ls.innerHTML=$l),Os=n(s),d(es.$$.fragment,s),sl=n(s),ts=M(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-fd2kff"&&(ts.innerHTML=zl),ll=n(s),d(as.$$.fragment,s),el=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1yjhf56"&&(ns.innerHTML=Ql),tl=n(s),d(ps.$$.fragment,s),al=n(s),I=M(s,"H2",{class:!0});var wl=y(I);_=M(wl,"A",{id:!0,class:!0,href:!0});var ne=y(_);fs=M(ne,"SPAN",{});var pe=y(fs);d(Ms.$$.fragment,pe),pe.forEach(l),ne.forEach(l),Ul=n(wl),us=M(wl,"SPAN",{"data-svelte-h":!0}),i(us)!=="svelte-1urg6h4"&&(us.textContent=Fl),wl.forEach(l),nl=n(s),is=M(s,"P",{"data-svelte-h":!0}),i(is)!=="svelte-52sri7"&&(is.innerHTML=Yl),pl=n(s),os=M(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-5f0sxq"&&(os.innerHTML=Sl),Ml=n(s),cs=M(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-yv6zf4"&&(cs.innerHTML=Pl),il=n(s),rs=M(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-15fh04w"&&(rs.innerHTML=Ll),ol=n(s),ys=M(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-e68emk"&&(ys.textContent=Kl),cl=n(s),ds=M(s,"UL",{"data-svelte-h":!0}),i(ds)!=="svelte-1wfarmi"&&(ds.innerHTML=Dl),rl=n(s),Is=M(s,"P",{}),y(Is).forEach(l),this.h()},h(){o(m,"name","hf:doc:metadata"),o(m,"content",JSON.stringify(je)),o(b,"id","how-to-create-a-custom-pipeline"),o(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(b,"href","#how-to-create-a-custom-pipeline"),o(h,"class","relative group"),o(C,"id","adding-it-to-the-list-of-supported-tasks"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#adding-it-to-the-list-of-supported-tasks"),o(U,"class","relative group"),o(B,"id","share-your-pipeline-on-the-hub"),o(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(B,"href","#share-your-pipeline-on-the-hub"),o(f,"class","relative group"),o(_,"id","add-the-pipeline-to-transformers"),o(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(_,"href","#add-the-pipeline-to-transformers"),o(I,"class","relative group")},m(s,e){c(document.head,m),t(s,bs,e),t(s,Ts,e),t(s,Cs,e),t(s,h,e),c(h,b),c(b,ms),j(k,ms,null),c(h,Tl),c(h,js),t(s,Bs,e),t(s,Z,e),t(s,_s,e),t(s,A,e),t(s,ks,e),t(s,v,e),t(s,Zs,e),t(s,V,e),t(s,As,e),j(g,s,e),t(s,vs,e),t(s,N,e),t(s,Vs,e),t(s,R,e),t(s,gs,e),t(s,E,e),t(s,Ns,e),t(s,G,e),t(s,Rs,e),t(s,W,e),t(s,Es,e),t(s,H,e),t(s,Gs,e),t(s,X,e),t(s,Ws,e),j(q,s,e),t(s,Hs,e),t(s,x,e),t(s,Xs,e),j($,s,e),t(s,qs,e),t(s,z,e),t(s,xs,e),t(s,U,e),c(U,C),c(C,hs),j(Q,hs,null),c(U,ml),c(U,Js),t(s,$s,e),t(s,F,e),t(s,zs,e),j(Y,s,e),t(s,Qs,e),t(s,S,e),t(s,Fs,e),j(P,s,e),t(s,Ys,e),t(s,f,e),c(f,B),c(B,Us),j(L,Us,null),c(f,hl),c(f,ws),t(s,Ss,e),t(s,K,e),t(s,Ps,e),j(D,s,e),t(s,Ls,e),t(s,O,e),t(s,Ks,e),j(ss,s,e),t(s,Ds,e),t(s,ls,e),t(s,Os,e),j(es,s,e),t(s,sl,e),t(s,ts,e),t(s,ll,e),j(as,s,e),t(s,el,e),t(s,ns,e),t(s,tl,e),j(ps,s,e),t(s,al,e),t(s,I,e),c(I,_),c(_,fs),j(Ms,fs,null),c(I,Ul),c(I,us),t(s,nl,e),t(s,is,e),t(s,pl,e),t(s,os,e),t(s,Ml,e),t(s,cs,e),t(s,il,e),t(s,rs,e),t(s,ol,e),t(s,ys,e),t(s,cl,e),t(s,ds,e),t(s,rl,e),t(s,Is,e),yl=!0},p:ie,i(s){yl||(J(k.$$.fragment,s),J(g.$$.fragment,s),J(q.$$.fragment,s),J($.$$.fragment,s),J(Q.$$.fragment,s),J(Y.$$.fragment,s),J(P.$$.fragment,s),J(L.$$.fragment,s),J(D.$$.fragment,s),J(ss.$$.fragment,s),J(es.$$.fragment,s),J(as.$$.fragment,s),J(ps.$$.fragment,s),J(Ms.$$.fragment,s),yl=!0)},o(s){w(k.$$.fragment,s),w(g.$$.fragment,s),w(q.$$.fragment,s),w($.$$.fragment,s),w(Q.$$.fragment,s),w(Y.$$.fragment,s),w(P.$$.fragment,s),w(L.$$.fragment,s),w(D.$$.fragment,s),w(ss.$$.fragment,s),w(es.$$.fragment,s),w(as.$$.fragment,s),w(ps.$$.fragment,s),w(Ms.$$.fragment,s),yl=!1},d(s){s&&(l(bs),l(Ts),l(Cs),l(h),l(Bs),l(Z),l(_s),l(A),l(ks),l(v),l(Zs),l(V),l(As),l(vs),l(N),l(Vs),l(R),l(gs),l(E),l(Ns),l(G),l(Rs),l(W),l(Es),l(H),l(Gs),l(X),l(Ws),l(Hs),l(x),l(Xs),l(qs),l(z),l(xs),l(U),l($s),l(F),l(zs),l(Qs),l(S),l(Fs),l(Ys),l(f),l(Ss),l(K),l(Ps),l(Ls),l(O),l(Ks),l(Ds),l(ls),l(Os),l(sl),l(ts),l(ll),l(el),l(ns),l(tl),l(al),l(I),l(nl),l(is),l(pl),l(os),l(Ml),l(cs),l(il),l(rs),l(ol),l(ys),l(cl),l(ds),l(rl),l(Is)),l(m),u(k),u(g,s),u(q,s),u($,s),u(Q),u(Y,s),u(P,s),u(L),u(D,s),u(ss,s),u(es,s),u(as,s),u(ps,s),u(Ms)}}}const je={local:"how-to-create-a-custom-pipeline",sections:[{local:"adding-it-to-the-list-of-supported-tasks",title:"지원되는 작업 목록에 추가하기 "},{local:"share-your-pipeline-on-the-hub",title:"Hub에 파이프라인 공유하기 "},{local:"add-the-pipeline-to-transformers",title:"🤗 Transformers에 파이프라인 추가하기 "}],title:"어떻게 사용자 정의 파이프라인을 생성하나요? "};function Je(fl){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class he extends ce{constructor(m){super(),re(this,m,Je,de,Me,{})}}export{he as component};
