import{s as dl,n as pl,o as ml}from"../chunks/scheduler.b9285784.js";import{S as ul,i as fl,e as s,s as i,c,h as yl,a as o,d as l,b as n,f as jt,g as h,j as r,k as f,l as kt,m as a,n as d,t as p,o as m,p as u}from"../chunks/index.26bc89a1.js";import{C as gl,H as y,E as wl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.65596716.js";import{C as be}from"../chunks/CodeBlock.fd6e4a0e.js";function Ml(Jt){let g,_e,Te,$e,k,Ue,J,Ce,G,Gt="This guide will cover basics of using context parallelism in 🤗<code>accelerate</code>, for the more curious readers, we will also cover some technicalities in the later sections.",ve,H,Ht='See also the very related <a href="./sequence_parallelism.md">Guide to Sequence Parallellism</a>.',je,I,ke,L,It=`With the advent of large language models, and recently reasoning models, the sequence length has been growing rapidly. This, combined with quadratic memory complexity of attention, has led to a need for more efficient ways to train models with long sequences.
With sequence length of 128k, the memory requirement of the attention matrix is <code>128k * 128k * 2 bytes * num_heads = ~32 GB * num_heads</code> for <code>bf16</code> precision, given vanilla attention implementation. Granted, with usage of <code>flash attention</code> or <code>SDPA</code> which do not materialize these attention weights, this decreases drastically, but the growth in memory requirements is still considerable.`,Je,q,Lt="Context parallelism allows us to shard the inputs to the attention computation along the sequence dimension and compute the attention in parallel on multiple GPUs. With this, we can train models with long sequences, scaling potentially to 1M+ sequence length.",Ge,W,He,B,Ie,z,qt=`As with any other feature in 🤗<code>accelerate</code>, you can enable context parallelism also by passing the corresponding flags to <code>accelerate launch</code>.
In this case, it’s no different:`,Le,V,qe,M,Wt="<p>You can also set the <code>cp_size</code> and <code>cp_comm_strategy</code> in the <code>accelerate config</code> command, which will save them in your <code>accelerate</code> configuration file, so you don’t have to pass them every time you launch your script.</p>",We,b,Bt=`<p>Context parallelism is compatible with other parallelism strategies, such as data parallelism, tensor parallelism and FSDP2.
You can simply combine them by setting your parallelism sizes to the desired values, e.g. <code>--parallelism-config-dp-size 8 --parallelism-config-tp-size 2 --parallelism-config-cp-size 8</code>. Or you can use the <code>ParallelismConfig</code> class to set them programmatically.</p>`,Be,T,zt=`<p>Context parallelism is tightly coupled  with <code>FSDP2</code>, which you can learn more about in the <a href="fsdp1_vs_fsdp2.md">FSDP2 introduction</a>. Meaning, context parallelism only works if you use <code>FullyShardedDataParallelPlugin</code> or <code>--use-fsdp</code> with version set to 2 to your
program. If no <code>FSDP2</code> is used, error will be raised.</p>`,ze,x,Vt='<p>Context parallelism works only with <a href="https://docs.pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">SDPA</a> and only with no mask or causal mask. We can’t properly detect this for you, so it’s your responsibility to ensure that you are using <code>SDPA</code> with no mask or causal mask. If you use any other attention implementation, it will raise an error.</p>',Ve,F,Ft=`After enabling context parallelism with the methods mentioned above, you can then apply it to your training loop. We provide a thin wrapper around <a href="https://docs.pytorch.org/docs/stable/distributed.tensor.html#torch.distributed.tensor.experimental.context_parallel" rel="nofollow"><code>torch.distributed.tensor.experimental.context_parallel</code></a> that you can use in your training loop, that abstracts some of the complexity of using it (more on this later). To minimize the changes you have to do in your training loop, we provide a context manager that is a <code>noop</code> if context parallelism is not enabled, and applies the context parallelism if it is enabled. This way, you can use it in your training loop without changing any code based on your parallelism configuration.
You can use it as follows:`,Fe,P,Pe,_,Pt="<p>This context manager has to be recreated with each training step, as shown in the example above. It’s crucial to do so.</p>",Qe,Q,Qt="This can scale your context size to 1M+ sequence length potentially. Below, we showcase speed and memory usage of context parallelism for up-to 256k context size. We can see that when we double the context size and number of GPUs, we can achieve consistent memory usage, potentially enabling endless context length scaling.",Ye,$,Yt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_perf.png" alt="context parallelism memory usage"/> <br/> <em>Figure 1: Memory usage and speed of context parallelism for up-to 256k context size.</em>',Ae,w,Me,At='These examples were created with a script you can find <a href="https://github.com/huggingface/accelerate/blob/main/examples/fsdp2/nd_parallel.py" rel="nofollow">in the examples folder</a>. To run the example on 8 H100 GPUs (128k sequence length), you can use the following command:',vt,Y,Se,A,Ze,S,St="The context manager takes a few arguments, that are used to configure the context parallelism.",Ee,Z,Zt=`<li><code>buffers</code>: This is a list of tensors that are to be sharded across the sequence dimension. These tensors are usually input ids, labels and attention mask.</li> <li><code>buffer_seq_dims</code>: This is a list of integers, that specify the sequence dimension of the buffers, in the order of the <code>buffers</code> list. If you pass <code>buffers=[input_ids, shift_labels]</code> with both having shape <code>[batch_size, sequence_length]</code>, you would pass <code>buffer_seq_dims=[1, 1]</code>.
as the sequence dimension is the second dimension of the tensors. This is required for correct computation of the model outputs.</li> <li><code>no_restore_buffers</code>: The implementation of context parallelism modifies the buffers in-place, converting them to <code>torch.distributed.tensor.Dtensor</code>s. After the context manager exits, a communication kernel would need to be launched to restore the buffers to their original state (usually all-gather). This takes some time, so it is recommended to pass the same tensors as in the <code>buffers</code> argument, to avoid unnecessary communication, unless you are sure that you need to use the buffers after the context manager exits.</li>`,Ne,U,Et=`<p>Context parallelism is not compatible with <code>labels</code> that are a copy of <code>input_ids</code>, which models from 🤗 transformers can shift to enable causal language modeling themselves.
Imagine this case:
labels = [l1, l2, l3, l4, … li]
if we apply context parallelism, each rank would end up with a part of labels, such as this:
labels_rank_0 = [l1, l2], labels_rank_1 = [l3, l4], …
after transformers modelling code shifts the labels, it would end up with:
labels_rank_0 = [l2, PAD], labels_rank_1 = [l3, PAD], …
where <code>PAD</code> is a padding token. This would result in incorrect loss computation, as the labels are not aligned with the inputs anymore.
Because of this, you need to manually shift the labels before passing them in the model</p>`,Xe,E,Re,N,Nt="Accelerate provides only a single option to configure context parallelism (except for <code>cp_size</code>)",De,X,Xt="<li><code>cp_comm_strategy</code>: The rotation method to use for the shards. We strongly recommend keeping this as <code>&quot;allgather&quot;</code>, as it’s very likely it will outperform <code>&quot;alltoall&quot;</code> in most cases.</li>",Ke,R,Rt=`Context parallel size is rather self-explanatory, it’s the number of ranks across which the inputs are to be-sharded.
Context parallel shard rotation defines how the shards of the inputs are rotated across ranks. We’ll cover the 2 options in more detail in the next section.`,Oe,D,Dt='You can see an end-to-end example in the <a href="https://github.com/huggingface/accelerate/blob/main/examples/fsdp2/nd_parallel.py" rel="nofollow">ND parallel example</a> file, where you can train an 8B model with up-to 128k context length on a single 8xH100 node. Using multi-node training, you can scale this to 1M+ sequence length on multiple GPUs. You can also seamlessly combine it with other parallelism strategies to fit your needs.',et,K,tt,C,Kt="<p>This section is fairly technical, so if you don’t need to learn the internals of context parallelism, you can skip it and start building 🚀</p>",lt,O,Ot="We’re going to be using word <code>shard</code> extensively in the following sections, so let’s define it first. If we call tensor <code>sharded</code> across <code>Dth</code> dimension, across <code>N</code> ranks, we mean that this tensor is split into <code>N</code> parts, where each part of the tensor has shape <code>[..., D//N, ...]</code>.",at,ee,it,te,el=`Context parallelism works on sharding the <code>Q, K and V</code> matrices across the sequence dimension. Each rank has its assigned shard of <code>Q</code>, let’s call it <code>Q_i</code>. This matrix stays only on this rank, during the whole computation. Similarly, each rank has its own shard of <code>K</code> and <code>V</code>, let’s call them <code>K_i</code> and <code>V_i</code>. Then, each rank calculates attention with its own shard of <code>Q_i</code>, <code>K_i</code> and <code>V_i</code>, let’s call it <code>attn_i</code>. During this computation, a communication kernel is launched to gather the <code>Ks</code> and <code>Vs</code> from all other ranks. What communication primitive is used, depends on the <code>context_parallel_shard_rotation</code> option.
This way, each rank gets to calculate local attention, first with <code>Q_i</code>, <code>K_i</code> and <code>V_i</code>, then with <code>K_j</code> and <code>V_j</code> from all other ranks. As each rank holds <code>Q, K and V</code> matrices that are sharded across the sequence dimension, the resulting matrices are smaller and can fit on a single GPU.`,nt,le,tl="We can formalize this in the following pseudocode:",st,ae,ot,ie,rt,ne,ct,se,ll=`So what’s the difference between all-to-all and all-gather? With all-gather, the communication is very simple. After (well, before, as it usually takes longer) we compute the local attention <code>attn_i</code> we launch an all-gather to gather all other <code>Ks</code> and <code>Vs</code> from all other ranks. As this communication is done, each rank has all the <code>Ks</code> and <code>Vs</code> from all other ranks, and can compute the attention with them sequentially.
In ideal scenario, all-gather finishes in the exact moment as the calculation of <code>attn_i</code> is done. However, this never happens in practice, so the ideal real overlap is achieved when the full <code>attn_i</code> is overlapped with a part of the communication, then to start the computation with <code>K_j</code> and <code>V_j</code>, we wait for the all-gather to finish.`,ht,oe,dt,re,al="All-to-all, or sometimes called <code>ring-rotation</code> utilizes a ring-like communication pattern. After concluding <code>attn_i</code> computation, an all-to-all is launched to send <code>K_i</code> and <code>V_i</code> to the neighbouring ranks. We then repeat this <code>context_parallel_size-1</code> times, so that each rank sees all the shards of <code>K</code> and <code>V</code> from all other ranks once. In ideal scenario, we prefetch shards <code>K_i+1</code> and <code>V_i+1</code> from the neighbouring rank and this communication is exactly overlapped with computation of our current <code>attn_i</code>. Again, realistically, this perfect overlap doesn’t ever happen. Given the nature of this approach, if we don’t achieve perfect overlap, the penalty is way larger than with all-gather.",pt,ce,mt,he,il='In theory, all-to-all should be the better choice. Though in practice, it rarely is. Therefore, we default to all-gather, as it’s more likely to achieve better performance. Extensive <a href="https://discuss.pytorch.org/t/distributed-w-torchtitan-breaking-barriers-training-long-context-llms-with-1m-sequence-length-in-pytorch-using-context-parallel/215082" rel="nofollow">benchmarks</a> from the <code>torchtitan</code> team also show that all-to-all rarely outperforms all-gather. Though, we still provide both options, as you might find one to be better for your use case.',ut,de,nl="You can directly see this issue in the profiler output in the image below:",ft,v,sl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_all_to_all.png" alt="all-to-all profiler output"/> <br/> <em>Figure 1: In red you can see the idle time, while we wait for the all-to-all kernel to finish. Highlighted in the first blue bar, you can see that it takes ~250us to finish, which is repeated N-1 times for each attention call, where N is the context parallel size.</em>',yt,pe,gt,me,ol=`We only support context parallelism with <code>FSDP2</code>, as we create a joint mesh of <code>context_parallel_size</code> and <code>dp_shard_size</code> to
utilize its full potential.
How it works is: we shard the model across the joint mesh of size <code>cp_size*dp_shard_size</code>, which maximizes the memory savings.
This is a “free lunch” of sorts, as <code>FSDP</code> communication is fully overlapped with the computation of attention, as shown in the images below.`,wt,j,rl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/accelerate/examples/fsdp2/cp_why_fsdp2.png" alt="why FSDP2+CP"/> <br/> <em>Figure 2: In blue rectangles (Stream 23), you can see that the pre-fetch of `FSDP` shard is fully overlapped with the computation of attention (Stream 7), while in red rectangles (Stream 24), you can see that the all-gather kernel results in a bubble of idle time, in which our compute stream (7) is idle.</em>',Mt,ue,cl="In the figure above, you can also note the difference between all-to-all and all-gather. While in all-to-all (Figure 1), we launch a communication kernel N-1 times for each attention call, in all-gather (Figure 2), we launch a communication kernel only once. This results in a bigger bubble, but it only happens once per attention call, while in all-to-all, it happens N-1 times.",bt,fe,Tt,ye,hl=`We make sure to dispatch the same batch of data to the whole <code>cp</code> subgroup, so that the results are correct. (Meaning each rank in <code>cp</code> subgroup gets the same batch of data.) However, we also dispatch different batches to each rank of <code>dp_shard</code> group.
Imagine it like this:`,xt,ge,_t,we,$t,xe,Ut;return k=new gl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new y({props:{title:"Context Parallel in 🤗 accelerate",local:"context-parallel-in--accelerate",headingTag:"h1"}}),I=new y({props:{title:"Why context parallelism?",local:"why-context-parallelism",headingTag:"h2"}}),W=new y({props:{title:"How to use context parallelism?",local:"how-to-use-context-parallelism",headingTag:"h2"}}),B=new be({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBQYXJhbGxlbGlzbUNvbmZpZyUyQyUyMFRvcmNoQ29udGV4dFBhcmFsbGVsQ29uZmlnJTBBJTBBJTJCJTIwY3BfY29uZmlnJTIwJTNEJTIwVG9yY2hDb250ZXh0UGFyYWxsZWxDb25maWcoJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3BfY29tbV9zdHJhdGVneSUzRCUyMmFsbHRvYWxsJTIyJTJDJTIwJTIzJTIwbm8lMjBuZWVkJTIwdG8lMjB1c2UlMjBjcF9jb25maWclMjBhdCUyMGFsbCUyQyUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdGhlJTIwZGVmYXVsdCUyMCUyMmFsbGdhdGhlciUyMiUwQSUyQiUyMCklMEElMEElMkIlMjBwYXJhbGxlbGlzbV9jb25maWclMjAlM0QlMjBQYXJhbGxlbGlzbUNvbmZpZyglMEElMkIlMjAlMjAlMjAlMjAlMjBjcF9zaXplJTNEOCUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMGNwX2hhbmRsZXIlM0RjcF9jb25maWclMkMlMjAlMjAlMjMlMjBvciUyMGp1c3QlMjBjcF9zaXplJTNEOCUyQyUyMGlmJTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdGhlJTIwZGVmYXVsdCUyMCUyMmFsbGdhdGhlciUyMiUwQSUyQiUyMCklMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHBhcmFsbGVsaXNtX2NvbmZpZyUzRHBhcmFsbGVsaXNtX2NvbmZpZyUyQyUwQSk=",highlighted:`from accelerate.utils import ParallelismConfig, TorchContextParallelConfig

<span class="hljs-addition">+ cp_config = TorchContextParallelConfig(</span>
<span class="hljs-addition">+       cp_comm_strategy=&quot;alltoall&quot;, # no need to use cp_config at all, if you want to use the default &quot;allgather&quot;</span>
<span class="hljs-addition">+ )</span>

<span class="hljs-addition">+ parallelism_config = ParallelismConfig(</span>
<span class="hljs-addition">+     cp_size=8,</span>
<span class="hljs-addition">+     cp_handler=cp_config,  # or just cp_size=8, if you want to use the default &quot;allgather&quot;</span>
<span class="hljs-addition">+ )</span>

accelerator = Accelerator(
    ...,
    parallelism_config=parallelism_config,
)`,wrap:!1}}),V=new be({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tcGFyYWxsZWxpc20tY29uZmlnLWNwLXNpemUlMjA4JTIwLS1wYXJhbGxlbGlzbS1jb25maWctY3AtY29tbS1zdHJhdGVneSUyMCU1QmFsbGdhdGhlciU3Q2FsbHRvYWxsJTVEJTIwLi4u",highlighted:"accelerate launch --parallelism-config-cp-size 8 --parallelism-config-cp-comm-strategy [allgather|alltoall] ...",wrap:!1}}),P=new be({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMGRhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IubWF5YmVfY29udGV4dF9wYXJhbGxlbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBidWZmZXJzJTNEJTVCYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBiYXRjaCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVmZmVyX3NlcV9kaW1zJTNEJTVCMSUyQyUyMDElNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub19yZXN0b3JlX2J1ZmZlcnMlM0QlN0JiYXRjaCU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
    <span class="hljs-keyword">with</span> accelerator.maybe_context_parallel(
        buffers=[batch[<span class="hljs-string">&quot;input_ids&quot;</span>], batch[<span class="hljs-string">&quot;attention_mask&quot;</span>]],
        buffer_seq_dims=[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
        no_restore_buffers={batch[<span class="hljs-string">&quot;input_ids&quot;</span>], batch[<span class="hljs-string">&quot;labels&quot;</span>]},
    ):
        outputs = model(**batch)
        ...`,wrap:!1}}),Y=new be({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tdXNlLWZzZHAlMjAtLWZzZHAtYWN0aXZhdGlvbi1jaGVja3BvaW50aW5nJTNEVFJVRSUyMGV4YW1wbGVzJTJGZnNkcDIlMkZuZF9wYXJhbGxlbC5weSUyMC0tY3Atc2l6ZSUzRDglMjAtLXNlcXVlbmNlLWxlbmd0aCUzRDEyODAwMA==",highlighted:"accelerate launch --use-fsdp --fsdp-activation-checkpointing=TRUE examples/fsdp2/nd_parallel.py --cp-size=8 --sequence-length=128000",wrap:!1}}),A=new y({props:{title:"Accelerate’s interface",local:"accelerates-interface",headingTag:"h2"}}),E=new y({props:{title:"Configurable options",local:"configurable-options",headingTag:"h2"}}),K=new y({props:{title:"Technical details",local:"technical-details",headingTag:"h2"}}),ee=new y({props:{title:"So how does it work?",local:"so-how-does-it-work",headingTag:"h2"}}),ae=new be({props:{code:"Y29tbV9rZXJuZWwlMjAlM0QlMjAlN0IlMjJhbGxnYXRoZXIlMjIlM0ElMjBhbGxnYXRoZXIlMkMlMjAlMjJhbGx0b2FsbCUyMiUzQSUyMGFsbHRvYWxsJTdEJTVCY29udGV4dF9wYXJhbGxlbF9zaGFyZF9yb3RhdGlvbiU1RCUwQVFpJTJDJTIwS2klMkMlMjBWaSUyMCUzRCUyMHNoYXJkKFElMkMlMjBLJTJDJTIwViUyQyUyMHNlcV9kaW0pJTBBYXR0biU1QmklNUQlMjAlM0QlMjBhdHRuKFFpJTJDJTIwS2klMkMlMjBWaSklMEFmb3IlMjBqJTIwaW4lMjByYW5nZShjb250ZXh0X3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwS2olMkMlMjBWaiUyMCUzRCUyMGNvbW1fa2VybmVsKCklMEElMjAlMjAlMjAlMjBhdHRuJTVCaiU1RCUyMCUzRCUyMGF0dG4oUWklMkMlMjBLaiUyQyUyMFZqKSUyMCUyMyUyMCU1QmJhdGNoJTJDJTIwbnVtX2hlYWRzJTJDJTIwc2VxX2xlbiUyMCUyRiUyRiUyMGNvbnRleHRfcGFyYWxsZWxfc2l6ZSUyQyUyMGhlYWRfZGltJTVEJTBBJTBBZmluYWxfYXR0biUyMCUzRCUyMGNvbWJpbmUoYXR0bik=",highlighted:`comm_kernel = {<span class="hljs-string">&quot;allgather&quot;</span>: allgather, <span class="hljs-string">&quot;alltoall&quot;</span>: alltoall}[context_parallel_shard_rotation]
Qi, Ki, Vi = shard(Q, K, V, seq_dim)
attn[i] = attn(Qi, Ki, Vi)
<span class="hljs-keyword">for</span> j <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(context_parallel_size):
    Kj, Vj = comm_kernel()
    attn[j] = attn(Qi, Kj, Vj) <span class="hljs-comment"># [batch, num_heads, seq_len // context_parallel_size, head_dim]</span>

final_attn = combine(attn)`,wrap:!1}}),ie=new y({props:{title:"all-to-all vs all-gather",local:"all-to-all-vs-all-gather",headingTag:"h2"}}),ne=new y({props:{title:"all-gather",local:"all-gather",headingTag:"h3"}}),oe=new y({props:{title:"all-to-all",local:"all-to-all",headingTag:"h3"}}),ce=new y({props:{title:"How to choose the right rotation method?",local:"how-to-choose-the-right-rotation-method",headingTag:"h2"}}),pe=new y({props:{title:"Why only FSDP2?",local:"why-only-fsdp2",headingTag:"h2"}}),fe=new y({props:{title:"Data dispatching in joint mesh",local:"data-dispatching-in-joint-mesh",headingTag:"h2"}}),ge=new be({props:{code:"YW5kJTIwc28lMjBvbi4=",highlighted:`<span class="hljs-comment"># 8 GPUS, --dp_shard_size 4, --cp_size 2</span>
<span class="hljs-comment"># mesh = [[0, 1], [2, 3], [4, 5], [6, 7]]</span>
<span class="hljs-comment"># model is sharded across the whole mesh (each GPU holds 1/8 of the model)</span>
<span class="hljs-comment"># GPUs 0,1 = batch 0</span>
<span class="hljs-comment"># GPUs 2,3 = batch 1</span>
... <span class="hljs-keyword">and</span> so <span class="hljs-keyword">on</span>.`,wrap:!1}}),we=new wl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/context_parallelism.md"}}),{c(){g=s("meta"),_e=i(),Te=s("p"),$e=i(),c(k.$$.fragment),Ue=i(),c(J.$$.fragment),Ce=i(),G=s("p"),G.innerHTML=Gt,ve=i(),H=s("p"),H.innerHTML=Ht,je=i(),c(I.$$.fragment),ke=i(),L=s("p"),L.innerHTML=It,Je=i(),q=s("p"),q.textContent=Lt,Ge=i(),c(W.$$.fragment),He=i(),c(B.$$.fragment),Ie=i(),z=s("p"),z.innerHTML=qt,Le=i(),c(V.$$.fragment),qe=i(),M=s("blockquote"),M.innerHTML=Wt,We=i(),b=s("blockquote"),b.innerHTML=Bt,Be=i(),T=s("blockquote"),T.innerHTML=zt,ze=i(),x=s("blockquote"),x.innerHTML=Vt,Ve=i(),F=s("p"),F.innerHTML=Ft,Fe=i(),c(P.$$.fragment),Pe=i(),_=s("blockquote"),_.innerHTML=Pt,Qe=i(),Q=s("p"),Q.textContent=Qt,Ye=i(),$=s("p"),$.innerHTML=Yt,Ae=i(),w=s("blockquote"),Me=s("p"),Me.innerHTML=At,vt=i(),c(Y.$$.fragment),Se=i(),c(A.$$.fragment),Ze=i(),S=s("p"),S.textContent=St,Ee=i(),Z=s("ul"),Z.innerHTML=Zt,Ne=i(),U=s("blockquote"),U.innerHTML=Et,Xe=i(),c(E.$$.fragment),Re=i(),N=s("p"),N.innerHTML=Nt,De=i(),X=s("ul"),X.innerHTML=Xt,Ke=i(),R=s("p"),R.textContent=Rt,Oe=i(),D=s("p"),D.innerHTML=Dt,et=i(),c(K.$$.fragment),tt=i(),C=s("blockquote"),C.innerHTML=Kt,lt=i(),O=s("p"),O.innerHTML=Ot,at=i(),c(ee.$$.fragment),it=i(),te=s("p"),te.innerHTML=el,nt=i(),le=s("p"),le.textContent=tl,st=i(),c(ae.$$.fragment),ot=i(),c(ie.$$.fragment),rt=i(),c(ne.$$.fragment),ct=i(),se=s("p"),se.innerHTML=ll,ht=i(),c(oe.$$.fragment),dt=i(),re=s("p"),re.innerHTML=al,pt=i(),c(ce.$$.fragment),mt=i(),he=s("p"),he.innerHTML=il,ut=i(),de=s("p"),de.textContent=nl,ft=i(),v=s("p"),v.innerHTML=sl,yt=i(),c(pe.$$.fragment),gt=i(),me=s("p"),me.innerHTML=ol,wt=i(),j=s("p"),j.innerHTML=rl,Mt=i(),ue=s("p"),ue.textContent=cl,bt=i(),c(fe.$$.fragment),Tt=i(),ye=s("p"),ye.innerHTML=hl,xt=i(),c(ge.$$.fragment),_t=i(),c(we.$$.fragment),$t=i(),xe=s("p"),this.h()},l(e){const t=yl("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),_e=n(e),Te=o(e,"P",{}),jt(Te).forEach(l),$e=n(e),h(k.$$.fragment,e),Ue=n(e),h(J.$$.fragment,e),Ce=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1vuwxvs"&&(G.innerHTML=Gt),ve=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-vuhqzj"&&(H.innerHTML=Ht),je=n(e),h(I.$$.fragment,e),ke=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-2sleob"&&(L.innerHTML=It),Je=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1u7kh92"&&(q.textContent=Lt),Ge=n(e),h(W.$$.fragment,e),He=n(e),h(B.$$.fragment,e),Ie=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1e2e60n"&&(z.innerHTML=qt),Le=n(e),h(V.$$.fragment,e),qe=n(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1ncmwz6"&&(M.innerHTML=Wt),We=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1io1dbt"&&(b.innerHTML=Bt),Be=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1ww4gnq"&&(T.innerHTML=zt),ze=n(e),x=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1vriq5e"&&(x.innerHTML=Vt),Ve=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-q27r1v"&&(F.innerHTML=Ft),Fe=n(e),h(P.$$.fragment,e),Pe=n(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-1git15w"&&(_.innerHTML=Pt),Qe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-l1hp35"&&(Q.textContent=Qt),Ye=n(e),$=o(e,"P",{align:!0,"data-svelte-h":!0}),r($)!=="svelte-zw16sw"&&($.innerHTML=Yt),Ae=n(e),w=o(e,"BLOCKQUOTE",{class:!0});var Ct=jt(w);Me=o(Ct,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-7kbx6m"&&(Me.innerHTML=At),vt=n(Ct),h(Y.$$.fragment,Ct),Ct.forEach(l),Se=n(e),h(A.$$.fragment,e),Ze=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-jcewir"&&(S.textContent=St),Ee=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1npdv1z"&&(Z.innerHTML=Zt),Ne=n(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-1kfcjij"&&(U.innerHTML=Et),Xe=n(e),h(E.$$.fragment,e),Re=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-tidq8o"&&(N.innerHTML=Nt),De=n(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-19ddlaf"&&(X.innerHTML=Xt),Ke=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-pt2d1o"&&(R.textContent=Rt),Oe=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-8bfpem"&&(D.innerHTML=Dt),et=n(e),h(K.$$.fragment,e),tt=n(e),C=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-1f1d7d3"&&(C.innerHTML=Kt),lt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-5gcsxu"&&(O.innerHTML=Ot),at=n(e),h(ee.$$.fragment,e),it=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1q8d3hy"&&(te.innerHTML=el),nt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-17jpam7"&&(le.textContent=tl),st=n(e),h(ae.$$.fragment,e),ot=n(e),h(ie.$$.fragment,e),rt=n(e),h(ne.$$.fragment,e),ct=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-6a32kj"&&(se.innerHTML=ll),ht=n(e),h(oe.$$.fragment,e),dt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-jzgpzc"&&(re.innerHTML=al),pt=n(e),h(ce.$$.fragment,e),mt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1kj70ku"&&(he.innerHTML=il),ut=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ldmtvt"&&(de.textContent=nl),ft=n(e),v=o(e,"P",{align:!0,"data-svelte-h":!0}),r(v)!=="svelte-1c3ofsn"&&(v.innerHTML=sl),yt=n(e),h(pe.$$.fragment,e),gt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ikc9rn"&&(me.innerHTML=ol),wt=n(e),j=o(e,"P",{align:!0,"data-svelte-h":!0}),r(j)!=="svelte-1jnhmn3"&&(j.innerHTML=rl),Mt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-10ujnkx"&&(ue.textContent=cl),bt=n(e),h(fe.$$.fragment,e),Tt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-14bdjd0"&&(ye.innerHTML=hl),xt=n(e),h(ge.$$.fragment,e),_t=n(e),h(we.$$.fragment,e),$t=n(e),xe=o(e,"P",{}),jt(xe).forEach(l),this.h()},h(){f(g,"name","hf:doc:metadata"),f(g,"content",bl),f(M,"class","tip"),f(b,"class","tip"),f(T,"class","warning"),f(x,"class","warning"),f(_,"class","warning"),f($,"align","center"),f(w,"class","tip"),f(U,"class","warning"),f(C,"class","tip"),f(v,"align","center"),f(j,"align","center")},m(e,t){kt(document.head,g),a(e,_e,t),a(e,Te,t),a(e,$e,t),d(k,e,t),a(e,Ue,t),d(J,e,t),a(e,Ce,t),a(e,G,t),a(e,ve,t),a(e,H,t),a(e,je,t),d(I,e,t),a(e,ke,t),a(e,L,t),a(e,Je,t),a(e,q,t),a(e,Ge,t),d(W,e,t),a(e,He,t),d(B,e,t),a(e,Ie,t),a(e,z,t),a(e,Le,t),d(V,e,t),a(e,qe,t),a(e,M,t),a(e,We,t),a(e,b,t),a(e,Be,t),a(e,T,t),a(e,ze,t),a(e,x,t),a(e,Ve,t),a(e,F,t),a(e,Fe,t),d(P,e,t),a(e,Pe,t),a(e,_,t),a(e,Qe,t),a(e,Q,t),a(e,Ye,t),a(e,$,t),a(e,Ae,t),a(e,w,t),kt(w,Me),kt(w,vt),d(Y,w,null),a(e,Se,t),d(A,e,t),a(e,Ze,t),a(e,S,t),a(e,Ee,t),a(e,Z,t),a(e,Ne,t),a(e,U,t),a(e,Xe,t),d(E,e,t),a(e,Re,t),a(e,N,t),a(e,De,t),a(e,X,t),a(e,Ke,t),a(e,R,t),a(e,Oe,t),a(e,D,t),a(e,et,t),d(K,e,t),a(e,tt,t),a(e,C,t),a(e,lt,t),a(e,O,t),a(e,at,t),d(ee,e,t),a(e,it,t),a(e,te,t),a(e,nt,t),a(e,le,t),a(e,st,t),d(ae,e,t),a(e,ot,t),d(ie,e,t),a(e,rt,t),d(ne,e,t),a(e,ct,t),a(e,se,t),a(e,ht,t),d(oe,e,t),a(e,dt,t),a(e,re,t),a(e,pt,t),d(ce,e,t),a(e,mt,t),a(e,he,t),a(e,ut,t),a(e,de,t),a(e,ft,t),a(e,v,t),a(e,yt,t),d(pe,e,t),a(e,gt,t),a(e,me,t),a(e,wt,t),a(e,j,t),a(e,Mt,t),a(e,ue,t),a(e,bt,t),d(fe,e,t),a(e,Tt,t),a(e,ye,t),a(e,xt,t),d(ge,e,t),a(e,_t,t),d(we,e,t),a(e,$t,t),a(e,xe,t),Ut=!0},p:pl,i(e){Ut||(p(k.$$.fragment,e),p(J.$$.fragment,e),p(I.$$.fragment,e),p(W.$$.fragment,e),p(B.$$.fragment,e),p(V.$$.fragment,e),p(P.$$.fragment,e),p(Y.$$.fragment,e),p(A.$$.fragment,e),p(E.$$.fragment,e),p(K.$$.fragment,e),p(ee.$$.fragment,e),p(ae.$$.fragment,e),p(ie.$$.fragment,e),p(ne.$$.fragment,e),p(oe.$$.fragment,e),p(ce.$$.fragment,e),p(pe.$$.fragment,e),p(fe.$$.fragment,e),p(ge.$$.fragment,e),p(we.$$.fragment,e),Ut=!0)},o(e){m(k.$$.fragment,e),m(J.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(V.$$.fragment,e),m(P.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(pe.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),Ut=!1},d(e){e&&(l(_e),l(Te),l($e),l(Ue),l(Ce),l(G),l(ve),l(H),l(je),l(ke),l(L),l(Je),l(q),l(Ge),l(He),l(Ie),l(z),l(Le),l(qe),l(M),l(We),l(b),l(Be),l(T),l(ze),l(x),l(Ve),l(F),l(Fe),l(Pe),l(_),l(Qe),l(Q),l(Ye),l($),l(Ae),l(w),l(Se),l(Ze),l(S),l(Ee),l(Z),l(Ne),l(U),l(Xe),l(Re),l(N),l(De),l(X),l(Ke),l(R),l(Oe),l(D),l(et),l(tt),l(C),l(lt),l(O),l(at),l(it),l(te),l(nt),l(le),l(st),l(ot),l(rt),l(ct),l(se),l(ht),l(dt),l(re),l(pt),l(mt),l(he),l(ut),l(de),l(ft),l(v),l(yt),l(gt),l(me),l(wt),l(j),l(Mt),l(ue),l(bt),l(Tt),l(ye),l(xt),l(_t),l($t),l(xe)),l(g),u(k,e),u(J,e),u(I,e),u(W,e),u(B,e),u(V,e),u(P,e),u(Y),u(A,e),u(E,e),u(K,e),u(ee,e),u(ae,e),u(ie,e),u(ne,e),u(oe,e),u(ce,e),u(pe,e),u(fe,e),u(ge,e),u(we,e)}}}const bl='{"title":"Context Parallel in 🤗 accelerate","local":"context-parallel-in--accelerate","sections":[{"title":"Why context parallelism?","local":"why-context-parallelism","sections":[],"depth":2},{"title":"How to use context parallelism?","local":"how-to-use-context-parallelism","sections":[],"depth":2},{"title":"Accelerate’s interface","local":"accelerates-interface","sections":[],"depth":2},{"title":"Configurable options","local":"configurable-options","sections":[],"depth":2},{"title":"Technical details","local":"technical-details","sections":[],"depth":2},{"title":"So how does it work?","local":"so-how-does-it-work","sections":[],"depth":2},{"title":"all-to-all vs all-gather","local":"all-to-all-vs-all-gather","sections":[{"title":"all-gather","local":"all-gather","sections":[],"depth":3},{"title":"all-to-all","local":"all-to-all","sections":[],"depth":3}],"depth":2},{"title":"How to choose the right rotation method?","local":"how-to-choose-the-right-rotation-method","sections":[],"depth":2},{"title":"Why only FSDP2?","local":"why-only-fsdp2","sections":[],"depth":2},{"title":"Data dispatching in joint mesh","local":"data-dispatching-in-joint-mesh","sections":[],"depth":2}],"depth":1}';function Tl(Jt){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends ul{constructor(g){super(),fl(this,g,Tl,Ml,dl,{})}}export{Cl as component};
