import{s as Xl,n as Wl,o as Fl}from"../chunks/scheduler.b9285784.js";import{S as Vl,i as Hl,e as i,s as a,c,h as Ql,a as o,d as s,b as n,f as Sl,g as r,j as p,k as nl,l as $l,m as t,n as M,t as d,o as h,p as m}from"../chunks/index.26bc89a1.js";import{C as ql,H as oe,E as Ll}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.65596716.js";import{C as pe}from"../chunks/CodeBlock.fd6e4a0e.js";function Rl(il){let u,Me,ce,de,T,he,f,me,U,ol="This guide will cover basics of using sequence parallelism in 🤗<code>accelerate</code>.",ue,J,pl='See also the very related <a href="./context_parallelism.md">Context Parallellism</a>.',ye,b,we,j,cl=`With the advent of large language models, and recently reasoning models, the sequence length has been growing rapidly. This, combined with quadratic memory complexity of attention, has led to a need for more efficient ways to train models with long sequences.
With sequence length of 128k, the memory requirement of the attention matrix is <code>128k * 128k * 2 bytes * num_heads = ~32 GB * num_heads</code> for <code>bf16</code> precision, given vanilla attention implementation. Granted, with usage of <code>flash attention</code> or <code>SDPA</code> which do not materialize these attention weights, this decreases drastically, but the growth in memory requirements is still considerable.`,Te,_,rl='Ulysses Sequence parallelism allows us to shard the inputs to the attention computation along the sequence dimension and compute the attention normally, but using only a slice of attention heads on each GPU. With this, we can train models with long sequences, with a few more tools, scaling to 15M+ sequence length. To see how to augment Ulysses SP with TiledMLP, Liger-Kernel, Activation checkpoint offload to cpu and a few other tricks pleae refer to the paper: <a href="https://arxiv.org/abs/2506.13996" rel="nofollow">Arctic Long Sequence Training: Scalable And Efficient Training For Multi-Million Token Sequences</a>.',fe,g,Ue,C,Ml='In the document <a href="./context_parallelism.md">Context Parallellism</a> you can learn about deploying another technology called Context Parallelism, which too slices on the sequence dimension but uses Ring Attention instead of slicing on the head dimension.',Je,I,dl="The following articles go into a very detailed explanation of the differences between the two technologies:",be,A,hl='<li><a href="https://insujang.github.io/2024-01-11/tensor-parallelism-and-sequence-parallelism-detailed-analysis/" rel="nofollow">https://insujang.github.io/2024-01-11/tensor-parallelism-and-sequence-parallelism-detailed-analysis/</a></li> <li><a href="https://huggingface.co/blog/exploding-gradients/ulysses-ring-attention" rel="nofollow">https://huggingface.co/blog/exploding-gradients/ulysses-ring-attention</a></li>',je,G,ml="A quick summary adapting from one of the articles:",_e,v,ul="<li>Ulysses SP has a relatively low communication overhead, but is limited by the number of Attention Heads and thus it has certain requirements for network topology (number of attention heads has has to be divisible by the number of participating gpus for a single replica). All-to-all communication is sensitive to latency and it requires Deepspeed.</li> <li>FSDP CP Ring-Attention’s P2P ring communication has no aforementioned divisibilty requirements, but has a higher communication volume.</li>",ge,Z,yl='Finally it should be possible to combine SP + CP as explained in the paper <a href="https://arxiv.org/abs/2405.07719" rel="nofollow">USP: A Unified Sequence Parallelism Approach for Long Context Generative AI</a> to support an even longer sequence length, albeit this is not yet integrated into 🤗<code>accelerate</code>.',Ce,B,Ie,z,wl='Currently the only sequence parallelism backend is <code>deepspeed</code>, which comes from the modernized Ulysses SP which is part of the <a href="https://arxiv.org/abs/2506.13996" rel="nofollow">Arctic Long Sequence Training technology</a>. There is also a <a href="https://www.deepspeed.ai/tutorials/ulysses-alst-sequence-parallelism/" rel="nofollow">tutorial</a> should you want to integrate it into your own code directly.',Ae,E,Ge,k,ve,N,Tl="As with any other feature in 🤗<code>accelerate</code>, you can enable sequence parallelism also by passing the corresponding flags to <code>accelerate launch</code>. In this case, it’s no different:",Ze,x,Be,y,fl="<p>You can also set the <code>sp_size</code> and other configuration in the <code>accelerate config</code> command, which will save them in your <code>accelerate</code> configuration file, so you don’t have to pass them every time you launch your script.</p>",ze,w,Ul=`<p>sequence parallelism combines with data parallelism. It doesn’t require additional GPUs.
So if you have 8 gpus you can do: <code>--parallelism-config-dp-shard-size 8 --parallelism-config-sp-size 8</code>. Or you can use the <code>ParallelismConfig</code> class to set them programmatically.</p> <p><strong>Important</strong>: You must ensure <code>dp_replicate_size × dp_shard_size × sp_size = num_processes</code>. For example, with 8 GPUs and <code>sp_size=8</code>, you need <code>dp_shard_size=1</code> (since 1 × 1 × 8 = 8). With 4 GPUs and <code>sp_size=2</code>, you could use <code>dp_shard_size=2</code> (since 1 × 2 × 2 = 4) for 2D parallelism.</p>`,Ee,S,ke,X,Jl='ALST/UlyssesSP implements sequence parallelism using attention head parallelism, as explained in <a href="https://arxiv.org/abs/2506.13996" rel="nofollow">this paper</a>. For simplicity, we reuse the concept and setup of sequence parallelism, which, from the user’s perspective, is the same: multiple GPUs are used to process a single batch.',Ne,W,bl='To give a sense of what ALST made possible - it allowed us to train in bf16 with 500K tokens on a single H100 GPU, 3.7M on a single node, and 15M on Llama-8B using just four nodes. This feature of HF Accelerate enables only 1 of the 3 ALST components, so the achievable sequence length will be smaller. You’d want TiledMLP, Activation checkpoint offload to CPU, and a few other things enabled to get the full power of ALST. For details, please refer to <a href="https://www.deepspeed.ai/tutorials/ulysses-alst-sequence-parallelism/" rel="nofollow">this tutorial</a>.',xe,F,jl="To configure the <code>deepspeed</code> backend:",Se,V,Xe,H,_l="<li><code>sp_backend</code>: set to <code>deepspeed</code> here</li> <li><code>sp_size</code> is the degree of the sequence parallelism - in the above example it’s 4, therefore 4 gpus will be used to process a single batch (while doing DP=4 over the same gpus)</li> <li><code>sp_seq_length</code> and <code>sp_seq_length_is_variable</code> are used to deal with sequence lengths. If <code>sp_seq_length_is_variable=True</code> the backend will work with a sequence length that may change between batches, in which case <code>sp_seq_length</code> value can be set to anything divisible by the sequence parallel degree or not set at all. In this case on every <code>forward</code> the sequence variables will be derived from input. If <code>False</code> then <code>seq_length</code> needs to match the batch’s sequence length dimension, which then will have to be padded to be always the same. The default is <code>True</code>.</li> <li><code>sp_attn_implementation</code> is one of <code>sdpa</code>, <code>flash_attention_2</code> or <code>flash_attention_3</code>. This sequence parallel implementation uses <code>position_ids</code> instead of <code>attention_mask</code> therefore, <code>eager</code> can’t work here until it supports working with <code>position_ids</code>. Also, please note that <code>sdpa</code> doesn’t handle multiple samples combined into one correctly; it will attend to the whole sample as one. If the samples aren’t combined, <code>sdpa</code> will work correctly. Therefore, Flash Attention should be the ideal choice as it always works.</li>",We,Q,gl="Instead of setting these values in <code>DeepSpeedSequenceParallelConfig</code> object, you can also use the environment variables to accomplish the same - here they are correspondingly to the end of the list above.",Fe,$,Cl="<li><code>PARALLELISM_CONFIG_SP_BACKEND</code></li> <li><code>PARALLELISM_CONFIG_SP_SEQ_LENGTH</code></li> <li><code>PARALLELISM_CONFIG_SP_SEQ_LENGTH_IS_VARIABLE</code></li> <li><code>PARALLELISM_CONFIG_SP_ATTN_IMPLEMENTATION</code></li>",Ve,q,Il="If not passed in the code, <code>sp_size</code> can be set via <code>--parallelism_config_sp_size</code> CLI argument. Same for other arguments. You can also do the accelerate config file style config, e.g., for 2 GPUs:",He,L,Qe,R,Al="As mentioned earlier Ulysses sequence parallelism is normally overlayed with data parallelism - same ranks are used for feeding unique data streams and also perform Ulysses Sequence Parallelism. But you could also create replicas like so:",$e,Y,qe,P,Gl="Here we use 4 gpus, with 2 sequence parallelism replicas. Deepspeed-ZeRO is what drives the data parallelism here.",Le,D,vl='Please note that a lot of magic is hidden inside <a href="https://github.com/deepspeedai/DeepSpeed/blob/64c0052fa08438b4ecf4cae30af15091a92d2108/deepspeed/runtime/sequence_parallel/ulysses_sp.py#L442" rel="nofollow">UlyssesSPDataLoaderAdapter</a>. It’s used behind the scenes, wrapping your original DataLoader object, but you should be aware of it should you run into any problems. It also automatically injects the correct <code>shift_labels</code> into the batch dictionary, before the batch gets sharded across the participating ranks.',Re,K,Zl="Now the only remaining piece to start using ALST/UlyssesSP is to aggregate the loss across ranks using a differentiable <code>all_gather</code> to get the grads right. The following code does it, while also excluding any masked out with <code>-100</code> tokens, to get the correct average:",Ye,O,Pe,ee,Bl='If you use <a href="https://github.com/linkedin/Liger-Kernel" rel="nofollow">Liger Kernel</a> it already knows how to handle <code>shift_labels</code> so you don’t need to go through manual loss calculation, just calling <code>model(**batch)</code> will already get the <code>loss</code> calculated and done in a very memory-efficient way. If you didn’t know about Liger-Kernel - it’s highly recommended to be used especially for long sequence length, since it liberates a lot of working GPU memory that can be used for handling longer sequences. For example, it performs a fused logit-loss computation, never manifesting the full logits tensor in memory.',De,le,zl='If you want to see what HF Accelerate did behind the scenes please read <a href="https://www.deepspeed.ai/tutorials/ulysses-alst-sequence-parallelism/" rel="nofollow">this full integration tutorial</a>.',Ke,se,El='For an example of an Accelerate training loop with enabled ALST/UlyssesSP see <a href="https://github.com/huggingface/accelerate/blob/main/examples/alst_ulysses_sequence_parallelism" rel="nofollow">examples/alst_ulysses_sequence_parallelism</a>.',Oe,te,kl="[!Warning]",el,ae,Nl="<p>This API is quite new and still in its experimental stage. While we strive to provide a stable API, some small parts of the public API may change in the future.</p>",ll,ne,xl="Since this is a Deepspeed backend the usual Deepspeed configuration applies, so you can combine sequence parallelism with optimizer states and/or weights offloading as well to liberate more gpu memory and enable an even longer sequence length. This technology has been tested to work with DeepSpeed ZeRO stage 2 and 3.",sl,ie,tl,re,al;return T=new ql({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new oe({props:{title:"Sequence parallel in 🤗 accelerate",local:"sequence-parallel-in--accelerate",headingTag:"h1"}}),b=new oe({props:{title:"Why sequence parallelism?",local:"why-sequence-parallelism",headingTag:"h2"}}),g=new oe({props:{title:"How is Ulysses SP different from FSDP CP",local:"how-is-ulysses-sp-different-from-fsdp-cp",headingTag:"h2"}}),B=new oe({props:{title:"Supported sequence parallelism backends",local:"supported-sequence-parallelism-backends",headingTag:"h2"}}),E=new oe({props:{title:"How to use sequence parallelism?",local:"how-to-use-sequence-parallelism",headingTag:"h2"}}),k=new pe({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBQYXJhbGxlbGlzbUNvbmZpZyUyQyUyMERlZXBTcGVlZFNlcXVlbmNlUGFyYWxsZWxDb25maWclMEElMEElMkIlMjMlMjBFeGFtcGxlJTNBJTIwNCUyMEdQVXMlMjB3aXRoJTIwc3Bfc2l6ZSUzRDQlMkMlMjBkcF9zaGFyZF9zaXplJTNEMSUwQSUyQiUyMyUyMEVuc3VyZSUzQSUyMGRwX3JlcGxpY2F0ZV9zaXplJTIwJUMzJTk3JTIwZHBfc2hhcmRfc2l6ZSUyMCVDMyU5NyUyMHNwX3NpemUlMjAlM0QlMjAxJTIwJUMzJTk3JTIwMSUyMCVDMyU5NyUyMDQlMjAlM0QlMjA0JTIwR1BVcyUwQXBhcmFsbGVsaXNtX2NvbmZpZyUyMCUzRCUyMFBhcmFsbGVsaXNtQ29uZmlnKCUwQSUyQiUyMCUyMCUyMCUyMCUyMHNwX2JhY2tlbmQlM0QlMjJkZWVwc3BlZWQlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjBzcF9zaXplJTNENCUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMGRwX3NoYXJkX3NpemUlM0QxJTJDJTIwJTIwJTIzJTIwRXhwbGljaXQlM0ElMjBubyUyMGRhdGElMjBwYXJhbGxlbGlzbSUwQSUyQiUyMCUyMCUyMCUyMCUyMHNwX2hhbmRsZXIlM0REZWVwU3BlZWRTZXF1ZW5jZVBhcmFsbGVsQ29uZmlnKCUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwX3NlcV9sZW5ndGhfaXNfdmFyaWFibGUlM0ElMjB0cnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BfYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTJCJTIwKSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwcGFyYWxsZWxpc21fY29uZmlnJTNEcGFyYWxsZWxpc21fY29uZmlnJTJDJTBBKQ==",highlighted:`from accelerate.utils import ParallelismConfig, DeepSpeedSequenceParallelConfig

<span class="hljs-addition">+# Example: 4 GPUs with sp_size=4, dp_shard_size=1</span>
<span class="hljs-addition">+# Ensure: dp_replicate_size × dp_shard_size × sp_size = 1 × 1 × 4 = 4 GPUs</span>
parallelism_config = ParallelismConfig(
<span class="hljs-addition">+     sp_backend=&quot;deepspeed&quot;,</span>
<span class="hljs-addition">+     sp_size=4,</span>
<span class="hljs-addition">+     dp_shard_size=1,  # Explicit: no data parallelism</span>
<span class="hljs-addition">+     sp_handler=DeepSpeedSequenceParallelConfig(</span>
<span class="hljs-addition">+         sp_seq_length_is_variable: true,</span>
<span class="hljs-addition">+         sp_attn_implementation=&quot;sdpa&quot;,</span>
<span class="hljs-addition">+     ),</span>
<span class="hljs-addition">+ )</span>

accelerator = Accelerator(
    ...,
    parallelism_config=parallelism_config,
)`,wrap:!1}}),x=new pe({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tcGFyYWxsZWxpc20tY29uZmlnLXNwLXNpemUlMjA4JTIwJTIwLi4u",highlighted:"accelerate launch --parallelism-config-sp-size 8  ...",wrap:!1}}),S=new oe({props:{title:"ALST/Ulysses SP backend configuration",local:"alstulysses-sp-backend-configuration",headingTag:"h2"}}),V=new pe({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMDQlMjBHUFVzJTIwd2l0aCUyMHNwX3NpemUlM0Q0JTJDJTIwZHBfc2hhcmRfc2l6ZSUzRDElMEElMjMlMjBFbnN1cmUlM0ElMjBkcF9yZXBsaWNhdGVfc2l6ZSUyMCVDMyU5NyUyMGRwX3NoYXJkX3NpemUlMjAlQzMlOTclMjBzcF9zaXplJTIwJTNEJTIwMSUyMCVDMyU5NyUyMDElMjAlQzMlOTclMjA0JTIwJTNEJTIwNCUyMEdQVXMlMEFwYXJhbGxlbGlzbV9jb25maWclMjAlM0QlMjBQYXJhbGxlbGlzbUNvbmZpZyglMEElMjAlMjAlMjAlMjBzcF9iYWNrZW5kJTNEJTIyZGVlcHNwZWVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3Bfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBkcF9zaGFyZF9zaXplJTNEMSUyQyUyMCUyMCUyMyUyMEV4cGxpY2l0JTNBJTIwbm8lMjBkYXRhJTIwcGFyYWxsZWxpc20lMEElMjAlMjAlMjAlMjBzcF9oYW5kbGVyJTNERGVlcFNwZWVkU2VxdWVuY2VQYXJhbGxlbENvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcF9zZXFfbGVuZ3RoJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3Bfc2VxX2xlbmd0aF9pc192YXJpYWJsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcF9hdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyc2RwYSUyMiUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEEpJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBwYXJhbGxlbGlzbV9jb25maWclM0RwYXJhbGxlbGlzbV9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-comment"># Example: 4 GPUs with sp_size=4, dp_shard_size=1</span>
<span class="hljs-comment"># Ensure: dp_replicate_size × dp_shard_size × sp_size = 1 × 1 × 4 = 4 GPUs</span>
parallelism_config = ParallelismConfig(
    sp_backend=<span class="hljs-string">&quot;deepspeed&quot;</span>,
    sp_size=<span class="hljs-number">4</span>,
    dp_shard_size=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Explicit: no data parallelism</span>
    sp_handler=DeepSpeedSequenceParallelConfig(
        sp_seq_length=<span class="hljs-number">256</span>,
        sp_seq_length_is_variable=<span class="hljs-literal">True</span>,
        sp_attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>,
    ),
)
accelerator = Accelerator(
    ...,
    parallelism_config=parallelism_config,
)`,wrap:!1}}),L=new pe({props:{code:"ZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWRlZXBzcGVlZF9jb25maWclM0ElMEElMjAlMjBkZWVwc3BlZWRfY29uZmlnX2ZpbGUlM0ElMjBwYXRoJTJGdG8lMkZkc19jb25maWcuanNvbiUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEFwYXJhbGxlbGlzbV9jb25maWclM0ElMEElMjAlMjBwYXJhbGxlbGlzbV9jb25maWdfZHBfcmVwbGljYXRlX3NpemUlM0ElMjAxJTBBJTIwJTIwcGFyYWxsZWxpc21fY29uZmlnX2RwX3NoYXJkX3NpemUlM0ElMjAxJTIwJTIwJTIzJTIwTXVzdCUyMHNhdGlzZnklM0ElMjAxJTIwJUMzJTk3JTIwMSUyMCVDMyU5NyUyMDIlMjAlM0QlMjAyJTIwbnVtX3Byb2Nlc3NlcyUwQSUyMCUyMHBhcmFsbGVsaXNtX2NvbmZpZ19zcF9zaXplJTNBJTIwMiUwQSUyMCUyMHBhcmFsbGVsaXNtX2NvbmZpZ19zcF9iYWNrZW5kJTNBJTIwZGVlcHNwZWVkJTBBJTIwJTIwcGFyYWxsZWxpc21fY29uZmlnX3NwX3NlcV9sZW5ndGhfaXNfdmFyaWFibGUlM0ElMjB0cnVlJTBBJTIwJTIwcGFyYWxsZWxpc21fY29uZmlnX3NwX2F0dG5faW1wbGVtZW50YXRpb24lM0ElMjBzZHBhJTBB",highlighted:`<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">path/to/ds_config.json</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">parallelism_config:</span>
  <span class="hljs-attr">parallelism_config_dp_replicate_size:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">parallelism_config_dp_shard_size:</span> <span class="hljs-number">1</span>  <span class="hljs-comment"># Must satisfy: 1 × 1 × 2 = 2 num_processes</span>
  <span class="hljs-attr">parallelism_config_sp_size:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">parallelism_config_sp_backend:</span> <span class="hljs-string">deepspeed</span>
  <span class="hljs-attr">parallelism_config_sp_seq_length_is_variable:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">parallelism_config_sp_attn_implementation:</span> <span class="hljs-string">sdpa</span>
`,wrap:!1}}),Y=new pe({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMDQlMjBHUFVzJTIwd2l0aCUyMDJEJTIwcGFyYWxsZWxpc20lMjAoU1AlM0QyJTJDJTIwRFAlM0QyKSUwQSUyMyUyMEVuc3VyZSUzQSUyMGRwX3JlcGxpY2F0ZV9zaXplJTIwJUMzJTk3JTIwZHBfc2hhcmRfc2l6ZSUyMCVDMyU5NyUyMHNwX3NpemUlMjAlM0QlMjAyJTIwJUMzJTk3JTIwMSUyMCVDMyU5NyUyMDIlMjAlM0QlMjA0JTIwR1BVcyUwQXBhcmFsbGVsaXNtX2NvbmZpZyUyMCUzRCUyMFBhcmFsbGVsaXNtQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGRwX3JlcGxpY2F0ZV9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGRwX3NoYXJkX3NpemUlM0QxJTJDJTIwJTIwJTIzJTIwRXhwbGljaXQlM0ElMjBubyUyMHNoYXJkaW5nJTIwd2l0aGluJTIwcmVwbGljYXMlMEElMjAlMjAlMjAlMjBzcF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNwX2JhY2tlbmQlM0QlMjJkZWVwc3BlZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBzcF9oYW5kbGVyJTNERGVlcFNwZWVkU2VxdWVuY2VQYXJhbGxlbENvbmZpZyguLi4pJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Example: 4 GPUs with 2D parallelism (SP=2, DP=2)</span>
<span class="hljs-comment"># Ensure: dp_replicate_size × dp_shard_size × sp_size = 2 × 1 × 2 = 4 GPUs</span>
parallelism_config = ParallelismConfig(
    dp_replicate_size=<span class="hljs-number">2</span>,
    dp_shard_size=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Explicit: no sharding within replicas</span>
    sp_size=<span class="hljs-number">2</span>,
    sp_backend=<span class="hljs-string">&quot;deepspeed&quot;</span>,
    sp_handler=DeepSpeedSequenceParallelConfig(...),
)`,wrap:!1}}),O=new pe({props:{code:"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",highlighted:`sp_size = parallelism_config.sp_size <span class="hljs-keyword">if</span> parallelism_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-number">1</span>
<span class="hljs-keyword">if</span> sp_size &gt; <span class="hljs-number">1</span>:
    sp_group = accelerator.torch_device_mesh[<span class="hljs-string">&quot;sp&quot;</span>].get_group()
    sp_world_size = parallelism_config.sp_size

<span class="hljs-comment"># Normal training loop</span>
<span class="hljs-keyword">for</span> <span class="hljs-built_in">iter</span>, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dl):
    optimizer.zero_grad()

    batch = move_to_device(batch, model.device)
    outputs = model(**batch)

    <span class="hljs-comment"># only if not using liger-kernel</span>
    shift_labels = batch[<span class="hljs-string">&quot;shift_labels&quot;</span>]
    loss = unwrapped_model.loss_function(
        logits=outputs.logits,
        labels=<span class="hljs-literal">None</span>,
        shift_labels=shift_labels,
        vocab_size=unwrapped_model.config.vocab_size,
    )

    <span class="hljs-keyword">if</span> sp_size &gt; <span class="hljs-number">1</span>:
        <span class="hljs-comment"># differentiable weighted per-shard-loss aggregation across ranks</span>
        losses_per_rank = torch.distributed.nn.functional.all_gather(loss, group=sp_group)
        <span class="hljs-comment"># special dealing with SFT that has prompt tokens that aren&#x27;t used in loss computation</span>
        good_tokens = (shift_labels != -<span class="hljs-number">100</span>).view(-<span class="hljs-number">1</span>).<span class="hljs-built_in">sum</span>()
        good_tokens_per_rank = torch.distributed.nn.functional.all_gather(
            good_tokens, group=sp_group
        )
        <span class="hljs-comment"># Skip ranks with zero valid tokens to avoid NaN contamination (NaN * 0 = NaN)</span>
        total_loss = <span class="hljs-built_in">sum</span>(
            losses_per_rank[rank] * good_tokens_per_rank[rank]
            <span class="hljs-keyword">for</span> rank <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(sp_world_size)
            <span class="hljs-keyword">if</span> good_tokens_per_rank[rank] &gt; <span class="hljs-number">0</span>
        )
        total_good_tokens = <span class="hljs-built_in">sum</span>(good_tokens_per_rank)
        loss = total_loss / <span class="hljs-built_in">max</span>(total_good_tokens, <span class="hljs-number">1</span>)

    <span class="hljs-keyword">if</span> rank == <span class="hljs-number">0</span>: accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">iter</span>}</span>: <span class="hljs-subst">{loss=}</span>&quot;</span>)
    accelerator.log(<span class="hljs-built_in">dict</span>(train_loss=loss, step=<span class="hljs-built_in">iter</span>))

    accelerator.backward(loss)
    optimizer.step()`,wrap:!1}}),ie=new Ll({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/concept_guides/sequence_parallelism.md"}}),{c(){u=i("meta"),Me=a(),ce=i("p"),de=a(),c(T.$$.fragment),he=a(),c(f.$$.fragment),me=a(),U=i("p"),U.innerHTML=ol,ue=a(),J=i("p"),J.innerHTML=pl,ye=a(),c(b.$$.fragment),we=a(),j=i("p"),j.innerHTML=cl,Te=a(),_=i("p"),_.innerHTML=rl,fe=a(),c(g.$$.fragment),Ue=a(),C=i("p"),C.innerHTML=Ml,Je=a(),I=i("p"),I.textContent=dl,be=a(),A=i("ul"),A.innerHTML=hl,je=a(),G=i("p"),G.textContent=ml,_e=a(),v=i("ul"),v.innerHTML=ul,ge=a(),Z=i("p"),Z.innerHTML=yl,Ce=a(),c(B.$$.fragment),Ie=a(),z=i("p"),z.innerHTML=wl,Ae=a(),c(E.$$.fragment),Ge=a(),c(k.$$.fragment),ve=a(),N=i("p"),N.innerHTML=Tl,Ze=a(),c(x.$$.fragment),Be=a(),y=i("blockquote"),y.innerHTML=fl,ze=a(),w=i("blockquote"),w.innerHTML=Ul,Ee=a(),c(S.$$.fragment),ke=a(),X=i("p"),X.innerHTML=Jl,Ne=a(),W=i("p"),W.innerHTML=bl,xe=a(),F=i("p"),F.innerHTML=jl,Se=a(),c(V.$$.fragment),Xe=a(),H=i("ul"),H.innerHTML=_l,We=a(),Q=i("p"),Q.innerHTML=gl,Fe=a(),$=i("ul"),$.innerHTML=Cl,Ve=a(),q=i("p"),q.innerHTML=Il,He=a(),c(L.$$.fragment),Qe=a(),R=i("p"),R.textContent=Al,$e=a(),c(Y.$$.fragment),qe=a(),P=i("p"),P.textContent=Gl,Le=a(),D=i("p"),D.innerHTML=vl,Re=a(),K=i("p"),K.innerHTML=Zl,Ye=a(),c(O.$$.fragment),Pe=a(),ee=i("p"),ee.innerHTML=Bl,De=a(),le=i("p"),le.innerHTML=zl,Ke=a(),se=i("p"),se.innerHTML=El,Oe=a(),te=i("p"),te.textContent=kl,el=a(),ae=i("blockquote"),ae.innerHTML=Nl,ll=a(),ne=i("p"),ne.textContent=xl,sl=a(),c(ie.$$.fragment),tl=a(),re=i("p"),this.h()},l(e){const l=Ql("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(s),Me=n(e),ce=o(e,"P",{}),Sl(ce).forEach(s),de=n(e),r(T.$$.fragment,e),he=n(e),r(f.$$.fragment,e),me=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1y95ixw"&&(U.innerHTML=ol),ue=n(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1hrdzhe"&&(J.innerHTML=pl),ye=n(e),r(b.$$.fragment,e),we=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-2sleob"&&(j.innerHTML=cl),Te=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-10nqeju"&&(_.innerHTML=rl),fe=n(e),r(g.$$.fragment,e),Ue=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-bhuk6j"&&(C.innerHTML=Ml),Je=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1vni0ze"&&(I.textContent=dl),be=n(e),A=o(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-105nvw"&&(A.innerHTML=hl),je=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1h1w23n"&&(G.textContent=ml),_e=n(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-5wq4l4"&&(v.innerHTML=ul),ge=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-qtmpoo"&&(Z.innerHTML=yl),Ce=n(e),r(B.$$.fragment,e),Ie=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1t64il8"&&(z.innerHTML=wl),Ae=n(e),r(E.$$.fragment,e),Ge=n(e),r(k.$$.fragment,e),ve=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-jsu941"&&(N.innerHTML=Tl),Ze=n(e),r(x.$$.fragment,e),Be=n(e),y=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(y)!=="svelte-1605fl9"&&(y.innerHTML=fl),ze=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(w)!=="svelte-awy0tc"&&(w.innerHTML=Ul),Ee=n(e),r(S.$$.fragment,e),ke=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-11qv90n"&&(X.innerHTML=Jl),Ne=n(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-6a2vre"&&(W.innerHTML=bl),xe=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-oter7c"&&(F.innerHTML=jl),Se=n(e),r(V.$$.fragment,e),Xe=n(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-3nnh2k"&&(H.innerHTML=_l),We=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-4mpkcu"&&(Q.innerHTML=gl),Fe=n(e),$=o(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1vnsins"&&($.innerHTML=Cl),Ve=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1jbv0ue"&&(q.innerHTML=Il),He=n(e),r(L.$$.fragment,e),Qe=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-cd9zrb"&&(R.textContent=Al),$e=n(e),r(Y.$$.fragment,e),qe=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1fapldk"&&(P.textContent=Gl),Le=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-wvrcbe"&&(D.innerHTML=vl),Re=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-k9ukq7"&&(K.innerHTML=Zl),Ye=n(e),r(O.$$.fragment,e),Pe=n(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-kovpml"&&(ee.innerHTML=Bl),De=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1i6q8r9"&&(le.innerHTML=zl),Ke=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1x8p321"&&(se.innerHTML=El),Oe=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1i5r9ol"&&(te.textContent=kl),el=n(e),ae=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ae)!=="svelte-1do693p"&&(ae.innerHTML=Nl),ll=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ctzlnp"&&(ne.textContent=xl),sl=n(e),r(ie.$$.fragment,e),tl=n(e),re=o(e,"P",{}),Sl(re).forEach(s),this.h()},h(){nl(u,"name","hf:doc:metadata"),nl(u,"content",Yl),nl(y,"class","tip"),nl(w,"class","tip")},m(e,l){$l(document.head,u),t(e,Me,l),t(e,ce,l),t(e,de,l),M(T,e,l),t(e,he,l),M(f,e,l),t(e,me,l),t(e,U,l),t(e,ue,l),t(e,J,l),t(e,ye,l),M(b,e,l),t(e,we,l),t(e,j,l),t(e,Te,l),t(e,_,l),t(e,fe,l),M(g,e,l),t(e,Ue,l),t(e,C,l),t(e,Je,l),t(e,I,l),t(e,be,l),t(e,A,l),t(e,je,l),t(e,G,l),t(e,_e,l),t(e,v,l),t(e,ge,l),t(e,Z,l),t(e,Ce,l),M(B,e,l),t(e,Ie,l),t(e,z,l),t(e,Ae,l),M(E,e,l),t(e,Ge,l),M(k,e,l),t(e,ve,l),t(e,N,l),t(e,Ze,l),M(x,e,l),t(e,Be,l),t(e,y,l),t(e,ze,l),t(e,w,l),t(e,Ee,l),M(S,e,l),t(e,ke,l),t(e,X,l),t(e,Ne,l),t(e,W,l),t(e,xe,l),t(e,F,l),t(e,Se,l),M(V,e,l),t(e,Xe,l),t(e,H,l),t(e,We,l),t(e,Q,l),t(e,Fe,l),t(e,$,l),t(e,Ve,l),t(e,q,l),t(e,He,l),M(L,e,l),t(e,Qe,l),t(e,R,l),t(e,$e,l),M(Y,e,l),t(e,qe,l),t(e,P,l),t(e,Le,l),t(e,D,l),t(e,Re,l),t(e,K,l),t(e,Ye,l),M(O,e,l),t(e,Pe,l),t(e,ee,l),t(e,De,l),t(e,le,l),t(e,Ke,l),t(e,se,l),t(e,Oe,l),t(e,te,l),t(e,el,l),t(e,ae,l),t(e,ll,l),t(e,ne,l),t(e,sl,l),M(ie,e,l),t(e,tl,l),t(e,re,l),al=!0},p:Wl,i(e){al||(d(T.$$.fragment,e),d(f.$$.fragment,e),d(b.$$.fragment,e),d(g.$$.fragment,e),d(B.$$.fragment,e),d(E.$$.fragment,e),d(k.$$.fragment,e),d(x.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(L.$$.fragment,e),d(Y.$$.fragment,e),d(O.$$.fragment,e),d(ie.$$.fragment,e),al=!0)},o(e){h(T.$$.fragment,e),h(f.$$.fragment,e),h(b.$$.fragment,e),h(g.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(k.$$.fragment,e),h(x.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(O.$$.fragment,e),h(ie.$$.fragment,e),al=!1},d(e){e&&(s(Me),s(ce),s(de),s(he),s(me),s(U),s(ue),s(J),s(ye),s(we),s(j),s(Te),s(_),s(fe),s(Ue),s(C),s(Je),s(I),s(be),s(A),s(je),s(G),s(_e),s(v),s(ge),s(Z),s(Ce),s(Ie),s(z),s(Ae),s(Ge),s(ve),s(N),s(Ze),s(Be),s(y),s(ze),s(w),s(Ee),s(ke),s(X),s(Ne),s(W),s(xe),s(F),s(Se),s(Xe),s(H),s(We),s(Q),s(Fe),s($),s(Ve),s(q),s(He),s(Qe),s(R),s($e),s(qe),s(P),s(Le),s(D),s(Re),s(K),s(Ye),s(Pe),s(ee),s(De),s(le),s(Ke),s(se),s(Oe),s(te),s(el),s(ae),s(ll),s(ne),s(sl),s(tl),s(re)),s(u),m(T,e),m(f,e),m(b,e),m(g,e),m(B,e),m(E,e),m(k,e),m(x,e),m(S,e),m(V,e),m(L,e),m(Y,e),m(O,e),m(ie,e)}}}const Yl='{"title":"Sequence parallel in 🤗 accelerate","local":"sequence-parallel-in--accelerate","sections":[{"title":"Why sequence parallelism?","local":"why-sequence-parallelism","sections":[],"depth":2},{"title":"How is Ulysses SP different from FSDP CP","local":"how-is-ulysses-sp-different-from-fsdp-cp","sections":[],"depth":2},{"title":"Supported sequence parallelism backends","local":"supported-sequence-parallelism-backends","sections":[],"depth":2},{"title":"How to use sequence parallelism?","local":"how-to-use-sequence-parallelism","sections":[],"depth":2},{"title":"ALST/Ulysses SP backend configuration","local":"alstulysses-sp-backend-configuration","sections":[],"depth":2}],"depth":1}';function Pl(il){return Fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Vl{constructor(u){super(),Hl(this,u,Pl,Rl,Xl,{})}}export{ls as component};
