import{s as ia,n as na,o as ra}from"../chunks/scheduler.b9285784.js";import{S as ca,i as sa,e as r,s as i,c as o,h as oa,a as c,d as a,b as n,f as la,g as d,j as s,k as y,l as da,m as l,n as p,t as f,o as m,p as h}from"../chunks/index.26bc89a1.js";import{C as pa,H as k,E as fa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.65596716.js";import{C as u}from"../chunks/CodeBlock.fd6e4a0e.js";function ma($t){let w,be,ge,ve,U,Je,C,$e,G,_t='There are many ways to launch and run your code depending on your training environment (<a href="https://pytorch.org/docs/stable/elastic/run.html" rel="nofollow">torchrun</a>, <a href="https://www.deepspeed.ai/" rel="nofollow">DeepSpeed</a>, etc.) and available hardware. Accelerate offers a unified interface for launching and training on different distributed setups, allowing you to focus on your PyTorch training code instead of the intricacies of adapting your code to these different setups. This allows you to easily scale your PyTorch code for training and inference on distributed setups with hardware like GPUs and TPUs. Accelerate also provides Big Model Inference to make loading and running inference with really large models that usually don’t fit in memory more accessible.',_e,I,kt="This quicktour introduces the three main features of Accelerate:",ke,j,Ut="<li>a unified command line launching interface for distributed training scripts</li> <li>a training library for adapting PyTorch training code to run on different distributed setups</li> <li>Big Model Inference</li>",Ue,Z,Ce,B,Ct='Accelerate automatically selects the appropriate configuration values for any given distributed training framework (DeepSpeed, FSDP, etc.) through a unified configuration file generated from the <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command. You could also pass the configuration values explicitly to the command line which is helpful in certain situations like if you’re using SLURM.',Ge,x,Gt='But in most cases, you should always run <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> first to help Accelerate learn about your training setup.',Ie,H,je,L,It='The <a href="package_reference/cli#accelerate-config"><code>accelerate config</code></a> command creates and saves a default_config.yaml file in Accelerates cache folder. This file stores the configuration for your training environment, which helps Accelerate correctly launch your training script based on your machine.',Ze,W,jt='After you’ve configured your environment, you can test your setup with <a href="package_reference/cli#accelerate-test"><code>accelerate test</code></a>, which launches a short script to test the distributed environment.',Be,X,xe,T,Zt="<p>Add <code>--config_file</code> to the <code>accelerate test</code> or <code>accelerate launch</code> command to specify the location of the configuration file if it is saved in a non-default location like the cache.</p>",He,Y,Bt='Once your environment is setup, launch your training script with <a href="package_reference/cli#accelerate-launch"><code>accelerate launch</code></a>!',Le,R,We,A,xt='To learn more, check out the <a href="basic_tutorials/launch">Launch distributed code</a> tutorial for more information about launching your scripts.',Xe,N,Ht='We also have a <a href="https://github.com/huggingface/accelerate/blob/main/examples/config_yaml_templates" rel="nofollow">configuration zoo</a> which showcases a number of premade <strong>minimal</strong> example configurations for a variety of setups you can run.',Ye,z,Re,P,Lt='The next main feature of Accelerate is the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class which adapts your PyTorch code to run on different distributed setups.',Ae,F,Wt="You only need to add a few lines of code to your training script to enable it to run on multiple GPUs or TPUs.",Ne,V,ze,Q,Xt='<li>Import and instantiate the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class at the beginning of your training script. The <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class initializes everything necessary for distributed training, and it automatically detects your training environment (a single machine with a GPU, a machine with several GPUs, several machines with multiple GPUs or a TPU, etc.) based on how the code was launched.</li>',Pe,S,Fe,g,Yt='<li>Remove calls like <code>.cuda()</code> on your model and input data. The <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class automatically places these objects on the appropriate device for you.</li>',Ve,M,Rt='<p>This step is <em>optional</em> but it is considered best practice to allow Accelerate to handle device placement. You could also deactivate automatic device placement by passing <code>device_placement=False</code> when initializing the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>. If you want to explicitly place objects on a device with <code>.to(device)</code>, make sure you use <code>accelerator.device</code> instead. For example, if you create an optimizer before placing a model on <code>accelerator.device</code>, training fails on a TPU.</p>',Qe,b,At='<p>Accelerate does not use non-blocking transfers by default for its automatic device placement, which can result in potentially unwanted CUDA synchronizations.  You can enable non-blocking transfers by passing a <a href="/docs/accelerate/v1.12.0/en/package_reference/utilities#accelerate.DataLoaderConfiguration">DataLoaderConfiguration</a> with <code>non_blocking=True</code> set as the <code>dataloader_config</code> when initializing the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>.  As usual, non-blocking transfers will only work if the dataloader also has <code>pin_memory=True</code> set.  Be wary that using non-blocking transfers from GPU to CPU may cause incorrect results if it results in CPU operations being performed on non-ready tensors.</p>',Se,E,Ee,v,Nt='<li>Pass all relevant PyTorch objects for training (optimizer, model, dataloader(s), learning rate scheduler) to the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method as soon as they’re created. This method wraps the model in a container optimized for your distributed setup, uses Accelerates version of the optimizer and scheduler, and creates a sharded version of your dataloader for distribution across GPUs or TPUs.</li>',qe,q,De,J,zt='<li>Replace <code>loss.backward()</code> with <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> to use the correct <code>backward()</code> method for your training setup.</li>',Ke,D,Oe,K,Pt='Read <a href="concept_guides/internal_mechanism">Accelerate’s internal mechanisms</a> guide to learn more details about how Accelerate adapts your code.',et,O,tt,ee,Ft='To perform distributed evaluation, pass your validation dataloader to the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method:',at,te,lt,ae,Vt='Each device in your distributed setup only receives a part of the evaluation data, which means you should group your predictions together with the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method. This method requires all tensors to be the same size on each process, so if your tensors have different sizes on each process (for instance when dynamically padding to the maximum length in a batch), you should use the <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.pad_across_processes">pad_across_processes()</a> method to pad you tensor to the largest size across processes. Note that the tensors needs to be 1D and that we concatenate the tensors along the first dimension.',it,le,nt,ie,Qt="For more complex cases (e.g. 2D tensors, don’t want to concatenate tensors, dict of 3D tensors), you can pass <code>use_gather_object=True</code> in <code>gather_for_metrics</code>. This will return the list of objects after gathering. Note that using it with GPU tensors is not well supported and inefficient.",rt,$,St='<p>Data at the end of a dataset may be duplicated so the batch can be equally divided among all workers. The <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.gather_for_metrics">gather_for_metrics()</a> method automatically removes the duplicated data to calculate a more accurate metric.</p>',ct,ne,st,re,Et='Accelerate’s Big Model Inference has two main features, <a href="/docs/accelerate/v1.12.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> and <a href="/docs/accelerate/v1.12.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, to load large models for inference that typically don’t fit into memory.',ot,_,qt='<p>Take a look at the <a href="concept_guides/big_model_inference">Handling big models for inference</a> guide for a better understanding of how Big Model Inference works under the hood.</p>',dt,ce,pt,se,Dt='The <a href="/docs/accelerate/v1.12.0/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> context manager initializes models of any size by creating a <em>model skeleton</em> and moving and placing parameters each time they’re created to PyTorch’s <a href="https://pytorch.org/docs/main/meta.html" rel="nofollow"><strong>meta</strong></a> device. This way, not all weights are immediately loaded and only a small part of the model is loaded into memory at a time.',ft,oe,Kt='For example, loading an empty <a href="https://huggingface.co/mistralai/Mixtral-8x7B-Instruct-v0.1" rel="nofollow">Mixtral-8x7B</a> model takes significantly less memory than fully loading the models and weights on the CPU.',mt,de,ht,pe,ut,fe,Ot='The <a href="/docs/accelerate/v1.12.0/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> function loads full or sharded checkpoints into the empty model, and automatically distribute weights across all available devices.',yt,me,ea="The <code>device_map</code> parameter determines where to place each model layer, and specifying <code>&quot;auto&quot;</code> places them on the GPU first, then the CPU, and finally the hard drive as memory-mapped tensors if there’s still not enough memory. Use the <code>no_split_module_classes</code> parameter to indicate which modules shouldn’t be split across devices (typically those with a residual connection).",wt,he,Tt,ue,gt,ye,ta="Now that you’ve been introduced to the main Accelerate features, your next steps could include:",Mt,we,aa='<li>Check out the <a href="basic_tutorials/overview">tutorials</a> for a gentle walkthrough of Accelerate. This is especially useful if you’re new to distributed training and the library.</li> <li>Dive into the <a href="usage_guides/explore">guides</a> to see how to use Accelerate for specific use-cases.</li> <li>Deepen your conceptual understanding of how Accelerate works internally by reading the <a href="concept_guides/internal_mechanism">concept guides</a>.</li> <li>Look up classes and commands in the <a href="package_reference/accelerator">API reference</a> to see what parameters and options are available.</li>',bt,Te,vt,Me,Jt;return U=new pa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new k({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),Z=new k({props:{title:"Unified launch interface",local:"unified-launch-interface",headingTag:"h2"}}),H=new u({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),X=new u({props:{code:"YWNjZWxlcmF0ZSUyMHRlc3Q=",highlighted:'accelerate <span class="hljs-built_in">test</span>',wrap:!1}}),R=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHBhdGhfdG9fc2NyaXB0LnB5JTIwLS1hcmdzX2Zvcl90aGVfc2NyaXB0",highlighted:"accelerate launch path_to_script.py --args_for_the_script",wrap:!1}}),z=new k({props:{title:"Adapt training code",local:"adapt-training-code",headingTag:"h2"}}),V=new u({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMGRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBLSUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ device = accelerator.device</span>
<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for batch in training_dataloader:
      optimizer.zero_grad()
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      optimizer.step()
      scheduler.step()`,wrap:!1}}),S=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),E=new u({props:{code:"ZGV2aWNlJTIwJTNEJTIwYWNjZWxlcmF0b3IuZGV2aWNl",highlighted:"device = accelerator.device",wrap:!1}}),q=new u({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
    model, optimizer, train_dataloader, lr_scheduler
)`,wrap:!1}}),D=new u({props:{code:"YWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyk=",highlighted:"accelerator.backward(loss)",wrap:!1}}),O=new k({props:{title:"Distributed evaluation",local:"distributed-evaluation",headingTag:"h3"}}),te=new u({props:{code:"dmFsaWRhdGlvbl9kYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSh2YWxpZGF0aW9uX2RhdGFsb2FkZXIp",highlighted:"validation_dataloader = accelerator.prepare(validation_dataloader)",wrap:!1}}),le=new u({props:{code:"Zm9yJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMGluJTIwdmFsaWRhdGlvbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2F0aGVyJTIwYWxsJTIwcHJlZGljdGlvbnMlMjBhbmQlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXJfZm9yX21ldHJpY3MoKHByZWRpY3Rpb25zJTJDJTIwdGFyZ2V0cykpJTBBJTIwJTIwJTIwJTIwJTIzJTIwRXhhbXBsZSUyMG9mJTIwdXNlJTIwd2l0aCUyMGElMjAqRGF0YXNldHMuTWV0cmljKiUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2goYWxsX3ByZWRpY3Rpb25zJTJDJTIwYWxsX3RhcmdldHMp",highlighted:`<span class="hljs-keyword">for</span> inputs, targets <span class="hljs-keyword">in</span> validation_dataloader:
    predictions = model(inputs)
    <span class="hljs-comment"># Gather all predictions and targets</span>
    all_predictions, all_targets = accelerator.gather_for_metrics((predictions, targets))
    <span class="hljs-comment"># Example of use with a *Datasets.Metric*</span>
    metric.add_batch(all_predictions, all_targets)`,wrap:!1}}),ne=new k({props:{title:"Big Model Inference",local:"big-model-inference",headingTag:"h2"}}),ce=new k({props:{title:"Empty weights initialization",local:"empty-weights-initialization",headingTag:"h3"}}),de=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWl4dHJhbC04eDdCLUluc3RydWN0LXYwLjElMjIpJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),pe=new k({props:{title:"Load and dispatch weights",local:"load-and-dispatch-weights",headingTag:"h3"}}),he=new u({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMnlvdXItbG9jYWwtbW9kZWwtZm9sZGVyJTIyJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRG1vZGVsX2NoZWNrcG9pbnQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG5vX3NwbGl0X21vZHVsZV9jbGFzc2VzJTNEJTVCJ0Jsb2NrJyU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model_checkpoint = <span class="hljs-string">&quot;your-local-model-folder&quot;</span>
model = load_checkpoint_and_dispatch(
    model, checkpoint=model_checkpoint, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),ue=new k({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Te=new fa({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/quicktour.md"}}),{c(){w=r("meta"),be=i(),ge=r("p"),ve=i(),o(U.$$.fragment),Je=i(),o(C.$$.fragment),$e=i(),G=r("p"),G.innerHTML=_t,_e=i(),I=r("p"),I.textContent=kt,ke=i(),j=r("ul"),j.innerHTML=Ut,Ue=i(),o(Z.$$.fragment),Ce=i(),B=r("p"),B.innerHTML=Ct,Ge=i(),x=r("p"),x.innerHTML=Gt,Ie=i(),o(H.$$.fragment),je=i(),L=r("p"),L.innerHTML=It,Ze=i(),W=r("p"),W.innerHTML=jt,Be=i(),o(X.$$.fragment),xe=i(),T=r("blockquote"),T.innerHTML=Zt,He=i(),Y=r("p"),Y.innerHTML=Bt,Le=i(),o(R.$$.fragment),We=i(),A=r("p"),A.innerHTML=xt,Xe=i(),N=r("p"),N.innerHTML=Ht,Ye=i(),o(z.$$.fragment),Re=i(),P=r("p"),P.innerHTML=Lt,Ae=i(),F=r("p"),F.textContent=Wt,Ne=i(),o(V.$$.fragment),ze=i(),Q=r("ol"),Q.innerHTML=Xt,Pe=i(),o(S.$$.fragment),Fe=i(),g=r("ol"),g.innerHTML=Yt,Ve=i(),M=r("blockquote"),M.innerHTML=Rt,Qe=i(),b=r("blockquote"),b.innerHTML=At,Se=i(),o(E.$$.fragment),Ee=i(),v=r("ol"),v.innerHTML=Nt,qe=i(),o(q.$$.fragment),De=i(),J=r("ol"),J.innerHTML=zt,Ke=i(),o(D.$$.fragment),Oe=i(),K=r("p"),K.innerHTML=Pt,et=i(),o(O.$$.fragment),tt=i(),ee=r("p"),ee.innerHTML=Ft,at=i(),o(te.$$.fragment),lt=i(),ae=r("p"),ae.innerHTML=Vt,it=i(),o(le.$$.fragment),nt=i(),ie=r("p"),ie.innerHTML=Qt,rt=i(),$=r("blockquote"),$.innerHTML=St,ct=i(),o(ne.$$.fragment),st=i(),re=r("p"),re.innerHTML=Et,ot=i(),_=r("blockquote"),_.innerHTML=qt,dt=i(),o(ce.$$.fragment),pt=i(),se=r("p"),se.innerHTML=Dt,ft=i(),oe=r("p"),oe.innerHTML=Kt,mt=i(),o(de.$$.fragment),ht=i(),o(pe.$$.fragment),ut=i(),fe=r("p"),fe.innerHTML=Ot,yt=i(),me=r("p"),me.innerHTML=ea,wt=i(),o(he.$$.fragment),Tt=i(),o(ue.$$.fragment),gt=i(),ye=r("p"),ye.textContent=ta,Mt=i(),we=r("ul"),we.innerHTML=aa,bt=i(),o(Te.$$.fragment),vt=i(),Me=r("p"),this.h()},l(e){const t=oa("svelte-u9bgzb",document.head);w=c(t,"META",{name:!0,content:!0}),t.forEach(a),be=n(e),ge=c(e,"P",{}),la(ge).forEach(a),ve=n(e),d(U.$$.fragment,e),Je=n(e),d(C.$$.fragment,e),$e=n(e),G=c(e,"P",{"data-svelte-h":!0}),s(G)!=="svelte-zyosvv"&&(G.innerHTML=_t),_e=n(e),I=c(e,"P",{"data-svelte-h":!0}),s(I)!=="svelte-1o5ahli"&&(I.textContent=kt),ke=n(e),j=c(e,"UL",{"data-svelte-h":!0}),s(j)!=="svelte-d1sk9"&&(j.innerHTML=Ut),Ue=n(e),d(Z.$$.fragment,e),Ce=n(e),B=c(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-aki53"&&(B.innerHTML=Ct),Ge=n(e),x=c(e,"P",{"data-svelte-h":!0}),s(x)!=="svelte-2e4yon"&&(x.innerHTML=Gt),Ie=n(e),d(H.$$.fragment,e),je=n(e),L=c(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-47dzsm"&&(L.innerHTML=It),Ze=n(e),W=c(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-vfcxnx"&&(W.innerHTML=jt),Be=n(e),d(X.$$.fragment,e),xe=n(e),T=c(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),s(T)!=="svelte-h3rozy"&&(T.innerHTML=Zt),He=n(e),Y=c(e,"P",{"data-svelte-h":!0}),s(Y)!=="svelte-jk8hrr"&&(Y.innerHTML=Bt),Le=n(e),d(R.$$.fragment,e),We=n(e),A=c(e,"P",{"data-svelte-h":!0}),s(A)!=="svelte-ehdvry"&&(A.innerHTML=xt),Xe=n(e),N=c(e,"P",{"data-svelte-h":!0}),s(N)!=="svelte-f0tpp6"&&(N.innerHTML=Ht),Ye=n(e),d(z.$$.fragment,e),Re=n(e),P=c(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-157wq27"&&(P.innerHTML=Lt),Ae=n(e),F=c(e,"P",{"data-svelte-h":!0}),s(F)!=="svelte-1x7bxhi"&&(F.textContent=Wt),Ne=n(e),d(V.$$.fragment,e),ze=n(e),Q=c(e,"OL",{"data-svelte-h":!0}),s(Q)!=="svelte-xgjm7v"&&(Q.innerHTML=Xt),Pe=n(e),d(S.$$.fragment,e),Fe=n(e),g=c(e,"OL",{start:!0,"data-svelte-h":!0}),s(g)!=="svelte-5k4dco"&&(g.innerHTML=Yt),Ve=n(e),M=c(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),s(M)!=="svelte-1m09t9y"&&(M.innerHTML=Rt),Qe=n(e),b=c(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),s(b)!=="svelte-6qq0in"&&(b.innerHTML=At),Se=n(e),d(E.$$.fragment,e),Ee=n(e),v=c(e,"OL",{start:!0,"data-svelte-h":!0}),s(v)!=="svelte-1jises2"&&(v.innerHTML=Nt),qe=n(e),d(q.$$.fragment,e),De=n(e),J=c(e,"OL",{start:!0,"data-svelte-h":!0}),s(J)!=="svelte-1yk324l"&&(J.innerHTML=zt),Ke=n(e),d(D.$$.fragment,e),Oe=n(e),K=c(e,"P",{"data-svelte-h":!0}),s(K)!=="svelte-l0bxbi"&&(K.innerHTML=Pt),et=n(e),d(O.$$.fragment,e),tt=n(e),ee=c(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-6rv3gp"&&(ee.innerHTML=Ft),at=n(e),d(te.$$.fragment,e),lt=n(e),ae=c(e,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-f73sk4"&&(ae.innerHTML=Vt),it=n(e),d(le.$$.fragment,e),nt=n(e),ie=c(e,"P",{"data-svelte-h":!0}),s(ie)!=="svelte-uu4pqd"&&(ie.innerHTML=Qt),rt=n(e),$=c(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),s($)!=="svelte-1qak1i5"&&($.innerHTML=St),ct=n(e),d(ne.$$.fragment,e),st=n(e),re=c(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-llg7h4"&&(re.innerHTML=Et),ot=n(e),_=c(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),s(_)!=="svelte-1lgyv23"&&(_.innerHTML=qt),dt=n(e),d(ce.$$.fragment,e),pt=n(e),se=c(e,"P",{"data-svelte-h":!0}),s(se)!=="svelte-biq79o"&&(se.innerHTML=Dt),ft=n(e),oe=c(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1oh4egp"&&(oe.innerHTML=Kt),mt=n(e),d(de.$$.fragment,e),ht=n(e),d(pe.$$.fragment,e),ut=n(e),fe=c(e,"P",{"data-svelte-h":!0}),s(fe)!=="svelte-1s0f9vo"&&(fe.innerHTML=Ot),yt=n(e),me=c(e,"P",{"data-svelte-h":!0}),s(me)!=="svelte-9v7eo2"&&(me.innerHTML=ea),wt=n(e),d(he.$$.fragment,e),Tt=n(e),d(ue.$$.fragment,e),gt=n(e),ye=c(e,"P",{"data-svelte-h":!0}),s(ye)!=="svelte-51r5yq"&&(ye.textContent=ta),Mt=n(e),we=c(e,"UL",{"data-svelte-h":!0}),s(we)!=="svelte-1xs3v0c"&&(we.innerHTML=aa),bt=n(e),d(Te.$$.fragment,e),vt=n(e),Me=c(e,"P",{}),la(Me).forEach(a),this.h()},h(){y(w,"name","hf:doc:metadata"),y(w,"content",ha),y(T,"class","tip"),y(g,"start","2"),y(M,"class","warning"),y(b,"class","warning"),y(v,"start","3"),y(J,"start","4"),y($,"class","tip"),y(_,"class","tip")},m(e,t){da(document.head,w),l(e,be,t),l(e,ge,t),l(e,ve,t),p(U,e,t),l(e,Je,t),p(C,e,t),l(e,$e,t),l(e,G,t),l(e,_e,t),l(e,I,t),l(e,ke,t),l(e,j,t),l(e,Ue,t),p(Z,e,t),l(e,Ce,t),l(e,B,t),l(e,Ge,t),l(e,x,t),l(e,Ie,t),p(H,e,t),l(e,je,t),l(e,L,t),l(e,Ze,t),l(e,W,t),l(e,Be,t),p(X,e,t),l(e,xe,t),l(e,T,t),l(e,He,t),l(e,Y,t),l(e,Le,t),p(R,e,t),l(e,We,t),l(e,A,t),l(e,Xe,t),l(e,N,t),l(e,Ye,t),p(z,e,t),l(e,Re,t),l(e,P,t),l(e,Ae,t),l(e,F,t),l(e,Ne,t),p(V,e,t),l(e,ze,t),l(e,Q,t),l(e,Pe,t),p(S,e,t),l(e,Fe,t),l(e,g,t),l(e,Ve,t),l(e,M,t),l(e,Qe,t),l(e,b,t),l(e,Se,t),p(E,e,t),l(e,Ee,t),l(e,v,t),l(e,qe,t),p(q,e,t),l(e,De,t),l(e,J,t),l(e,Ke,t),p(D,e,t),l(e,Oe,t),l(e,K,t),l(e,et,t),p(O,e,t),l(e,tt,t),l(e,ee,t),l(e,at,t),p(te,e,t),l(e,lt,t),l(e,ae,t),l(e,it,t),p(le,e,t),l(e,nt,t),l(e,ie,t),l(e,rt,t),l(e,$,t),l(e,ct,t),p(ne,e,t),l(e,st,t),l(e,re,t),l(e,ot,t),l(e,_,t),l(e,dt,t),p(ce,e,t),l(e,pt,t),l(e,se,t),l(e,ft,t),l(e,oe,t),l(e,mt,t),p(de,e,t),l(e,ht,t),p(pe,e,t),l(e,ut,t),l(e,fe,t),l(e,yt,t),l(e,me,t),l(e,wt,t),p(he,e,t),l(e,Tt,t),p(ue,e,t),l(e,gt,t),l(e,ye,t),l(e,Mt,t),l(e,we,t),l(e,bt,t),p(Te,e,t),l(e,vt,t),l(e,Me,t),Jt=!0},p:na,i(e){Jt||(f(U.$$.fragment,e),f(C.$$.fragment,e),f(Z.$$.fragment,e),f(H.$$.fragment,e),f(X.$$.fragment,e),f(R.$$.fragment,e),f(z.$$.fragment,e),f(V.$$.fragment,e),f(S.$$.fragment,e),f(E.$$.fragment,e),f(q.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(Te.$$.fragment,e),Jt=!0)},o(e){m(U.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(H.$$.fragment,e),m(X.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),m(V.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(pe.$$.fragment,e),m(he.$$.fragment,e),m(ue.$$.fragment,e),m(Te.$$.fragment,e),Jt=!1},d(e){e&&(a(be),a(ge),a(ve),a(Je),a($e),a(G),a(_e),a(I),a(ke),a(j),a(Ue),a(Ce),a(B),a(Ge),a(x),a(Ie),a(je),a(L),a(Ze),a(W),a(Be),a(xe),a(T),a(He),a(Y),a(Le),a(We),a(A),a(Xe),a(N),a(Ye),a(Re),a(P),a(Ae),a(F),a(Ne),a(ze),a(Q),a(Pe),a(Fe),a(g),a(Ve),a(M),a(Qe),a(b),a(Se),a(Ee),a(v),a(qe),a(De),a(J),a(Ke),a(Oe),a(K),a(et),a(tt),a(ee),a(at),a(lt),a(ae),a(it),a(nt),a(ie),a(rt),a($),a(ct),a(st),a(re),a(ot),a(_),a(dt),a(pt),a(se),a(ft),a(oe),a(mt),a(ht),a(ut),a(fe),a(yt),a(me),a(wt),a(Tt),a(gt),a(ye),a(Mt),a(we),a(bt),a(vt),a(Me)),a(w),h(U,e),h(C,e),h(Z,e),h(H,e),h(X,e),h(R,e),h(z,e),h(V,e),h(S,e),h(E,e),h(q,e),h(D,e),h(O,e),h(te,e),h(le,e),h(ne,e),h(ce,e),h(de,e),h(pe,e),h(he,e),h(ue,e),h(Te,e)}}}const ha='{"title":"Quicktour","local":"quicktour","sections":[{"title":"Unified launch interface","local":"unified-launch-interface","sections":[],"depth":2},{"title":"Adapt training code","local":"adapt-training-code","sections":[{"title":"Distributed evaluation","local":"distributed-evaluation","sections":[],"depth":3}],"depth":2},{"title":"Big Model Inference","local":"big-model-inference","sections":[{"title":"Empty weights initialization","local":"empty-weights-initialization","sections":[],"depth":3},{"title":"Load and dispatch weights","local":"load-and-dispatch-weights","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ua($t){return ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends ca{constructor(w){super(),sa(this,w,ua,ma,ia,{})}}export{Ma as component};
