import{s as qs,o as Ks,n as rl}from"../chunks/scheduler.b9285784.js";import{S as Os,i as ea,e as M,s as a,c as o,h as la,a as i,d as t,b as n,f as Ds,g as c,j as r,k as Ps,l as ta,m as s,n as m,t as y,o as w,p as J}from"../chunks/index.26bc89a1.js";import{T as Ml}from"../chunks/Tip.e4eba3d6.js";import{C as sa,H as il,E as aa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.65596716.js";import{C as h}from"../chunks/CodeBlock.fd6e4a0e.js";function na(d){let p,U='This tutorial is also available as a Jupyter Notebook <a href="https://github.com/huggingface/notebooks/blob/main/examples/accelerate_examples/simple_cv_example.ipynb" rel="nofollow">here</a>';return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1tjynav"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function pa(d){let p,U="CUDA can’t be initialized more than once on a multi-GPU system. It’s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1cflfr7"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function Ma(d){let p,U="The code has been split up to allow for explanations on each section. A full version that can be copy and pasted will be available at the end";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1eykicx"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function ia(d){let p,U=`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the <a href="../concept_guides/training_tpu">TPU best practices</a>
to learn why`;return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1aol2se"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function ra(d){let p,U="You build the model here so that the seed also controls the new weight initialization";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-j432sg"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function oa(d){let p,U="There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1y658j6"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function ca(d){let p,U="Notice how the <code>node_rank</code> has changed";return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dj1i7x"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:rl,d(T){T&&t(p)}}}function ma(d){let p,U,T,j,G,cl,g,ml,_,Kt=`This tutorial teaches you how to fine tune a computer vision model with 🤗 Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`,yl,u,wl,k,Jl,W,Ot="Before any training can be performed, an Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:",Tl,B,hl,v,es='However, if general defaults are fine and you are <em>not</em> running on a TPU, Accelerate has a utility to quickly write your GPU configuration into a config file via <a href="/docs/accelerate/v1.12.0/en/package_reference/utilities#accelerate.commands.config.default.write_basic_config">utils.write_basic_config()</a>.',Ul,Y,ls="The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this.",jl,b,dl,N,ul,A,bl,X,ts="Next you should prepare your dataset. As mentioned earlier, great care should be taken when preparing the <code>DataLoaders</code> and model to make sure that <strong>nothing</strong> is put on <em>any</em> GPU.",Il,R,ss="If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later.",fl,V,as='Make sure the dataset is downloaded based on the directions <a href="https://github.com/huggingface/accelerate/tree/main/examples#simple-vision-example" rel="nofollow">here</a>',Cl,x,$l,F,ns="First you need to create a function to extract the class name based on a filename:",Zl,Q,Gl,z,gl,E,ps="In the case here, the label is <code>beagle</code>. Using regex you can extract the label from the filename:",_l,S,kl,H,Wl,L,Ms="And you can see it properly returned the right name for our file:",Bl,D,vl,P,is="Next a <code>Dataset</code> class should be made to handle grabbing the image and the label:",Yl,q,Nl,K,rs=`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`,Al,O,Xl,ee,os="Next gather all the labels:",Rl,le,Vl,te,cs=`Next, you should make a <code>get_dataloaders</code> function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your <code>DataLoaders</code>, they must be built using this method.`,xl,se,Fl,ae,ms="Finally, you should import the scheduler to be used later:",Ql,ne,zl,pe,El,Me,ys='Now you can build the training loop. <a href="/docs/accelerate/v1.12.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> works by passing in a function to call that will be ran across the distributed system.',Sl,ie,ws="Here is a basic training loop for the animal classification problem:",Hl,I,Ll,re,Dl,oe,Js='First you should set the seed and create an <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object as early in the training loop as possible.',Pl,f,ql,ce,Ts="Next you should build your dataloaders and create your model:",Kl,me,Ol,C,et,ye,hs=`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`,lt,we,tt,Je,Us="Normalizing the batches of images will make training a little faster:",st,Te,at,he,js="To make these constants available on the active device, you should set it to the Accelerator’s device:",nt,Ue,pt,je,ds="Next instantiate the rest of the PyTorch classes used for training:",Mt,de,it,ue,us='Before passing everything to <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.',rt,$,ot,be,ct,Ie,bs="Now train the model:",mt,fe,yt,Ce,Is=`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`,wt,$e,Jt,Ze,fs="Next you have the rest of your standard PyTorch loop:",Tt,Ge,ht,ge,Cs="Before finally the last major difference.",Ut,_e,$s=`When performing distributed evaluation, the predictions and labels need to be passed through
<a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> so that all of the data is available on the current device and a properly calculated metric can be achieved:`,jt,ke,dt,We,Zs='Now you just need to calculate the actual metric for this problem, and you can print it on the main process using <a href="/docs/accelerate/v1.12.0/en/package_reference/accelerator#accelerate.Accelerator.print">print()</a>:',ut,Be,bt,ve,Gs="A full version of this training loop is available below:",It,Ye,ft,Ne,Ct,Ae,gs='All that’s left is to use the <a href="/docs/accelerate/v1.12.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a>.',$t,Xe,_s='You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the <a href="../package_reference/launchers">documentation</a> for more information)',Zt,Re,Gt,Ve,gt,xe,ks="In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time.",_t,Fe,Ws="For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of “172.31.43.8”, it would look like so:",kt,Qe,Wt,ze,Bs="And in the second Jupyter session on the other machine:",Bt,Z,vt,Ee,Yt,Se,vs="In the case of running on the TPU, it would look like so:",Nt,He,At,Le,Ys="To launch the training process with elasticity, enabling fault tolerance, you can use the <code>elastic_launch</code> feature provided by PyTorch. This requires setting additional parameters such as <code>rdzv_backend</code> and <code>max_restarts</code>. Here is an example of how to use <code>notebook_launcher</code> with elastic capabilities:",Xt,De,Rt,Pe,Ns="As it’s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:",Vt,qe,xt,Ke,As="And that’s it!",Ft,Oe,Xs='Please note that <a href="/docs/accelerate/v1.12.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> ignores the Accelerate config file, to launch based on the config use:',Qt,el,zt,ll,Et,tl,Rs=`A common issue when running the <code>notebook_launcher</code> is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch <code>torch.cuda</code> sublibrary. To help narrow down what went wrong,
you can launch the <code>notebook_launcher</code> with <code>ACCELERATE_DEBUG_MODE=yes</code> in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`,St,sl,Ht,al,Vs="This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:",Lt,nl,xs='<li>Make sure to save any code that use CUDA (or CUDA imports) for the function passed to <a href="/docs/accelerate/v1.12.0/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a></li> <li>Set the <code>num_processes</code> to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)</li> <li>If using the TPU, declare your model outside the training loop function</li>',Dt,pl,Pt,ol,qt;return G=new sa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new il({props:{title:"Launching distributed training from Jupyter Notebooks",local:"launching-distributed-training-from-jupyter-notebooks",headingTag:"h1"}}),u=new Ml({props:{$$slots:{default:[na]},$$scope:{ctx:d}}}),k=new il({props:{title:"Configuring the Environment",local:"configuring-the-environment",headingTag:"h2"}}),B=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),b=new Ml({props:{warning:!0,$$slots:{default:[pa]},$$scope:{ctx:d}}}),N=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHdyaXRlX2Jhc2ljX2NvbmZpZyUwQSUwQXdyaXRlX2Jhc2ljX2NvbmZpZygpJTIwJTIwJTIzJTIwV3JpdGUlMjBhJTIwY29uZmlnJTIwZmlsZSUwQW9zLl9leGl0KDAwKSUyMCUyMCUyMyUyMFJlc3RhcnQlMjB0aGUlMjBub3RlYm9vaw==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()  <span class="hljs-comment"># Write a config file</span>
os._exit(<span class="hljs-number">00</span>)  <span class="hljs-comment"># Restart the notebook</span>`,wrap:!1}}),A=new il({props:{title:"Preparing the Dataset and Model",local:"preparing-the-dataset-and-model",headingTag:"h2"}}),x=new h({props:{code:"aW1wb3J0JTIwb3MlMkMlMjByZSUyQyUyMHRvcmNoJTJDJTIwUElMJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyME9uZUN5Y2xlTFIlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMkMlMjBEYXRhc2V0JTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBSZXNpemUlMkMlMjBUb1RlbnNvciUwQSUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBZnJvbSUyMHRpbW0lMjBpbXBvcnQlMjBjcmVhdGVfbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> os, re, torch, PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> OneCycleLR
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader, Dataset
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, RandomResizedCrop, Resize, ToTensor

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> timm <span class="hljs-keyword">import</span> create_model`,wrap:!1}}),Q=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEFkYXRhX2RpciUyMCUzRCUyMCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMEFmbmFtZXMlMjAlM0QlMjBvcy5saXN0ZGlyKGRhdGFfZGlyKSUwQWZuYW1lJTIwJTNEJTIwZm5hbWVzJTVCMCU1RCUwQXByaW50KGZuYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> os

data_dir = <span class="hljs-string">&quot;../../images&quot;</span>
fnames = os.listdir(data_dir)
fname = fnames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(fname)`,wrap:!1}}),z=new h({props:{code:"YmVhZ2xlXzMyLmpwZw==",highlighted:"beagle_32.jpg",wrap:!1}}),S=new h({props:{code:"aW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZW0lMjAlM0QlMjBmbmFtZS5zcGxpdChvcy5wYXRoLnNlcCklNUItMSU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlLnNlYXJjaChyJTIyJTVFKC4qKV8lNUNkJTJCJTVDLmpwZyUyNCUyMiUyQyUyMHN0ZW0pLmdyb3VwcygpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_label</span>(<span class="hljs-params">fname</span>):
    stem = fname.split(os.path.sep)[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">return</span> re.search(<span class="hljs-string">r&quot;^(.*)_\\d+\\.jpg$&quot;</span>, stem).groups()[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new h({props:{code:"ZXh0cmFjdF9sYWJlbChmbmFtZSk=",highlighted:"extract_label(fname)",wrap:!1}}),D=new h({props:{code:"JTIyYmVhZ2xlJTIy",highlighted:'<span class="hljs-string">&quot;beagle&quot;</span>',wrap:!1}}),q=new h({props:{code:"Y2xhc3MlMjBQZXRzRGF0YXNldChEYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBmaWxlX25hbWVzJTJDJTIwaW1hZ2VfdHJhbnNmb3JtJTNETm9uZSUyQyUyMGxhYmVsX3RvX2lkJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZpbGVfbmFtZXMlMjAlM0QlMjBmaWxlX25hbWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0lMjAlM0QlMjBpbWFnZV90cmFuc2Zvcm0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxhYmVsX3RvX2lkJTIwJTNEJTIwbGFiZWxfdG9faWQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGVuKHNlbGYuZmlsZV9uYW1lcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2dldGl0ZW1fXyhzZWxmJTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuYW1lJTIwJTNEJTIwc2VsZi5maWxlX25hbWVzJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X2ltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oZm5hbWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjByYXdfaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmltYWdlX3RyYW5zZm9ybSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0oaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlMjAlM0QlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5sYWJlbF90b19pZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5sYWJlbF90b19pZCU1QmxhYmVsJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwbGFiZWwlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PetsDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, file_names, image_transform=<span class="hljs-literal">None</span>, label_to_id=<span class="hljs-literal">None</span></span>):
        self.file_names = file_names
        self.image_transform = image_transform
        self.label_to_id = label_to_id

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.file_names)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
        fname = self.file_names[idx]
        raw_image = PIL.Image.<span class="hljs-built_in">open</span>(fname)
        image = raw_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        <span class="hljs-keyword">if</span> self.image_transform <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            image = self.image_transform(image)
        label = extract_label(fname)
        <span class="hljs-keyword">if</span> self.label_to_id <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            label = self.label_to_id[label]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;image&quot;</span>: image, <span class="hljs-string">&quot;label&quot;</span>: label}`,wrap:!1}}),O=new h({props:{code:"Zm5hbWVzJTIwJTNEJTIwJTVCb3MucGF0aC5qb2luKCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMkMlMjBmbmFtZSklMjBmb3IlMjBmbmFtZSUyMGluJTIwZm5hbWVzJTIwaWYlMjBmbmFtZS5lbmRzd2l0aCglMjIuanBnJTIyKSU1RA==",highlighted:'fnames = [os.path.join(<span class="hljs-string">&quot;../../images&quot;</span>, fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames <span class="hljs-keyword">if</span> fname.endswith(<span class="hljs-string">&quot;.jpg&quot;</span>)]',wrap:!1}}),le=new h({props:{code:"YWxsX2xhYmVscyUyMCUzRCUyMCU1QmV4dHJhY3RfbGFiZWwoZm5hbWUpJTIwZm9yJTIwZm5hbWUlMjBpbiUyMGZuYW1lcyU1RCUwQWlkX3RvX2xhYmVsJTIwJTNEJTIwbGlzdChzZXQoYWxsX2xhYmVscykpJTBBaWRfdG9fbGFiZWwuc29ydCgpJTBBbGFiZWxfdG9faWQlMjAlM0QlMjAlN0JsYmwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxibCUyMGluJTIwZW51bWVyYXRlKGlkX3RvX2xhYmVsKSU3RA==",highlighted:`all_labels = [extract_label(fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames]
id_to_label = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_labels))
id_to_label.sort()
label_to_id = {lbl: i <span class="hljs-keyword">for</span> i, lbl <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(id_to_label)}`,wrap:!1}}),se=new h({props:{code:"ZGVmJTIwZ2V0X2RhdGFsb2FkZXJzKGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA2NCklM0ElMEElMjAlMjAlMjAlMjAlMjJCdWlsZHMlMjBhJTIwc2V0JTIwb2YlMjBkYXRhbG9hZGVycyUyMHdpdGglMjBhJTIwYmF0Y2hfc2l6ZSUyMiUwQSUyMCUyMCUyMCUyMHJhbmRvbV9wZXJtJTIwJTNEJTIwbnAucmFuZG9tLnBlcm11dGF0aW9uKGxlbihmbmFtZXMpKSUwQSUyMCUyMCUyMCUyMGN1dCUyMCUzRCUyMGludCgwLjglMjAqJTIwbGVuKGZuYW1lcykpJTBBJTIwJTIwJTIwJTIwdHJhaW5fc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QiUzQWN1dCU1RCUwQSUyMCUyMCUyMCUyMGV2YWxfc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QmN1dCUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTIwYSUyMHNpbXBsZSUyMFJhbmRvbVJlc2l6ZWRDcm9wJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMHRyYWluX3RmbSUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3AoKDIyNCUyQyUyMDIyNCklMkMlMjBzY2FsZSUzRCgwLjUlMkMlMjAxLjApKSUyQyUyMFRvVGVuc29yKCklNUQpJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMFBldHNEYXRhc2V0KCU1QmZuYW1lcyU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjB0cmFpbl9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRHRyYWluX3RmbSUyQyUyMGxhYmVsX3RvX2lkJTNEbGFiZWxfdG9faWQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwZXZhbHVhdGlvbiUyMGElMjBkZXRlcm1pbmlzdGljJTIwUmVzaXplJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMGV2YWxfdGZtJTIwJTNEJTIwQ29tcG9zZSglNUJSZXNpemUoKDIyNCUyQyUyMDIyNCkpJTJDJTIwVG9UZW5zb3IoKSU1RCklMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBQZXRzRGF0YXNldCglNUJmbmFtZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwZXZhbF9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRGV2YWxfdGZtJTJDJTIwbGFiZWxfdG9faWQlM0RsYWJlbF90b19pZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMGRhdGFsb2FkZXJzJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIodHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihldmFsX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNERmFsc2UlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyMColMjAyJTJDJTIwbnVtX3dvcmtlcnMlM0Q0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_dataloaders</span>(<span class="hljs-params">batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;Builds a set of dataloaders with a batch_size&quot;</span>
    random_perm = np.random.permutation(<span class="hljs-built_in">len</span>(fnames))
    cut = <span class="hljs-built_in">int</span>(<span class="hljs-number">0.8</span> * <span class="hljs-built_in">len</span>(fnames))
    train_split = random_perm[:cut]
    eval_split = random_perm[cut:]

    <span class="hljs-comment"># For training a simple RandomResizedCrop will be used</span>
    train_tfm = Compose([RandomResizedCrop((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), scale=(<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>)), ToTensor()])
    train_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> train_split], image_transform=train_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># For evaluation a deterministic Resize will be used</span>
    eval_tfm = Compose([Resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)), ToTensor()])
    eval_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> eval_split], image_transform=eval_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># Instantiate dataloaders</span>
    train_dataloader = DataLoader(train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=batch_size, num_workers=<span class="hljs-number">4</span>)
    eval_dataloader = DataLoader(eval_dataset, shuffle=<span class="hljs-literal">False</span>, batch_size=batch_size * <span class="hljs-number">2</span>, num_workers=<span class="hljs-number">4</span>)
    <span class="hljs-keyword">return</span> train_dataloader, eval_dataloader`,wrap:!1}}),ne=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyMENvc2luZUFubmVhbGluZ0xS",highlighted:'<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> CosineAnnealingLR',wrap:!1}}),pe=new il({props:{title:"Writing the Training Function",local:"writing-the-training-function",headingTag:"h2"}}),I=new Ml({props:{$$slots:{default:[Ma]},$$scope:{ctx:d}}}),re=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    accelerator = Accelerator(mixed_precision=mixed_precision)`,wrap:!1}}),f=new Ml({props:{warning:!0,$$slots:{default:[ia]},$$scope:{ctx:d}}}),me=new h({props:{code:"JTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhiYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RsZW4obGFiZWxfdG9faWQpKQ==",highlighted:`    train_dataloader, eval_dataloader = get_dataloaders(batch_size)
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))`,wrap:!1}}),C=new Ml({props:{$$slots:{default:[ra]},$$scope:{ctx:d}}}),we=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBtb2RlbC5nZXRfY2xhc3NpZmllcigpLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBUcnVl",highlighted:`    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>`,wrap:!1}}),Te=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMm1lYW4lMjIlNUQpJTVCTm9uZSUyQyUyMCUzQSUyQyUyME5vbmUlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwc3RkJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsLmRlZmF1bHRfY2ZnJTVCJTIyc3RkJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RA==",highlighted:`    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),Ue=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2Up",highlighted:`    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)`,wrap:!1}}),de=new h({props:{code:"JTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTIlMjAlMkYlMjAyNSklMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKQ==",highlighted:`    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))`,wrap:!1}}),$=new Ml({props:{$$slots:{default:[oa]},$$scope:{ctx:d}}}),be=new h({props:{code:"JTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjAp",highlighted:`    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )`,wrap:!1}}),fe=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwKGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMjAtJTIwbWVhbiklMjAlMkYlMjBzdGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmNyb3NzX2VudHJvcHkob3V0cHV0cyUyQyUyMGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()`,wrap:!1}}),$e=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMA==",highlighted:`        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>`,wrap:!1}}),Ge=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSk=",highlighted:`        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)`,wrap:!1}}),ke=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCk=",highlighted:`            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()`,wrap:!1}}),Be=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9tZXRyaWMlMjAlM0QlMjBhY2N1cmF0ZS5pdGVtKCklMjAlMkYlMjBudW1fZWxlbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5wcmludChmJTIyZXBvY2glMjAlN0JlcG9jaCU3RCUzQSUyMCU3QjEwMCUyMColMjBldmFsX21ldHJpYyUzQS4yZiU3RCUyMik=",highlighted:`        eval_metric = accurate.item() / num_elems
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Ye=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    <span class="hljs-comment"># Initialize accelerator</span>
    accelerator = Accelerator(mixed_precision=mixed_precision)
    <span class="hljs-comment"># Build dataloaders</span>
    train_dataloader, eval_dataloader = get_dataloaders(batch_size)

    <span class="hljs-comment"># Instantiate the model (you build the model here so that the seed also controls new weight initializations)</span>
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

    <span class="hljs-comment"># Freeze the base model</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>

    <span class="hljs-comment"># You can normalize the batches of images to be a bit faster</span>
    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]

    <span class="hljs-comment"># To make these constants available on the active device, set it to the accelerator device</span>
    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)

    <span class="hljs-comment"># Instantiate the optimizer</span>
    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)

    <span class="hljs-comment"># Instantiate the learning rate scheduler</span>
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))

    <span class="hljs-comment"># Prepare everything</span>
    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the</span>
    <span class="hljs-comment"># prepare method.</span>
    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )

    <span class="hljs-comment"># Now you train the model</span>
    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()

        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)
            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()

        eval_metric = accurate.item() / num_elems
        <span class="hljs-comment"># Use accelerator.print to print only on the main process.</span>
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Ne=new il({props:{title:"Using the notebook_launcher",local:"using-the-notebooklauncher",headingTag:"h2"}}),Re=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlcg==",highlighted:'<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher',wrap:!1}}),Ve=new h({props:{code:"YXJncyUyMCUzRCUyMCglMjJmcDE2JTIyJTJDJTIwNDIlMkMlMjA2NCklMEFub3RlYm9va19sYXVuY2hlcih0cmFpbmluZ19sb29wJTJDJTIwYXJncyUyQyUyMG51bV9wcm9jZXNzZXMlM0QyKQ==",highlighted:`args = (<span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">2</span>)`,wrap:!1}}),Qe=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMCUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">0</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Z=new Ml({props:{$$slots:{default:[ca]},$$scope:{ctx:d}}}),Ee=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMSUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">1</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),He=new h({props:{code:"bW9kZWwlMjAlM0QlMjBjcmVhdGVfbW9kZWwoJTIycmVzbmV0NTBkJTIyJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRGxlbihsYWJlbF90b19pZCkpJTBBJTBBYXJncyUyMCUzRCUyMChtb2RlbCUyQyUyMCUyMmZwMTYlMjIlMkMlMjA0MiUyQyUyMDY0KSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDgp",highlighted:`model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

args = (model, <span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">8</span>)`,wrap:!1}}),De=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfbG9vcCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlMkMlMEElMjAlMjAlMjAlMjBudW1fcHJvY2Vzc2VzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9yZXN0YXJ0cyUzRDMlMEEp",highlighted:`notebook_launcher(
    training_loop,
    args,
    num_processes=<span class="hljs-number">2</span>,
    max_restarts=<span class="hljs-number">3</span>
)`,wrap:!1}}),qe=new h({props:{code:"TGF1bmNoaW5nJTIwdHJhaW5pbmclMjBvbiUyMDIlMjBHUFVzLiUwQWVwb2NoJTIwMCUzQSUyMDg4LjEyJTBBZXBvY2glMjAxJTNBJTIwOTEuNzMlMEFlcG9jaCUyMDIlM0ElMjA5Mi41OCUwQWVwb2NoJTIwMyUzQSUyMDkzLjkwJTBBZXBvY2glMjA0JTNBJTIwOTQuNzE=",highlighted:`Launching training on <span class="hljs-number">2</span> GPUs.
epoch <span class="hljs-number">0</span>: <span class="hljs-number">88.12</span>
epoch <span class="hljs-number">1</span>: <span class="hljs-number">91.73</span>
epoch <span class="hljs-number">2</span>: <span class="hljs-number">92.58</span>
epoch <span class="hljs-number">3</span>: <span class="hljs-number">93.90</span>
epoch <span class="hljs-number">4</span>: <span class="hljs-number">94.71</span>`,wrap:!1}}),el=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaA==",highlighted:"accelerate launch",wrap:!1}}),ll=new il({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),sl=new il({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),pl=new aa({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/notebook.md"}}),{c(){p=M("meta"),U=a(),T=M("p"),j=a(),o(G.$$.fragment),cl=a(),o(g.$$.fragment),ml=a(),_=M("p"),_.textContent=Kt,yl=a(),o(u.$$.fragment),wl=a(),o(k.$$.fragment),Jl=a(),W=M("p"),W.textContent=Ot,Tl=a(),o(B.$$.fragment),hl=a(),v=M("p"),v.innerHTML=es,Ul=a(),Y=M("p"),Y.textContent=ls,jl=a(),o(b.$$.fragment),dl=a(),o(N.$$.fragment),ul=a(),o(A.$$.fragment),bl=a(),X=M("p"),X.innerHTML=ts,Il=a(),R=M("p"),R.textContent=ss,fl=a(),V=M("p"),V.innerHTML=as,Cl=a(),o(x.$$.fragment),$l=a(),F=M("p"),F.textContent=ns,Zl=a(),o(Q.$$.fragment),Gl=a(),o(z.$$.fragment),gl=a(),E=M("p"),E.innerHTML=ps,_l=a(),o(S.$$.fragment),kl=a(),o(H.$$.fragment),Wl=a(),L=M("p"),L.textContent=Ms,Bl=a(),o(D.$$.fragment),vl=a(),P=M("p"),P.innerHTML=is,Yl=a(),o(q.$$.fragment),Nl=a(),K=M("p"),K.textContent=rs,Al=a(),o(O.$$.fragment),Xl=a(),ee=M("p"),ee.textContent=os,Rl=a(),o(le.$$.fragment),Vl=a(),te=M("p"),te.innerHTML=cs,xl=a(),o(se.$$.fragment),Fl=a(),ae=M("p"),ae.textContent=ms,Ql=a(),o(ne.$$.fragment),zl=a(),o(pe.$$.fragment),El=a(),Me=M("p"),Me.innerHTML=ys,Sl=a(),ie=M("p"),ie.textContent=ws,Hl=a(),o(I.$$.fragment),Ll=a(),o(re.$$.fragment),Dl=a(),oe=M("p"),oe.innerHTML=Js,Pl=a(),o(f.$$.fragment),ql=a(),ce=M("p"),ce.textContent=Ts,Kl=a(),o(me.$$.fragment),Ol=a(),o(C.$$.fragment),et=a(),ye=M("p"),ye.textContent=hs,lt=a(),o(we.$$.fragment),tt=a(),Je=M("p"),Je.textContent=Us,st=a(),o(Te.$$.fragment),at=a(),he=M("p"),he.textContent=js,nt=a(),o(Ue.$$.fragment),pt=a(),je=M("p"),je.textContent=ds,Mt=a(),o(de.$$.fragment),it=a(),ue=M("p"),ue.innerHTML=us,rt=a(),o($.$$.fragment),ot=a(),o(be.$$.fragment),ct=a(),Ie=M("p"),Ie.textContent=bs,mt=a(),o(fe.$$.fragment),yt=a(),Ce=M("p"),Ce.textContent=Is,wt=a(),o($e.$$.fragment),Jt=a(),Ze=M("p"),Ze.textContent=fs,Tt=a(),o(Ge.$$.fragment),ht=a(),ge=M("p"),ge.textContent=Cs,Ut=a(),_e=M("p"),_e.innerHTML=$s,jt=a(),o(ke.$$.fragment),dt=a(),We=M("p"),We.innerHTML=Zs,ut=a(),o(Be.$$.fragment),bt=a(),ve=M("p"),ve.textContent=Gs,It=a(),o(Ye.$$.fragment),ft=a(),o(Ne.$$.fragment),Ct=a(),Ae=M("p"),Ae.innerHTML=gs,$t=a(),Xe=M("p"),Xe.innerHTML=_s,Zt=a(),o(Re.$$.fragment),Gt=a(),o(Ve.$$.fragment),gt=a(),xe=M("p"),xe.textContent=ks,_t=a(),Fe=M("p"),Fe.textContent=Ws,kt=a(),o(Qe.$$.fragment),Wt=a(),ze=M("p"),ze.textContent=Bs,Bt=a(),o(Z.$$.fragment),vt=a(),o(Ee.$$.fragment),Yt=a(),Se=M("p"),Se.textContent=vs,Nt=a(),o(He.$$.fragment),At=a(),Le=M("p"),Le.innerHTML=Ys,Xt=a(),o(De.$$.fragment),Rt=a(),Pe=M("p"),Pe.textContent=Ns,Vt=a(),o(qe.$$.fragment),xt=a(),Ke=M("p"),Ke.textContent=As,Ft=a(),Oe=M("p"),Oe.innerHTML=Xs,Qt=a(),o(el.$$.fragment),zt=a(),o(ll.$$.fragment),Et=a(),tl=M("p"),tl.innerHTML=Rs,St=a(),o(sl.$$.fragment),Ht=a(),al=M("p"),al.textContent=Vs,Lt=a(),nl=M("ul"),nl.innerHTML=xs,Dt=a(),o(pl.$$.fragment),Pt=a(),ol=M("p"),this.h()},l(e){const l=la("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=n(e),T=i(e,"P",{}),Ds(T).forEach(t),j=n(e),c(G.$$.fragment,e),cl=n(e),c(g.$$.fragment,e),ml=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6spvy7"&&(_.textContent=Kt),yl=n(e),c(u.$$.fragment,e),wl=n(e),c(k.$$.fragment,e),Jl=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1wr7aay"&&(W.textContent=Ot),Tl=n(e),c(B.$$.fragment,e),hl=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-14n6qxc"&&(v.innerHTML=es),Ul=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-3qwb6i"&&(Y.textContent=ls),jl=n(e),c(b.$$.fragment,e),dl=n(e),c(N.$$.fragment,e),ul=n(e),c(A.$$.fragment,e),bl=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mtlp3l"&&(X.innerHTML=ts),Il=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1gkh70d"&&(R.textContent=ss),fl=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-myu7hv"&&(V.innerHTML=as),Cl=n(e),c(x.$$.fragment,e),$l=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-h07c4l"&&(F.textContent=ns),Zl=n(e),c(Q.$$.fragment,e),Gl=n(e),c(z.$$.fragment,e),gl=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-60ulbw"&&(E.innerHTML=ps),_l=n(e),c(S.$$.fragment,e),kl=n(e),c(H.$$.fragment,e),Wl=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1kzkru5"&&(L.textContent=Ms),Bl=n(e),c(D.$$.fragment,e),vl=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-eeriqt"&&(P.innerHTML=is),Yl=n(e),c(q.$$.fragment,e),Nl=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1erq0yi"&&(K.textContent=rs),Al=n(e),c(O.$$.fragment,e),Xl=n(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-17fsfbj"&&(ee.textContent=os),Rl=n(e),c(le.$$.fragment,e),Vl=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1wyd1v3"&&(te.innerHTML=cs),xl=n(e),c(se.$$.fragment,e),Fl=n(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-s9102n"&&(ae.textContent=ms),Ql=n(e),c(ne.$$.fragment,e),zl=n(e),c(pe.$$.fragment,e),El=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1mg4l14"&&(Me.innerHTML=ys),Sl=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-oa85ci"&&(ie.textContent=ws),Hl=n(e),c(I.$$.fragment,e),Ll=n(e),c(re.$$.fragment,e),Dl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-g3sqw4"&&(oe.innerHTML=Js),Pl=n(e),c(f.$$.fragment,e),ql=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1ojop43"&&(ce.textContent=Ts),Kl=n(e),c(me.$$.fragment,e),Ol=n(e),c(C.$$.fragment,e),et=n(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-2qfnag"&&(ye.textContent=hs),lt=n(e),c(we.$$.fragment,e),tt=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-16kq69y"&&(Je.textContent=Us),st=n(e),c(Te.$$.fragment,e),at=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1x7hf7y"&&(he.textContent=js),nt=n(e),c(Ue.$$.fragment,e),pt=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1drdkyl"&&(je.textContent=ds),Mt=n(e),c(de.$$.fragment,e),it=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-pwkaan"&&(ue.innerHTML=us),rt=n(e),c($.$$.fragment,e),ot=n(e),c(be.$$.fragment,e),ct=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-8iqamy"&&(Ie.textContent=bs),mt=n(e),c(fe.$$.fragment,e),yt=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-uq3liu"&&(Ce.textContent=Is),wt=n(e),c($e.$$.fragment,e),Jt=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1vssgg7"&&(Ze.textContent=fs),Tt=n(e),c(Ge.$$.fragment,e),ht=n(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-o67l3v"&&(ge.textContent=Cs),Ut=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-9xauqm"&&(_e.innerHTML=$s),jt=n(e),c(ke.$$.fragment,e),dt=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-6pd4de"&&(We.innerHTML=Zs),ut=n(e),c(Be.$$.fragment,e),bt=n(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1kobhd"&&(ve.textContent=Gs),It=n(e),c(Ye.$$.fragment,e),ft=n(e),c(Ne.$$.fragment,e),Ct=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1ag7fi4"&&(Ae.innerHTML=gs),$t=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-7o5jv1"&&(Xe.innerHTML=_s),Zt=n(e),c(Re.$$.fragment,e),Gt=n(e),c(Ve.$$.fragment,e),gt=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-rkokvk"&&(xe.textContent=ks),_t=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-192rw96"&&(Fe.textContent=Ws),kt=n(e),c(Qe.$$.fragment,e),Wt=n(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-3ig3ul"&&(ze.textContent=Bs),Bt=n(e),c(Z.$$.fragment,e),vt=n(e),c(Ee.$$.fragment,e),Yt=n(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-10flsnd"&&(Se.textContent=vs),Nt=n(e),c(He.$$.fragment,e),At=n(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-lkd19f"&&(Le.innerHTML=Ys),Xt=n(e),c(De.$$.fragment,e),Rt=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-svq1hp"&&(Pe.textContent=Ns),Vt=n(e),c(qe.$$.fragment,e),xt=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-9wooxy"&&(Ke.textContent=As),Ft=n(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-16o79c4"&&(Oe.innerHTML=Xs),Qt=n(e),c(el.$$.fragment,e),zt=n(e),c(ll.$$.fragment,e),Et=n(e),tl=i(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-1p7dsaj"&&(tl.innerHTML=Rs),St=n(e),c(sl.$$.fragment,e),Ht=n(e),al=i(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-ixf1ne"&&(al.textContent=Vs),Lt=n(e),nl=i(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-zbltrv"&&(nl.innerHTML=xs),Dt=n(e),c(pl.$$.fragment,e),Pt=n(e),ol=i(e,"P",{}),Ds(ol).forEach(t),this.h()},h(){Ps(p,"name","hf:doc:metadata"),Ps(p,"content",ya)},m(e,l){ta(document.head,p),s(e,U,l),s(e,T,l),s(e,j,l),m(G,e,l),s(e,cl,l),m(g,e,l),s(e,ml,l),s(e,_,l),s(e,yl,l),m(u,e,l),s(e,wl,l),m(k,e,l),s(e,Jl,l),s(e,W,l),s(e,Tl,l),m(B,e,l),s(e,hl,l),s(e,v,l),s(e,Ul,l),s(e,Y,l),s(e,jl,l),m(b,e,l),s(e,dl,l),m(N,e,l),s(e,ul,l),m(A,e,l),s(e,bl,l),s(e,X,l),s(e,Il,l),s(e,R,l),s(e,fl,l),s(e,V,l),s(e,Cl,l),m(x,e,l),s(e,$l,l),s(e,F,l),s(e,Zl,l),m(Q,e,l),s(e,Gl,l),m(z,e,l),s(e,gl,l),s(e,E,l),s(e,_l,l),m(S,e,l),s(e,kl,l),m(H,e,l),s(e,Wl,l),s(e,L,l),s(e,Bl,l),m(D,e,l),s(e,vl,l),s(e,P,l),s(e,Yl,l),m(q,e,l),s(e,Nl,l),s(e,K,l),s(e,Al,l),m(O,e,l),s(e,Xl,l),s(e,ee,l),s(e,Rl,l),m(le,e,l),s(e,Vl,l),s(e,te,l),s(e,xl,l),m(se,e,l),s(e,Fl,l),s(e,ae,l),s(e,Ql,l),m(ne,e,l),s(e,zl,l),m(pe,e,l),s(e,El,l),s(e,Me,l),s(e,Sl,l),s(e,ie,l),s(e,Hl,l),m(I,e,l),s(e,Ll,l),m(re,e,l),s(e,Dl,l),s(e,oe,l),s(e,Pl,l),m(f,e,l),s(e,ql,l),s(e,ce,l),s(e,Kl,l),m(me,e,l),s(e,Ol,l),m(C,e,l),s(e,et,l),s(e,ye,l),s(e,lt,l),m(we,e,l),s(e,tt,l),s(e,Je,l),s(e,st,l),m(Te,e,l),s(e,at,l),s(e,he,l),s(e,nt,l),m(Ue,e,l),s(e,pt,l),s(e,je,l),s(e,Mt,l),m(de,e,l),s(e,it,l),s(e,ue,l),s(e,rt,l),m($,e,l),s(e,ot,l),m(be,e,l),s(e,ct,l),s(e,Ie,l),s(e,mt,l),m(fe,e,l),s(e,yt,l),s(e,Ce,l),s(e,wt,l),m($e,e,l),s(e,Jt,l),s(e,Ze,l),s(e,Tt,l),m(Ge,e,l),s(e,ht,l),s(e,ge,l),s(e,Ut,l),s(e,_e,l),s(e,jt,l),m(ke,e,l),s(e,dt,l),s(e,We,l),s(e,ut,l),m(Be,e,l),s(e,bt,l),s(e,ve,l),s(e,It,l),m(Ye,e,l),s(e,ft,l),m(Ne,e,l),s(e,Ct,l),s(e,Ae,l),s(e,$t,l),s(e,Xe,l),s(e,Zt,l),m(Re,e,l),s(e,Gt,l),m(Ve,e,l),s(e,gt,l),s(e,xe,l),s(e,_t,l),s(e,Fe,l),s(e,kt,l),m(Qe,e,l),s(e,Wt,l),s(e,ze,l),s(e,Bt,l),m(Z,e,l),s(e,vt,l),m(Ee,e,l),s(e,Yt,l),s(e,Se,l),s(e,Nt,l),m(He,e,l),s(e,At,l),s(e,Le,l),s(e,Xt,l),m(De,e,l),s(e,Rt,l),s(e,Pe,l),s(e,Vt,l),m(qe,e,l),s(e,xt,l),s(e,Ke,l),s(e,Ft,l),s(e,Oe,l),s(e,Qt,l),m(el,e,l),s(e,zt,l),m(ll,e,l),s(e,Et,l),s(e,tl,l),s(e,St,l),m(sl,e,l),s(e,Ht,l),s(e,al,l),s(e,Lt,l),s(e,nl,l),s(e,Dt,l),m(pl,e,l),s(e,Pt,l),s(e,ol,l),qt=!0},p(e,[l]){const Fs={};l&2&&(Fs.$$scope={dirty:l,ctx:e}),u.$set(Fs);const Qs={};l&2&&(Qs.$$scope={dirty:l,ctx:e}),b.$set(Qs);const zs={};l&2&&(zs.$$scope={dirty:l,ctx:e}),I.$set(zs);const Es={};l&2&&(Es.$$scope={dirty:l,ctx:e}),f.$set(Es);const Ss={};l&2&&(Ss.$$scope={dirty:l,ctx:e}),C.$set(Ss);const Hs={};l&2&&(Hs.$$scope={dirty:l,ctx:e}),$.$set(Hs);const Ls={};l&2&&(Ls.$$scope={dirty:l,ctx:e}),Z.$set(Ls)},i(e){qt||(y(G.$$.fragment,e),y(g.$$.fragment,e),y(u.$$.fragment,e),y(k.$$.fragment,e),y(B.$$.fragment,e),y(b.$$.fragment,e),y(N.$$.fragment,e),y(A.$$.fragment,e),y(x.$$.fragment,e),y(Q.$$.fragment,e),y(z.$$.fragment,e),y(S.$$.fragment,e),y(H.$$.fragment,e),y(D.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(I.$$.fragment,e),y(re.$$.fragment,e),y(f.$$.fragment,e),y(me.$$.fragment,e),y(C.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(Ue.$$.fragment,e),y(de.$$.fragment,e),y($.$$.fragment,e),y(be.$$.fragment,e),y(fe.$$.fragment,e),y($e.$$.fragment,e),y(Ge.$$.fragment,e),y(ke.$$.fragment,e),y(Be.$$.fragment,e),y(Ye.$$.fragment,e),y(Ne.$$.fragment,e),y(Re.$$.fragment,e),y(Ve.$$.fragment,e),y(Qe.$$.fragment,e),y(Z.$$.fragment,e),y(Ee.$$.fragment,e),y(He.$$.fragment,e),y(De.$$.fragment,e),y(qe.$$.fragment,e),y(el.$$.fragment,e),y(ll.$$.fragment,e),y(sl.$$.fragment,e),y(pl.$$.fragment,e),qt=!0)},o(e){w(G.$$.fragment,e),w(g.$$.fragment,e),w(u.$$.fragment,e),w(k.$$.fragment,e),w(B.$$.fragment,e),w(b.$$.fragment,e),w(N.$$.fragment,e),w(A.$$.fragment,e),w(x.$$.fragment,e),w(Q.$$.fragment,e),w(z.$$.fragment,e),w(S.$$.fragment,e),w(H.$$.fragment,e),w(D.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(se.$$.fragment,e),w(ne.$$.fragment,e),w(pe.$$.fragment,e),w(I.$$.fragment,e),w(re.$$.fragment,e),w(f.$$.fragment,e),w(me.$$.fragment,e),w(C.$$.fragment,e),w(we.$$.fragment,e),w(Te.$$.fragment,e),w(Ue.$$.fragment,e),w(de.$$.fragment,e),w($.$$.fragment,e),w(be.$$.fragment,e),w(fe.$$.fragment,e),w($e.$$.fragment,e),w(Ge.$$.fragment,e),w(ke.$$.fragment,e),w(Be.$$.fragment,e),w(Ye.$$.fragment,e),w(Ne.$$.fragment,e),w(Re.$$.fragment,e),w(Ve.$$.fragment,e),w(Qe.$$.fragment,e),w(Z.$$.fragment,e),w(Ee.$$.fragment,e),w(He.$$.fragment,e),w(De.$$.fragment,e),w(qe.$$.fragment,e),w(el.$$.fragment,e),w(ll.$$.fragment,e),w(sl.$$.fragment,e),w(pl.$$.fragment,e),qt=!1},d(e){e&&(t(U),t(T),t(j),t(cl),t(ml),t(_),t(yl),t(wl),t(Jl),t(W),t(Tl),t(hl),t(v),t(Ul),t(Y),t(jl),t(dl),t(ul),t(bl),t(X),t(Il),t(R),t(fl),t(V),t(Cl),t($l),t(F),t(Zl),t(Gl),t(gl),t(E),t(_l),t(kl),t(Wl),t(L),t(Bl),t(vl),t(P),t(Yl),t(Nl),t(K),t(Al),t(Xl),t(ee),t(Rl),t(Vl),t(te),t(xl),t(Fl),t(ae),t(Ql),t(zl),t(El),t(Me),t(Sl),t(ie),t(Hl),t(Ll),t(Dl),t(oe),t(Pl),t(ql),t(ce),t(Kl),t(Ol),t(et),t(ye),t(lt),t(tt),t(Je),t(st),t(at),t(he),t(nt),t(pt),t(je),t(Mt),t(it),t(ue),t(rt),t(ot),t(ct),t(Ie),t(mt),t(yt),t(Ce),t(wt),t(Jt),t(Ze),t(Tt),t(ht),t(ge),t(Ut),t(_e),t(jt),t(dt),t(We),t(ut),t(bt),t(ve),t(It),t(ft),t(Ct),t(Ae),t($t),t(Xe),t(Zt),t(Gt),t(gt),t(xe),t(_t),t(Fe),t(kt),t(Wt),t(ze),t(Bt),t(vt),t(Yt),t(Se),t(Nt),t(At),t(Le),t(Xt),t(Rt),t(Pe),t(Vt),t(xt),t(Ke),t(Ft),t(Oe),t(Qt),t(zt),t(Et),t(tl),t(St),t(Ht),t(al),t(Lt),t(nl),t(Dt),t(Pt),t(ol)),t(p),J(G,e),J(g,e),J(u,e),J(k,e),J(B,e),J(b,e),J(N,e),J(A,e),J(x,e),J(Q,e),J(z,e),J(S,e),J(H,e),J(D,e),J(q,e),J(O,e),J(le,e),J(se,e),J(ne,e),J(pe,e),J(I,e),J(re,e),J(f,e),J(me,e),J(C,e),J(we,e),J(Te,e),J(Ue,e),J(de,e),J($,e),J(be,e),J(fe,e),J($e,e),J(Ge,e),J(ke,e),J(Be,e),J(Ye,e),J(Ne,e),J(Re,e),J(Ve,e),J(Qe,e),J(Z,e),J(Ee,e),J(He,e),J(De,e),J(qe,e),J(el,e),J(ll,e),J(sl,e),J(pl,e)}}}const ya='{"title":"Launching distributed training from Jupyter Notebooks","local":"launching-distributed-training-from-jupyter-notebooks","sections":[{"title":"Configuring the Environment","local":"configuring-the-environment","sections":[],"depth":2},{"title":"Preparing the Dataset and Model","local":"preparing-the-dataset-and-model","sections":[],"depth":2},{"title":"Writing the Training Function","local":"writing-the-training-function","sections":[],"depth":2},{"title":"Using the notebook_launcher","local":"using-the-notebooklauncher","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function wa(d){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class da extends Os{constructor(p){super(),ea(this,p,wa,ma,qs,{})}}export{da as component};
