import{s as Dl,o as Ol,n as al}from"../chunks/scheduler.eb244325.js";import{S as Kl,i as ts,e as i,s as n,c as y,h as es,a as M,d as l,b as a,f as ll,g as J,j as p,k as Pl,l as sl,m as s,n as r,t as T,o as u,p as c}from"../chunks/index.661680a1.js";import{T as nl}from"../chunks/Tip.76637dd3.js";import{C as ls,H as j,E as ss}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f2fe41ba.js";import{C as d}from"../chunks/CodeBlock.a220ed00.js";function ns(m){let o,U="This tutorial uses Python and Gradio, but you can adapt the approach to any language that can make HTTP requests. The models deployed on Inference Endpoints use standard APIs, so you can integrate them into web applications, mobile apps, or any other system.";return{c(){o=i("p"),o.textContent=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1kzcndf"&&(o.textContent=U)},m(w,I){s(w,o,I)},p:al,d(w){w&&l(o)}}}function as(m){let o,U="You might also want to use <code>os.getenv</code> for your endpoint details.";return{c(){o=i("p"),o.innerHTML=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1ene528"&&(o.innerHTML=U)},m(w,I){s(w,o,I)},p:al,d(w){w&&l(o)}}}function is(m){let o,U="The transcription endpoint expects a file upload in the <code>files</code> parameter. Make sure to read the audio file as binary data and pass it correctly to the API.";return{c(){o=i("p"),o.innerHTML=U},l(w){o=M(w,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1xad941"&&(o.innerHTML=U)},m(w,I){s(w,o,I)},p:al,d(w){w&&l(o)}}}function Ms(m){let o,U,w,I,B,Vt,g,kt,Z,il="This tutorial will guide you through building a complete transcription application using Hugging Face Inference Endpoints. We’ll create an app that can transcribe audio files and generate intelligent summaries with action items - perfect for meeting notes, interviews, or any audio content.",Rt,h,Ht,G,xt,A,Ml="First, we need to create an Inference Endpoint for audio transcription. We’ll use OpenAI’s Whisper model for high-quality speech recognition.",zt,N,pl="Start by navigating to the Inference Endpoints UI, and once you have logged in you should see a button for creating a new Inference Endpoint. Click the “New” button.",Yt,W,ol='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/1-new-button.png" alt="new-button"/>',Ft,X,yl="From there you’ll be directed to the catalog. The Model Catalog consists of popular models which have tuned configurations to work as one-click deploys. You can filter by name, task, price of the hardware and much more.",_t,q,Jl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/quick_start/2-catalog.png" alt="catalog"/>',Lt,E,rl='Search for “whisper” to find transcription models, or you can create a custom endpoint with <a href="https://huggingface.co/openai/whisper-large-v3" rel="nofollow">openai/whisper-large-v3</a>. This model provides excellent transcription quality for multiple languages and handles various audio formats.',Pt,S,Tl="For transcription models, we recommend:",Dt,v,ul="<li><strong>GPU</strong>: NVIDIA L4 or A10G for good performance with audio processing</li> <li><strong>Instance Size</strong>: x1 (sufficient for most transcription workloads)</li> <li><strong>Auto-scaling</strong>: Enable scale-to-zero to save costs when not in use</li>",Ot,$,cl="Click “Create Endpoint” to deploy your transcription service.",Kt,Q,wl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/config.png" alt="config"/>',te,V,Ul="Your endpoint will take about 5 minutes to initialize. Once it’s ready, you’ll see it in the “Running” state.",ee,k,le,R,jl='Now let’s do the same again but now for a text generation model. For generating summaries and action items, we’ll create a second endpoint using the <a href="https://huggingface.co/Qwen/Qwen3-1.7B" rel="nofollow">Qwen/Qwen3-1.7B</a> model.',se,H,Il="Follow the same process:",ne,x,dl="<li>Click “New” button in the Inference Endpoints UI</li> <li>Search for <code>qwen3 1.7b</code> in the catalog</li> <li>The NVIDIA L4 with x1 instance size is recommended for this model</li> <li>Keep the default settings (scale-to-zero enabled, 1-hour timeout)</li> <li>Click “Create Endpoint”</li>",ae,z,ml="This model is optimized for text generation tasks and will provide excellent summarization capabilities. Both endpoints will take about 3-5 minutes to initialize.",ie,Y,Me,F,hl="Once your endpoints are running, you can test them in the playground. The transcription endpoint will accept audio files and return text transcripts.",pe,_,Cl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/playground.png" alt="playground"/>',oe,L,fl="Test with a short audio sample to verify the transcription quality.",ye,P,Je,D,bl='You’ll need the endpoint details from your <a href="https://endpoints.huggingface.co/" rel="nofollow">endpoints page</a>:',re,O,Bl='<li><strong>Base URL</strong>: <code>https://&lt;endpoint-name&gt;.endpoints.huggingface.cloud/v1/</code></li> <li><strong>Model name</strong>: The name of your endpoint</li> <li><strong>Token</strong>: Your HF token from <a href="https://huggingface.co/settings/tokens" rel="nofollow">settings</a></li>',Te,K,gl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/chatbot/endpoint-page.png" alt="endpoint-details"/>',ue,tt,Zl="You can validate your details by testing your endpoint out in the command line with curl.",ce,et,we,lt,Ue,st,Gl="Now let’s build a transcription application step by step. We’ll break it down into logical blocks to create a complete solution that can transcribe audio and generate intelligent summaries.",je,nt,Ie,at,Al="We’ll use the <code>requests</code> library to connect to both endpoints and <code>gradio</code> to create the interface. Let’s install the required packages:",de,it,me,Mt,Nl="Then, set up your imports in a new Python file:",he,pt,Ce,ot,fe,yt,Wl="Set up the configuration to connect to both your transcription and summarization endpoints based on the details you collected in the previous steps.",be,Jt,Be,rt,Xl="Your endpoints are now configured to handle both audio transcription and text summarization.",ge,C,Ze,Tt,Ge,ut,ql="Next, we’ll create a function to handle audio file uploads and transcription:",Ae,ct,Ne,f,We,wt,Xe,Ut,El="Now we’ll create a function to generate summaries from the transcribed text. We’ll do some simple prompt engineering to get the best results.",qe,jt,Ee,It,Se,dt,Sl="Now let’s build our Gradio interface. We’ll use the <code>gr.Interface</code> class to create a simple interface that allows us to upload an audio file and see the transcript and summary.",ve,mt,vl="First, we’ll create a main processing function that handles the complete workflow.",$e,ht,Qe,Ct,$l="Then, we can run that function in a Gradio interface. We’ll add some descriptions and a title to make it more user-friendly.",Ve,ft,ke,bt,Ql="That’s it! You can now run the app locally with <code>python app.py</code> and test it out.",Re,b,$t,Vl="Click to view the complete script",el,Bt,He,gt,kl='<img src="https://raw.githubusercontent.com/huggingface/hf-endpoints-documentation/main/assets/tutorials/transcriptions/app.png" alt="app"/>',xe,Zt,ze,Gt,Rl="Now, let’s deploy it to Hugging Face Spaces so everyone can use it!",Ye,At,Hl='<li><strong>Create a new Space</strong>: Go to <a href="https://huggingface.co/new-space" rel="nofollow">huggingface.co/new-space</a></li> <li><strong>Choose Gradio SDK</strong> and make it public</li> <li><strong>Upload your files</strong>: Upload <code>app.py</code> and any requirements</li> <li><strong>Add your token</strong>: In Space settings, add <code>HF_TOKEN</code> as a secret</li> <li><strong>Configure hardware</strong>: Consider GPU for faster processing</li> <li><strong>Launch</strong>: Your app will be live at <code>https://huggingface.co/spaces/your-username/your-space-name</code></li>',Fe,Nt,xl="Your transcription app is now ready to handle meeting notes, interviews, podcasts, and any other audio content that needs to be transcribed and summarized!",_e,Wt,Le,Xt,zl="Great work! You’ve now built a complete transcription application with intelligent summarization.",Pe,qt,Yl="Here are some ways to extend your transcription app:",De,Et,Fl="<li><strong>Multi-language support</strong>: Add language detection and support for multiple languages</li> <li><strong>Speaker identification</strong>: Use a model from the hub with speaker diarization capabilities.</li> <li><strong>Custom prompts</strong>: Allow users to customize the summary format and style</li> <li><strong>Implement Text-to-Speech</strong>: Use a model from the hub to convert your summary to another audio file!</li>",Oe,St,Ke,Qt,tl;return B=new ls({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new j({props:{title:"Create your own transcription app",local:"create-your-own-transcription-app",headingTag:"h1"}}),h=new nl({props:{$$slots:{default:[ns]},$$scope:{ctx:m}}}),G=new j({props:{title:"Create your transcription endpoint",local:"create-your-transcription-endpoint",headingTag:"h2"}}),k=new j({props:{title:"Create your text generation endpoint",local:"create-your-text-generation-endpoint",headingTag:"h2"}}),Y=new j({props:{title:"Test your endpoints",local:"test-your-endpoints",headingTag:"h2"}}),P=new j({props:{title:"Get your endpoint details",local:"get-your-endpoint-details",headingTag:"h2"}}),et=new d({props:{code:"Y3VybCUyMCUyMiUzQ2VuZHBvaW50LXVybCUzRSUyMiUyMCU1QyUwQS1YJTIwUE9TVCUyMCU1QyUwQS0tZGF0YS1iaW5hcnklMjAnJTQwJTNDYXVkaW8tZmlsZSUzRSclMjAlNUMlMEEtSCUyMCUyMkFjY2VwdCUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUyMiUyMCU1QyUwQS1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXVkaW8lMkZmbGFjJTIyJTIwJTVD",highlighted:`curl <span class="hljs-string">&quot;&lt;endpoint-url&gt;&quot;</span> \\
-X POST \\
--data-binary <span class="hljs-string">&#x27;@&lt;audio-file&gt;&#x27;</span> \\
-H <span class="hljs-string">&quot;Accept: application/json&quot;</span> \\
-H <span class="hljs-string">&quot;Content-Type: audio/flac&quot;</span> \\`,wrap:!1}}),lt=new j({props:{title:"Building the transcription app",local:"building-the-transcription-app",headingTag:"h2"}}),nt=new j({props:{title:"Step 1: Set up dependencies and imports",local:"step-1-set-up-dependencies-and-imports",headingTag:"h3"}}),it=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMHJlcXVlc3Rz",highlighted:"pip install gradio requests",wrap:!1}}),pt=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBaW1wb3J0JTIwcmVxdWVzdHM=",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> requests`,wrap:!1}}),ot=new j({props:{title:"Step 2: Configure your endpoint connections",local:"step-2-configure-your-endpoint-connections",headingTag:"h3"}}),Jt=new d({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUyMGZvciUyMGJvdGglMjBlbmRwb2ludHMlMEFUUkFOU0NSSVBUSU9OX0VORFBPSU5UJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ5b3VyLXdoaXNwZXItZW5kcG9pbnQuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGYXBpJTJGdjElMkZhdWRpbyUyRnRyYW5zY3JpcHRpb25zJTIyJTBBU1VNTUFSSVpBVElPTl9FTkRQT0lOVCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGeW91ci1xd2VuLWVuZHBvaW50LmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIyJTBBSEZfVE9LRU4lMjAlM0QlMjBvcy5nZXRlbnYoJTIySEZfVE9LRU4lMjIpJTIwJTIwJTIzJTIwWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwdG9rZW4lMEElMEElMjMlMjBIZWFkZXJzJTIwZm9yJTIwYXV0aGVudGljYXRpb24lMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JIRl9UT0tFTiU3RCUyMiUwQSU3RA==",highlighted:`<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}`,wrap:!1}}),C=new nl({props:{$$slots:{default:[as]},$$scope:{ctx:m}}}),Tt=new j({props:{title:"Step 3: Create the transcription function",local:"step-3-create-the-transcription-function",headingTag:"h3"}}),ct=new d({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9hdWRpbyhhdWRpb19maWxlX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNjcmliZSUyMGF1ZGlvJTIwdXNpbmclMjBkaXJlY3QlMjByZXF1ZXN0cyUyMHRvJTIwdGhlJTIwZW5kcG9pbnQlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSZWFkJTIwYXVkaW8lMjBmaWxlJTIwYW5kJTIwcHJlcGFyZSUyMGZvciUyMHVwbG9hZCUwQSUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGF1ZGlvX2ZpbGVfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwYXVkaW9fZmlsZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFJlYWQlMjB0aGUlMjBhdWRpbyUyMGZpbGUlMjBhcyUyMGJpbmFyeSUyMGRhdGElMjBhbmQlMjByZXByZXNlbnQlMjBpdCUyMGFzJTIwYSUyMGZpbGUlMjBvYmplY3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcyUyMCUzRCUyMCU3QiUyMmZpbGUlMjIlM0ElMjBhdWRpb19maWxlLnJlYWQoKSU3RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyME1ha2UlMjB0aGUlMjByZXF1ZXN0JTIwdG8lMjB0aGUlMjB0cmFuc2NyaXB0aW9uJTIwZW5kcG9pbnQlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLnBvc3QoVFJBTlNDUklQVElPTl9FTkRQT0lOVCUyQyUyMGhlYWRlcnMlM0RoZWFkZXJzJTJDJTIwZmlsZXMlM0RmaWxlcyklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBDaGVjayUyMGlmJTIwdGhlJTIwcmVxdWVzdCUyMHdhcyUyMHN1Y2Nlc3NmdWwlMEElMjAlMjAlMjAlMjBpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwJTNEJTNEJTIwMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0LmdldCglMjJ0ZXh0JTIyJTJDJTIwJTIyTm8lMjB0cmFuc2NyaXB0aW9uJTIwYXZhaWxhYmxlJTIyKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlM0ElMjAlN0JyZXNwb25zZS5zdGF0dXNfY29kZSU3RCUyMC0lMjAlN0JyZXNwb25zZS50ZXh0JTdEJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        <span class="hljs-comment"># Read the audio file as binary data and represent it as a file object</span>
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-comment"># Check if the request was successful</span>
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>`,wrap:!1}}),f=new nl({props:{$$slots:{default:[is]},$$scope:{ctx:m}}}),wt=new j({props:{title:"Step 4: Create the summarization function",local:"step-4-create-the-summarization-function",headingTag:"h3"}}),jt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># define a nice prompt to get the best results for our use case</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>, <span class="hljs-comment"># we can also set a max_tokens parameter to limit the length of the response</span>
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-comment"># we might want to set lower temperature for more deterministic results</span>
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span> <span class="hljs-comment"># we don&#x27;t need streaming for this use case</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]`,wrap:!1}}),It=new j({props:{title:"Step 5: Wrap it all together",local:"step-5-wrap-it-all-together",headingTag:"h3"}}),ht=new d({props:{code:"ZGVmJTIwcHJvY2Vzc19tZWV0aW5nX2F1ZGlvKGF1ZGlvX2ZpbGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTWFpbiUyMHByb2Nlc3NpbmclMjBmdW5jdGlvbiUyMHRoYXQlMjBoYW5kbGVzJTIwdGhlJTIwY29tcGxldGUlMjB3b3JrZmxvdyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGlmJTIwYXVkaW9fZmlsZSUyMGlzJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMlBsZWFzZSUyMHVwbG9hZCUyMGFuJTIwYXVkaW8lMjBmaWxlLiUyMiUyQyUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwVHJhbnNjcmliZSUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNjcmlwdCUyMCUzRCUyMHRyYW5zY3JpYmVfYXVkaW8oYXVkaW9fZmlsZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMiUzQSUyMEdlbmVyYXRlJTIwc3VtbWFyeSUyMGZyb20lMjB0cmFuc2NyaXB0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VtbWFyeSUyMCUzRCUyMGdlbmVyYXRlX3N1bW1hcnkodHJhbnNjcmlwdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFuc2NyaXB0JTJDJTIwc3VtbWFyeSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJFcnJvciUyMHByb2Nlc3NpbmclMjBhdWRpbyUzQSUyMCU3QnN0cihlKSU3RCUyMiUyQyUyMCUyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),ft=new d({props:{code:"JTIzJTIwQ3JlYXRlJTIwR3JhZGlvJTIwaW50ZXJmYWNlJTBBYXBwJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEcHJvY2Vzc19tZWV0aW5nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJVcGxvYWQlMjBNZWV0aW5nJTIwQXVkaW8lMjIlMkMlMjB0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3gobGFiZWwlM0QlMjJGdWxsJTIwVHJhbnNjcmlwdCUyMiUyQyUyMGxpbmVzJTNEMTApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ3IuVGV4dGJveChsYWJlbCUzRCUyMk1lZXRpbmclMjBTdW1tYXJ5JTIyJTJDJTIwbGluZXMlM0Q4KSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyJUYwJTlGJThFJUE0JTIwQUklMjBNZWV0aW5nJTIwTm90ZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlVwbG9hZCUyMGF1ZGlvJTIwdG8lMjBnZXQlMjBpbnN0YW50JTIwdHJhbnNjcmlwdHMlMjBhbmQlMjBzdW1tYXJpZXMuJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)`,wrap:!1}}),Bt=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Configuration for both endpoints</span>
TRANSCRIPTION_ENDPOINT = <span class="hljs-string">&quot;https://your-whisper-endpoint.endpoints.huggingface.cloud/api/v1/audio/transcriptions&quot;</span>
SUMMARIZATION_ENDPOINT = <span class="hljs-string">&quot;https://your-qwen-endpoint.endpoints.huggingface.cloud/v1/chat/completions&quot;</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)  <span class="hljs-comment"># Your Hugging Face Hub token</span>

<span class="hljs-comment"># Headers for authentication</span>
headers = {
    <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">audio_file_path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Transcribe audio using direct requests to the endpoint&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Read audio file and prepare for upload</span>
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(audio_file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> audio_file:
        files = {<span class="hljs-string">&quot;file&quot;</span>: audio_file.read()}
    
    <span class="hljs-comment"># Make the request to the transcription endpoint</span>
    response = requests.post(TRANSCRIPTION_ENDPOINT, headers=headers, files=files)
    
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        result = response.json()
        <span class="hljs-keyword">return</span> result.get(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;No transcription available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error: <span class="hljs-subst">{response.status_code}</span> - <span class="hljs-subst">{response.text}</span>&quot;</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_summary</span>(<span class="hljs-params">transcript</span>):
    <span class="hljs-string">&quot;&quot;&quot;Generate summary using requests to the chat completions endpoint&quot;&quot;&quot;</span>
    
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    Analyze this meeting transcript and provide:
    1. A concise summary of key points
    2. Action items with responsible parties
    3. Important decisions made
    
    Transcript: <span class="hljs-subst">{transcript}</span>
    
    Format with clear sections:
    ## Summary
    ## Action Items  
    ## Decisions Made
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Prepare the payload using the Messages API format</span>
    payload = {
        <span class="hljs-string">&quot;model&quot;</span>: <span class="hljs-string">&quot;your-qwen-endpoint-name&quot;</span>,  <span class="hljs-comment"># Use the name of your endpoint</span>
        <span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}],
        <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">1000</span>,
        <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
        <span class="hljs-string">&quot;stream&quot;</span>: <span class="hljs-literal">False</span>
    }
    
    <span class="hljs-comment"># Headers for chat completions</span>
    chat_headers = {
        <span class="hljs-string">&quot;Accept&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
        <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{HF_TOKEN}</span>&quot;</span>
    }
    
    <span class="hljs-comment"># Make the request</span>
    response = requests.post(SUMMARIZATION_ENDPOINT, headers=chat_headers, json=payload)
    response.raise_for_status()
    
    <span class="hljs-comment"># Parse the response</span>
    result = response.json()
    <span class="hljs-keyword">return</span> result[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">process_meeting_audio</span>(<span class="hljs-params">audio_file</span>):
    <span class="hljs-string">&quot;&quot;&quot;Main processing function that handles the complete workflow&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_file <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Please upload an audio file.&quot;</span>, <span class="hljs-string">&quot;&quot;</span>
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Step 1: Transcribe the audio</span>
        transcript = transcribe_audio(audio_file)
        
        <span class="hljs-comment"># Step 2: Generate summary from transcript</span>
        summary = generate_summary(transcript)
        
        <span class="hljs-keyword">return</span> transcript, summary
    
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error processing audio: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>, <span class="hljs-string">&quot;&quot;</span>


<span class="hljs-comment"># Create Gradio interface</span>
app = gr.Interface(
    fn=process_meeting_audio,
    inputs=gr.Audio(label=<span class="hljs-string">&quot;Upload Meeting Audio&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=[
        gr.Textbox(label=<span class="hljs-string">&quot;Full Transcript&quot;</span>, lines=<span class="hljs-number">10</span>),
        gr.Textbox(label=<span class="hljs-string">&quot;Meeting Summary&quot;</span>, lines=<span class="hljs-number">8</span>),
    ],
    title=<span class="hljs-string">&quot;🎤 AI Meeting Notes&quot;</span>,
    description=<span class="hljs-string">&quot;Upload audio to get instant transcripts and summaries.&quot;</span>,
)

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    app.launch()`,wrap:!1}}),Zt=new j({props:{title:"Deploy your transcription app",local:"deploy-your-transcription-app",headingTag:"h2"}}),Wt=new j({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),St=new ss({props:{source:"https://github.com/huggingface/hf-endpoints-documentation/blob/main/docs/source/tutorials/transcription.md"}}),{c(){o=i("meta"),U=n(),w=i("p"),I=n(),y(B.$$.fragment),Vt=n(),y(g.$$.fragment),kt=n(),Z=i("p"),Z.textContent=il,Rt=n(),y(h.$$.fragment),Ht=n(),y(G.$$.fragment),xt=n(),A=i("p"),A.textContent=Ml,zt=n(),N=i("p"),N.textContent=pl,Yt=n(),W=i("p"),W.innerHTML=ol,Ft=n(),X=i("p"),X.textContent=yl,_t=n(),q=i("p"),q.innerHTML=Jl,Lt=n(),E=i("p"),E.innerHTML=rl,Pt=n(),S=i("p"),S.textContent=Tl,Dt=n(),v=i("ul"),v.innerHTML=ul,Ot=n(),$=i("p"),$.textContent=cl,Kt=n(),Q=i("p"),Q.innerHTML=wl,te=n(),V=i("p"),V.textContent=Ul,ee=n(),y(k.$$.fragment),le=n(),R=i("p"),R.innerHTML=jl,se=n(),H=i("p"),H.textContent=Il,ne=n(),x=i("ol"),x.innerHTML=dl,ae=n(),z=i("p"),z.textContent=ml,ie=n(),y(Y.$$.fragment),Me=n(),F=i("p"),F.textContent=hl,pe=n(),_=i("p"),_.innerHTML=Cl,oe=n(),L=i("p"),L.textContent=fl,ye=n(),y(P.$$.fragment),Je=n(),D=i("p"),D.innerHTML=bl,re=n(),O=i("ul"),O.innerHTML=Bl,Te=n(),K=i("p"),K.innerHTML=gl,ue=n(),tt=i("p"),tt.textContent=Zl,ce=n(),y(et.$$.fragment),we=n(),y(lt.$$.fragment),Ue=n(),st=i("p"),st.textContent=Gl,je=n(),y(nt.$$.fragment),Ie=n(),at=i("p"),at.innerHTML=Al,de=n(),y(it.$$.fragment),me=n(),Mt=i("p"),Mt.textContent=Nl,he=n(),y(pt.$$.fragment),Ce=n(),y(ot.$$.fragment),fe=n(),yt=i("p"),yt.textContent=Wl,be=n(),y(Jt.$$.fragment),Be=n(),rt=i("p"),rt.textContent=Xl,ge=n(),y(C.$$.fragment),Ze=n(),y(Tt.$$.fragment),Ge=n(),ut=i("p"),ut.textContent=ql,Ae=n(),y(ct.$$.fragment),Ne=n(),y(f.$$.fragment),We=n(),y(wt.$$.fragment),Xe=n(),Ut=i("p"),Ut.textContent=El,qe=n(),y(jt.$$.fragment),Ee=n(),y(It.$$.fragment),Se=n(),dt=i("p"),dt.innerHTML=Sl,ve=n(),mt=i("p"),mt.textContent=vl,$e=n(),y(ht.$$.fragment),Qe=n(),Ct=i("p"),Ct.textContent=$l,Ve=n(),y(ft.$$.fragment),ke=n(),bt=i("p"),bt.innerHTML=Ql,Re=n(),b=i("details"),$t=i("summary"),$t.textContent=Vl,el=n(),y(Bt.$$.fragment),He=n(),gt=i("p"),gt.innerHTML=kl,xe=n(),y(Zt.$$.fragment),ze=n(),Gt=i("p"),Gt.textContent=Rl,Ye=n(),At=i("ol"),At.innerHTML=Hl,Fe=n(),Nt=i("p"),Nt.textContent=xl,_e=n(),y(Wt.$$.fragment),Le=n(),Xt=i("p"),Xt.textContent=zl,Pe=n(),qt=i("p"),qt.textContent=Yl,De=n(),Et=i("ul"),Et.innerHTML=Fl,Oe=n(),y(St.$$.fragment),Ke=n(),Qt=i("p"),this.h()},l(t){const e=es("svelte-u9bgzb",document.head);o=M(e,"META",{name:!0,content:!0}),e.forEach(l),U=a(t),w=M(t,"P",{}),ll(w).forEach(l),I=a(t),J(B.$$.fragment,t),Vt=a(t),J(g.$$.fragment,t),kt=a(t),Z=M(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-11kksmv"&&(Z.textContent=il),Rt=a(t),J(h.$$.fragment,t),Ht=a(t),J(G.$$.fragment,t),xt=a(t),A=M(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-z0skyq"&&(A.textContent=Ml),zt=a(t),N=M(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-2crr1b"&&(N.textContent=pl),Yt=a(t),W=M(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-dnyg4"&&(W.innerHTML=ol),Ft=a(t),X=M(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-4f7swo"&&(X.textContent=yl),_t=a(t),q=M(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-fxecmn"&&(q.innerHTML=Jl),Lt=a(t),E=M(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-csv139"&&(E.innerHTML=rl),Pt=a(t),S=M(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-lld6nd"&&(S.textContent=Tl),Dt=a(t),v=M(t,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-10gw77w"&&(v.innerHTML=ul),Ot=a(t),$=M(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-1shrp82"&&($.textContent=cl),Kt=a(t),Q=M(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1a0gqw5"&&(Q.innerHTML=wl),te=a(t),V=M(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-r8kuit"&&(V.textContent=Ul),ee=a(t),J(k.$$.fragment,t),le=a(t),R=M(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-13t63ie"&&(R.innerHTML=jl),se=a(t),H=M(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-6jil6r"&&(H.textContent=Il),ne=a(t),x=M(t,"OL",{"data-svelte-h":!0}),p(x)!=="svelte-1vkmkhw"&&(x.innerHTML=dl),ae=a(t),z=M(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1hrp0qn"&&(z.textContent=ml),ie=a(t),J(Y.$$.fragment,t),Me=a(t),F=M(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-o2p4m3"&&(F.textContent=hl),pe=a(t),_=M(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-12e9kdf"&&(_.innerHTML=Cl),oe=a(t),L=M(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1rqdtmf"&&(L.textContent=fl),ye=a(t),J(P.$$.fragment,t),Je=a(t),D=M(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-13oqpkl"&&(D.innerHTML=bl),re=a(t),O=M(t,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-1mxq0ya"&&(O.innerHTML=Bl),Te=a(t),K=M(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-2v5kr8"&&(K.innerHTML=gl),ue=a(t),tt=M(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-5vve8m"&&(tt.textContent=Zl),ce=a(t),J(et.$$.fragment,t),we=a(t),J(lt.$$.fragment,t),Ue=a(t),st=M(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1jgxvf2"&&(st.textContent=Gl),je=a(t),J(nt.$$.fragment,t),Ie=a(t),at=M(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-u4wya2"&&(at.innerHTML=Al),de=a(t),J(it.$$.fragment,t),me=a(t),Mt=M(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-16rd7fj"&&(Mt.textContent=Nl),he=a(t),J(pt.$$.fragment,t),Ce=a(t),J(ot.$$.fragment,t),fe=a(t),yt=M(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-14dcghr"&&(yt.textContent=Wl),be=a(t),J(Jt.$$.fragment,t),Be=a(t),rt=M(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1vvhq4u"&&(rt.textContent=Xl),ge=a(t),J(C.$$.fragment,t),Ze=a(t),J(Tt.$$.fragment,t),Ge=a(t),ut=M(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-llct1j"&&(ut.textContent=ql),Ae=a(t),J(ct.$$.fragment,t),Ne=a(t),J(f.$$.fragment,t),We=a(t),J(wt.$$.fragment,t),Xe=a(t),Ut=M(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-1afb0a0"&&(Ut.textContent=El),qe=a(t),J(jt.$$.fragment,t),Ee=a(t),J(It.$$.fragment,t),Se=a(t),dt=M(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-xfdfb"&&(dt.innerHTML=Sl),ve=a(t),mt=M(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-1kwhso3"&&(mt.textContent=vl),$e=a(t),J(ht.$$.fragment,t),Qe=a(t),Ct=M(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-byxuh9"&&(Ct.textContent=$l),Ve=a(t),J(ft.$$.fragment,t),ke=a(t),bt=M(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-p0i73e"&&(bt.innerHTML=Ql),Re=a(t),b=M(t,"DETAILS",{});var vt=ll(b);$t=M(vt,"SUMMARY",{"data-svelte-h":!0}),p($t)!=="svelte-1ri4alz"&&($t.textContent=Vl),el=a(vt),J(Bt.$$.fragment,vt),vt.forEach(l),He=a(t),gt=M(t,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-p5c6xj"&&(gt.innerHTML=kl),xe=a(t),J(Zt.$$.fragment,t),ze=a(t),Gt=M(t,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-6mo49f"&&(Gt.textContent=Rl),Ye=a(t),At=M(t,"OL",{"data-svelte-h":!0}),p(At)!=="svelte-1rcpgt7"&&(At.innerHTML=Hl),Fe=a(t),Nt=M(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1hlivpl"&&(Nt.textContent=xl),_e=a(t),J(Wt.$$.fragment,t),Le=a(t),Xt=M(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-e08du4"&&(Xt.textContent=zl),Pe=a(t),qt=M(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-8g6jer"&&(qt.textContent=Yl),De=a(t),Et=M(t,"UL",{"data-svelte-h":!0}),p(Et)!=="svelte-gv9avz"&&(Et.innerHTML=Fl),Oe=a(t),J(St.$$.fragment,t),Ke=a(t),Qt=M(t,"P",{}),ll(Qt).forEach(l),this.h()},h(){Pl(o,"name","hf:doc:metadata"),Pl(o,"content",ps)},m(t,e){sl(document.head,o),s(t,U,e),s(t,w,e),s(t,I,e),r(B,t,e),s(t,Vt,e),r(g,t,e),s(t,kt,e),s(t,Z,e),s(t,Rt,e),r(h,t,e),s(t,Ht,e),r(G,t,e),s(t,xt,e),s(t,A,e),s(t,zt,e),s(t,N,e),s(t,Yt,e),s(t,W,e),s(t,Ft,e),s(t,X,e),s(t,_t,e),s(t,q,e),s(t,Lt,e),s(t,E,e),s(t,Pt,e),s(t,S,e),s(t,Dt,e),s(t,v,e),s(t,Ot,e),s(t,$,e),s(t,Kt,e),s(t,Q,e),s(t,te,e),s(t,V,e),s(t,ee,e),r(k,t,e),s(t,le,e),s(t,R,e),s(t,se,e),s(t,H,e),s(t,ne,e),s(t,x,e),s(t,ae,e),s(t,z,e),s(t,ie,e),r(Y,t,e),s(t,Me,e),s(t,F,e),s(t,pe,e),s(t,_,e),s(t,oe,e),s(t,L,e),s(t,ye,e),r(P,t,e),s(t,Je,e),s(t,D,e),s(t,re,e),s(t,O,e),s(t,Te,e),s(t,K,e),s(t,ue,e),s(t,tt,e),s(t,ce,e),r(et,t,e),s(t,we,e),r(lt,t,e),s(t,Ue,e),s(t,st,e),s(t,je,e),r(nt,t,e),s(t,Ie,e),s(t,at,e),s(t,de,e),r(it,t,e),s(t,me,e),s(t,Mt,e),s(t,he,e),r(pt,t,e),s(t,Ce,e),r(ot,t,e),s(t,fe,e),s(t,yt,e),s(t,be,e),r(Jt,t,e),s(t,Be,e),s(t,rt,e),s(t,ge,e),r(C,t,e),s(t,Ze,e),r(Tt,t,e),s(t,Ge,e),s(t,ut,e),s(t,Ae,e),r(ct,t,e),s(t,Ne,e),r(f,t,e),s(t,We,e),r(wt,t,e),s(t,Xe,e),s(t,Ut,e),s(t,qe,e),r(jt,t,e),s(t,Ee,e),r(It,t,e),s(t,Se,e),s(t,dt,e),s(t,ve,e),s(t,mt,e),s(t,$e,e),r(ht,t,e),s(t,Qe,e),s(t,Ct,e),s(t,Ve,e),r(ft,t,e),s(t,ke,e),s(t,bt,e),s(t,Re,e),s(t,b,e),sl(b,$t),sl(b,el),r(Bt,b,null),s(t,He,e),s(t,gt,e),s(t,xe,e),r(Zt,t,e),s(t,ze,e),s(t,Gt,e),s(t,Ye,e),s(t,At,e),s(t,Fe,e),s(t,Nt,e),s(t,_e,e),r(Wt,t,e),s(t,Le,e),s(t,Xt,e),s(t,Pe,e),s(t,qt,e),s(t,De,e),s(t,Et,e),s(t,Oe,e),r(St,t,e),s(t,Ke,e),s(t,Qt,e),tl=!0},p(t,[e]){const vt={};e&2&&(vt.$$scope={dirty:e,ctx:t}),h.$set(vt);const _l={};e&2&&(_l.$$scope={dirty:e,ctx:t}),C.$set(_l);const Ll={};e&2&&(Ll.$$scope={dirty:e,ctx:t}),f.$set(Ll)},i(t){tl||(T(B.$$.fragment,t),T(g.$$.fragment,t),T(h.$$.fragment,t),T(G.$$.fragment,t),T(k.$$.fragment,t),T(Y.$$.fragment,t),T(P.$$.fragment,t),T(et.$$.fragment,t),T(lt.$$.fragment,t),T(nt.$$.fragment,t),T(it.$$.fragment,t),T(pt.$$.fragment,t),T(ot.$$.fragment,t),T(Jt.$$.fragment,t),T(C.$$.fragment,t),T(Tt.$$.fragment,t),T(ct.$$.fragment,t),T(f.$$.fragment,t),T(wt.$$.fragment,t),T(jt.$$.fragment,t),T(It.$$.fragment,t),T(ht.$$.fragment,t),T(ft.$$.fragment,t),T(Bt.$$.fragment,t),T(Zt.$$.fragment,t),T(Wt.$$.fragment,t),T(St.$$.fragment,t),tl=!0)},o(t){u(B.$$.fragment,t),u(g.$$.fragment,t),u(h.$$.fragment,t),u(G.$$.fragment,t),u(k.$$.fragment,t),u(Y.$$.fragment,t),u(P.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ot.$$.fragment,t),u(Jt.$$.fragment,t),u(C.$$.fragment,t),u(Tt.$$.fragment,t),u(ct.$$.fragment,t),u(f.$$.fragment,t),u(wt.$$.fragment,t),u(jt.$$.fragment,t),u(It.$$.fragment,t),u(ht.$$.fragment,t),u(ft.$$.fragment,t),u(Bt.$$.fragment,t),u(Zt.$$.fragment,t),u(Wt.$$.fragment,t),u(St.$$.fragment,t),tl=!1},d(t){t&&(l(U),l(w),l(I),l(Vt),l(kt),l(Z),l(Rt),l(Ht),l(xt),l(A),l(zt),l(N),l(Yt),l(W),l(Ft),l(X),l(_t),l(q),l(Lt),l(E),l(Pt),l(S),l(Dt),l(v),l(Ot),l($),l(Kt),l(Q),l(te),l(V),l(ee),l(le),l(R),l(se),l(H),l(ne),l(x),l(ae),l(z),l(ie),l(Me),l(F),l(pe),l(_),l(oe),l(L),l(ye),l(Je),l(D),l(re),l(O),l(Te),l(K),l(ue),l(tt),l(ce),l(we),l(Ue),l(st),l(je),l(Ie),l(at),l(de),l(me),l(Mt),l(he),l(Ce),l(fe),l(yt),l(be),l(Be),l(rt),l(ge),l(Ze),l(Ge),l(ut),l(Ae),l(Ne),l(We),l(Xe),l(Ut),l(qe),l(Ee),l(Se),l(dt),l(ve),l(mt),l($e),l(Qe),l(Ct),l(Ve),l(ke),l(bt),l(Re),l(b),l(He),l(gt),l(xe),l(ze),l(Gt),l(Ye),l(At),l(Fe),l(Nt),l(_e),l(Le),l(Xt),l(Pe),l(qt),l(De),l(Et),l(Oe),l(Ke),l(Qt)),l(o),c(B,t),c(g,t),c(h,t),c(G,t),c(k,t),c(Y,t),c(P,t),c(et,t),c(lt,t),c(nt,t),c(it,t),c(pt,t),c(ot,t),c(Jt,t),c(C,t),c(Tt,t),c(ct,t),c(f,t),c(wt,t),c(jt,t),c(It,t),c(ht,t),c(ft,t),c(Bt),c(Zt,t),c(Wt,t),c(St,t)}}}const ps='{"title":"Create your own transcription app","local":"create-your-own-transcription-app","sections":[{"title":"Create your transcription endpoint","local":"create-your-transcription-endpoint","sections":[],"depth":2},{"title":"Create your text generation endpoint","local":"create-your-text-generation-endpoint","sections":[],"depth":2},{"title":"Test your endpoints","local":"test-your-endpoints","sections":[],"depth":2},{"title":"Get your endpoint details","local":"get-your-endpoint-details","sections":[],"depth":2},{"title":"Building the transcription app","local":"building-the-transcription-app","sections":[{"title":"Step 1: Set up dependencies and imports","local":"step-1-set-up-dependencies-and-imports","sections":[],"depth":3},{"title":"Step 2: Configure your endpoint connections","local":"step-2-configure-your-endpoint-connections","sections":[],"depth":3},{"title":"Step 3: Create the transcription function","local":"step-3-create-the-transcription-function","sections":[],"depth":3},{"title":"Step 4: Create the summarization function","local":"step-4-create-the-summarization-function","sections":[],"depth":3},{"title":"Step 5: Wrap it all together","local":"step-5-wrap-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Deploy your transcription app","local":"deploy-your-transcription-app","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function os(m){return Ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Kl{constructor(o){super(),ts(this,o,os,Ms,Dl,{})}}export{cs as component};
