import{s as Ws,a as $s,n as As,o as Vs}from"../chunks/scheduler.3d32dc09.js";import{S as Es,i as Rs,e as i,s,c as r,h as Ns,a as o,d as l,b as a,f as Gs,g as M,j as p,k as J,l as Qs,m as n,n as u,t as c,o as y,p as d}from"../chunks/index.f9718211.js";import{C as Ss,H as w,E as _s}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6dc416b7.js";import{C as m}from"../chunks/CodeBlock.7afc40bd.js";import{D as Hs}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function Ys(Un){let T,ht,Jt,bt,x,Ut,B,It,v,jt,h,In='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',gt,k,ft,Z,jn='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Ct,$,gn="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",xt,G,fn="Code is just a better way to express actions on a computer. It has better:",Bt,W,Cn="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",vt,A,xn='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',kt,wt,Bn,Zt,V,vn="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",$t,E,Gt,R,kn="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",Wt,N,Zn="This is inherently risky, LLM-generated code could be harmful to your environment.",At,Q,$n="Malicious code execution can occur in several ways:",Vt,S,Gn=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,Et,_,Wn='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',Rt,H,An="So you need to be very mindful of security.",Nt,Y,Vn="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",Qt,q,En="We advise you to keep in mind that no solution will be 100% safe.",St,mt,Rn,_t,X,Ht,L,Nn=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,Yt,z,Qn="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",qt,F,Sn=`<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.
<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>`,Xt,D,_n="You could try these safeguards as follows:",Lt,P,zt,K,Hn=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,Ft,b,Yn="<p>It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.</p> <p>For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.</p> <p>Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.</p>",Dt,O,qn=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,Pt,ee,Kt,te,Xn="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",Ot,le,Ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="Sandbox approaches comparison"/>',el,ne,zn=`<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;blaxel&quot;</code>, <code>executor_type=&quot;e2b&quot;</code>, <code>executor_type=&quot;modal&quot;</code>, or
<code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>`,tl,se,Fn="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",ll,ae,nl,ie,sl,oe,Dn='<li>Create a Blaxel account at <a href="https://blaxel.ai" rel="nofollow">blaxel.ai</a></li> <li>Install the required packages:</li>',al,pe,il,re,ol,Me,Pn="We provide a simple way to use a Blaxel Sandbox: simply add <code>executor_type=&quot;blaxel&quot;</code> to the agent initialization, as follows:",pl,ue,rl,U,Kn=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Blaxel sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Ml,ce,On=`This solution sends the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,ul,ye,es="Blaxel provides fast-launching virtual machines that start from hibernation in under 25ms and scale back to zero after inactivity while maintaining memory state, making it an excellent choice for agent applications that require quick, secure code execution.",cl,I,ts='<p>For even stronger security isolation, you can host your entire agent remotely on Blaxel. This provides complete sandboxing of the agent, model, and tools. See the <a href="https://docs.blaxel.ai/Agents/Develop-an-agent-py" rel="nofollow">Blaxel agent hosting documentation</a> for details.</p>',yl,de,dl,we,wl,me,ls='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',ml,Je,Jl,Te,Tl,he,ns="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",hl,be,bl,j,ss=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Ul,Ue,as=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,Il,Ie,is="This is illustrated in the figure below.",jl,g,os='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',gl,je,ps=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,fl,ge,Cl,fe,rs="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",xl,Ce,Ms="Here is how to do it:",Bl,xe,vl,Be,kl,ve,Zl,ke,us='<li>Create a Modal account at <a href="https://modal.com/signup" rel="nofollow">modal.com</a></li> <li>Install the required packages:</li>',$l,Ze,Gl,$e,Wl,Ge,cs="We provide a simple way to use a Modal Sandbox: simply add <code>executor_type=&quot;modal&quot;</code> to the agent initialization, as follows:",Al,We,Vl,f,ys=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Modal sandbox is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,El,Ae,ds="The agent state and generated code from the <code>InferenceClientModel</code> are sent to a Modal sandbox, which can securely execute code inside them.",Rl,Ve,Nl,Ee,Ql,Re,ws='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',Sl,Ne,_l,Qe,Hl,Se,ms="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Yl,_e,ql,C,Js=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Xl,He,Ll,Ye,Ts="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",zl,qe,hs="Here is how to setup the a Dockerfile:",Fl,Xe,Dl,Le,bs="Create a sandbox manager to run code:",Pl,ze,Kl,Fe,Ol,De,Us=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,en,Pe,Is='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',tn,Ke,ln,Oe,js='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',nn,et,sn,tt,gs="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",an,lt,on,nt,pn,st,fs="These key practices apply to Blaxel, E2B, and Docker sandboxes:",rn,at,Cs="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",Mn,it,xs="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",un,ot,cn,pt,Bs="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",yn,rt,dn,Mt,vs=`<li><strong>Pros</strong>: 
<ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;blaxel&quot;</code>, <code>executor_type=&quot;e2b&quot;</code>, or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li> <li>Fast execution with Blaxel’s hibernation technology (&lt;25ms startup)</li></ul></li> <li><strong>Cons</strong>:
<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>`,wn,ut,mn,ct,ks=`<li><strong>Pros</strong>:
<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:
<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>`,Jn,yt,Zs="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Tn,dt,hn,Tt,bn;return x=new Ss({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new Hs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),v=new w({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),k=new w({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),E=new w({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),X=new w({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),P=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),ee=new w({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),ae=new w({props:{title:"Blaxel setup",local:"blaxel-setup",headingTag:"h3"}}),ie=new w({props:{title:"Installation",local:"installation",headingTag:"h4"}}),pe=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCYmxheGVsJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[blaxel]&#x27;</span>',wrap:!1}}),re=new w({props:{title:"Running your agent with Blaxel: quick start",local:"running-your-agent-with-blaxel-quick-start",headingTag:"h4"}}),ue=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyYmxheGVsJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;blaxel&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),de=new w({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),we=new w({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Je=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),Te=new w({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),be=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZTJiJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),ge=new w({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),xe=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),Be=new w({props:{title:"Modal setup",local:"modal-setup",headingTag:"h3"}}),ve=new w({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Ze=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbW9kYWwlNUQn",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[modal]&#x27;</span>',wrap:!1}}),$e=new w({props:{title:"Running your agent in Modal: quick start",local:"running-your-agent-in-modal-quick-start",headingTag:"h4"}}),We=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIybW9kYWwlMjIpJTIwYXMlMjBhZ2VudCUzQSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjA0MnRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;modal&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;What is the 42th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ve=new w({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),Ee=new w({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Ne=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),Qe=new w({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),_e=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZG9ja2VyJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),He=new w({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),Xe=new m({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),ze=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Fe=new w({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),Ke=new w({props:{title:"Installation",local:"installation",headingTag:"h4"}}),et=new w({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),lt=new m({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),nt=new w({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),ot=new w({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),rt=new w({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),ut=new w({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),dt=new _s({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){T=i("meta"),ht=s(),Jt=i("p"),bt=s(),r(x.$$.fragment),Ut=s(),r(B.$$.fragment),It=s(),r(v.$$.fragment),jt=s(),h=i("blockquote"),h.innerHTML=In,gt=s(),r(k.$$.fragment),ft=s(),Z=i("p"),Z.innerHTML=jn,Ct=s(),$=i("p"),$.textContent=gn,xt=s(),G=i("p"),G.textContent=fn,Bt=s(),W=i("ul"),W.innerHTML=Cn,vt=s(),A=i("p"),A.innerHTML=xn,kt=s(),wt=i("img"),Zt=s(),V=i("p"),V.textContent=vn,$t=s(),r(E.$$.fragment),Gt=s(),R=i("p"),R.innerHTML=kn,Wt=s(),N=i("p"),N.textContent=Zn,At=s(),Q=i("p"),Q.textContent=$n,Vt=s(),S=i("ul"),S.innerHTML=Gn,Et=s(),_=i("p"),_.innerHTML=Wn,Rt=s(),H=i("p"),H.textContent=An,Nt=s(),Y=i("p"),Y.textContent=Vn,Qt=s(),q=i("p"),q.textContent=En,St=s(),mt=i("img"),_t=s(),r(X.$$.fragment),Ht=s(),L=i("p"),L.innerHTML=Nn,Yt=s(),z=i("p"),z.textContent=Qn,qt=s(),F=i("ul"),F.innerHTML=Sn,Xt=s(),D=i("p"),D.textContent=_n,Lt=s(),r(P.$$.fragment),zt=s(),K=i("p"),K.textContent=Hn,Ft=s(),b=i("blockquote"),b.innerHTML=Yn,Dt=s(),O=i("p"),O.textContent=qn,Pt=s(),r(ee.$$.fragment),Kt=s(),te=i("p"),te.textContent=Xn,Ot=s(),le=i("p"),le.innerHTML=Ln,el=s(),ne=i("ol"),ne.innerHTML=zn,tl=s(),se=i("p"),se.textContent=Fn,ll=s(),r(ae.$$.fragment),nl=s(),r(ie.$$.fragment),sl=s(),oe=i("ol"),oe.innerHTML=Dn,al=s(),r(pe.$$.fragment),il=s(),r(re.$$.fragment),ol=s(),Me=i("p"),Me.innerHTML=Pn,pl=s(),r(ue.$$.fragment),rl=s(),U=i("blockquote"),U.innerHTML=Kn,Ml=s(),ce=i("p"),ce.innerHTML=On,ul=s(),ye=i("p"),ye.textContent=es,cl=s(),I=i("blockquote"),I.innerHTML=ts,yl=s(),r(de.$$.fragment),dl=s(),r(we.$$.fragment),wl=s(),me=i("ol"),me.innerHTML=ls,ml=s(),r(Je.$$.fragment),Jl=s(),r(Te.$$.fragment),Tl=s(),he=i("p"),he.innerHTML=ns,hl=s(),r(be.$$.fragment),bl=s(),j=i("blockquote"),j.innerHTML=ss,Ul=s(),Ue=i("p"),Ue.innerHTML=as,Il=s(),Ie=i("p"),Ie.textContent=is,jl=s(),g=i("p"),g.innerHTML=os,gl=s(),je=i("p"),je.innerHTML=ps,fl=s(),r(ge.$$.fragment),Cl=s(),fe=i("p"),fe.textContent=rs,xl=s(),Ce=i("p"),Ce.textContent=Ms,Bl=s(),r(xe.$$.fragment),vl=s(),r(Be.$$.fragment),kl=s(),r(ve.$$.fragment),Zl=s(),ke=i("ol"),ke.innerHTML=us,$l=s(),r(Ze.$$.fragment),Gl=s(),r($e.$$.fragment),Wl=s(),Ge=i("p"),Ge.innerHTML=cs,Al=s(),r(We.$$.fragment),Vl=s(),f=i("blockquote"),f.innerHTML=ys,El=s(),Ae=i("p"),Ae.innerHTML=ds,Rl=s(),r(Ve.$$.fragment),Nl=s(),r(Ee.$$.fragment),Ql=s(),Re=i("ol"),Re.innerHTML=ws,Sl=s(),r(Ne.$$.fragment),_l=s(),r(Qe.$$.fragment),Hl=s(),Se=i("p"),Se.innerHTML=ms,Yl=s(),r(_e.$$.fragment),ql=s(),C=i("blockquote"),C.innerHTML=Js,Xl=s(),r(He.$$.fragment),Ll=s(),Ye=i("p"),Ye.textContent=Ts,zl=s(),qe=i("p"),qe.textContent=hs,Fl=s(),r(Xe.$$.fragment),Dl=s(),Le=i("p"),Le.textContent=bs,Pl=s(),r(ze.$$.fragment),Kl=s(),r(Fe.$$.fragment),Ol=s(),De=i("p"),De.textContent=Us,en=s(),Pe=i("p"),Pe.innerHTML=Is,tn=s(),r(Ke.$$.fragment),ln=s(),Oe=i("ol"),Oe.innerHTML=js,nn=s(),r(et.$$.fragment),sn=s(),tt=i("p"),tt.innerHTML=gs,an=s(),r(lt.$$.fragment),on=s(),r(nt.$$.fragment),pn=s(),st=i("p"),st.textContent=fs,rn=s(),at=i("ul"),at.innerHTML=Cs,Mn=s(),it=i("p"),it.textContent=xs,un=s(),r(ot.$$.fragment),cn=s(),pt=i("p"),pt.textContent=Bs,yn=s(),r(rt.$$.fragment),dn=s(),Mt=i("ul"),Mt.innerHTML=vs,wn=s(),r(ut.$$.fragment),mn=s(),ct=i("ul"),ct.innerHTML=ks,Jn=s(),yt=i("p"),yt.textContent=Zs,Tn=s(),r(dt.$$.fragment),hn=s(),Tt=i("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),ht=a(e),Jt=o(e,"P",{}),Gs(Jt).forEach(l),bt=a(e),M(x.$$.fragment,e),Ut=a(e),M(B.$$.fragment,e),It=a(e),M(v.$$.fragment,e),jt=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-1eo9frz"&&(h.innerHTML=In),gt=a(e),M(k.$$.fragment,e),ft=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1nor5c0"&&(Z.innerHTML=jn),Ct=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1b2f48c"&&($.textContent=gn),xt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1jp5kiv"&&(G.textContent=fn),Bt=a(e),W=o(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-a7ou7n"&&(W.innerHTML=Cn),vt=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1ugtxvn"&&(A.innerHTML=xn),kt=a(e),wt=o(e,"IMG",{src:!0}),Zt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1lbgv3o"&&(V.textContent=vn),$t=a(e),M(E.$$.fragment,e),Gt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-19p3p3d"&&(R.innerHTML=kn),Wt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-y55i8i"&&(N.textContent=Zn),At=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-y4kupg"&&(Q.textContent=$n),Vt=a(e),S=o(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1b6z7ic"&&(S.innerHTML=Gn),Et=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-uopq3c"&&(_.innerHTML=Wn),Rt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-gfolx1"&&(H.textContent=An),Nt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1j1i1cv"&&(Y.textContent=Vn),Qt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ghwkh9"&&(q.textContent=En),St=a(e),mt=o(e,"IMG",{src:!0}),_t=a(e),M(X.$$.fragment,e),Ht=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-845rka"&&(L.innerHTML=Nn),Yt=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-180snho"&&(z.textContent=Qn),qt=a(e),F=o(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-1ukc2t6"&&(F.innerHTML=Sn),Xt=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1wz8jbt"&&(D.textContent=_n),Lt=a(e),M(P.$$.fragment,e),zt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1gk7uki"&&(K.textContent=Hn),Ft=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-620wn8"&&(b.innerHTML=Yn),Dt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-whkli4"&&(O.textContent=qn),Pt=a(e),M(ee.$$.fragment,e),Kt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-grnb59"&&(te.textContent=Xn),Ot=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1r04sc2"&&(le.innerHTML=Ln),el=a(e),ne=o(e,"OL",{"data-svelte-h":!0}),p(ne)!=="svelte-1ghdlwu"&&(ne.innerHTML=zn),tl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1h3g1zs"&&(se.textContent=Fn),ll=a(e),M(ae.$$.fragment,e),nl=a(e),M(ie.$$.fragment,e),sl=a(e),oe=o(e,"OL",{"data-svelte-h":!0}),p(oe)!=="svelte-hgtr4l"&&(oe.innerHTML=Dn),al=a(e),M(pe.$$.fragment,e),il=a(e),M(re.$$.fragment,e),ol=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-x3nrqj"&&(Me.innerHTML=Pn),pl=a(e),M(ue.$$.fragment,e),rl=a(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-aigfdt"&&(U.innerHTML=Kn),Ml=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1x1dv2u"&&(ce.innerHTML=On),ul=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1hr3dw4"&&(ye.textContent=es),cl=a(e),I=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-vkl2pa"&&(I.innerHTML=ts),yl=a(e),M(de.$$.fragment,e),dl=a(e),M(we.$$.fragment,e),wl=a(e),me=o(e,"OL",{"data-svelte-h":!0}),p(me)!=="svelte-uvtwg2"&&(me.innerHTML=ls),ml=a(e),M(Je.$$.fragment,e),Jl=a(e),M(Te.$$.fragment,e),Tl=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-r3242t"&&(he.innerHTML=ns),hl=a(e),M(be.$$.fragment,e),bl=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-1mfz8t0"&&(j.innerHTML=ss),Ul=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-jrgx8f"&&(Ue.innerHTML=as),Il=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-8sir7q"&&(Ie.textContent=is),jl=a(e),g=o(e,"P",{align:!0,"data-svelte-h":!0}),p(g)!=="svelte-11rtdvt"&&(g.innerHTML=os),gl=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-ofpo9r"&&(je.innerHTML=ps),fl=a(e),M(ge.$$.fragment,e),Cl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-geglm0"&&(fe.textContent=rs),xl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1iycphr"&&(Ce.textContent=Ms),Bl=a(e),M(xe.$$.fragment,e),vl=a(e),M(Be.$$.fragment,e),kl=a(e),M(ve.$$.fragment,e),Zl=a(e),ke=o(e,"OL",{"data-svelte-h":!0}),p(ke)!=="svelte-18yk2df"&&(ke.innerHTML=us),$l=a(e),M(Ze.$$.fragment,e),Gl=a(e),M($e.$$.fragment,e),Wl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-fv88x1"&&(Ge.innerHTML=cs),Al=a(e),M(We.$$.fragment,e),Vl=a(e),f=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-tfrjt3"&&(f.innerHTML=ys),El=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1tt8eoy"&&(Ae.innerHTML=ds),Rl=a(e),M(Ve.$$.fragment,e),Nl=a(e),M(Ee.$$.fragment,e),Ql=a(e),Re=o(e,"OL",{"data-svelte-h":!0}),p(Re)!=="svelte-19h0avy"&&(Re.innerHTML=ws),Sl=a(e),M(Ne.$$.fragment,e),_l=a(e),M(Qe.$$.fragment,e),Hl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1j9zoi1"&&(Se.innerHTML=ms),Yl=a(e),M(_e.$$.fragment,e),ql=a(e),C=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(C)!=="svelte-1y2mdhk"&&(C.innerHTML=Js),Xl=a(e),M(He.$$.fragment,e),Ll=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-t1it0d"&&(Ye.textContent=Ts),zl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1lygj8"&&(qe.textContent=hs),Fl=a(e),M(Xe.$$.fragment,e),Dl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-8mtm8c"&&(Le.textContent=bs),Pl=a(e),M(ze.$$.fragment,e),Kl=a(e),M(Fe.$$.fragment,e),Ol=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-ozg6k5"&&(De.textContent=Us),en=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1f0518g"&&(Pe.innerHTML=Is),tn=a(e),M(Ke.$$.fragment,e),ln=a(e),Oe=o(e,"OL",{"data-svelte-h":!0}),p(Oe)!=="svelte-18eum27"&&(Oe.innerHTML=js),nn=a(e),M(et.$$.fragment,e),sn=a(e),tt=o(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-zmyq9d"&&(tt.innerHTML=gs),an=a(e),M(lt.$$.fragment,e),on=a(e),M(nt.$$.fragment,e),pn=a(e),st=o(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-12hbx8o"&&(st.textContent=fs),rn=a(e),at=o(e,"UL",{"data-svelte-h":!0}),p(at)!=="svelte-162p62u"&&(at.innerHTML=Cs),Mn=a(e),it=o(e,"P",{"data-svelte-h":!0}),p(it)!=="svelte-1hbg2e4"&&(it.textContent=xs),un=a(e),M(ot.$$.fragment,e),cn=a(e),pt=o(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-i4top7"&&(pt.textContent=Bs),yn=a(e),M(rt.$$.fragment,e),dn=a(e),Mt=o(e,"UL",{"data-svelte-h":!0}),p(Mt)!=="svelte-rneg7z"&&(Mt.innerHTML=vs),wn=a(e),M(ut.$$.fragment,e),mn=a(e),ct=o(e,"UL",{"data-svelte-h":!0}),p(ct)!=="svelte-rn5tr"&&(ct.innerHTML=ks),Jn=a(e),yt=o(e,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-l1ns7z"&&(yt.textContent=Zs),Tn=a(e),M(dt.$$.fragment,e),hn=a(e),Tt=o(e,"P",{}),Gs(Tt).forEach(l),this.h()},h(){J(T,"name","hf:doc:metadata"),J(T,"content",qs),J(h,"class","tip"),$s(wt.src,Bn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||J(wt,"src",Bn),$s(mt.src,Rn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||J(mt,"src",Rn),J(b,"class","warning"),J(U,"class","tip"),J(I,"class","tip"),J(j,"class","tip"),J(g,"align","center"),J(f,"class","tip"),J(C,"class","tip")},m(e,t){Qs(document.head,T),n(e,ht,t),n(e,Jt,t),n(e,bt,t),u(x,e,t),n(e,Ut,t),u(B,e,t),n(e,It,t),u(v,e,t),n(e,jt,t),n(e,h,t),n(e,gt,t),u(k,e,t),n(e,ft,t),n(e,Z,t),n(e,Ct,t),n(e,$,t),n(e,xt,t),n(e,G,t),n(e,Bt,t),n(e,W,t),n(e,vt,t),n(e,A,t),n(e,kt,t),n(e,wt,t),n(e,Zt,t),n(e,V,t),n(e,$t,t),u(E,e,t),n(e,Gt,t),n(e,R,t),n(e,Wt,t),n(e,N,t),n(e,At,t),n(e,Q,t),n(e,Vt,t),n(e,S,t),n(e,Et,t),n(e,_,t),n(e,Rt,t),n(e,H,t),n(e,Nt,t),n(e,Y,t),n(e,Qt,t),n(e,q,t),n(e,St,t),n(e,mt,t),n(e,_t,t),u(X,e,t),n(e,Ht,t),n(e,L,t),n(e,Yt,t),n(e,z,t),n(e,qt,t),n(e,F,t),n(e,Xt,t),n(e,D,t),n(e,Lt,t),u(P,e,t),n(e,zt,t),n(e,K,t),n(e,Ft,t),n(e,b,t),n(e,Dt,t),n(e,O,t),n(e,Pt,t),u(ee,e,t),n(e,Kt,t),n(e,te,t),n(e,Ot,t),n(e,le,t),n(e,el,t),n(e,ne,t),n(e,tl,t),n(e,se,t),n(e,ll,t),u(ae,e,t),n(e,nl,t),u(ie,e,t),n(e,sl,t),n(e,oe,t),n(e,al,t),u(pe,e,t),n(e,il,t),u(re,e,t),n(e,ol,t),n(e,Me,t),n(e,pl,t),u(ue,e,t),n(e,rl,t),n(e,U,t),n(e,Ml,t),n(e,ce,t),n(e,ul,t),n(e,ye,t),n(e,cl,t),n(e,I,t),n(e,yl,t),u(de,e,t),n(e,dl,t),u(we,e,t),n(e,wl,t),n(e,me,t),n(e,ml,t),u(Je,e,t),n(e,Jl,t),u(Te,e,t),n(e,Tl,t),n(e,he,t),n(e,hl,t),u(be,e,t),n(e,bl,t),n(e,j,t),n(e,Ul,t),n(e,Ue,t),n(e,Il,t),n(e,Ie,t),n(e,jl,t),n(e,g,t),n(e,gl,t),n(e,je,t),n(e,fl,t),u(ge,e,t),n(e,Cl,t),n(e,fe,t),n(e,xl,t),n(e,Ce,t),n(e,Bl,t),u(xe,e,t),n(e,vl,t),u(Be,e,t),n(e,kl,t),u(ve,e,t),n(e,Zl,t),n(e,ke,t),n(e,$l,t),u(Ze,e,t),n(e,Gl,t),u($e,e,t),n(e,Wl,t),n(e,Ge,t),n(e,Al,t),u(We,e,t),n(e,Vl,t),n(e,f,t),n(e,El,t),n(e,Ae,t),n(e,Rl,t),u(Ve,e,t),n(e,Nl,t),u(Ee,e,t),n(e,Ql,t),n(e,Re,t),n(e,Sl,t),u(Ne,e,t),n(e,_l,t),u(Qe,e,t),n(e,Hl,t),n(e,Se,t),n(e,Yl,t),u(_e,e,t),n(e,ql,t),n(e,C,t),n(e,Xl,t),u(He,e,t),n(e,Ll,t),n(e,Ye,t),n(e,zl,t),n(e,qe,t),n(e,Fl,t),u(Xe,e,t),n(e,Dl,t),n(e,Le,t),n(e,Pl,t),u(ze,e,t),n(e,Kl,t),u(Fe,e,t),n(e,Ol,t),n(e,De,t),n(e,en,t),n(e,Pe,t),n(e,tn,t),u(Ke,e,t),n(e,ln,t),n(e,Oe,t),n(e,nn,t),u(et,e,t),n(e,sn,t),n(e,tt,t),n(e,an,t),u(lt,e,t),n(e,on,t),u(nt,e,t),n(e,pn,t),n(e,st,t),n(e,rn,t),n(e,at,t),n(e,Mn,t),n(e,it,t),n(e,un,t),u(ot,e,t),n(e,cn,t),n(e,pt,t),n(e,yn,t),u(rt,e,t),n(e,dn,t),n(e,Mt,t),n(e,wn,t),u(ut,e,t),n(e,mn,t),n(e,ct,t),n(e,Jn,t),n(e,yt,t),n(e,Tn,t),u(dt,e,t),n(e,hn,t),n(e,Tt,t),bn=!0},p:As,i(e){bn||(c(x.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(X.$$.fragment,e),c(P.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(xe.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c($e.$$.fragment,e),c(We.$$.fragment,e),c(Ve.$$.fragment,e),c(Ee.$$.fragment,e),c(Ne.$$.fragment,e),c(Qe.$$.fragment,e),c(_e.$$.fragment,e),c(He.$$.fragment,e),c(Xe.$$.fragment,e),c(ze.$$.fragment,e),c(Fe.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(lt.$$.fragment,e),c(nt.$$.fragment,e),c(ot.$$.fragment,e),c(rt.$$.fragment,e),c(ut.$$.fragment,e),c(dt.$$.fragment,e),bn=!0)},o(e){y(x.$$.fragment,e),y(B.$$.fragment,e),y(v.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(X.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(we.$$.fragment,e),y(Je.$$.fragment,e),y(Te.$$.fragment,e),y(be.$$.fragment,e),y(ge.$$.fragment,e),y(xe.$$.fragment,e),y(Be.$$.fragment,e),y(ve.$$.fragment,e),y(Ze.$$.fragment,e),y($e.$$.fragment,e),y(We.$$.fragment,e),y(Ve.$$.fragment,e),y(Ee.$$.fragment,e),y(Ne.$$.fragment,e),y(Qe.$$.fragment,e),y(_e.$$.fragment,e),y(He.$$.fragment,e),y(Xe.$$.fragment,e),y(ze.$$.fragment,e),y(Fe.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(lt.$$.fragment,e),y(nt.$$.fragment,e),y(ot.$$.fragment,e),y(rt.$$.fragment,e),y(ut.$$.fragment,e),y(dt.$$.fragment,e),bn=!1},d(e){e&&(l(ht),l(Jt),l(bt),l(Ut),l(It),l(jt),l(h),l(gt),l(ft),l(Z),l(Ct),l($),l(xt),l(G),l(Bt),l(W),l(vt),l(A),l(kt),l(wt),l(Zt),l(V),l($t),l(Gt),l(R),l(Wt),l(N),l(At),l(Q),l(Vt),l(S),l(Et),l(_),l(Rt),l(H),l(Nt),l(Y),l(Qt),l(q),l(St),l(mt),l(_t),l(Ht),l(L),l(Yt),l(z),l(qt),l(F),l(Xt),l(D),l(Lt),l(zt),l(K),l(Ft),l(b),l(Dt),l(O),l(Pt),l(Kt),l(te),l(Ot),l(le),l(el),l(ne),l(tl),l(se),l(ll),l(nl),l(sl),l(oe),l(al),l(il),l(ol),l(Me),l(pl),l(rl),l(U),l(Ml),l(ce),l(ul),l(ye),l(cl),l(I),l(yl),l(dl),l(wl),l(me),l(ml),l(Jl),l(Tl),l(he),l(hl),l(bl),l(j),l(Ul),l(Ue),l(Il),l(Ie),l(jl),l(g),l(gl),l(je),l(fl),l(Cl),l(fe),l(xl),l(Ce),l(Bl),l(vl),l(kl),l(Zl),l(ke),l($l),l(Gl),l(Wl),l(Ge),l(Al),l(Vl),l(f),l(El),l(Ae),l(Rl),l(Nl),l(Ql),l(Re),l(Sl),l(_l),l(Hl),l(Se),l(Yl),l(ql),l(C),l(Xl),l(Ll),l(Ye),l(zl),l(qe),l(Fl),l(Dl),l(Le),l(Pl),l(Kl),l(Ol),l(De),l(en),l(Pe),l(tn),l(ln),l(Oe),l(nn),l(sn),l(tt),l(an),l(on),l(pn),l(st),l(rn),l(at),l(Mn),l(it),l(un),l(cn),l(pt),l(yn),l(dn),l(Mt),l(wn),l(mn),l(ct),l(Jn),l(yt),l(Tn),l(hn),l(Tt)),l(T),d(x,e),d(B,e),d(v,e),d(k,e),d(E,e),d(X,e),d(P,e),d(ee,e),d(ae,e),d(ie,e),d(pe,e),d(re,e),d(ue,e),d(de,e),d(we,e),d(Je,e),d(Te,e),d(be,e),d(ge,e),d(xe,e),d(Be,e),d(ve,e),d(Ze,e),d($e,e),d(We,e),d(Ve,e),d(Ee,e),d(Ne,e),d(Qe,e),d(_e,e),d(He,e),d(Xe,e),d(ze,e),d(Fe,e),d(Ke,e),d(et,e),d(lt,e),d(nt,e),d(ot,e),d(rt,e),d(ut,e),d(dt,e)}}}const qs='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"Blaxel setup","local":"blaxel-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent with Blaxel: quick start","local":"running-your-agent-with-blaxel-quick-start","sections":[],"depth":4}],"depth":3},{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Modal setup","local":"modal-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Modal: quick start","local":"running-your-agent-in-modal-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xs(Un){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends Es{constructor(T){super(),Rs(this,T,Xs,Ys,Ws,{})}}export{Ks as component};
