import{s as Ht,n as St,o as _t}from"../chunks/scheduler.3d32dc09.js";import{S as Yt,i as zt,e as i,s as n,c as p,h as Et,a as o,d as l,b as a,f as qt,g as M,j as r,k as ut,l as Ft,m as s,n as c,t as m,o as u,p as y}from"../chunks/index.f9718211.js";import{C as Lt,H as d,E as Pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6dc416b7.js";import{C as me}from"../chunks/CodeBlock.7afc40bd.js";import{D as Dt}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function Kt(yt){let w,de,ue,we,T,je,g,Je,h,Te,f,ge,b,dt="Retrieval-Augmented Generation (RAG) combines the power of large language models with external knowledge retrieval to produce more accurate, factual, and contextually relevant responses. At its core, RAG is about “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base.”",he,U,fe,I,wt="RAG offers several significant advantages over using vanilla or fine-tuned LLMs:",be,v,jt="<li><strong>Factual Grounding</strong>: Reduces hallucinations by anchoring responses in retrieved facts</li> <li><strong>Domain Specialization</strong>: Provides domain-specific knowledge without model retraining</li> <li><strong>Knowledge Recency</strong>: Allows access to information beyond the model’s training cutoff</li> <li><strong>Transparency</strong>: Enables citation of sources for generated content</li> <li><strong>Control</strong>: Offers fine-grained control over what information the model can access</li>",Ue,C,Ie,B,Jt="Despite its benefits, traditional RAG approaches face several challenges:",ve,Z,Tt="<li><strong>Single Retrieval Step</strong>: If the initial retrieval results are poor, the final generation will suffer</li> <li><strong>Query-Document Mismatch</strong>: User queries (often questions) may not match well with documents containing answers (often statements)</li> <li><strong>Limited Reasoning</strong>: Simple RAG pipelines don’t allow for multi-step reasoning or query refinement</li> <li><strong>Context Window Constraints</strong>: Retrieved documents must fit within the model’s context window</li>",Ce,A,Be,$,gt="We can overcome these limitations by implementing an <strong>Agentic RAG</strong> system - essentially an agent equipped with retrieval capabilities. This approach transforms RAG from a rigid pipeline into an interactive, reasoning-driven process.",Ze,G,Ae,R,ht="An agent with retrieval tools can:",$e,W,ft="<li>✅ <strong>Formulate optimized queries</strong>: The agent can transform user questions into retrieval-friendly queries</li> <li>✅ <strong>Perform multiple retrievals</strong>: The agent can retrieve information iteratively as needed</li> <li>✅ <strong>Reason over retrieved content</strong>: The agent can analyze, synthesize, and draw conclusions from multiple sources</li> <li>✅ <strong>Self-critique and refine</strong>: The agent can evaluate retrieval results and adjust its approach</li>",Ge,k,bt="This approach naturally implements advanced RAG techniques:",Re,x,Ut='<li><strong>Hypothetical Document Embedding (HyDE)</strong>: Instead of using the user query directly, the agent formulates retrieval-optimized queries (<a href="https://huggingface.co/papers/2212.10496" rel="nofollow">paper reference</a>)</li> <li><strong>Self-Query Refinement</strong>: The agent can analyze initial results and perform follow-up retrievals with refined queries (<a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">technique reference</a>)</li>',We,V,ke,X,It="Let’s build a complete Agentic RAG system step by step. We’ll create an agent that can answer questions about the Hugging Face Transformers library by retrieving information from its documentation.",xe,Q,vt='You can follow along with the code snippets below, or check out the full example in the smolagents GitHub repository: <a href="https://github.com/huggingface/smolagents/blob/main/examples/rag.py" rel="nofollow">examples/rag.py</a>.',Ve,N,Xe,q,Ct="First, we need to install the necessary packages:",Qe,H,Ne,S,Bt="If you plan to use Hugging Face’s Inference API, you’ll need to set up your API token:",qe,_,He,Y,Se,z,Zt="We’ll use a dataset containing Hugging Face documentation and prepare it for retrieval:",_e,E,Ye,F,ze,L,At="Now we’ll create a custom tool that our agent can use to retrieve information from the knowledge base:",Ee,P,Fe,j,$t='<p>We’re using BM25, a lexical retrieval method, for simplicity and speed. For production systems, you might want to use semantic search with embeddings for better retrieval quality. Check the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> for high-quality embedding models.</p>',Le,D,Pe,K,Gt="Now we’ll create an agent that can use our retriever tool to answer questions:",De,O,Ke,J,Rt='<p>Inference Providers give access to hundreds of models, powered by serverless inference partners. A list of supported providers can be found <a href="https://huggingface.co/docs/inference-providers/index" rel="nofollow">here</a>.</p>',Oe,ee,et,te,Wt="Let’s use our agent to answer a question about Transformers:",tt,le,lt,se,st,ne,kt="Agentic RAG systems can be applied to various use cases:",nt,ae,xt="<li><strong>Technical Documentation Assistance</strong>: Help users navigate complex technical documentation</li> <li><strong>Research Paper Analysis</strong>: Extract and synthesize information from scientific papers</li> <li><strong>Legal Document Review</strong>: Find relevant precedents and clauses in legal documents</li> <li><strong>Customer Support</strong>: Answer questions based on product documentation and knowledge bases</li> <li><strong>Educational Tutoring</strong>: Provide explanations based on textbooks and learning materials</li>",at,ie,it,oe,Vt="Agentic RAG represents a significant advancement over traditional RAG pipelines. By combining the reasoning capabilities of LLM agents with the factual grounding of retrieval systems, we can build more powerful, flexible, and accurate information systems.",ot,re,Xt="The approach we’ve demonstrated:",rt,pe,Qt="<li>Overcomes the limitations of single-step retrieval</li> <li>Enables more natural interactions with knowledge bases</li> <li>Provides a framework for continuous improvement through self-critique and query refinement</li>",pt,Me,Nt="As you build your own Agentic RAG systems, consider experimenting with different retrieval methods, agent architectures, and knowledge sources to find the optimal configuration for your specific use case.",Mt,ce,ct,ye,mt;return T=new Lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new Dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),h=new d({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),f=new d({props:{title:"Introduction to Retrieval-Augmented Generation (RAG)",local:"introduction-to-retrieval-augmented-generation-rag",headingTag:"h2"}}),U=new d({props:{title:"Why Use RAG?",local:"why-use-rag",headingTag:"h3"}}),C=new d({props:{title:"Limitations of Traditional RAG",local:"limitations-of-traditional-rag",headingTag:"h3"}}),A=new d({props:{title:"Agentic RAG: A More Powerful Approach",local:"agentic-rag-a-more-powerful-approach",headingTag:"h2"}}),G=new d({props:{title:"Key Benefits of Agentic RAG",local:"key-benefits-of-agentic-rag",headingTag:"h3"}}),V=new d({props:{title:"Building an Agentic RAG System",local:"building-an-agentic-rag-system",headingTag:"h2"}}),N=new d({props:{title:"Step 1: Install Required Dependencies",local:"step-1-install-required-dependencies",headingTag:"h3"}}),H=new me({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZGF0YXNldHMlMjBweXRob24tZG90ZW52JTIwcmFua19ibTI1JTIwLS11cGdyYWRl",highlighted:"pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade",wrap:!1}}),_=new me({props:{code:"JTIzJTIwTG9hZCUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIwKGluY2x1ZGluZyUyMEhGX1RPS0VOKSUwQWZyb20lMjBkb3RlbnYlMjBpbXBvcnQlMjBsb2FkX2RvdGVudiUwQWxvYWRfZG90ZW52KCk=",highlighted:`<span class="hljs-comment"># Load environment variables (including HF_TOKEN)</span>
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),Y=new d({props:{title:"Step 2: Prepare the Knowledge Base",local:"step-2-prepare-the-knowledge-base",headingTag:"h3"}}),E=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

<span class="hljs-comment"># Load the Hugging Face documentation dataset</span>
knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-comment"># Filter to include only Transformers documentation</span>
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

<span class="hljs-comment"># Convert dataset entries to Document objects with metadata</span>
source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

<span class="hljs-comment"># Split documents into smaller chunks for better retrieval</span>
text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,  <span class="hljs-comment"># Characters per chunk</span>
    chunk_overlap=<span class="hljs-number">50</span>,  <span class="hljs-comment"># Overlap between chunks to maintain context</span>
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],  <span class="hljs-comment"># Priority order for splitting</span>
)
docs_processed = text_splitter.split_documents(source_docs)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Knowledge base prepared with <span class="hljs-subst">{<span class="hljs-built_in">len</span>(docs_processed)}</span> document chunks&quot;</span>)`,wrap:!1}}),F=new d({props:{title:"Step 3: Create a Retriever Tool",local:"step-3-create-a-retriever-tool",headingTag:"h3"}}),P=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        <span class="hljs-comment"># Initialize the retriever with our processed documents</span>
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>  <span class="hljs-comment"># Return top 10 most relevant documents</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Execute the retrieval based on the provided query.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-comment"># Retrieve relevant documents</span>
        docs = self.retriever.invoke(query)

        <span class="hljs-comment"># Format the retrieved documents for readability</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

<span class="hljs-comment"># Initialize our retriever tool with the processed documents</span>
retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),D=new d({props:{title:"Step 4: Create an Advanced Retrieval Agent",local:"step-4-create-an-advanced-retrieval-agent",headingTag:"h3"}}),O=new me({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBvdXIlMjByZXRyaWV2ZXIlMjB0b29sJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMCUyMCUyMyUyMExpc3QlMjBvZiUyMHRvb2xzJTIwYXZhaWxhYmxlJTIwdG8lMjB0aGUlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMCUyMCUyMyUyMERlZmF1bHQlMjBtb2RlbCUyMCUyMlF3ZW4lMkZRd2VuMy1OZXh0LTgwQi1BM0ItVGhpbmtpbmclMjIlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0JTJDJTIwJTIwJTIzJTIwTGltaXQlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHJlYXNvbmluZyUyMHN0ZXBzJTBBJTIwJTIwJTIwJTIwdmVyYm9zaXR5X2xldmVsJTNEMiUyQyUyMCUyMCUyMyUyMFNob3clMjBkZXRhaWxlZCUyMGFnZW50JTIwcmVhc29uaW5nJTBBKSUwQSUwQSUyMyUyMFRvJTIwdXNlJTIwYSUyMHNwZWNpZmljJTIwbW9kZWwlMkMlMjB5b3UlMjBjYW4lMjBzcGVjaWZ5JTIwaXQlMjBsaWtlJTIwdGhpcyUzQSUwQSUyMyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4zLTcwQi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-comment"># Initialize the agent with our retriever tool</span>
agent = CodeAgent(
    tools=[retriever_tool],  <span class="hljs-comment"># List of tools available to the agent</span>
    model=InferenceClientModel(),  <span class="hljs-comment"># Default model &quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>
    max_steps=<span class="hljs-number">4</span>,  <span class="hljs-comment"># Limit the number of reasoning steps</span>
    verbosity_level=<span class="hljs-number">2</span>,  <span class="hljs-comment"># Show detailed agent reasoning</span>
)

<span class="hljs-comment"># To use a specific model, you can specify it like this:</span>
<span class="hljs-comment"># model=InferenceClientModel(model_id=&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</span>`,wrap:!1}}),ee=new d({props:{title:"Step 5: Run the Agent to Answer Questions",local:"step-5-run-the-agent-to-answer-questions",headingTag:"h3"}}),le=new me({props:{code:"JTIzJTIwQXNrJTIwYSUyMHF1ZXN0aW9uJTIwdGhhdCUyMHJlcXVpcmVzJTIwcmV0cmlldmluZyUyMGluZm9ybWF0aW9uJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJGb3IlMjBhJTIwdHJhbnNmb3JtZXJzJTIwbW9kZWwlMjB0cmFpbmluZyUyQyUyMHdoaWNoJTIwaXMlMjBzbG93ZXIlMkMlMjB0aGUlMjBmb3J3YXJkJTIwb3IlMjB0aGUlMjBiYWNrd2FyZCUyMHBhc3MlM0YlMjIlMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHRvJTIwZ2V0JTIwYW4lMjBhbnN3ZXIlMEFhZ2VudF9vdXRwdXQlMjAlM0QlMjBhZ2VudC5ydW4ocXVlc3Rpb24pJTBBJTBBJTIzJTIwRGlzcGxheSUyMHRoZSUyMGZpbmFsJTIwYW5zd2VyJTBBcHJpbnQoJTIyJTVDbkZpbmFsJTIwYW5zd2VyJTNBJTIyKSUwQXByaW50KGFnZW50X291dHB1dCk=",highlighted:`<span class="hljs-comment"># Ask a question that requires retrieving information</span>
question = <span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>

<span class="hljs-comment"># Run the agent to get an answer</span>
agent_output = agent.run(question)

<span class="hljs-comment"># Display the final answer</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nFinal answer:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),se=new d({props:{title:"Practical Applications of Agentic RAG",local:"practical-applications-of-agentic-rag",headingTag:"h2"}}),ie=new d({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),ce=new Pt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){w=i("meta"),de=n(),ue=i("p"),we=n(),p(T.$$.fragment),je=n(),p(g.$$.fragment),Je=n(),p(h.$$.fragment),Te=n(),p(f.$$.fragment),ge=n(),b=i("p"),b.textContent=dt,he=n(),p(U.$$.fragment),fe=n(),I=i("p"),I.textContent=wt,be=n(),v=i("ol"),v.innerHTML=jt,Ue=n(),p(C.$$.fragment),Ie=n(),B=i("p"),B.textContent=Jt,ve=n(),Z=i("ul"),Z.innerHTML=Tt,Ce=n(),p(A.$$.fragment),Be=n(),$=i("p"),$.innerHTML=gt,Ze=n(),p(G.$$.fragment),Ae=n(),R=i("p"),R.textContent=ht,$e=n(),W=i("ol"),W.innerHTML=ft,Ge=n(),k=i("p"),k.textContent=bt,Re=n(),x=i("ul"),x.innerHTML=Ut,We=n(),p(V.$$.fragment),ke=n(),X=i("p"),X.textContent=It,xe=n(),Q=i("p"),Q.innerHTML=vt,Ve=n(),p(N.$$.fragment),Xe=n(),q=i("p"),q.textContent=Ct,Qe=n(),p(H.$$.fragment),Ne=n(),S=i("p"),S.textContent=Bt,qe=n(),p(_.$$.fragment),He=n(),p(Y.$$.fragment),Se=n(),z=i("p"),z.textContent=Zt,_e=n(),p(E.$$.fragment),Ye=n(),p(F.$$.fragment),ze=n(),L=i("p"),L.textContent=At,Ee=n(),p(P.$$.fragment),Fe=n(),j=i("blockquote"),j.innerHTML=$t,Le=n(),p(D.$$.fragment),Pe=n(),K=i("p"),K.textContent=Gt,De=n(),p(O.$$.fragment),Ke=n(),J=i("blockquote"),J.innerHTML=Rt,Oe=n(),p(ee.$$.fragment),et=n(),te=i("p"),te.textContent=Wt,tt=n(),p(le.$$.fragment),lt=n(),p(se.$$.fragment),st=n(),ne=i("p"),ne.textContent=kt,nt=n(),ae=i("ol"),ae.innerHTML=xt,at=n(),p(ie.$$.fragment),it=n(),oe=i("p"),oe.textContent=Vt,ot=n(),re=i("p"),re.textContent=Xt,rt=n(),pe=i("ul"),pe.innerHTML=Qt,pt=n(),Me=i("p"),Me.textContent=Nt,Mt=n(),p(ce.$$.fragment),ct=n(),ye=i("p"),this.h()},l(e){const t=Et("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),de=a(e),ue=o(e,"P",{}),qt(ue).forEach(l),we=a(e),M(T.$$.fragment,e),je=a(e),M(g.$$.fragment,e),Je=a(e),M(h.$$.fragment,e),Te=a(e),M(f.$$.fragment,e),ge=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-ahsalp"&&(b.textContent=dt),he=a(e),M(U.$$.fragment,e),fe=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3b2p9t"&&(I.textContent=wt),be=a(e),v=o(e,"OL",{"data-svelte-h":!0}),r(v)!=="svelte-s9vwtj"&&(v.innerHTML=jt),Ue=a(e),M(C.$$.fragment,e),Ie=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-5ohm8g"&&(B.textContent=Jt),ve=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-1b6u5vg"&&(Z.innerHTML=Tt),Ce=a(e),M(A.$$.fragment,e),Be=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-nkypap"&&($.innerHTML=gt),Ze=a(e),M(G.$$.fragment,e),Ae=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-106qzhl"&&(R.textContent=ht),$e=a(e),W=o(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-17ov5nb"&&(W.innerHTML=ft),Ge=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1vth8dz"&&(k.textContent=bt),Re=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1kmp0ag"&&(x.innerHTML=Ut),We=a(e),M(V.$$.fragment,e),ke=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ebtqsa"&&(X.textContent=It),xe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-a2onz5"&&(Q.innerHTML=vt),Ve=a(e),M(N.$$.fragment,e),Xe=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1yz8wyl"&&(q.textContent=Ct),Qe=a(e),M(H.$$.fragment,e),Ne=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-io6cbu"&&(S.textContent=Bt),qe=a(e),M(_.$$.fragment,e),He=a(e),M(Y.$$.fragment,e),Se=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1r0dacz"&&(z.textContent=Zt),_e=a(e),M(E.$$.fragment,e),Ye=a(e),M(F.$$.fragment,e),ze=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16ovxir"&&(L.textContent=At),Ee=a(e),M(P.$$.fragment,e),Fe=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1j7z97m"&&(j.innerHTML=$t),Le=a(e),M(D.$$.fragment,e),Pe=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-uyg5h9"&&(K.textContent=Gt),De=a(e),M(O.$$.fragment,e),Ke=a(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1lti5bi"&&(J.innerHTML=Rt),Oe=a(e),M(ee.$$.fragment,e),et=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1cnhgyu"&&(te.textContent=Wt),tt=a(e),M(le.$$.fragment,e),lt=a(e),M(se.$$.fragment,e),st=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1vnmlwn"&&(ne.textContent=kt),nt=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),r(ae)!=="svelte-u8fd9x"&&(ae.innerHTML=xt),at=a(e),M(ie.$$.fragment,e),it=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1nscnr8"&&(oe.textContent=Vt),ot=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-18cofwx"&&(re.textContent=Xt),rt=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-12ngelm"&&(pe.innerHTML=Qt),pt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-izrxrg"&&(Me.textContent=Nt),Mt=a(e),M(ce.$$.fragment,e),ct=a(e),ye=o(e,"P",{}),qt(ye).forEach(l),this.h()},h(){ut(w,"name","hf:doc:metadata"),ut(w,"content",Ot),ut(j,"class","tip"),ut(J,"class","tip")},m(e,t){Ft(document.head,w),s(e,de,t),s(e,ue,t),s(e,we,t),c(T,e,t),s(e,je,t),c(g,e,t),s(e,Je,t),c(h,e,t),s(e,Te,t),c(f,e,t),s(e,ge,t),s(e,b,t),s(e,he,t),c(U,e,t),s(e,fe,t),s(e,I,t),s(e,be,t),s(e,v,t),s(e,Ue,t),c(C,e,t),s(e,Ie,t),s(e,B,t),s(e,ve,t),s(e,Z,t),s(e,Ce,t),c(A,e,t),s(e,Be,t),s(e,$,t),s(e,Ze,t),c(G,e,t),s(e,Ae,t),s(e,R,t),s(e,$e,t),s(e,W,t),s(e,Ge,t),s(e,k,t),s(e,Re,t),s(e,x,t),s(e,We,t),c(V,e,t),s(e,ke,t),s(e,X,t),s(e,xe,t),s(e,Q,t),s(e,Ve,t),c(N,e,t),s(e,Xe,t),s(e,q,t),s(e,Qe,t),c(H,e,t),s(e,Ne,t),s(e,S,t),s(e,qe,t),c(_,e,t),s(e,He,t),c(Y,e,t),s(e,Se,t),s(e,z,t),s(e,_e,t),c(E,e,t),s(e,Ye,t),c(F,e,t),s(e,ze,t),s(e,L,t),s(e,Ee,t),c(P,e,t),s(e,Fe,t),s(e,j,t),s(e,Le,t),c(D,e,t),s(e,Pe,t),s(e,K,t),s(e,De,t),c(O,e,t),s(e,Ke,t),s(e,J,t),s(e,Oe,t),c(ee,e,t),s(e,et,t),s(e,te,t),s(e,tt,t),c(le,e,t),s(e,lt,t),c(se,e,t),s(e,st,t),s(e,ne,t),s(e,nt,t),s(e,ae,t),s(e,at,t),c(ie,e,t),s(e,it,t),s(e,oe,t),s(e,ot,t),s(e,re,t),s(e,rt,t),s(e,pe,t),s(e,pt,t),s(e,Me,t),s(e,Mt,t),c(ce,e,t),s(e,ct,t),s(e,ye,t),mt=!0},p:St,i(e){mt||(m(T.$$.fragment,e),m(g.$$.fragment,e),m(h.$$.fragment,e),m(f.$$.fragment,e),m(U.$$.fragment,e),m(C.$$.fragment,e),m(A.$$.fragment,e),m(G.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(H.$$.fragment,e),m(_.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),mt=!0)},o(e){u(T.$$.fragment,e),u(g.$$.fragment,e),u(h.$$.fragment,e),u(f.$$.fragment,e),u(U.$$.fragment,e),u(C.$$.fragment,e),u(A.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(H.$$.fragment,e),u(_.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),mt=!1},d(e){e&&(l(de),l(ue),l(we),l(je),l(Je),l(Te),l(ge),l(b),l(he),l(fe),l(I),l(be),l(v),l(Ue),l(Ie),l(B),l(ve),l(Z),l(Ce),l(Be),l($),l(Ze),l(Ae),l(R),l($e),l(W),l(Ge),l(k),l(Re),l(x),l(We),l(ke),l(X),l(xe),l(Q),l(Ve),l(Xe),l(q),l(Qe),l(Ne),l(S),l(qe),l(He),l(Se),l(z),l(_e),l(Ye),l(ze),l(L),l(Ee),l(Fe),l(j),l(Le),l(Pe),l(K),l(De),l(Ke),l(J),l(Oe),l(et),l(te),l(tt),l(lt),l(st),l(ne),l(nt),l(ae),l(at),l(it),l(oe),l(ot),l(re),l(rt),l(pe),l(pt),l(Me),l(Mt),l(ct),l(ye)),l(w),y(T,e),y(g,e),y(h,e),y(f,e),y(U,e),y(C,e),y(A,e),y(G,e),y(V,e),y(N,e),y(H,e),y(_,e),y(Y,e),y(E,e),y(F,e),y(P,e),y(D,e),y(O,e),y(ee,e),y(le,e),y(se,e),y(ie,e),y(ce,e)}}}const Ot='{"title":"Agentic RAG","local":"agentic-rag","sections":[{"title":"Introduction to Retrieval-Augmented Generation (RAG)","local":"introduction-to-retrieval-augmented-generation-rag","sections":[{"title":"Why Use RAG?","local":"why-use-rag","sections":[],"depth":3},{"title":"Limitations of Traditional RAG","local":"limitations-of-traditional-rag","sections":[],"depth":3}],"depth":2},{"title":"Agentic RAG: A More Powerful Approach","local":"agentic-rag-a-more-powerful-approach","sections":[{"title":"Key Benefits of Agentic RAG","local":"key-benefits-of-agentic-rag","sections":[],"depth":3}],"depth":2},{"title":"Building an Agentic RAG System","local":"building-an-agentic-rag-system","sections":[{"title":"Step 1: Install Required Dependencies","local":"step-1-install-required-dependencies","sections":[],"depth":3},{"title":"Step 2: Prepare the Knowledge Base","local":"step-2-prepare-the-knowledge-base","sections":[],"depth":3},{"title":"Step 3: Create a Retriever Tool","local":"step-3-create-a-retriever-tool","sections":[],"depth":3},{"title":"Step 4: Create an Advanced Retrieval Agent","local":"step-4-create-an-advanced-retrieval-agent","sections":[],"depth":3},{"title":"Step 5: Run the Agent to Answer Questions","local":"step-5-run-the-agent-to-answer-questions","sections":[],"depth":3}],"depth":2},{"title":"Practical Applications of Agentic RAG","local":"practical-applications-of-agentic-rag","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function el(yt){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Yt{constructor(w){super(),zt(this,w,el,Kt,Ht,{})}}export{il as component};
