# Agents

Smolagents एक experimental API है जो किसी भी समय बदल सकता है। एजेंट्स द्वारा लौटाए गए परिणाम भिन्न हो सकते हैं क्योंकि APIs या underlying मॉडल बदलने की संभावना रखते हैं।

Agents और tools के बारे में अधिक जानने के लिए [introductory guide](../index) पढ़ना सुनिश्चित करें। 
यह पेज underlying क्लासेज के लिए API docs को शामिल करता है।

## Agents

हमारे एजेंट्स [MultiStepAgent](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.MultiStepAgent) से इनहेरिट करते हैं, जिसका अर्थ है कि वे कई चरणों में कार्य कर सकते हैं, प्रत्येक चरण में एक विचार, फिर एक टूल कॉल और एक्जीक्यूशन शामिल होता है। [इस कॉन्सेप्चुअल गाइड](../conceptual_guides/react) में अधिक पढ़ें।

हम मुख्य `Agent` क्लास पर आधारित दो प्रकार के एजेंट्स प्रदान करते हैं।
  - [CodeAgent](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.CodeAgent) डिफ़ॉल्ट एजेंट है, यह अपने टूल कॉल्स को Python कोड में लिखता है।
  - [ToolCallingAgent](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.ToolCallingAgent) अपने टूल कॉल्स को JSON में लिखता है।

दोनों को इनिशियलाइजेशन पर `model` और टूल्स की सूची `tools` आर्गुमेंट्स की आवश्यकता होती है।

### Agents की क्लासेज[[smolagents.MultiStepAgent]]

#### smolagents.MultiStepAgent[[smolagents.MultiStepAgent]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L267)

Agent class that solves the given task step by step, using the ReAct framework:
While the objective is not reached, the agent will perform a cycle of action (given by the LLM) and observation (obtained from the environment).

extract_actionsmolagents.MultiStepAgent.extract_actionhttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L785[{"name": "model_output", "val": ": str"}, {"name": "split_token", "val": ": str"}]- **model_output** (`str`) -- Output of the LLM
- **split_token** (`str`) -- Separator for the action. Should match the example in the system prompt.0

Parse action from the LLM output

**Parameters:**

tools (`list[Tool]`) : [Tool](/docs/smolagents/v1.23.0/hi/reference/tools#smolagents.Tool)s that the agent can use.

model (`Callable[[list[dict[str, str]]], ChatMessage]`) : Model that will generate the agent's actions.

prompt_templates ([PromptTemplates](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.PromptTemplates), *optional*) : Prompt templates.

instructions (`str`, *optional*) : Custom instructions for the agent, will be inserted in the system prompt.

max_steps (`int`, default `20`) : Maximum number of steps the agent can take to solve the task.

add_base_tools (`bool`, default `False`) : Whether to add the base tools to the agent's tools.

verbosity_level (`LogLevel`, default `LogLevel.INFO`) : Level of verbosity of the agent's logs.

managed_agents (`list`, *optional*) : Managed agents that the agent can call.

step_callbacks (`list[Callable]` | `dict[Type[MemoryStep], Callable | list[Callable]]`, *optional*) : Callbacks that will be called at each step.

planning_interval (`int`, *optional*) : Interval at which the agent will run a planning step.

name (`str`, *optional*) : Necessary for a managed agent only - the name by which this agent can be called.

description (`str`, *optional*) : Necessary for a managed agent only - the description of this agent.

provide_run_summary (`bool`, *optional*) : Whether to provide a run summary when called as a managed agent.

final_answer_checks (`list[Callable]`, *optional*) : List of validation functions to run before accepting a final answer. Each function should: - Take the final answer, the agent's memory, and the agent itself as arguments. - Return a boolean indicating whether the final answer is valid.

return_full_result (`bool`, default `False`) : Whether to return the full `RunResult` object or just the final answer output from the agent run.
#### from_dict[[smolagents.MultiStepAgent.from_dict]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1006)

Create agent from a dictionary representation.

**Parameters:**

agent_dict (`dict[str, Any]`) : Dictionary representation of the agent.

- ****kwargs** : Additional keyword arguments that will override agent_dict values.

**Returns:**

``MultiStepAgent``

Instance of the agent class.
#### from_folder[[smolagents.MultiStepAgent.from_folder]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1104)

Loads an agent from a local folder.

**Parameters:**

folder (`str` or `Path`) : The folder where the agent is saved.

- ****kwargs** : Additional keyword arguments that will be passed to the agent's init.
#### from_hub[[smolagents.MultiStepAgent.from_hub]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1050)

Loads an agent defined on the Hub.

Loading a tool from the Hub means that you'll download the tool and execute it locally.
ALWAYS inspect the tool you're downloading before loading it within your runtime, as you would do when
installing a package using pip/npm/apt.

**Parameters:**

repo_id (`str`) : The name of the repo on the Hub where your tool is defined.

token (`str`, *optional*) : The token to identify you on hf.co. If unset, will use the token generated when running `huggingface-cli login` (stored in `~/.huggingface`).

trust_remote_code(`bool`, *optional*, defaults to False) : This flags marks that you understand the risk of running remote code and that you trust this tool. If not setting this to True, loading the tool from Hub will fail.

kwargs (additional keyword arguments, *optional*) : Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as `cache_dir`, `revision`, `subfolder`) will be used when downloading the files for your agent, and the others will be passed along to its init.
#### initialize_system_prompt[[smolagents.MultiStepAgent.initialize_system_prompt]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L745)

To be implemented in child classes
#### interrupt[[smolagents.MultiStepAgent.interrupt]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L750)

Interrupts the agent execution.
#### provide_final_answer[[smolagents.MultiStepAgent.provide_final_answer]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L806)

Provide the final answer to the task, based on the logs of the agent's interactions.

**Parameters:**

task (`str`) : Task to perform.

images (`list[PIL.Image.Image]`, *optional*) : Image(s) objects.

**Returns:**

``str``

Final answer to the task.
#### push_to_hub[[smolagents.MultiStepAgent.push_to_hub]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1136)

Upload the agent to the Hub.

**Parameters:**

repo_id (`str`) : The name of the repository you want to push to. It should contain your organization name when pushing to a given organization.

commit_message (`str`, *optional*, defaults to `"Upload agent"`) : Message to commit while pushing.

private (`bool`, *optional*, defaults to `None`) : Whether to make the repo private. If `None`, the repo will be public unless the organization's default is private. This value is ignored if the repo already exists.

token (`bool` or `str`, *optional*) : The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when running `huggingface-cli login` (stored in `~/.huggingface`).

create_pr (`bool`, *optional*, defaults to `False`) : Whether to create a PR with the uploaded files or directly commit.
#### replay[[smolagents.MultiStepAgent.replay]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L855)

Prints a pretty replay of the agent's steps.

**Parameters:**

detailed (bool, optional) : If True, also displays the memory at each step. Defaults to False. Careful: will increase log length exponentially. Use only for debugging.
#### run[[smolagents.MultiStepAgent.run]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L435)

Run the agent for the given task.

Example:
```py
from smolagents import CodeAgent
agent = CodeAgent(tools=[])
agent.run("What is the result of 2 power 3.7384?")
```

**Parameters:**

task (`str`) : Task to perform.

stream (`bool`) : Whether to run in streaming mode. If `True`, returns a generator that yields each step as it is executed. You must iterate over this generator to process the individual steps (e.g., using a for loop or `next()`). If `False`, executes all steps internally and returns only the final answer after completion.

reset (`bool`) : Whether to reset the conversation or keep it going from previous run.

images (`list[PIL.Image.Image]`, *optional*) : Image(s) objects.

additional_args (`dict`, *optional*) : Any other variables that you want to pass to the agent run, for instance images or dataframes. Give them clear names!

max_steps (`int`, *optional*) : Maximum number of steps the agent can take to solve the task. if not provided, will use the agent's default value.

return_full_result (`bool`, *optional*) : Whether to return the full `RunResult` object or just the final answer output. If `None` (default), the agent's `self.return_full_result` setting is used.
#### save[[smolagents.MultiStepAgent.save]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L888)

Saves the relevant code files for your agent. This will copy the code of your agent in `output_dir` as well as autogenerate:

- a `tools` folder containing the logic for each of the tools under `tools/{tool_name}.py`.
- a `managed_agents` folder containing the logic for each of the managed agents.
- an `agent.json` file containing a dictionary representing your agent.
- a `prompt.yaml` file containing the prompt templates used by your agent.
- an `app.py` file providing a UI for your agent when it is exported to a Space with `agent.push_to_hub()`
- a `requirements.txt` containing the names of the modules used by your tool (as detected when inspecting its
  code)

**Parameters:**

output_dir (`str` or `Path`) : The folder in which you want to save your agent.
#### step[[smolagents.MultiStepAgent.step]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L778)

Perform one step in the ReAct framework: the agent thinks, acts, and observes the result.
Returns either None if the step is not final, or the final answer.
#### to_dict[[smolagents.MultiStepAgent.to_dict]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L966)

Convert the agent to a dictionary representation.

**Returns:**

``dict``

Dictionary representation of the agent.
#### visualize[[smolagents.MultiStepAgent.visualize]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L851)

Creates a rich tree visualization of the agent's structure.
#### write_memory_to_messages[[smolagents.MultiStepAgent.write_memory_to_messages]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L754)

Reads past llm_outputs, actions, and observations or errors from the memory into a series of messages
that can be used as input to the LLM. Adds a number of keywords (such as PLAN, error, etc) to help
the LLM.

#### smolagents.CodeAgent[[smolagents.CodeAgent]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1481)

In this agent, the tool calls will be formulated by the LLM in code format, then parsed and executed.

cleanupsmolagents.CodeAgent.cleanuphttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1569[]
Clean up resources used by the agent, such as the remote Python executor.

**Parameters:**

tools (`list[Tool]`) : [Tool](/docs/smolagents/v1.23.0/hi/reference/tools#smolagents.Tool)s that the agent can use.

model (`Model`) : Model that will generate the agent's actions.

prompt_templates ([PromptTemplates](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.PromptTemplates), *optional*) : Prompt templates.

additional_authorized_imports (`list[str]`, *optional*) : Additional authorized imports for the agent.

planning_interval (`int`, *optional*) : Interval at which the agent will run a planning step.

executor (`PythonExecutor`, *optional*) : Custom Python code executor. If not provided, a default executor will be created based on `executor_type`.

executor_type (`Literal["local", "blaxel", "e2b", "modal", "docker", "wasm"]`, default `"local"`) : Type of code executor.

executor_kwargs (`dict`, *optional*) : Additional arguments to pass to initialize the executor.

max_print_outputs_length (`int`, *optional*) : Maximum length of the print outputs.

stream_outputs (`bool`, *optional*, default `False`) : Whether to stream outputs during execution.

use_structured_outputs_internally (`bool`, default `False`) : Whether to use structured generation at each action step: improves performance for many models.  

code_block_tags (`tuple[str, str]` | `Literal["markdown"]`, *optional*) : Opening and closing tags for code blocks (regex strings). Pass a custom tuple, or pass 'markdown' to use ("```(?:python|py)", "\n```"), leave empty to use ("", "").

- ****kwargs** : Additional keyword arguments.
#### from_dict[[smolagents.CodeAgent.from_dict]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1756)

Create CodeAgent from a dictionary representation.

**Parameters:**

agent_dict (`dict[str, Any]`) : Dictionary representation of the agent.

- ****kwargs** : Additional keyword arguments that will override agent_dict values.

**Returns:**

``CodeAgent``

Instance of the CodeAgent class.

#### smolagents.ToolCallingAgent[[smolagents.ToolCallingAgent]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1191)

This agent uses JSON-like tool calls, using method `model.get_tool_call` to leverage the LLM engine's tool calling capabilities.

execute_tool_callsmolagents.ToolCallingAgent.execute_tool_callhttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1429[{"name": "tool_name", "val": ": str"}, {"name": "arguments", "val": ": dict[str, str] | str"}]- **tool_name** (`str`) -- Name of the tool or managed agent to execute.
- **arguments** (dict[str, str] | str) -- Arguments passed to the tool call.0

Execute a tool or managed agent with the provided arguments.

The arguments are replaced with the actual values from the state if they refer to state variables.

**Parameters:**

tools (`list[Tool]`) : [Tool](/docs/smolagents/v1.23.0/hi/reference/tools#smolagents.Tool)s that the agent can use.

model (`Model`) : Model that will generate the agent's actions.

prompt_templates ([PromptTemplates](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.PromptTemplates), *optional*) : Prompt templates.

planning_interval (`int`, *optional*) : Interval at which the agent will run a planning step.

stream_outputs (`bool`, *optional*, default `False`) : Whether to stream outputs during execution.

max_tool_threads (`int`, *optional*) : Maximum number of threads for parallel tool calls. Higher values increase concurrency but resource usage as well. Defaults to `ThreadPoolExecutor`'s default.

- ****kwargs** : Additional keyword arguments.
#### process_tool_calls[[smolagents.ToolCallingAgent.process_tool_calls]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L1337)

Process tool calls from the model output and update agent memory.

**Parameters:**

chat_message (`ChatMessage`) : Chat message containing tool calls from the model.

memory_step (`ActionStep)` : Memory ActionStep to update with results.

### stream_to_gradio[[smolagents.stream_to_gradio]]

#### smolagents.stream_to_gradio[[smolagents.stream_to_gradio]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/gradio_ui.py#L248)

Runs an agent with the given task and streams the messages from the agent as gradio ChatMessages.

### GradioUI[[smolagents.GradioUI]]

#### smolagents.GradioUI[[smolagents.GradioUI]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/gradio_ui.py#L279)

Gradio interface for interacting with a [MultiStepAgent](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.MultiStepAgent).

This class provides a web interface to interact with the agent in real-time, allowing users to submit prompts, upload files, and receive responses in a chat-like format.
It  can reset the agent's memory at the start of each interaction if desired.
It supports file uploads, which are saved to a specified folder.
It uses the `gradio.Chatbot` component to display the conversation history.
This class requires the `gradio` extra to be installed: `pip install 'smolagents[gradio]'`.

Example:
```python
from smolagents import CodeAgent, GradioUI, InferenceClientModel

model = InferenceClientModel(model_id="meta-llama/Meta-Llama-3.1-8B-Instruct")
agent = CodeAgent(tools=[], model=model)
gradio_ui = GradioUI(agent, file_upload_folder="uploads", reset_agent_memory=True)
gradio_ui.launch()
```

launchsmolagents.GradioUI.launchhttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/gradio_ui.py#L406[{"name": "share", "val": ": bool = True"}, {"name": "**kwargs", "val": ""}]- **share** (`bool`, defaults to `True`) -- Whether to share the app publicly.
- ****kwargs** -- Additional keyword arguments to pass to the Gradio launch method.0

Launch the Gradio app with the agent interface.

**Parameters:**

agent ([MultiStepAgent](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.MultiStepAgent)) : The agent to interact with.

file_upload_folder (`str`, *optional*) : The folder where uploaded files will be saved. If not provided, file uploads are disabled.

reset_agent_memory (`bool`, *optional*, defaults to `False`) : Whether to reset the agent's memory at the start of each interaction. If `True`, the agent will not remember previous interactions.
#### upload_file[[smolagents.GradioUI.upload_file]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/gradio_ui.py#L356)

Upload a file and add it to the list of uploaded files in the session state.

The file is saved to the `self.file_upload_folder` folder.
If the file type is not allowed, it returns a message indicating the disallowed file type.

**Parameters:**

file (`gradio.File`) : The uploaded file.

file_uploads_log (`list`) : A list to log uploaded files.

allowed_file_types (`list`, *optional*) : List of allowed file extensions. Defaults to [".pdf", ".docx", ".txt"].

## मॉडल्स

आप स्वतंत्र रूप से अपने स्वयं के मॉडल बना सकते हैं और उनका उपयोग कर सकते हैं।

आप अपने एजेंट के लिए कोई भी `model` कॉल करने योग्य उपयोग कर सकते हैं, जब तक कि:
1. यह अपने इनपुट `messages` के लिए [messages format](./chat_templating) (`List[Dict[str, str]]`) का पालन करता है, और यह एक `str` लौटाता है।
2. यह आर्गुमेंट `stop_sequences` में पास किए गए सीक्वेंस से *पहले* आउटपुट जनरेट करना बंद कर देता है।

अपने LLM को परिभाषित करने के लिए, आप एक `custom_model` मेथड बना सकते हैं जो [messages](./chat_templating) की एक सूची स्वीकार करता है और टेक्स्ट युक्त .content विशेषता वाला एक ऑब्जेक्ट लौटाता है। इस कॉलेबल को एक `stop_sequences` आर्गुमेंट भी स्वीकार करने की आवश्यकता होती है जो बताता है कि कब जनरेट करना और बंद करना है।

```python
from huggingface_hub import login, InferenceClient

login("")

model_id = "meta-llama/Llama-3.3-70B-Instruct"

client = InferenceClient(model=model_id)

def custom_model(messages, stop_sequences=["Task"]):
    response = client.chat_completion(messages, stop=stop_sequences, max_tokens=1000)
    answer = response.choices[0].message
    return answer
```

इसके अतिरिक्त, `custom_model` एक `grammar` आर्गुमेंट भी ले सकता है। जिस स्थिति में आप एजेंट इनिशियलाइजेशन पर एक `grammar` निर्दिष्ट करते हैं, यह आर्गुमेंट मॉडल के कॉल्स को आपके द्वारा इनिशियलाइजेशन पर परिभाषित `grammar` के साथ पास किया जाएगा, ताकि [constrained generation](https://huggingface.co/docs/text-generation-inference/conceptual/guidance) की अनुमति मिल सके जिससे उचित-फॉर्मेटेड एजेंट आउटपुट को फोर्स किया जा सके।

### TransformersModel[[smolagents.TransformersModel]]

सुविधा के लिए, हमने एक `TransformersModel` जोड़ा है जो इनिशियलाइजेशन पर दिए गए model_id के लिए एक लोकल `transformers` पाइपलाइन बनाकर ऊपर के बिंदुओं को लागू करता है।

```python
from smolagents import TransformersModel

model = TransformersModel(model_id="HuggingFaceTB/SmolLM-135M-Instruct")

print(model([{"role": "user", "content": "Ok!"}], stop_sequences=["great"]))
```
```text
>>> What a
```

#### smolagents.TransformersModel[[smolagents.TransformersModel]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/models.py#L827)

A class that uses Hugging Face's Transformers library for language model interaction.

This model allows you to load and use Hugging Face's models locally using the Transformers library. It supports features like stop sequences and grammar customization.

> [!TIP]
> You must have `transformers` and `torch` installed on your machine. Please run `pip install 'smolagents[transformers]'` if it's not the case.

Example:
```python
>>> engine = TransformersModel(
...     model_id="Qwen/Qwen3-Next-80B-A3B-Thinking",
...     device="cuda",
...     max_new_tokens=5000,
... )
>>> messages = [{"role": "user", "content": "Explain quantum mechanics in simple terms."}]
>>> response = engine(messages, stop_sequences=["END"])
>>> print(response)
"Quantum mechanics is the branch of physics that studies..."
```

**Parameters:**

model_id (`str`) : The Hugging Face model ID to be used for inference. This can be a path or model identifier from the Hugging Face model hub. For example, `"Qwen/Qwen3-Next-80B-A3B-Thinking"`.

device_map (`str`, *optional*) : The device_map to initialize your model with.

torch_dtype (`str`, *optional*) : The torch_dtype to initialize your model with.

trust_remote_code (bool, default `False`) : Some models on the Hub require running remote code: for this model, you would have to set this flag to True.

model_kwargs (`dict[str, Any]`, *optional*) : Additional keyword arguments to pass to `AutoModel.from_pretrained` (like revision, model_args, config, etc.).

max_new_tokens (`int`, default `4096`) : Maximum number of new tokens to generate, ignoring the number of tokens in the prompt.

max_tokens (`int`, *optional*) : Alias for `max_new_tokens`. If provided, this value takes precedence.

- ****kwargs** : Additional keyword arguments to forward to the underlying Transformers model generate call, such as `device`.

### InferenceClientModel[[smolagents.InferenceClientModel]]

`InferenceClientModel` LLM के एक्जीक्यूशन के लिए [HF Inference API](https://huggingface.co/docs/api-inference/index) क्लाइंट को रैप करता है।

```python
from smolagents import InferenceClientModel

messages = [
  {"role": "user", "content": "Hello, how are you?"},
  {"role": "assistant", "content": "I'm doing great. How can I help you today?"},
  {"role": "user", "content": "No need to help, take it easy."},
]

model = InferenceClientModel()
print(model(messages))
```
```text
>>> Of course! If you change your mind, feel free to reach out. Take care!
```
#### smolagents.InferenceClientModel[[smolagents.InferenceClientModel]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/models.py#L1418)

A class to interact with Hugging Face's Inference Providers for language model interaction.

This model allows you to communicate with Hugging Face's models using Inference Providers. It can be used in both serverless mode, with a dedicated endpoint, or even with a local URL, supporting features like stop sequences and grammar customization.

Providers include Cerebras, Cohere, Fal, Fireworks, HF-Inference, Hyperbolic, Nebius, Novita, Replicate, SambaNova, Together, and more.

Example:
```python
>>> engine = InferenceClientModel(
...     model_id="Qwen/Qwen3-Next-80B-A3B-Thinking",
...     provider="hyperbolic",
...     token="your_hf_token_here",
...     max_tokens=5000,
... )
>>> messages = [{"role": "user", "content": "Explain quantum mechanics in simple terms."}]
>>> response = engine(messages, stop_sequences=["END"])
>>> print(response)
"Quantum mechanics is the branch of physics that studies..."
```

create_clientsmolagents.InferenceClientModel.create_clienthttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/models.py#L1509[]
Create the Hugging Face client.

**Parameters:**

model_id (`str`, *optional*, default `"Qwen/Qwen3-Next-80B-A3B-Thinking"`) : The Hugging Face model ID to be used for inference. This can be a model identifier from the Hugging Face model hub or a URL to a deployed Inference Endpoint. Currently, it defaults to `"Qwen/Qwen3-Next-80B-A3B-Thinking"`, but this may change in the future.

provider (`str`, *optional*) : Name of the provider to use for inference. A list of supported providers can be found in the [Inference Providers documentation](https://huggingface.co/docs/inference-providers/index#partners). Defaults to "auto" i.e. the first of the providers available for the model, sorted by the user's order [here](https://hf.co/settings/inference-providers). If `base_url` is passed, then `provider` is not used.

token (`str`, *optional*) : Token used by the Hugging Face API for authentication. This token need to be authorized 'Make calls to the serverless Inference Providers'. If the model is gated (like Llama-3 models), the token also needs 'Read access to contents of all public gated repos you can access'. If not provided, the class will try to use environment variable 'HF_TOKEN', else use the token stored in the Hugging Face CLI configuration.

timeout (`int`, *optional*, defaults to 120) : Timeout for the API request, in seconds.

client_kwargs (`dict[str, Any]`, *optional*) : Additional keyword arguments to pass to the Hugging Face InferenceClient.

custom_role_conversions (`dict[str, str]`, *optional*) : Custom role conversion mapping to convert message roles in others. Useful for specific models that do not support specific message roles like "system".

api_key (`str`, *optional*) : Token to use for authentication. This is a duplicated argument from `token` to make [InferenceClientModel](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.InferenceClientModel) follow the same pattern as `openai.OpenAI` client. Cannot be used if `token` is set. Defaults to None.

bill_to (`str`, *optional*) : The billing account to use for the requests. By default the requests are billed on the user's account. Requests can only be billed to an organization the user is a member of, and which has subscribed to Enterprise Hub.

base_url (`str`, `optional`) : Base URL to run inference. This is a duplicated argument from `model` to make [InferenceClientModel](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.InferenceClientModel) follow the same pattern as `openai.OpenAI` client. Cannot be used if `model` is set. Defaults to None.

- ****kwargs** : Additional keyword arguments to forward to the underlying Hugging Face InferenceClient completion call.

### LiteLLMModel[[smolagents.LiteLLMModel]]

`LiteLLMModel` विभिन्न प्रदाताओं से 100+ LLMs को सपोर्ट करने के लिए [LiteLLM](https://www.litellm.ai/) का लाभ उठाता है।
आप मॉडल इनिशियलाइजेशन पर kwargs पास कर सकते हैं जो तब मॉडल का उपयोग करते समय प्रयोग किए जाएंगे, उदाहरण के लिए नीचे हम `temperature` पास करते हैं।

```python
from smolagents import LiteLLMModel

messages = [
  {"role": "user", "content": "Hello, how are you?"},
  {"role": "assistant", "content": "I'm doing great. How can I help you today?"},
  {"role": "user", "content": "No need to help, take it easy."},
]

model = LiteLLMModel(model_id="anthropic/claude-3-5-sonnet-latest", temperature=0.2, max_tokens=10)
print(model(messages))
```

#### smolagents.LiteLLMModel[[smolagents.LiteLLMModel]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/models.py#L1167)

Model to use [LiteLLM Python SDK](https://docs.litellm.ai/docs/#litellm-python-sdk) to access hundreds of LLMs.

create_clientsmolagents.LiteLLMModel.create_clienthttps://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/models.py#L1217[]
Create the LiteLLM client.

**Parameters:**

model_id (`str`) : The model identifier to use on the server (e.g. "gpt-3.5-turbo").

api_base (`str`, *optional*) : The base URL of the provider API to call the model.

api_key (`str`, *optional*) : The API key to use for authentication.

custom_role_conversions (`dict[str, str]`, *optional*) : Custom role conversion mapping to convert message roles in others. Useful for specific models that do not support specific message roles like "system".

flatten_messages_as_text (`bool`, *optional*) : Whether to flatten messages as text. Defaults to `True` for models that start with "ollama", "groq", "cerebras".

- ****kwargs** : Additional keyword arguments to forward to the underlying LiteLLM completion call.

### OpenAiModel

यह क्लास आपको किसी भी OpenAIServer कम्पैटिबल मॉडल को कॉल करने देती है।
यहाँ बताया गया है कि आप इसे कैसे सेट कर सकते हैं (आप दूसरे सर्वर को पॉइंट करने के लिए `api_base` url को कस्टमाइज़ कर सकते हैं):
```py
import os
from smolagents import OpenAIModel

model = OpenAIModel(
    model_id="gpt-4o",
    api_base="https://api.openai.com/v1",
    api_key=os.environ["OPENAI_API_KEY"],
)
```

## Prompts[[smolagents.PromptTemplates]]

#### smolagents.PromptTemplates[[smolagents.PromptTemplates]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L165)

Prompt templates for the agent.

**Parameters:**

system_prompt (`str`) : System prompt.

planning ([PlanningPromptTemplate](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.PlanningPromptTemplate)) : Planning prompt templates.

managed_agent ([ManagedAgentPromptTemplate](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.ManagedAgentPromptTemplate)) : Managed agent prompt templates.

final_answer ([FinalAnswerPromptTemplate](/docs/smolagents/v1.23.0/hi/reference/agents#smolagents.FinalAnswerPromptTemplate)) : Final answer prompt templates.

#### smolagents.PlanningPromptTemplate[[smolagents.PlanningPromptTemplate]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L124)

Prompt templates for the planning step.

**Parameters:**

plan (`str`) : Initial plan prompt.

update_plan_pre_messages (`str`) : Update plan pre-messages prompt.

update_plan_post_messages (`str`) : Update plan post-messages prompt.

#### smolagents.ManagedAgentPromptTemplate[[smolagents.ManagedAgentPromptTemplate]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L139)

Prompt templates for the managed agent.

**Parameters:**

task (`str`) : Task prompt.

report (`str`) : Report prompt.

#### smolagents.FinalAnswerPromptTemplate[[smolagents.FinalAnswerPromptTemplate]]

[Source](https://github.com/huggingface/smolagents/blob/v1.23.0/src/smolagents/agents.py#L152)

Prompt templates for the final answer.

**Parameters:**

pre_messages (`str`) : Pre-messages prompt.

post_messages (`str`) : Post-messages prompt.

