import{s as Jt,o as Tt,n as Ae}from"../chunks/scheduler.a2b4ca8e.js";import{S as wt,i as jt,g as i,s as o,r as u,A as gt,h as r,f as l,c as s,j as Ut,u as M,x as m,k as Ct,y as Zt,a as n,v as y,d as f,t as h,w as b}from"../chunks/index.d2f673cc.js";import{T as Ye}from"../chunks/Tip.a902c250.js";import{C as ae}from"../chunks/CodeBlock.792343a6.js";import{H as ie}from"../chunks/Heading.675d4c1e.js";function Xt(j){let a,C="When running inference for the first time, there is a warmup phase when you run the pipeline for the first time.  This run would take 3x-4x higher latency than a regular run.";return{c(){a=i("p"),a.textContent=C},l(p){a=r(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-1p17snc"&&(a.textContent=C)},m(p,d){n(p,a,d)},p:Ae,d(p){p&&l(a)}}}function vt(j){let a,C="Be careful, the input shapes used for compilation should be inferior than the size of inputs that you will feed into the model during the inference.";return{c(){a=i("p"),a.textContent=C},l(p){a=r(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-urc7mx"&&(a.textContent=C)},m(p,d){n(p,a,d)},p:Ae,d(p){p&&l(a)}}}function Nt(j){let a,C="<li>What if input sizes are smaller than compilation input shapes?</li>",p,d,T="No worries, <code>NeuronModelForXXX</code> class will pad your inputs to an eligible shape. Besides you can set <code>dynamic_batch_size=True</code> in the <code>from_pretrained</code> method to enable dynamic batching, which means that your inputs can have variable batch size.",w,U,re="<em>(Just keep in mind: dynamicity and padding comes with not only flexibility but also performance drop. Fair enough!)</em>";return{c(){a=i("ul"),a.innerHTML=C,p=o(),d=i("p"),d.innerHTML=T,w=o(),U=i("p"),U.innerHTML=re},l(c){a=r(c,"UL",{"data-svelte-h":!0}),m(a)!=="svelte-6yr52r"&&(a.innerHTML=C),p=s(c),d=r(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-1i2c71c"&&(d.innerHTML=T),w=s(c),U=r(c,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1aeohpg"&&(U.innerHTML=re)},m(c,J){n(c,a,J),n(c,p,J),n(c,d,J),n(c,w,J),n(c,U,J)},p:Ae,d(c){c&&(l(a),l(p),l(d),l(w),l(U))}}}function _t(j){let a,C,p,d,T,w,U,re=`<em>The APIs presented in the following documentation are relevant for the inference on <a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">inf2</a>,
<a href="https://aws.amazon.com/ec2/instance-types/trn1/" rel="nofollow">trn1</a> and <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">inf1</a>.</em>`,c,J,Le=`<code>NeuronModelForXXX</code> classes help to load models from the <a href="hf.co/models">Hugging Face Hub</a> and compile them to a serialized format optimized for
neuron devices. You will then be able to load the model and run inference with the acceleration powered by AWS Neuron devices.`,pe,v,ce,N,Pe=`The <code>optimum.neuron.NeuronModelForXXX</code> model classes are APIs compatible with Hugging Face Transformers models. This means seamless integration
with Hugging Face’s ecosystem. You can just replace your <code>AutoModelForXXX</code> class with the corresponding <code>NeuronModelForXXX</code> class in <code>optimum.neuron</code>.`,de,_,Ke="If you already use Transformers, you will be able to reuse your code just by replacing model classes:",ue,W,Me,$,De="As shown above, when you use <code>NeuronModelForXXX</code> for the first time, you will need to set <code>export=True</code> to compile your model from PyTorch to a neuron-compatible format.",ye,x,Oe="You will also need to pass Neuron specific parameters to configure the export. Each model architecture has its own set of parameters, as detailed in the next paragraphs.",fe,V,et='Once your model has been exported, you can save it either on your local or in the <a href="https://hf.co/models" rel="nofollow">Hugging Face Model Hub</a>:',he,I,be,G,tt="And the next time when you want to run inference, just load your compiled model which will save you the compilation time:",Ue,k,Ce,R,lt=`As you see, there is no need to pass the neuron arguments used during the export as they are
saved in a <code>config.json</code> file, and will be restored automatically by <code>NeuronModelForXXX</code> class.`,Je,g,Te,E,we,F,nt="As explained in the previous section, you will need only few modifications to your Transformers code to export and run NLP models:",je,Q,ge,B,ot="<code>compiler_args</code> are optional arguments for the compiler, these arguments usually control how the compiler makes tradeoff between the inference performance (latency and throughput) and the accuracy. Here we cast FP32 operations to BF16 using the Neuron matrix-multiplication engine.",Ze,q,st=`<code>input_shapes</code> are mandatory static shape information that you need to send to the neuron compiler. Wondering what shapes are mandatory for your model? Check it out
with the following code:`,Xe,H,ve,Z,Ne,X,_e,S,We,z,at="As explained before, you will need only a few modifications to your Transformers code to export and run NLP models:",$e,Y,xe,A,it=`As for non-generative models, two sets of parameters can be passed to the <code>from_pretrained()</code> method to configure how a transformers checkpoint is exported to
a neuron optimized model:`,Ve,L,rt=`<li><p><code>compiler_args = { num_cores, auto_cast_type }</code> are optional arguments for the compiler, these arguments usually control how the compiler makes tradeoff between the inference latency and throughput and the accuracy.</p></li> <li><p><code>input_shapes = { batch_size, sequence_length }</code> correspond to the static shape of the model input and the KV-cache (attention keys and values for past tokens).</p></li> <li><p><code>num_cores</code> is the number of neuron cores used when instantiating the model. Each neuron core has 16 Gb of memory, which means that
bigger models need to be split on multiple cores. Defaults to 1,</p></li> <li><p><code>auto_cast_type</code> specifies the format to encode the weights. It can be one of <code>fp32</code> (<code>float32</code>), <code>fp16</code> (<code>float16</code>) or <code>bf16</code> (<code>bfloat16</code>). Defaults to <code>fp32</code>.</p></li> <li><p><code>batch_size</code> is the number of input sequences that the model will accept. Defaults to 1,</p></li> <li><p><code>sequence_length</code> is the maximum number of tokens in an input sequence. Defaults to <code>max_position_embeddings</code> (<code>n_positions</code> for older models).</p></li>`,Ie,P,Ge,K,mt=`As explained before, these parameters can only be configured during export.
This means in particular that during inference:`,ke,D,pt="<li>the <code>batch_size</code> of the inputs should be equal to the <code>batch_size</code> used during export,</li> <li>the <code>length</code> of the input sequences should be lower than the <code>sequence_length</code> used during export,</li> <li>the maximum number of tokens (input + generated) cannot exceed the <code>sequence_length</code> used during export.</li>",Re,O,Ee,ee,ct="As with the original transformers models, use <code>generate()</code> instead of <code>forward()</code> to generate text sequences.",Fe,te,Qe,le,dt='The generation is highly configurable. Please refer to <a href="https://huggingface.co/docs/transformers/generation_strategies" rel="nofollow">https://huggingface.co/docs/transformers/generation_strategies</a> for details.',Be,ne,ut="Please be aware that:",qe,oe,Mt=`<li>for each model architecture, default values are provided for all parameters, but values passed to the <code>generate</code> method will take precedence,</li> <li>the generation parameters can be stored in a <code>generation_config.json</code> file. When such a file is present in model directory,
it will be parsed to set the default parameters (the values passed to the <code>generate</code> method still take precedence).</li>`,He,se,yt="Happy inference with Neuron! 🚀",Se,me,ze;return T=new ie({props:{title:"Neuron Model Inference",local:"neuron-model-inference",headingTag:"h1"}}),v=new ie({props:{title:"Switching from Transformers to Optimum",local:"switching-from-transformers-to-optimum",headingTag:"h2"}}),W=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMkJmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUwQS1tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyQm1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKm5ldXJvbl9rd2FyZ3Mp",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForSequenceClassification</span>

# PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)</span>

<span class="hljs-addition">+model = NeuronModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;,</span>
<span class="hljs-addition">+                                                             export=True, **neuron_kwargs)</span>`,wrap:!1}}),I=new ae({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmFfbG9jYWxfcGF0aF9mb3JfY29tcGlsZWRfbmV1cm9uX21vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUwQSUyMCUyMCUyMCUyMCUyMmFfbG9jYWxfcGF0aF9mb3JfY29tcGlsZWRfbmV1cm9uX21vZGVsJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRCUyMm15LW5ldXJvbi1yZXBvJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># Save the neuron model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;a_local_path_for_compiled_neuron_model&quot;</span>)

<span class="hljs-comment"># Push the neuron model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;a_local_path_for_compiled_neuron_model&quot;</span>, repository_id=<span class="hljs-string">&quot;my-neuron-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),k=new ae({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm15LW5ldXJvbi1yZXBvJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;my-neuron-repo&quot;</span>)`,wrap:!1}}),g=new Ye({props:{$$slots:{default:[Xt]},$$scope:{ctx:j}}}),E=new ie({props:{title:"Discriminative NLP models",local:"discriminative-nlp-models",headingTag:"h2"}}),Q=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMkJmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUwQS1tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB5b3VyJTIwbW9kZWwlMjBkdXJpbmclMjB0aGUlMjBmaXJzdCUyMHRpbWUlMEElMkJjb21waWxlcl9hcmdzJTIwJTNEJTIwJTdCJTIyYXV0b19jYXN0JTIyJTNBJTIwJTIybWF0bXVsJTIyJTJDJTIwJTIyYXV0b19jYXN0X3R5cGUlMjIlM0ElMjAlMjJiZjE2JTIyJTdEJTBBJTJCaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJzZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjA2NCU3RCUwQSUyQm1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMkIlMjAlMjAlMjAlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyUyQyUwQSUyQiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGFtaWx0b24lMjBpcyUyMGNvbnNpZGVyZWQlMjB0byUyMGJlJTIwdGhlJTIwYmVzdCUyMG11c2ljYWwlMjBvZiUyMGh1bWFuJTIwaGlzdG9yeS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTVEKSUwQSUyMyUyMCdQT1NJVElWRSc=",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForSequenceClassification</span>

# PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForSequenceClassification.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)</span>

# Compile your model during the first time
<span class="hljs-addition">+compiler_args = {&quot;auto_cast&quot;: &quot;matmul&quot;, &quot;auto_cast_type&quot;: &quot;bf16&quot;}</span>
<span class="hljs-addition">+input_shapes = {&quot;batch_size&quot;: 1, &quot;sequence_length&quot;: 64}</span>
<span class="hljs-addition">+model = NeuronModelForSequenceClassification.from_pretrained(</span>
<span class="hljs-addition">+    &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;, export=True, **compiler_args, **input_shapes,</span>
<span class="hljs-addition">+)</span>

tokenizer = AutoTokenizer.from_pretrained(&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;)
inputs = tokenizer(&quot;Hamilton is considered to be the best musical of human history.&quot;, return_tensors=&quot;pt&quot;)

logits = model(**inputs).logits
print(model.config.id2label[logits.argmax().item()])
# &#x27;POSITIVE&#x27;`,wrap:!1}}),H=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwb3B0aW11bS5leHBvcnRlcnMlMjBpbXBvcnQlMjBUYXNrc01hbmFnZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQXRhc2slMjAlM0QlMjBUYXNrc01hbmFnZXIuaW5mZXJfdGFza19mcm9tX21vZGVsKG1vZGVsKSUyMCUyMCUyMyUyMCd0ZXh0LWNsYXNzaWZpY2F0aW9uJyUwQSUwQW5ldXJvbl9jb25maWdfY29uc3RydWN0b3IlMjAlM0QlMjBUYXNrc01hbmFnZXIuZ2V0X2V4cG9ydGVyX2NvbmZpZ19jb25zdHJ1Y3RvciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZXhwb3J0ZXIlM0QlMjJuZXVyb24lMjIlMkMlMjB0YXNrJTNEJ3RleHQtY2xhc3NpZmljYXRpb24nJTBBKSUwQXByaW50KG5ldXJvbl9jb25maWdfY29uc3RydWN0b3IuZnVuYy5nZXRfbWFuZGF0b3J5X2F4ZXNfZm9yX3Rhc2sodGFzaykp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.exporters <span class="hljs-keyword">import</span> TasksManager

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-comment"># Infer the task name if you don&#x27;t know</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>task = TasksManager.infer_task_from_model(model)  <span class="hljs-comment"># &#x27;text-classification&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>neuron_config_constructor = TasksManager.get_exporter_config_constructor(
<span class="hljs-meta">... </span>    model=model, exporter=<span class="hljs-string">&quot;neuron&quot;</span>, task=<span class="hljs-string">&#x27;text-classification&#x27;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(neuron_config_constructor.func.get_mandatory_axes_for_task(task))
<span class="hljs-comment"># (&#x27;batch_size&#x27;, &#x27;sequence_length&#x27;)</span>`,wrap:!1}}),Z=new Ye({props:{$$slots:{default:[vt]},$$scope:{ctx:j}}}),X=new Ye({props:{$$slots:{default:[Nt]},$$scope:{ctx:j}}}),S=new ie({props:{title:"Generative NLP models",local:"generative-nlp-models",headingTag:"h2"}}),Y=new ie({props:{title:"Configuring the export of a generative model",local:"configuring-the-export-of-a-generative-model",headingTag:"h3"}}),P=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTJCZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwYW5kJTIwY29udmVydCUyMHRvJTIwTmV1cm9uJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTBBJTJCY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDElMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDMyJyU3RCUwQSUyQmlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwNTEyJTdEJTBBLW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTJCbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMCoqY29tcGlsZXJfYXJncyUyQyUyMCoqaW5wdXRfc2hhcGVzKQ==",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForCausalLM</span>

# Instantiate and convert to Neuron a PyTorch checkpoint
<span class="hljs-addition">+compiler_args = {&quot;num_cores&quot;: 1, &quot;auto_cast_type&quot;: &#x27;fp32&#x27;}</span>
<span class="hljs-addition">+input_shapes = {&quot;batch_size&quot;: 1, &quot;sequence_length&quot;: 512}</span>
<span class="hljs-deletion">-model = AutoModelForCausalLM.from_pretrained(&quot;gpt2&quot;)</span>
<span class="hljs-addition">+model = NeuronModelForCausalLM.from_pretrained(&quot;gpt2&quot;, export=True, **compiler_args, **input_shapes)</span>`,wrap:!1}}),O=new ie({props:{title:"Text generation inference",local:"text-generation-inference",headingTag:"h3"}}),te=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEEtZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTJCZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluc3RhbnRpYXRlJTIwYW5kJTIwY29udmVydCUyMHRvJTIwTmV1cm9uJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTBBLW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTJCbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTBBJTBBdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjByZWFsbHklMjB3aXNoJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZV9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAqKnRva2VucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtaW5fbGVuZ3RoJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDI1NiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC43JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlNUJ0b2tlbml6ZXIuZGVjb2RlKHRvayklMjBmb3IlMjB0b2slMjBpbiUyMHNhbXBsZV9vdXRwdXQlNUQlMEElMjAlMjAlMjAlMjBwcmludChvdXRwdXRzKQ==",highlighted:`from transformers import AutoTokenizer
<span class="hljs-deletion">-from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+from optimum.neuron import NeuronModelForCausalLM</span>

# Instantiate and convert to Neuron a PyTorch checkpoint
<span class="hljs-deletion">-model = AutoModelForCausalLM.from_pretrained(&quot;gpt2&quot;)</span>
<span class="hljs-addition">+model = NeuronModelForCausalLM.from_pretrained(&quot;gpt2&quot;, export=True)</span>

tokenizer = AutoTokenizer.from_pretrained(&quot;gpt2&quot;)
tokenizer.pad_token_id = tokenizer.eos_token_id

tokens = tokenizer(&quot;I really wish &quot;, return_tensors=&quot;pt&quot;)
with torch.inference_mode():
    sample_output = model.generate(
        **tokens,
        do_sample=True,
        min_length=128,
        max_length=256,
        temperature=0.7,
    )
    outputs = [tokenizer.decode(tok) for tok in sample_output]
    print(outputs)`,wrap:!1}}),{c(){a=i("meta"),C=o(),p=i("p"),d=o(),u(T.$$.fragment),w=o(),U=i("p"),U.innerHTML=re,c=o(),J=i("p"),J.innerHTML=Le,pe=o(),u(v.$$.fragment),ce=o(),N=i("p"),N.innerHTML=Pe,de=o(),_=i("p"),_.textContent=Ke,ue=o(),u(W.$$.fragment),Me=o(),$=i("p"),$.innerHTML=De,ye=o(),x=i("p"),x.textContent=Oe,fe=o(),V=i("p"),V.innerHTML=et,he=o(),u(I.$$.fragment),be=o(),G=i("p"),G.textContent=tt,Ue=o(),u(k.$$.fragment),Ce=o(),R=i("p"),R.innerHTML=lt,Je=o(),u(g.$$.fragment),Te=o(),u(E.$$.fragment),we=o(),F=i("p"),F.textContent=nt,je=o(),u(Q.$$.fragment),ge=o(),B=i("p"),B.innerHTML=ot,Ze=o(),q=i("p"),q.innerHTML=st,Xe=o(),u(H.$$.fragment),ve=o(),u(Z.$$.fragment),Ne=o(),u(X.$$.fragment),_e=o(),u(S.$$.fragment),We=o(),z=i("p"),z.textContent=at,$e=o(),u(Y.$$.fragment),xe=o(),A=i("p"),A.innerHTML=it,Ve=o(),L=i("ul"),L.innerHTML=rt,Ie=o(),u(P.$$.fragment),Ge=o(),K=i("p"),K.textContent=mt,ke=o(),D=i("ul"),D.innerHTML=pt,Re=o(),u(O.$$.fragment),Ee=o(),ee=i("p"),ee.innerHTML=ct,Fe=o(),u(te.$$.fragment),Qe=o(),le=i("p"),le.innerHTML=dt,Be=o(),ne=i("p"),ne.textContent=ut,qe=o(),oe=i("ul"),oe.innerHTML=Mt,He=o(),se=i("p"),se.textContent=yt,Se=o(),me=i("p"),this.h()},l(e){const t=gt("svelte-u9bgzb",document.head);a=r(t,"META",{name:!0,content:!0}),t.forEach(l),C=s(e),p=r(e,"P",{}),Ut(p).forEach(l),d=s(e),M(T.$$.fragment,e),w=s(e),U=r(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1eizqkl"&&(U.innerHTML=re),c=s(e),J=r(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1pwj84v"&&(J.innerHTML=Le),pe=s(e),M(v.$$.fragment,e),ce=s(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-11gy3bo"&&(N.innerHTML=Pe),de=s(e),_=r(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1nb8pat"&&(_.textContent=Ke),ue=s(e),M(W.$$.fragment,e),Me=s(e),$=r(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-qud127"&&($.innerHTML=De),ye=s(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-126hjbj"&&(x.textContent=Oe),fe=s(e),V=r(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1l6u6ld"&&(V.innerHTML=et),he=s(e),M(I.$$.fragment,e),be=s(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-x3o861"&&(G.textContent=tt),Ue=s(e),M(k.$$.fragment,e),Ce=s(e),R=r(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1ugid4e"&&(R.innerHTML=lt),Je=s(e),M(g.$$.fragment,e),Te=s(e),M(E.$$.fragment,e),we=s(e),F=r(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-10onjii"&&(F.textContent=nt),je=s(e),M(Q.$$.fragment,e),ge=s(e),B=r(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1f1bjg7"&&(B.innerHTML=ot),Ze=s(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-qvhyy7"&&(q.innerHTML=st),Xe=s(e),M(H.$$.fragment,e),ve=s(e),M(Z.$$.fragment,e),Ne=s(e),M(X.$$.fragment,e),_e=s(e),M(S.$$.fragment,e),We=s(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-njr3h4"&&(z.textContent=at),$e=s(e),M(Y.$$.fragment,e),xe=s(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-18n8q64"&&(A.innerHTML=it),Ve=s(e),L=r(e,"UL",{"data-svelte-h":!0}),m(L)!=="svelte-ezyrr9"&&(L.innerHTML=rt),Ie=s(e),M(P.$$.fragment,e),Ge=s(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1d0ot4r"&&(K.textContent=mt),ke=s(e),D=r(e,"UL",{"data-svelte-h":!0}),m(D)!=="svelte-d4fneu"&&(D.innerHTML=pt),Re=s(e),M(O.$$.fragment,e),Ee=s(e),ee=r(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-qc8n5z"&&(ee.innerHTML=ct),Fe=s(e),M(te.$$.fragment,e),Qe=s(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1266wn0"&&(le.innerHTML=dt),Be=s(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1g2jw6w"&&(ne.textContent=ut),qe=s(e),oe=r(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-14ajc9a"&&(oe.innerHTML=Mt),He=s(e),se=r(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-12v26si"&&(se.textContent=yt),Se=s(e),me=r(e,"P",{}),Ut(me).forEach(l),this.h()},h(){Ct(a,"name","hf:doc:metadata"),Ct(a,"content",Wt)},m(e,t){Zt(document.head,a),n(e,C,t),n(e,p,t),n(e,d,t),y(T,e,t),n(e,w,t),n(e,U,t),n(e,c,t),n(e,J,t),n(e,pe,t),y(v,e,t),n(e,ce,t),n(e,N,t),n(e,de,t),n(e,_,t),n(e,ue,t),y(W,e,t),n(e,Me,t),n(e,$,t),n(e,ye,t),n(e,x,t),n(e,fe,t),n(e,V,t),n(e,he,t),y(I,e,t),n(e,be,t),n(e,G,t),n(e,Ue,t),y(k,e,t),n(e,Ce,t),n(e,R,t),n(e,Je,t),y(g,e,t),n(e,Te,t),y(E,e,t),n(e,we,t),n(e,F,t),n(e,je,t),y(Q,e,t),n(e,ge,t),n(e,B,t),n(e,Ze,t),n(e,q,t),n(e,Xe,t),y(H,e,t),n(e,ve,t),y(Z,e,t),n(e,Ne,t),y(X,e,t),n(e,_e,t),y(S,e,t),n(e,We,t),n(e,z,t),n(e,$e,t),y(Y,e,t),n(e,xe,t),n(e,A,t),n(e,Ve,t),n(e,L,t),n(e,Ie,t),y(P,e,t),n(e,Ge,t),n(e,K,t),n(e,ke,t),n(e,D,t),n(e,Re,t),y(O,e,t),n(e,Ee,t),n(e,ee,t),n(e,Fe,t),y(te,e,t),n(e,Qe,t),n(e,le,t),n(e,Be,t),n(e,ne,t),n(e,qe,t),n(e,oe,t),n(e,He,t),n(e,se,t),n(e,Se,t),n(e,me,t),ze=!0},p(e,[t]){const ft={};t&2&&(ft.$$scope={dirty:t,ctx:e}),g.$set(ft);const ht={};t&2&&(ht.$$scope={dirty:t,ctx:e}),Z.$set(ht);const bt={};t&2&&(bt.$$scope={dirty:t,ctx:e}),X.$set(bt)},i(e){ze||(f(T.$$.fragment,e),f(v.$$.fragment,e),f(W.$$.fragment,e),f(I.$$.fragment,e),f(k.$$.fragment,e),f(g.$$.fragment,e),f(E.$$.fragment,e),f(Q.$$.fragment,e),f(H.$$.fragment,e),f(Z.$$.fragment,e),f(X.$$.fragment,e),f(S.$$.fragment,e),f(Y.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),ze=!0)},o(e){h(T.$$.fragment,e),h(v.$$.fragment,e),h(W.$$.fragment,e),h(I.$$.fragment,e),h(k.$$.fragment,e),h(g.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(Z.$$.fragment,e),h(X.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),ze=!1},d(e){e&&(l(C),l(p),l(d),l(w),l(U),l(c),l(J),l(pe),l(ce),l(N),l(de),l(_),l(ue),l(Me),l($),l(ye),l(x),l(fe),l(V),l(he),l(be),l(G),l(Ue),l(Ce),l(R),l(Je),l(Te),l(we),l(F),l(je),l(ge),l(B),l(Ze),l(q),l(Xe),l(ve),l(Ne),l(_e),l(We),l(z),l($e),l(xe),l(A),l(Ve),l(L),l(Ie),l(Ge),l(K),l(ke),l(D),l(Re),l(Ee),l(ee),l(Fe),l(Qe),l(le),l(Be),l(ne),l(qe),l(oe),l(He),l(se),l(Se),l(me)),l(a),b(T,e),b(v,e),b(W,e),b(I,e),b(k,e),b(g,e),b(E,e),b(Q,e),b(H,e),b(Z,e),b(X,e),b(S,e),b(Y,e),b(P,e),b(O,e),b(te,e)}}}const Wt='{"title":"Neuron Model Inference","local":"neuron-model-inference","sections":[{"title":"Switching from Transformers to Optimum","local":"switching-from-transformers-to-optimum","sections":[],"depth":2},{"title":"Discriminative NLP models","local":"discriminative-nlp-models","sections":[],"depth":2},{"title":"Generative NLP models","local":"generative-nlp-models","sections":[{"title":"Configuring the export of a generative model","local":"configuring-the-export-of-a-generative-model","sections":[],"depth":3},{"title":"Text generation inference","local":"text-generation-inference","sections":[],"depth":3}],"depth":2}],"depth":1}';function $t(j){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends wt{constructor(a){super(),jt(this,a,$t,_t,Jt,{})}}export{Rt as component};
