import{s as Dn,o as Rn,n as E}from"../chunks/scheduler.6062bdaf.js";import{S as kn,i as En,g as d,s as o,r as m,A as Nn,h as p,f as t,c as r,j as x,u as h,x as C,k as J,y as c,a as i,v as u,d as M,t as f,w as _,m as $n,n as In}from"../chunks/index.4bca734e.js";import{T as An}from"../chunks/Tip.b9ac1f03.js";import{D as w}from"../chunks/Docstring.ed07512f.js";import{C as X}from"../chunks/CodeBlock.fa01571c.js";import{E as B}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as $}from"../chunks/Heading.723dceba.js";function Zn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBdGV4dCUyMCUzRCUyMCcnJyUwQS0tLSUwQWxhbmd1YWdlJTNBJTIwZW4lMEFsaWNlbnNlJTNBJTIwbWl0JTBBLS0tJTBBJTIzJTIwTXklMjByZXBvJTBBJycnJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkKHRleHQpJTBBY2FyZC5kYXRhLnRvX2RpY3QoKSUwQWNhcmQudGV4dCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>language: en
<span class="hljs-meta">... </span>license: mit
<span class="hljs-meta">... </span>---
...
<span class="hljs-meta">... </span># My repo
<span class="hljs-meta">... </span>&#x27;&#x27;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard(text)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.to_dict()
{<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>card.text
<span class="hljs-string">&#x27;\\n# My repo\\n&#x27;</span>
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Wn(U){let n,y,j=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
when the content of the repo card metadata is not a dictionary.</li>`;return{c(){n=$n(`Raises the following error:
`),y=d("ul"),y.innerHTML=j},l(s){n=In(s,`Raises the following error:
`),y=p(s,"UL",{"data-svelte-h":!0}),C(y)!=="svelte-1ewksj3"&&(y.innerHTML=j)},m(s,g){i(s,n,g),i(s,y,g)},p:E,d(s){s&&(t(n),t(y))}}}function Gn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkLmxvYWQoJTIybmF0ZXJhdyUyRmZvb2QlMjIpJTBBYXNzZXJ0JTIwY2FyZC5kYXRhLnRhZ3MlMjAlM0QlM0QlMjAlNUIlMjJnZW5lcmF0ZWRfZnJvbV90cmFpbmVyJTIyJTJDJTIwJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjJweXRvcmNoJTIyJTVEJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard.load(<span class="hljs-string">&quot;nateraw/food&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> card.data.tags == [<span class="hljs-string">&quot;generated_from_trainer&quot;</span>, <span class="hljs-string">&quot;image-classification&quot;</span>, <span class="hljs-string">&quot;pytorch&quot;</span>]
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Yn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZCUyMGltcG9ydCUyMFJlcG9DYXJkJTBBY2FyZCUyMCUzRCUyMFJlcG9DYXJkKCUyMi0tLSU1Q25sYW5ndWFnZSUzQSUyMGVuJTVDbi0tLSU1Q24lMjMlMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMHJlcG8lMjBjYXJkJTIyKSUwQWNhcmQuc2F2ZSglMjIlMkZ0bXAlMkZ0ZXN0Lm1kJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> RepoCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = RepoCard(<span class="hljs-string">&quot;---\\nlanguage: en\\n---\\n# This is a test repo card&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.save(<span class="hljs-string">&quot;/tmp/test.md&quot;</span>)
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Fn(U){let n,y,j=`<li><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if the card fails validation checks.</li> <li><a href="https://requests.readthedocs.io/en/latest/api/#requests.HTTPError" rel="nofollow"><code>HTTPError</code></a>
if the request to the Hub API fails for any other reason.</li>`;return{c(){n=$n(`Raises the following errors:
`),y=d("ul"),y.innerHTML=j},l(s){n=In(s,`Raises the following errors:
`),y=p(s,"UL",{"data-svelte-h":!0}),C(y)!=="svelte-brxevo"&&(y.innerHTML=j)},m(s,g){i(s,n,g),i(s,y,g)},p:E,d(s){s&&(t(n),t(y))}}}function Qn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData, EvalResult

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using the Default Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>    library_name=<span class="hljs-string">&#x27;timm&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>    datasets=[<span class="hljs-string">&#x27;beans&#x27;</span>],
<span class="hljs-meta">... </span>    metrics=[<span class="hljs-string">&#x27;accuracy&#x27;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(
<span class="hljs-meta">... </span>    card_data,
<span class="hljs-meta">... </span>    model_description=<span class="hljs-string">&#x27;This model does x + y...&#x27;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Including Evaluation Results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>    eval_results=[
<span class="hljs-meta">... </span>        EvalResult(
<span class="hljs-meta">... </span>            task_type=<span class="hljs-string">&#x27;image-classification&#x27;</span>,
<span class="hljs-meta">... </span>            dataset_type=<span class="hljs-string">&#x27;beans&#x27;</span>,
<span class="hljs-meta">... </span>            dataset_name=<span class="hljs-string">&#x27;Beans&#x27;</span>,
<span class="hljs-meta">... </span>            metric_type=<span class="hljs-string">&#x27;accuracy&#x27;</span>,
<span class="hljs-meta">... </span>            metric_value=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    model_name=<span class="hljs-string">&#x27;my-cool-model&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(card_data)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using a Custom Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.from_template(
<span class="hljs-meta">... </span>    card_data=card_data,
<span class="hljs-meta">... </span>    template_path=<span class="hljs-string">&#x27;./src/huggingface_hub/templates/modelcard_template.md&#x27;</span>,
<span class="hljs-meta">... </span>    custom_template_var=<span class="hljs-string">&#x27;custom value&#x27;</span>,  <span class="hljs-comment"># will be replaced in template if it exists</span>
<span class="hljs-meta">... </span>)
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Sn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZERhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBNb2RlbENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJTIybWl0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIydGltbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhZ3MlM0QlNUInaW1hZ2UtY2xhc3NpZmljYXRpb24nJTJDJTIwJ3Jlc25ldCclNUQlMkMlMEEpJTBBY2FyZF9kYXRhLnRvX2RpY3QoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCardData
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = ModelCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&quot;en&quot;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&quot;mit&quot;</span>,
<span class="hljs-meta">... </span>    library_name=<span class="hljs-string">&quot;timm&quot;</span>,
<span class="hljs-meta">... </span>    tags=[<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data.to_dict()
{<span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>, <span class="hljs-string">&#x27;library_name&#x27;</span>: <span class="hljs-string">&#x27;timm&#x27;</span>, <span class="hljs-string">&#x27;tags&#x27;</span>: [<span class="hljs-string">&#x27;image-classification&#x27;</span>, <span class="hljs-string">&#x27;resnet&#x27;</span>]}
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Bn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMERhdGFzZXRDYXJkJTJDJTIwRGF0YXNldENhcmREYXRhJTBBJTBBJTIzJTIwVXNpbmclMjB0aGUlMjBEZWZhdWx0JTIwVGVtcGxhdGUlMEFjYXJkX2RhdGElMjAlM0QlMjBEYXRhc2V0Q2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwbGFuZ3VhZ2UlM0QnZW4nJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCdtaXQnJTJDJTBBJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnNfY3JlYXRvcnMlM0QnY3Jvd2Rzb3VyY2VkJyUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfY2F0ZWdvcmllcyUzRCU1Qid0ZXh0LWNsYXNzaWZpY2F0aW9uJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfaWRzJTNEJTVCJ3NlbnRpbWVudC1jbGFzc2lmaWNhdGlvbiclMkMlMjAndGV4dC1zY29yaW5nJyU1RCUyQyUwQSUyMCUyMCUyMCUyMG11bHRpbGluZ3VhbGl0eSUzRCdtb25vbGluZ3VhbCclMkMlMEElMjAlMjAlMjAlMjBwcmV0dHlfbmFtZSUzRCdNeSUyMFRleHQlMjBDbGFzc2lmaWNhdGlvbiUyMERhdGFzZXQnJTJDJTBBKSUwQWNhcmQlMjAlM0QlMjBEYXRhc2V0Q2FyZC5mcm9tX3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMGNhcmRfZGF0YSUyQyUwQSUyMCUyMCUyMCUyMHByZXR0eV9uYW1lJTNEY2FyZF9kYXRhLnByZXR0eV9uYW1lJTJDJTBBKSUwQSUwQSUyMyUyMFVzaW5nJTIwYSUyMEN1c3RvbSUyMFRlbXBsYXRlJTBBY2FyZF9kYXRhJTIwJTNEJTIwRGF0YXNldENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJ2VuJyUyQyUwQSUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUwQSklMEFjYXJkJTIwJTNEJTIwRGF0YXNldENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBjYXJkX2RhdGElM0RjYXJkX2RhdGElMkMlMEElMjAlMjAlMjAlMjB0ZW1wbGF0ZV9wYXRoJTNEJy4lMkZzcmMlMkZodWdnaW5nZmFjZV9odWIlMkZ0ZW1wbGF0ZXMlMkZkYXRhc2V0Y2FyZF90ZW1wbGF0ZS5tZCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fdGVtcGxhdGVfdmFyJTNEJ2N1c3RvbSUyMHZhbHVlJyUyQyUyMCUyMCUyMyUyMHdpbGwlMjBiZSUyMHJlcGxhY2VkJTIwaW4lMjB0ZW1wbGF0ZSUyMGlmJTIwaXQlMjBleGlzdHMlMEEpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> DatasetCard, DatasetCardData

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using the Default Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = DatasetCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>    annotations_creators=<span class="hljs-string">&#x27;crowdsourced&#x27;</span>,
<span class="hljs-meta">... </span>    task_categories=[<span class="hljs-string">&#x27;text-classification&#x27;</span>],
<span class="hljs-meta">... </span>    task_ids=[<span class="hljs-string">&#x27;sentiment-classification&#x27;</span>, <span class="hljs-string">&#x27;text-scoring&#x27;</span>],
<span class="hljs-meta">... </span>    multilinguality=<span class="hljs-string">&#x27;monolingual&#x27;</span>,
<span class="hljs-meta">... </span>    pretty_name=<span class="hljs-string">&#x27;My Text Classification Dataset&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = DatasetCard.from_template(
<span class="hljs-meta">... </span>    card_data,
<span class="hljs-meta">... </span>    pretty_name=card_data.pretty_name,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Using a Custom Template</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = DatasetCardData(
<span class="hljs-meta">... </span>    language=<span class="hljs-string">&#x27;en&#x27;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&#x27;mit&#x27;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card = DatasetCard.from_template(
<span class="hljs-meta">... </span>    card_data=card_data,
<span class="hljs-meta">... </span>    template_path=<span class="hljs-string">&#x27;./src/huggingface_hub/templates/datasetcard_template.md&#x27;</span>,
<span class="hljs-meta">... </span>    custom_template_var=<span class="hljs-string">&#x27;custom value&#x27;</span>,  <span class="hljs-comment"># will be replaced in template if it exists</span>
<span class="hljs-meta">... </span>)
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Xn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFNwYWNlQ2FyZERhdGElMEFjYXJkX2RhdGElMjAlM0QlMjBTcGFjZUNhcmREYXRhKCUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyRHJlYW1ib290aCUyMFRyYWluaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGljZW5zZSUzRCUyMm1pdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNkayUzRCUyMmdyYWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMGR1cGxpY2F0ZWRfZnJvbSUzRCUyMm11bHRpbW9kYWxhcnQlMkZkcmVhbWJvb3RoLXRyYWluaW5nJTIyJTBBKSUwQWNhcmRfZGF0YS50b19kaWN0KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> SpaceCardData
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data = SpaceCardData(
<span class="hljs-meta">... </span>    title=<span class="hljs-string">&quot;Dreambooth Training&quot;</span>,
<span class="hljs-meta">... </span>    license=<span class="hljs-string">&quot;mit&quot;</span>,
<span class="hljs-meta">... </span>    sdk=<span class="hljs-string">&quot;gradio&quot;</span>,
<span class="hljs-meta">... </span>    duplicated_from=<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card_data.to_dict()
{<span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Dreambooth Training&#x27;</span>, <span class="hljs-string">&#x27;sdk&#x27;</span>: <span class="hljs-string">&#x27;gradio&#x27;</span>, <span class="hljs-string">&#x27;license&#x27;</span>: <span class="hljs-string">&#x27;mit&#x27;</span>, <span class="hljs-string">&#x27;duplicated_from&#x27;</span>: <span class="hljs-string">&#x27;multimodalart/dreambooth-training&#x27;</span>}`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Vn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard_data <span class="hljs-keyword">import</span> model_index_to_eval_results
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define a minimal model index</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_index = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;my-cool-model&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;results&quot;</span>: [
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;task&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image-classification&quot;</span>
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;dataset&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;beans&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;Beans&quot;</span>
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;metrics&quot;</span>: [
<span class="hljs-meta">... </span>                    {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-number">0.9</span>
<span class="hljs-meta">... </span>                    }
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        ]
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name, eval_results = model_index_to_eval_results(model_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name
<span class="hljs-string">&#x27;my-cool-model&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results[<span class="hljs-number">0</span>].task_type
<span class="hljs-string">&#x27;image-classification&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results[<span class="hljs-number">0</span>].metric_type
<span class="hljs-string">&#x27;accuracy&#x27;</span>
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Hn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi5yZXBvY2FyZF9kYXRhJTIwaW1wb3J0JTIwZXZhbF9yZXN1bHRzX3RvX21vZGVsX2luZGV4JTJDJTIwRXZhbFJlc3VsdCUwQSUyMyUyMERlZmluZSUyMG1pbmltYWwlMjBldmFsX3Jlc3VsdHMlMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBFdmFsUmVzdWx0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwJTIwJTIzJTIwUmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X3R5cGUlM0QlMjJiZWFucyUyMiUyQyUyMCUyMCUyMyUyMFJlcXVpcmVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF9uYW1lJTNEJTIyQmVhbnMlMjIlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY190eXBlJTNEJTIyYWNjdXJhY3klMjIlMkMlMjAlMjAlMjMlMjBSZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY192YWx1ZSUzRDAuOSUyQyUyMCUyMCUyMyUyMFJlcXVpcmVkJTBBJTIwJTIwJTIwJTIwKSUwQSU1RCUwQWV2YWxfcmVzdWx0c190b19tb2RlbF9pbmRleCglMjJteS1jb29sLW1vZGVsJTIyJTJDJTIwZXZhbF9yZXN1bHRzKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.repocard_data <span class="hljs-keyword">import</span> eval_results_to_model_index, EvalResult
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define minimal eval_results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results = [
<span class="hljs-meta">... </span>    EvalResult(
<span class="hljs-meta">... </span>        task_type=<span class="hljs-string">&quot;image-classification&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        dataset_type=<span class="hljs-string">&quot;beans&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        dataset_name=<span class="hljs-string">&quot;Beans&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        metric_type=<span class="hljs-string">&quot;accuracy&quot;</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>        metric_value=<span class="hljs-number">0.9</span>,  <span class="hljs-comment"># Required</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_results_to_model_index(<span class="hljs-string">&quot;my-cool-model&quot;</span>, eval_results)
[{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;my-cool-model&#x27;</span>, <span class="hljs-string">&#x27;results&#x27;</span>: [{<span class="hljs-string">&#x27;task&#x27;</span>: {<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;image-classification&#x27;</span>}, <span class="hljs-string">&#x27;dataset&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Beans&#x27;</span>, <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;beans&#x27;</span>}, <span class="hljs-string">&#x27;metrics&#x27;</span>: [{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;accuracy&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.9</span>}]}]}]
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function Ln(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_eval_result
<span class="hljs-meta">&gt;&gt;&gt; </span>results = metadata_eval_result(
<span class="hljs-meta">... </span>        model_pretty_name=<span class="hljs-string">&quot;RoBERTa fine-tuned on ReactionGIF&quot;</span>,
<span class="hljs-meta">... </span>        task_pretty_name=<span class="hljs-string">&quot;Text Classification&quot;</span>,
<span class="hljs-meta">... </span>        task_id=<span class="hljs-string">&quot;text-classification&quot;</span>,
<span class="hljs-meta">... </span>        metrics_pretty_name=<span class="hljs-string">&quot;Accuracy&quot;</span>,
<span class="hljs-meta">... </span>        metrics_id=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>        metrics_value=<span class="hljs-number">0.2662102282047272</span>,
<span class="hljs-meta">... </span>        dataset_pretty_name=<span class="hljs-string">&quot;ReactionJPEG&quot;</span>,
<span class="hljs-meta">... </span>        dataset_id=<span class="hljs-string">&quot;julien-c/reactionjpeg&quot;</span>,
<span class="hljs-meta">... </span>        dataset_config=<span class="hljs-string">&quot;default&quot;</span>,
<span class="hljs-meta">... </span>        dataset_split=<span class="hljs-string">&quot;test&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>results == {
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;model-index&#x27;</span>: [
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;RoBERTa fine-tuned on ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;results&#x27;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;task&#x27;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text-classification&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Text Classification&#x27;</span>
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;dataset&#x27;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;ReactionJPEG&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;julien-c/reactionjpeg&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;config&#x27;</span>: <span class="hljs-string">&#x27;default&#x27;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&#x27;split&#x27;</span>: <span class="hljs-string">&#x27;test&#x27;</span>
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&#x27;metrics&#x27;</span>: [
<span class="hljs-meta">... </span>                        {
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;accuracy&#x27;</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.2662102282047272</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Accuracy&#x27;</span>,
<span class="hljs-meta">... </span>                            <span class="hljs-string">&#x27;verified&#x27;</span>: <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>                        }
<span class="hljs-meta">... </span>                    ]
<span class="hljs-meta">... </span>                }
<span class="hljs-meta">... </span>            ]
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>}
<span class="hljs-literal">True</span>
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function qn(U){let n,y="Example:",j,s,g;return s=new X({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1ldGFkYXRhX3VwZGF0ZSUwQW1ldGFkYXRhJTIwJTNEJTIwJTdCJ21vZGVsLWluZGV4JyUzQSUyMCU1QiU3QiduYW1lJyUzQSUyMCdSb0JFUlRhJTIwZmluZS10dW5lZCUyMG9uJTIwUmVhY3Rpb25HSUYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Jlc3VsdHMnJTNBJTIwJTVCJTdCJ2RhdGFzZXQnJTNBJTIwJTdCJ25hbWUnJTNBJTIwJ1JlYWN0aW9uR0lGJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCd0eXBlJyUzQSUyMCdqdWxpZW4tYyUyRnJlYWN0aW9uZ2lmJyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdtZXRyaWNzJyUzQSUyMCU1QiU3QiduYW1lJyUzQSUyMCdSZWNhbGwnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3R5cGUnJTNBJTIwJ3JlY2FsbCclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAndmFsdWUnJTNBJTIwMC43NzYyMTAyMjgyMDQ3MjcyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Rhc2snJTNBJTIwJTdCJ25hbWUnJTNBJTIwJ1RleHQlMjBDbGFzc2lmaWNhdGlvbiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAndHlwZSclM0ElMjAndGV4dC1jbGFzc2lmaWNhdGlvbiclN0QlN0QlNUQlN0QlNUQlN0QlMEF1cmwlMjAlM0QlMjBtZXRhZGF0YV91cGRhdGUoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnJlYWN0aW9uZ2lmLXJvYmVydGEtY2FyZCUyMiUyQyUyMG1ldGFkYXRhKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> metadata_update
<span class="hljs-meta">&gt;&gt;&gt; </span>metadata = {<span class="hljs-string">&#x27;model-index&#x27;</span>: [{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;RoBERTa fine-tuned on ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&#x27;results&#x27;</span>: [{<span class="hljs-string">&#x27;dataset&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;ReactionGIF&#x27;</span>,
<span class="hljs-meta">... </span>                                     <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;julien-c/reactiongif&#x27;</span>},
<span class="hljs-meta">... </span>                          <span class="hljs-string">&#x27;metrics&#x27;</span>: [{<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Recall&#x27;</span>,
<span class="hljs-meta">... </span>                                       <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;recall&#x27;</span>,
<span class="hljs-meta">... </span>                                       <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.7762102282047272</span>}],
<span class="hljs-meta">... </span>                         <span class="hljs-string">&#x27;task&#x27;</span>: {<span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;Text Classification&#x27;</span>,
<span class="hljs-meta">... </span>                                  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;text-classification&#x27;</span>}}]}]}
<span class="hljs-meta">&gt;&gt;&gt; </span>url = metadata_update(<span class="hljs-string">&quot;hf-internal-testing/reactiongif-roberta-card&quot;</span>, metadata)
`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,j=o(),m(s.$$.fragment)},l(a){n=p(a,"P",{"data-svelte-h":!0}),C(n)!=="svelte-11lpom8"&&(n.textContent=y),j=r(a),h(s.$$.fragment,a)},m(a,b){i(a,n,b),i(a,j,b),u(s,a,b),g=!0},p:E,i(a){g||(M(s.$$.fragment,a),g=!0)},o(a){f(s.$$.fragment,a),g=!1},d(a){a&&(t(n),t(j)),_(s,a)}}}function zn(U){let n,y,j,s,g,a,b,Hs=`The huggingface_hub library provides a Python interface to create, share, and update Model/Dataset Cards.
Visit the <a href="https://huggingface.co/docs/hub/models-cards" rel="nofollow">dedicated documentation page</a> for a deeper view of what
Model Cards on the Hub are, and how they work under the hood. You can also check out our <a href="../how-to-model-cards">Model Cards guide</a> to
get a feel for how you would use these utilities in your own projects.`,rt,Te,ct,ve,Ls='The <code>RepoCard</code> object is the parent class of <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.ModelCard">ModelCard</a>, <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.DatasetCard">DatasetCard</a> and <code>SpaceCard</code>.',it,v,Ae,Xt,N,$e,Vt,wa,qs=`Initialize a RepoCard from string content. The content should be a
Markdown file with a YAML block at the beginning and a Markdown body.`,Ht,se,Lt,ne,qt,V,Ie,zt,Ta,zs="Initialize a RepoCard from a template. By default, it uses the default template.",Ot,va,Os="Templates are Jinja2 templates that can be customized by passing keyword arguments.",Pt,H,De,Kt,Aa,Ps="Initialize a RepoCard from a Hugging Face Hub repo’s README.md or a local filepath.",es,le,as,oe,Re,ts,$a,Ks="Push a RepoCard to a Hugging Face Hub repo.",ss,L,ke,ns,Ia,en="Save a RepoCard to a file.",ls,re,os,q,Ee,rs,Da,an=`Validates card against Hugging Face Hub’s card validation logic.
Using this function requires access to the internet, so it is only called
internally by <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.RepoCard.push_to_hub">huggingface_hub.repocard.RepoCard.push_to_hub()</a>.`,cs,ce,dt,Ne,pt,Ze,tn='The <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.CardData">CardData</a> object is the parent class of <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> and <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.DatasetCardData">DatasetCardData</a>.',gt,T,We,is,Ra,sn="Structure containing metadata from a RepoCard.",ds,ka,nn='<a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.CardData">CardData</a> is the parent class of <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.ModelCardData">ModelCardData</a> and <a href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.DatasetCardData">DatasetCardData</a>.',ps,Ea,ln=`Metadata can be exported as a dictionary or YAML. Export can be customized to alter the representation of the data
(example: flatten evaluation results). <code>CardData</code> behaves as a dictionary (can get, pop, set values) but do not
inherit from <code>dict</code> to allow this export step.`,gs,ie,Ge,ms,Na,on="Get value for a given metadata key.",hs,de,Ye,us,Za,rn="Pop value for a given metadata key.",Ms,pe,Fe,fs,Wa,cn="Converts CardData to a dict.",_s,ge,Qe,js,Ga,dn="Dumps CardData to a YAML block for inclusion in a README.md file.",mt,Se,ht,Be,ut,z,Xe,ys,Z,Ve,bs,Ya,pn=`Initialize a ModelCard from a template. By default, it uses the default template, which can be found here:
<a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/modelcard_template.md</a>`,Cs,Fa,gn="Templates are Jinja2 templates that can be customized by passing keyword arguments.",Us,me,Mt,He,ft,G,Le,xs,Qa,mn="Model Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",Js,he,_t,qe,jt,ze,hn="Dataset cards are also known as Data Cards in the ML Community.",yt,Oe,bt,O,Pe,ws,W,Ke,Ts,Sa,un=`Initialize a DatasetCard from a template. By default, it uses the default template, which can be found here:
<a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/datasetcard_template.md" rel="nofollow">https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/templates/datasetcard_template.md</a>`,vs,Ba,Mn="Templates are Jinja2 templates that can be customized by passing keyword arguments.",As,ue,Ct,ea,Ut,P,aa,$s,Xa,fn="Dataset Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",xt,ta,Jt,sa,wt,na,la,Tt,oa,vt,D,ra,Is,Va,_n="Space Card Metadata that is used by Hugging Face Hub when included at the top of your README.md",Ds,Ha,jn='To get an exhaustive reference of Spaces configuration, please visit <a href="https://huggingface.co/docs/hub/spaces-config-reference#spaces-configuration-reference" rel="nofollow">https://huggingface.co/docs/hub/spaces-config-reference#spaces-configuration-reference</a>.',Rs,Me,At,ca,$t,ia,It,R,da,ks,La,yn="Flattened representation of individual evaluation results found in model-index of Model Cards.",Es,qa,bn='For more information on the model-index spec, see <a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1</a>.',Ns,fe,pa,Zs,za,Cn=`Return True if <code>self</code> and <code>other</code> describe exactly the same metric but with a
different value.`,Dt,ga,Rt,k,ma,Ws,Oa,Un="Takes in a model index and returns the model name and a list of <code>huggingface_hub.EvalResult</code> objects.",Gs,Pa,xn=`A detailed spec of the model index can be found here:
<a href="https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1" rel="nofollow">https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1</a>`,Ys,_e,kt,ha,Et,Y,ua,Fs,Ka,Jn=`Takes in given model name and list of <code>huggingface_hub.EvalResult</code> and returns a
valid model-index that will be compatible with the format expected by the
Hugging Face Hub.`,Qs,je,Nt,Ma,Zt,F,fa,Ss,et,wn="Creates a metadata dict with the result from a model evaluated on a dataset.",Bs,ye,Wt,_a,Gt,Q,ja,Xs,at,Tn=`Updates the metadata in the README.md of a repository on the Hugging Face Hub.
If the README.md file doesn’t exist yet, a new one is created with metadata and an
the default ModelCard or DatasetCard template. For <code>space</code> repo, an error is thrown
as a Space cannot exist without a <code>README.md</code> file.`,Vs,be,Yt,ot,Ft;return g=new $({props:{title:"Repository Cards",local:"repository-cards",headingTag:"h1"}}),Te=new $({props:{title:"Repo Card",local:"huggingface_hub.RepoCard",headingTag:"h2"}}),Ae=new w({props:{name:"class huggingface_hub.RepoCard",anchor:"huggingface_hub.RepoCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L37"}}),$e=new w({props:{name:"__init__",anchor:"huggingface_hub.RepoCard.__init__",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.__init__.content",description:"<strong>content</strong> (<code>str</code>) &#x2014; The content of the Markdown file.",name:"content"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L42"}}),se=new B({props:{anchor:"huggingface_hub.RepoCard.__init__.example",$$slots:{default:[Zn]},$$scope:{ctx:U}}}),ne=new An({props:{$$slots:{default:[Wn]},$$scope:{ctx:U}}}),Ie=new w({props:{name:"from_template",anchor:"huggingface_hub.RepoCard.from_template",parameters:[{name:"card_data",val:": CardData"},{name:"template_path",val:": Optional = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.CardData</code>) &#x2014;
A huggingface_hub.CardData instance containing the metadata you want to include in the YAML
header of the repo card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.RepoCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A RepoCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.RepoCard"
>huggingface_hub.repocard.RepoCard</a></p>
`}}),De=new w({props:{name:"load",anchor:"huggingface_hub.RepoCard.load",parameters:[{name:"repo_id_or_path",val:": Union"},{name:"repo_type",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"ignore_metadata_errors",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.load.repo_id_or_path",description:`<strong>repo_id_or_path</strong> (<code>Union[str, Path]</code>) &#x2014;
The repo ID associated with a Hugging Face Hub repo or a local filepath.`,name:"repo_id_or_path"},{anchor:"huggingface_hub.RepoCard.load.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The type of Hugging Face repo to push to. Defaults to None, which will use use &#x201C;model&#x201D;. Other options
are &#x201C;dataset&#x201D; and &#x201C;space&#x201D;. Not used when loading from a local filepath. If this is called from a child
class, the default value will be the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"},{anchor:"huggingface_hub.RepoCard.load.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token, obtained with <code>huggingface_hub.HfApi.login</code> method. Will default to the stored token.`,name:"token"},{anchor:"huggingface_hub.RepoCard.load.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L136",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The RepoCard (or subclass) initialized from the repo’s
README.md file or filepath.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.RepoCard"
>huggingface_hub.repocard.RepoCard</a></p>
`}}),le=new B({props:{anchor:"huggingface_hub.RepoCard.load.example",$$slots:{default:[Gn]},$$scope:{ctx:U}}}),Re=new w({props:{name:"push_to_hub",anchor:"huggingface_hub.RepoCard.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"token",val:": Optional = None"},{name:"repo_type",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"commit_description",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"create_pr",val:": Optional = None"},{name:"parent_commit",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The repo ID of the Hugging Face Hub repo to push to. Example: &#x201C;nateraw/food&#x201D;.`,name:"repo_id"},{anchor:"huggingface_hub.RepoCard.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Authentication token, obtained with <code>huggingface_hub.HfApi.login</code> method. Will default to
the stored token.`,name:"token"},{anchor:"huggingface_hub.RepoCard.push_to_hub.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;model&#x201D;) &#x2014;
The type of Hugging Face repo to push to. Options are &#x201C;model&#x201D;, &#x201C;dataset&#x201D;, and &#x201C;space&#x201D;. If this
function is called by a child class, it will default to the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"},{anchor:"huggingface_hub.RepoCard.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit.`,name:"commit_message"},{anchor:"huggingface_hub.RepoCard.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the generated commit.`,name:"commit_description"},{anchor:"huggingface_hub.RepoCard.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the <code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.RepoCard.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request with this commit. Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.RepoCard.push_to_hub.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL of the commit which updated the card metadata.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),ke=new w({props:{name:"save",anchor:"huggingface_hub.RepoCard.save",parameters:[{name:"filepath",val:": Union"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.save.filepath",description:"<strong>filepath</strong> (<code>Union[Path, str]</code>) &#x2014; Filepath to the markdown file to save.",name:"filepath"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L116"}}),re=new B({props:{anchor:"huggingface_hub.RepoCard.save.example",$$slots:{default:[Yn]},$$scope:{ctx:U}}}),Ee=new w({props:{name:"validate",anchor:"huggingface_hub.RepoCard.validate",parameters:[{name:"repo_type",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.RepoCard.validate.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;model&#x201D;) &#x2014;
The type of Hugging Face repo to push to. Options are &#x201C;model&#x201D;, &#x201C;dataset&#x201D;, and &#x201C;space&#x201D;.
If this function is called from a child class, the default will be the child class&#x2019;s <code>repo_type</code>.`,name:"repo_type"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L190"}}),ce=new An({props:{$$slots:{default:[Fn]},$$scope:{ctx:U}}}),Ne=new $({props:{title:"Card Data",local:"huggingface_hub.CardData",headingTag:"h2"}}),We=new w({props:{name:"class huggingface_hub.CardData",anchor:"huggingface_hub.CardData",parameters:[{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L164"}}),Ge=new w({props:{name:"get",anchor:"huggingface_hub.CardData.get",parameters:[{name:"key",val:": str"},{name:"default",val:": Any = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L216"}}),Ye=new w({props:{name:"pop",anchor:"huggingface_hub.CardData.pop",parameters:[{name:"key",val:": str"},{name:"default",val:": Any = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L220"}}),Fe=new w({props:{name:"to_dict",anchor:"huggingface_hub.CardData.to_dict",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L178",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>CardData represented as a dictionary ready to be dumped to a YAML
block for inclusion in a README.md file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict</code></p>
`}}),Qe=new w({props:{name:"to_yaml",anchor:"huggingface_hub.CardData.to_yaml",parameters:[{name:"line_break",val:" = None"}],parametersDescription:[{anchor:"huggingface_hub.CardData.to_yaml.line_break",description:`<strong>line_break</strong> (str, <em>optional</em>) &#x2014;
The line break to use when dumping to yaml.`,name:"line_break"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L198",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>CardData represented as a YAML block.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Se=new $({props:{title:"Model Cards",local:"model-cards",headingTag:"h2"}}),Be=new $({props:{title:"ModelCard",local:"huggingface_hub.ModelCard",headingTag:"h3"}}),Xe=new w({props:{name:"class huggingface_hub.ModelCard",anchor:"huggingface_hub.ModelCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L330"}}),Ve=new w({props:{name:"from_template",anchor:"huggingface_hub.ModelCard.from_template",parameters:[{name:"card_data",val:": ModelCardData"},{name:"template_path",val:": Optional = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.ModelCardData</code>) &#x2014;
A huggingface_hub.ModelCardData instance containing the metadata you want to include in the YAML
header of the model card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.ModelCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L335",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A ModelCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.ModelCard"
>huggingface_hub.ModelCard</a></p>
`}}),me=new B({props:{anchor:"huggingface_hub.ModelCard.from_template.example",$$slots:{default:[Qn]},$$scope:{ctx:U}}}),He=new $({props:{title:"ModelCardData",local:"huggingface_hub.ModelCardData",headingTag:"h3"}}),Le=new w({props:{name:"class huggingface_hub.ModelCardData",anchor:"huggingface_hub.ModelCardData",parameters:[{name:"language",val:": Union = None"},{name:"license",val:": Optional = None"},{name:"library_name",val:": Optional = None"},{name:"tags",val:": Optional = None"},{name:"base_model",val:": Union = None"},{name:"datasets",val:": Optional = None"},{name:"metrics",val:": Optional = None"},{name:"eval_results",val:": Optional = None"},{name:"model_name",val:": Optional = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.ModelCardData.language",description:`<strong>language</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
Language of model&#x2019;s training data or metadata. It must be an ISO 639-1, 639-2 or
639-3 code (two/three letters), or a special value like &#x201C;code&#x201D;, &#x201C;multilingual&#x201D;. Defaults to <code>None</code>.`,name:"language"},{anchor:"huggingface_hub.ModelCardData.license",description:`<strong>license</strong> (<code>str</code>, <em>optional</em>) &#x2014;
License of this model. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>. Defaults to None.`,name:"license"},{anchor:"huggingface_hub.ModelCardData.library_name",description:`<strong>library_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of library used by this model. Example: keras or any library from
<a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts</a>.
Defaults to None.`,name:"library_name"},{anchor:"huggingface_hub.ModelCardData.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to add to your model that can be used when filtering on the Hugging
Face Hub. Defaults to None.`,name:"tags"},{anchor:"huggingface_hub.ModelCardData.base_model",description:`<strong>base_model</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The identifier of the base model from which the model derives. This is applicable for example if your model is a
fine-tune or adapter of an existing model. The value must be the ID of a model on the Hub (or a list of IDs
if your model derives from multiple models). Defaults to None.`,name:"base_model"},{anchor:"huggingface_hub.ModelCardData.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets that were used to train this model. Should be a dataset ID
found on <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>. Defaults to None.`,name:"datasets"},{anchor:"huggingface_hub.ModelCardData.metrics",description:`<strong>metrics</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of metrics used to evaluate this model. Should be a metric name that can be found
at <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>. Example: &#x2018;accuracy&#x2019;. Defaults to None.`,name:"metrics"},{anchor:"huggingface_hub.ModelCardData.eval_results",description:`<strong>eval_results</strong> (<code>Union[List[EvalResult], EvalResult]</code>, <em>optional</em>) &#x2014;
List of <code>huggingface_hub.EvalResult</code> that define evaluation results of the model. If provided,
<code>model_name</code> is used to as a name on PapersWithCode&#x2019;s leaderboards. Defaults to <code>None</code>.`,name:"eval_results"},{anchor:"huggingface_hub.ModelCardData.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A name for this model. It is used along with
<code>eval_results</code> to construct the <code>model-index</code> within the card&#x2019;s metadata. The name
you supply here is what will be used on PapersWithCode&#x2019;s leaderboards. If None is provided
then the repo name is used as a default. Defaults to None.`,name:"model_name"},{anchor:"huggingface_hub.ModelCardData.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"},{anchor:"huggingface_hub.ModelCardData.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional metadata that will be added to the model card. Defaults to None.`,name:"kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L241"}}),he=new B({props:{anchor:"huggingface_hub.ModelCardData.example",$$slots:{default:[Sn]},$$scope:{ctx:U}}}),qe=new $({props:{title:"Dataset Cards",local:"dataset-cards",headingTag:"h2"}}),Oe=new $({props:{title:"DatasetCard",local:"huggingface_hub.DatasetCard",headingTag:"h3"}}),Pe=new w({props:{name:"class huggingface_hub.DatasetCard",anchor:"huggingface_hub.DatasetCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L410"}}),Ke=new w({props:{name:"from_template",anchor:"huggingface_hub.DatasetCard.from_template",parameters:[{name:"card_data",val:": DatasetCardData"},{name:"template_path",val:": Optional = None"},{name:"**template_kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetCard.from_template.card_data",description:`<strong>card_data</strong> (<code>huggingface_hub.DatasetCardData</code>) &#x2014;
A huggingface_hub.DatasetCardData instance containing the metadata you want to include in the YAML
header of the dataset card on the Hugging Face Hub.`,name:"card_data"},{anchor:"huggingface_hub.DatasetCard.from_template.template_path",description:`<strong>template_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A path to a markdown file with optional Jinja template variables that can be filled
in with <code>template_kwargs</code>. Defaults to the default template.`,name:"template_path"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L415",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A DatasetCard instance with the specified card data and content from the
template.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.21.1/en/package_reference/cards#huggingface_hub.DatasetCard"
>huggingface_hub.DatasetCard</a></p>
`}}),ue=new B({props:{anchor:"huggingface_hub.DatasetCard.from_template.example",$$slots:{default:[Bn]},$$scope:{ctx:U}}}),ea=new $({props:{title:"DatasetCardData",local:"huggingface_hub.DatasetCardData",headingTag:"h3"}}),aa=new w({props:{name:"class huggingface_hub.DatasetCardData",anchor:"huggingface_hub.DatasetCardData",parameters:[{name:"language",val:": Union = None"},{name:"license",val:": Union = None"},{name:"annotations_creators",val:": Union = None"},{name:"language_creators",val:": Union = None"},{name:"multilinguality",val:": Union = None"},{name:"size_categories",val:": Union = None"},{name:"source_datasets",val:": Optional = None"},{name:"task_categories",val:": Union = None"},{name:"task_ids",val:": Union = None"},{name:"paperswithcode_id",val:": Optional = None"},{name:"pretty_name",val:": Optional = None"},{name:"train_eval_index",val:": Optional = None"},{name:"config_names",val:": Union = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.DatasetCardData.language",description:`<strong>language</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Language of dataset&#x2019;s data or metadata. It must be an ISO 639-1, 639-2 or
639-3 code (two/three letters), or a special value like &#x201C;code&#x201D;, &#x201C;multilingual&#x201D;.`,name:"language"},{anchor:"huggingface_hub.DatasetCardData.license",description:`<strong>license</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
License(s) of this dataset. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>.`,name:"license"},{anchor:"huggingface_hub.DatasetCardData.annotations_creators",description:`<strong>annotations_creators</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
How the annotations for the dataset were created.
Options are: &#x2018;found&#x2019;, &#x2018;crowdsourced&#x2019;, &#x2018;expert-generated&#x2019;, &#x2018;machine-generated&#x2019;, &#x2018;no-annotation&#x2019;, &#x2018;other&#x2019;.`,name:"annotations_creators"},{anchor:"huggingface_hub.DatasetCardData.language_creators",description:`<strong>language_creators</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
How the text-based data in the dataset was created.
Options are: &#x2018;found&#x2019;, &#x2018;crowdsourced&#x2019;, &#x2018;expert-generated&#x2019;, &#x2018;machine-generated&#x2019;, &#x2018;other&#x2019;`,name:"language_creators"},{anchor:"huggingface_hub.DatasetCardData.multilinguality",description:`<strong>multilinguality</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
Whether the dataset is multilingual.
Options are: &#x2018;monolingual&#x2019;, &#x2018;multilingual&#x2019;, &#x2018;translation&#x2019;, &#x2018;other&#x2019;.`,name:"multilinguality"},{anchor:"huggingface_hub.DatasetCardData.size_categories",description:`<strong>size_categories</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
The number of examples in the dataset. Options are: &#x2018;n&lt;1K&#x2019;, &#x2018;1K<n<10k’, ‘10k<n<100k’, ‘100k<n<1m’, ‘1m<n<10m’, ‘10m<n<100m’, ‘100m<n<1b’, ‘1b<n<10b’, ‘10b<n<100b’, ‘100b<n<1t’, ‘n>1T&#x2019;, and &#x2018;other&#x2019;.</n<10k’,>`,name:"size_categories"},{anchor:"huggingface_hub.DatasetCardData.source_datasets",description:`<strong>source_datasets</strong> (<code>List[str]]</code>, <em>optional</em>) &#x2014;
Indicates whether the dataset is an original dataset or extended from another existing dataset.
Options are: &#x2018;original&#x2019; and &#x2018;extended&#x2019;.`,name:"source_datasets"},{anchor:"huggingface_hub.DatasetCardData.task_categories",description:`<strong>task_categories</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
What categories of task does the dataset support?`,name:"task_categories"},{anchor:"huggingface_hub.DatasetCardData.task_ids",description:`<strong>task_ids</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
What specific tasks does the dataset support?`,name:"task_ids"},{anchor:"huggingface_hub.DatasetCardData.paperswithcode_id",description:`<strong>paperswithcode_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset on PapersWithCode.`,name:"paperswithcode_id"},{anchor:"huggingface_hub.DatasetCardData.pretty_name",description:`<strong>pretty_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A more human-readable name for the dataset. (ex. &#x201C;Cats vs. Dogs&#x201D;)`,name:"pretty_name"},{anchor:"huggingface_hub.DatasetCardData.train_eval_index",description:`<strong>train_eval_index</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary that describes the necessary spec for doing evaluation on the Hub.
If not provided, it will be gathered from the &#x2018;train-eval-index&#x2019; key of the kwargs.`,name:"train_eval_index"},{anchor:"huggingface_hub.DatasetCardData.config_names",description:`<strong>config_names</strong> (<code>Union[str, List[str]]</code>, <em>optional</em>) &#x2014;
A list of the available dataset configs for the dataset.`,name:"config_names"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L353"}}),ta=new $({props:{title:"Space Cards",local:"space-cards",headingTag:"h2"}}),sa=new $({props:{title:"SpaceCard",local:"huggingface_hub.SpaceCard",headingTag:"h3"}}),la=new w({props:{name:"class huggingface_hub.SpaceCard",anchor:"huggingface_hub.SpaceCard",parameters:[{name:"content",val:": str"},{name:"ignore_metadata_errors",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L474"}}),oa=new $({props:{title:"SpaceCardData",local:"huggingface_hub.SpaceCardData",headingTag:"h3"}}),ra=new w({props:{name:"class huggingface_hub.SpaceCardData",anchor:"huggingface_hub.SpaceCardData",parameters:[{name:"title",val:": Optional = None"},{name:"sdk",val:": Optional = None"},{name:"sdk_version",val:": Optional = None"},{name:"python_version",val:": Optional = None"},{name:"app_file",val:": Optional = None"},{name:"app_port",val:": Optional = None"},{name:"license",val:": Optional = None"},{name:"duplicated_from",val:": Optional = None"},{name:"models",val:": Optional = None"},{name:"datasets",val:": Optional = None"},{name:"tags",val:": Optional = None"},{name:"ignore_metadata_errors",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.SpaceCardData.title",description:`<strong>title</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Title of the Space.`,name:"title"},{anchor:"huggingface_hub.SpaceCardData.sdk",description:`<strong>sdk</strong> (<code>str</code>, <em>optional</em>) &#x2014;
SDK of the Space (one of <code>gradio</code>, <code>streamlit</code>, <code>docker</code>, or <code>static</code>).`,name:"sdk"},{anchor:"huggingface_hub.SpaceCardData.sdk_version",description:`<strong>sdk_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Version of the used SDK (if Gradio/Streamlit sdk).`,name:"sdk_version"},{anchor:"huggingface_hub.SpaceCardData.python_version",description:`<strong>python_version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Python version used in the Space (if Gradio/Streamlit sdk).`,name:"python_version"},{anchor:"huggingface_hub.SpaceCardData.app_file",description:`<strong>app_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to your main application file (which contains either gradio or streamlit Python code, or static html code).
Path is relative to the root of the repository.`,name:"app_file"},{anchor:"huggingface_hub.SpaceCardData.app_port",description:`<strong>app_port</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Port on which your application is running. Used only if sdk is <code>docker</code>.`,name:"app_port"},{anchor:"huggingface_hub.SpaceCardData.license",description:`<strong>license</strong> (<code>str</code>, <em>optional</em>) &#x2014;
License of this model. Example: apache-2.0 or any license from
<a href="https://huggingface.co/docs/hub/repositories-licenses" rel="nofollow">https://huggingface.co/docs/hub/repositories-licenses</a>.`,name:"license"},{anchor:"huggingface_hub.SpaceCardData.duplicated_from",description:`<strong>duplicated_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the original Space if this is a duplicated Space.`,name:"duplicated_from"},{anchor:"huggingface_hub.SpaceCardData.models",description:`<strong>models</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of models related to this Space. Should be a dataset ID found on <a href="https://hf.co/models" rel="nofollow">https://hf.co/models</a>.`,name:"models"},{anchor:"huggingface_hub.SpaceCardData.datasets",description:`<strong>datasets</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of datasets related to this Space. Should be a dataset ID found on <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"datasets"},{anchor:"huggingface_hub.SpaceCardData.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to add to your Space that can be used when filtering on the Hub.`,name:"tags"},{anchor:"huggingface_hub.SpaceCardData.ignore_metadata_errors",description:`<strong>ignore_metadata_errors</strong> (<code>str</code>) &#x2014;
If True, errors while parsing the metadata section will be ignored. Some information might be lost during
the process. Use it at your own risk.`,name:"ignore_metadata_errors"},{anchor:"huggingface_hub.SpaceCardData.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional metadata that will be added to the space card.`,name:"kwargs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L433"}}),Me=new B({props:{anchor:"huggingface_hub.SpaceCardData.example",$$slots:{default:[Xn]},$$scope:{ctx:U}}}),ca=new $({props:{title:"Utilities",local:"utilities",headingTag:"h2"}}),ia=new $({props:{title:"EvalResult",local:"huggingface_hub.EvalResult",headingTag:"h3"}}),da=new w({props:{name:"class huggingface_hub.EvalResult",anchor:"huggingface_hub.EvalResult",parameters:[{name:"task_type",val:": str"},{name:"dataset_type",val:": str"},{name:"dataset_name",val:": str"},{name:"metric_type",val:": str"},{name:"metric_value",val:": Any"},{name:"task_name",val:": Optional = None"},{name:"dataset_config",val:": Optional = None"},{name:"dataset_split",val:": Optional = None"},{name:"dataset_revision",val:": Optional = None"},{name:"dataset_args",val:": Optional = None"},{name:"metric_name",val:": Optional = None"},{name:"metric_config",val:": Optional = None"},{name:"metric_args",val:": Optional = None"},{name:"verified",val:": Optional = None"},{name:"verify_token",val:": Optional = None"},{name:"source_name",val:": Optional = None"},{name:"source_url",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.EvalResult.task_type",description:`<strong>task_type</strong> (<code>str</code>) &#x2014;
The task identifier. Example: &#x201C;image-classification&#x201D;.`,name:"task_type"},{anchor:"huggingface_hub.EvalResult.dataset_type",description:`<strong>dataset_type</strong> (<code>str</code>) &#x2014;
The dataset identifier. Example: &#x201C;common_voice&#x201D;. Use dataset id from <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"dataset_type"},{anchor:"huggingface_hub.EvalResult.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>) &#x2014;
A pretty name for the dataset. Example: &#x201C;Common Voice (French)&#x201C;.`,name:"dataset_name"},{anchor:"huggingface_hub.EvalResult.metric_type",description:`<strong>metric_type</strong> (<code>str</code>) &#x2014;
The metric identifier. Example: &#x201C;wer&#x201D;. Use metric id from <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>.`,name:"metric_type"},{anchor:"huggingface_hub.EvalResult.metric_value",description:`<strong>metric_value</strong> (<code>Any</code>) &#x2014;
The metric value. Example: 0.9 or &#x201C;20.0 &#xB1; 1.2&#x201D;.`,name:"metric_value"},{anchor:"huggingface_hub.EvalResult.task_name",description:`<strong>task_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A pretty name for the task. Example: &#x201C;Speech Recognition&#x201D;.`,name:"task_name"},{anchor:"huggingface_hub.EvalResult.dataset_config",description:`<strong>dataset_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the dataset configuration used in <code>load_dataset()</code>.
Example: fr in <code>load_dataset(&quot;common_voice&quot;, &quot;fr&quot;)</code>. See the <code>datasets</code> docs for more info:
<a href="https://hf.co/docs/datasets/package_reference/loading_methods#datasets.load_dataset.name" rel="nofollow">https://hf.co/docs/datasets/package_reference/loading_methods#datasets.load_dataset.name</a>`,name:"dataset_config"},{anchor:"huggingface_hub.EvalResult.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The split used in <code>load_dataset()</code>. Example: &#x201C;test&#x201D;.`,name:"dataset_split"},{anchor:"huggingface_hub.EvalResult.dataset_revision",description:`<strong>dataset_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision (AKA Git Sha) of the dataset used in <code>load_dataset()</code>.
Example: 5503434ddd753f426f4b38109466949a1217c2bb`,name:"dataset_revision"},{anchor:"huggingface_hub.EvalResult.dataset_args",description:`<strong>dataset_args</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The arguments passed during <code>Metric.compute()</code>. Example for <code>bleu</code>: <code>{&quot;max_order&quot;: 4}</code>`,name:"dataset_args"},{anchor:"huggingface_hub.EvalResult.metric_name",description:`<strong>metric_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A pretty name for the metric. Example: &#x201C;Test WER&#x201D;.`,name:"metric_name"},{anchor:"huggingface_hub.EvalResult.metric_config",description:`<strong>metric_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the metric configuration used in <code>load_metric()</code>.
Example: bleurt-large-512 in <code>load_metric(&quot;bleurt&quot;, &quot;bleurt-large-512&quot;)</code>.
See the <code>datasets</code> docs for more info: <a href="https://huggingface.co/docs/datasets/v2.1.0/en/loading#load-configurations" rel="nofollow">https://huggingface.co/docs/datasets/v2.1.0/en/loading#load-configurations</a>`,name:"metric_config"},{anchor:"huggingface_hub.EvalResult.metric_args",description:`<strong>metric_args</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The arguments passed during <code>Metric.compute()</code>. Example for <code>bleu</code>: max_order: 4`,name:"metric_args"},{anchor:"huggingface_hub.EvalResult.verified",description:`<strong>verified</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Indicates whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not. Automatically computed by Hugging Face, do not set.`,name:"verified"},{anchor:"huggingface_hub.EvalResult.verify_token",description:`<strong>verify_token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A JSON Web Token that is used to verify whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not.`,name:"verify_token"},{anchor:"huggingface_hub.EvalResult.source_name",description:`<strong>source_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the source of the evaluation result. Example: &#x201C;Open LLM Leaderboard&#x201D;.`,name:"source_name"},{anchor:"huggingface_hub.EvalResult.source_url",description:`<strong>source_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the source of the evaluation result. Example: &#x201D;<a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard%22" rel="nofollow">https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard&#x201D;</a>.`,name:"source_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L12"}}),pa=new w({props:{name:"is_equal_except_value",anchor:"huggingface_hub.EvalResult.is_equal_except_value",parameters:[{name:"other",val:": EvalResult"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L145"}}),ga=new $({props:{title:"model_index_to_eval_results",local:"huggingface_hub.repocard_data.model_index_to_eval_results",headingTag:"h3"}}),ma=new w({props:{name:"huggingface_hub.repocard_data.model_index_to_eval_results",anchor:"huggingface_hub.repocard_data.model_index_to_eval_results",parameters:[{name:"model_index",val:": List"}],parametersDescription:[{anchor:"huggingface_hub.repocard_data.model_index_to_eval_results.model_index",description:`<strong>model_index</strong> (<code>List[Dict[str, Any]]</code>) &#x2014;
A model index data structure, likely coming from a README.md file on the
Hugging Face Hub.`,name:"model_index"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L514",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The name of the model as found in the model index. This is used as the
identifier for the model on leaderboards like PapersWithCode.
eval_results (<code>List[EvalResult]</code>):
A list of <code>huggingface_hub.EvalResult</code> objects containing the metrics
reported in the provided model_index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>model_name (<code>str</code>)</p>
`}}),_e=new B({props:{anchor:"huggingface_hub.repocard_data.model_index_to_eval_results.example",$$slots:{default:[Vn]},$$scope:{ctx:U}}}),ha=new $({props:{title:"eval_results_to_model_index",local:"huggingface_hub.repocard_data.eval_results_to_model_index",headingTag:"h3"}}),ua=new w({props:{name:"huggingface_hub.repocard_data.eval_results_to_model_index",anchor:"huggingface_hub.repocard_data.eval_results_to_model_index",parameters:[{name:"model_name",val:": str"},{name:"eval_results",val:": List"}],parametersDescription:[{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.model_name",description:`<strong>model_name</strong> (<code>str</code>) &#x2014;
Name of the model (ex. &#x201C;my-cool-model&#x201D;). This is used as the identifier
for the model on leaderboards like PapersWithCode.`,name:"model_name"},{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.eval_results",description:`<strong>eval_results</strong> (<code>List[EvalResult]</code>) &#x2014;
List of <code>huggingface_hub.EvalResult</code> objects containing the metrics to be
reported in the model-index.`,name:"eval_results"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard_data.py#L630",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The eval_results converted to a model-index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>model_index (<code>List[Dict[str, Any]]</code>)</p>
`}}),je=new B({props:{anchor:"huggingface_hub.repocard_data.eval_results_to_model_index.example",$$slots:{default:[Hn]},$$scope:{ctx:U}}}),Ma=new $({props:{title:"metadata_eval_result",local:"huggingface_hub.metadata_eval_result",headingTag:"h3"}}),fa=new w({props:{name:"huggingface_hub.metadata_eval_result",anchor:"huggingface_hub.metadata_eval_result",parameters:[{name:"model_pretty_name",val:": str"},{name:"task_pretty_name",val:": str"},{name:"task_id",val:": str"},{name:"metrics_pretty_name",val:": str"},{name:"metrics_id",val:": str"},{name:"metrics_value",val:": Any"},{name:"dataset_pretty_name",val:": str"},{name:"dataset_id",val:": str"},{name:"metrics_config",val:": Optional = None"},{name:"metrics_verified",val:": bool = False"},{name:"dataset_config",val:": Optional = None"},{name:"dataset_split",val:": Optional = None"},{name:"dataset_revision",val:": Optional = None"},{name:"metrics_verification_token",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.metadata_eval_result.model_pretty_name",description:`<strong>model_pretty_name</strong> (<code>str</code>) &#x2014;
The name of the model in natural language.`,name:"model_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.task_pretty_name",description:`<strong>task_pretty_name</strong> (<code>str</code>) &#x2014;
The name of a task in natural language.`,name:"task_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.task_id",description:`<strong>task_id</strong> (<code>str</code>) &#x2014;
Example: automatic-speech-recognition. A task id.`,name:"task_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_pretty_name",description:`<strong>metrics_pretty_name</strong> (<code>str</code>) &#x2014;
A name for the metric in natural language. Example: Test WER.`,name:"metrics_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.metrics_id",description:`<strong>metrics_id</strong> (<code>str</code>) &#x2014;
Example: wer. A metric id from <a href="https://hf.co/metrics" rel="nofollow">https://hf.co/metrics</a>.`,name:"metrics_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_value",description:`<strong>metrics_value</strong> (<code>Any</code>) &#x2014;
The value from the metric. Example: 20.0 or &#x201C;20.0 &#xB1; 1.2&#x201D;.`,name:"metrics_value"},{anchor:"huggingface_hub.metadata_eval_result.dataset_pretty_name",description:`<strong>dataset_pretty_name</strong> (<code>str</code>) &#x2014;
The name of the dataset in natural language.`,name:"dataset_pretty_name"},{anchor:"huggingface_hub.metadata_eval_result.dataset_id",description:`<strong>dataset_id</strong> (<code>str</code>) &#x2014;
Example: common_voice. A dataset id from <a href="https://hf.co/datasets" rel="nofollow">https://hf.co/datasets</a>.`,name:"dataset_id"},{anchor:"huggingface_hub.metadata_eval_result.metrics_config",description:`<strong>metrics_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the metric configuration used in <code>load_metric()</code>.
Example: bleurt-large-512 in <code>load_metric(&quot;bleurt&quot;, &quot;bleurt-large-512&quot;)</code>.`,name:"metrics_config"},{anchor:"huggingface_hub.metadata_eval_result.metrics_verified",description:`<strong>metrics_verified</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Indicates whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not. Automatically computed by Hugging Face, do not set.`,name:"metrics_verified"},{anchor:"huggingface_hub.metadata_eval_result.dataset_config",description:`<strong>dataset_config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: fr. The name of the dataset configuration used in <code>load_dataset()</code>.`,name:"dataset_config"},{anchor:"huggingface_hub.metadata_eval_result.dataset_split",description:`<strong>dataset_split</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: test. The name of the dataset split used in <code>load_dataset()</code>.`,name:"dataset_split"},{anchor:"huggingface_hub.metadata_eval_result.dataset_revision",description:`<strong>dataset_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Example: 5503434ddd753f426f4b38109466949a1217c2bb. The name of the dataset dataset revision
used in <code>load_dataset()</code>.`,name:"dataset_revision"},{anchor:"huggingface_hub.metadata_eval_result.metrics_verification_token",description:`<strong>metrics_verification_token</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
A JSON Web Token that is used to verify whether the metrics originate from Hugging Face&#x2019;s <a href="https://huggingface.co/spaces/autoevaluate/model-evaluator" rel="nofollow">evaluation service</a> or not.`,name:"metrics_verification_token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L546",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a metadata dict with the result from a model evaluated on a dataset.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict</code></p>
`}}),ye=new B({props:{anchor:"huggingface_hub.metadata_eval_result.example",$$slots:{default:[Ln]},$$scope:{ctx:U}}}),_a=new $({props:{title:"metadata_update",local:"huggingface_hub.metadata_update",headingTag:"h3"}}),ja=new w({props:{name:"huggingface_hub.metadata_update",anchor:"huggingface_hub.metadata_update",parameters:[{name:"repo_id",val:": str"},{name:"metadata",val:": Dict"},{name:"repo_type",val:": Optional = None"},{name:"overwrite",val:": bool = False"},{name:"token",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"commit_description",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"parent_commit",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.metadata_update.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository.`,name:"repo_id"},{anchor:"huggingface_hub.metadata_update.metadata",description:`<strong>metadata</strong> (<code>dict</code>) &#x2014;
A dictionary containing the metadata to be updated.`,name:"metadata"},{anchor:"huggingface_hub.metadata_update.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Set to <code>&quot;dataset&quot;</code> or <code>&quot;space&quot;</code> if updating to a dataset or space,
<code>None</code> or <code>&quot;model&quot;</code> if updating to a model. Default is <code>None</code>.`,name:"repo_type"},{anchor:"huggingface_hub.metadata_update.overwrite",description:`<strong>overwrite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code> an existing field can be overwritten, otherwise
attempting to overwrite an existing field will cause an error.`,name:"overwrite"},{anchor:"huggingface_hub.metadata_update.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The Hugging Face authentication token.`,name:"token"},{anchor:"huggingface_hub.metadata_update.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The summary / title / first line of the generated commit. Defaults to
<code>f&quot;Update metadata with huggingface_hub&quot;</code>`,name:"commit_message"},{anchor:"huggingface_hub.metadata_update.commit_description",description:`<strong>commit_description</strong> (<code>str</code> <em>optional</em>) &#x2014;
The description of the generated commit`,name:"commit_description"},{anchor:"huggingface_hub.metadata_update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to commit from. Defaults to the head of the
<code>&quot;main&quot;</code> branch.`,name:"revision"},{anchor:"huggingface_hub.metadata_update.create_pr",description:`<strong>create_pr</strong> (<code>boolean</code>, <em>optional</em>) &#x2014;
Whether or not to create a Pull Request from <code>revision</code> with that commit.
Defaults to <code>False</code>.`,name:"create_pr"},{anchor:"huggingface_hub.metadata_update.parent_commit",description:`<strong>parent_commit</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The OID / SHA of the parent commit, as a hexadecimal string. Shorthands (7 first characters) are also supported.
If specified and <code>create_pr</code> is <code>False</code>, the commit will fail if <code>revision</code> does not point to <code>parent_commit</code>.
If specified and <code>create_pr</code> is <code>True</code>, the pull request will be created from <code>parent_commit</code>.
Specifying <code>parent_commit</code> ensures the repo has not changed before committing the changes, and can be
especially useful if the repo is updated / committed to concurrently.`,name:"parent_commit"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.21.1/src/huggingface_hub/repocard.py#L674",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>URL of the commit which updated the card metadata.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),be=new B({props:{anchor:"huggingface_hub.metadata_update.example",$$slots:{default:[qn]},$$scope:{ctx:U}}}),{c(){n=d("meta"),y=o(),j=d("p"),s=o(),m(g.$$.fragment),a=o(),b=d("p"),b.innerHTML=Hs,rt=o(),m(Te.$$.fragment),ct=o(),ve=d("p"),ve.innerHTML=Ls,it=o(),v=d("div"),m(Ae.$$.fragment),Xt=o(),N=d("div"),m($e.$$.fragment),Vt=o(),wa=d("p"),wa.textContent=qs,Ht=o(),m(se.$$.fragment),Lt=o(),m(ne.$$.fragment),qt=o(),V=d("div"),m(Ie.$$.fragment),zt=o(),Ta=d("p"),Ta.textContent=zs,Ot=o(),va=d("p"),va.textContent=Os,Pt=o(),H=d("div"),m(De.$$.fragment),Kt=o(),Aa=d("p"),Aa.textContent=Ps,es=o(),m(le.$$.fragment),as=o(),oe=d("div"),m(Re.$$.fragment),ts=o(),$a=d("p"),$a.textContent=Ks,ss=o(),L=d("div"),m(ke.$$.fragment),ns=o(),Ia=d("p"),Ia.textContent=en,ls=o(),m(re.$$.fragment),os=o(),q=d("div"),m(Ee.$$.fragment),rs=o(),Da=d("p"),Da.innerHTML=an,cs=o(),m(ce.$$.fragment),dt=o(),m(Ne.$$.fragment),pt=o(),Ze=d("p"),Ze.innerHTML=tn,gt=o(),T=d("div"),m(We.$$.fragment),is=o(),Ra=d("p"),Ra.textContent=sn,ds=o(),ka=d("p"),ka.innerHTML=nn,ps=o(),Ea=d("p"),Ea.innerHTML=ln,gs=o(),ie=d("div"),m(Ge.$$.fragment),ms=o(),Na=d("p"),Na.textContent=on,hs=o(),de=d("div"),m(Ye.$$.fragment),us=o(),Za=d("p"),Za.textContent=rn,Ms=o(),pe=d("div"),m(Fe.$$.fragment),fs=o(),Wa=d("p"),Wa.textContent=cn,_s=o(),ge=d("div"),m(Qe.$$.fragment),js=o(),Ga=d("p"),Ga.textContent=dn,mt=o(),m(Se.$$.fragment),ht=o(),m(Be.$$.fragment),ut=o(),z=d("div"),m(Xe.$$.fragment),ys=o(),Z=d("div"),m(Ve.$$.fragment),bs=o(),Ya=d("p"),Ya.innerHTML=pn,Cs=o(),Fa=d("p"),Fa.textContent=gn,Us=o(),m(me.$$.fragment),Mt=o(),m(He.$$.fragment),ft=o(),G=d("div"),m(Le.$$.fragment),xs=o(),Qa=d("p"),Qa.textContent=mn,Js=o(),m(he.$$.fragment),_t=o(),m(qe.$$.fragment),jt=o(),ze=d("p"),ze.textContent=hn,yt=o(),m(Oe.$$.fragment),bt=o(),O=d("div"),m(Pe.$$.fragment),ws=o(),W=d("div"),m(Ke.$$.fragment),Ts=o(),Sa=d("p"),Sa.innerHTML=un,vs=o(),Ba=d("p"),Ba.textContent=Mn,As=o(),m(ue.$$.fragment),Ct=o(),m(ea.$$.fragment),Ut=o(),P=d("div"),m(aa.$$.fragment),$s=o(),Xa=d("p"),Xa.textContent=fn,xt=o(),m(ta.$$.fragment),Jt=o(),m(sa.$$.fragment),wt=o(),na=d("div"),m(la.$$.fragment),Tt=o(),m(oa.$$.fragment),vt=o(),D=d("div"),m(ra.$$.fragment),Is=o(),Va=d("p"),Va.textContent=_n,Ds=o(),Ha=d("p"),Ha.innerHTML=jn,Rs=o(),m(Me.$$.fragment),At=o(),m(ca.$$.fragment),$t=o(),m(ia.$$.fragment),It=o(),R=d("div"),m(da.$$.fragment),ks=o(),La=d("p"),La.textContent=yn,Es=o(),qa=d("p"),qa.innerHTML=bn,Ns=o(),fe=d("div"),m(pa.$$.fragment),Zs=o(),za=d("p"),za.innerHTML=Cn,Dt=o(),m(ga.$$.fragment),Rt=o(),k=d("div"),m(ma.$$.fragment),Ws=o(),Oa=d("p"),Oa.innerHTML=Un,Gs=o(),Pa=d("p"),Pa.innerHTML=xn,Ys=o(),m(_e.$$.fragment),kt=o(),m(ha.$$.fragment),Et=o(),Y=d("div"),m(ua.$$.fragment),Fs=o(),Ka=d("p"),Ka.innerHTML=Jn,Qs=o(),m(je.$$.fragment),Nt=o(),m(Ma.$$.fragment),Zt=o(),F=d("div"),m(fa.$$.fragment),Ss=o(),et=d("p"),et.textContent=wn,Bs=o(),m(ye.$$.fragment),Wt=o(),m(_a.$$.fragment),Gt=o(),Q=d("div"),m(ja.$$.fragment),Xs=o(),at=d("p"),at.innerHTML=Tn,Vs=o(),m(be.$$.fragment),Yt=o(),ot=d("p"),this.h()},l(e){const l=Nn("svelte-u9bgzb",document.head);n=p(l,"META",{name:!0,content:!0}),l.forEach(t),y=r(e),j=p(e,"P",{}),x(j).forEach(t),s=r(e),h(g.$$.fragment,e),a=r(e),b=p(e,"P",{"data-svelte-h":!0}),C(b)!=="svelte-1iyhjbm"&&(b.innerHTML=Hs),rt=r(e),h(Te.$$.fragment,e),ct=r(e),ve=p(e,"P",{"data-svelte-h":!0}),C(ve)!=="svelte-1av45fz"&&(ve.innerHTML=Ls),it=r(e),v=p(e,"DIV",{class:!0});var I=x(v);h(Ae.$$.fragment,I),Xt=r(I),N=p(I,"DIV",{class:!0});var S=x(N);h($e.$$.fragment,S),Vt=r(S),wa=p(S,"P",{"data-svelte-h":!0}),C(wa)!=="svelte-161avre"&&(wa.textContent=qs),Ht=r(S),h(se.$$.fragment,S),Lt=r(S),h(ne.$$.fragment,S),S.forEach(t),qt=r(I),V=p(I,"DIV",{class:!0});var K=x(V);h(Ie.$$.fragment,K),zt=r(K),Ta=p(K,"P",{"data-svelte-h":!0}),C(Ta)!=="svelte-18ags6f"&&(Ta.textContent=zs),Ot=r(K),va=p(K,"P",{"data-svelte-h":!0}),C(va)!=="svelte-1lmhx0i"&&(va.textContent=Os),K.forEach(t),Pt=r(I),H=p(I,"DIV",{class:!0});var ee=x(H);h(De.$$.fragment,ee),Kt=r(ee),Aa=p(ee,"P",{"data-svelte-h":!0}),C(Aa)!=="svelte-b3pfo4"&&(Aa.textContent=Ps),es=r(ee),h(le.$$.fragment,ee),ee.forEach(t),as=r(I),oe=p(I,"DIV",{class:!0});var ya=x(oe);h(Re.$$.fragment,ya),ts=r(ya),$a=p(ya,"P",{"data-svelte-h":!0}),C($a)!=="svelte-13tv3j4"&&($a.textContent=Ks),ya.forEach(t),ss=r(I),L=p(I,"DIV",{class:!0});var ae=x(L);h(ke.$$.fragment,ae),ns=r(ae),Ia=p(ae,"P",{"data-svelte-h":!0}),C(Ia)!=="svelte-9cwft2"&&(Ia.textContent=en),ls=r(ae),h(re.$$.fragment,ae),ae.forEach(t),os=r(I),q=p(I,"DIV",{class:!0});var te=x(q);h(Ee.$$.fragment,te),rs=r(te),Da=p(te,"P",{"data-svelte-h":!0}),C(Da)!=="svelte-19j6q3w"&&(Da.innerHTML=an),cs=r(te),h(ce.$$.fragment,te),te.forEach(t),I.forEach(t),dt=r(e),h(Ne.$$.fragment,e),pt=r(e),Ze=p(e,"P",{"data-svelte-h":!0}),C(Ze)!=="svelte-a84b7y"&&(Ze.innerHTML=tn),gt=r(e),T=p(e,"DIV",{class:!0});var A=x(T);h(We.$$.fragment,A),is=r(A),Ra=p(A,"P",{"data-svelte-h":!0}),C(Ra)!=="svelte-11gq3a9"&&(Ra.textContent=sn),ds=r(A),ka=p(A,"P",{"data-svelte-h":!0}),C(ka)!=="svelte-1h6o3eu"&&(ka.innerHTML=nn),ps=r(A),Ea=p(A,"P",{"data-svelte-h":!0}),C(Ea)!=="svelte-3994xf"&&(Ea.innerHTML=ln),gs=r(A),ie=p(A,"DIV",{class:!0});var ba=x(ie);h(Ge.$$.fragment,ba),ms=r(ba),Na=p(ba,"P",{"data-svelte-h":!0}),C(Na)!=="svelte-1vt5g5k"&&(Na.textContent=on),ba.forEach(t),hs=r(A),de=p(A,"DIV",{class:!0});var Ca=x(de);h(Ye.$$.fragment,Ca),us=r(Ca),Za=p(Ca,"P",{"data-svelte-h":!0}),C(Za)!=="svelte-1tl2a7n"&&(Za.textContent=rn),Ca.forEach(t),Ms=r(A),pe=p(A,"DIV",{class:!0});var Ua=x(pe);h(Fe.$$.fragment,Ua),fs=r(Ua),Wa=p(Ua,"P",{"data-svelte-h":!0}),C(Wa)!=="svelte-1s2hgf6"&&(Wa.textContent=cn),Ua.forEach(t),_s=r(A),ge=p(A,"DIV",{class:!0});var xa=x(ge);h(Qe.$$.fragment,xa),js=r(xa),Ga=p(xa,"P",{"data-svelte-h":!0}),C(Ga)!=="svelte-1wsmx9v"&&(Ga.textContent=dn),xa.forEach(t),A.forEach(t),mt=r(e),h(Se.$$.fragment,e),ht=r(e),h(Be.$$.fragment,e),ut=r(e),z=p(e,"DIV",{class:!0});var Ja=x(z);h(Xe.$$.fragment,Ja),ys=r(Ja),Z=p(Ja,"DIV",{class:!0});var Ce=x(Z);h(Ve.$$.fragment,Ce),bs=r(Ce),Ya=p(Ce,"P",{"data-svelte-h":!0}),C(Ya)!=="svelte-1eear21"&&(Ya.innerHTML=pn),Cs=r(Ce),Fa=p(Ce,"P",{"data-svelte-h":!0}),C(Fa)!=="svelte-1lmhx0i"&&(Fa.textContent=gn),Us=r(Ce),h(me.$$.fragment,Ce),Ce.forEach(t),Ja.forEach(t),Mt=r(e),h(He.$$.fragment,e),ft=r(e),G=p(e,"DIV",{class:!0});var tt=x(G);h(Le.$$.fragment,tt),xs=r(tt),Qa=p(tt,"P",{"data-svelte-h":!0}),C(Qa)!=="svelte-rhbg82"&&(Qa.textContent=mn),Js=r(tt),h(he.$$.fragment,tt),tt.forEach(t),_t=r(e),h(qe.$$.fragment,e),jt=r(e),ze=p(e,"P",{"data-svelte-h":!0}),C(ze)!=="svelte-1vz0b8q"&&(ze.textContent=hn),yt=r(e),h(Oe.$$.fragment,e),bt=r(e),O=p(e,"DIV",{class:!0});var Qt=x(O);h(Pe.$$.fragment,Qt),ws=r(Qt),W=p(Qt,"DIV",{class:!0});var Ue=x(W);h(Ke.$$.fragment,Ue),Ts=r(Ue),Sa=p(Ue,"P",{"data-svelte-h":!0}),C(Sa)!=="svelte-1stjz9i"&&(Sa.innerHTML=un),vs=r(Ue),Ba=p(Ue,"P",{"data-svelte-h":!0}),C(Ba)!=="svelte-1lmhx0i"&&(Ba.textContent=Mn),As=r(Ue),h(ue.$$.fragment,Ue),Ue.forEach(t),Qt.forEach(t),Ct=r(e),h(ea.$$.fragment,e),Ut=r(e),P=p(e,"DIV",{class:!0});var St=x(P);h(aa.$$.fragment,St),$s=r(St),Xa=p(St,"P",{"data-svelte-h":!0}),C(Xa)!=="svelte-q1o4e7"&&(Xa.textContent=fn),St.forEach(t),xt=r(e),h(ta.$$.fragment,e),Jt=r(e),h(sa.$$.fragment,e),wt=r(e),na=p(e,"DIV",{class:!0});var vn=x(na);h(la.$$.fragment,vn),vn.forEach(t),Tt=r(e),h(oa.$$.fragment,e),vt=r(e),D=p(e,"DIV",{class:!0});var xe=x(D);h(ra.$$.fragment,xe),Is=r(xe),Va=p(xe,"P",{"data-svelte-h":!0}),C(Va)!=="svelte-1j9hyb1"&&(Va.textContent=_n),Ds=r(xe),Ha=p(xe,"P",{"data-svelte-h":!0}),C(Ha)!=="svelte-sg51el"&&(Ha.innerHTML=jn),Rs=r(xe),h(Me.$$.fragment,xe),xe.forEach(t),At=r(e),h(ca.$$.fragment,e),$t=r(e),h(ia.$$.fragment,e),It=r(e),R=p(e,"DIV",{class:!0});var Je=x(R);h(da.$$.fragment,Je),ks=r(Je),La=p(Je,"P",{"data-svelte-h":!0}),C(La)!=="svelte-1tnxdck"&&(La.textContent=yn),Es=r(Je),qa=p(Je,"P",{"data-svelte-h":!0}),C(qa)!=="svelte-1en2oav"&&(qa.innerHTML=bn),Ns=r(Je),fe=p(Je,"DIV",{class:!0});var Bt=x(fe);h(pa.$$.fragment,Bt),Zs=r(Bt),za=p(Bt,"P",{"data-svelte-h":!0}),C(za)!=="svelte-6pr4vq"&&(za.innerHTML=Cn),Bt.forEach(t),Je.forEach(t),Dt=r(e),h(ga.$$.fragment,e),Rt=r(e),k=p(e,"DIV",{class:!0});var we=x(k);h(ma.$$.fragment,we),Ws=r(we),Oa=p(we,"P",{"data-svelte-h":!0}),C(Oa)!=="svelte-18o9q21"&&(Oa.innerHTML=Un),Gs=r(we),Pa=p(we,"P",{"data-svelte-h":!0}),C(Pa)!=="svelte-1nu88lf"&&(Pa.innerHTML=xn),Ys=r(we),h(_e.$$.fragment,we),we.forEach(t),kt=r(e),h(ha.$$.fragment,e),Et=r(e),Y=p(e,"DIV",{class:!0});var st=x(Y);h(ua.$$.fragment,st),Fs=r(st),Ka=p(st,"P",{"data-svelte-h":!0}),C(Ka)!=="svelte-oll614"&&(Ka.innerHTML=Jn),Qs=r(st),h(je.$$.fragment,st),st.forEach(t),Nt=r(e),h(Ma.$$.fragment,e),Zt=r(e),F=p(e,"DIV",{class:!0});var nt=x(F);h(fa.$$.fragment,nt),Ss=r(nt),et=p(nt,"P",{"data-svelte-h":!0}),C(et)!=="svelte-67svdo"&&(et.textContent=wn),Bs=r(nt),h(ye.$$.fragment,nt),nt.forEach(t),Wt=r(e),h(_a.$$.fragment,e),Gt=r(e),Q=p(e,"DIV",{class:!0});var lt=x(Q);h(ja.$$.fragment,lt),Xs=r(lt),at=p(lt,"P",{"data-svelte-h":!0}),C(at)!=="svelte-1v61xs3"&&(at.innerHTML=Tn),Vs=r(lt),h(be.$$.fragment,lt),lt.forEach(t),Yt=r(e),ot=p(e,"P",{}),x(ot).forEach(t),this.h()},h(){J(n,"name","hf:doc:metadata"),J(n,"content",On),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(na,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){c(document.head,n),i(e,y,l),i(e,j,l),i(e,s,l),u(g,e,l),i(e,a,l),i(e,b,l),i(e,rt,l),u(Te,e,l),i(e,ct,l),i(e,ve,l),i(e,it,l),i(e,v,l),u(Ae,v,null),c(v,Xt),c(v,N),u($e,N,null),c(N,Vt),c(N,wa),c(N,Ht),u(se,N,null),c(N,Lt),u(ne,N,null),c(v,qt),c(v,V),u(Ie,V,null),c(V,zt),c(V,Ta),c(V,Ot),c(V,va),c(v,Pt),c(v,H),u(De,H,null),c(H,Kt),c(H,Aa),c(H,es),u(le,H,null),c(v,as),c(v,oe),u(Re,oe,null),c(oe,ts),c(oe,$a),c(v,ss),c(v,L),u(ke,L,null),c(L,ns),c(L,Ia),c(L,ls),u(re,L,null),c(v,os),c(v,q),u(Ee,q,null),c(q,rs),c(q,Da),c(q,cs),u(ce,q,null),i(e,dt,l),u(Ne,e,l),i(e,pt,l),i(e,Ze,l),i(e,gt,l),i(e,T,l),u(We,T,null),c(T,is),c(T,Ra),c(T,ds),c(T,ka),c(T,ps),c(T,Ea),c(T,gs),c(T,ie),u(Ge,ie,null),c(ie,ms),c(ie,Na),c(T,hs),c(T,de),u(Ye,de,null),c(de,us),c(de,Za),c(T,Ms),c(T,pe),u(Fe,pe,null),c(pe,fs),c(pe,Wa),c(T,_s),c(T,ge),u(Qe,ge,null),c(ge,js),c(ge,Ga),i(e,mt,l),u(Se,e,l),i(e,ht,l),u(Be,e,l),i(e,ut,l),i(e,z,l),u(Xe,z,null),c(z,ys),c(z,Z),u(Ve,Z,null),c(Z,bs),c(Z,Ya),c(Z,Cs),c(Z,Fa),c(Z,Us),u(me,Z,null),i(e,Mt,l),u(He,e,l),i(e,ft,l),i(e,G,l),u(Le,G,null),c(G,xs),c(G,Qa),c(G,Js),u(he,G,null),i(e,_t,l),u(qe,e,l),i(e,jt,l),i(e,ze,l),i(e,yt,l),u(Oe,e,l),i(e,bt,l),i(e,O,l),u(Pe,O,null),c(O,ws),c(O,W),u(Ke,W,null),c(W,Ts),c(W,Sa),c(W,vs),c(W,Ba),c(W,As),u(ue,W,null),i(e,Ct,l),u(ea,e,l),i(e,Ut,l),i(e,P,l),u(aa,P,null),c(P,$s),c(P,Xa),i(e,xt,l),u(ta,e,l),i(e,Jt,l),u(sa,e,l),i(e,wt,l),i(e,na,l),u(la,na,null),i(e,Tt,l),u(oa,e,l),i(e,vt,l),i(e,D,l),u(ra,D,null),c(D,Is),c(D,Va),c(D,Ds),c(D,Ha),c(D,Rs),u(Me,D,null),i(e,At,l),u(ca,e,l),i(e,$t,l),u(ia,e,l),i(e,It,l),i(e,R,l),u(da,R,null),c(R,ks),c(R,La),c(R,Es),c(R,qa),c(R,Ns),c(R,fe),u(pa,fe,null),c(fe,Zs),c(fe,za),i(e,Dt,l),u(ga,e,l),i(e,Rt,l),i(e,k,l),u(ma,k,null),c(k,Ws),c(k,Oa),c(k,Gs),c(k,Pa),c(k,Ys),u(_e,k,null),i(e,kt,l),u(ha,e,l),i(e,Et,l),i(e,Y,l),u(ua,Y,null),c(Y,Fs),c(Y,Ka),c(Y,Qs),u(je,Y,null),i(e,Nt,l),u(Ma,e,l),i(e,Zt,l),i(e,F,l),u(fa,F,null),c(F,Ss),c(F,et),c(F,Bs),u(ye,F,null),i(e,Wt,l),u(_a,e,l),i(e,Gt,l),i(e,Q,l),u(ja,Q,null),c(Q,Xs),c(Q,at),c(Q,Vs),u(be,Q,null),i(e,Yt,l),i(e,ot,l),Ft=!0},p(e,[l]){const I={};l&2&&(I.$$scope={dirty:l,ctx:e}),se.$set(I);const S={};l&2&&(S.$$scope={dirty:l,ctx:e}),ne.$set(S);const K={};l&2&&(K.$$scope={dirty:l,ctx:e}),le.$set(K);const ee={};l&2&&(ee.$$scope={dirty:l,ctx:e}),re.$set(ee);const ya={};l&2&&(ya.$$scope={dirty:l,ctx:e}),ce.$set(ya);const ae={};l&2&&(ae.$$scope={dirty:l,ctx:e}),me.$set(ae);const te={};l&2&&(te.$$scope={dirty:l,ctx:e}),he.$set(te);const A={};l&2&&(A.$$scope={dirty:l,ctx:e}),ue.$set(A);const ba={};l&2&&(ba.$$scope={dirty:l,ctx:e}),Me.$set(ba);const Ca={};l&2&&(Ca.$$scope={dirty:l,ctx:e}),_e.$set(Ca);const Ua={};l&2&&(Ua.$$scope={dirty:l,ctx:e}),je.$set(Ua);const xa={};l&2&&(xa.$$scope={dirty:l,ctx:e}),ye.$set(xa);const Ja={};l&2&&(Ja.$$scope={dirty:l,ctx:e}),be.$set(Ja)},i(e){Ft||(M(g.$$.fragment,e),M(Te.$$.fragment,e),M(Ae.$$.fragment,e),M($e.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(Ie.$$.fragment,e),M(De.$$.fragment,e),M(le.$$.fragment,e),M(Re.$$.fragment,e),M(ke.$$.fragment,e),M(re.$$.fragment,e),M(Ee.$$.fragment,e),M(ce.$$.fragment,e),M(Ne.$$.fragment,e),M(We.$$.fragment,e),M(Ge.$$.fragment,e),M(Ye.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(Se.$$.fragment,e),M(Be.$$.fragment,e),M(Xe.$$.fragment,e),M(Ve.$$.fragment,e),M(me.$$.fragment,e),M(He.$$.fragment,e),M(Le.$$.fragment,e),M(he.$$.fragment,e),M(qe.$$.fragment,e),M(Oe.$$.fragment,e),M(Pe.$$.fragment,e),M(Ke.$$.fragment,e),M(ue.$$.fragment,e),M(ea.$$.fragment,e),M(aa.$$.fragment,e),M(ta.$$.fragment,e),M(sa.$$.fragment,e),M(la.$$.fragment,e),M(oa.$$.fragment,e),M(ra.$$.fragment,e),M(Me.$$.fragment,e),M(ca.$$.fragment,e),M(ia.$$.fragment,e),M(da.$$.fragment,e),M(pa.$$.fragment,e),M(ga.$$.fragment,e),M(ma.$$.fragment,e),M(_e.$$.fragment,e),M(ha.$$.fragment,e),M(ua.$$.fragment,e),M(je.$$.fragment,e),M(Ma.$$.fragment,e),M(fa.$$.fragment,e),M(ye.$$.fragment,e),M(_a.$$.fragment,e),M(ja.$$.fragment,e),M(be.$$.fragment,e),Ft=!0)},o(e){f(g.$$.fragment,e),f(Te.$$.fragment,e),f(Ae.$$.fragment,e),f($e.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(Ie.$$.fragment,e),f(De.$$.fragment,e),f(le.$$.fragment,e),f(Re.$$.fragment,e),f(ke.$$.fragment,e),f(re.$$.fragment,e),f(Ee.$$.fragment,e),f(ce.$$.fragment,e),f(Ne.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ye.$$.fragment,e),f(Fe.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Be.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(me.$$.fragment,e),f(He.$$.fragment,e),f(Le.$$.fragment,e),f(he.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Pe.$$.fragment,e),f(Ke.$$.fragment,e),f(ue.$$.fragment,e),f(ea.$$.fragment,e),f(aa.$$.fragment,e),f(ta.$$.fragment,e),f(sa.$$.fragment,e),f(la.$$.fragment,e),f(oa.$$.fragment,e),f(ra.$$.fragment,e),f(Me.$$.fragment,e),f(ca.$$.fragment,e),f(ia.$$.fragment,e),f(da.$$.fragment,e),f(pa.$$.fragment,e),f(ga.$$.fragment,e),f(ma.$$.fragment,e),f(_e.$$.fragment,e),f(ha.$$.fragment,e),f(ua.$$.fragment,e),f(je.$$.fragment,e),f(Ma.$$.fragment,e),f(fa.$$.fragment,e),f(ye.$$.fragment,e),f(_a.$$.fragment,e),f(ja.$$.fragment,e),f(be.$$.fragment,e),Ft=!1},d(e){e&&(t(y),t(j),t(s),t(a),t(b),t(rt),t(ct),t(ve),t(it),t(v),t(dt),t(pt),t(Ze),t(gt),t(T),t(mt),t(ht),t(ut),t(z),t(Mt),t(ft),t(G),t(_t),t(jt),t(ze),t(yt),t(bt),t(O),t(Ct),t(Ut),t(P),t(xt),t(Jt),t(wt),t(na),t(Tt),t(vt),t(D),t(At),t($t),t(It),t(R),t(Dt),t(Rt),t(k),t(kt),t(Et),t(Y),t(Nt),t(Zt),t(F),t(Wt),t(Gt),t(Q),t(Yt),t(ot)),t(n),_(g,e),_(Te,e),_(Ae),_($e),_(se),_(ne),_(Ie),_(De),_(le),_(Re),_(ke),_(re),_(Ee),_(ce),_(Ne,e),_(We),_(Ge),_(Ye),_(Fe),_(Qe),_(Se,e),_(Be,e),_(Xe),_(Ve),_(me),_(He,e),_(Le),_(he),_(qe,e),_(Oe,e),_(Pe),_(Ke),_(ue),_(ea,e),_(aa),_(ta,e),_(sa,e),_(la),_(oa,e),_(ra),_(Me),_(ca,e),_(ia,e),_(da),_(pa),_(ga,e),_(ma),_(_e),_(ha,e),_(ua),_(je),_(Ma,e),_(fa),_(ye),_(_a,e),_(ja),_(be)}}}const On='{"title":"Repository Cards","local":"repository-cards","sections":[{"title":"Repo Card","local":"huggingface_hub.RepoCard","sections":[],"depth":2},{"title":"Card Data","local":"huggingface_hub.CardData","sections":[],"depth":2},{"title":"Model Cards","local":"model-cards","sections":[{"title":"ModelCard","local":"huggingface_hub.ModelCard","sections":[],"depth":3},{"title":"ModelCardData","local":"huggingface_hub.ModelCardData","sections":[],"depth":3}],"depth":2},{"title":"Dataset Cards","local":"dataset-cards","sections":[{"title":"DatasetCard","local":"huggingface_hub.DatasetCard","sections":[],"depth":3},{"title":"DatasetCardData","local":"huggingface_hub.DatasetCardData","sections":[],"depth":3}],"depth":2},{"title":"Space Cards","local":"space-cards","sections":[{"title":"SpaceCard","local":"huggingface_hub.SpaceCard","sections":[],"depth":3},{"title":"SpaceCardData","local":"huggingface_hub.SpaceCardData","sections":[],"depth":3}],"depth":2},{"title":"Utilities","local":"utilities","sections":[{"title":"EvalResult","local":"huggingface_hub.EvalResult","sections":[],"depth":3},{"title":"model_index_to_eval_results","local":"huggingface_hub.repocard_data.model_index_to_eval_results","sections":[],"depth":3},{"title":"eval_results_to_model_index","local":"huggingface_hub.repocard_data.eval_results_to_model_index","sections":[],"depth":3},{"title":"metadata_eval_result","local":"huggingface_hub.metadata_eval_result","sections":[],"depth":3},{"title":"metadata_update","local":"huggingface_hub.metadata_update","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pn(U){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends kn{constructor(n){super(),En(this,n,Pn,zn,Dn,{})}}export{ol as component};
