class CustomTestimonials extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: 'open' });
    this.shadowRoot.innerHTML = `
      <style>
        :host {
          display: block;
          margin: 2rem 0;
        }
        .testimonials-container {
          display: grid;
          grid-template-columns: 1fr;
          gap: 1.5rem;
        }
        .testimonial-card {
          background: white;
          padding: 1.5rem;
          border-radius: 0.5rem;
          box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .testimonial-header {
          display: flex;
          align-items: center;
          margin-bottom: 1rem;
        }
        .testimonial-avatar {
          width: 3rem;
          height: 3rem;
          border-radius: 50%;
          object-fit: cover;
          margin-left: 1rem;
        }
        .testimonial-name {
          font-weight: 600;
        }
        .testimonial-title {
          color: #6b7280;
          font-size: 0.875rem;
        }
        .testimonial-text {
          color: #4b5563;
          line-height: 1.6;
        }
        @media (min-width: 768px) {
          .testimonials-container {
            grid-template-columns: repeat(2, 1fr);
          }
        }
      </style>
      <div class="testimonials-container">
        <div class="testimonial-card">
          <div class="testimonial-header">
            <img src="http://static.photos/people/200x200/1" alt="الطالب" class="testimonial-avatar">
            <div>
              <h4 class="testimonial-name">أحمد محمد</h4>
              <p class="testimonial-title">طالب علوم حاسوب</p>
              <div class="flex mt-1">
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
              </div>
            </div>
          </div>
          <p class="testimonial-text">"الدورات المقدمة ممتازة وساعدتني في تطوير مهاراتي البرمجية بشكل كبير. المحتوى يتم تحديثه بانتظام مع أحدث التقنيات."</p>
          <p class="text-xs text-gray-500 mt-2">تمت المراجعة منذ 3 أيام</p>
        </div>
        <div class="testimonial-card">
          <div class="testimonial-header">
            <img src="http://static.photos/people/200x200/2" alt="الطالبة" class="testimonial-avatar">
            <div>
              <h4 class="testimonial-name">سارة عبدالله</h4>
              <p class="testimonial-title">طالبة تصميم جرافيك</p>
              <div class="flex mt-1">
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
                <i data-feather="star" class="text-yellow-400 w-4 h-4"></i>
              </div>
            </div>
          </div>
          <p class="testimonial-text">"المحتوى غني ومتنوع، والمدربين محترفين جداً. أنصح الجميع بالتسجيل. فريق الدعم الفني سريع الاستجابة."</p>
          <p class="text-xs text-gray-500 mt-2">تمت المراجعة منذ أسبوع</p>
        </div>
      </div>
`;
  }
}

customElements.define('custom-testimonials', CustomTestimonials);